/*
 * Decompiled with CFR 0.152.
 */
package ACN_1_17_Package;

import ACN_1_17_Package.ACNDataPackage;
import ACN_1_17_Package.ACN_RootLayer;
import ACN_1_31_Package.ACN_1_31_DMPLayer;
import ACN_1_31_Package.ACN_1_31_FrameLayer;
import ACN_1_31_Package.ProtocolConfiguration_ACN_1_31;
import NetworkTools.UDP_Transport_Multicast;
import ProtocolPackage.Protocols;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;

public class ACNSender
implements UDP_Transport_Multicast.UDPTransportListener {
    public static int UDP_DATAGRAM_SIZE = 1472;
    protected ACN_RootLayer m_ACN_RootLayer_Actual;
    protected UDP_Transport_Multicast m_UDP_Transport;
    protected ProtocolConfiguration_ACN_1_31 m_ProtocolConfiguration_ACN_1_31;
    protected int m_SequenceNumber;
    protected ArrayList<ACNDataPackage> m_DataPackages;
    protected String m_UsedProtocol;
    protected boolean m_IsActive;
    protected InetAddress m_LastRemoteAddress;
    protected final Object m_SyncUDPTransport = new Object();
    protected final Object m_SyncPackages = new Object();

    public ACNSender(ProtocolConfiguration_ACN_1_31 p_ProtocolConfiguration_ACN_1_31) {
        this.initMembers();
        this.m_ProtocolConfiguration_ACN_1_31 = p_ProtocolConfiguration_ACN_1_31;
        this.m_IsActive = true;
    }

    private void initMembers() {
        this.m_ACN_RootLayer_Actual = null;
        this.m_UDP_Transport = null;
        this.m_SequenceNumber = 0;
        this.m_DataPackages = new ArrayList();
        this.m_LastRemoteAddress = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<ACNDataPackage> o_DataPackages;
        this.m_IsActive = false;
        this.setUDP_Transport(null);
        Object object = this.m_SyncPackages;
        synchronized (object) {
            if (this.m_DataPackages == null) {
                return;
            }
            if (this.m_DataPackages.size() <= 0) {
                return;
            }
            o_DataPackages = new ArrayList<ACNDataPackage>(this.m_DataPackages.size());
            o_DataPackages.addAll(this.m_DataPackages);
            this.m_DataPackages.clear();
        }
        for (int intPackage = o_DataPackages.size() - 1; intPackage >= 0; --intPackage) {
            ACNDataPackage o_DataPackage = (ACNDataPackage)o_DataPackages.get(intPackage);
            o_DataPackage.close();
        }
        o_DataPackages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUDP_Transport(UDP_Transport_Multicast p_UDP_Transport) {
        UDP_Transport_Multicast o_UDP_Transport;
        Object object = this.m_SyncUDPTransport;
        synchronized (object) {
            o_UDP_Transport = this.m_UDP_Transport;
        }
        if (o_UDP_Transport != null) {
            o_UDP_Transport.removeUDPTransportListener((UDP_Transport_Multicast.UDPTransportListener)this);
        }
        object = this.m_SyncUDPTransport;
        synchronized (object) {
            o_UDP_Transport = this.m_UDP_Transport = p_UDP_Transport;
        }
        if (o_UDP_Transport != null) {
            o_UDP_Transport.addUDPTransportListener((UDP_Transport_Multicast.UDPTransportListener)this);
        }
    }

    public void setActive(boolean p_Active) {
        this.m_IsActive = p_Active;
    }

    public boolean isActive() {
        return this.m_IsActive;
    }

    public void changeProtocol(String p_Protocol) {
        this.m_UsedProtocol = p_Protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(ACNDataPackage p_DataPackage, InetAddress p_InetAddress, int p_Port) {
        UDP_Transport_Multicast o_UDP_Transport;
        if (p_DataPackage == null) {
            return false;
        }
        byte[] o_DataArray = null;
        boolean boolSended = false;
        Object object = this.m_SyncPackages;
        synchronized (object) {
            if (this.m_DataPackages.contains(p_DataPackage)) {
                return false;
            }
            this.m_DataPackages.add(p_DataPackage);
        }
        Object object2 = this.m_SyncUDPTransport;
        synchronized (object2) {
            o_UDP_Transport = this.m_UDP_Transport;
        }
        p_DataPackage.resetFilled();
        o_DataArray = p_DataPackage.createByteArray();
        if (o_UDP_Transport != null && o_DataArray != null) {
            boolSended = o_UDP_Transport.send(o_DataArray, o_DataArray.length, p_InetAddress, p_Port);
        }
        object2 = this.m_SyncPackages;
        synchronized (object2) {
            this.m_DataPackages.remove(p_DataPackage);
        }
        p_DataPackage.close();
        return boolSended;
    }

    public void eventDataReceived(UDP_Transport_Multicast p_UDP_Transport, DatagramPacket p_DatagramPacket, InetSocketAddress p_ReceiverInetSocketAddress) {
    }

    public void eventClosed(UDP_Transport_Multicast p_UDP_Transport) {
        if (this.m_UDP_Transport == p_UDP_Transport) {
            this.setUDP_Transport(null);
        }
    }

    public void eventBound(UDP_Transport_Multicast p_UDP_Transport) {
    }

    public void eventError(UDP_Transport_Multicast p_UDP_Transport, Exception p_Exception) {
    }

    public boolean sendRefresh(int p_DMXUniverseNumber, int[] p_AllValues, int p_ProtocolType) {
        if (this.m_LastRemoteAddress == null) {
            return false;
        }
        this.sendDMXUniverseValues(this.m_LastRemoteAddress, p_DMXUniverseNumber, null, p_AllValues, p_ProtocolType);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sendDMXUniverseValues(InetAddress p_RemoteInetAddress, int p_DMXUniverseNumber, ArrayList<Integer> p_ChangedAddresses, int[] p_AllValues, int p_ProtocolType) {
        int intAddressCount;
        if (p_RemoteInetAddress == null) {
            return false;
        }
        if (p_AllValues == null) {
            return false;
        }
        if (p_AllValues.length <= 0) {
            return false;
        }
        if (!this.m_IsActive) {
            return false;
        }
        int intHighestAddress = -1;
        int intLowestAddress = -1;
        boolean boolSended = false;
        if (4 != p_ProtocolType && 3 != p_ProtocolType) {
            return false;
        }
        if (p_DMXUniverseNumber < 0) {
            return false;
        }
        if (p_ChangedAddresses != null) {
            intAddressCount = p_ChangedAddresses.size();
            if (intAddressCount <= 0) return true;
            intHighestAddress = p_ChangedAddresses.get(p_ChangedAddresses.size() - 1);
            intLowestAddress = p_ChangedAddresses.get(0);
            intAddressCount = intHighestAddress - intLowestAddress + 1;
        } else {
            intAddressCount = p_AllValues.length;
            intHighestAddress = p_AllValues.length - 1;
            intLowestAddress = 0;
        }
        if (3 != p_ProtocolType) return true;
        if (this.m_ProtocolConfiguration_ACN_1_31 == null) {
            return false;
        }
        ACN_1_31_DMPLayer.ACN_1_31_DMP o_Acn_1_31_dmp = new ACN_1_31_DMPLayer.ACN_1_31_DMP();
        intAddressCount = p_AllValues.length;
        intHighestAddress = p_AllValues.length - 1;
        intLowestAddress = 0;
        int[] intValues = new int[intAddressCount];
        try {
            System.arraycopy(p_AllValues, intLowestAddress, intValues, 0, intAddressCount);
        }
        catch (Exception e) {
            return false;
        }
        o_Acn_1_31_dmp.setPropertyValueCount(intAddressCount);
        o_Acn_1_31_dmp.setStartCode(intLowestAddress);
        o_Acn_1_31_dmp.setPropertyValues(intValues);
        ACN_1_31_FrameLayer.ACN_1_31_Frame o_ACN_1_31_Frame = new ACN_1_31_FrameLayer.ACN_1_31_Frame();
        o_ACN_1_31_Frame.setUniverseNumber(p_DMXUniverseNumber);
        o_ACN_1_31_Frame.setSequenceNumber(this.m_SequenceNumber);
        o_ACN_1_31_Frame.addACNData(o_Acn_1_31_dmp);
        ACN_RootLayer.ACN_Root o_ACN_Root = new ACN_RootLayer.ACN_Root();
        o_ACN_Root.getACN_PDU().getPDU_Vector().setInt(4);
        o_ACN_Root.getACN_PDU().getPDU_Header().getHeaderContent().setByteArray(this.m_ProtocolConfiguration_ACN_1_31.getLocalUUID(), 0, 0, 16);
        o_ACN_Root.addACNData(o_ACN_1_31_Frame);
        ACNDataPackage o_DataPackage = new ACNDataPackage();
        o_DataPackage.addACNRoot(o_ACN_Root);
        boolSended = this.send(o_DataPackage, p_RemoteInetAddress, Protocols.ACN_1_31_PORT);
        o_DataPackage.close();
        if (!boolSended) return true;
        this.m_LastRemoteAddress = p_RemoteInetAddress;
        ++this.m_SequenceNumber;
        if (this.m_SequenceNumber <= 255) return true;
        this.m_SequenceNumber = 0;
        return true;
    }
}

