/*
 * Decompiled with CFR 0.152.
 */
package ACN_1_17_Package;

import ACN_1_17_Package.ACNData_Interface;
import ACN_1_17_Package.ACNLayer_Interface;
import ACN_1_17_Package.ACN_ByteData;
import ACN_1_17_Package.ACN_PDU;
import ACN_1_17_Package.ACN_RootLayer;
import java.util.ArrayList;

public abstract class ACNDataAbstract
implements ACNData_Interface,
ACN_ByteData.ACN_ByteDataListener {
    protected ACNData_Interface m_ParentACNData;
    protected ACNLayer_Interface m_ACNLayer;
    protected ACN_PDU m_ACN_PDU;
    protected ACNLayer_Interface m_NextACNLayer;
    protected ArrayList<ACN_ByteData> m_DataACN_Members;
    protected ACN_PDU m_ReceivingACN_PDU;
    protected boolean m_IsReceived;
    protected boolean m_HasRecivedData;
    protected boolean m_IsFilled;
    protected boolean m_HasFilledData;
    protected boolean m_IsDiscarded;
    protected boolean m_IsClosed;
    protected boolean m_HasError;
    protected ArrayList<ACNData_Interface> m_DataObjects;

    public ACNDataAbstract(ACNData_Interface p_ParentACNData, ACNLayer_Interface p_ACNLayer_Interface, ACN_PDU p_ACN_PDU) {
        this.initMembers();
        this.m_ParentACNData = p_ParentACNData;
        this.m_ACNLayer = p_ACNLayer_Interface;
        this.m_ACN_PDU = p_ACN_PDU == null ? new ACN_PDU(this.m_ACNLayer, this) : p_ACN_PDU;
    }

    private void initMembers() {
        this.m_IsClosed = false;
        this.m_IsReceived = false;
        this.m_HasRecivedData = false;
        this.m_ReceivingACN_PDU = null;
        this.m_IsFilled = false;
        this.m_HasFilledData = false;
        this.m_IsDiscarded = false;
        this.m_DataACN_Members = new ArrayList();
        this.m_DataObjects = new ArrayList();
        this.m_HasError = false;
    }

    @Override
    public void close() {
        if (this.m_IsClosed) {
            return;
        }
        this.m_IsClosed = true;
        for (int intMember = this.m_DataACN_Members.size() - 1; intMember >= 0; --intMember) {
            ACN_ByteData o_DataACN_Member = this.m_DataACN_Members.get(intMember);
            o_DataACN_Member.removeListener(this);
            this.m_DataACN_Members.remove(o_DataACN_Member);
            o_DataACN_Member.close();
        }
        for (int intDataObject = this.m_DataObjects.size() - 1; intDataObject >= 0; --intDataObject) {
            ACNData_Interface o_ACNData_Interface = this.m_DataObjects.get(intDataObject);
            o_ACNData_Interface.close();
            this.m_DataObjects.remove(o_ACNData_Interface);
        }
        if (this.m_ACN_PDU != null) {
            this.m_ACN_PDU.close();
        }
        this.m_DataACN_Members.clear();
        this.m_DataObjects.clear();
    }

    @Override
    public ACN_PDU getACN_PDU() {
        return this.m_ACN_PDU;
    }

    @Override
    public ACN_PDU getParentACN_PDU() {
        if (this.m_ParentACNData == null) {
            return null;
        }
        return this.m_ParentACNData.getACN_PDU();
    }

    @Override
    public ACN_PDU.PDU_Vector getPDUVectorHeritage(ACNData_Interface p_ACNData) {
        int intIndex = this.m_DataObjects.indexOf(p_ACNData);
        if (intIndex <= 0) {
            return null;
        }
        ACNData_Interface o_ACNData_Interface = this.m_DataObjects.get(intIndex - 1);
        if (o_ACNData_Interface == null) {
            return null;
        }
        return o_ACNData_Interface.getACN_PDU().getPDU_Vector();
    }

    @Override
    public ACN_PDU.PDU_Header getPDUHeaderHeritage(ACNData_Interface p_ACNData) {
        int intIndex = this.m_DataObjects.indexOf(p_ACNData);
        if (intIndex <= 0) {
            return null;
        }
        ACNData_Interface o_ACNData_Interface = this.m_DataObjects.get(intIndex - 1);
        if (o_ACNData_Interface == null) {
            return null;
        }
        return o_ACNData_Interface.getACN_PDU().getPDU_Header();
    }

    @Override
    public ACNData_Interface getACNDataHeritage(ACNData_Interface p_ACNData) {
        int intIndex = this.m_DataObjects.indexOf(p_ACNData);
        if (intIndex <= 0) {
            return null;
        }
        ACNData_Interface o_ACNData_Interface = this.m_DataObjects.get(intIndex - 1);
        if (o_ACNData_Interface == null) {
            return null;
        }
        return o_ACNData_Interface.getACN_PDU().getACNData();
    }

    @Override
    public ACNLayer_Interface getACNLayer() {
        return this.m_ACNLayer;
    }

    @Override
    public void setParentACNData(ACNData_Interface p_ACNData_Interface) {
        if (this.m_ParentACNData == p_ACNData_Interface) {
            return;
        }
        if (this.m_ParentACNData != null) {
            this.m_ParentACNData.removeACNData(this);
        }
        this.m_ParentACNData = p_ACNData_Interface;
        if (this.m_ParentACNData != null) {
            this.m_ParentACNData.addACNData(this);
        }
    }

    @Override
    public ACNData_Interface getParentACNData() {
        return this.m_ParentACNData;
    }

    @Override
    public void setError(ACNData_Interface p_ACNData_Interface, ACN_PDU p_ACN_PDU, String p_ErrorCause) {
        this.m_HasError = true;
        if (this.m_ParentACNData != null) {
            this.m_ParentACNData.setError(p_ACNData_Interface, p_ACN_PDU, p_ErrorCause);
        } else if (this.m_ACNLayer != null) {
            this.setError(p_ACNData_Interface, p_ACN_PDU, p_ErrorCause);
        } else {
            String stringACNData_Interface = "";
            String stringACN_PDU = "";
            if (p_ACNData_Interface != null) {
                stringACNData_Interface = p_ACNData_Interface.getClass().getSimpleName();
            }
            if (p_ACN_PDU != null) {
                stringACN_PDU = p_ACN_PDU.getClass().getSimpleName();
            }
            System.out.println(" Error: " + stringACN_PDU + " " + stringACNData_Interface + " " + p_ErrorCause);
        }
    }

    @Override
    public void setDiscarded(boolean p_Discarded) {
        if (this.m_IsDiscarded == p_Discarded) {
            return;
        }
        this.m_IsDiscarded = p_Discarded;
        this.m_ACN_PDU.setDiscarded(p_Discarded);
        for (int intObject = 0; intObject < this.m_DataObjects.size(); ++intObject) {
            ACNData_Interface o_ACNData_Interface = this.m_DataObjects.get(intObject);
            o_ACNData_Interface.getACN_PDU().setDiscarded(p_Discarded);
        }
    }

    public boolean isDiscarded() {
        return this.m_IsDiscarded;
    }

    @Override
    public ACNLayer_Interface createNextACNLayer() {
        if (this.m_NextACNLayer != null) {
            return this.m_NextACNLayer;
        }
        ACN_PDU.PDU_Vector o_PDU_Vector = this.m_ACN_PDU.getPDU_Vector();
        ACN_PDU.PDU_Header o_PDU_Header = this.m_ACN_PDU.getPDU_Header();
        this.m_NextACNLayer = this.createNextACNLayer(o_PDU_Vector, o_PDU_Header);
        return this.m_NextACNLayer;
    }

    public abstract ACNLayer_Interface createNextACNLayer(ACN_PDU.PDU_Vector var1, ACN_PDU.PDU_Header var2);

    public void addDataACN_Member(ACN_ByteData p_ACN_ByteData) {
        if (p_ACN_ByteData == null) {
            return;
        }
        if (this.m_DataACN_Members.contains(p_ACN_ByteData)) {
            return;
        }
        this.m_DataACN_Members.add(p_ACN_ByteData);
        p_ACN_ByteData.addListener(this);
    }

    public void removeDataACN_Member(ACN_ByteData p_ACN_ByteData) {
        if (p_ACN_ByteData == null) {
            return;
        }
        this.m_DataACN_Members.remove(p_ACN_ByteData);
        p_ACN_ByteData.removeListener(this);
    }

    @Override
    public void addACNData(ACNData_Interface p_ACNData_Interface) {
        if (p_ACNData_Interface == null) {
            return;
        }
        if (this.m_DataObjects.contains(p_ACNData_Interface)) {
            return;
        }
        this.m_DataObjects.add(p_ACNData_Interface);
        p_ACNData_Interface.setParentACNData(this);
    }

    @Override
    public void removeACNData(ACNData_Interface p_ACNData_Interface) {
        if (p_ACNData_Interface == null) {
            return;
        }
        if (!this.m_DataObjects.contains(p_ACNData_Interface)) {
            return;
        }
        this.m_DataObjects.remove(p_ACNData_Interface);
    }

    public int getACNDataObjectCount() {
        return this.m_DataObjects.size();
    }

    public ACNData_Interface getACNDataObject(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_DataObjects.size()) {
            return null;
        }
        return this.m_DataObjects.get(p_Index);
    }

    @Override
    public int calculateSize() {
        int intSize = 0;
        for (int intMember = 0; intMember < this.m_DataACN_Members.size(); ++intMember) {
            ACN_ByteData o_ACN_ByteData = this.m_DataACN_Members.get(intMember);
            intSize += o_ACN_ByteData.getSize();
        }
        for (int intDataObject = 0; intDataObject < this.m_DataObjects.size(); ++intDataObject) {
            intSize += this.m_DataObjects.get(intDataObject).getACN_PDU().calculateSize();
        }
        return intSize;
    }

    @Override
    public void resetReceive() {
        this.m_HasError = false;
        if (!this.m_HasRecivedData) {
            return;
        }
        this.m_HasRecivedData = false;
        this.m_ReceivingACN_PDU = null;
        this.m_IsReceived = false;
        for (int intMember = 0; intMember < this.m_DataACN_Members.size(); ++intMember) {
            ACN_ByteData o_ACN_ByteData = this.m_DataACN_Members.get(intMember);
            o_ACN_ByteData.resetReceive();
        }
        for (int intObject = 0; intObject < this.m_DataObjects.size(); ++intObject) {
            ACNData_Interface o_ACNData_Interface = this.m_DataObjects.get(intObject);
            o_ACNData_Interface.getACN_PDU().resetReceive();
        }
        this.m_ACN_PDU.resetReceive();
    }

    @Override
    public boolean isReceived() {
        return this.m_IsReceived;
    }

    @Override
    public int eventDataReceived(byte[] p_Data, int p_Offset, int p_Length, int p_Position) {
        this.m_HasRecivedData = true;
        if (this.m_IsReceived) {
            return p_Offset;
        }
        int intNewOffset = p_Offset;
        int intNewPosition = p_Position;
        int intInternalPosition = intNewPosition - this.m_ACN_PDU.getStartPosition();
        for (int intMember = 0; intMember < this.m_DataACN_Members.size(); ++intMember) {
            ACN_ByteData o_ACN_ByteData = this.m_DataACN_Members.get(intMember);
            if (o_ACN_ByteData.isReceived()) continue;
            intNewOffset = o_ACN_ByteData.eventDataReceived(p_Data, intNewOffset, p_Length);
            if (!o_ACN_ByteData.isReceived()) {
                return intNewOffset;
            }
            intNewPosition = p_Position + intNewOffset - p_Offset;
            this.eventDataMemberReceived(this, o_ACN_ByteData);
        }
        intInternalPosition = intNewPosition - this.m_ACN_PDU.getStartPosition();
        while (intInternalPosition < this.m_ACN_PDU.getSize()) {
            this.createNextACNLayer();
            if (this.m_ReceivingACN_PDU == null) {
                this.m_ReceivingACN_PDU = new ACN_PDU(intNewPosition, this, this.m_NextACNLayer);
            }
            if (this.m_ReceivingACN_PDU.isReceived()) {
                this.m_ReceivingACN_PDU = new ACN_PDU(intNewPosition, this, this.m_NextACNLayer);
            }
            intNewOffset = this.m_ReceivingACN_PDU.eventDataReceived(p_Data, intNewOffset, p_Length, intNewPosition);
            intNewPosition = p_Position + intNewOffset - p_Offset;
            if (!this.m_ReceivingACN_PDU.isReceived()) {
                return intNewOffset;
            }
            this.m_DataObjects.add(this.m_ReceivingACN_PDU.getACNData());
            intInternalPosition = intNewPosition - this.m_ACN_PDU.getStartPosition();
        }
        if (intInternalPosition > this.m_ACN_PDU.getSize()) {
            this.setError(this, this.m_ACN_PDU, ACN_RootLayer.ERRORSTRING_WRONGPDUSIZE);
        }
        this.m_IsReceived = true;
        this.eventDataReceived(this);
        return intNewOffset;
    }

    public abstract void eventDataReceived(ACNData_Interface var1);

    public abstract void eventDataMemberReceived(ACNData_Interface var1, ACN_ByteData var2);

    @Override
    public boolean isFilled() {
        return this.m_IsFilled;
    }

    @Override
    public void resetFilled() {
        this.m_HasError = false;
        if (!this.m_HasFilledData) {
            return;
        }
        this.m_HasFilledData = false;
        this.m_IsFilled = false;
        for (int intMember = 0; intMember < this.m_DataACN_Members.size(); ++intMember) {
            ACN_ByteData o_ACN_ByteData = this.m_DataACN_Members.get(intMember);
            o_ACN_ByteData.resetFilled();
        }
        for (int intObject = 0; intObject < this.m_DataObjects.size(); ++intObject) {
            ACNData_Interface o_ACNData_Interface = this.m_DataObjects.get(intObject);
            o_ACNData_Interface.getACN_PDU().resetFilled();
        }
        this.m_ACN_PDU.resetFilled();
    }

    @Override
    public int fillByteArray(byte[] p_ByteArray, int p_Offset, int p_Position) {
        this.m_HasFilledData = true;
        if (this.m_IsFilled) {
            return p_Offset;
        }
        int intNewOffset = p_Offset;
        int intNewPosition = p_Position;
        for (int intMember = 0; intMember < this.m_DataACN_Members.size(); ++intMember) {
            ACN_ByteData o_ACN_ByteData = this.m_DataACN_Members.get(intMember);
            if (o_ACN_ByteData.isFilled()) continue;
            intNewOffset = o_ACN_ByteData.fillByteArray(p_ByteArray, intNewOffset);
            if (!o_ACN_ByteData.isFilled()) {
                return intNewOffset;
            }
            intNewPosition = p_Position + intNewOffset - p_Offset;
            this.eventDataMemberFilled(this, o_ACN_ByteData);
        }
        for (int intDataObject = 0; intDataObject < this.m_DataObjects.size(); ++intDataObject) {
            ACNData_Interface o_ACNData_Interface = this.m_DataObjects.get(intDataObject);
            intNewOffset = o_ACNData_Interface.getACN_PDU().fillByteArray(p_ByteArray, intNewOffset, intNewPosition);
            if (!o_ACNData_Interface.getACN_PDU().isFilled()) {
                return intNewOffset;
            }
            intNewPosition = p_Position + intNewOffset - p_Offset;
        }
        this.m_IsFilled = true;
        this.eventDataFilled(this);
        return intNewOffset;
    }

    public abstract void eventDataFilled(ACNData_Interface var1);

    public abstract void eventDataMemberFilled(ACNData_Interface var1, ACN_ByteData var2);

    @Override
    public void eventChanged(ACN_ByteData p_ACN_ByteData) {
        this.eventDataMemberChanged(this, p_ACN_ByteData);
    }

    public abstract void eventDataMemberChanged(ACNData_Interface var1, ACN_ByteData var2);
}

