/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import DMXHardwarePackage.LAN_Device;
import DMXHardwarePackage.LAN_Device_ArtNet;
import DMXHardwarePackage.LAN_Device_Configuration_PlugInPanel;
import DMXHardwarePackage.LAN_Interface_Configuration;
import DMXHardwarePackage.LAN_PlugIn;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import ToolPackage.DocumentFilter_Integer;
import ToolPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LAN_Device_Configuration_BindPanel
extends JPanel
implements PropertyChangeListener {
    private LAN_Device m_LAN_Device;
    private int m_BindIndex;
    private GridBagConstraints m_GridBagConstraints;
    private HashMap<LAN_PlugIn, LAN_Device_Configuration_PlugInPanel> m_PlugInPanels;
    private Runnable m_Runnable_RefreshGUI;
    private final Object m_SyncLanPlugIn = new Object();
    private Byte m_New_NetSwitch;
    private Byte m_New_SubNet;
    private String m_New_ShortName = "";
    private String m_New_LongName = "";
    private JLabel jLabel_BindIndex;
    private JLabel jLabel_BindIndex_Content;
    private JLabel jLabel_LongName;
    private JLabel jLabel_NetSwitch;
    private JLabel jLabel_ShortName;
    private JLabel jLabel_SubSwitch;
    private JPanel jPanel_LAN_PlugIns;
    private JTextField jTextField_LongName;
    private JTextField jTextField_NetSwitch;
    private JTextField jTextField_ShortName;
    private JTextField jTextField_SubSwitch;

    public LAN_Device_Configuration_BindPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener(this, LAN_Interface_Configuration.class.getSimpleName());
    }

    private void initMembers() {
        this.m_LAN_Device = null;
        this.m_PlugInPanels = new HashMap();
        this.m_GridBagConstraints = new GridBagConstraints();
        this.m_GridBagConstraints.gridx = 0;
        this.m_GridBagConstraints.gridy = 0;
        this.m_GridBagConstraints.fill = 2;
        this.m_GridBagConstraints.weightx = 1.0;
        this.m_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.m_Runnable_RefreshGUI = new Runnable(){

            @Override
            public void run() {
                LAN_Device_Configuration_BindPanel.this.refreshGUI();
            }
        };
    }

    private void initComponents() {
        this.jLabel_NetSwitch = new JLabel();
        this.jTextField_NetSwitch = new JTextField();
        this.jLabel_SubSwitch = new JLabel();
        this.jTextField_SubSwitch = new JTextField();
        this.jLabel_BindIndex = new JLabel();
        this.jLabel_BindIndex_Content = new JLabel();
        this.jPanel_LAN_PlugIns = new JPanel();
        this.jLabel_ShortName = new JLabel();
        this.jTextField_ShortName = new JTextField();
        this.jLabel_LongName = new JLabel();
        this.jTextField_LongName = new JTextField();
        this.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.setMinimumSize(new Dimension(115, 110));
        this.setLayout(new GridBagLayout());
        this.jLabel_NetSwitch.setHorizontalAlignment(4);
        this.jLabel_NetSwitch.setText("Universe NetSwitch:");
        this.jLabel_NetSwitch.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_NetSwitch, gridBagConstraints);
        this.jTextField_NetSwitch.setHorizontalAlignment(0);
        this.jTextField_NetSwitch.setText("jTextField1");
        this.jTextField_NetSwitch.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LAN_Device_Configuration_BindPanel.this.jTextField_NetSwitchFocusLost(evt);
            }
        });
        this.jTextField_NetSwitch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LAN_Device_Configuration_BindPanel.this.jTextField_NetSwitchKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_NetSwitch, gridBagConstraints);
        this.jLabel_SubSwitch.setHorizontalAlignment(4);
        this.jLabel_SubSwitch.setText("Universe SubNet:");
        this.jLabel_SubSwitch.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_SubSwitch, gridBagConstraints);
        this.jTextField_SubSwitch.setHorizontalAlignment(0);
        this.jTextField_SubSwitch.setText("jTextField1");
        this.jTextField_SubSwitch.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LAN_Device_Configuration_BindPanel.this.jTextField_SubSwitchFocusLost(evt);
            }
        });
        this.jTextField_SubSwitch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LAN_Device_Configuration_BindPanel.this.jTextField_SubSwitchKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_SubSwitch, gridBagConstraints);
        this.jLabel_BindIndex.setHorizontalAlignment(4);
        this.jLabel_BindIndex.setText("BindIndex:");
        this.jLabel_BindIndex.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_BindIndex, gridBagConstraints);
        this.jLabel_BindIndex_Content.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_BindIndex_Content.setHorizontalAlignment(0);
        this.jLabel_BindIndex_Content.setText("1");
        this.jLabel_BindIndex_Content.setToolTipText("");
        this.jLabel_BindIndex_Content.setMaximumSize(new Dimension(6, 20));
        this.jLabel_BindIndex_Content.setMinimumSize(new Dimension(6, 20));
        this.jLabel_BindIndex_Content.setPreferredSize(new Dimension(6, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_BindIndex_Content, gridBagConstraints);
        this.jPanel_LAN_PlugIns.setMinimumSize(new Dimension(100, 10));
        this.jPanel_LAN_PlugIns.setPreferredSize(new Dimension(100, 30));
        this.jPanel_LAN_PlugIns.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel_LAN_PlugIns, gridBagConstraints);
        this.jLabel_ShortName.setHorizontalAlignment(4);
        this.jLabel_ShortName.setText("ShortName:");
        this.jLabel_ShortName.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_ShortName, gridBagConstraints);
        this.jTextField_ShortName.setHorizontalAlignment(0);
        this.jTextField_ShortName.setText("jTextField1");
        this.jTextField_ShortName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LAN_Device_Configuration_BindPanel.this.jTextField_ShortNameFocusLost(evt);
            }
        });
        this.jTextField_ShortName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LAN_Device_Configuration_BindPanel.this.jTextField_ShortNameKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_ShortName, gridBagConstraints);
        this.jLabel_LongName.setHorizontalAlignment(4);
        this.jLabel_LongName.setText("LongName:");
        this.jLabel_LongName.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_LongName, gridBagConstraints);
        this.jTextField_LongName.setHorizontalAlignment(0);
        this.jTextField_LongName.setText("jTextField1");
        this.jTextField_LongName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LAN_Device_Configuration_BindPanel.this.jTextField_LongNameFocusLost(evt);
            }
        });
        this.jTextField_LongName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LAN_Device_Configuration_BindPanel.this.jTextField_LongNameKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_LongName, gridBagConstraints);
    }

    private void initComponentsFurther() {
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer(this.jTextField_NetSwitch);
        o_DocumentFilter_Integer.setAllowNegativeNumbers(false);
        o_DocumentFilter_Integer = new DocumentFilter_Integer(this.jTextField_SubSwitch);
        o_DocumentFilter_Integer.setAllowNegativeNumbers(false);
        this.jTextField_ShortName.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_LongName.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_NetSwitch.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_SubSwitch.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jLabel_BindIndex.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    private void jTextField_NetSwitchFocusLost(FocusEvent evt) {
        this.checkNetSwitch();
    }

    private void jTextField_NetSwitchKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.checkNetSwitch();
        }
    }

    private int checkNetSwitch() {
        int intNetSwitch;
        LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device != null && o_LAN_Device instanceof LAN_Device_ArtNet) {
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        }
        if (o_LAN_Device_ArtNet == null) {
            return -1;
        }
        try {
            intNetSwitch = Integer.valueOf(this.jTextField_NetSwitch.getText());
            if (intNetSwitch < 0) {
                intNetSwitch = 0;
            }
            if (intNetSwitch > 127) {
                intNetSwitch = 127;
            }
        }
        catch (Exception e) {
            LAN_Device_ArtNet.BindIndexStructure o_BindIndexStructure = o_LAN_Device_ArtNet.getBindIndexStructure(this.m_BindIndex);
            if (o_BindIndexStructure != null) {
                Byte byteNetSwitch = o_BindIndexStructure.getUniverseNetSwitch();
                if (byteNetSwitch == null) {
                    byteNetSwitch = 0;
                }
                intNetSwitch = byteNetSwitch & 0xFF;
            }
            intNetSwitch = 0;
        }
        this.jTextField_NetSwitch.setText(String.valueOf(intNetSwitch));
        this.refreshPlugInPanels();
        return intNetSwitch;
    }

    public int getNew_NetSwitchFromText() {
        int intNetSwitch = -1;
        try {
            intNetSwitch = Integer.valueOf(this.jTextField_NetSwitch.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return intNetSwitch;
    }

    private void jTextField_SubSwitchFocusLost(FocusEvent evt) {
        this.checkSubSwitch();
    }

    private void jTextField_SubSwitchKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.checkSubSwitch();
        }
    }

    private void jTextField_ShortNameFocusLost(FocusEvent evt) {
    }

    private void jTextField_ShortNameKeyPressed(KeyEvent evt) {
    }

    private void jTextField_LongNameFocusLost(FocusEvent evt) {
    }

    private void jTextField_LongNameKeyPressed(KeyEvent evt) {
    }

    private int checkSubSwitch() {
        int intSubSwitch;
        LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device != null && o_LAN_Device instanceof LAN_Device_ArtNet) {
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        }
        if (o_LAN_Device_ArtNet == null) {
            return -1;
        }
        try {
            intSubSwitch = Integer.valueOf(this.jTextField_SubSwitch.getText());
            if (intSubSwitch < 0) {
                intSubSwitch = 0;
            }
            if (intSubSwitch > 15) {
                intSubSwitch = 15;
            }
        }
        catch (Exception e) {
            LAN_Device_ArtNet.BindIndexStructure o_BindIndexStructure = o_LAN_Device_ArtNet.getBindIndexStructure(this.m_BindIndex);
            Byte byteSubSwitch = o_BindIndexStructure != null ? Byte.valueOf(o_BindIndexStructure.getUniverseSubSwitch()) : Byte.valueOf((byte)0);
            intSubSwitch = byteSubSwitch & 0xFF;
        }
        this.jTextField_SubSwitch.setText(String.valueOf(intSubSwitch));
        this.refreshPlugInPanels();
        return intSubSwitch;
    }

    public int getNew_SubNetFromText() {
        int intSubSwitch = -1;
        try {
            intSubSwitch = Integer.valueOf(this.jTextField_SubSwitch.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return intSubSwitch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.jTextField_ShortName.setComponentPopupMenu(null);
        this.jTextField_LongName.setComponentPopupMenu(null);
        this.jTextField_NetSwitch.setComponentPopupMenu(null);
        this.jTextField_SubSwitch.setComponentPopupMenu(null);
        this.jLabel_BindIndex.setComponentPopupMenu(null);
        if (this.m_LAN_Device != null) {
            this.m_LAN_Device.removePropertyChangeListener(this);
        }
        Object object = this.m_SyncLanPlugIn;
        synchronized (object) {
            Iterator<LAN_PlugIn> o_Iterator = this.m_PlugInPanels.keySet().iterator();
            while (o_Iterator.hasNext()) {
                LAN_Device_Configuration_PlugInPanel o_PlugInPanel;
                LAN_PlugIn o_LAN_PlugIn = o_Iterator.next();
                if (o_LAN_PlugIn == null || (o_PlugInPanel = this.m_PlugInPanels.get(o_LAN_PlugIn)) == null) continue;
                this.jPanel_LAN_PlugIns.remove(o_PlugInPanel);
                o_Iterator.remove();
                o_PlugInPanel.close();
            }
        }
        this.m_LAN_Device = null;
    }

    public GridBagConstraints getGridBagConstraints() {
        this.m_GridBagConstraints.gridy = this.m_BindIndex;
        return this.m_GridBagConstraints;
    }

    public void setLAN_Device(LAN_Device p_LAN_Device, int p_BindIndex) {
        if (this.m_LAN_Device == p_LAN_Device) {
            return;
        }
        if (this.m_LAN_Device != null) {
            this.m_LAN_Device.removePropertyChangeListener(this);
        }
        this.m_LAN_Device = p_LAN_Device;
        if (this.m_LAN_Device != null) {
            this.m_LAN_Device.addPropertyChangeListener(this);
        }
        this.m_GridBagConstraints.gridy = this.m_BindIndex = p_BindIndex;
        EventQueue.invokeLater(this.m_Runnable_RefreshGUI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLAN_PlugIn(LAN_PlugIn p_LAN_PlugIn) {
        if (p_LAN_PlugIn == null) {
            return;
        }
        if (p_LAN_PlugIn.getBindIndex() != this.m_BindIndex) {
            return;
        }
        Object object = this.m_SyncLanPlugIn;
        synchronized (object) {
            LAN_Device_Configuration_PlugInPanel o_PlugInPanel = this.m_PlugInPanels.get(p_LAN_PlugIn);
            if (o_PlugInPanel == null) {
                p_LAN_PlugIn.addPropertyChangeListener(this);
                o_PlugInPanel = new LAN_Device_Configuration_PlugInPanel(this);
                this.m_PlugInPanels.put(p_LAN_PlugIn, o_PlugInPanel);
                o_PlugInPanel.setLAN_PlugIn(p_LAN_PlugIn);
                this.jPanel_LAN_PlugIns.add((Component)o_PlugInPanel, o_PlugInPanel.getGridBagConstraints());
                o_PlugInPanel.setVisible(true);
            }
        }
        EventQueue.invokeLater(this.m_Runnable_RefreshGUI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLAN_PlugIn(LAN_PlugIn p_LAN_PlugIn) {
        if (p_LAN_PlugIn == null) {
            return;
        }
        Object object = this.m_SyncLanPlugIn;
        synchronized (object) {
            p_LAN_PlugIn.removePropertyChangeListener(this);
            LAN_Device_Configuration_PlugInPanel o_PlugInPanel = this.m_PlugInPanels.get(p_LAN_PlugIn);
            if (o_PlugInPanel == null) {
                return;
            }
            o_PlugInPanel.setVisible(false);
            this.remove(o_PlugInPanel);
            this.m_PlugInPanels.remove(p_LAN_PlugIn);
            o_PlugInPanel.close();
        }
        EventQueue.invokeLater(this.m_Runnable_RefreshGUI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPlugInPanels() {
        LAN_Device_Configuration_PlugInPanel o_PlugInPanel;
        ArrayList<LAN_Device_Configuration_PlugInPanel> o_PlugInPanels;
        Object object = this.m_SyncLanPlugIn;
        synchronized (object) {
            Iterator<LAN_Device_Configuration_PlugInPanel> o_Iterator = this.m_PlugInPanels.values().iterator();
            o_PlugInPanels = new ArrayList<LAN_Device_Configuration_PlugInPanel>(this.m_PlugInPanels.size());
            while (o_Iterator.hasNext()) {
                o_PlugInPanel = o_Iterator.next();
                o_PlugInPanels.add(o_PlugInPanel);
            }
        }
        for (int intPluginPanel = 0; intPluginPanel < o_PlugInPanels.size(); ++intPluginPanel) {
            o_PlugInPanel = (LAN_Device_Configuration_PlugInPanel)o_PlugInPanels.get(intPluginPanel);
            o_PlugInPanel.refreshNewLANUniverseNumber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshGUI() {
        LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device instanceof LAN_Device_ArtNet) {
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        }
        GridBagLayout o_GridBagLayout = (GridBagLayout)this.getLayout();
        this.jLabel_BindIndex_Content.setText(String.valueOf(this.m_BindIndex));
        if (o_LAN_Device_ArtNet == null) {
            this.jLabel_ShortName.setVisible(false);
            this.jTextField_ShortName.setVisible(false);
            this.jLabel_LongName.setVisible(false);
            this.jTextField_LongName.setVisible(false);
            this.jLabel_NetSwitch.setVisible(false);
            this.jTextField_NetSwitch.setVisible(false);
            this.jTextField_NetSwitch.setText("0");
            this.jLabel_SubSwitch.setVisible(false);
            this.jTextField_SubSwitch.setVisible(false);
            this.jTextField_SubSwitch.setText("0");
            this.jLabel_BindIndex.setVisible(false);
            this.jLabel_BindIndex_Content.setVisible(false);
        } else {
            Byte byteSubSwitch;
            Byte byteNetSwitch;
            String stringLongName;
            String stringShortName;
            this.jLabel_LongName.setVisible(true);
            this.jTextField_LongName.setVisible(true);
            this.jLabel_ShortName.setVisible(true);
            this.jTextField_ShortName.setVisible(true);
            this.jLabel_NetSwitch.setVisible(true);
            this.jTextField_NetSwitch.setVisible(true);
            this.jLabel_SubSwitch.setVisible(true);
            this.jTextField_SubSwitch.setVisible(true);
            this.jLabel_BindIndex.setVisible(true);
            this.jLabel_BindIndex_Content.setVisible(true);
            LAN_Device_ArtNet.BindIndexStructure o_BindIndexStructure = o_LAN_Device_ArtNet.getBindIndexStructure(this.m_BindIndex);
            if (o_BindIndexStructure != null) {
                stringShortName = o_BindIndexStructure.getShortName();
                stringLongName = o_BindIndexStructure.getLongName();
                byteNetSwitch = o_BindIndexStructure.getUniverseNetSwitch();
                byteSubSwitch = o_BindIndexStructure.getUniverseSubSwitch();
            } else {
                stringShortName = "";
                stringLongName = "";
                byteNetSwitch = 0;
                byteSubSwitch = 0;
            }
            this.jTextField_ShortName.setText(stringShortName);
            this.jTextField_LongName.setText(stringLongName);
            this.jTextField_NetSwitch.setText(String.valueOf(byteNetSwitch & 0xFF));
            this.jTextField_SubSwitch.setText(String.valueOf(byteSubSwitch & 0xFF));
            if (o_BindIndexStructure == null || o_BindIndexStructure.getIsVirtual()) {
                this.jTextField_ShortName.setEnabled(false);
                this.jTextField_LongName.setEnabled(false);
                this.jTextField_NetSwitch.setEnabled(false);
                this.jTextField_SubSwitch.setEnabled(false);
            } else {
                this.jTextField_ShortName.setEnabled(true);
                this.jTextField_LongName.setEnabled(true);
                this.jTextField_NetSwitch.setEnabled(true);
                this.jTextField_SubSwitch.setEnabled(true);
            }
        }
        int intHeight = 0;
        Object object = this.m_SyncLanPlugIn;
        synchronized (object) {
            for (LAN_PlugIn o_LAN_PlugIn : this.m_PlugInPanels.keySet()) {
                LAN_Device_Configuration_PlugInPanel o_PlugInPanel = this.m_PlugInPanels.get(o_LAN_PlugIn);
                if (o_PlugInPanel == null) continue;
                GridBagConstraints o_GridBagConstraints = o_PlugInPanel.getGridBagConstraints();
                intHeight += o_PlugInPanel.getMinimumSize().height + o_GridBagConstraints.insets.top + o_GridBagConstraints.insets.bottom;
                o_GridBagLayout.setConstraints(o_PlugInPanel, o_PlugInPanel.getGridBagConstraints());
            }
        }
        this.jPanel_LAN_PlugIns.setMinimumSize(new Dimension(100, intHeight));
        this.jPanel_LAN_PlugIns.setPreferredSize(new Dimension(100, intHeight));
        intHeight += this.jLabel_BindIndex_Content.getPreferredSize().height;
        intHeight += this.jTextField_ShortName.getPreferredSize().height;
        intHeight += this.jTextField_NetSwitch.getPreferredSize().height;
        intHeight += this.jTextField_SubSwitch.getPreferredSize().height;
        this.setMinimumSize(new Dimension(0, intHeight += 26));
        this.jPanel_LAN_PlugIns.revalidate();
        this.jPanel_LAN_PlugIns.repaint();
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<LAN_PlugIn> getIterator_LAN_PlugIn() {
        Object object = this.m_SyncLanPlugIn;
        synchronized (object) {
            return this.m_PlugInPanels.keySet().iterator();
        }
    }

    public LAN_Device_Configuration_PlugInPanel getPlugInPanel(LAN_PlugIn p_LAN_PlugIn) {
        return this.m_PlugInPanels.get(p_LAN_PlugIn);
    }

    public void prepareSave_ArtNet() {
        int intValue;
        LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device != null && this.m_LAN_Device instanceof LAN_Device_ArtNet) {
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        }
        if (o_LAN_Device_ArtNet == null) {
            this.m_New_NetSwitch = 0;
            this.m_New_SubNet = 0;
            this.m_New_ShortName = "";
            return;
        }
        this.m_New_ShortName = this.jTextField_ShortName.getText();
        if (this.m_New_ShortName.length() > 17) {
            this.m_New_ShortName = this.m_New_ShortName.substring(0, 17);
        }
        this.m_New_LongName = this.jTextField_LongName.getText();
        if (this.m_New_LongName.length() > 63) {
            this.m_New_LongName = this.m_New_LongName.substring(0, 63);
        }
        try {
            intValue = Integer.valueOf(this.jTextField_NetSwitch.getText());
            if (intValue < 0) {
                intValue = 0;
            }
            if (intValue > 127) {
                intValue = 127;
            }
        }
        catch (Exception e) {
            intValue = 0;
        }
        this.m_New_NetSwitch = (byte)(intValue & 0xFF);
        try {
            intValue = Integer.valueOf(this.jTextField_SubSwitch.getText());
            if (intValue < 0) {
                intValue = 0;
            }
            if (intValue > 15) {
                intValue = 15;
            }
        }
        catch (Exception e) {
            intValue = 0;
        }
        this.m_New_SubNet = (byte)(intValue & 0xFF);
        for (LAN_PlugIn o_LAN_PlugIn : this.m_PlugInPanels.keySet()) {
            LAN_Device_Configuration_PlugInPanel o_PlugInPanel;
            if (o_LAN_PlugIn == null || (o_PlugInPanel = this.m_PlugInPanels.get(o_LAN_PlugIn)) == null) continue;
            o_PlugInPanel.prepareSave_ArtNet();
        }
    }

    public void prepareSave_sACN() {
        this.m_New_NetSwitch = 0;
        this.m_New_SubNet = 0;
        for (LAN_PlugIn o_LAN_PlugIn : this.m_PlugInPanels.keySet()) {
            LAN_Device_Configuration_PlugInPanel o_PlugInPanel;
            if (o_LAN_PlugIn == null || (o_PlugInPanel = this.m_PlugInPanels.get(o_LAN_PlugIn)) == null) continue;
            o_PlugInPanel.prepareSave_sACN();
        }
    }

    public String getNew_ShortName() {
        String stringName = this.m_New_ShortName;
        if (stringName.length() > 17) {
            stringName = stringName.substring(0, 17);
        }
        return this.m_New_ShortName;
    }

    public String getNew_LongName() {
        return this.m_New_LongName;
    }

    public byte getNew_NetSwitch() {
        return this.m_New_NetSwitch;
    }

    public byte getNew_SubNet() {
        return this.m_New_SubNet;
    }

    public int getBindIndex() {
        return this.m_BindIndex;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof LAN_Device) {
            IndexedPropertyChangeEvent o_IndexedPropertyChangeEvent;
            if ("prop_devicelanplugin".equals(evt.getPropertyName())) {
                LAN_PlugIn o_LAN_PlugIn = (LAN_PlugIn)evt.getOldValue();
                if (o_LAN_PlugIn != null) {
                    this.removeLAN_PlugIn(o_LAN_PlugIn);
                } else {
                    o_LAN_PlugIn = (LAN_PlugIn)evt.getNewValue();
                    if (o_LAN_PlugIn != null) {
                        this.addLAN_PlugIn(o_LAN_PlugIn);
                    }
                }
            } else if ("prop_deviceartnetnodename".equals(evt.getPropertyName()) && this.m_BindIndex != (o_IndexedPropertyChangeEvent = (IndexedPropertyChangeEvent)evt).getIndex()) {
                return;
            }
            EventQueue.invokeLater(this.m_Runnable_RefreshGUI);
        } else if (evt.getSource() instanceof LAN_PlugIn) {
            EventQueue.invokeLater(this.m_Runnable_RefreshGUI);
        }
    }
}

