/*
 * Decompiled with CFR 0.152.
 */
package SoundVirtualPackage;

import Icons.IconManager;
import LiveShowNotificationPackage.LiveShowNotification;
import LiveShowObjectPackage.LiveShowDragDrop;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowSceneBridgeMain;
import LiveShowVirtualPackage.LiveShowTimer;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import LiveShowVirtualPackage.LiveShow_ExportDescription;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import PlaySoundPackage.PlaySound;
import SoundPackage.SoundMixers;
import SoundSamplePackage.LiveShowSoundHD;
import SoundVirtualPackage.LiveShowSoundObject;
import SoundVirtualPackage.LiveShowSoundObjectDescription;
import SoundVirtualPackage.LiveShowSoundSceneBridge;
import SoundVirtualPackage.LiveShowSoundVIPTrack;
import StartPackage.LiveShowSoundSystem;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.swing.ImageIcon;

public class LiveShowSoundVIP
extends LiveShowVIP
implements Externalizable,
LiveShowObjectListener {
    public static final int SOFTWAREVERSION = 2;
    public static final String FILESUFFIX = ".lsv";
    public static ImageIcon s_Icon = IconManager.getImageIcon((String)"Sound.png");
    public static String ERROR_NODATALINEFOUND = "No matching Dataline was found!";
    private AudioFormat m_AudioFormat;
    private PlaySound.SoundPlayObject m_VipTrackSoundPlayObject;
    private final Object m_SyncPlay = new Object();
    public static Exception s_LoadException = null;

    public LiveShowSoundVIP(boolean p_Create) {
        this.initMembers();
        if (p_Create) {
            this.m_AudioFormat = SoundMixers.DEFAULT_AUDIOFORMAT;
            this.m_VipTrackSoundPlayObject = new PlaySound.SoundPlayObject((Playable)this, this.m_AudioFormat);
            this.initializeVIP();
        }
    }

    public void initializeVIP() {
        this.createPlay();
        for (int intVipTrack = 0; intVipTrack < DEFAULT_TRACKSCOUNT; ++intVipTrack) {
            this.createLiveShowVipTrack();
        }
        LiveShowTimer.selfReference().addLiveShowVIP((LiveShowVIP)this);
        this.notifyLiveShowVIPListeners_MaxFrame(this.getFramePositionMax());
    }

    public void createPlay() {
        if (this.m_Play != null) {
            this.m_Play.close();
        }
        this.m_Play = new PlaySound((Playable)this, this.m_AudioFormat);
        this.m_Play.createOutputLine();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal_Objects(out, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeExternal_Objects(ObjectOutput out, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShowExportDescription) throws IOException {
        LiveShowObjectInterface o_LiveShowObjectInterface;
        if (out == null) {
            return false;
        }
        out.writeInt(2);
        out.writeBoolean(this.m_Active);
        LiveShowNotification o_LiveShowNotification = null;
        AudioFormat o_AudioFormat = this.m_AudioFormat;
        int intVipTrackCount = this.m_LiveShowVIPTracks.size();
        ArrayList<LiveShowSceneBridge> o_ArrayListSceneBridges = new ArrayList<LiveShowSceneBridge>();
        ArrayList<LiveShowObjectInterface> o_ArrayListObjects = new ArrayList<LiveShowObjectInterface>();
        Object object = this.m_SyncObjects;
        synchronized (object) {
            Object[] o_SceneBridges = this.m_SceneBridges.toArray();
            for (int intSceneBridge = 0; intSceneBridge < o_SceneBridges.length; ++intSceneBridge) {
                LiveShowSceneBridge o_LiveShowSceneBridge = (LiveShowSceneBridge)o_SceneBridges[intSceneBridge];
                if (!p_LiveShowExportDescription.getSaveProject() && !p_LiveShowExportDescription.getExportProjectAll() && !o_LiveShowSceneBridge.getSelected()) continue;
                o_ArrayListSceneBridges.add(o_LiveShowSceneBridge);
            }
            Object[] o_Objects = this.m_LiveShowObjects.toArray();
            for (int intObject = 0; intObject < o_Objects.length; ++intObject) {
                o_LiveShowObjectInterface = (LiveShowObjectInterface)o_Objects[intObject];
                if (o_LiveShowObjectInterface instanceof LiveShowSceneBridge || !p_LiveShowExportDescription.getSaveProject() && !p_LiveShowExportDescription.getExportProjectAll() && !o_LiveShowObjectInterface.getSelected()) continue;
                o_ArrayListObjects.add(o_LiveShowObjectInterface);
            }
        }
        if (!p_LiveShowExportDescription.getSaveProject() && !p_LiveShowExportDescription.getExportProjectAll() && o_ArrayListSceneBridges.size() <= 0 && o_ArrayListObjects.size() <= 0) {
            return false;
        }
        if (this.m_LiveShowNotification != null) {
            o_LiveShowNotification = new LiveShowNotification(this.m_LiveShowNotification, "-", (long)o_ArrayListObjects.size(), 0L);
        }
        LiveShowProjectDescription.writeExternalAudioFormat((ObjectOutput)out, (AudioFormat)o_AudioFormat);
        out.writeInt(intVipTrackCount);
        out.writeInt(o_ArrayListSceneBridges.size());
        for (int intSoundObject = 0; intSoundObject < o_ArrayListSceneBridges.size(); ++intSoundObject) {
            o_LiveShowObjectInterface = (LiveShowObjectInterface)o_ArrayListSceneBridges.get(intSoundObject);
            o_LiveShowObjectInterface.getDescription().writeExternal(out);
            p_LiveShowExportDescription.addLiveShowSceneBridge((LiveShowVIP)this, (LiveShowSceneBridge)o_LiveShowObjectInterface);
        }
        out.writeInt(o_ArrayListObjects.size());
        int intSoundObjectCount = 0;
        for (int intSoundObject = 0; intSoundObject < o_ArrayListObjects.size(); ++intSoundObject) {
            o_LiveShowObjectInterface = (LiveShowObjectInterface)o_ArrayListObjects.get(intSoundObject);
            if (o_LiveShowObjectInterface instanceof LiveShowSceneBridge) continue;
            if (o_LiveShowNotification != null) {
                String stringSourceString = o_LiveShowObjectInterface.getDescription().getSourceString();
                if (stringSourceString == null) {
                    stringSourceString = "";
                }
                o_LiveShowNotification.setText(stringSourceString);
            }
            if (p_LiveShowExportDescription.getSaveProject()) {
                o_LiveShowObjectInterface.getDescription().writeExternal(out);
            } else if (!LiveShowSoundSystem.exportLiveShowSoundObject(out, (LiveShowSoundObject)o_LiveShowObjectInterface, p_LiveShowProjectDescription)) {
                // empty if block
            }
            p_LiveShowExportDescription.addLiveShowObject((LiveShowVIP)this, o_LiveShowObjectInterface);
            ++intSoundObjectCount;
            if (o_LiveShowNotification == null) continue;
            o_LiveShowNotification.setProgress((long)intSoundObjectCount);
        }
        if (o_LiveShowNotification != null) {
            o_LiveShowNotification.close();
        }
        return true;
    }

    public long getDiskSpaceEstimated(File p_ExportDirectory, boolean p_OnlySelectedObjects, ArrayList<Object> p_SourceObjects) {
        long longBytesCount = 0L;
        File o_ExportDirectorySoundFiles = null;
        if (p_ExportDirectory != null) {
            o_ExportDirectorySoundFiles = new File(p_ExportDirectory.getAbsolutePath() + LiveShowSoundSystem.FILENAME_SOUNDDIRECTORY);
        }
        longBytesCount += 4L;
        ++longBytesCount;
        longBytesCount += 4L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        Object[] o_Objects = this.m_LiveShowObjects.toArray();
        for (int intObject = 0; intObject < o_Objects.length; ++intObject) {
            LiveShowObjectInterface o_LiveShowObjectInterface = (LiveShowObjectInterface)o_Objects[intObject];
            if (p_OnlySelectedObjects && !o_LiveShowObjectInterface.getSelected()) continue;
            if (o_LiveShowObjectInterface instanceof LiveShowSceneBridge) {
                longBytesCount += o_LiveShowObjectInterface.getDiskSpaceEstimated();
                continue;
            }
            if (!(o_LiveShowObjectInterface instanceof LiveShowSoundObject)) continue;
            longBytesCount += o_LiveShowObjectInterface.getDiskSpaceEstimated();
            LiveShowSoundHD o_LiveShowSoundHD = ((LiveShowSoundObject)o_LiveShowObjectInterface).getLiveShowSoundHD();
            if (o_LiveShowSoundHD == null || p_SourceObjects != null && p_SourceObjects.contains(o_LiveShowSoundHD)) continue;
            longBytesCount += o_LiveShowSoundHD.getDiskSpaceEstimated(o_ExportDirectorySoundFiles);
            if (p_SourceObjects == null) continue;
            p_SourceObjects.add(o_LiveShowSoundHD);
        }
        return longBytesCount;
    }

    public static boolean saveSoundVIP(LiveShowSoundVIP o_LiveShowSoundVIP, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShowExportDescription) {
        if (o_LiveShowSoundVIP == null) {
            return false;
        }
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        FileOutputStream o_OutputStream = null;
        ObjectOutputStream o_ObjectOutput = null;
        boolean boolHasSomething = true;
        boolean boolError = false;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
        try {
            if (o_File.exists()) {
                o_File.delete();
            }
            o_OutputStream = new FileOutputStream(o_File);
            o_ObjectOutput = new ObjectOutputStream(o_OutputStream);
            o_ObjectOutput.writeInt(2);
            boolHasSomething = o_LiveShowSoundVIP.writeExternal_Objects(o_ObjectOutput, p_LiveShowProjectDescription, p_LiveShowExportDescription);
            o_ObjectOutput.close();
            ((OutputStream)o_OutputStream).close();
            if (!boolHasSomething) {
                LiveShowSoundVIP.deleteSoundVIP(o_LiveShowSoundVIP, p_LiveShowProjectDescription);
            }
        }
        catch (Exception e) {
            boolError = true;
            System.err.println("Error cannot write LiveShowSoundVIP: " + o_File.getAbsolutePath());
            try {
                if (o_ObjectOutput != null) {
                    o_ObjectOutput.close();
                }
                if (o_OutputStream != null) {
                    ((OutputStream)o_OutputStream).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolError;
    }

    public static boolean deleteSoundVIP(LiveShowSoundVIP p_LiveShowSoundVIP, LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowSoundVIP == null) {
            return false;
        }
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
        if (o_File.exists()) {
            boolSuccess = o_File.delete();
        }
        return boolSuccess;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void readExternal_Objects(ObjectInput in, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        if (intSoftwareVersion >= 2) {
            boolean boolActive = in.readBoolean();
            if (p_LiveShow_ImportDescription.getLoadNewProject()) {
                this.m_Active = boolActive;
            }
        }
        LiveShowNotification o_LiveShowNotification = null;
        boolean boolOK = true;
        AudioFormat o_AudioFormat = LiveShowProjectDescription.readExternalAudioFormat((ObjectInput)in);
        int intTrackCount = in.readInt();
        if (intTrackCount <= 0) {
            intTrackCount = 1;
        }
        if (p_LiveShow_ImportDescription.getLoadNewProject()) {
            this.m_AudioFormat = o_AudioFormat;
            this.createPlay();
            if (intTrackCount > this.m_LiveShowVIPTracks.size()) {
                for (int intVipTrack = this.m_LiveShowVIPTracks.size(); intVipTrack < intTrackCount; ++intVipTrack) {
                    this.createLiveShowVipTrack();
                }
            }
        } else if (!o_AudioFormat.matches(this.m_AudioFormat)) {
            boolOK = false;
        }
        if (boolOK) {
            LiveShowSoundObjectDescription o_LiveShowSoundObjectDescription;
            int intObject;
            if (this.m_VipTrackSoundPlayObject == null) {
                this.m_VipTrackSoundPlayObject = new PlaySound.SoundPlayObject((Playable)this, this.m_AudioFormat);
            }
            int intObjectCount = in.readInt();
            for (intObject = 0; intObject < intObjectCount; ++intObject) {
                o_LiveShowSoundObjectDescription = LiveShowSoundObjectDescription.poolGet();
                o_LiveShowSoundObjectDescription.readExternal(in);
                p_LiveShow_ImportDescription.checkImportObject((LiveShowVIP)this, (LiveShowObjectDescription)o_LiveShowSoundObjectDescription);
                LiveShowSceneBridge o_LiveShowSceneBridge = this.createLiveShowSceneBridge(o_LiveShowSoundObjectDescription);
                this.addLiveShowSceneBridge(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getFrameStart());
                p_LiveShow_ImportDescription.addLiveShowSceneBridge((LiveShowVIP)this, o_LiveShowSceneBridge);
                o_LiveShowSoundObjectDescription.close(true);
            }
            this.refreshJumps();
            intObjectCount = in.readInt();
            if (this.m_LiveShowNotification != null) {
                o_LiveShowNotification = new LiveShowNotification(this.m_LiveShowNotification, "-", (long)intObjectCount, 0L);
            }
            for (intObject = 0; intObject < intObjectCount; ++intObject) {
                o_LiveShowSoundObjectDescription = LiveShowSoundObjectDescription.poolGet();
                o_LiveShowSoundObjectDescription.readExternal(in);
                int intVipTrackNumber = o_LiveShowSoundObjectDescription.getVIPTrackNumber();
                if (intVipTrackNumber >= 0) {
                    LiveShowObjectInterface o_LiveShowObjectInterface;
                    if (intVipTrackNumber >= this.m_LiveShowVIPTracks.size()) {
                        for (int intVipTrack = this.m_LiveShowVIPTracks.size(); intVipTrack <= intVipTrackNumber; ++intVipTrack) {
                            this.createLiveShowVipTrack();
                        }
                    }
                    p_LiveShow_ImportDescription.checkImportObject((LiveShowVIP)this, (LiveShowObjectDescription)o_LiveShowSoundObjectDescription);
                    if (o_LiveShowNotification != null) {
                        String stringSourceFile = o_LiveShowSoundObjectDescription.getSourceString();
                        if (stringSourceFile == null) {
                            stringSourceFile = "";
                        }
                        stringSourceFile = stringSourceFile.replace("\\", "/");
                        File o_File = new File(stringSourceFile);
                        File o_FileParent = o_File.getParentFile();
                        StringBuffer stringBufferNotificationText = new StringBuffer();
                        stringBufferNotificationText.append("<html>");
                        stringBufferNotificationText.append("<center>");
                        stringBufferNotificationText.append("<b>");
                        stringBufferNotificationText.append(o_File.getName());
                        stringBufferNotificationText.append("</b>");
                        if (o_FileParent != null) {
                            stringBufferNotificationText.append("<br>");
                            stringBufferNotificationText.append(o_FileParent.getPath());
                        }
                        stringBufferNotificationText.append("</center>");
                        stringBufferNotificationText.append("</html>");
                        o_LiveShowNotification.setText(stringBufferNotificationText.toString());
                    }
                    if ((o_LiveShowObjectInterface = this.createLiveShowObject(o_LiveShowSoundObjectDescription, p_LiveShowProjectDescription)) == null) {
                        o_LiveShowSoundObjectDescription.close(true);
                        continue;
                    }
                    LiveShowVIPTrack o_LiveShowVIPTrack = (LiveShowVIPTrack)this.m_LiveShowVIPTracks.get(o_LiveShowSoundObjectDescription.getVIPTrackNumber());
                    if (o_LiveShowVIPTrack != null) {
                        o_LiveShowVIPTrack.addLiveShowObjectInterface(o_LiveShowObjectInterface, o_LiveShowObjectInterface.getFrameStart());
                        p_LiveShow_ImportDescription.addLiveShowObject((LiveShowVIP)this, o_LiveShowObjectInterface);
                    }
                }
                o_LiveShowSoundObjectDescription.close(true);
                if (o_LiveShowNotification == null) continue;
                o_LiveShowNotification.setProgress((long)intObject);
            }
        }
        if (this.m_LiveShowVIPTracks.size() == 0) {
            this.createLiveShowVipTrack();
        }
        if (o_LiveShowNotification != null) {
            o_LiveShowNotification.close();
        }
        this.calculateFramesToNextSceneBridge();
        this.notifyLiveShowVIPListeners_MaxFrame(this.getFramePositionMax());
        LiveShowTimer.selfReference().addLiveShowVIP((LiveShowVIP)this);
    }

    public static LiveShowSoundVIP loadLiveShowSoundVIP(LiveShowSoundVIP p_LiveShowSoundVIP, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription, LiveShowNotification p_LiveShowNotification) {
        s_LoadException = null;
        if (p_LiveShowSoundVIP == null) {
            return null;
        }
        if (p_LiveShowProjectDescription == null) {
            return null;
        }
        if (p_LiveShow_ImportDescription == null) {
            return null;
        }
        FileInputStream o_InputStream = null;
        ObjectInputStream o_ObjectInput = null;
        p_LiveShowSoundVIP.clearSelectedObjects(false);
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
        if (!o_File.exists()) {
            if (p_LiveShow_ImportDescription.getLoadNewProject()) {
                p_LiveShowSoundVIP.initializeVIP();
            }
            return p_LiveShowSoundVIP;
        }
        try {
            o_InputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_InputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            p_LiveShowSoundVIP.setLiveShowNotification(p_LiveShowNotification);
            p_LiveShowSoundVIP.readExternal_Objects(o_ObjectInput, p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
            o_ObjectInput.close();
            ((InputStream)o_InputStream).close();
        }
        catch (Exception e) {
            s_LoadException = e;
            System.err.println("Error LiveShowSoundVIP loadLiveShowSoundVIP File: " + o_File.getAbsolutePath());
            e.printStackTrace();
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_InputStream != null) {
                    ((InputStream)o_InputStream).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return p_LiveShowSoundVIP;
        }
        return p_LiveShowSoundVIP;
    }

    private void initMembers() {
        super.setType("Sound");
        this.m_AudioFormat = SoundMixers.DEFAULT_AUDIOFORMAT;
    }

    public void close() {
        LiveShowTimer.selfReference().removeLiveShowVIP((LiveShowVIP)this);
        if (this.m_Play != null) {
            this.m_Play.stopAndWaitFor();
        }
        super.close();
        if (this.m_VipTrackSoundPlayObject != null) {
            this.m_VipTrackSoundPlayObject.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public boolean accepts(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return false;
        }
        if (p_LiveShowObjectInterface.getObjectType() == 1) {
            return true;
        }
        return p_LiveShowObjectInterface.getObjectType() == 2;
    }

    public DataFlavor getDataFlavor() {
        return LiveShowDragDrop.LiveShowTransferable.SOUNDOBJECTFLAVOUR;
    }

    public FlavorMap getDataFlavorMap() {
        return LiveShowDragDrop.LiveShowTransferable.getFlavorMapSound();
    }

    public AudioFormat getAudioFormat() {
        return this.m_AudioFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowVIPTrack createLiveShowVipTrack() {
        LiveShowSoundVIPTrack o_LiveShowSoundVIPTrack = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            o_LiveShowSoundVIPTrack = new LiveShowSoundVIPTrack(this);
            this.addLiveShowVIPTrack(o_LiveShowSoundVIPTrack);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSoundVIPTrack;
    }

    public LiveShowObjectInterface createLiveShowObject(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return null;
        }
        LiveShowSoundObject o_LiveShowObjectInterface = null;
        if (p_LiveShowObjectDescription.getObjectType() != 1) {
            return null;
        }
        o_LiveShowObjectInterface = new LiveShowSoundObject(p_LiveShowObjectDescription);
        if (o_LiveShowObjectInterface.getSource() == null) {
            o_LiveShowObjectInterface.close(true);
            o_LiveShowObjectInterface = null;
        }
        return o_LiveShowObjectInterface;
    }

    public LiveShowObjectInterface createLiveShowObject(LiveShowObjectDescription p_LiveShowObjectDescription, LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return null;
        }
        LiveShowSoundObject o_LiveShowObjectInterface = null;
        if (p_LiveShowObjectDescription.getObjectType() != 1) {
            return null;
        }
        o_LiveShowObjectInterface = new LiveShowSoundObject(p_LiveShowObjectDescription, p_LiveShowProjectDescription);
        if (o_LiveShowObjectInterface.getSource() == null) {
            o_LiveShowObjectInterface.close(true);
            o_LiveShowObjectInterface = null;
        }
        return o_LiveShowObjectInterface;
    }

    public LiveShowSceneBridge createLiveShowSceneBridge(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            p_LiveShowObjectDescription = LiveShowSoundObjectDescription.poolGet();
            p_LiveShowObjectDescription.setObjectType(2);
            long longLength = LiveShowSceneBridge.DEFAULTFRAMELENGTHSCENEBRIDGE;
            p_LiveShowObjectDescription.setFrameStart(0L);
            p_LiveShowObjectDescription.setFrameLength(longLength);
            p_LiveShowObjectDescription.setFrameFadeInLength(longLength);
            p_LiveShowObjectDescription.setFrameFadeOutLength(longLength);
            p_LiveShowObjectDescription.setName("newSceneBridge");
            LiveShowSoundSceneBridge o_LiveShowSoundSceneBridge = new LiveShowSoundSceneBridge(p_LiveShowObjectDescription);
            return o_LiveShowSoundSceneBridge;
        }
        if (p_LiveShowObjectDescription.getObjectType() != 2) {
            return null;
        }
        LiveShowSoundSceneBridge o_LiveShowSoundSceneBridge = new LiveShowSoundSceneBridge(p_LiveShowObjectDescription);
        return o_LiveShowSoundSceneBridge;
    }

    public LiveShowSceneBridge createLiveShowSceneBridge(LiveShowSceneBridgeMain p_LiveShowSceneBridgeMain, LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return null;
        }
        if (p_LiveShowSceneBridgeMain == null) {
            return null;
        }
        LiveShowSoundObjectDescription o_LiveShowObjectDescription = LiveShowSoundObjectDescription.poolGet();
        o_LiveShowObjectDescription.setID(p_LiveShowSceneBridgeMain.getID());
        o_LiveShowObjectDescription.setObjectType(2);
        o_LiveShowObjectDescription.setName(p_LiveShowObjectDescription.getName());
        o_LiveShowObjectDescription.setIsMainBridge(true);
        long longLength = p_LiveShowObjectDescription.getFrameLength();
        o_LiveShowObjectDescription.setFrameStart(p_LiveShowObjectDescription.getFrameStart());
        o_LiveShowObjectDescription.setFrameLength(longLength);
        o_LiveShowObjectDescription.setFrameFadeInLength(longLength);
        o_LiveShowObjectDescription.setFrameFadeOutLength(longLength);
        o_LiveShowObjectDescription.setStopAtStart(p_LiveShowObjectDescription.getStopAtStart());
        o_LiveShowObjectDescription.setActive(p_LiveShowObjectDescription.getActive());
        LiveShowSoundSceneBridge o_LiveShowSoundSceneBridge = new LiveShowSoundSceneBridge(o_LiveShowObjectDescription);
        this.addLiveShowSceneBridge(o_LiveShowSoundSceneBridge, o_LiveShowSoundSceneBridge.getFrameStart());
        return o_LiveShowSoundSceneBridge;
    }

    public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject) {
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getFramePosition() < 0L) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Playable.PlayObject o_PlayObject = null;
        LiveShowSceneBridge o_ActualSceneBridge = this.m_ActualSceneBridge;
        o_PlayObject = o_ActualSceneBridge != null ? o_ActualSceneBridge.read(p_Play, p_PlayObject, null, -1L, 1.0, false) : this.readInternal(p_Play, p_PlayObject, null, -1L, 1.0, false);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (!this.m_Active) {
            return null;
        }
        return o_PlayObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Playable.PlayObject readInternal(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_ScenebridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        if (!this.m_Active) {
            return p_PlayObject;
        }
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getFramePosition() < 0L) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        if (!(p_PlayObject instanceof PlaySound.SoundPlayObject)) {
            return null;
        }
        PlaySound.SoundPlayObject o_SoundPlayObject = (PlaySound.SoundPlayObject)p_PlayObject;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        PlaySound.SoundPlayObject o_Result = null;
        Object object = this.m_SyncPlay;
        synchronized (object) {
            for (int intTrack = 0; intTrack < this.m_LiveShowVIPTracks.size(); ++intTrack) {
                PlaySound.SoundPlayObject o_PlayObject;
                LiveShowSoundVIPTrack o_LiveShowSoundVIPTrack = (LiveShowSoundVIPTrack)((Object)this.m_LiveShowVIPTracks.get(intTrack));
                if (o_LiveShowSoundVIPTrack == null || (o_PlayObject = (PlaySound.SoundPlayObject)o_LiveShowSoundVIPTrack.read(p_Play, o_SoundPlayObject, p_LiveShowSceneBridge, p_ScenebridgeFrameInside, p_SceneBridgeFadeProgress, p_IsPreObject)) == null) continue;
                o_Result = o_SoundPlayObject;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_Result;
    }

    public ImageIcon getImageIcon() {
        return s_Icon;
    }

    public void eventEndOfAction(LiveShowVIP.LiveShowVIPStatus p_LiveShowVIPStatus, boolean p_Success, int p_Action) {
        super.eventEndOfAction(p_LiveShowVIPStatus, p_Success, p_Action);
    }

    public void setSceneBridgeCursorChanged(LiveShowSceneBridge p_LiveShowSceneBridge) {
    }

    public long checkSnappingSpecial(long p_ActorFramePosition, int p_ActorLabelType, LiveShowObjectDescription p_LiveShowObjectDescription, boolean p_ObjectItself) {
        return p_ActorFramePosition;
    }
}

