/*
 * Decompiled with CFR 0.152.
 */
package SoundVirtualPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import PlaySoundPackage.PlaySound;
import SoundVirtualPackage.LiveShowSoundObjectDescription;
import SoundVirtualPackage.LiveShowSoundVIP;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;

public class LiveShowSoundSceneBridge
extends LiveShowSceneBridge {
    public static final int SOFTWAREVERSION = 1;
    @LiveLanguageString
    public static String s_BridgeRemoteGroupName = "Scene_Sound";
    private PlaySound.SoundPlayObject m_SoundPlayObjectPre;

    public LiveShowSoundSceneBridge(LiveShowObjectDescription p_LiveShowObjectDescription) {
        super(p_LiveShowObjectDescription);
        this.initMembers();
        this.initMembersFurther(p_LiveShowObjectDescription);
        LiveLanguage.addLanguageListener((Object)((Object)this), null);
    }

    private void initMembers() {
        this.setObjectType(2);
    }

    private void initMembersFurther(LiveShowObjectDescription p_LiveShowObjectDescription) {
        this.setDescription(p_LiveShowObjectDescription);
        if (this.m_LiveShowVIP != null) {
            this.m_SoundPlayObjectPre = new PlaySound.SoundPlayObject((Playable)this.m_LiveShowVIP, ((LiveShowSoundVIP)this.m_LiveShowVIP).getAudioFormat());
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        this.m_Description.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        LiveShowSoundObjectDescription o_LiveShowObjectDescription = LiveShowSoundObjectDescription.poolGet();
        o_LiveShowObjectDescription.readExternal(in);
        this.initMembersFurther(o_LiveShowObjectDescription);
    }

    public boolean exportExternal(ObjectOutput out, LiveShowProjectDescription p_LiveShowProjectDescription, String p_ReplaceName) throws IOException {
        this.writeExternal(out);
        return true;
    }

    public void close(boolean p_Finish) {
        super.close(p_Finish);
        if (this.m_SoundPlayObjectPre != null) {
            this.m_SoundPlayObjectPre.close();
        }
    }

    public void setLiveShowVIP(LiveShowVIP p_LiveShowSoundVIP) {
        super.setLiveShowVIP(p_LiveShowSoundVIP);
        if (this.m_LiveShowVIP != null) {
            this.m_SoundPlayObjectPre = new PlaySound.SoundPlayObject((Playable)this.m_LiveShowVIP, ((LiveShowSoundVIP)this.m_LiveShowVIP).getAudioFormat());
        }
    }

    public void setSource(Object p_SourceObject) {
    }

    public Object getSource() {
        return null;
    }

    public String getSourceAdditionalInfo() {
        return null;
    }

    public ComboBoxModel getSourceListModel() {
        return null;
    }

    public boolean getSourceIsReplaceable() {
        return false;
    }

    public DefaultListCellRenderer getSourceListRenderer() {
        return null;
    }

    public boolean getFrameOffsetAbility() {
        return false;
    }

    public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        PlaySound.SoundPlayObject o_SoundPlayObjectPost;
        if (p_Play == null) {
            return null;
        }
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getFramePosition() < 0L) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        if (!(p_PlayObject instanceof PlaySound.SoundPlayObject)) {
            return null;
        }
        if (this.m_LiveShowVIP == null) {
            return null;
        }
        PlaySound.SoundPlayObject o_SoundPlayObject = (PlaySound.SoundPlayObject)p_PlayObject;
        if (this.m_Play == null) {
            return null;
        }
        boolean boolBridgeStarted = false;
        if (!this.m_IsPlaying) {
            this.m_IsPlaying = true;
            boolBridgeStarted = true;
            ((PlaySound.SoundPlayObject)p_PlayObject).setFramePosition_Pre(p_PlayObject.getFramePosition());
            this.setFramePositionPre(p_PlayObject.getFramePosition());
            if (p_Play.isRunning()) {
                this.m_Play.setPlayCursor(this.m_Description.getFrameStart());
                p_PlayObject.setFramePosition(this.m_Description.getFrameStart());
            }
        }
        if (!this.isCursorPositionInside(p_PlayObject.getFramePosition())) {
            if (this.m_IsPlaying) {
                this.stopSceneBridge();
                this.m_IsPlaying = false;
            }
            Playable.PlayObject o_ResultPlayObject = this.m_LiveShowVIP.readInternal(p_Play, (Playable.PlayObject)o_SoundPlayObject, null, -1L, 1.0, false);
            return o_ResultPlayObject;
        }
        long longFrameInside = p_PlayObject.getFramePosition() - this.getFrameStart();
        PlaySound.SoundPlayObject o_SoundPlayObjectPre = null;
        double doubleFadeProgress = this.calculateFadeProgress(longFrameInside, o_SoundPlayObject.getFramesToRead(), false, true);
        o_SoundPlayObjectPre = (PlaySound.SoundPlayObject)this.m_LiveShowVIP.readInternal(p_Play, (Playable.PlayObject)o_SoundPlayObject, (LiveShowSceneBridge)this, longFrameInside, doubleFadeProgress, true);
        if (o_SoundPlayObjectPre != null) {
            // empty if block
        }
        if ((o_SoundPlayObjectPost = (PlaySound.SoundPlayObject)this.m_LiveShowVIP.readInternal(p_Play, (Playable.PlayObject)o_SoundPlayObject, (LiveShowSceneBridge)this, longFrameInside, doubleFadeProgress = this.calculateFadeProgress(longFrameInside, o_SoundPlayObject.getFramesToRead(), true, false), false)) != null) {
            // empty if block
        }
        PlaySound.SoundPlayObject o_ResultPlayObject = o_SoundPlayObjectPre != null && o_SoundPlayObject != null ? o_SoundPlayObject : (o_SoundPlayObjectPost != null ? o_SoundPlayObjectPost : (o_SoundPlayObjectPre != null ? o_SoundPlayObjectPre : null));
        ((PlaySound.SoundPlayObject)p_PlayObject).setFramePosition_Pre(((PlaySound.SoundPlayObject)p_PlayObject).getFramePosition_Pre() + p_PlayObject.getFramesToRead());
        this.setFramePositionPre(this.getFramePositionPre() + p_PlayObject.getFramesToRead());
        Play.PlaySynchronisizer o_PlaySynchronisizer = this.m_Play.getPlaySynchronizer();
        if (o_PlaySynchronisizer != null) {
            // empty if block
        }
        if (!this.m_LiveShowVIP.getActive()) {
            return null;
        }
        return o_ResultPlayObject;
    }

    public double calculateFadeProgress(long p_FramePositionInside, long p_FramesLength, boolean p_FadeIn, boolean p_FadeOut) {
        boolean boolInside = false;
        double doubleFactor = 1.0;
        long longFramePositionInside = p_FramePositionInside;
        if (longFramePositionInside == 0L && p_FadeIn) {
            return 0.0;
        }
        if (longFramePositionInside > 0L && longFramePositionInside < this.m_Description.getFrameStart() + this.m_Description.getFrameLength()) {
            boolInside = true;
        }
        if (boolInside = true) {
            if (!p_FadeIn) {
                if (this.m_Description.getFrameFadeOutLength() - this.m_Description.getFrameFadeOutOffset() > 0L && longFramePositionInside <= this.m_Description.getFrameFadeOutLength()) {
                    if (longFramePositionInside > this.m_Description.getFrameFadeOutOffset()) {
                        doubleFactor = (double)(this.m_Description.getFrameFadeOutLength() - longFramePositionInside) / (double)(this.m_Description.getFrameFadeOutLength() - this.m_Description.getFrameFadeOutOffset());
                    }
                } else {
                    doubleFactor = longFramePositionInside > this.m_Description.getFrameFadeOutOffset() ? 0.0 : 1.0;
                }
            } else {
                long longPositionFromEnd = this.m_Description.getFrameLength() - longFramePositionInside;
                if (longPositionFromEnd < 0L) {
                    doubleFactor = 1.0;
                } else if (this.m_Description.getFrameFadeInLength() - this.m_Description.getFrameFadeInOffset() > 0L && longPositionFromEnd <= this.m_Description.getFrameFadeInLength()) {
                    if (longPositionFromEnd > this.m_Description.getFrameFadeInOffset()) {
                        doubleFactor = (double)(this.m_Description.getFrameFadeInLength() - longPositionFromEnd) / (double)(this.m_Description.getFrameFadeInLength() - this.m_Description.getFrameFadeInOffset());
                    }
                } else {
                    doubleFactor = longPositionFromEnd > this.m_Description.getFrameFadeInOffset() ? 0.0 : 1.0;
                }
            }
        }
        if (doubleFactor > 1.0) {
            doubleFactor = 1.0;
        }
        if (doubleFactor < 0.0) {
            doubleFactor = 0.0;
        }
        return doubleFactor;
    }

    public double calculateSceneBridgeVolume(long p_FramePosition, boolean p_IsPreObject) {
        return 1.0;
    }

    private void recalculateFadeVolume(long p_FramePosition, Playable.PlayObject p_PlayObject, long p_FramesLength, boolean p_FadeIn) {
        if (p_FramePosition < 0L) {
            return;
        }
        if (p_PlayObject == null) {
            return;
        }
        if (p_PlayObject.getData() == null) {
            return;
        }
        ByteBuffer o_ByteBuffer = (ByteBuffer)p_PlayObject.getData();
        PlaySound.SoundPlayObject o_SoundPlayObject = (PlaySound.SoundPlayObject)p_PlayObject;
        int intFrameSize = o_SoundPlayObject.getAudioFormat().getFrameSize();
        if (intFrameSize <= 0) {
            return;
        }
        int intChannelByteCount = o_SoundPlayObject.getAudioFormat().getSampleSizeInBits() / 8;
        boolean boolInside = false;
        double doubleFactor = 1.0;
        long longFramePosition = p_FramePosition;
        double doubleValue = 0.0;
        int intByteStart = 0;
        int intByteEnd = (int)(p_FramesLength * (long)intFrameSize);
        int intByteBufferPosition = intByteStart;
        if (intByteEnd > o_ByteBuffer.capacity()) {
            return;
        }
        for (int intByte = intByteStart; intByte < intByteEnd; intByte += intFrameSize) {
            long longFramePositionInside = longFramePosition - this.m_Description.getFrameStart();
            if (longFramePositionInside > 0L && longFramePositionInside < this.m_Description.getFrameStart() + this.m_Description.getFrameLength()) {
                boolInside = true;
            }
            if (boolInside = true) {
                doubleFactor = this.m_Description.getVolumeFactor_Logarithm();
                if (!p_FadeIn) {
                    if (this.m_Description.getFrameFadeOutLength() - this.m_Description.getFrameFadeOutOffset() > 0L && longFramePositionInside <= this.m_Description.getFrameFadeOutLength()) {
                        if (longFramePositionInside > this.m_Description.getFrameFadeOutOffset()) {
                            doubleFactor *= (double)((float)(this.m_Description.getFrameFadeOutLength() - longFramePositionInside) / (float)(this.m_Description.getFrameFadeOutLength() - this.m_Description.getFrameFadeOutOffset()));
                        }
                    } else if (longFramePositionInside > this.m_Description.getFrameFadeOutOffset()) {
                        doubleFactor = 0.0;
                    }
                } else {
                    long longPositionFromEnd = this.m_Description.getFrameLength() - longFramePositionInside;
                    if (longPositionFromEnd < 0L) {
                        doubleFactor *= 1.0;
                    } else if (this.m_Description.getFrameFadeInLength() - this.m_Description.getFrameFadeInOffset() > 0L && longPositionFromEnd <= this.m_Description.getFrameFadeInLength()) {
                        if (longPositionFromEnd > this.m_Description.getFrameFadeInOffset()) {
                            doubleFactor *= (double)((float)(this.m_Description.getFrameFadeInLength() - longPositionFromEnd) / (float)(this.m_Description.getFrameFadeInLength() - this.m_Description.getFrameFadeInOffset()));
                        }
                    } else if (longPositionFromEnd > this.m_Description.getFrameFadeInOffset()) {
                        doubleFactor = 0.0;
                    }
                }
            }
            if (doubleFactor > 1.0) {
                doubleFactor = 1.0;
            }
            if (doubleFactor < 0.0) {
                doubleFactor = 0.0;
            }
            for (int intChannel = 0; intChannel < o_SoundPlayObject.getAudioFormat().getChannels(); ++intChannel) {
                o_ByteBuffer.position(intByteBufferPosition);
                if (!boolInside) {
                    doubleValue = 0.0;
                } else {
                    switch (intChannelByteCount) {
                        case 1: {
                            doubleValue = o_ByteBuffer.get();
                            break;
                        }
                        case 2: {
                            doubleValue = o_ByteBuffer.getShort();
                            break;
                        }
                        case 3: {
                            o_ByteBuffer.get();
                            o_ByteBuffer.get();
                            o_ByteBuffer.get();
                            doubleValue = 0.0;
                            break;
                        }
                        case 4: {
                            doubleValue = o_ByteBuffer.getInt();
                        }
                    }
                    doubleValue *= doubleFactor;
                }
                o_ByteBuffer.position(intByteBufferPosition);
                switch (intChannelByteCount) {
                    case 1: {
                        if (doubleValue > 255.0) {
                            doubleValue = 255.0;
                        }
                        if (doubleValue < 0.0) {
                            doubleValue = 0.0;
                        }
                        o_ByteBuffer.put((byte)doubleValue);
                        break;
                    }
                    case 2: {
                        if (doubleValue > 32767.0) {
                            doubleValue = 32767.0;
                        }
                        if (doubleValue < -32768.0) {
                            doubleValue = -32768.0;
                        }
                        o_ByteBuffer.putShort((short)doubleValue);
                        break;
                    }
                    case 3: {
                        doubleValue = 0.0;
                        o_ByteBuffer.put((byte)0);
                        o_ByteBuffer.put((byte)0);
                        o_ByteBuffer.put((byte)0);
                        break;
                    }
                    case 4: {
                        if (doubleValue > 2.147483647E9) {
                            doubleValue = 2.147483647E9;
                        }
                        if (doubleValue < -2.147483648E9) {
                            doubleValue = -2.147483648E9;
                        }
                        o_ByteBuffer.putInt((int)doubleValue);
                    }
                }
                intByteBufferPosition += intChannelByteCount;
            }
            ++longFramePosition;
        }
    }

    public double getFrameTime() {
        return LiveShowVIP.FRAMETIME;
    }

    public void notifyObjectListeners_ObjectParameterChanged(LiveShowObjectDescription p_LiveShowObjectDescription) {
        super.notifyObjectListeners_ObjectParameterChanged(p_LiveShowObjectDescription);
    }

    public void eventEndOfAction(LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
        super.eventEndOfAction(p_ActorLiveShowVIP, p_Success, p_Action);
    }

    public String getRemoteGroupName() {
        return s_BridgeRemoteGroupName;
    }
}

