/*
 * Decompiled with CFR 0.152.
 */
package SoundVirtualPackage;

import Icons.IconManager;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectPanel;
import SoundGraphics.LiveShowSoundGraphicsFile;
import SoundPackage.SoundMixers;
import SoundSamplePackage.LiveShowSoundHD;
import SoundVirtualPackage.LiveShowSoundObject;
import SynchronizationPackage.JobHandler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.swing.ImageIcon;

public class LiveShowSoundObjectPanel
extends LiveShowObjectPanel {
    public static ImageIcon s_IconCalculateSoundGraphic = IconManager.getImageIcon((String)"Sound_CalculateGraphic.png");
    private Point m_PointMin;
    private Point m_PointMax;
    private LiveShowSoundHD m_LiveShowSoundHD;
    private LiveShowSoundGraphicsFile m_LiveShowSoundGraphicsFile;
    private ArrayList<Path2D.Float> m_GraphicPaths;
    private ArrayList<LiveShowSoundGraphicsFile.GraphicsFrame> m_GraphicsFrames;
    private StringBuilder stringChannelName;
    private final Object m_SyncStringBuilder = new Object();

    public LiveShowSoundObjectPanel(LiveShowSoundObject p_LiveShowSoundObject, boolean p_Resizable) {
        super((LiveShowObjectInterface)p_LiveShowSoundObject, p_Resizable);
        this.initMembers();
        this.m_LiveShowSoundHD = p_LiveShowSoundObject.getLiveShowSoundHD();
        AudioFormat o_AudioFormat = this.m_LiveShowSoundHD == null ? SoundMixers.DEFAULT_AUDIOFORMAT : this.m_LiveShowSoundHD.getAudioFormat();
        for (int intChannel = 0; intChannel < o_AudioFormat.getChannels(); ++intChannel) {
            Path2D.Float o_Path = new Path2D.Float();
            this.m_GraphicPaths.add(o_Path);
        }
    }

    private void initMembers() {
        this.m_LiveShowSoundGraphicsFile = null;
        this.m_GraphicsFrames = new ArrayList();
        this.m_GraphicPaths = new ArrayList();
        this.m_PointMin = new Point(0, 0);
        this.m_PointMax = new Point(0, 0);
        this.setDoubleBuffered(false);
        this.stringChannelName = new StringBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        Object object = this.m_SyncPainting;
        synchronized (object) {
            if (this.m_GraphicsFrames != null) {
                this.m_GraphicsFrames.clear();
                this.m_GraphicsFrames = null;
            }
            this.m_LiveShowSoundGraphicsFile = null;
        }
    }

    public void loadSoundGraphicsFile() {
        final LiveShowSoundObjectPanel o_SelfReference = this;
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (LiveShowSoundObjectPanel.this.m_LiveShowSoundHD != null) {
                    LiveShowSoundObjectPanel.this.m_LiveShowSoundGraphicsFile = LiveShowSoundObjectPanel.this.m_LiveShowSoundHD.getLiveShowSoundGraphicsFile();
                    o_SelfReference.setDirty();
                } else {
                    LiveShowSoundObjectPanel.this.m_LiveShowSoundGraphicsFile = null;
                }
            }
        };
        JobHandler.addJob((Runnable)o_Runnable);
    }

    public void paintData(Graphics2D p_Graphics2D, int p_ContainerViewWidth, int p_Height, int p_VisibleStartX, int p_VisibleEndX, long p_VisibleStartFrame, long p_VisibleEndFrame, boolean p_RedrawWidth, boolean p_RedrawHeight) {
        int intChannel;
        Path2D.Float o_Path;
        int intChannelHeightMiddle;
        if (p_Graphics2D == null) {
            return;
        }
        AudioFormat o_AudioFormat = null;
        LiveShowSoundHD o_LiveShowSoundHD = this.m_LiveShowSoundHD;
        if (o_LiveShowSoundHD != null) {
            o_AudioFormat = o_LiveShowSoundHD.getAudioFormat();
        }
        LiveShowSoundGraphicsFile o_LiveShowSoundGraphicsFile = this.m_LiveShowSoundGraphicsFile;
        if (o_LiveShowSoundHD == null || o_AudioFormat == null || o_LiveShowSoundGraphicsFile == null) {
            this.paintCalculate(p_Graphics2D, p_VisibleStartX, p_VisibleEndX);
            return;
        }
        int intChannels = o_AudioFormat.getChannels();
        int intHeightChannel = intChannels <= 0 ? 1 : this.m_AbsoluteConstraints.height / intChannels;
        this.m_PointMin.setLocation(0, 0);
        this.m_PointMax.setLocation(0, 0);
        double doubleHeightFactor = (double)intHeightChannel / 32767.0 / 2.0;
        if (this.m_GraphicsFrames.size() < this.m_ContainerViewWidth) {
            for (int intGraphicFrame = this.m_GraphicsFrames.size(); intGraphicFrame < p_ContainerViewWidth; ++intGraphicFrame) {
                this.m_GraphicsFrames.add(new LiveShowSoundGraphicsFile.GraphicsFrame(intChannels));
            }
        }
        if (p_RedrawWidth) {
            if (o_LiveShowSoundGraphicsFile == null) {
                return;
            }
            o_LiveShowSoundGraphicsFile.getGraphicFrames(this.m_GraphicsFrames, p_VisibleStartX, p_VisibleEndX, p_VisibleStartFrame, p_VisibleEndFrame);
        }
        if (p_RedrawHeight || p_RedrawWidth) {
            int intPointX;
            int intChannel2;
            LiveShowSoundGraphicsFile.GraphicsFrame o_GraphicsFrame = this.m_GraphicsFrames.get(0);
            for (intChannel2 = 0; intChannel2 < intChannels; ++intChannel2) {
                intChannelHeightMiddle = intChannel2 * intHeightChannel + intHeightChannel / 2;
                o_Path = this.m_GraphicPaths.get(intChannel2);
                o_Path.reset();
                o_Path.moveTo((double)p_VisibleStartX, (double)intChannelHeightMiddle + (double)o_GraphicsFrame.getChannelMaxValue(intChannel2) * doubleHeightFactor);
            }
            for (intPointX = p_VisibleStartX + 1; intPointX < p_VisibleEndX; ++intPointX) {
                o_GraphicsFrame = this.m_GraphicsFrames.get(intPointX - p_VisibleStartX);
                if (o_GraphicsFrame == null) continue;
                for (intChannel = 0; intChannel < intChannels; ++intChannel) {
                    intChannelHeightMiddle = intChannel * intHeightChannel + intHeightChannel / 2;
                    this.m_PointMax.setLocation((double)intPointX, (double)intChannelHeightMiddle + (double)o_GraphicsFrame.getChannelMaxValue(intChannel) * doubleHeightFactor);
                    o_Path = this.m_GraphicPaths.get(intChannel);
                    o_Path.lineTo(this.m_PointMax.x, this.m_PointMax.y);
                }
            }
            for (intPointX = p_VisibleEndX - 1; intPointX >= p_VisibleStartX; --intPointX) {
                o_GraphicsFrame = this.m_GraphicsFrames.get(intPointX - p_VisibleStartX);
                if (o_GraphicsFrame == null) continue;
                for (intChannel = 0; intChannel < intChannels; ++intChannel) {
                    intChannelHeightMiddle = intChannel * intHeightChannel + intHeightChannel / 2;
                    this.m_PointMin.setLocation((double)intPointX, (double)intChannelHeightMiddle + (double)o_GraphicsFrame.getChannelMinValue(intChannel) * doubleHeightFactor);
                    o_Path = this.m_GraphicPaths.get(intChannel);
                    o_Path.lineTo(this.m_PointMin.x, this.m_PointMin.y);
                }
            }
            for (intChannel2 = 0; intChannel2 < intChannels; ++intChannel2) {
                o_Path = this.m_GraphicPaths.get(intChannel2);
                if (o_Path == null) continue;
                o_Path.closePath();
            }
        }
        Color o_Color = this.m_ColorFill_Transparent;
        p_Graphics2D.setColor(o_Color);
        for (intChannel = 0; intChannel < intChannels; ++intChannel) {
            o_Path = this.m_GraphicPaths.get(intChannel);
            p_Graphics2D.fill(o_Path);
        }
        o_Color = this.getColorOutline();
        p_Graphics2D.setColor(o_Color);
        for (intChannel = 0; intChannel < intChannels; ++intChannel) {
            o_Path = this.m_GraphicPaths.get(intChannel);
            p_Graphics2D.draw(o_Path);
        }
        p_Graphics2D.setColor(this.getBackground());
        for (intChannel = 0; intChannel < intChannels; ++intChannel) {
            this.stringChannelName.delete(0, this.stringChannelName.length());
            this.stringChannelName.append(intChannel + 1);
            switch (intChannel) {
                case 0: {
                    this.stringChannelName.append(" L");
                    break;
                }
                case 1: {
                    this.stringChannelName.append(" R");
                    break;
                }
                case 2: {
                    this.stringChannelName.append(" C");
                    break;
                }
                case 3: {
                    this.stringChannelName.append(" Sub");
                    break;
                }
                case 4: {
                    this.stringChannelName.append(" RL");
                    break;
                }
                case 5: {
                    this.stringChannelName.append(" RR");
                    break;
                }
                case 6: {
                    this.stringChannelName.append(" AL");
                    break;
                }
                case 7: {
                    this.stringChannelName.append(" AR");
                    break;
                }
            }
            intChannelHeightMiddle = intChannel * intHeightChannel + intHeightChannel / 2;
            p_Graphics2D.setColor(this.getBackground());
            p_Graphics2D.drawLine(0, intChannelHeightMiddle, p_VisibleEndX - p_VisibleStartX, intChannelHeightMiddle);
            p_Graphics2D.setColor(Color.LIGHT_GRAY);
            p_Graphics2D.drawString(this.stringChannelName.toString(), 5, intChannelHeightMiddle);
        }
    }

    private void paintCalculate(Graphics2D p_Graphics2D, int p_VisibleStartX, int p_VisibleEndX) {
        Color o_Color = Color.DARK_GRAY;
        p_Graphics2D.setColor(o_Color);
        p_Graphics2D.fillRect(p_VisibleStartX + 1, 0, p_VisibleEndX - p_VisibleStartX, this.m_AbsoluteConstraints.height);
        p_Graphics2D.drawImage(s_IconCalculateSoundGraphic.getImage(), p_VisibleStartX + 1 + (p_VisibleEndX - p_VisibleStartX) / 2, this.m_AbsoluteConstraints.height / 3, s_IconCalculateSoundGraphic.getImageObserver());
    }
}

