/*
 * Decompiled with CFR 0.152.
 */
package SoundVirtualPackage;

import FileToolPackage.FileTools;
import Icons.IconManager;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectPanel;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import PlaySoundPackage.PlaySound;
import SoundGraphics.LiveShowSoundGraphicsFile;
import SoundPackage.SoundMixers;
import SoundSamplePackage.LiveShowSoundHD;
import SoundVirtualPackage.LiveShowSoundObjectDescription;
import SoundVirtualPackage.LiveShowSoundObjectPanel;
import SoundVirtualPackage.LiveShowSoundSceneBridge;
import SoundVirtualPackage.LiveShowSoundVIP;
import StartPackage.LiveShowSoundSystem;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.DoubleBuffer;
import java.util.HashMap;
import javax.sound.sampled.AudioFormat;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;

public class LiveShowSoundObject
extends LiveShowObject
implements SoundMixers.Sound_Lines_Parent {
    public static final int SOFTWAREVERSION = 1;
    public static ImageIcon s_Icon = IconManager.getImageIcon((String)"Sound.png");
    public static final String SOURCESTRING_SILENT = "-";
    private static HashMap<String, String> s_HasMapFileNewPosition = new HashMap();
    private static File s_LastNewPath = null;
    private LiveShowSoundHD m_LiveShowSoundHD;
    private AudioFormat m_AudioFormat;
    private LiveShowSoundSceneBridge m_LiveShowSceneBridge;
    private LiveShowSoundSystem.PlayPrefetchBuffer m_PrefetchBuffer;
    private LiveShowSoundSystem.PlayPrefetchBuffer m_PrefetchBufferSceneBridgePre;
    private DoubleBuffer m_ChannelBuffer;
    private boolean m_ResetRestart;
    private boolean m_ResetPrefetchDone;
    private boolean m_ResetPrefetchSceneBridgeDone;
    private final Object m_SyncSoundLines = new Object();

    public static void clearHashMapFilePositions() {
        s_HasMapFileNewPosition.clear();
        s_LastNewPath = null;
    }

    public LiveShowSoundObject(LiveShowObjectDescription p_Description, LiveShowSoundHD p_LiveShowSoundHD, long p_ObjectFrameOffset, long p_ObjectFrameLength) {
        super(p_Description);
        this.initMembers();
        File o_SoundFile = null;
        this.m_LiveShowSoundHD = p_LiveShowSoundHD;
        if (this.m_LiveShowSoundHD != null) {
            o_SoundFile = p_LiveShowSoundHD.getSoundFile();
        }
        if (o_SoundFile != null) {
            this.m_Description.setSourceName(o_SoundFile.getName());
            this.m_Description.setSourceString(o_SoundFile.getPath());
        } else {
            this.m_Description.setSourceName(SOURCESTRING_SILENT);
            this.m_Description.setSourceString(SOURCESTRING_SILENT);
        }
        this.m_Description.setFrameStartOffset(p_ObjectFrameOffset);
        this.m_Description.setFrameLength(p_ObjectFrameLength);
        this.initMembersFurther(this.m_Description, null);
        SoundMixers.Sound_Lines o_Sound_Lines = ((LiveShowSoundObjectDescription)this.m_Description).getSound_Lines();
        o_Sound_Lines.clear();
        o_Sound_Lines.setParentType("SoundObject");
        o_Sound_Lines.setParentChannelCount(this.m_AudioFormat.getChannels());
        for (int intChannel = 0; intChannel < this.m_AudioFormat.getChannels(); ++intChannel) {
            this.addSoundLineFactor(intChannel, intChannel, 1.0, true);
        }
    }

    public LiveShowSoundObject(LiveShowObjectDescription p_Description) {
        super(p_Description);
        this.initMembers();
        this.initMembersFurther(p_Description, null);
        SoundMixers.Sound_Lines o_Sound_Lines = ((LiveShowSoundObjectDescription)p_Description).getSound_Lines();
    }

    public LiveShowSoundObject(LiveShowObjectDescription p_Description, LiveShowProjectDescription p_LiveShowProjectDescription) {
        super(p_Description);
        this.initMembers();
        this.initMembersFurther(p_Description, p_LiveShowProjectDescription);
        SoundMixers.Sound_Lines o_Sound_Lines = ((LiveShowSoundObjectDescription)p_Description).getSound_Lines();
    }

    private void initMembers() {
        this.m_LiveShowSoundHD = null;
        this.setObjectType(1);
        this.m_ResetPrefetchDone = false;
        this.m_ResetPrefetchSceneBridgeDone = false;
        this.m_ResetRestart = false;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public boolean exportExternal(ObjectOutput out, LiveShowProjectDescription p_LiveShowProjectDescription, String p_ReplaceName) throws IOException {
        File o_NewFile = null;
        String stringNewFileNameBase = "Unkwown";
        long longLastModification = 0L;
        boolean boolMustCopyFile = true;
        boolean boolCopiedPrior = false;
        boolean boolCopyOK = true;
        String stringOldFilePathName = this.m_Description.getSourceString();
        if (stringOldFilePathName == null) {
            return false;
        }
        File o_OldFile = new File(stringOldFilePathName);
        String stringOldFileNameBase = FileTools.getFileNameBase((File)o_OldFile);
        String stringOldPath = FileTools.getPathName((File)o_OldFile);
        String stringFileNameWithoutPath = p_ReplaceName != null ? p_ReplaceName : o_OldFile.getName();
        if (!o_OldFile.exists()) {
            boolMustCopyFile = false;
        }
        if (LiveShowSoundSystem.exportedFileList_Contains(o_OldFile)) {
            boolCopiedPrior = true;
        }
        String stringNewPath = p_LiveShowProjectDescription.getProjectPath();
        File o_NewDirectory = new File(stringNewPath + LiveShowSoundSystem.FILENAME_SOUNDDIRECTORY);
        if (boolMustCopyFile && !boolCopiedPrior) {
            o_NewFile = FileTools.copyFileTo((File)o_OldFile, (File)o_NewDirectory, (String)stringFileNameWithoutPath, (boolean)true);
            if (o_NewFile == null) {
                boolCopyOK = false;
                System.err.println("LiveShowSoundVIP Cannot copy sound file: " + this.getSourceName());
            }
            if (boolCopyOK) {
                stringFileNameWithoutPath = o_NewFile.getName();
                stringNewFileNameBase = FileTools.getFileNameBase((File)o_NewFile);
                LiveShowSoundSystem.exportedFileList_Add(o_OldFile);
            }
        }
        if (boolCopyOK && !boolCopiedPrior) {
            longLastModification = o_NewFile.lastModified();
            stringOldFilePathName = stringOldPath + "/" + stringOldFileNameBase + ".lsg";
            o_OldFile = new File(stringOldFilePathName);
            o_NewFile = FileTools.copyFileTo((File)o_OldFile, (File)o_NewDirectory, (String)(stringNewFileNameBase + ".lsg"), (boolean)true);
            if (o_NewFile == null) {
                System.err.println("LiveShowSoundVIP cannot copy graphic file of: " + this.getSourceName());
            } else {
                LiveShowSoundGraphicsFile.GraphicsHeader o_GraphicsHeader = LiveShowSoundGraphicsFile.GraphicsHeader.readGraphicsHeader(o_NewFile);
                if (o_GraphicsHeader != null) {
                    o_GraphicsHeader.setSoundFileLastModification(longLastModification);
                    LiveShowSoundGraphicsFile.GraphicsHeader.writeGraphicsHeader(o_NewFile, o_GraphicsHeader);
                }
            }
        }
        if (!boolMustCopyFile || !boolCopiedPrior) {
            // empty if block
        }
        if (boolCopyOK && !boolCopiedPrior) {
            stringOldFilePathName = stringOldPath + "/" + stringOldFileNameBase + ".lsm";
            o_OldFile = new File(stringOldFilePathName);
            FileTools.copyFileTo((File)o_OldFile, (File)o_NewDirectory, (String)(stringNewFileNameBase + ".lsm"), (boolean)true);
        }
        LiveShowObjectDescription o_LiveShowObjectDescription = this.m_Description.clone(null);
        if (boolCopyOK) {
            o_LiveShowObjectDescription.setSourceString(stringFileNameWithoutPath);
            o_LiveShowObjectDescription.setSourceName(stringFileNameWithoutPath);
        }
        o_LiveShowObjectDescription.writeExternal(out);
        o_LiveShowObjectDescription.close(true);
        return boolCopyOK;
    }

    private void initMembersFurther(LiveShowObjectDescription p_Description, LiveShowProjectDescription p_LiveShowProjectDescription) {
        File o_File;
        if (p_Description == null) {
            return;
        }
        String stringNewFileName = null;
        String stringOldFileName = p_Description.getSourceString();
        if (stringOldFileName == null) {
            stringNewFileName = "";
        }
        stringOldFileName = stringOldFileName.replace("\\", "/");
        if (this.m_LiveShowSoundHD == null) {
            stringNewFileName = stringOldFileName;
            this.m_LiveShowSoundHD = LiveShowSoundSystem.createLiveShowSoundHD(stringNewFileName);
        }
        if (this.m_LiveShowSoundHD == null) {
            o_File = new File(stringOldFileName);
            stringNewFileName = o_File.getName();
            stringNewFileName = LiveShowSoundSystem.getLiveShowProjectDescription().getProjectPath() + LiveShowSoundSystem.FILENAME_SOUNDDIRECTORY + "/" + stringNewFileName;
            o_File = new File(stringNewFileName);
            if (o_File.exists()) {
                this.m_LiveShowSoundHD = LiveShowSoundSystem.createLiveShowSoundHD(stringNewFileName);
            }
        }
        if (this.m_LiveShowSoundHD == null && p_LiveShowProjectDescription != null) {
            o_File = new File(stringOldFileName);
            stringNewFileName = o_File.getName();
            stringNewFileName = p_LiveShowProjectDescription.getProjectPath() + LiveShowSoundSystem.FILENAME_SOUNDDIRECTORY + "/" + stringNewFileName;
            o_File = new File(stringNewFileName);
            if (o_File.exists()) {
                this.m_LiveShowSoundHD = LiveShowSoundSystem.createLiveShowSoundHD(stringNewFileName);
            }
        }
        if (this.m_LiveShowSoundHD == null) {
            stringNewFileName = s_HasMapFileNewPosition.get(stringOldFileName);
            if (SOURCESTRING_SILENT.equals(stringNewFileName)) {
                return;
            }
            if (stringNewFileName != null) {
                this.m_LiveShowSoundHD = LiveShowSoundSystem.createLiveShowSoundHD(stringNewFileName);
            }
        }
        if (this.m_LiveShowSoundHD == null && s_LastNewPath != null) {
            o_File = new File(stringOldFileName);
            stringNewFileName = o_File.getName();
            stringNewFileName = s_LastNewPath + "/" + stringNewFileName;
            o_File = new File(stringNewFileName);
            if (o_File.exists()) {
                this.m_LiveShowSoundHD = LiveShowSoundSystem.createLiveShowSoundHD(stringNewFileName);
            }
        }
        if (this.m_LiveShowSoundHD == null) {
            o_File = new File(stringOldFileName);
            if ((o_File = LiveShowSoundSystem.searchLostSoundFile(o_File)) == null) {
                s_HasMapFileNewPosition.put(stringOldFileName, SOURCESTRING_SILENT);
                return;
            }
            stringNewFileName = o_File.getPath();
            this.m_LiveShowSoundHD = LiveShowSoundSystem.createLiveShowSoundHD(stringNewFileName);
            if (this.m_LiveShowSoundHD != null) {
                s_HasMapFileNewPosition.put(stringOldFileName, stringNewFileName);
                s_LastNewPath = o_File.getParentFile();
            }
        }
        if (this.m_LiveShowSoundHD == null) {
            return;
        }
        if (stringNewFileName != null && !SOURCESTRING_SILENT.equals(stringNewFileName)) {
            p_Description.setSourceString(stringNewFileName);
        }
        this.m_LiveShowSoundHD.addReference((Object)this);
        this.m_AudioFormat = this.m_LiveShowSoundHD.getAudioFormat();
        this.m_PrefetchBuffer = LiveShowSoundSystem.getPlayBuffer();
        this.m_PrefetchBufferSceneBridgePre = LiveShowSoundSystem.getPlayBuffer();
        super.setDescription(p_Description);
        this.m_Description.setID(p_Description.getID());
        o_File = this.m_LiveShowSoundHD.getSoundFile();
        if (o_File != null) {
            this.m_Description.setSourceName(o_File.getName());
        } else {
            this.m_Description.setSourceName("");
        }
        this.m_LiveShowSoundHD.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.m_PrefetchBuffer.initPlay(this);
        this.m_PrefetchBufferSceneBridgePre.initPlay(this);
        this.m_ChannelBuffer = DoubleBuffer.allocate(this.m_AudioFormat.getChannels() * (int)((double)this.m_AudioFormat.getFrameRate() * ((double)PlaySound.BUFFER_MILLISECONDS / 1000.0)));
    }

    public void close(boolean p_Finish) {
        LiveShowSoundSystem.releasePlayBuffer(this.m_PrefetchBuffer);
        LiveShowSoundSystem.releasePlayBuffer(this.m_PrefetchBufferSceneBridgePre);
        if (this.m_LiveShowSoundHD != null) {
            this.m_LiveShowSoundHD.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.m_LiveShowSoundHD.removeReference((Object)this, p_Finish);
            this.m_LiveShowSoundHD = null;
        }
        super.close(p_Finish);
    }

    public LiveShowVIP getLiveShowVIP() {
        return LiveShowSoundSystem.getLiveShowSoundVIP();
    }

    public long getSourceFrameLength() {
        if (this.m_LiveShowSoundHD == null) {
            return 0L;
        }
        return this.m_LiveShowSoundHD.getFrameLength();
    }

    public LiveShowSoundHD getLiveShowSoundHD() {
        return this.m_LiveShowSoundHD;
    }

    public void setLiveShowSoundHD(LiveShowSoundHD p_LiveShowSoundHD) {
        this.m_LiveShowSoundHD = p_LiveShowSoundHD;
    }

    public AudioFormat getAudioFormat() {
        return this.m_AudioFormat;
    }

    public void resetPrefetchBuffer(long p_FrameInside) {
        this.m_ResetPrefetchDone = true;
        if (this.m_ResetPrefetchDone && this.m_ResetPrefetchSceneBridgeDone) {
            this.m_ResetRestart = false;
        }
        if (this.m_PrefetchBuffer != null) {
            this.m_PrefetchBuffer.setPositionInsideObject_Frame(p_FrameInside, false);
        }
    }

    public void resetPrefetchBuffer_SceneBridge(LiveShowSceneBridge p_ActualSceneBridge, LiveShowSceneBridge p_NextSceneBridge, long p_PlayCursor) {
        LiveShowSceneBridge o_LiveShowSceneBridge;
        this.m_ResetPrefetchSceneBridgeDone = true;
        if (this.m_ResetPrefetchDone && this.m_ResetPrefetchSceneBridgeDone) {
            this.m_ResetRestart = false;
        }
        if (p_ActualSceneBridge != null) {
            if (p_ActualSceneBridge.getFrameStart() > this.getFrameStart() + this.getFrameLength()) {
                p_ActualSceneBridge = null;
            } else if (p_ActualSceneBridge.getFrameStart() + this.getFrameLength() < this.getFrameStart()) {
                p_ActualSceneBridge = null;
            }
        }
        if ((o_LiveShowSceneBridge = p_NextSceneBridge) != null) {
            if (o_LiveShowSceneBridge.getFrameStart() > this.getFrameStart() + this.getFrameLength()) {
                o_LiveShowSceneBridge = null;
            } else if (o_LiveShowSceneBridge.getFrameStart() + o_LiveShowSceneBridge.getFrameLength() < this.getFrameStart()) {
                o_LiveShowSceneBridge = null;
            } else if (p_ActualSceneBridge != null ? p_PlayCursor < p_ActualSceneBridge.getFrameStart() + p_ActualSceneBridge.getFrameLength() : p_PlayCursor >= o_LiveShowSceneBridge.getFrameStart()) {
                return;
            }
        }
        if (o_LiveShowSceneBridge == null) {
            o_LiveShowSceneBridge = p_ActualSceneBridge;
        }
        if (o_LiveShowSceneBridge != null) {
            this.m_PrefetchBufferSceneBridgePre.setPositionInsideObject_Frame(o_LiveShowSceneBridge.getFrameStart() - this.getFrameStart(), false);
        } else {
            this.m_PrefetchBufferSceneBridgePre.setPositionInsideObject_Frame(0L, false);
        }
    }

    public SoundMixers.Sound_Lines getSound_Lines() {
        return ((LiveShowSoundObjectDescription)this.m_Description).getSound_Lines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSound_Channel_LinesCount(int p_HDChannel) {
        Object object = this.m_SyncSoundLines;
        synchronized (object) {
            SoundMixers.Sound_Lines o_Sound_Lines = this.getSound_Lines();
            return o_Sound_Lines.getSound_Channel_LinesCount(p_HDChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoundMixers.SoundLineFactor getSoundLineFactorByIndex(int p_HDChannel, int p_Index) {
        Object object = this.m_SyncSoundLines;
        synchronized (object) {
            SoundMixers.Sound_Lines o_Sound_Lines = this.getSound_Lines();
            return o_Sound_Lines.getSoundLineFactorByIndex(p_HDChannel, p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSoundLineFactor(int p_HDChannel, int p_SoundLineNumber, double p_VolumeFactor, boolean p_Proof) {
        Object object = this.m_SyncSoundLines;
        synchronized (object) {
            SoundMixers.Sound_Lines o_Sound_Lines = this.getSound_Lines();
            return o_Sound_Lines.addSoundLineFactor(p_HDChannel, p_SoundLineNumber, p_VolumeFactor, p_Proof);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSoundLineFactor(int p_HDChannel, int p_SoundLineNumber) {
        Object object = this.m_SyncSoundLines;
        synchronized (object) {
            SoundMixers.Sound_Lines o_Sound_Lines = this.getSound_Lines();
            return o_Sound_Lines.removeSoundLineFactor(p_HDChannel, p_SoundLineNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        LiveShowSceneBridge o_LiveShowSceneBridge_Previous;
        if (p_Play == null) {
            return null;
        }
        if (p_PlayObject == null) {
            this.m_IsPlaying = false;
            return null;
        }
        if (p_PlayObject.getData() == null) {
            this.m_IsPlaying = false;
            return null;
        }
        if (!(p_PlayObject instanceof PlaySound.SoundPlayObject)) {
            this.m_IsPlaying = false;
            return null;
        }
        if (this.m_Description == null) {
            this.m_IsPlaying = false;
            return null;
        }
        if (this.m_LiveShowSoundHD == null) {
            this.m_IsPlaying = false;
            return null;
        }
        if (this.m_AudioFormat == null) {
            this.m_IsPlaying = false;
            return null;
        }
        PlaySound.SoundPlayObject o_SoundPlayObject = (PlaySound.SoundPlayObject)p_PlayObject;
        LiveShowSoundVIP o_LiveShowSoundVIP = LiveShowSoundSystem.getLiveShowSoundVIP();
        if (o_LiveShowSoundVIP != null && !o_LiveShowSoundVIP.getActive()) {
            return null;
        }
        long longFramePosition = p_IsPreObject ? o_SoundPlayObject.getFramePosition_Pre() : o_SoundPlayObject.getFramePosition();
        if (p_LiveShowSceneBridge != null) {
            if (p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart()) && p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart() + this.getFrameLength() - 1L)) {
                if (p_IsPreObject) {
                    return null;
                }
            } else if (p_IsPreObject) {
                if (!p_LiveShowSceneBridge.getPlayPreObject()) {
                    return null;
                }
                if (p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart()) && longFramePosition < p_LiveShowSceneBridge.getFrameStart() + p_LiveShowSceneBridge.getFrameLength()) {
                    return null;
                }
                LiveShowSceneBridge o_ExcludedLiveShowSceneBridge = p_LiveShowSceneBridge.getLiveShowVIP().getLiveShowSceneBridge_Exluded();
                if (o_ExcludedLiveShowSceneBridge != null && this.getFrameStart() >= o_ExcludedLiveShowSceneBridge.getFrameStart()) {
                    return null;
                }
            } else if (p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart() + this.getFrameLength() - 1L)) {
                return null;
            }
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        if (o_SoundPlayObject.getFramesToRead() > (long)o_SoundPlayObject.getFramesBuffered()) {
            o_SoundPlayObject.setFramesToRead(o_SoundPlayObject.getFramesBuffered());
        }
        if (longFramePosition + o_SoundPlayObject.getFramesToRead() < this.m_Description.getFrameStart()) {
            if (p_LiveShowSceneBridge == null) {
                if (!this.m_ResetPrefetchSceneBridgeDone && o_LiveShowSoundVIP != null) {
                    o_LiveShowSceneBridge_Previous = null;
                    LiveShowSceneBridge o_LiveShowSceneBridge_Next = o_LiveShowSoundVIP.getLiveShowSceneBridge_Next(this.m_Description.getFrameStart(), false, true);
                    this.resetPrefetchBuffer_SceneBridge(o_LiveShowSceneBridge_Previous, o_LiveShowSceneBridge_Next, o_SoundPlayObject.getFramePosition());
                }
                if (!this.m_ResetPrefetchDone) {
                    this.resetPrefetchBuffer(0L);
                }
            }
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            this.m_IsPlaying = false;
            return null;
        }
        if (longFramePosition >= this.m_Description.getFrameStart() + this.getFrameLengthToPlay()) {
            if (p_LiveShowSceneBridge == null) {
                if (!this.m_ResetPrefetchSceneBridgeDone && o_LiveShowSoundVIP != null) {
                    o_LiveShowSceneBridge_Previous = o_LiveShowSoundVIP.getLiveShowSceneBridge_Previous(this.m_Description.getFrameStart() + this.getFrameLengthToPlay(), false, true);
                    LiveShowSceneBridge o_LiveShowSceneBridge_Next = null;
                    this.resetPrefetchBuffer_SceneBridge(o_LiveShowSceneBridge_Previous, o_LiveShowSceneBridge_Next, o_SoundPlayObject.getFramePosition());
                }
                if (!this.m_ResetPrefetchDone) {
                    this.resetPrefetchBuffer(0L);
                }
            }
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            this.m_IsPlaying = false;
            return null;
        }
        this.m_ResetPrefetchDone = false;
        this.m_ResetPrefetchSceneBridgeDone = false;
        this.m_IsPlaying = true;
        long longPlayObjectFrameOffset = 0L;
        long longPlayObjectFramesToRead = o_SoundPlayObject.getFramesToRead();
        if (longFramePosition < this.m_Description.getFrameStart()) {
            longPlayObjectFrameOffset = this.m_Description.getFrameStart() - longFramePosition;
        }
        if (longFramePosition + o_SoundPlayObject.getFramesToRead() > this.m_Description.getFrameStart() + this.getFrameLengthToPlay()) {
            longPlayObjectFramesToRead = this.m_Description.getFrameStart() + this.getFrameLengthToPlay() - longFramePosition;
        }
        int intSoundLinesBufferBase = 0;
        boolean boolWasInside = false;
        double doubleFadeProgress = 1.0;
        double doubleFadeInProgress = 1.0;
        double doubleFadeOutProgress = 0.0;
        SoundMixers.Sound_Lines o_Sound_Lines = this.getSound_Lines();
        try {
            if (p_LiveShowSceneBridge != null) {
                if (this.m_LiveShowSceneBridge != p_LiveShowSceneBridge) {
                    LiveShowSoundSystem.PlayPrefetchBuffer o_Temp = this.m_PrefetchBufferSceneBridgePre;
                    this.m_PrefetchBufferSceneBridgePre = this.m_PrefetchBuffer;
                    this.m_PrefetchBuffer = o_Temp;
                }
                this.m_LiveShowSceneBridge = (LiveShowSoundSceneBridge)p_LiveShowSceneBridge;
            } else if (this.m_LiveShowSceneBridge != null && !this.m_LiveShowSceneBridge.getIsPlaying()) {
                if (o_LiveShowSoundVIP != null) {
                    o_LiveShowSceneBridge_Previous = null;
                    LiveShowSceneBridge o_LiveShowSceneBridge_Next = o_LiveShowSoundVIP.getLiveShowSceneBridge_Next(this.m_LiveShowSceneBridge, false, true);
                    if (o_LiveShowSceneBridge_Next != null && this.m_Description.getFrameStart() + this.getFrameLengthToPlay() <= o_LiveShowSceneBridge_Next.getFrameStart()) {
                        if (o_LiveShowSceneBridge_Next.getJumpActive()) {
                            if ((o_LiveShowSceneBridge_Next = o_LiveShowSceneBridge_Next.getJumpSceneBridge()) != null && this.m_Description.getFrameStart() + this.getFrameLengthToPlay() <= o_LiveShowSceneBridge_Next.getFrameStart()) {
                                o_LiveShowSceneBridge_Next = null;
                            }
                        } else {
                            o_LiveShowSceneBridge_Next = null;
                        }
                    }
                    if (o_LiveShowSceneBridge_Next == null) {
                        o_LiveShowSceneBridge_Previous = this.m_LiveShowSceneBridge;
                    }
                    this.resetPrefetchBuffer_SceneBridge(o_LiveShowSceneBridge_Previous, o_LiveShowSceneBridge_Next, p_PlayObject.getFramePosition());
                }
                this.m_LiveShowSceneBridge = null;
            }
            DoubleBuffer o_SoundLinesBuffer = o_SoundPlayObject.getSoundLinesBuffer();
            if (o_SoundLinesBuffer == null) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return null;
            }
            AudioFormat o_AudioFormat = this.m_AudioFormat;
            if (o_AudioFormat == null || o_AudioFormat.getChannels() <= 0) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return null;
            }
            int intChannelCount = o_AudioFormat.getChannels();
            if (longPlayObjectFramesToRead > (long)(this.m_ChannelBuffer.capacity() / this.m_AudioFormat.getChannels())) {
                this.m_ChannelBuffer = DoubleBuffer.allocate((int)longPlayObjectFramesToRead * this.m_AudioFormat.getChannels());
            }
            longPlayObjectFramesToRead = p_IsPreObject ? this.m_PrefetchBufferSceneBridgePre.readPlay(this.m_ChannelBuffer.array(), longFramePosition, longPlayObjectFramesToRead) : this.m_PrefetchBuffer.readPlay(this.m_ChannelBuffer.array(), longFramePosition, longPlayObjectFramesToRead);
            int intFrame = 0;
            while ((long)intFrame < longPlayObjectFramesToRead) {
                boolean boolInside = false;
                double doubleVolume_SoundObject = 1.0;
                doubleFadeProgress = 1.0;
                doubleFadeInProgress = 1.0;
                doubleFadeOutProgress = 0.0;
                long longFramePositionInside = longFramePosition + (long)intFrame - this.m_Description.getFrameStart();
                if (longFramePositionInside > 0L || longFramePositionInside < this.m_Description.getFrameStart() + this.getFrameLengthToPlay()) {
                    boolInside = true;
                    boolWasInside = true;
                }
                if (!boolInside) {
                    doubleFadeInProgress = 0.0;
                    doubleFadeOutProgress = 0.0;
                    doubleFadeProgress = 0.0;
                } else {
                    long longFrameFromEndPosition = this.getFrameLengthToPlay() - longFramePositionInside;
                    long longFrameFromStartPosition = longFramePositionInside > this.getFrameLengthToPlay() - this.m_Description.getFrameFadeOutLength() ? this.getFrameLengthToPlay() - this.m_Description.getFrameFadeOutLength() : longFramePositionInside;
                    doubleFadeInProgress = 1.0;
                    if (this.m_Description.getFrameFadeInLength() > 0L && longFrameFromStartPosition < this.m_Description.getFrameFadeInLength()) {
                        doubleFadeInProgress = (double)longFrameFromStartPosition / (double)this.m_Description.getFrameFadeInLength();
                    }
                    doubleFadeOutProgress = 1.0;
                    if (this.m_Description.getFrameFadeOutLength() > 0L && longFrameFromEndPosition < this.m_Description.getFrameFadeOutLength()) {
                        doubleFadeOutProgress = (double)longFrameFromEndPosition / (double)this.m_Description.getFrameFadeOutLength();
                    }
                    doubleFadeProgress = doubleFadeInProgress * doubleFadeOutProgress;
                    doubleVolume_SoundObject = (double)this.m_Description.getVolumeFactor_Logarithm() * doubleFadeProgress;
                    if (this.m_LiveShowSceneBridge != null) {
                        double doubleVolume_SceneBridge = this.m_LiveShowSceneBridge.calculateFadeProgress(p_SceneBridgeFrameInside + (long)intFrame, p_PlayObject.getFramesToRead(), !p_IsPreObject, p_IsPreObject);
                        doubleVolume_SoundObject *= doubleVolume_SceneBridge;
                    }
                    if (!(doubleVolume_SoundObject <= 0.0)) {
                        intSoundLinesBufferBase = intFrame * SoundMixers.SOUND_SOUNDLINES_COUNT;
                        for (int intChannel = 0; intChannel < intChannelCount; ++intChannel) {
                            int intSound_Channel_LinesCount = o_Sound_Lines.getSound_Channel_LinesCount(intChannel);
                            if (intSound_Channel_LinesCount <= 0) continue;
                            for (int intSoundLineIndex = 0; intSoundLineIndex < intSound_Channel_LinesCount; ++intSoundLineIndex) {
                                double doubleValue_Read;
                                double doubleVolume_SoundLine;
                                SoundMixers.SoundLineFactor o_SoundLineFactor = o_Sound_Lines.getSoundLineFactorByIndex(intChannel, intSoundLineIndex);
                                if (o_SoundLineFactor == null || (doubleVolume_SoundLine = o_SoundLineFactor.getVolumeFactor() * doubleVolume_SoundObject) <= 0.0 || (doubleValue_Read = this.m_ChannelBuffer.get(intFrame * intChannelCount + intChannel)) == 0.0) continue;
                                double doubleValue_SoundLine = o_SoundLinesBuffer.get(intSoundLinesBufferBase + o_SoundLineFactor.getSoundLineNumber());
                                double doubleValue_Result = doubleValue_SoundLine + doubleValue_Read * doubleVolume_SoundLine;
                                o_SoundLinesBuffer.put(intSoundLinesBufferBase + o_SoundLineFactor.getSoundLineNumber(), doubleValue_Result);
                            }
                        }
                    }
                }
                ++intFrame;
            }
        }
        catch (Exception e) {
            this.m_IsPlaying = false;
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return null;
        }
        if (boolWasInside) {
            o_SoundPlayObject.setFadeInProgress(doubleFadeInProgress);
            o_SoundPlayObject.setFadeOutProgress(doubleFadeOutProgress);
            o_SoundPlayObject.setFadeProgress(doubleFadeProgress);
        } else {
            o_SoundPlayObject.setFadeInProgress(0.0);
            o_SoundPlayObject.setFadeOutProgress(0.0);
            o_SoundPlayObject.setFadeProgress(0.0);
        }
        Object object = o_SoundPlayObject.getSyncObjectBuffer();
        synchronized (object) {
            o_SoundPlayObject.getSoundLinesBuffer().position(0);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_SoundPlayObject;
    }

    public LiveShowObjectPanel createLiveShowObjectPanel(boolean p_Resizable) {
        LiveShowSoundObjectPanel o_LiveShowSoundObjectPanel = new LiveShowSoundObjectPanel(this, p_Resizable);
        o_LiveShowSoundObjectPanel.loadSoundGraphicsFile();
        return o_LiveShowSoundObjectPanel;
    }

    public void refreshJumps() {
    }

    public double getFrameTime() {
        return LiveShowVIP.FRAMETIME;
    }

    public ImageIcon getImageIcon() {
        return s_Icon;
    }

    public void setSource(Object p_SourceObject) {
    }

    public Object getSource() {
        return this.m_LiveShowSoundHD;
    }

    public String getSourceAdditionalInfo() {
        if (this.m_LiveShowSoundHD == null) {
            return null;
        }
        return this.m_LiveShowSoundHD.getSoundFileDirectory().getPath();
    }

    public ComboBoxModel getSourceListModel() {
        return null;
    }

    public boolean getSourceIsReplaceable() {
        return false;
    }

    public DefaultListCellRenderer getSourceListRenderer() {
        return null;
    }

    public boolean getFrameOffsetAbility() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("liveShowObject_SourceClose".equals(evt.getPropertyName())) {
            this.close(true);
        }
        super.propertyChange(evt);
    }

    public void notifyObjectListeners_ObjectParameterChanged(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (this.m_ChangedFrameStartOffset_SinceLastNotification) {
            this.m_ResetRestart = true;
        }
        super.notifyObjectListeners_ObjectParameterChanged(p_LiveShowObjectDescription);
    }

    public void eventEndOfAction(LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
        super.eventEndOfAction(p_ActorLiveShowVIP, p_Success, p_Action);
        if (this.m_ResetRestart) {
            this.m_ResetPrefetchDone = false;
            this.m_ResetPrefetchSceneBridgeDone = false;
        }
        this.m_ResetRestart = false;
    }

    public String createToolTipText(boolean p_Complete) {
        StringBuffer o_StringBuffer = new StringBuffer();
        if (p_Complete) {
            o_StringBuffer.append("<html>");
        }
        o_StringBuffer.append("<center>");
        o_StringBuffer.append(LiveShowSoundObjectDescription.DEFAULTNAME);
        o_StringBuffer.append("<br>");
        o_StringBuffer.append("</center>");
        o_StringBuffer.append(super.createToolTipText(false));
        o_StringBuffer.append("<center>");
        o_StringBuffer.append("<table align=center>");
        o_StringBuffer.append("<thead>");
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<th>");
        o_StringBuffer.append("Channel -> ");
        o_StringBuffer.append("</th>");
        o_StringBuffer.append("<th>");
        o_StringBuffer.append("Sound Lines");
        o_StringBuffer.append("</th>");
        o_StringBuffer.append("</tr>");
        o_StringBuffer.append("</thead>");
        o_StringBuffer.append("<tbody>");
        for (int intChannel = 0; intChannel < this.getAudioFormat().getChannels(); ++intChannel) {
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td>");
            o_StringBuffer.append(SoundMixers.getChannelToolTip((int)intChannel));
            o_StringBuffer.append(" -> ");
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("<td>");
            SoundMixers.Sound_Channel_Lines o_Sound_Channel_Lines = this.getSound_Lines().getSound_Channel_Lines(intChannel);
            if (o_Sound_Channel_Lines != null) {
                for (int intIndex = 0; intIndex < o_Sound_Channel_Lines.getSoundLineFactorsCount(); ++intIndex) {
                    SoundMixers.SoundLineFactor o_SoundLineFactor = o_Sound_Channel_Lines.getSoundLineFactorByIndex(intIndex);
                    if (o_SoundLineFactor == null) continue;
                    o_StringBuffer.append(o_SoundLineFactor.getSoundLineNumber() + 1);
                    if (intIndex >= o_Sound_Channel_Lines.getSoundLineFactorsCount() - 1) continue;
                    o_StringBuffer.append(", ");
                }
            }
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("</tr>");
        }
        o_StringBuffer.append("</tbody>");
        o_StringBuffer.append("</table>");
        o_StringBuffer.append("</center>");
        if (p_Complete) {
            o_StringBuffer.append("</html>");
        }
        return o_StringBuffer.toString();
    }
}

