/*
 * Decompiled with CFR 0.152.
 */
package SoundSamplePackage;

import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import SoundPackage.SoundMixers;
import SoundSamplePackage.LiveShowSoundHD;
import SoundTools.LiveShowWaveHeader;
import SoundVirtualPackage.LiveShowSoundObject;
import SoundVirtualPackage.LiveShowSoundSceneBridge;
import SoundVirtualPackage.LiveShowSoundVIP;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;

public class LiveShowSoundTrackbounce
implements SoundMixers.Sound_Lines_Parent {
    public static String ERRORFILE_OVERWRITE = "Cannot overwrite file: ";
    public static String ERRORFILE_OPEN = "Cannot open file for writing: ";
    public static String ERRORFILE_READ = "Cannot open file for reading: ";
    public static String ERRORFILE_WRITE = "Cannot write file: ";
    public static String ERRORFILE_DELETE = "Cannot delete file for overwriting: ";
    private LiveShowSoundVIP m_LiveShowSoundVIP;
    private ArrayList<LiveShowObject> m_LiveShowObjects;
    private ArrayList<FrameBuffer> m_FrameBuffers;
    private ArrayList<LiveShowObject> m_LiveShowSoundSceneBridges;
    private ArrayList<SceneBridgePair> m_SceneBridgePairs;
    private long m_FrameStart;
    private long m_FrameMax;
    private long m_FrameLength;
    private AudioFormat m_AudioFormat_Output;
    private SoundMixers.Sound_Lines m_Sound_Lines_Output;
    private File m_WaveFile;
    private ArrayList<Trackbounce_Listener> m_Trackbounce_Listeners;
    private Thread m_TrackbounceThread;
    private final Object m_SyncListeners = new Object();
    private final Object m_SyncTrackbounce = new Object();

    public LiveShowSoundTrackbounce() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_LiveShowObjects = new ArrayList();
        this.m_LiveShowSoundSceneBridges = new ArrayList();
        this.m_FrameBuffers = new ArrayList();
        this.m_FrameStart = Long.MAX_VALUE;
        this.m_FrameLength = 0L;
        this.m_FrameMax = 0L;
        this.m_Trackbounce_Listeners = new ArrayList();
        this.m_SceneBridgePairs = new ArrayList();
        this.m_Sound_Lines_Output = new SoundMixers.Sound_Lines();
        this.setAudioFormat_Output(SoundMixers.DEFAULT_AUDIOFORMAT.getChannels());
    }

    public void setLiveShowSoundVip(LiveShowSoundVIP p_LiveShowSoundVIP) {
        this.m_LiveShowSoundVIP = p_LiveShowSoundVIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLiveShowObjectInterfaces(ArrayList<LiveShowObjectInterface> p_LiveShowObjectInterfaces) {
        Object object = this.m_SyncTrackbounce;
        synchronized (object) {
            if (p_LiveShowObjectInterfaces == null) {
                return;
            }
            this.m_LiveShowSoundSceneBridges.clear();
            this.m_LiveShowObjects.clear();
            for (int intFrameBuffer = this.m_FrameBuffers.size() - 1; intFrameBuffer >= 0; --intFrameBuffer) {
                FrameBuffer o_FrameBuffer = this.m_FrameBuffers.get(intFrameBuffer);
                if (o_FrameBuffer == null) continue;
                o_FrameBuffer.close();
                this.m_FrameBuffers.remove(o_FrameBuffer);
            }
            this.m_FrameBuffers.clear();
            this.m_FrameStart = -1L;
            this.m_FrameMax = -1L;
            for (int intInterface = 0; intInterface < p_LiveShowObjectInterfaces.size(); ++intInterface) {
                LiveShowObjectInterface o_LiveShowObjectInterface = p_LiveShowObjectInterfaces.get(intInterface);
                if (o_LiveShowObjectInterface instanceof LiveShowSoundSceneBridge) {
                    this.addSortedObject(this.m_LiveShowSoundSceneBridges, (LiveShowObject)o_LiveShowObjectInterface);
                    this.addSortedObject(this.m_LiveShowObjects, (LiveShowObject)o_LiveShowObjectInterface);
                }
                if (!(o_LiveShowObjectInterface instanceof LiveShowSoundObject)) continue;
                this.addSortedObject(this.m_LiveShowObjects, (LiveShowObject)o_LiveShowObjectInterface);
            }
            if (this.m_FrameStart < 0L) {
                this.m_FrameStart = 0L;
            }
            if (this.m_FrameMax < 0L) {
                this.m_FrameMax = 0L;
            }
            this.m_FrameLength = this.m_FrameMax - this.m_FrameStart;
        }
    }

    private void addSortedObject(ArrayList<LiveShowObject> p_LiveShowSoundObjects, LiveShowObject p_LiveShowObject) {
        int intObject;
        if (p_LiveShowSoundObjects == null) {
            return;
        }
        if (p_LiveShowObject == null) {
            return;
        }
        long longFrameStart = p_LiveShowObject.getFrameStart();
        long longFrameEnd = longFrameStart + p_LiveShowObject.getFrameLength();
        if (this.m_FrameStart < 0L) {
            this.m_FrameStart = longFrameStart;
        } else if (this.m_FrameStart > longFrameStart) {
            this.m_FrameStart = longFrameStart;
        }
        if (this.m_FrameMax < 0L) {
            this.m_FrameMax = longFrameEnd;
        } else if (this.m_FrameMax < longFrameEnd) {
            this.m_FrameMax = longFrameEnd;
        }
        if (p_LiveShowSoundObjects.contains(p_LiveShowObject)) {
            return;
        }
        int intSoundObjectPurIndex = 0;
        for (intObject = 0; intObject < p_LiveShowSoundObjects.size(); ++intObject) {
            LiveShowObject o_LiveShowObject = p_LiveShowSoundObjects.get(intObject);
            if (o_LiveShowObject == null) continue;
            if (o_LiveShowObject.getFrameStart() >= p_LiveShowObject.getFrameStart()) break;
            if (o_LiveShowObject instanceof LiveShowSceneBridge) continue;
            ++intSoundObjectPurIndex;
        }
        p_LiveShowSoundObjects.add(intObject, p_LiveShowObject);
        if (p_LiveShowObject instanceof LiveShowSceneBridge) {
            return;
        }
        FrameBuffer o_FrameBuffer = new FrameBuffer(this, (LiveShowSoundObject)p_LiveShowObject);
        this.m_FrameBuffers.add(intSoundObjectPurIndex, o_FrameBuffer);
    }

    public int getLiveShowObjectCount() {
        return this.m_LiveShowObjects.size();
    }

    public LiveShowObject getLiveShowObject(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_LiveShowObjects.size()) {
            return null;
        }
        return this.m_LiveShowObjects.get(p_Index);
    }

    public long getFrameLength() {
        return this.m_FrameLength;
    }

    public long getFrameStart() {
        return this.m_FrameStart;
    }

    public String getTimeLength() {
        if (this.m_LiveShowSoundVIP == null) {
            return "";
        }
        long longFramLength = this.getSelectionFrameLength();
        return this.getString(longFramLength, this.getFrameTime());
    }

    public String getString(long p_Frames, double p_FrameTime) {
        return this.getTimeStringFromMillis((long)((double)p_Frames * p_FrameTime));
    }

    private String getTimeStringFromMillis(long p_Milliseconds) {
        String stringTemp;
        String stringTime = "";
        boolean boolSetString = false;
        int intHours = (int)(p_Milliseconds / 3600000L);
        p_Milliseconds -= (long)(intHours * 3600000);
        if (boolSetString || intHours > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intHours);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
            boolSetString = true;
        }
        int intMinutes = (int)(p_Milliseconds / 60000L);
        p_Milliseconds -= (long)(intMinutes * 60000);
        if (boolSetString || intMinutes > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intMinutes);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
        }
        int intSeconds = (int)(p_Milliseconds / 1000L);
        p_Milliseconds -= (long)(intSeconds * 1000);
        if (boolSetString || intSeconds > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intSeconds);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
        }
        int intMilliseconds = (int)p_Milliseconds;
        stringTemp = "000";
        stringTemp = stringTemp + String.valueOf(intMilliseconds);
        stringTime = stringTime + stringTemp.substring(stringTemp.length() - 3, stringTemp.length());
        return stringTime;
    }

    public double getFrameTime() {
        if (this.m_LiveShowSoundVIP == null) {
            return 0.0;
        }
        AudioFormat o_AudioFormat = this.m_LiveShowSoundVIP.getAudioFormat();
        if (o_AudioFormat == null) {
            return 0.0;
        }
        return 1000.0 / (double)o_AudioFormat.getFrameRate();
    }

    private LiveShowSoundSceneBridge checkSceneBridge(long p_FramePosition) {
        LiveShowSoundSceneBridge o_ActualBridge = null;
        for (int intBridge = 0; intBridge < this.m_LiveShowSoundSceneBridges.size(); ++intBridge) {
            LiveShowSoundSceneBridge o_LiveShowSoundSceneBridge = (LiveShowSoundSceneBridge)this.m_LiveShowSoundSceneBridges.get(intBridge);
            if (o_LiveShowSoundSceneBridge == null || o_LiveShowSoundSceneBridge.getFrameStart() > p_FramePosition || o_LiveShowSoundSceneBridge.getFrameStart() + o_LiveShowSoundSceneBridge.getFrameLength() < p_FramePosition) continue;
            o_ActualBridge = o_LiveShowSoundSceneBridge;
            break;
        }
        return o_ActualBridge;
    }

    public static float calculateFadeInFactor(LiveShowObject p_LiveShowObject, long p_FramePosition) {
        float floatFactor;
        if (p_LiveShowObject == null) {
            return 1.0f;
        }
        if (p_FramePosition < p_LiveShowObject.getFrameStart()) {
            return 1.0f;
        }
        if (p_FramePosition > p_LiveShowObject.getFrameStart() + p_LiveShowObject.getFrameLength()) {
            return 1.0f;
        }
        long longFadeOffset = p_LiveShowObject.getFrameFadeInOffset();
        long longFadeLength = p_LiveShowObject.getFrameFadeInLength();
        if (p_LiveShowObject instanceof LiveShowSceneBridge) {
            long longFrameFromEnd = p_LiveShowObject.getFrameLength() - (p_FramePosition - p_LiveShowObject.getFrameStart());
            if (longFrameFromEnd >= longFadeLength) {
                return 0.0f;
            }
            if (longFrameFromEnd < longFadeOffset) {
                return 1.0f;
            }
            if (longFadeLength - longFadeOffset == 0L) {
                return 1.0f;
            }
            floatFactor = 1.0f - (float)(longFrameFromEnd - longFadeOffset) / (float)(longFadeLength - longFadeOffset);
        } else {
            long longFrameInside = p_FramePosition - p_LiveShowObject.getFrameStart();
            if (longFrameInside < longFadeOffset) {
                return 0.0f;
            }
            if (longFrameInside >= longFadeLength) {
                return 1.0f;
            }
            if (longFadeLength - longFadeOffset == 0L) {
                return 1.0f;
            }
            floatFactor = (float)(longFrameInside - longFadeOffset) / (float)(longFadeLength - longFadeOffset);
        }
        return floatFactor;
    }

    public static float calculateFadeOutFactor(LiveShowObject p_LiveShowObject, long p_FramePosition) {
        float floatFactor;
        if (p_LiveShowObject == null) {
            return 1.0f;
        }
        if (p_FramePosition < p_LiveShowObject.getFrameStart()) {
            return 1.0f;
        }
        if (p_FramePosition > p_LiveShowObject.getFrameStart() + p_LiveShowObject.getFrameLength()) {
            return 1.0f;
        }
        long longFrameFromEnd = p_LiveShowObject.getFrameLength() - (p_FramePosition - p_LiveShowObject.getFrameStart());
        long longFadeOffset = p_LiveShowObject.getFrameFadeOutOffset();
        long longFadeLength = p_LiveShowObject.getFrameFadeOutLength();
        if (p_LiveShowObject instanceof LiveShowSceneBridge) {
            long longFrameInside = p_FramePosition - p_LiveShowObject.getFrameStart();
            if (longFrameInside >= longFadeLength) {
                return 0.0f;
            }
            if (longFrameInside < longFadeOffset) {
                return 1.0f;
            }
            if (longFadeLength - longFadeOffset == 0L) {
                return 0.0f;
            }
            floatFactor = 1.0f - (float)(longFrameInside - longFadeOffset) / (float)(longFadeLength - longFadeOffset);
        } else {
            if (longFrameFromEnd < longFadeOffset) {
                return 0.0f;
            }
            if (longFrameFromEnd >= longFadeLength) {
                return 1.0f;
            }
            if (longFadeLength - longFadeOffset == 0L) {
                return 0.0f;
            }
            floatFactor = (float)(longFrameFromEnd - longFadeOffset) / (float)(longFadeLength - longFadeOffset);
        }
        return floatFactor;
    }

    public static float calculateFadeSceneBridge(LiveShowObject p_LiveShowObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_FramePosition) {
        if (p_LiveShowObject == null) {
            return 1.0f;
        }
        if (p_LiveShowSceneBridge == null) {
            return 1.0f;
        }
        if (p_LiveShowObject.getFrameStart() > p_LiveShowSceneBridge.getFrameEnd()) {
            return 1.0f;
        }
        if (p_LiveShowObject.getFrameEnd() < p_LiveShowSceneBridge.getFrameStart()) {
            return 1.0f;
        }
        boolean boolFadeIn = false;
        boolean boolFadeOut = false;
        float floatFadeIn = 1.0f;
        float floatFadeOut = 1.0f;
        if (p_LiveShowObject.getFrameStart() < p_LiveShowSceneBridge.getFrameStart()) {
            boolFadeOut = true;
        }
        if (p_LiveShowObject.getFrameEnd() > p_LiveShowSceneBridge.getFrameEnd()) {
            boolFadeIn = true;
        }
        if (boolFadeIn) {
            floatFadeIn = LiveShowSoundTrackbounce.calculateFadeInFactor((LiveShowObject)p_LiveShowSceneBridge, p_FramePosition);
        }
        if (boolFadeOut) {
            floatFadeOut = LiveShowSoundTrackbounce.calculateFadeOutFactor((LiveShowObject)p_LiveShowSceneBridge, p_FramePosition);
        }
        if (boolFadeIn && boolFadeOut) {
            if (floatFadeIn + floatFadeOut > 1.0f) {
                return 1.0f;
            }
            return floatFadeIn + floatFadeOut;
        }
        if (boolFadeIn) {
            return floatFadeIn;
        }
        if (boolFadeOut) {
            return floatFadeOut;
        }
        return 1.0f;
    }

    public void setWaveFile(File p_WaveFile) {
        this.m_WaveFile = p_WaveFile;
    }

    public void trackbounce(boolean p_MultipleFiles) {
        if (this.m_WaveFile == null) {
            return;
        }
        if (this.m_LiveShowSoundVIP == null) {
            return;
        }
        if (this.m_TrackbounceThread != null) {
            // empty if block
        }
        if (this.m_SceneBridgePairs.size() <= 0) {
            RunnableTrackbounce_Single o_RunnableTrackbounce = new RunnableTrackbounce_Single(this, this.m_WaveFile);
            this.m_TrackbounceThread = new Thread((Runnable)o_RunnableTrackbounce, this.getClass().getSimpleName() + "_Single");
            this.m_TrackbounceThread.start();
        } else {
            this.setLiveShowObjectInterfaces(this.m_SceneBridgePairs.get(0).getLiveShowObjectInterfaces());
            RunnableTrackbounce_Multi o_RunnableTrackbounceMulti = new RunnableTrackbounce_Multi(this, this.m_WaveFile, this.m_SceneBridgePairs, p_MultipleFiles);
            this.m_TrackbounceThread = new Thread((Runnable)o_RunnableTrackbounceMulti, this.getClass().getSimpleName() + "_Multi");
            this.m_TrackbounceThread.start();
        }
    }

    public void clearSceneBridgePairs() {
        this.m_SceneBridgePairs.clear();
    }

    public void addSceneBridgePair(int p_Index, LiveShowSceneBridge p_SceneBridge_From, LiveShowSceneBridge p_SceneBridge_To) {
        SceneBridgePair o_SceneBridgePair = new SceneBridgePair(this, this.m_LiveShowSoundVIP, p_SceneBridge_From, p_SceneBridge_To);
        this.m_SceneBridgePairs.add(o_SceneBridgePair);
    }

    public void showSelectionInTimeline() {
        LiveShowSoundVIP o_LiveShowSoundVIP = this.m_LiveShowSoundVIP;
        if (o_LiveShowSoundVIP == null) {
            return;
        }
        o_LiveShowSoundVIP.clearSelectedObjects(true);
        if (this.m_SceneBridgePairs.size() >= 0) {
            for (int intPair = 0; intPair < this.m_SceneBridgePairs.size(); ++intPair) {
                SceneBridgePair o_SceneBridgePair = this.m_SceneBridgePairs.get(intPair);
                ArrayList<LiveShowObjectInterface> o_ObjectInterfaces = o_SceneBridgePair.getLiveShowObjectInterfaces();
                if (o_ObjectInterfaces == null) continue;
                for (int intObject = 0; intObject < o_ObjectInterfaces.size(); ++intObject) {
                    o_LiveShowSoundVIP.addSelectedObject(o_ObjectInterfaces.get(intObject));
                }
            }
        } else {
            for (int intObject = 0; intObject < this.m_LiveShowObjects.size(); ++intObject) {
                o_LiveShowSoundVIP.addSelectedObject((LiveShowObjectInterface)this.m_LiveShowObjects.get(intObject));
            }
        }
    }

    public long getSelectionFrameStart() {
        if (this.m_SceneBridgePairs.size() >= 0) {
            long longFrameStart = -1L;
            for (int intPair = 0; intPair < this.m_SceneBridgePairs.size(); ++intPair) {
                SceneBridgePair o_SceneBridgePair = this.m_SceneBridgePairs.get(intPair);
                ArrayList<LiveShowObjectInterface> o_ObjectInterfaces = o_SceneBridgePair.getLiveShowObjectInterfaces();
                if (o_ObjectInterfaces == null) continue;
                for (int intObject = 0; intObject < o_ObjectInterfaces.size(); ++intObject) {
                    LiveShowObjectInterface o_ObjectInterface = o_ObjectInterfaces.get(intObject);
                    if (longFrameStart < 0L) {
                        longFrameStart = o_ObjectInterface.getFrameStart();
                        continue;
                    }
                    if (longFrameStart <= o_ObjectInterface.getFrameStart()) continue;
                    longFrameStart = o_ObjectInterface.getFrameStart();
                }
            }
            return longFrameStart;
        }
        return this.m_FrameStart;
    }

    public long getSelectionFrameLength() {
        if (this.m_SceneBridgePairs.size() > 0) {
            long longFrameEnd = -1L;
            long longFrameStart = -1L;
            for (int intPair = 0; intPair < this.m_SceneBridgePairs.size(); ++intPair) {
                SceneBridgePair o_SceneBridgePair = this.m_SceneBridgePairs.get(intPair);
                ArrayList<LiveShowObjectInterface> o_ObjectInterfaces = o_SceneBridgePair.getLiveShowObjectInterfaces();
                if (o_ObjectInterfaces == null) continue;
                for (int intObject = 0; intObject < o_ObjectInterfaces.size(); ++intObject) {
                    LiveShowObjectInterface o_ObjectInterface = o_ObjectInterfaces.get(intObject);
                    if (o_ObjectInterface == null) continue;
                    if (longFrameStart < 0L) {
                        longFrameStart = o_ObjectInterface.getFrameStart();
                    } else if (longFrameStart > o_ObjectInterface.getFrameStart()) {
                        longFrameStart = o_ObjectInterface.getFrameStart();
                    }
                    if (longFrameEnd < 0L) {
                        longFrameEnd = o_ObjectInterface.getFrameStart() + o_ObjectInterface.getFrameLength();
                        continue;
                    }
                    if (longFrameEnd >= o_ObjectInterface.getFrameStart() + o_ObjectInterface.getFrameLength()) continue;
                    longFrameEnd = o_ObjectInterface.getFrameStart() + o_ObjectInterface.getFrameLength();
                }
            }
            return longFrameEnd - longFrameStart;
        }
        return this.m_FrameLength;
    }

    public String getFileName_Wav(LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return "000_Start.wav";
        }
        LiveShowSoundVIP o_LiveShowSoundVIP = this.m_LiveShowSoundVIP;
        if (o_LiveShowSoundVIP == null) {
            return "null.wav";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int intIndex = o_LiveShowSoundVIP.getLiveShowSceneBridgeNumber(p_LiveShowSceneBridge, false);
        if (++intIndex < 10) {
            stringBuilder.append("00");
        } else if (intIndex < 100) {
            stringBuilder.append("0");
        }
        stringBuilder.append(intIndex);
        stringBuilder.append("_");
        String stringSceneBridgeName = p_LiveShowSceneBridge.getName();
        stringSceneBridgeName = stringSceneBridgeName.replace(" ", "_");
        stringSceneBridgeName = stringSceneBridgeName.replace("\u00df", "ss");
        stringSceneBridgeName = stringSceneBridgeName.replace("\u00e4", "ae");
        stringSceneBridgeName = stringSceneBridgeName.replace("\u00c4", "Ae");
        stringSceneBridgeName = stringSceneBridgeName.replace("\u00fc", "ue");
        stringSceneBridgeName = stringSceneBridgeName.replace("\u00dc", "Ue");
        stringSceneBridgeName = stringSceneBridgeName.replace("\u00f6", "oe");
        stringSceneBridgeName = stringSceneBridgeName.replace("\u00d6", "Oe");
        stringSceneBridgeName = stringSceneBridgeName.replaceAll("\\W", "");
        stringBuilder.append(stringSceneBridgeName);
        stringBuilder.append(".wav");
        return stringBuilder.toString();
    }

    public void trackbounceSceneBridgePairs(File p_WaveDirectory) {
        String stringWaveDirectoryName = p_WaveDirectory != null ? p_WaveDirectory.getAbsolutePath() : "";
        for (int intPair = 0; intPair < this.m_SceneBridgePairs.size(); ++intPair) {
            SceneBridgePair o_SceneBridgePair = this.m_SceneBridgePairs.get(intPair);
            if (o_SceneBridgePair == null) continue;
            ArrayList<LiveShowObjectInterface> o_LiveShowObjectInterfaces = o_SceneBridgePair.getLiveShowObjectInterfaces();
            this.setLiveShowObjectInterfaces(o_LiveShowObjectInterfaces);
            String stringFileName = stringWaveDirectoryName + "/" + o_SceneBridgePair.getFileName();
            RunnableTrackbounce_Single o_RunnableTrackbounce = new RunnableTrackbounce_Single(this, new File(stringFileName));
            this.m_TrackbounceThread = new Thread((Runnable)o_RunnableTrackbounce, this.getClass().getSimpleName() + "_SceneBridgePair");
            this.m_TrackbounceThread.start();
        }
    }

    public void setAudioFormat_Output(int p_Channels) {
        this.m_AudioFormat_Output = new AudioFormat(SoundMixers.DEFAULT_AUDIOFORMAT.getEncoding(), SoundMixers.DEFAULT_AUDIOFORMAT.getSampleRate(), SoundMixers.DEFAULT_AUDIOFORMAT.getSampleSizeInBits(), p_Channels, p_Channels * SoundMixers.DEFAULT_AUDIOFORMAT.getSampleSizeInBits() / 8, SoundMixers.DEFAULT_AUDIOFORMAT.getFrameRate(), SoundMixers.DEFAULT_AUDIOFORMAT.isBigEndian());
        this.m_Sound_Lines_Output.clear();
        this.m_Sound_Lines_Output.setParentChannelCount(p_Channels);
        for (int intChannel = 0; intChannel < p_Channels; ++intChannel) {
            this.m_Sound_Lines_Output.addSoundLineFactor(intChannel, intChannel, 1.0, false);
        }
    }

    public AudioFormat getAudioFormat_Output() {
        return this.m_AudioFormat_Output;
    }

    public SoundMixers.Sound_Lines getSound_Lines() {
        return this.m_Sound_Lines_Output;
    }

    public String getName() {
        return "Trackbouncing";
    }

    public String getSourceName() {
        return "";
    }

    public boolean addSoundLineFactor(int p_MixerChannel, int p_SoundLineNumber, double p_VolumeFactor, boolean p_ProofMixerChannel) {
        return this.m_Sound_Lines_Output.addSoundLineFactor(p_MixerChannel, p_SoundLineNumber, p_VolumeFactor, p_ProofMixerChannel);
    }

    public boolean removeSoundLineFactor(int p_MixerChannel, int p_SoundLineNumber) {
        return this.m_Sound_Lines_Output.removeSoundLineFactor(p_MixerChannel, p_SoundLineNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackbounceRun(File p_WaveFile) {
        Object object = this.m_SyncTrackbounce;
        synchronized (object) {
            if (p_WaveFile == null) {
                return;
            }
            if (this.m_LiveShowSoundVIP == null) {
                return;
            }
            RandomAccessFile o_RandomAccessFile_temp = null;
            AudioFormat o_AudioFormat_Output = this.m_AudioFormat_Output;
            if (o_AudioFormat_Output == null) {
                return;
            }
            ArrayList<Double> o_DoubleValuesChannel = new ArrayList<Double>();
            FrameBuffer o_FrameBuffer_Output = new FrameBuffer(this, o_AudioFormat_Output, (int)(this.m_FrameMax - this.m_FrameStart));
            try {
                FrameBuffer o_FrameBuffer;
                try {
                    if (p_WaveFile.exists()) {
                        o_RandomAccessFile_temp = new RandomAccessFile(p_WaveFile, "rw");
                        o_RandomAccessFile_temp.close();
                        if (!p_WaveFile.delete()) {
                            Exception o_Exception = new Exception(ERRORFILE_DELETE + "\n" + p_WaveFile.getAbsolutePath());
                            this.fireTrackbounceException(o_Exception);
                            return;
                        }
                    }
                    p_WaveFile.createNewFile();
                }
                catch (Exception e) {
                    try {
                        if (o_RandomAccessFile_temp != null) {
                            o_RandomAccessFile_temp.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Exception o_Exception = new Exception(ERRORFILE_OVERWRITE + "\n" + p_WaveFile.getAbsolutePath());
                    this.fireTrackbounceException(o_Exception);
                    return;
                }
                if (o_FrameBuffer_Output.createRandomAccessFile_Write(p_WaveFile) == null) {
                    Exception o_Exception = new Exception(ERRORFILE_OPEN + "\n" + p_WaveFile.getAbsolutePath());
                    this.fireTrackbounceException(o_Exception);
                    return;
                }
                for (int intFrameBuffer = 0; intFrameBuffer < this.m_FrameBuffers.size(); ++intFrameBuffer) {
                    File o_File;
                    o_FrameBuffer = this.m_FrameBuffers.get(intFrameBuffer);
                    if (o_FrameBuffer == null || o_FrameBuffer.createRandomAccessFile_Read() != null) continue;
                    LiveShowSoundObject o_LiveShowSoundObject = o_FrameBuffer.getLiveShowSoundObject();
                    String stringPath = "";
                    LiveShowSoundHD o_LiveShowSoundHD = o_LiveShowSoundObject.getLiveShowSoundHD();
                    if (o_LiveShowSoundHD != null && (o_File = o_LiveShowSoundHD.getSoundFile()) != null) {
                        stringPath = o_File.getAbsolutePath();
                    }
                    Exception o_Exception = new Exception(ERRORFILE_READ + "\n" + stringPath);
                    --intFrameBuffer;
                    while (intFrameBuffer >= 0) {
                        o_FrameBuffer = this.m_FrameBuffers.get(intFrameBuffer);
                        o_FrameBuffer.closeRandomAccessfile();
                        --intFrameBuffer;
                    }
                    o_FrameBuffer_Output.closeRandomAccessfile();
                    this.fireTrackbounceException(o_Exception);
                    return;
                }
                try {
                    o_FrameBuffer_Output.writeWaveHeader(o_FrameBuffer_Output.getRandomAccessFile());
                }
                catch (Exception e) {
                    Exception o_Exception = new Exception(ERRORFILE_WRITE + "\n" + p_WaveFile.getAbsolutePath());
                    o_FrameBuffer_Output.closeRandomAccessfile();
                    this.fireTrackbounceException(o_Exception);
                    return;
                }
                for (int intChannel = 0; intChannel < o_AudioFormat_Output.getChannels(); ++intChannel) {
                    o_DoubleValuesChannel.add(0.0);
                }
                try {
                    for (long longFrame = this.m_FrameStart; longFrame < this.m_FrameMax; ++longFrame) {
                        int intChannel;
                        for (intChannel = 0; intChannel < o_AudioFormat_Output.getChannels(); ++intChannel) {
                            o_DoubleValuesChannel.set(intChannel, 0.0);
                        }
                        for (int intFrameBuffer = 0; intFrameBuffer < this.m_FrameBuffers.size(); ++intFrameBuffer) {
                            o_FrameBuffer = this.m_FrameBuffers.get(intFrameBuffer);
                            if (o_FrameBuffer == null) continue;
                            for (int intChannel2 = 0; intChannel2 < o_AudioFormat_Output.getChannels(); ++intChannel2) {
                                double doubleValue = (Double)o_DoubleValuesChannel.get(intChannel2);
                                o_DoubleValuesChannel.set(intChannel2, doubleValue + o_FrameBuffer.getValue(intChannel2, longFrame));
                            }
                        }
                        for (intChannel = 0; intChannel < o_AudioFormat_Output.getChannels(); ++intChannel) {
                            o_FrameBuffer_Output.setValue(intChannel, (Double)o_DoubleValuesChannel.get(intChannel), longFrame - this.m_FrameStart);
                        }
                        this.fireTrackbounceProgress(longFrame - this.m_FrameStart, this.m_FrameMax - this.m_FrameStart);
                    }
                    o_FrameBuffer_Output.writeBuffer();
                }
                catch (Exception e) {
                    Exception o_Exception = new Exception(ERRORFILE_WRITE + "\n" + p_WaveFile.getAbsolutePath());
                    o_FrameBuffer_Output.closeRandomAccessfile();
                    for (int intFrameBuffer = 0; intFrameBuffer < this.m_FrameBuffers.size(); ++intFrameBuffer) {
                        o_FrameBuffer = this.m_FrameBuffers.get(intFrameBuffer);
                        if (o_FrameBuffer == null) continue;
                        o_FrameBuffer.closeRandomAccessfile();
                    }
                    this.fireTrackbounceException(o_Exception);
                    return;
                }
                o_FrameBuffer_Output.closeRandomAccessfile();
                for (int intFrameBuffer = 0; intFrameBuffer < this.m_FrameBuffers.size(); ++intFrameBuffer) {
                    o_FrameBuffer = this.m_FrameBuffers.get(intFrameBuffer);
                    if (o_FrameBuffer == null) continue;
                    o_FrameBuffer.closeRandomAccessfile();
                }
            }
            catch (Exception e) {
                Exception o_Exception = new Exception(ERRORFILE_WRITE + "\n" + p_WaveFile.getAbsolutePath());
                this.fireTrackbounceException(o_Exception);
            }
        }
        this.m_TrackbounceThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrackbounceListener(Trackbounce_Listener p_Trackbounce_Listener) {
        if (p_Trackbounce_Listener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_Trackbounce_Listeners.contains(p_Trackbounce_Listener)) {
                return;
            }
            this.m_Trackbounce_Listeners.add(p_Trackbounce_Listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrackbounceListener(Trackbounce_Listener p_Trackbounce_Listener) {
        if (p_Trackbounce_Listener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (!this.m_Trackbounce_Listeners.contains(p_Trackbounce_Listener)) {
                return;
            }
            this.m_Trackbounce_Listeners.remove(p_Trackbounce_Listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTrackbounceProgressFiles(int p_IndexFile, int p_CountFiles) {
        ArrayList<Trackbounce_Listener> o_Trackbounce_Listeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            o_Trackbounce_Listeners = new ArrayList<Trackbounce_Listener>();
            o_Trackbounce_Listeners.addAll(this.m_Trackbounce_Listeners);
        }
        for (int intListener = 0; intListener < o_Trackbounce_Listeners.size(); ++intListener) {
            Trackbounce_Listener o_Trackbounce_Listener = (Trackbounce_Listener)o_Trackbounce_Listeners.get(intListener);
            o_Trackbounce_Listener.trackbounceProgress_Files(p_IndexFile, p_CountFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTrackbounceProgress(long p_Position, long p_Length) {
        ArrayList<Trackbounce_Listener> o_Trackbounce_Listeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            o_Trackbounce_Listeners = new ArrayList<Trackbounce_Listener>();
            o_Trackbounce_Listeners.addAll(this.m_Trackbounce_Listeners);
        }
        for (int intListener = 0; intListener < o_Trackbounce_Listeners.size(); ++intListener) {
            Trackbounce_Listener o_Trackbounce_Listener = (Trackbounce_Listener)o_Trackbounce_Listeners.get(intListener);
            o_Trackbounce_Listener.trackbounceProgress(p_Position, p_Length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTrackbounceException(Exception p_Exception) {
        ArrayList<Trackbounce_Listener> o_Trackbounce_Listeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            o_Trackbounce_Listeners = new ArrayList<Trackbounce_Listener>();
            o_Trackbounce_Listeners.addAll(this.m_Trackbounce_Listeners);
        }
        for (int intListener = 0; intListener < o_Trackbounce_Listeners.size(); ++intListener) {
            Trackbounce_Listener o_Trackbounce_Listener = (Trackbounce_Listener)o_Trackbounce_Listeners.get(intListener);
            o_Trackbounce_Listener.trackbounceException(p_Exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTrackbounceReady(LiveShowSoundTrackbounce p_LiveShowSoundTrackbounce) {
        ArrayList<Trackbounce_Listener> o_Trackbounce_Listeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            o_Trackbounce_Listeners = new ArrayList<Trackbounce_Listener>();
            o_Trackbounce_Listeners.addAll(this.m_Trackbounce_Listeners);
        }
        for (int intListener = 0; intListener < o_Trackbounce_Listeners.size(); ++intListener) {
            Trackbounce_Listener o_Trackbounce_Listener = (Trackbounce_Listener)o_Trackbounce_Listeners.get(intListener);
            o_Trackbounce_Listener.trackbounceReady(p_LiveShowSoundTrackbounce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTrackbounceStart(LiveShowSoundTrackbounce p_LiveShowSoundTrackbounce) {
        ArrayList<Trackbounce_Listener> o_Trackbounce_Listeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            o_Trackbounce_Listeners = new ArrayList<Trackbounce_Listener>();
            o_Trackbounce_Listeners.addAll(this.m_Trackbounce_Listeners);
        }
        for (int intListener = 0; intListener < o_Trackbounce_Listeners.size(); ++intListener) {
            Trackbounce_Listener o_Trackbounce_Listener = (Trackbounce_Listener)o_Trackbounce_Listeners.get(intListener);
            o_Trackbounce_Listener.trackbounceStart(p_LiveShowSoundTrackbounce);
        }
    }

    public static class SceneBridgePair {
        private LiveShowSoundTrackbounce m_LiveShowSoundTrackbounce;
        private LiveShowSoundVIP m_LiveShowSoundVIP;
        private LiveShowSceneBridge m_StartSceneBridge;
        private LiveShowSceneBridge m_EndSceneBridge;
        private ArrayList<LiveShowObjectInterface> m_LiveShowObjectInterfaces;
        private long m_FrameStart;
        private long m_frameEnd;
        private long m_FrameLength;
        private String m_FileName;
        private boolean m_ContainsSound;

        public SceneBridgePair(LiveShowSoundTrackbounce p_LiveShowSoundTrackbounce, LiveShowSoundVIP p_LiveShowSoundVIP, LiveShowSceneBridge p_StartSceneBridge, LiveShowSceneBridge p_EndSceneBridge) {
            this.m_LiveShowSoundTrackbounce = p_LiveShowSoundTrackbounce;
            this.m_LiveShowSoundVIP = p_LiveShowSoundVIP;
            this.m_StartSceneBridge = p_StartSceneBridge;
            this.m_EndSceneBridge = p_EndSceneBridge;
            this.m_FrameLength = 0L;
            this.m_FrameStart = -1L;
            this.m_frameEnd = -1L;
            this.m_ContainsSound = false;
            this.calculateParameters();
        }

        private void calculateParameters() {
            if (this.m_LiveShowSoundVIP == null) {
                return;
            }
            if (this.m_LiveShowObjectInterfaces == null) {
                this.m_LiveShowObjectInterfaces = new ArrayList();
            }
            this.m_LiveShowObjectInterfaces.clear();
            if (this.m_StartSceneBridge != null && this.m_EndSceneBridge != null && this.m_StartSceneBridge.getFrameStart() > this.m_EndSceneBridge.getFrameStart()) {
                LiveShowSceneBridge o_LiveShowSceneBridge = this.m_StartSceneBridge;
                this.m_StartSceneBridge = this.m_EndSceneBridge;
                this.m_EndSceneBridge = o_LiveShowSceneBridge;
            }
            int intLiveShowObjectsCount = this.m_LiveShowSoundVIP.getLiveShowObjectInterfaceCount();
            for (int intObject = 0; intObject < intLiveShowObjectsCount; ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowSoundVIP.getLiveShowObjectInterface(intObject);
                if (o_LiveShowObjectInterface == null || this.m_StartSceneBridge != null && o_LiveShowObjectInterface.getFrameStart() < this.m_StartSceneBridge.getFrameStart()) continue;
                if (this.m_EndSceneBridge != null) {
                    if (o_LiveShowObjectInterface == this.m_EndSceneBridge || o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameLength() > this.m_EndSceneBridge.getFrameEnd()) continue;
                    if (o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameLength() > this.m_EndSceneBridge.getFrameStart() && !this.m_LiveShowObjectInterfaces.contains(this.m_EndSceneBridge)) {
                        this.addLiveShowObject((LiveShowObjectInterface)this.m_EndSceneBridge);
                    }
                }
                if (!(o_LiveShowObjectInterface instanceof LiveShowSceneBridge)) {
                    this.m_ContainsSound = true;
                }
                this.addLiveShowObject(o_LiveShowObjectInterface);
            }
            this.m_FrameLength = this.m_frameEnd - this.m_FrameStart;
            this.m_FileName = this.m_LiveShowSoundTrackbounce.getFileName_Wav(this.m_StartSceneBridge);
            boolean intTest = false;
        }

        private void addLiveShowObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
            if (this.m_LiveShowObjectInterfaces.contains(p_LiveShowObjectInterface)) {
                return;
            }
            this.m_LiveShowObjectInterfaces.add(p_LiveShowObjectInterface);
            long longFrameStart = p_LiveShowObjectInterface.getFrameStart();
            long longFrameEnd = longFrameStart + p_LiveShowObjectInterface.getFrameLength();
            if (this.m_FrameStart < 0L) {
                this.m_FrameStart = longFrameStart;
            } else if (this.m_FrameStart > longFrameStart) {
                this.m_FrameStart = longFrameStart;
            }
            if (this.m_frameEnd < 0L) {
                this.m_frameEnd = longFrameEnd;
            } else if (this.m_frameEnd < longFrameEnd) {
                this.m_frameEnd = longFrameEnd;
            }
        }

        public ArrayList<LiveShowObjectInterface> getLiveShowObjectInterfaces() {
            return this.m_LiveShowObjectInterfaces;
        }

        public void setFileName(String p_Name) {
            this.m_FileName = p_Name == null ? "" : p_Name;
        }

        public String getFileName() {
            return this.m_FileName;
        }

        public long getFrameLength() {
            return this.m_FrameLength;
        }

        public boolean getContainsSound() {
            return this.m_ContainsSound;
        }
    }

    public static interface Trackbounce_Listener {
        public void trackbounceProgress_Files(int var1, int var2);

        public void trackbounceProgress(long var1, long var3);

        public void trackbounceException(Exception var1);

        public void trackbounceStart(LiveShowSoundTrackbounce var1);

        public void trackbounceReady(LiveShowSoundTrackbounce var1);
    }

    public static class FrameBuffer {
        public static int BUFFERFRAMESCOUNT = 1764;
        private LiveShowSoundTrackbounce m_LiveShowSoundTrackbounce;
        private LiveShowSoundObject m_LiveShowSoundObject;
        private AudioFormat m_AudioFormat;
        private int m_FrameSize;
        private RandomAccessFile m_RandomAccessFile;
        private LiveShowWaveHeader m_LiveShowWaveHeader;
        private ByteBuffer m_ByteBuffer;
        private DoubleBuffer m_DoubleBuffer_LineValues;
        private long m_Buffered_FrameInternalStart;
        private int m_Buffered_FrameInternalLength;

        public FrameBuffer(LiveShowSoundTrackbounce p_LiveShowSoundTrackbounce, LiveShowSoundObject p_LiveShowSoundObject) {
            this.m_LiveShowSoundTrackbounce = p_LiveShowSoundTrackbounce;
            this.initMembers();
            this.m_LiveShowSoundObject = p_LiveShowSoundObject;
            this.m_AudioFormat = p_LiveShowSoundObject.getAudioFormat();
            this.setAudioFormat();
        }

        public FrameBuffer(LiveShowSoundTrackbounce p_LiveShowSoundTrackbounce, AudioFormat p_AudioFormat, int p_FrameLength) {
            this.m_LiveShowSoundTrackbounce = p_LiveShowSoundTrackbounce;
            this.initMembers();
            this.m_AudioFormat = p_AudioFormat;
            this.setAudioFormat();
            this.m_LiveShowWaveHeader = new LiveShowWaveHeader(p_AudioFormat, p_FrameLength * this.m_AudioFormat.getFrameSize());
        }

        private void initMembers() {
            this.m_LiveShowSoundObject = null;
            this.m_RandomAccessFile = null;
            this.m_DoubleBuffer_LineValues = DoubleBuffer.allocate(SoundMixers.SOUND_SOUNDLINES_COUNT * BUFFERFRAMESCOUNT);
        }

        public void close() {
            if (this.m_ByteBuffer != null) {
                this.m_ByteBuffer.clear();
            }
        }

        private void setAudioFormat() {
            this.m_FrameSize = this.m_AudioFormat.getFrameSize();
            this.m_ByteBuffer = ByteBuffer.allocate(this.m_FrameSize * BUFFERFRAMESCOUNT);
            if (this.m_AudioFormat.isBigEndian()) {
                this.m_ByteBuffer.order(ByteOrder.BIG_ENDIAN);
            } else {
                this.m_ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            this.m_Buffered_FrameInternalStart = 0L;
            this.m_Buffered_FrameInternalLength = 0;
        }

        public AudioFormat getAudioFormat() {
            return this.m_AudioFormat;
        }

        public RandomAccessFile getRandomAccessFile() {
            return this.m_RandomAccessFile;
        }

        public void closeRandomAccessfile() {
            if (this.m_RandomAccessFile == null) {
                return;
            }
            try {
                this.m_RandomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_RandomAccessFile = null;
        }

        public LiveShowSoundObject getLiveShowSoundObject() {
            return this.m_LiveShowSoundObject;
        }

        public RandomAccessFile createRandomAccessFile_Read() {
            if (this.m_LiveShowSoundObject == null) {
                return null;
            }
            this.m_RandomAccessFile = this.m_LiveShowSoundObject.getLiveShowSoundHD().createReadableRandomAccessFile();
            return this.m_RandomAccessFile;
        }

        public boolean readFramesFromFile(long p_FramePosition) {
            if (p_FramePosition < this.m_LiveShowSoundObject.getFrameStart()) {
                return false;
            }
            if (p_FramePosition >= this.m_LiveShowSoundObject.getFrameStart() + this.m_LiveShowSoundObject.getFrameLength()) {
                return false;
            }
            long longInternalPosition = p_FramePosition - this.m_LiveShowSoundObject.getFrameStart();
            long longFirstDataByte = this.m_LiveShowSoundObject.getLiveShowSoundHD().getFirstDataBytePosition();
            long longFilePosition = longFirstDataByte + (this.m_LiveShowSoundObject.getFrameStartOffset() + longInternalPosition) * (long)this.m_FrameSize;
            try {
                int intBytesToRead;
                if (this.m_RandomAccessFile.getFilePointer() != longFilePosition) {
                    this.m_RandomAccessFile.seek(longFilePosition);
                }
                if ((intBytesToRead = (int)(this.m_LiveShowSoundObject.getFrameLength() - longInternalPosition)) > this.m_ByteBuffer.capacity()) {
                    intBytesToRead = this.m_ByteBuffer.capacity();
                }
                int intBytesReaden = 0;
                int intBytesCount = 0;
                this.m_ByteBuffer.clear();
                this.m_ByteBuffer.position(0);
                while (intBytesCount < intBytesToRead) {
                    intBytesReaden = this.m_RandomAccessFile.read(this.m_ByteBuffer.array());
                    if (intBytesReaden < 0) continue;
                    intBytesCount += intBytesReaden;
                }
                this.m_Buffered_FrameInternalStart = longInternalPosition;
                this.m_Buffered_FrameInternalLength = intBytesReaden / this.m_FrameSize;
                int intChannelByteCount = this.m_AudioFormat.getSampleSizeInBits() / 8;
                SoundMixers.Sound_Lines o_Sound_Lines = this.m_LiveShowSoundObject.getSound_Lines();
                this.m_DoubleBuffer_LineValues.clear();
                this.m_DoubleBuffer_LineValues.position(0);
                for (int intFrame = 0; intFrame < this.m_Buffered_FrameInternalLength; ++intFrame) {
                    for (int intLine = 0; intLine < SoundMixers.SOUND_SOUNDLINES_COUNT; ++intLine) {
                        this.m_DoubleBuffer_LineValues.put(intFrame * SoundMixers.SOUND_SOUNDLINES_COUNT + intLine, 0.0);
                    }
                    for (int intChannel = 0; intChannel < this.m_AudioFormat.getChannels(); ++intChannel) {
                        int intByteIndex = intFrame * this.m_FrameSize + intChannel * intChannelByteCount;
                        SoundMixers.Sound_Channel_Lines o_Sound_Channel_Lines = o_Sound_Lines.getSound_Channel_Lines(intChannel);
                        if (o_Sound_Channel_Lines == null) continue;
                        for (int intSoundLineIndex = 0; intSoundLineIndex < o_Sound_Channel_Lines.getSoundLineFactorsCount(); ++intSoundLineIndex) {
                            double doubleSampleValue;
                            SoundMixers.SoundLineFactor o_SoundLineFactor = o_Sound_Channel_Lines.getSoundLineFactorByIndex(intSoundLineIndex);
                            if (o_SoundLineFactor == null) continue;
                            if (this.m_AudioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
                                switch (intChannelByteCount) {
                                    case 1: {
                                        doubleSampleValue = (double)this.m_ByteBuffer.get(intByteIndex) / 256.0;
                                        break;
                                    }
                                    case 2: {
                                        short shortSampleValue = this.m_ByteBuffer.getShort(intByteIndex);
                                        doubleSampleValue = (double)shortSampleValue / 32768.0;
                                        break;
                                    }
                                    case 3: {
                                        int intSampleValue;
                                        byte byteSampleValue;
                                        if (this.m_AudioFormat.isBigEndian()) {
                                            byteSampleValue = this.m_ByteBuffer.get(intByteIndex);
                                            intSampleValue = (byteSampleValue & 0xFF) << 24;
                                            byteSampleValue = this.m_ByteBuffer.get(intByteIndex + 1);
                                            intSampleValue |= (byteSampleValue & 0xFF) << 16;
                                            byteSampleValue = this.m_ByteBuffer.get(intByteIndex + 2);
                                            doubleSampleValue = (double)(intSampleValue |= (byteSampleValue & 0xFF) << 8) / 2.147483648E9;
                                            break;
                                        }
                                        byteSampleValue = this.m_ByteBuffer.get(intByteIndex);
                                        intSampleValue = (byteSampleValue & 0xFF) << 8;
                                        byteSampleValue = this.m_ByteBuffer.get(intByteIndex + 1);
                                        intSampleValue |= (byteSampleValue & 0xFF) << 16;
                                        byteSampleValue = this.m_ByteBuffer.get(intByteIndex + 2);
                                        doubleSampleValue = (double)(intSampleValue |= (byteSampleValue & 0xFF) << 24) / 2.147483648E9;
                                        break;
                                    }
                                    case 4: {
                                        doubleSampleValue = (double)this.m_ByteBuffer.getInt(intByteIndex) / 2.147483648E9;
                                        break;
                                    }
                                    case 8: {
                                        doubleSampleValue = (double)this.m_ByteBuffer.getLong(intByteIndex) / 9.223372036854776E18;
                                        break;
                                    }
                                    default: {
                                        doubleSampleValue = 0.0;
                                        break;
                                    }
                                }
                            } else {
                                doubleSampleValue = this.m_AudioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED ? 0.0 : 0.0;
                            }
                            this.m_DoubleBuffer_LineValues.put(intFrame * SoundMixers.SOUND_SOUNDLINES_COUNT + o_SoundLineFactor.getSoundLineNumber(), doubleSampleValue);
                        }
                    }
                }
            }
            catch (Exception error) {
                return false;
            }
            return true;
        }

        public double getValue(int p_Channel, long p_FramePosition) {
            SoundMixers.Sound_Lines o_Sound_Lines;
            SoundMixers.Sound_Channel_Lines o_Sound_Channel_Lines;
            if (p_Channel < 0) {
                return 0.0;
            }
            double doubleValue = 0.0;
            if (p_FramePosition < this.m_LiveShowSoundObject.getFrameStart()) {
                return 0.0;
            }
            if (p_FramePosition >= this.m_LiveShowSoundObject.getFrameStart() + this.m_LiveShowSoundObject.getFrameLength()) {
                return 0.0;
            }
            long longInternalFramePosition = p_FramePosition - this.m_LiveShowSoundObject.getFrameStart();
            if (longInternalFramePosition < this.m_Buffered_FrameInternalStart || longInternalFramePosition >= this.m_Buffered_FrameInternalStart + (long)this.m_Buffered_FrameInternalLength) {
                this.readFramesFromFile(p_FramePosition);
            }
            float floatVolumeFactor = this.m_LiveShowSoundObject.getVolumeFactor_Logarithm();
            LiveShowSoundSceneBridge o_LiveShowSoundSceneBridge = this.m_LiveShowSoundTrackbounce.checkSceneBridge(p_FramePosition);
            float floatFadeIn = LiveShowSoundTrackbounce.calculateFadeInFactor(this.m_LiveShowSoundObject, p_FramePosition);
            float floatfadeOut = LiveShowSoundTrackbounce.calculateFadeOutFactor(this.m_LiveShowSoundObject, p_FramePosition);
            float floatSceneBridge = 1.0f;
            if (o_LiveShowSoundSceneBridge != null) {
                floatSceneBridge = LiveShowSoundTrackbounce.calculateFadeSceneBridge(this.m_LiveShowSoundObject, o_LiveShowSoundSceneBridge, p_FramePosition);
            }
            if ((o_Sound_Channel_Lines = (o_Sound_Lines = this.m_LiveShowSoundTrackbounce.getSound_Lines()).getSound_Channel_Lines(p_Channel)) == null) {
                return 0.0;
            }
            for (int intIndex = 0; intIndex < o_Sound_Channel_Lines.getSoundLineFactorsCount(); ++intIndex) {
                SoundMixers.SoundLineFactor o_SoundLineFactor = o_Sound_Channel_Lines.getSoundLineFactorByIndex(intIndex);
                if (o_SoundLineFactor == null || o_SoundLineFactor.getVolumeFactor() == 0.0) continue;
                double doubleSampleValue = this.m_DoubleBuffer_LineValues.get((int)(longInternalFramePosition - this.m_Buffered_FrameInternalStart) * SoundMixers.SOUND_SOUNDLINES_COUNT + o_SoundLineFactor.getSoundLineNumber());
                doubleValue += doubleSampleValue * o_SoundLineFactor.getVolumeFactor();
            }
            return doubleValue * (double)floatVolumeFactor * (double)floatFadeIn * (double)floatfadeOut * (double)floatSceneBridge;
        }

        public RandomAccessFile createRandomAccessFile_Write(File p_WaveFile) {
            try {
                RandomAccessFile o_RandomAccessFile = new RandomAccessFile(p_WaveFile, "rw");
                o_RandomAccessFile.seek(0L);
                this.m_RandomAccessFile = o_RandomAccessFile;
            }
            catch (Exception e) {
                this.m_RandomAccessFile = null;
            }
            return this.m_RandomAccessFile;
        }

        public boolean writeWaveHeader(RandomAccessFile p_RandomWaveFile) {
            if (this.m_LiveShowWaveHeader == null) {
                return false;
            }
            return LiveShowWaveHeader.writeWaveHeader(p_RandomWaveFile, this.m_LiveShowWaveHeader);
        }

        public void setValue(int p_Channel, double p_Value, long p_FramePositionInternal) {
            if (p_Channel < 0 || p_Channel >= this.m_AudioFormat.getChannels()) {
                return;
            }
            double doubleValue = p_Value;
            if (doubleValue < -1.0) {
                doubleValue = -1.0;
            }
            if (doubleValue > 1.0) {
                doubleValue = 1.0;
            }
            if (p_FramePositionInternal - this.m_Buffered_FrameInternalStart >= (long)BUFFERFRAMESCOUNT) {
                this.writeBuffer();
            }
            int intChannelByteCount = this.m_AudioFormat.getSampleSizeInBits() / 8;
            int intByteIndex = (int)(p_FramePositionInternal - this.m_Buffered_FrameInternalStart) * this.m_FrameSize + intChannelByteCount * p_Channel;
            try {
                this.m_ByteBuffer.position(intByteIndex);
                switch (intChannelByteCount) {
                    case 1: {
                        this.m_ByteBuffer.put((byte)(doubleValue * 255.0));
                        break;
                    }
                    case 2: {
                        this.m_ByteBuffer.putShort((short)(doubleValue * 32767.0));
                        break;
                    }
                    case 3: {
                        int intValue = (int)(doubleValue * 2.147483647E9);
                        if (this.m_AudioFormat.isBigEndian()) {
                            this.m_ByteBuffer.put((byte)(intValue >> 24));
                            this.m_ByteBuffer.put((byte)(intValue >> 16));
                            this.m_ByteBuffer.put((byte)(intValue >> 8));
                            break;
                        }
                        this.m_ByteBuffer.put((byte)(intValue >> 8));
                        this.m_ByteBuffer.put((byte)(intValue >> 16));
                        this.m_ByteBuffer.put((byte)(intValue >> 24));
                        break;
                    }
                    case 4: {
                        this.m_ByteBuffer.putInt((int)(doubleValue * 2.147483647E9));
                        break;
                    }
                    case 8: {
                        this.m_ByteBuffer.putLong((long)(doubleValue * 9.223372036854776E18));
                    }
                }
                this.m_Buffered_FrameInternalLength = (int)(p_FramePositionInternal - this.m_Buffered_FrameInternalStart) + 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean writeBuffer() {
            int intByteIndex = 0;
            int intBytesToWrite = this.m_Buffered_FrameInternalLength * this.m_FrameSize;
            long longFirstDataByte = this.m_LiveShowWaveHeader.getFirstDataBytePosition();
            long longFilePosition = longFirstDataByte + this.m_Buffered_FrameInternalStart * (long)this.m_FrameSize;
            try {
                if (this.m_RandomAccessFile.getFilePointer() != longFilePosition) {
                    this.m_RandomAccessFile.seek(longFilePosition);
                }
                this.m_RandomAccessFile.write(this.m_ByteBuffer.array(), intByteIndex, intBytesToWrite);
                this.m_Buffered_FrameInternalStart += (long)this.m_Buffered_FrameInternalLength;
                this.m_Buffered_FrameInternalLength = 0;
            }
            catch (Exception error) {
                return false;
            }
            return true;
        }
    }

    public static class RunnableTrackbounce_Multi
    implements Runnable {
        LiveShowSoundTrackbounce m_LiveShowSoundTrackbounce;
        File m_WaveFile;
        ArrayList<SceneBridgePair> m_SceneBridgePairs;
        boolean m_WriteInMultipleFiles;

        public RunnableTrackbounce_Multi(LiveShowSoundTrackbounce p_LiveShowSoundTrackbounce, File p_WaveFile, ArrayList<SceneBridgePair> p_SceneBridgePairs, boolean p_MultipleFiles) {
            this.m_LiveShowSoundTrackbounce = p_LiveShowSoundTrackbounce;
            this.m_WaveFile = p_WaveFile;
            this.m_SceneBridgePairs = p_SceneBridgePairs;
            this.m_WriteInMultipleFiles = p_MultipleFiles;
        }

        @Override
        public void run() {
            if (this.m_WaveFile == null) {
                return;
            }
            File o_Directory = this.m_WaveFile.isDirectory() ? this.m_WaveFile : this.m_WaveFile.getParentFile();
            this.m_LiveShowSoundTrackbounce.fireTrackbounceStart(this.m_LiveShowSoundTrackbounce);
            this.m_LiveShowSoundTrackbounce.fireTrackbounceProgressFiles(0, this.m_SceneBridgePairs.size());
            for (int intPair = 0; intPair < this.m_SceneBridgePairs.size(); ++intPair) {
                SceneBridgePair o_SceneBridgePair = this.m_SceneBridgePairs.get(intPair);
                if (o_SceneBridgePair == null) continue;
                if (o_SceneBridgePair.getContainsSound()) {
                    this.m_LiveShowSoundTrackbounce.setLiveShowObjectInterfaces(o_SceneBridgePair.getLiveShowObjectInterfaces());
                    File o_WaveFile = this.m_SceneBridgePairs.size() > 1 || this.m_WriteInMultipleFiles ? (o_Directory != null ? new File(o_Directory.getAbsoluteFile() + "/" + o_SceneBridgePair.getFileName()) : new File(o_SceneBridgePair.getFileName())) : this.m_WaveFile;
                    this.m_LiveShowSoundTrackbounce.trackbounceRun(o_WaveFile);
                }
                this.m_LiveShowSoundTrackbounce.fireTrackbounceProgressFiles(intPair + 1, this.m_SceneBridgePairs.size());
            }
            this.m_LiveShowSoundTrackbounce.fireTrackbounceReady(this.m_LiveShowSoundTrackbounce);
        }
    }

    public static class RunnableTrackbounce_Single
    implements Runnable {
        LiveShowSoundTrackbounce m_LiveShowSoundTrackbounce;
        File m_WaveFile;

        public RunnableTrackbounce_Single(LiveShowSoundTrackbounce p_LiveShowSoundTrackbounce, File p_WaveFile) {
            this.m_LiveShowSoundTrackbounce = p_LiveShowSoundTrackbounce;
            this.m_WaveFile = p_WaveFile;
        }

        @Override
        public void run() {
            this.m_LiveShowSoundTrackbounce.fireTrackbounceStart(this.m_LiveShowSoundTrackbounce);
            this.m_LiveShowSoundTrackbounce.fireTrackbounceProgressFiles(0, 1);
            this.m_LiveShowSoundTrackbounce.trackbounceRun(this.m_WaveFile);
            this.m_LiveShowSoundTrackbounce.fireTrackbounceProgressFiles(1, 1);
            this.m_LiveShowSoundTrackbounce.fireTrackbounceReady(this.m_LiveShowSoundTrackbounce);
        }
    }
}

