/*
 * Decompiled with CFR 0.152.
 */
package SoundSamplePackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageListener;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowDragDrop;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayControlCursor;
import LiveShowPlayPackage.PlayControlPanel;
import LiveShowPlayPackage.PlayControlTimePanel;
import LiveShowPlayPackage.PlayJumpInterface;
import LiveShowPlayPackage.PlayListener;
import LiveShowScrollPackage.LiveShowMarkControlPanel;
import LiveShowScrollPackage.LiveShowScrollBarListener;
import LiveShowScrollPackage.LiveShowScrollBarPanel;
import LiveShowScrollPackage.LiveShowTimeBar;
import LiveShowScrollPackage.LiveShowViewListener;
import LiveShowVirtualPackage.LiveShowVIP;
import PlaySoundPackage.PlaySound;
import SoundPackage.SoundMixers;
import SoundPackage.Sound_Channel_LinesPanel;
import SoundSamplePackage.LiveShowSoundHD;
import SoundVirtualPackage.LiveShowSoundObject;
import SoundVirtualPackage.LiveShowSoundObjectDescription;
import SoundVirtualPackage.LiveShowSoundObjectPanel;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import SynchronizationPackage.LiveCloseSemaphore;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class LiveShowSoundHDPanel
extends JPanel
implements ComponentListener,
PlayListener,
MouseInputListener,
MouseWheelListener,
LiveShowScrollBarListener,
DragGestureListener,
DragSourceListener,
PropertyChangeListener {
    public static ImageIcon s_Icon_MenuSoundSettings = new ImageIcon(Sound_Channel_LinesPanel.class.getResource("/IconsPackage/Menu_SoundcardSettings.png"));
    @LiveLanguageString
    public static String LABEL_START = "Start";
    @LiveLanguageString
    public static String LABEL_END = "End";
    @LiveLanguageString
    public static String LABEL_DURATION = "Duration";
    private LiveShowSoundHD m_LiveShowSoundHD;
    private LiveShowSoundObject m_LiveShowSoundObject;
    private LiveShowSoundObjectPanel m_LiveShowSoundObjectPanel;
    private PlaySound m_PlaySound;
    private Play.PlaySynchronisizer m_PlaySynchronisizer;
    private long m_SoundObjectFrameStart;
    private long m_SoundObjectFrameEnd;
    private long m_VisibleFrameStart;
    private long m_VisibleFrameEnd;
    private long m_FramePlayCursor;
    private PlayControlCursor m_LiveShowSoundPlayCursor;
    private Section m_Section;
    private PlayControlPanel m_PlayControlPanel;
    private PlayControlTimePanel m_PlayControlTimePanel;
    private LiveShowMarkControlPanel m_LiveShowMarkControlPanel;
    private LiveShowScrollBarPanel m_LiveShowScrollBarPanel;
    private JLabel m_JLabel_SoundSettings;
    private JLabel_ResizeFrame m_JLabel_ResizeFrame;
    public static Color BUTTON_DEFAULTBACKGROUND;
    private ArrayList<LiveShowViewListener> m_LiveShowViewListeners;
    private DragSource m_DragSource;
    private boolean m_DragStarted;
    private LiveCloseSemaphore m_LiveCloseSemaphore;
    private final Object m_SyncViewListeners = new Object();
    private Dimension m_OldSize_jPanel_SoundView;
    private Runnable m_Runnable_EventPlayCursor = new Runnable(){

        @Override
        public void run() {
            try {
                LiveShowSoundHDPanel.this.calculatePlayCursor();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    };
    private Runnable m_Runnable_Revalidate_JPanel_SoundView = new Runnable(){

        @Override
        public void run() {
            try {
                LiveShowSoundHDPanel.this.jPanel_SoundView.revalidate();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    };
    private boolean isSettingZoom = false;
    private Runnable m_RunnableEndZoom = new Runnable(){

        @Override
        public void run() {
            LiveShowSoundHDPanel.this.isSettingZoom = false;
        }
    };
    private JPanel jPanel_Mark;
    private JPanel jPanel_PlayControl;
    private JPanel jPanel_SoundView;
    private LiveShowTimeBar liveShowTimeBar1;

    public LiveShowSoundHDPanel(LiveShowSoundHD p_LiveShowSoundHD) {
        String stringFileName;
        this.initMembers();
        this.m_LiveShowSoundHD = p_LiveShowSoundHD;
        if (this.m_LiveShowSoundHD == null) {
            return;
        }
        this.m_LiveShowSoundHD.addReference(this);
        this.m_LiveShowSoundObject = this.m_LiveShowSoundHD.getLiveShowSoundObject();
        this.setOutputSound_Lines();
        this.m_SoundObjectFrameStart = 0L;
        this.m_SoundObjectFrameEnd = this.m_LiveShowSoundHD.getFrameLength();
        this.m_VisibleFrameStart = this.m_SoundObjectFrameStart;
        this.m_VisibleFrameEnd = this.m_SoundObjectFrameEnd;
        this.initComponents();
        this.m_PlaySynchronisizer = new Play.PlaySynchronisizer();
        this.m_PlaySound = new PlaySound(this.m_LiveShowSoundHD, this.m_LiveShowSoundHD.getAudioFormat());
        this.m_PlaySound.setPlaySynchronizer(this.m_PlaySynchronisizer);
        this.m_PlaySound.createOutputLine();
        this.m_PlaySound.addPlayListener(this);
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.setVisibleRegion(this.m_VisibleFrameStart, this.m_VisibleFrameEnd);
        this.m_LiveShowScrollBarPanel.addLiveShowScrollBarListener((LiveShowScrollBarListener)this);
        this.addLiveShowViewListener((LiveShowViewListener)this.m_LiveShowScrollBarPanel);
        if (this.m_PlaySound != null) {
            this.m_PlaySound.addPlayListener((PlayListener)this.m_LiveShowScrollBarPanel);
        }
        if ((stringFileName = this.liveShowTimeBar1.calculateMarksFilePath(this.m_LiveShowSoundHD.getSoundFile())) != null) {
            File o_FileMarks = new File(stringFileName);
            this.liveShowTimeBar1.readMarks(o_FileMarks);
        }
        this.notifySoundObjectViewListeners_ViewChanged(this.getFrameStart(), this.getFrameEnd(), this.m_VisibleFrameStart, this.m_VisibleFrameEnd, this.jPanel_SoundView.getBounds());
        SoundMixers.s_JDialog_Sound_Lines_Preview.addPropertyChangeListener("changedSoundLines", (PropertyChangeListener)this);
    }

    private void initMembers() {
        BUTTON_DEFAULTBACKGROUND = new Color(240, 240, 240);
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_LiveShowViewListeners = new ArrayList();
        this.m_FramePlayCursor = 0L;
        this.m_Section = null;
        this.m_LiveShowSoundObject = null;
        this.m_OldSize_jPanel_SoundView = new Dimension(0, 0);
        this.m_DragStarted = false;
    }

    private void initComponentsFurther() {
        this.m_LiveShowScrollBarPanel = new LiveShowScrollBarPanel();
        this.m_LiveShowScrollBarPanel.setZoomChange(1.5);
        GridBagConstraints o_Constraints = new GridBagConstraints();
        o_Constraints.gridx = 1;
        o_Constraints.gridy = 2;
        o_Constraints.weightx = 1.0;
        o_Constraints.fill = 2;
        o_Constraints.anchor = 11;
        this.m_LiveShowScrollBarPanel.setVisible(true);
        this.add((Component)this.m_LiveShowScrollBarPanel, o_Constraints);
        this.m_JLabel_SoundSettings = new JLabel();
        this.m_JLabel_SoundSettings.setIcon(s_Icon_MenuSoundSettings);
        this.m_JLabel_SoundSettings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LiveShowSoundHDPanel.this.showSound_Lines_Settings();
            }
        });
        o_Constraints = new GridBagConstraints();
        o_Constraints.gridx = 2;
        o_Constraints.gridy = 2;
        o_Constraints.weightx = 0.0;
        o_Constraints.insets = new Insets(0, 3, 0, 3);
        o_Constraints.anchor = 10;
        this.add((Component)this.m_JLabel_SoundSettings, o_Constraints);
        this.m_JLabel_ResizeFrame = new JLabel_ResizeFrame();
        o_Constraints = new GridBagConstraints();
        o_Constraints.gridx = 3;
        o_Constraints.gridy = 2;
        o_Constraints.weightx = 0.0;
        o_Constraints.anchor = 14;
        this.m_JLabel_ResizeFrame.setVisible(true);
        this.add((Component)this.m_JLabel_ResizeFrame, o_Constraints);
        this.m_LiveShowMarkControlPanel = new LiveShowMarkControlPanel(this.liveShowTimeBar1);
        o_Constraints = new GridBagConstraints();
        o_Constraints.gridx = 0;
        o_Constraints.gridy = 0;
        o_Constraints.fill = 1;
        o_Constraints.anchor = 11;
        this.m_LiveShowMarkControlPanel.setVisible(true);
        this.jPanel_Mark.add((Component)this.m_LiveShowMarkControlPanel, o_Constraints);
        this.m_PlayControlTimePanel = new PlayControlTimePanel((Play)this.m_PlaySound, false, false);
        o_Constraints = new GridBagConstraints();
        o_Constraints.gridx = 0;
        o_Constraints.gridy = 0;
        o_Constraints.fill = 2;
        o_Constraints.anchor = 11;
        this.m_PlayControlTimePanel.setVisible(true);
        this.m_PlayControlTimePanel.setMinimumSize(new Dimension(90, 40));
        this.m_PlayControlTimePanel.setPreferredSize(new Dimension(90, 40));
        this.jPanel_PlayControl.add((Component)this.m_PlayControlTimePanel, o_Constraints);
        this.m_PlayControlPanel = this.m_PlaySound != null ? new PlayControlPanel(this.m_PlaySound.getPlaySynchronizer(), 2, true, true, true, true, true, true, false, false, false, false) : new PlayControlPanel(null, 2, true, true, true, true, true, true, false, false, false, false);
        this.m_PlayControlPanel.addPlay((Play)this.m_PlaySound);
        o_Constraints = new GridBagConstraints();
        o_Constraints.gridx = 0;
        o_Constraints.gridy = 1;
        o_Constraints.fill = 2;
        o_Constraints.anchor = 11;
        this.m_PlayControlPanel.setVisible(true);
        this.jPanel_PlayControl.add((Component)this.m_PlayControlPanel, o_Constraints);
        this.jPanel_SoundView.setBackground(Color.GRAY);
        this.m_LiveShowSoundObjectPanel = new LiveShowSoundObjectPanel(this.m_LiveShowSoundObject, false);
        this.m_LiveShowSoundObjectPanel.loadSoundGraphicsFile();
        this.addLiveShowViewListener((LiveShowViewListener)this.m_LiveShowSoundObjectPanel);
        this.jPanel_SoundView.add((Component)((Object)this.m_LiveShowSoundObjectPanel), this.m_LiveShowSoundObjectPanel.getAbsoluteConstraints());
        this.m_LiveShowSoundObjectPanel.setVisible(true);
        this.m_LiveShowSoundPlayCursor = new PlayControlCursor();
        this.jPanel_SoundView.add((Component)this.m_LiveShowSoundPlayCursor, this.m_LiveShowSoundPlayCursor.getAbsoluteConstraints(), 0);
        this.m_LiveShowSoundPlayCursor.setVisible(true);
        this.jPanel_SoundView.addComponentListener(this);
        this.m_LiveShowSoundObjectPanel.addMouseMotionListener(this);
        this.m_LiveShowSoundObjectPanel.addMouseListener(this);
        this.m_LiveShowSoundObjectPanel.addMouseWheelListener(this);
        this.m_DragSource = new DragSource();
        LiveShowDragDrop.LiveShowGestureRecognizer o_DragGestureRecognizer = new LiveShowDragDrop.LiveShowGestureRecognizer(this.m_DragSource, (JComponent)((Object)this.m_LiveShowSoundObjectPanel), 2, (DragGestureListener)this, 2);
        this.liveShowTimeBar1.addPlay((Play)this.m_PlaySound);
        this.addLiveShowViewListener((LiveShowViewListener)this.liveShowTimeBar1);
        this.m_JLabel_SoundSettings.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.revalidate();
    }

    public void close() {
        SoundMixers.s_JDialog_Sound_Lines_Preview.removePropertyChangeListener((PropertyChangeListener)this);
        this.m_JLabel_SoundSettings.setComponentPopupMenu(null);
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        LiveLanguage.removeLanguageListener((Object)this);
        EventQueueHandler.removeRunnable((Runnable)this.m_Runnable_EventPlayCursor);
        this.saveMarks();
        this.m_JLabel_ResizeFrame.setContainer(null);
        if (this.m_LiveShowSoundHD != null && this.m_PlaySound != null) {
            if (this.m_PlayControlPanel != null) {
                this.m_PlayControlPanel.actionPlayStop();
                this.m_PlayControlPanel.removePlay((Play)this.m_PlaySound);
                this.m_PlayControlPanel.close();
            }
            this.m_PlaySound.removePlayListener(this);
            this.m_PlaySound.removePlayListener((PlayListener)this.m_LiveShowScrollBarPanel);
            this.m_PlaySound.close();
        }
        if (this.m_LiveShowScrollBarPanel != null) {
            this.m_LiveShowScrollBarPanel.removeLiveShowScrollBarListener((LiveShowScrollBarListener)this);
        }
        this.removeLiveShowViewListener((LiveShowViewListener)this.m_LiveShowScrollBarPanel);
        if (this.m_LiveShowSoundObjectPanel != null) {
            this.removeLiveShowViewListener((LiveShowViewListener)this.m_LiveShowSoundObjectPanel);
            this.m_LiveShowSoundObjectPanel.close();
            this.m_LiveShowSoundObjectPanel = null;
        }
        this.removeLiveShowViewListener((LiveShowViewListener)this.liveShowTimeBar1);
        this.liveShowTimeBar1.close();
        if (this.m_LiveShowSoundHD != null) {
            this.m_LiveShowSoundHD.removeReference(this, true);
            if (this.m_PlaySound != null) {
                this.m_PlaySound.closeOutputLine();
            }
        }
        if (this.m_LiveShowMarkControlPanel != null) {
            this.m_LiveShowMarkControlPanel.close();
        }
        LiveLanguage.removeLanguageListener((Object)this);
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public void showSound_Lines_Settings() {
        SoundMixers.s_JDialog_Sound_Lines_Preview.setVisible(true);
    }

    private void setOutputSound_Lines() {
        SoundMixers.Sound_Lines o_Sound_Lines;
        if (this.m_LiveShowSoundObject != null && (o_Sound_Lines = ((LiveShowSoundObjectDescription)this.m_LiveShowSoundObject.getDescription()).getSound_Lines()) != null) {
            o_Sound_Lines.clear();
            o_Sound_Lines.setParentChannelCount(this.m_LiveShowSoundObject.getAudioFormat().getChannels());
            for (int intChannel = 0; intChannel < this.m_LiveShowSoundObject.getAudioFormat().getChannels(); ++intChannel) {
                SoundMixers.Sound_Channel_Lines o_Sound_Channel_Lines_Default = SoundMixers.s_Sound_Lines_Preview.getSound_Channel_Lines(intChannel);
                if (o_Sound_Channel_Lines_Default == null) continue;
                for (int intFactor = 0; intFactor < o_Sound_Channel_Lines_Default.getSoundLineFactorsCount(); ++intFactor) {
                    SoundMixers.SoundLineFactor o_SoundLineFactor_Default = o_Sound_Channel_Lines_Default.getSoundLineFactorByIndex(intFactor);
                    if (o_SoundLineFactor_Default == null) continue;
                    o_Sound_Lines.addSoundLineFactor(intChannel, o_SoundLineFactor_Default.getSoundLineNumber(), o_SoundLineFactor_Default.getVolumeFactor(), false);
                }
            }
        }
    }

    public boolean getMarksChanged() {
        if (this.liveShowTimeBar1 == null) {
            return false;
        }
        return this.liveShowTimeBar1.getMarksChanged();
    }

    public void saveMarks() {
        String stringFileName;
        if (this.liveShowTimeBar1 != null && (stringFileName = this.liveShowTimeBar1.calculateMarksFilePath(this.m_LiveShowSoundHD.getSoundFile())) != null) {
            File o_FileMarks = new File(stringFileName);
            this.liveShowTimeBar1.saveMarks(o_FileMarks);
        }
    }

    public LiveShowSoundHD getLiveShowSoundHD() {
        return this.m_LiveShowSoundHD;
    }

    public LiveShowSoundObject getLiveShowSoundObject() {
        return this.m_LiveShowSoundObject;
    }

    public LiveShowTimeBar getLiveShowTimeBar() {
        return this.liveShowTimeBar1;
    }

    public JLabel_ResizeFrame getLabelResizeFrame() {
        return this.m_JLabel_ResizeFrame;
    }

    public JPanel getSoundObjectViewContainer() {
        return this.jPanel_SoundView;
    }

    public boolean getIsSetingZoom() {
        return this.isSettingZoom;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int intX = e.getX();
        if (this.isSettingZoom) {
            return;
        }
        long longFramePosition = this.m_LiveShowSoundObjectPanel.getPositionFrame(intX);
        if (e.getWheelRotation() > 0) {
            this.zoomMinus(false, longFramePosition);
        } else if (e.getWheelRotation() < 0) {
            this.zoomPlus(false, longFramePosition);
        }
    }

    public void zoomPlus(boolean p_AdjustFramePosition, long p_FramePosition) {
        this.isSettingZoom = true;
        this.m_LiveShowScrollBarPanel.zoomPlus(p_AdjustFramePosition, p_FramePosition);
        EventQueueHandler.invokeLater((Runnable)this.m_RunnableEndZoom);
    }

    public void zoomMinus(boolean p_AdjustFramePosition, long p_FramePosition) {
        this.isSettingZoom = true;
        this.m_LiveShowScrollBarPanel.zoomMinus(p_AdjustFramePosition, p_FramePosition);
        EventQueueHandler.invokeLater((Runnable)this.m_RunnableEndZoom);
    }

    public double getFramesPerPoint() {
        return this.m_LiveShowSoundObjectPanel.getFramesPerPoint();
    }

    public long getPositionFrame(Point p_Point) {
        return this.getPositionFrame(p_Point.x);
    }

    public long getPositionFrame(int p_X) {
        long longFrame = (long)((double)p_X * this.getFramesPerPoint());
        return longFrame;
    }

    public int getPositionX(long p_Frame) {
        double doubleFramesPerPoint;
        if (p_Frame < this.m_SoundObjectFrameStart) {
            p_Frame = this.m_SoundObjectFrameStart;
        }
        if (p_Frame > this.m_SoundObjectFrameEnd) {
            p_Frame = this.m_SoundObjectFrameEnd;
        }
        int intX = (doubleFramesPerPoint = this.getFramesPerPoint()) <= 0.0 ? 0 : (int)((double)p_Frame / this.getFramesPerPoint());
        return intX;
    }

    public void setVisibleRegion(long p_VisibleFrameStart, long p_VisibleFrameEnd) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        long longFrameLength = p_VisibleFrameEnd - p_VisibleFrameStart;
        if (longFrameLength > this.m_SoundObjectFrameEnd - this.m_SoundObjectFrameStart) {
            longFrameLength = this.m_SoundObjectFrameEnd - this.m_SoundObjectFrameStart;
        }
        if (p_VisibleFrameStart < this.m_SoundObjectFrameStart) {
            p_VisibleFrameStart = this.m_SoundObjectFrameStart;
            p_VisibleFrameEnd = p_VisibleFrameStart + longFrameLength;
        }
        if (p_VisibleFrameEnd > this.m_SoundObjectFrameEnd) {
            p_VisibleFrameEnd = this.m_SoundObjectFrameEnd;
            p_VisibleFrameStart = p_VisibleFrameEnd - longFrameLength;
        }
        if (p_VisibleFrameStart != this.m_VisibleFrameStart || p_VisibleFrameEnd != this.m_VisibleFrameEnd) {
            this.m_VisibleFrameStart = p_VisibleFrameStart;
            this.m_VisibleFrameEnd = p_VisibleFrameEnd;
            this.notifySoundObjectViewListeners_ViewChanged(this.getFrameStart(), this.getFrameEnd(), this.m_VisibleFrameStart, this.m_VisibleFrameEnd, this.jPanel_SoundView.getBounds());
            this.jPanel_SoundView.revalidate();
        }
        this.calculatePlayCursor();
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public long getVisibleFrameStart() {
        return this.m_VisibleFrameStart;
    }

    public long getVisibleFrameEnd() {
        return this.m_VisibleFrameEnd;
    }

    public long getFrameStart() {
        return 0L;
    }

    public long getFrameEnd() {
        return this.m_LiveShowSoundHD.getFrameLength();
    }

    public void setSection(long p_FrameStart, long p_FrameEnd) {
        this.deleteSection();
        if (p_FrameStart < 0L || p_FrameEnd < 0L) {
            this.m_Section = null;
            if (this.m_PlaySound != null) {
                this.m_PlaySound.setActualPlayJump(this.m_Section);
            }
            return;
        }
        this.m_Section = new Section(this, p_FrameStart);
        this.m_Section.setFrameEnd(p_FrameEnd);
        if (this.m_PlaySound != null) {
            this.m_PlaySound.setActualPlayJump(this.m_Section);
        }
    }

    public void deleteSection() {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_Section != null) {
            this.m_Section.close();
            this.m_Section = null;
            if (this.m_PlaySound != null) {
                this.m_PlaySound.setActualPlayJump(this.m_Section);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLiveShowViewListener(LiveShowViewListener p_Listener) {
        if (p_Listener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAdded = false;
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners != null && !this.m_LiveShowViewListeners.contains(p_Listener)) {
                this.m_LiveShowViewListeners.add(p_Listener);
                p_Listener.eventViewChanged(this.getFrameStart(), this.getFrameEnd(), this.m_VisibleFrameStart, this.m_VisibleFrameEnd, this.jPanel_SoundView.getBounds());
                boolAdded = true;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLiveShowViewListener(LiveShowViewListener p_Listener) {
        if (p_Listener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners != null) {
                boolRemoved = this.m_LiveShowViewListeners.remove(p_Listener);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySoundObjectViewListeners_ViewChanged(long p_FrameStart, long p_FrameEnd, long p_VisibleFrameStart, long p_VisibleFrameEnd, Rectangle p_Bounds) {
        ArrayList<LiveShowViewListener> o_LiveShowViewListeners;
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners == null) {
                return;
            }
            o_LiveShowViewListeners = new ArrayList<LiveShowViewListener>(this.m_LiveShowViewListeners.size());
            o_LiveShowViewListeners.addAll(this.m_LiveShowViewListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowViewListeners.size(); ++intListener) {
            LiveShowViewListener o_Listener = (LiveShowViewListener)o_LiveShowViewListeners.get(intListener);
            o_Listener.eventViewChanged(p_FrameStart, p_FrameEnd, p_VisibleFrameStart, p_VisibleFrameEnd, p_Bounds);
        }
    }

    public void setFramePlayCursor(long p_FramePlayCursor) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (p_FramePlayCursor < this.m_SoundObjectFrameStart) {
            p_FramePlayCursor = this.m_SoundObjectFrameStart;
        }
        if (p_FramePlayCursor > this.m_SoundObjectFrameEnd) {
            p_FramePlayCursor = this.m_SoundObjectFrameEnd;
        }
        this.m_FramePlayCursor = p_FramePlayCursor;
        long longFramePlayCursor = this.m_LiveShowSoundHD.setFramePlayCursor(this.m_FramePlayCursor);
        if (this.m_PlaySound != null) {
            this.m_PlaySound.setPlayCursor(longFramePlayCursor);
        }
        this.calculatePlayCursor();
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    private void calculatePlayCursor() {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        AbsoluteConstraints o_AbsoluteConstraints = this.m_LiveShowSoundPlayCursor.getAbsoluteConstraints();
        o_AbsoluteConstraints.width = 5;
        o_AbsoluteConstraints.height = this.jPanel_SoundView.getHeight();
        int intNewX = this.getPositionX(this.m_FramePlayCursor) - this.getPositionX(this.m_VisibleFrameStart);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if ((intNewX -= o_AbsoluteConstraints.width / 2) != o_AbsoluteConstraints.x) {
            o_AbsoluteConstraints.x = intNewX;
            EventQueueHandler.invokeLater((Runnable)this.m_Runnable_Revalidate_JPanel_SoundView);
        }
    }

    public void setAutoScroll(boolean p_AutoScroll) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_LiveShowScrollBarPanel != null) {
            this.m_LiveShowScrollBarPanel.setAutoScroll(p_AutoScroll);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getComponent() == this.jPanel_SoundView) {
            if (this.jPanel_SoundView.getWidth() == this.m_OldSize_jPanel_SoundView.width && this.jPanel_SoundView.getHeight() == this.m_OldSize_jPanel_SoundView.height) {
                return;
            }
            this.m_OldSize_jPanel_SoundView.setSize(this.jPanel_SoundView.getWidth(), this.jPanel_SoundView.getHeight());
            this.notifySoundObjectViewListeners_ViewChanged(this.getFrameStart(), this.getFrameEnd(), this.m_VisibleFrameStart, this.m_VisibleFrameEnd, e.getComponent().getBounds());
            this.revalidate();
            this.jPanel_SoundView.revalidate();
            this.calculatePlayCursor();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void eventPlayStart(Play p_Play) {
    }

    public void eventPlayStop(Play p_Play) {
    }

    public void eventPlayPause(Play p_Play) {
    }

    public void eventPlayRewind(Play p_Play) {
    }

    public void eventPlayCursorSet(Play p_Play, long p_FramePlayCursor) {
    }

    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
    }

    public void eventEditCursorSet(Play p_Play, long p_FrameEditCursor) {
    }

    public void eventPlayFastForward(Play p_Play) {
    }

    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
    }

    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
    }

    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    public void eventPlayCursor(Play p_Play, long p_OldFramePlayCursor, long p_FramePlayCursor) {
        if (p_FramePlayCursor < this.m_SoundObjectFrameStart) {
            p_FramePlayCursor = this.m_SoundObjectFrameStart;
        }
        if (p_FramePlayCursor > this.m_SoundObjectFrameEnd) {
            p_FramePlayCursor = this.m_SoundObjectFrameEnd;
        }
        if (this.m_FramePlayCursor == p_OldFramePlayCursor) {
            return;
        }
        this.m_FramePlayCursor = p_OldFramePlayCursor;
        this.calculatePlayCursor();
    }

    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    public void eventPlayClosing(Play p_Play) {
    }

    public void eventPlayTimelineEnd(Play p_Play) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (e.getComponent() == this.jPanel_SoundView) {
            // empty if block
        }
        if (e.getComponent() == this.jPanel_SoundView || e.getComponent() == this.m_LiveShowSoundObjectPanel) {
            long longFrameClicked = this.getPositionFrame(e.getX());
            this.setFramePlayCursor(longFrameClicked);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (e.getComponent() == this.jPanel_SoundView || e.getComponent() == this.m_LiveShowSoundObjectPanel) {
            if (this.m_Section == null) {
                this.setSection(this.getPositionFrame(e.getPoint()), this.getPositionFrame(e.getPoint()));
            } else {
                this.m_Section.setFrameEnd(this.m_Section.checkSnapping(e.getPoint().x));
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == SoundMixers.s_JDialog_Sound_Lines_Preview && "changedSoundLines".equals(evt.getPropertyName())) {
            this.setOutputSound_Lines();
        }
    }

    private void initComponents() {
        this.jPanel_SoundView = new JPanel();
        this.jPanel_PlayControl = new JPanel();
        this.liveShowTimeBar1 = new LiveShowTimeBar();
        this.jPanel_Mark = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel_SoundView.setLayout(new AbsoluteLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel_SoundView, gridBagConstraints);
        this.jPanel_PlayControl.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.jPanel_PlayControl.setOpaque(false);
        this.jPanel_PlayControl.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel_PlayControl, gridBagConstraints);
        this.liveShowTimeBar1.setMinimumSize(new Dimension(0, 32));
        this.liveShowTimeBar1.setPreferredSize(new Dimension(100, 32));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.liveShowTimeBar1, gridBagConstraints);
        this.jPanel_Mark.setMinimumSize(new Dimension(64, 32));
        this.jPanel_Mark.setOpaque(false);
        this.jPanel_Mark.setPreferredSize(new Dimension(64, 32));
        this.jPanel_Mark.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_Mark, gridBagConstraints);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        if (this.m_DragStarted) {
            return;
        }
        this.m_DragStarted = true;
        LiveShowSoundObjectDescription o_LiveShowObjectDescription = new LiveShowSoundObjectDescription();
        o_LiveShowObjectDescription.setObjectType(1);
        if (this.m_LiveShowSoundHD != null) {
            o_LiveShowObjectDescription.setSourceName(this.m_LiveShowSoundHD.getSoundFile().getName());
            o_LiveShowObjectDescription.setSourceString(this.m_LiveShowSoundHD.getSoundFile().getPath());
        } else {
            o_LiveShowObjectDescription.setSourceName("-");
            o_LiveShowObjectDescription.setSourceString("-");
        }
        o_LiveShowObjectDescription.setFrameStartOffset(this.m_SoundObjectFrameStart);
        o_LiveShowObjectDescription.setFrameLength(this.m_SoundObjectFrameEnd);
        this.setSection(this.m_SoundObjectFrameStart, this.m_SoundObjectFrameEnd);
        if (this.m_LiveShowSoundObject != null) {
            o_LiveShowObjectDescription.getSound_Lines().setParentType("SoundObject");
            o_LiveShowObjectDescription.getSound_Lines().setParentChannelCount(this.m_LiveShowSoundObject.getAudioFormat().getChannels());
            for (int intChannel = 0; intChannel < this.m_LiveShowSoundObject.getAudioFormat().getChannels(); ++intChannel) {
                o_LiveShowObjectDescription.getSound_Lines().addSoundLineFactor(intChannel, intChannel, 1.0, false);
            }
            if (this.m_LiveShowSoundObject.getAudioFormat().getChannels() == 1) {
                o_LiveShowObjectDescription.getSound_Lines().addSoundLineFactor(0, 1, 1.0, false);
            }
        }
        LiveShowDragDrop.LiveShowTransferable o_Transferable = new LiveShowDragDrop.LiveShowTransferable((LiveShowObjectDescription)o_LiveShowObjectDescription, LiveShowDragDrop.LiveShowTransferable.SOUNDOBJECTFLAVOUR);
        LiveShowDragDrop.setSource((Object)this);
        dge.startDrag(null, (Transferable)o_Transferable, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (!dsde.getDropSuccess()) {
            LiveShowDragDrop.notifyDropCancelled();
        }
        this.m_DragStarted = false;
    }

    public static class Section
    extends JPanel
    implements LiveShowViewListener,
    PlayJumpInterface,
    MouseInputListener,
    MouseWheelListener,
    DragGestureListener,
    DragSourceListener,
    LiveLanguageListener {
        public static int MOUSEFETCHSIZE = 16;
        private LiveShowSoundHDPanel m_LiveShowSoundHDPanel;
        private long m_FrameStart;
        private long m_FrameEnd;
        private AbsoluteConstraints m_AbsoluteConstraints;
        private JComponent m_SoundObjectViewContainer;
        private JLabel m_JLabelClose;
        private AbsoluteConstraints m_JButtonCloseConstraints;
        private boolean m_MouseResizeEast;
        private boolean m_MouseResizeWest;
        private DragSource m_DragSource;
        private boolean m_DragStarted;
        private LiveShowDragDrop.LiveShowGestureRecognizer m_DragGestureRecognizer;
        private Color m_ColorSection;

        public Section(LiveShowSoundHDPanel p_LiveShowSoundHDPanel, long p_FrameStart) {
            this.initMembers();
            this.initComponents();
            this.m_LiveShowSoundHDPanel = p_LiveShowSoundHDPanel;
            this.m_FrameStart = p_FrameStart;
            this.m_FrameEnd = p_FrameStart;
            this.m_SoundObjectViewContainer = p_LiveShowSoundHDPanel.getSoundObjectViewContainer();
            this.m_SoundObjectViewContainer.add(this, this.m_AbsoluteConstraints, 0);
            this.m_LiveShowSoundHDPanel.addLiveShowViewListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.setVisible(true);
            LiveLanguage.addLanguageListener((Object)this, null);
        }

        private void initMembers() {
            this.m_FrameEnd = 0L;
            this.m_FrameStart = 0L;
            this.m_MouseResizeWest = false;
            this.m_MouseResizeEast = false;
            this.m_ColorSection = new Color(0.0f, 0.0f, 0.5f, 0.3f);
            this.m_DragStarted = false;
        }

        private void initComponents() {
            this.setBorder(new LineBorder(Color.BLUE, 1));
            this.setOpaque(false);
            this.setLayout(new AbsoluteLayout());
            this.m_AbsoluteConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            this.m_JButtonCloseConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            this.m_JLabelClose = new JLabel("X");
            this.m_JLabelClose.setHorizontalAlignment(0);
            this.m_JLabelClose.setVerticalAlignment(0);
            this.m_JLabelClose.setForeground(Color.WHITE);
            this.m_JLabelClose.setBackground(Color.red);
            this.m_JLabelClose.setOpaque(true);
            this.add((Component)this.m_JLabelClose, this.m_JButtonCloseConstraints);
            this.m_JLabelClose.setVisible(true);
            this.m_JLabelClose.setCursor(Cursor.getPredefinedCursor(12));
            this.m_JLabelClose.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (m_LiveShowSoundHDPanel instanceof LiveShowSoundHDPanel) {
                        m_LiveShowSoundHDPanel.deleteSection();
                    }
                }
            });
            this.m_DragSource = new DragSource();
            this.m_DragGestureRecognizer = new LiveShowDragDrop.LiveShowGestureRecognizer(this.m_DragSource, (JComponent)this, 2, (DragGestureListener)this, 2);
            this.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        }

        public void close() {
            this.setComponentPopupMenu(null);
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            if (this.m_LiveShowSoundHDPanel != null) {
                this.m_LiveShowSoundHDPanel.removeLiveShowViewListener(this);
                this.setVisible(false);
                this.m_LiveShowSoundHDPanel.getSoundObjectViewContainer().remove(this);
                if (!SwingUtilities.isEventDispatchThread()) {
                    // empty if block
                }
                this.m_LiveShowSoundHDPanel.getSoundObjectViewContainer().repaint();
                this.m_LiveShowSoundHDPanel = null;
            }
        }

        public void setFrameEnd(long p_FrameEnd) {
            if (p_FrameEnd < 0L) {
                p_FrameEnd = 0L;
            }
            if (p_FrameEnd > this.m_LiveShowSoundHDPanel.getFrameEnd()) {
                p_FrameEnd = this.m_LiveShowSoundHDPanel.getFrameEnd();
            }
            this.m_FrameEnd = p_FrameEnd;
            if (this.m_FrameEnd < this.m_FrameStart) {
                long longOldFrameStart = this.m_FrameStart;
                this.m_FrameStart = this.m_FrameEnd;
                this.m_FrameEnd = longOldFrameStart;
            }
            this.calculateSection();
        }

        public void setFrameStart(long p_FrameStart) {
            if (p_FrameStart < 0L) {
                p_FrameStart = 0L;
            }
            if (p_FrameStart > this.m_LiveShowSoundHDPanel.getFrameEnd()) {
                p_FrameStart = this.m_LiveShowSoundHDPanel.getFrameEnd();
            }
            this.m_FrameStart = p_FrameStart;
            if (this.m_FrameEnd < this.m_FrameStart) {
                long longOldFrameStart = this.m_FrameStart;
                this.m_FrameStart = this.m_FrameEnd;
                this.m_FrameEnd = longOldFrameStart;
            }
            this.calculateSection();
        }

        public void moveSection(long p_Frames) {
            if (p_Frames == 0L) {
                return;
            }
            long longFrameLength = this.m_FrameEnd - this.m_FrameStart;
            this.m_FrameStart += p_Frames;
            this.m_FrameEnd = this.m_FrameStart + longFrameLength;
            this.calculateSection();
        }

        public long checkSnapping(int p_X) {
            ArrayList o_Marks = this.m_LiveShowSoundHDPanel.getLiveShowTimeBar().getMarks();
            for (int intMark = 0; intMark < o_Marks.size(); ++intMark) {
                int intMarkX;
                LiveShowTimeBar.Mark o_Mark = (LiveShowTimeBar.Mark)o_Marks.get(intMark);
                if (o_Mark == null || p_X > (intMarkX = this.m_LiveShowSoundHDPanel.getPositionX(o_Mark.getFramePosition())) + MOUSEFETCHSIZE || p_X < intMarkX - MOUSEFETCHSIZE) continue;
                return o_Mark.getFramePosition();
            }
            return this.m_LiveShowSoundHDPanel.getPositionFrame(p_X);
        }

        public void calculateSection() {
            this.m_AbsoluteConstraints.y = 0;
            this.m_AbsoluteConstraints.height = this.m_SoundObjectViewContainer.getHeight();
            this.m_AbsoluteConstraints.x = this.m_LiveShowSoundHDPanel.getPositionX(this.m_FrameStart) - this.m_LiveShowSoundHDPanel.getPositionX(this.m_LiveShowSoundHDPanel.getVisibleFrameStart());
            this.m_AbsoluteConstraints.width = this.m_LiveShowSoundHDPanel.getPositionX(this.m_FrameEnd) - this.m_LiveShowSoundHDPanel.getPositionX(this.m_LiveShowSoundHDPanel.getVisibleFrameStart()) - this.m_AbsoluteConstraints.x;
            if (this.m_AbsoluteConstraints.width <= 0) {
                this.m_AbsoluteConstraints.width = 2;
            }
            this.m_SoundObjectViewContainer.revalidate();
            this.m_JButtonCloseConstraints.y = 0;
            this.m_JButtonCloseConstraints.x = this.m_AbsoluteConstraints.width - 16;
            this.m_JButtonCloseConstraints.height = 16;
            this.m_JButtonCloseConstraints.width = 16;
            this.createToolTipText();
            this.revalidate();
        }

        public void createToolTipText() {
            StringBuffer o_StringBuffer = new StringBuffer();
            o_StringBuffer.append("<html>");
            o_StringBuffer.append("<table>");
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td>");
            o_StringBuffer.append(LABEL_START);
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("<td>");
            o_StringBuffer.append(LiveShowObject.getTimeStringFromMillis((long)((long)((double)this.m_FrameStart * LiveShowVIP.getFRAMETIME()))));
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("</tr>");
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td>");
            o_StringBuffer.append(LABEL_END);
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("<td>");
            o_StringBuffer.append(LiveShowObject.getTimeStringFromMillis((long)((long)((double)this.m_FrameEnd * LiveShowVIP.getFRAMETIME()))));
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("</tr>");
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td>");
            o_StringBuffer.append("<b>");
            o_StringBuffer.append(LABEL_DURATION);
            o_StringBuffer.append("</b>");
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("<td>");
            o_StringBuffer.append("<b>");
            o_StringBuffer.append(LiveShowObject.getTimeStringFromMillis((long)((long)((double)(this.m_FrameEnd - this.m_FrameStart) * LiveShowVIP.getFRAMETIME()))));
            o_StringBuffer.append("</b>");
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("</tr>");
            o_StringBuffer.append("</table>");
            this.setToolTipText(o_StringBuffer.toString());
        }

        public void eventViewChanged(long p_FrameStart, long p_FrameEnd, long p_VisibleFrameStart, long p_VisibleFrameEnd, Rectangle p_Bounds) {
            this.calculateSection();
        }

        public void eventViewScrollAutomaticStart() {
        }

        public void eventZoomPlus(boolean p_AdjustFramePosition, long p_FramePosition) {
        }

        public void eventZoomMinus(boolean p_AdjustFramePosition, long p_FramePosition) {
        }

        public void eventZoomReset() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int intX = e.getX();
            if (this.mouseNearEast(intX)) {
                this.m_MouseResizeEast = true;
                this.m_DragGestureRecognizer.setActive(false);
            } else if (this.mouseNearWest(intX)) {
                this.m_MouseResizeWest = true;
                this.m_DragGestureRecognizer.setActive(false);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.m_MouseResizeWest = false;
            this.m_MouseResizeEast = false;
            this.m_DragGestureRecognizer.setActive(true);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int intX = e.getPoint().x;
            long longPositionFrame = this.checkSnapping(intX + this.m_LiveShowSoundHDPanel.getPositionX(this.m_FrameStart));
            if (longPositionFrame < 0L) {
                return;
            }
            if (this.m_MouseResizeEast) {
                this.setFrameEnd(longPositionFrame);
            } else if (this.m_MouseResizeWest) {
                this.setFrameStart(longPositionFrame);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int intX = e.getPoint().x;
            if (this.mouseNearEast(intX)) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (this.mouseNearWest(intX)) {
                this.setCursor(Cursor.getPredefinedCursor(10));
            } else {
                this.setCursor(null);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (this.m_LiveShowSoundHDPanel.getIsSetingZoom()) {
                return;
            }
            long longFramePosition = this.m_LiveShowSoundHDPanel.getPositionFrame(e.getX());
            if (e.getWheelRotation() > 0) {
                this.m_LiveShowSoundHDPanel.zoomMinus(false, this.m_FrameStart + longFramePosition);
            } else if (e.getWheelRotation() < 0) {
                this.m_LiveShowSoundHDPanel.zoomPlus(false, this.m_FrameStart + longFramePosition);
            }
        }

        boolean mouseNearEast(int p_X) {
            boolean boolIs = false;
            boolIs = this.getWidth() <= 2 * MOUSEFETCHSIZE ? p_X > this.getWidth() / 2 : p_X >= this.getWidth() - MOUSEFETCHSIZE && p_X <= this.getWidth() + MOUSEFETCHSIZE;
            return boolIs;
        }

        boolean mouseNearWest(int p_X) {
            boolean boolIs = false;
            boolIs = this.getWidth() <= 2 * MOUSEFETCHSIZE ? p_X < this.getWidth() / 2 : p_X <= MOUSEFETCHSIZE && p_X >= -MOUSEFETCHSIZE;
            return boolIs;
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            super.paintComponent(p_Graphics);
            Graphics2D g2d = (Graphics2D)p_Graphics;
            g2d.setColor(this.m_ColorSection);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        public long getJumpFrameFrom() {
            return this.m_FrameEnd;
        }

        public long getJumpFrameTo() {
            return this.m_FrameStart;
        }

        public boolean getJumpIsActive() {
            return true;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (this.m_DragStarted) {
                return;
            }
            this.m_DragStarted = true;
            File o_File = null;
            LiveShowSoundObjectDescription o_LiveShowObjectDescription = new LiveShowSoundObjectDescription();
            o_LiveShowObjectDescription.setObjectType(1);
            if (this.m_LiveShowSoundHDPanel.getLiveShowSoundHD() != null) {
                o_File = this.m_LiveShowSoundHDPanel.getLiveShowSoundHD().getSoundFile();
            }
            if (o_File != null) {
                o_LiveShowObjectDescription.setSourceName(o_File.getName());
                o_LiveShowObjectDescription.setSourceString(o_File.getPath());
            } else {
                o_LiveShowObjectDescription.setSourceName("-");
                o_LiveShowObjectDescription.setSourceString("-");
            }
            o_LiveShowObjectDescription.setFrameStartOffset(this.m_FrameStart);
            o_LiveShowObjectDescription.setFrameLength(this.m_FrameEnd - this.m_FrameStart);
            LiveShowSoundObject o_LiveShowSoundObject = this.m_LiveShowSoundHDPanel.getLiveShowSoundObject();
            if (o_LiveShowSoundObject != null) {
                o_LiveShowSoundObject.getSound_Lines().copyTo(o_LiveShowObjectDescription.getSound_Lines());
            }
            LiveShowDragDrop.LiveShowTransferable o_Transferable = new LiveShowDragDrop.LiveShowTransferable((LiveShowObjectDescription)o_LiveShowObjectDescription, LiveShowDragDrop.LiveShowTransferable.SOUNDOBJECTFLAVOUR);
            LiveShowDragDrop.setSource((Object)this.m_LiveShowSoundHDPanel);
            dge.startDrag(null, (Transferable)o_Transferable, this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (!dsde.getDropSuccess()) {
                LiveShowDragDrop.notifyDropCancelled();
            }
            this.m_DragStarted = false;
        }

        public void eventLanguageChanged(Locale p_OldLanguage, Locale p_SelectedLanguage) {
        }
    }
}

