/*
 * Decompiled with CFR 0.152.
 */
package SoundSamplePackage;

import FileToolPackage.FileTools;
import Icons.IconManager;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import SoundGraphics.LiveShowSoundGraphicsFile;
import SoundPackage.SoundMixers;
import SoundSamplePackage.LiveShowSoundHDListener;
import SoundSamplePackage.LiveShowSoundStream;
import SoundSamplePackage.LiveShowSoundStreamListener;
import SoundTools.LiveShowSoundConverter;
import SoundTools.LiveShowWaveHeader;
import SoundVirtualPackage.LiveShowSoundObject;
import SoundVirtualPackage.LiveShowSoundObjectDescription;
import StartPackage.LiveShowSoundSystem;
import SwingModelPackage.TableAndListModel;
import SynchronizationPackage.LiveCloseSemaphore;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class LiveShowSoundHD
implements LiveShowSoundStreamListener,
Playable,
LiveShowObject.LiveShowObjectOwner {
    public static ImageIcon s_Icon = IconManager.getImageIcon((String)"Sound.png");
    public static SoundHDTableModel s_SoundHDTableModel = new SoundHDTableModel();
    public static TableAndListModel.ListModel<LiveShowSoundHD> s_SoundHDListModel = s_SoundHDTableModel.getListModel();
    private File m_SoundFile;
    private LiveShowSoundStream m_LiveShowSoundStream;
    private AudioFormat m_SoundFileAudioFormat;
    private LiveShowSoundGraphicsFile m_LiveShowSoundGraphicsFile;
    private LiveShowSoundObject m_LiveShowSoundObject;
    private ArrayList<LiveShowSoundHDListener> m_LiveShowSoundHDListeners;
    private SinglePropertyChangeSupport m_PropertyChangeSupport;
    private ArrayList<Object> m_References;
    private LiveCloseSemaphore m_LiveCloseSemaphore;
    private final Object m_SyncHDListeners = new Object();

    public LiveShowSoundHD(File p_SoundFile) {
        this.initMembers();
        this.m_SoundFileAudioFormat = SoundMixers.getAudioFormat((File)p_SoundFile);
        this.m_SoundFile = p_SoundFile;
    }

    public void load() throws IOException {
        String stringSoundFile = "";
        if (this.m_SoundFile == null || !this.m_SoundFile.exists()) {
            if (this.m_SoundFile != null) {
                stringSoundFile = this.m_SoundFile.getPath();
            }
            this.notifyListener_InvalidSoundFile(this.m_SoundFile);
            this.close();
            throw new IOException("LiveShowSoundHD load() - invalid soundfile " + stringSoundFile);
        }
        try {
            this.m_LiveShowSoundStream = new LiveShowSoundStream(this, SoundMixers.DEFAULT_AUDIOFORMAT, this.m_SoundFile);
        }
        catch (Exception e) {
            stringSoundFile = this.m_SoundFile.getPath();
            this.notifyListener_InvalidSoundFile(this.m_SoundFile);
            this.close();
            throw new IOException("LiveShowSoundHD load() - invalid soundfile " + stringSoundFile);
        }
        if (this.m_LiveShowSoundStream != null) {
            LiveShowSoundObjectDescription o_LiveShowSoundObjectDescription = new LiveShowSoundObjectDescription();
            this.m_LiveShowSoundObject = new LiveShowSoundObject(o_LiveShowSoundObjectDescription, this, 0L, this.m_LiveShowSoundStream.getFrameLength());
        }
        this.notifyListener_Opened();
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_References = new ArrayList();
        this.m_LiveShowSoundHDListeners = new ArrayList();
        this.m_LiveShowSoundStream = null;
        this.m_SoundFileAudioFormat = SoundMixers.DEFAULT_AUDIOFORMAT;
        this.m_LiveShowSoundGraphicsFile = null;
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
    }

    public long getDiskSpaceEstimated(File p_ExportDirectory) {
        long longBytesCount = 0L;
        try {
            if (this.m_SoundFile != null) {
                longBytesCount += this.m_SoundFile.length();
            }
            if (this.m_LiveShowSoundGraphicsFile.getGraphicsFile() != null) {
                longBytesCount += this.m_LiveShowSoundGraphicsFile.getGraphicsFile().length();
            }
            if (p_ExportDirectory != null) {
                File o_File;
                if (this.m_SoundFile != null && (o_File = new File(p_ExportDirectory.getAbsolutePath() + "/" + this.m_SoundFile.getName())).exists()) {
                    longBytesCount -= o_File.length();
                }
                if (this.m_LiveShowSoundGraphicsFile.getGraphicsFile() != null && (o_File = new File(p_ExportDirectory.getAbsolutePath() + "/" + this.m_LiveShowSoundGraphicsFile.getGraphicsFile().getName())).exists()) {
                    longBytesCount -= o_File.length();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return longBytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange("liveShowObject_SourceClose", (Object)this, null);
            this.m_PropertyChangeSupport.clear();
        }
        this.notifyListener_Closing();
        Object object = this.m_SyncHDListeners;
        synchronized (object) {
            if (this.m_LiveShowSoundHDListeners != null) {
                this.m_LiveShowSoundHDListeners.clear();
                this.m_LiveShowSoundHDListeners = null;
            }
        }
        if (this.m_LiveShowSoundObject != null) {
            this.m_LiveShowSoundObject.close(true);
            this.m_LiveShowSoundObject = null;
        }
        if (this.m_LiveShowSoundStream != null) {
            this.m_LiveShowSoundStream.close();
            this.m_LiveShowSoundStream = null;
        }
        if (this.m_LiveShowSoundGraphicsFile != null) {
            this.m_LiveShowSoundGraphicsFile.close();
        }
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.m_PropertyChangeSupport = null;
    }

    public String getToolTipText() {
        if (this.m_SoundFile == null) {
            return null;
        }
        return this.m_SoundFile.getAbsolutePath();
    }

    public void addReference(Object p_Object) {
        if (p_Object == null) {
            return;
        }
        if (this.m_References.contains(p_Object)) {
            return;
        }
        this.m_References.add(p_Object);
    }

    public void removeReference(Object p_Object, boolean p_Finish) {
        if (p_Object == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (!this.m_References.contains(p_Object)) {
            return;
        }
        this.m_References.remove(p_Object);
        if (!p_Finish) {
            return;
        }
        if (this.m_References.size() > 1) {
            return;
        }
        if (this.m_References.size() == 1 && this.m_References.get(0) != this.m_LiveShowSoundObject) {
            return;
        }
        this.close();
    }

    public LiveShowObject getLiveShowObject() {
        return this.m_LiveShowSoundObject;
    }

    public LiveShowSoundObject getLiveShowSoundObject() {
        return this.m_LiveShowSoundObject;
    }

    public LiveShowSoundStream getLiveShowSoundStream() {
        return this.m_LiveShowSoundStream;
    }

    public LiveShowWaveHeader getLiveShowWaveHeader() {
        LiveShowSoundStream o_LiveShowSoundStream = this.m_LiveShowSoundStream;
        if (o_LiveShowSoundStream == null) {
            return null;
        }
        return o_LiveShowSoundStream.getLiveShowWaveHeader();
    }

    public File getSoundFile() {
        LiveShowSoundStream o_LiveShowSoundStream = this.m_LiveShowSoundStream;
        if (o_LiveShowSoundStream == null) {
            return null;
        }
        return o_LiveShowSoundStream.getSoundFile();
    }

    public LiveShowSoundGraphicsFile getLiveShowSoundGraphicsFile() {
        if (this.m_LiveShowSoundGraphicsFile == null) {
            this.m_LiveShowSoundGraphicsFile = new LiveShowSoundGraphicsFile(this);
        }
        return this.m_LiveShowSoundGraphicsFile;
    }

    public File getSoundGraphicsFile() {
        if (this.m_LiveShowSoundGraphicsFile == null) {
            return null;
        }
        return this.m_LiveShowSoundGraphicsFile.getGraphicsFile();
    }

    public File getSoundFileDirectory() {
        File o_SoundFile = this.getSoundFile();
        if (o_SoundFile == null) {
            return null;
        }
        return o_SoundFile.getParentFile();
    }

    public long getFrameLength() {
        LiveShowSoundStream o_LiveShowSoundStream = this.m_LiveShowSoundStream;
        if (o_LiveShowSoundStream == null) {
            return 0L;
        }
        return o_LiveShowSoundStream.getFrameLength();
    }

    public long getUnusedBytesEOF() {
        LiveShowSoundStream o_LiveShowSoundStream = this.m_LiveShowSoundStream;
        if (o_LiveShowSoundStream == null) {
            return 0L;
        }
        return o_LiveShowSoundStream.getUnusedBytesEOF();
    }

    public RandomAccessFile createReadableRandomAccessFile() {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        RandomAccessFile o_RandomAccessFile = null;
        if (this.m_LiveShowSoundStream != null) {
            o_RandomAccessFile = this.m_LiveShowSoundStream.createReadableRandomAccessFile();
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_RandomAccessFile;
    }

    public long getFirstDataBytePosition() {
        LiveShowSoundStream o_LiveShowSoundStream = this.m_LiveShowSoundStream;
        if (o_LiveShowSoundStream == null) {
            return 0L;
        }
        return o_LiveShowSoundStream.getFirstDataBytePosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLiveShowSoundHDListener(LiveShowSoundHDListener p_LiveShowSoundHDListener) {
        if (p_LiveShowSoundHDListener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAdded = false;
        Object object = this.m_SyncHDListeners;
        synchronized (object) {
            if (this.m_LiveShowSoundHDListeners != null) {
                if (!this.m_LiveShowSoundHDListeners.contains(p_LiveShowSoundHDListener)) {
                    this.m_LiveShowSoundHDListeners.add(p_LiveShowSoundHDListener);
                    boolAdded = true;
                } else {
                    boolAdded = true;
                }
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLiveShowSoundHDListener(LiveShowSoundHDListener p_LiveShowSoundHDListener) {
        if (p_LiveShowSoundHDListener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncHDListeners;
        synchronized (object) {
            if (this.m_LiveShowSoundHDListeners != null) {
                boolRemoved = this.m_LiveShowSoundHDListeners.remove(p_LiveShowSoundHDListener);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener_Opened() {
        File o_SoundFile;
        ArrayList<LiveShowSoundHDListener> o_LiveShowSoundHDListeners;
        LiveShowSoundStream o_LiveShowSoundStream = this.m_LiveShowSoundStream;
        if (o_LiveShowSoundStream == null) {
            return;
        }
        Object object = this.m_SyncHDListeners;
        synchronized (object) {
            if (this.m_LiveShowSoundHDListeners == null) {
                return;
            }
            if (this.m_LiveShowSoundHDListeners.size() <= 0) {
                return;
            }
            o_LiveShowSoundHDListeners = new ArrayList<LiveShowSoundHDListener>(this.m_LiveShowSoundHDListeners.size());
            o_LiveShowSoundHDListeners.addAll(this.m_LiveShowSoundHDListeners);
            o_SoundFile = o_LiveShowSoundStream == null ? null : o_LiveShowSoundStream.getSoundFile();
        }
        for (int intListener = 0; intListener < o_LiveShowSoundHDListeners.size(); ++intListener) {
            LiveShowSoundHDListener o_LiveShowSoundHDListener = (LiveShowSoundHDListener)o_LiveShowSoundHDListeners.get(intListener);
            o_LiveShowSoundHDListener.eventHDOpened(this, o_SoundFile, -1L, -1L);
        }
        o_LiveShowSoundHDListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener_Closing() {
        ArrayList<LiveShowSoundHDListener> o_LiveShowSoundHDListeners;
        Object object = this.m_SyncHDListeners;
        synchronized (object) {
            if (this.m_LiveShowSoundHDListeners == null) {
                return;
            }
            if (this.m_LiveShowSoundHDListeners.size() <= 0) {
                return;
            }
            o_LiveShowSoundHDListeners = new ArrayList<LiveShowSoundHDListener>(this.m_LiveShowSoundHDListeners.size());
            o_LiveShowSoundHDListeners.addAll(this.m_LiveShowSoundHDListeners);
            this.m_LiveShowSoundHDListeners.clear();
        }
        int intListenerCount = o_LiveShowSoundHDListeners.size();
        for (int intListener = intListenerCount - 1; intListener >= 0; --intListener) {
            LiveShowSoundHDListener o_LiveShowSoundHDListener = (LiveShowSoundHDListener)o_LiveShowSoundHDListeners.get(intListener);
            o_LiveShowSoundHDListener.eventHDClosing(this);
            o_LiveShowSoundHDListeners.remove(o_LiveShowSoundHDListener);
        }
        o_LiveShowSoundHDListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener_InvalidSoundFile(File p_SoundFile) {
        ArrayList<LiveShowSoundHDListener> o_LiveShowSoundHDListeners;
        Object object = this.m_SyncHDListeners;
        synchronized (object) {
            if (this.m_LiveShowSoundHDListeners == null) {
                return;
            }
            if (this.m_LiveShowSoundHDListeners.size() <= 0) {
                return;
            }
            o_LiveShowSoundHDListeners = new ArrayList<LiveShowSoundHDListener>(this.m_LiveShowSoundHDListeners.size());
            o_LiveShowSoundHDListeners.addAll(this.m_LiveShowSoundHDListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowSoundHDListeners.size(); ++intListener) {
            LiveShowSoundHDListener o_LiveShowSoundHDListener = (LiveShowSoundHDListener)o_LiveShowSoundHDListeners.get(intListener);
            o_LiveShowSoundHDListener.eventHDInvalidSoundFile(this, p_SoundFile);
        }
        o_LiveShowSoundHDListeners.clear();
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    @Override
    public File eventSoundStreamFileNotFound(LiveShowSoundStream p_LiveShowSoundStream, File p_InputFile) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return null;
    }

    @Override
    public File eventSoundStreamFileNotMatchingFormat(LiveShowSoundStream p_LiveShowSoundStream, File p_InputFile) {
        AudioFormat o_AudioFormat;
        if (p_InputFile == null) {
            return null;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        File o_File = null;
        this.m_SoundFileAudioFormat = o_AudioFormat = LiveShowSoundSystem.getAudioFormatMatching(this.m_SoundFileAudioFormat);
        String stringFilePathName = FileTools.getPathName((File)p_InputFile);
        String stringFileName = LiveShowSoundSystem.calculateConvertedSoundFileName(this.m_SoundFile, o_AudioFormat);
        if (stringFileName != null) {
            File o_OutputFile = new File(stringFilePathName + "/" + stringFileName);
            o_File = LiveShowSoundConverter.convertAudioFile(p_InputFile, o_AudioFormat, o_OutputFile);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_File;
    }

    @Override
    public void eventSoundStreamClosing(LiveShowSoundStream p_LiveShowSoundStream) {
    }

    public long setFramePlayCursor(long p_FramePosition) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return 0L;
        }
        LiveShowSoundObject o_LiveShowSoundObject = this.m_LiveShowSoundObject;
        if (o_LiveShowSoundObject == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return 0L;
        }
        if (p_FramePosition < o_LiveShowSoundObject.getFrameStartOffset()) {
            p_FramePosition = o_LiveShowSoundObject.getFrameStartOffset();
        }
        if (p_FramePosition > o_LiveShowSoundObject.getFrameStartOffset() + o_LiveShowSoundObject.getFrameLength()) {
            p_FramePosition = o_LiveShowSoundObject.getFrameStartOffset() + o_LiveShowSoundObject.getFrameLength();
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return p_FramePosition;
    }

    public AudioFormat getAudioFormat() {
        return this.m_SoundFileAudioFormat;
    }

    public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject) {
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveShowSoundObject o_LiveShowSoundObject = this.m_LiveShowSoundObject;
        Playable.PlayObject o_PlayObject = o_LiveShowSoundObject != null ? o_LiveShowSoundObject.read(p_Play, p_PlayObject, null, -1L, 1.0, false) : null;
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_PlayObject;
    }

    public Playable.PlayObject readInternal(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        return p_PlayObject;
    }

    public boolean getActive() {
        return true;
    }

    public long getFrameStart() {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return 0L;
        }
        LiveShowSoundObject o_LiveShowSoundObject = this.m_LiveShowSoundObject;
        long longPosition = o_LiveShowSoundObject != null ? o_LiveShowSoundObject.getFrameStart() : 0L;
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return longPosition;
    }

    public long getFrameEnd() {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return 0L;
        }
        LiveShowSoundObject o_LiveShowSoundObject = this.m_LiveShowSoundObject;
        long longPosition = o_LiveShowSoundObject != null ? o_LiveShowSoundObject.getFrameStart() + o_LiveShowSoundObject.getFrameLength() : 0L;
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return longPosition;
    }

    public long getFrameEndToPlay() {
        return this.getFrameEnd();
    }

    public boolean setFadeOutDirect(long p_ActualFramePlay, double p_FadeInProgress, double p_FadeOutProgress) {
        return false;
    }

    public void resetFadeOutDirect() {
    }

    public long getFrameLength_FadeOutDirect() {
        return 0L;
    }

    public long findFramePosition_FadeIn(double p_FadeProgress) {
        LiveShowSoundObject o_LiveShowSoundObject = this.m_LiveShowSoundObject;
        if (o_LiveShowSoundObject == null) {
            return 0L;
        }
        return o_LiveShowSoundObject.findFramePosition_FadeIn(p_FadeProgress);
    }

    public long findFramePosition_FadeOut(double p_FadeProgress) {
        LiveShowSoundObject o_LiveShowSoundObject = this.m_LiveShowSoundObject;
        if (o_LiveShowSoundObject == null) {
            return 0L;
        }
        return o_LiveShowSoundObject.findFramePosition_FadeOut(p_FadeProgress);
    }

    public double getFrameTime() {
        if (this.m_SoundFileAudioFormat == null) {
            return 0.0;
        }
        return 1000.0 / (double)this.m_SoundFileAudioFormat.getFrameRate();
    }

    public void eventPlayStart(Play p_Play) {
    }

    public void eventPlayStop(Play p_Play) {
    }

    public void eventPlayPause(Play p_Play) {
    }

    public void eventPlayRewind(Play p_Play) {
    }

    public void eventPlayFastForward(Play p_Play) {
    }

    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
    }

    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
    }

    public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
    }

    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
    }

    public void eventEditCursorSet(Play p_Play, long p_EditCursor) {
    }

    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
    }

    public void eventPlayClosing(Play p_Play) {
    }

    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
        System.out.println("PlayError: " + p_Exception);
        System.out.println("PlayError Remark: " + p_Remark);
    }

    public void eventPlayTimelineEnd(Play p_Play) {
    }

    public void gotoSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_Friends, boolean p_JumpInternal) {
    }

    public LiveShowSceneBridge getLiveShowSceneBridge_Cursor() {
        return null;
    }

    public LiveShowSceneBridge getLiveShowSceneBridge_EditCursor() {
        return null;
    }

    public LiveShowSceneBridge getLiveShowSceneBridge_Actual() {
        return null;
    }

    public LiveShowSceneBridge getLiveShowSceneBridge_Next(long p_FramePosition, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        return null;
    }

    public LiveShowSceneBridge getLiveShowSceneBridge_NextToPlay(long p_StartFrame, boolean p_OnlyMainScenes) {
        return null;
    }

    public LiveShowSceneBridge getLiveShowSceneBridge_Previous(long p_FramePosition, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        return null;
    }

    public LiveShowSceneBridge getLiveShowSceneBridge_PreviousToPlay(long p_StartFrame, boolean p_OnlyMainScenes) {
        return null;
    }

    public ImageIcon getImageIcon() {
        return s_Icon;
    }

    public static class SoundHDTableModel
    extends TableAndListModel<LiveShowSoundHD> {
        public static final int COLUMNCOUNT = 5;
        public static final int COLUMNINDEX_FILENAME = 0;
        public static final int COLUMNINDEX_FILEPATH = 1;
        public static final int COLUMNINDEX_INFOTITLE = 2;
        public static final int COLUMNINDEX_INFOARTIST = 3;
        public static final int COLUMNINDEX_INFOPRODUCT = 4;
        @LiveLanguageString
        public static String COLUMN_FILENAME = "File";
        @LiveLanguageString
        public static String COLUMN_FILEPATH = "Path";
        @LiveLanguageString
        public static String COLUMN_INFOTITLE = "Title";
        @LiveLanguageString
        public static String COLUMN_INFOARTIST = "Artist";
        @LiveLanguageString
        public static String COLUMN_INFOPRODUCT = "Product";
        private TableRowSorter m_TableRowSorter;
        private final Object m_SyncObject = new Object();

        public SoundHDTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, null);
        }

        private void initMembers() {
            this.m_TableRowSorter = new TableRowSorter<SoundHDTableModel>(this);
        }

        public void finishJTable(JTable p_JTable) {
            TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            this.m_TableRowSorter.setComparator(0, TableAndListModel.getStringComparator_Normal());
            this.m_TableRowSorter.setComparator(1, TableAndListModel.getStringComparator_Normal());
            this.m_TableRowSorter.setComparator(2, TableAndListModel.getStringComparator_Normal());
            this.m_TableRowSorter.setComparator(3, TableAndListModel.getStringComparator_Normal());
            this.m_TableRowSorter.setComparator(4, TableAndListModel.getStringComparator_Normal());
            super.finishJTable(p_JTable, this.m_TableRowSorter, null);
            Font o_Font = p_JTable.getFont();
            Font o_FontNew = new Font(o_Font.getFamily(), o_Font.getStyle(), 14);
            TableColumn o_TableColumn = p_JTable.getColumnModel().getColumn(0);
            if (o_TableColumn != null) {
                o_TableColumn.setMinWidth(120);
                o_TableColumn.setPreferredWidth(150);
                o_TableColumn.setResizable(true);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setIcon(s_Icon);
                o_TableCellEditorRenderer_String.setFont(o_Font);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(true, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(1)) != null) {
                o_TableColumn.setMinWidth(100);
                o_TableColumn.setPreferredWidth(150);
                o_TableColumn.setResizable(true);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setFont(o_Font);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(true, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(2)) != null) {
                o_TableColumn.setMinWidth(100);
                o_TableColumn.setPreferredWidth(150);
                o_TableColumn.setResizable(true);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setFont(o_Font);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(true, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(3)) != null) {
                o_TableColumn.setMinWidth(100);
                o_TableColumn.setPreferredWidth(150);
                o_TableColumn.setResizable(true);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setFont(o_Font);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(true, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(4)) != null) {
                o_TableColumn.setMinWidth(100);
                o_TableColumn.setPreferredWidth(150);
                o_TableColumn.setResizable(true);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setFont(o_Font);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(true, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
        }

        public void addSelectedLiveShowSoundHD(JTable p_JTable, LiveShowSoundHD p_LiveShowSoundHD) {
            if (p_JTable == null) {
                return;
            }
            if (p_LiveShowSoundHD == null) {
                return;
            }
            this.addSelectedElement(p_JTable, p_LiveShowSoundHD);
        }

        public void removeSelectedLiveShowSoundHD(JTable p_JTable, LiveShowSoundHD p_LiveShowSoundHD) {
            if (p_JTable == null) {
                return;
            }
            if (p_LiveShowSoundHD == null) {
                return;
            }
            this.removeSelectedElement(p_JTable, p_LiveShowSoundHD);
        }

        public LiveShowSoundHD getLiveShowSoundHD(int p_Index) {
            return (LiveShowSoundHD)this.get(p_Index);
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_FILENAME;
                }
                case 1: {
                    return COLUMN_FILEPATH;
                }
                case 2: {
                    return COLUMN_INFOTITLE;
                }
                case 3: {
                    return COLUMN_INFOARTIST;
                }
                case 4: {
                    return COLUMN_INFOPRODUCT;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(LiveShowSoundHD p_LiveShowSoundHD, int columnIndex) {
            String stringValue = "";
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_LiveShowSoundHD == null) {
                    return stringValue;
                }
            }
            switch (columnIndex) {
                case 0: {
                    File o_File = p_LiveShowSoundHD.getSoundFile();
                    if (o_File == null) break;
                    stringValue = o_File.getName();
                    break;
                }
                case 1: {
                    File o_File = p_LiveShowSoundHD.getSoundFileDirectory();
                    if (o_File == null) break;
                    stringValue = o_File.getPath();
                    break;
                }
                case 2: {
                    LiveShowWaveHeader o_LiveShowWaveHeader = p_LiveShowSoundHD.getLiveShowWaveHeader();
                    if (o_LiveShowWaveHeader == null) {
                        stringValue = "";
                        break;
                    }
                    stringValue = o_LiveShowWaveHeader.getInfo_Title();
                    break;
                }
                case 3: {
                    LiveShowWaveHeader o_LiveShowWaveHeader = p_LiveShowSoundHD.getLiveShowWaveHeader();
                    if (o_LiveShowWaveHeader == null) {
                        stringValue = "";
                        break;
                    }
                    stringValue = o_LiveShowWaveHeader.getInfo_Artist();
                    break;
                }
                case 4: {
                    LiveShowWaveHeader o_LiveShowWaveHeader = p_LiveShowSoundHD.getLiveShowWaveHeader();
                    stringValue = o_LiveShowWaveHeader == null ? "" : o_LiveShowWaveHeader.getInfo_Product();
                }
            }
            return stringValue;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public void setValue(LiveShowSoundHD p_LiveShowSoundHD, Object p_Value, int p_Column) {
        }
    }
}

