/*
 * Decompiled with CFR 0.152.
 */
package SocketManagementPackage;

import SelectorPackage.LiveDBObjectReadWrite;
import SelectorPackage.LiveDBSelector;
import SocketPackage.LiveDBSocket;
import SynchronizationPackage.LiveDBCloseSemaphore;
import java.io.IOException;
import java.nio.channels.SocketChannel;

public class LiveDBSocketChannelMerger {
    private LiveDBSocket m_LiveDBSocket;
    private SocketChannel m_SocketChannel;
    private LiveDBSelector m_LiveDBSelector;
    private LiveDBObjectReadWrite m_LiveDBObjectReadWrite;
    private LiveDBCloseSemaphore m_LiveDBCloseSemaphore;

    public LiveDBSocketChannelMerger(SocketChannel p_SocketChannel, LiveDBSelector p_LiveDBSelector) {
        this(null, p_SocketChannel, p_LiveDBSelector);
    }

    public LiveDBSocketChannelMerger(LiveDBSocket p_LiveDBSocket, SocketChannel p_SocketChannel, LiveDBSelector p_LiveDBSelector) {
        this.initMembers();
        this.m_LiveDBSocket = p_LiveDBSocket;
        this.m_SocketChannel = p_SocketChannel;
        this.m_LiveDBSelector = p_LiveDBSelector;
        this.m_LiveDBObjectReadWrite = new LiveDBObjectReadWrite(this);
    }

    private void initMembers() {
        this.m_LiveDBCloseSemaphore = new LiveDBCloseSemaphore(this.getClass().getName());
        this.m_SocketChannel = null;
        this.m_LiveDBSocket = null;
        this.m_LiveDBSelector = null;
    }

    public void close() {
        if (!this.m_LiveDBCloseSemaphore.enterCloseSection()) {
            return;
        }
        if (this.m_SocketChannel != null) {
            try {
                this.m_SocketChannel.socket().close();
                this.m_SocketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_SocketChannel = null;
        if (this.m_LiveDBObjectReadWrite != null) {
            this.m_LiveDBObjectReadWrite.close();
            this.m_LiveDBObjectReadWrite = null;
        }
        if (this.m_LiveDBSocket != null) {
            this.m_LiveDBSocket.setLiveDBSocketChannelMerger(null);
        }
        this.m_LiveDBSocket = null;
        this.m_LiveDBSelector = null;
        this.m_LiveDBCloseSemaphore.leaveCloseSection();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void setLiveDBSocket(LiveDBSocket p_LiveDBSocket) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveDBSocket = p_LiveDBSocket;
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public LiveDBSocket getLiveDBSocket() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return this.m_LiveDBSocket;
    }

    public void setSocketChannel(SocketChannel p_SocketChannel) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_SocketChannel = p_SocketChannel;
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public SocketChannel getSocketChannel() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return this.m_SocketChannel;
    }

    public LiveDBSelector getLiveSBSelector() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return this.m_LiveDBSelector;
    }

    public void selectorRead() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBObjectReadWrite o_LiveDBObjectReadWrite = this.m_LiveDBObjectReadWrite;
        if (o_LiveDBObjectReadWrite != null) {
            o_LiveDBObjectReadWrite.selectorRead();
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void selectorWrite() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBObjectReadWrite o_LiveDBObjectReadWrite = this.m_LiveDBObjectReadWrite;
        if (o_LiveDBObjectReadWrite != null) {
            o_LiveDBObjectReadWrite.selectorWrite();
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void wakeUpSelector() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_LiveDBSelector != null) {
            this.m_LiveDBSelector.wakeUpSelector();
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void addChannelEventInterest(int p_EventInterest) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBSelector o_LiveDBSelector = this.m_LiveDBSelector;
        if (o_LiveDBSelector != null) {
            o_LiveDBSelector.addChannelEventInterestLater(this.m_SocketChannel, p_EventInterest);
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }
}

