/*
 * Decompiled with CFR 0.152.
 */
package SocketManagementPackage;

import GUID.LiveDBUID;
import LiveDBSerializingPackage.LiveDBObjectDeserializing;
import LiveDBSerializingPackage.LiveDBObjectSerializing;
import RareByteInterpreterPackage.RareByteInterpreterInterface;
import SocketManagementPackage.LiveDBSocketChannelManagement;
import SocketManagementPackage.LiveDBSocketChannelMerger;
import SocketMessagePackage.LiveDBMessageStreamCancel;
import SocketMessagePackage.LiveDBMessageStreamConfirmation;
import SocketMessagePackage.LiveDBMessageStreamInfo;
import SocketMessagePackage.LiveDBMessageStreamPackage;
import SocketPackage.LiveDBSocket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class LiveDBStream {
    public static final int DATATYPE_UNKNOWN = 0;
    public static final int DATATYPE_LIVEDBMESSAGEOBJECT = -1;
    public static final int PACKAGESIZE_MIN = 512;
    private static int PACKAGESIZE_MAX = 0x100000;
    private static int m_PackageSize = 8192;
    private LiveDBSocket m_LiveDBSocket;
    private String m_ID;
    private int m_Priority;
    private int m_DataType;
    private long m_DataBytesCount;
    private long m_DataPosition;
    private boolean m_EndOfStream;
    private boolean m_Error;
    private OutputStream m_OutputStream;
    private InputStream m_InputStream;
    private boolean m_InternalHandled;
    private LiveDBMessageStreamInfo m_StreamInfo;
    private boolean m_IsConfirmed;
    private long m_ConfirmedPosition;
    private Object m_LastStreamObject;
    private LiveDBMessageStreamConfirmation m_StreamConfirmPackage;
    private boolean m_Canceled;
    private boolean m_TransferActive;
    private String m_Remark;
    private boolean m_IsOutgoing;

    public static LiveDBStream createOutgoingStream(LiveDBSocket p_LiveDBSocket, InputStream p_InputStream, int p_DataType, int p_Priority, long p_DataBytesCount, String p_Remark) {
        if (p_LiveDBSocket == null) {
            return null;
        }
        if (p_InputStream == null) {
            return null;
        }
        LiveDBStream o_LiveDBStream = new LiveDBStream(p_LiveDBSocket, p_InputStream, p_DataType, p_Priority, p_DataBytesCount, p_Remark);
        p_LiveDBSocket.addOutgoingMessage(o_LiveDBStream);
        return o_LiveDBStream;
    }

    public static LiveDBStream createOutgoingStream(LiveDBSocket p_LiveDBSocket, Serializable p_MessageObject, int p_Priority) {
        if (p_LiveDBSocket == null) {
            return null;
        }
        if (p_MessageObject == null) {
            return null;
        }
        int intDataType = 0;
        int intDataBytesCount = 0;
        String stringRemark = "";
        LiveDBStream o_LiveDBStream = new LiveDBStream(p_LiveDBSocket, p_MessageObject, intDataType, p_Priority, intDataBytesCount, stringRemark);
        p_LiveDBSocket.addOutgoingMessage(o_LiveDBStream);
        return o_LiveDBStream;
    }

    public LiveDBStream(LiveDBSocket p_LiveDBSocket, Object p_MessageObject, int p_DataType, int p_Priority, long p_DataBytesCount, String p_Remark) {
        this.initOutgoing();
        this.m_LiveDBSocket = p_LiveDBSocket;
        this.m_DataType = p_DataType;
        this.m_Priority = p_Priority;
        this.m_Remark = p_Remark;
        if (p_MessageObject == null) {
            this.m_OutputStream = null;
            this.m_DataBytesCount = 0L;
            return;
        }
        this.m_DataBytesCount = p_DataBytesCount;
        if (p_MessageObject instanceof InputStream) {
            this.createInputStream((InputStream)p_MessageObject);
        } else if (p_MessageObject instanceof Serializable) {
            this.createSerializableStream((Serializable)p_MessageObject);
        } else {
            this.m_DataType = 0;
            this.m_InputStream = null;
        }
        this.m_StreamInfo = new LiveDBMessageStreamInfo(this.getID(), this.getPriority(), this.getInternalHandled(), this.getDataType(), this.getDataBytesCount(), this.getRemark());
    }

    private void initOutgoing() {
        this.m_IsOutgoing = true;
        this.m_ID = LiveDBUID.getUID();
        this.m_EndOfStream = false;
        this.m_Error = false;
        this.m_DataPosition = 0L;
        this.m_Canceled = false;
        this.m_TransferActive = false;
        this.m_Remark = null;
        this.m_ConfirmedPosition = -1L;
        this.m_InternalHandled = false;
    }

    private void createSerializableStream(Serializable p_MessageObject) {
        ByteBuffer o_ByteBuffer;
        this.m_DataType = -1;
        this.m_InputStream = null;
        this.m_DataBytesCount = 0L;
        LiveDBSocket o_LiveDBSocket = this.m_LiveDBSocket;
        if (o_LiveDBSocket == null) {
            return;
        }
        if (o_LiveDBSocket.getRareByteInterpreterInterface() != null) {
            RareByteInterpreterInterface o_RareByteInterpreterInterface = o_LiveDBSocket.getRareByteInterpreterInterface();
            o_ByteBuffer = o_RareByteInterpreterInterface.convertObjectToBytes(p_MessageObject);
            if (o_ByteBuffer == null) {
                return;
            }
        } else {
            try {
                o_ByteBuffer = LiveDBObjectSerializing.serialize((Serializable)p_MessageObject);
            }
            catch (Exception e) {
                return;
            }
        }
        this.m_DataBytesCount = o_ByteBuffer.limit();
        this.m_InputStream = new ByteArrayInputStream(o_ByteBuffer.array());
        this.m_InternalHandled = true;
    }

    private void createInputStream(InputStream p_InputStream) {
        this.m_InputStream = p_InputStream;
    }

    public InputStream getInputStream() {
        return this.m_InputStream;
    }

    public void selectorConfirmObject(LiveDBMessageStreamConfirmation p_StreamConfirmObject) {
        if (p_StreamConfirmObject == null) {
            return;
        }
    }

    public boolean parseConfirmObject(LiveDBMessageStreamConfirmation p_StreamConfirmObject) {
        LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger;
        boolean boolClosed = false;
        boolean boolConfirmedAll = false;
        LiveDBSocket o_LiveDBSocket = this.m_LiveDBSocket;
        this.m_ConfirmedPosition = p_StreamConfirmObject.getDataPosition();
        this.m_IsConfirmed = true;
        if (this.m_EndOfStream && p_StreamConfirmObject.getDataPosition() == this.m_DataPosition) {
            boolConfirmedAll = true;
        }
        if (boolConfirmedAll || this.m_Canceled || this.m_Error) {
            if (this.m_Canceled || this.m_Error) {
                this.m_ConfirmedPosition = 0L;
            }
            if (o_LiveDBSocket != null) {
                o_LiveDBSocket.removeOutgoingMessage(this);
            }
            this.close();
            boolClosed = true;
        }
        if (o_LiveDBSocket != null && (o_LiveDBSocketChannelMerger = o_LiveDBSocket.getLiveDBSocketChannelMerger()) != null) {
            o_LiveDBSocketChannelMerger.addChannelEventInterest(4);
        }
        return boolClosed;
    }

    public long getDataPositionConfirmed() {
        return this.m_ConfirmedPosition;
    }

    public Object getNextOutgoingStreamObject() {
        LiveDBSocket o_LiveDBSocket = this.m_LiveDBSocket;
        if (this.m_InputStream == null) {
            this.m_EndOfStream = true;
            return null;
        }
        if (!this.m_TransferActive) {
            if (o_LiveDBSocket != null) {
                this.m_TransferActive = true;
                this.m_LastStreamObject = this.m_StreamInfo;
                this.m_DataPosition = 0L;
                this.m_IsConfirmed = false;
                return this.m_StreamInfo;
            }
            return null;
        }
        if (!(this.m_IsConfirmed || this.m_Canceled || this.m_Error)) {
            return null;
        }
        if (this.m_Error) {
            if (o_LiveDBSocket != null) {
                o_LiveDBSocket.notifyListeners_ParseMessageIncomingStreamEnd(this, false, this.m_Canceled, this.m_Error, "");
            }
            return null;
        }
        LiveDBMessageStreamPackage o_StreamPackage = new LiveDBMessageStreamPackage(this.m_ID, this.m_DataPosition, m_PackageSize);
        if (this.m_Canceled) {
            o_StreamPackage.setCanceled(this.m_Canceled);
            this.m_LastStreamObject = o_StreamPackage;
            return o_StreamPackage;
        }
        if (this.m_DataPosition > this.m_ConfirmedPosition) {
            this.m_IsConfirmed = false;
            return this.m_LastStreamObject;
        }
        if (this.m_EndOfStream) {
            return null;
        }
        this.m_DataPosition += (long)o_StreamPackage.readStream(this.m_InputStream);
        if (o_StreamPackage.getEndOfStream()) {
            this.m_EndOfStream = true;
        }
        if (o_StreamPackage.getError()) {
            this.m_Error = true;
        }
        this.m_LastStreamObject = o_StreamPackage;
        this.m_IsConfirmed = false;
        return o_StreamPackage;
    }

    public static LiveDBStream createIncomingStream(LiveDBSocket p_LiveDBSocket, LiveDBMessageStreamInfo p_StreamInfo, OutputStream p_OutputStream) {
        if (p_LiveDBSocket == null) {
            return null;
        }
        if (p_StreamInfo == null) {
            return null;
        }
        LiveDBStream o_LiveDBStream = new LiveDBStream(p_LiveDBSocket, p_StreamInfo, p_OutputStream);
        p_LiveDBSocket.addIncomingStream(o_LiveDBStream);
        return o_LiveDBStream;
    }

    public LiveDBStream(LiveDBSocket p_LiveDBSocket, LiveDBMessageStreamInfo p_StreamInfo, OutputStream p_OutputStream) {
        this.initIncoming();
        this.m_LiveDBSocket = p_LiveDBSocket;
        if (p_StreamInfo != null) {
            this.m_ID = p_StreamInfo.getStreamID();
            this.m_DataType = p_StreamInfo.getDataType();
            this.m_DataBytesCount = p_StreamInfo.getDataBytesCount();
            this.m_Priority = p_StreamInfo.getPriority();
            this.m_Remark = p_StreamInfo.getRemark();
        }
        if (this.m_DataType == -1 && this.m_OutputStream == null) {
            ByteArrayOutputStream o_ByteArrayOutputStream = new ByteArrayOutputStream();
            this.m_OutputStream = o_ByteArrayOutputStream;
            this.m_InternalHandled = true;
        } else {
            this.m_OutputStream = p_OutputStream;
        }
        this.m_StreamInfo = new LiveDBMessageStreamInfo(this.getID(), this.getPriority(), this.getInternalHandled(), this.getDataType(), this.getDataBytesCount(), this.getRemark());
        this.m_StreamConfirmPackage = new LiveDBMessageStreamConfirmation(this.m_ID, 0L);
    }

    private void initIncoming() {
        this.m_IsOutgoing = false;
        this.m_ID = "";
        this.m_DataType = 0;
        this.m_DataBytesCount = 0L;
        this.m_Priority = 0;
        this.m_Remark = null;
        this.m_InternalHandled = false;
        this.m_DataPosition = 0L;
        this.m_Canceled = false;
        this.m_InternalHandled = false;
    }

    public LiveDBMessageStreamConfirmation getStreamConfirmPackage() {
        this.m_StreamConfirmPackage.setDataPosition(this.m_DataPosition);
        return this.m_StreamConfirmPackage;
    }

    public void selectorIncomingStreamPackage(LiveDBMessageStreamPackage p_StreamPackage) {
        if (p_StreamPackage == null) {
            return;
        }
        if (p_StreamPackage.getCanceled()) {
            return;
        }
        if (p_StreamPackage.getError()) {
            return;
        }
    }

    public void parseIncomingStreamPackage(LiveDBMessageStreamPackage p_StreamPackage) {
        LiveDBSocket o_LiveDBSocket;
        block21: {
            if (p_StreamPackage == null) {
                return;
            }
            o_LiveDBSocket = this.m_LiveDBSocket;
            this.m_DataPosition += (long)p_StreamPackage.getDataLengthValid();
            if (this.m_OutputStream != null && p_StreamPackage.getDataLengthValid() > 0) {
                try {
                    this.m_OutputStream.write(p_StreamPackage.getDataBytes(), 0, p_StreamPackage.getDataLengthValid());
                }
                catch (Exception e) {
                    this.m_Error = true;
                    LiveDBSocketChannelManagement.eventError(e, LiveDBSocketChannelManagement.ERROR_STREAMREAD_WRITEOUTPUTBUFFER);
                }
            }
            if (o_LiveDBSocket != null) {
                LiveDBMessageStreamConfirmation o_StreamConfirmation = this.getStreamConfirmPackage();
                o_LiveDBSocket.addOutgoingMessage(o_StreamConfirmation);
            }
            if (p_StreamPackage.getEndOfStream()) {
                this.m_EndOfStream = true;
            }
            if (p_StreamPackage.getError()) {
                this.m_Error = true;
            }
            if (p_StreamPackage.getCanceled()) {
                this.m_Canceled = true;
            }
            if (this.m_EndOfStream && this.m_OutputStream != null && this.m_OutputStream instanceof ByteArrayOutputStream && this.m_InternalHandled && this.m_DataType == -1) {
                try {
                    Serializable o_MessageObject;
                    this.m_OutputStream.flush();
                    ByteArrayOutputStream o_ByteArrayOutputStream = (ByteArrayOutputStream)this.m_OutputStream;
                    byte[] o_ByteArray = o_ByteArrayOutputStream.toByteArray();
                    RareByteInterpreterInterface o_RareByteInterpreterInterface = null;
                    if (o_LiveDBSocket != null) {
                        o_RareByteInterpreterInterface = o_LiveDBSocket.getRareByteInterpreterInterface();
                    }
                    if (o_RareByteInterpreterInterface != null) {
                        ByteBuffer o_ByteBuffer = ByteBuffer.wrap(o_ByteArray);
                        o_MessageObject = o_RareByteInterpreterInterface.convertBytesToObject(o_ByteBuffer);
                    } else {
                        o_MessageObject = LiveDBObjectDeserializing.deserialize((byte[])o_ByteArray);
                    }
                    if (o_LiveDBSocket != null) {
                        o_LiveDBSocket.addIncomingMessage(o_MessageObject);
                    }
                }
                catch (Exception e) {
                    if (o_LiveDBSocket == null) break block21;
                    o_LiveDBSocket.eventError(e, LiveDBSocketChannelManagement.ERROR_MESSAGEDESERIALIZING);
                }
            }
        }
        if (o_LiveDBSocket != null) {
            if (this.m_Error) {
                o_LiveDBSocket.removeIncomingStream(this);
                this.close();
            } else if (this.m_Canceled) {
                o_LiveDBSocket.removeIncomingStream(this);
                this.close();
            } else if (this.m_EndOfStream) {
                o_LiveDBSocket.removeIncomingStream(this);
                this.close();
            }
        }
    }

    public OutputStream getOutputStream() {
        return this.m_OutputStream;
    }

    public void close() {
        try {
            if (this.m_InputStream != null) {
                this.m_InputStream.close();
            }
            if (this.m_OutputStream != null) {
                this.m_OutputStream.flush();
                this.m_OutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_EndOfStream = true;
        this.m_LiveDBSocket = null;
    }

    public String getID() {
        return this.m_ID;
    }

    public boolean setDataType(int p_DataType) {
        if (p_DataType < 0) {
            return false;
        }
        if (this.m_DataType == -1) {
            return false;
        }
        this.m_DataType = p_DataType;
        return true;
    }

    public int getDataType() {
        return this.m_DataType;
    }

    public long getDataBytesCount() {
        return this.m_DataBytesCount;
    }

    public long getDataPosition() {
        return this.m_DataPosition;
    }

    public int getPriority() {
        return this.m_Priority;
    }

    public boolean getEndOfStream() {
        return this.m_EndOfStream;
    }

    public boolean getError() {
        return this.m_Error;
    }

    public void cancel(String p_Cause) {
        if (p_Cause == null) {
            p_Cause = "";
        }
        LiveDBSocket o_LiveDBSocket = this.m_LiveDBSocket;
        if (this.m_Canceled || this.m_EndOfStream || this.m_Error) {
            return;
        }
        this.m_Canceled = true;
        this.m_IsConfirmed = true;
        if (this.m_IsOutgoing) {
            if (o_LiveDBSocket != null) {
                o_LiveDBSocket.removeOutgoingMessage(this);
                this.close();
                o_LiveDBSocket.notifyListeners_ParseMessageOutgoingStreamEnd(this, false, this.m_Canceled, this.m_Error, p_Cause);
                LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger = o_LiveDBSocket.getLiveDBSocketChannelMerger();
                if (o_LiveDBSocketChannelMerger != null) {
                    o_LiveDBSocketChannelMerger.addChannelEventInterest(4);
                }
            }
        } else if (o_LiveDBSocket != null) {
            LiveDBMessageStreamCancel o_LiveDBMessageStreamCancel = new LiveDBMessageStreamCancel(this.m_ID, p_Cause);
            o_LiveDBSocket.addOutgoingMessage(o_LiveDBMessageStreamCancel);
            o_LiveDBSocket.removeIncomingStream(this);
            this.close();
            o_LiveDBSocket.notifyListeners_ParseMessageIncomingStreamEnd(this, false, this.m_Canceled, this.m_Error, p_Cause);
        }
    }

    public boolean getCanceled() {
        return this.m_Canceled;
    }

    public String getRemark() {
        return this.m_Remark;
    }

    public LiveDBMessageStreamInfo getStreamInfo() {
        return this.m_StreamInfo;
    }

    public boolean getInternalHandled() {
        return this.m_InternalHandled;
    }

    public static int setPackageSize(int p_PackageSize) {
        m_PackageSize = p_PackageSize < 512 ? 512 : (p_PackageSize > PACKAGESIZE_MAX ? PACKAGESIZE_MAX : p_PackageSize);
        return m_PackageSize;
    }

    public static int getPackageSize() {
        return m_PackageSize;
    }

    public static int setPackageSizeMax(int p_PackageSize) {
        PACKAGESIZE_MAX = p_PackageSize < 512 ? 512 : p_PackageSize;
        return PACKAGESIZE_MAX;
    }

    public static int getPackageSizeMax() {
        return PACKAGESIZE_MAX;
    }
}

