/*
 * Decompiled with CFR 0.152.
 */
package SocketManagementPackage;

import SocketManagementPackage.LiveDBSocketChannelManagement;
import SocketPackage.LiveDBSocket;
import SynchronizationPackage.LiveDBCloseSemaphore;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;

public class LiveDBParserManager
implements Runnable {
    public static String INIPATH = "";
    public static String INIFILENAME = "LiveDBParserManager.ini";
    private static String m_IniLineSeperator = "\n";
    private static String m_IniFieldSeperator = "=";
    private static int DEFAULT_PARSERTHREADSCOUNT = 10;
    private int m_ParserThreadsCount = 0;
    private ArrayList<Thread> m_ArrayListParserThreads;
    private boolean m_ParserThreadsExit;
    private ArrayList<LiveDBSocket> m_ArrayListSocketsPending;
    private ArrayList<LiveDBSocket> m_ArrayListSocketsInAction;
    private LiveDBCloseSemaphore m_LiveDBCloseSemaphore;
    private final Object m_SyncParserThreads = new Object();
    public static final Object s_SyncWriteIni = new Object();

    public static void setDefaultParserThreadCount(int p_ParserThreadCount) {
        if (p_ParserThreadCount <= 0) {
            return;
        }
        DEFAULT_PARSERTHREADSCOUNT = p_ParserThreadCount;
    }

    public static void setINIPath(String p_IniPath) {
        if (p_IniPath == null) {
            return;
        }
        if (!p_IniPath.substring(p_IniPath.length() - 1, p_IniPath.length()).equals(File.separator)) {
            p_IniPath = p_IniPath + File.separator;
        }
        INIPATH = p_IniPath;
    }

    public LiveDBParserManager(int p_NumberOfThreads) {
        this.m_LiveDBCloseSemaphore = new LiveDBCloseSemaphore(this.getClass().getName());
        if (!this.readIni()) {
            this.m_ParserThreadsCount = DEFAULT_PARSERTHREADSCOUNT;
            this.writeIni();
        } else if (this.m_ParserThreadsCount <= 0) {
            this.m_ParserThreadsCount = DEFAULT_PARSERTHREADSCOUNT;
        }
        if (p_NumberOfThreads > 0) {
            this.m_ParserThreadsCount = p_NumberOfThreads;
        }
        this.m_ArrayListSocketsPending = new ArrayList();
        this.m_ArrayListSocketsInAction = new ArrayList();
        this.m_ArrayListParserThreads = new ArrayList();
        for (int intParserThread = 0; intParserThread < this.m_ParserThreadsCount; ++intParserThread) {
            Thread o_ParserThread = new Thread((Runnable)this, "ClientParserThread" + intParserThread);
            this.m_ArrayListParserThreads.add(o_ParserThread);
            o_ParserThread.start();
        }
    }

    private boolean readIni() {
        boolean boolOK = true;
        File o_FileIni = null;
        InputStreamReader o_FileReaderIni = null;
        BufferedReader o_BufferedReader = null;
        String stringLine = null;
        String[] stringValuePair = null;
        String stringPropertyName = null;
        String stringPropertyValue = null;
        try {
            o_FileIni = new File(INIPATH + INIFILENAME);
            if (!o_FileIni.exists()) {
                return false;
            }
            o_FileReaderIni = new FileReader(o_FileIni);
            o_BufferedReader = new BufferedReader(o_FileReaderIni);
            stringLine = o_BufferedReader.readLine();
            while (stringLine != null) {
                stringValuePair = stringLine.split(m_IniFieldSeperator);
                if (stringValuePair == null) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair.length < 2) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair[1].trim().length() > 0) {
                    stringPropertyName = stringValuePair[0].trim();
                    stringPropertyValue = stringValuePair[1].trim();
                    if (stringPropertyName.equals("ParserThreadsCount")) {
                        this.m_ParserThreadsCount = Integer.valueOf(stringPropertyValue);
                    }
                }
                stringLine = o_BufferedReader.readLine();
            }
        }
        catch (IOException e_IOException) {
            boolOK = false;
        }
        try {
            if (o_BufferedReader != null) {
                o_BufferedReader.close();
            }
            if (o_FileReaderIni != null) {
                o_FileReaderIni.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return boolOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIni() {
        Object object = s_SyncWriteIni;
        synchronized (object) {
            File o_FileOutput = null;
            OutputStreamWriter o_FileWriter = null;
            BufferedWriter o_BufferedWriter = null;
            if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
                return;
            }
            try {
                o_FileOutput = new File(INIPATH + INIFILENAME);
                if (o_FileOutput.exists() && !o_FileOutput.delete()) {
                    this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                    return;
                }
                o_FileOutput.createNewFile();
                if (!o_FileOutput.exists()) {
                    this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                    return;
                }
                o_FileWriter = new FileWriter(o_FileOutput);
                o_BufferedWriter = new BufferedWriter(o_FileWriter);
                String stringPropertyName = "ParserThreadsCount";
                String stringPropertyValue = String.valueOf(this.m_ParserThreadsCount);
                String stringLine = stringPropertyName + m_IniFieldSeperator + stringPropertyValue + m_IniFieldSeperator + "Amount of Parser-Threads, which handles incoming messages asynchronously" + m_IniLineSeperator;
                o_BufferedWriter.write(stringLine);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (o_BufferedWriter != null) {
                    o_BufferedWriter.close();
                }
                if (o_FileWriter != null) {
                    o_FileWriter.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.m_LiveDBCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.m_ParserThreadsExit = true;
        Object object = this.m_SyncParserThreads;
        synchronized (object) {
            this.m_SyncParserThreads.notifyAll();
        }
        int intCount = this.m_ArrayListParserThreads.size();
        for (int intParserThread = 0; intParserThread < intCount; ++intParserThread) {
            Thread o_Thread = this.m_ArrayListParserThreads.get(0);
            try {
                if (Thread.currentThread() != o_Thread) {
                    o_Thread.join(2000L);
                    if (o_Thread.isAlive()) {
                        o_Thread.interrupt();
                    }
                }
                this.m_ArrayListParserThreads.remove(o_Thread);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.m_ArrayListParserThreads != null) {
            this.m_ArrayListParserThreads.clear();
        }
        Object object2 = this.m_SyncParserThreads;
        synchronized (object2) {
            this.m_ArrayListSocketsPending.clear();
            this.m_ArrayListSocketsInAction.clear();
        }
        this.m_LiveDBCloseSemaphore.leaveCloseSection();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeParsing(LiveDBSocket p_LiveDBSocket) {
        if (p_LiveDBSocket == null) {
            return;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncParserThreads;
        synchronized (object) {
            if (this.m_ArrayListSocketsPending.contains(p_LiveDBSocket) || this.m_ArrayListSocketsInAction.contains(p_LiveDBSocket)) {
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
            this.m_ArrayListSocketsPending.add(p_LiveDBSocket);
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            this.m_SyncParserThreads.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LiveDBSocket getNextPendingLiveDBSocket() {
        LiveDBSocket o_LiveDBSocket;
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncParserThreads;
        synchronized (object) {
            if (this.m_ArrayListSocketsPending.size() == 0) {
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return null;
            }
            o_LiveDBSocket = this.m_ArrayListSocketsPending.get(0);
            this.m_ArrayListSocketsPending.remove(0);
            this.m_ArrayListSocketsInAction.add(o_LiveDBSocket);
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBSocket;
    }

    private void parseMessage(LiveDBSocket p_LiveDBSocket, Serializable p_Message) {
        if (p_LiveDBSocket == null) {
            return;
        }
        if (p_Message == null) {
            return;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        try {
            LiveDBSocketChannelManagement.parseMessage(p_LiveDBSocket, p_Message);
        }
        catch (Exception e) {
            p_LiveDBSocket.eventError(e, LiveDBSocketChannelManagement.ERROR_MESSAGEPARSING + " " + p_Message.getClass().getSimpleName());
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Serializable o_Message = null;
        LiveDBSocket o_LiveDBSocket = null;
        while (!this.m_ParserThreadsExit) {
            Object object = this.m_SyncParserThreads;
            synchronized (object) {
                block14: {
                    try {
                        if (this.m_ArrayListSocketsPending.size() > 0) break block14;
                        this.m_SyncParserThreads.wait();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                if (this.m_ParserThreadsExit) {
                    continue;
                }
                o_LiveDBSocket = this.getNextPendingLiveDBSocket();
                if (o_LiveDBSocket == null) {
                    continue;
                }
                o_Message = o_LiveDBSocket.getNextIncomingMessage();
            }
            if (o_Message != null) {
                this.parseMessage(o_LiveDBSocket, o_Message);
            }
            object = this.m_SyncParserThreads;
            synchronized (object) {
                this.m_ArrayListSocketsInAction.remove(o_LiveDBSocket);
                if (o_LiveDBSocket.getIncomingMessageSize() <= 0) {
                    o_LiveDBSocket = null;
                }
            }
            if (o_LiveDBSocket != null) {
                this.invokeParsing(o_LiveDBSocket);
            }
            o_LiveDBSocket = null;
        }
    }
}

