/*
 * Decompiled with CFR 0.152.
 */
package RunPackage;

import OS.OSChecker;
import com.sun.management.OperatingSystemMXBean;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;

public class Run_LiveShow {
    public static long DEFAULTSIZE_MIN_MB = 1500L;
    public static long DEFAULTSIZE_MAX_MB = -1L;
    public static long DEFAULTSIZE_SMALLMIN_MB = 900L;
    public static float DEFAULT_MAXPERCENTAGE = 0.4f;
    public static float DEFAULT_MINPERCENTAGE = 0.4f;
    public static long s_MaxMemory = DEFAULTSIZE_SMALLMIN_MB;
    public static long s_MinMemory = DEFAULTSIZE_SMALLMIN_MB;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                File o_RunFile = null;
                int intOSGroupFlag = OSChecker.getOSGroupFlag();
                switch (intOSGroupFlag) {
                    case 1: {
                        o_RunFile = Run_LiveShow.writeWindowsStartFile();
                        break;
                    }
                    case 3: {
                        o_RunFile = Run_LiveShow.writeMacStartFile();
                        break;
                    }
                    case 2: {
                        o_RunFile = Run_LiveShow.writeLinuxStartFile();
                    }
                }
                if (o_RunFile == null) {
                    return;
                }
                try {
                    o_RunFile.setExecutable(true, false);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        });
    }

    public static String getWorkingDirectory() {
        URL urlWorkingDirectory = Run_LiveShow.class.getProtectionDomain().getCodeSource().getLocation();
        String stringWorkingDirectory = urlWorkingDirectory.getFile();
        try {
            stringWorkingDirectory = URLDecoder.decode(stringWorkingDirectory, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        File o_RunFile = new File(stringWorkingDirectory);
        stringWorkingDirectory = o_RunFile.getParent();
        return stringWorkingDirectory;
    }

    public static String getLiveShowUserPath() {
        StringBuffer o_StringBuffer = new StringBuffer();
        o_StringBuffer.append(OSChecker.getPathUserHomeDirectory());
        o_StringBuffer.append(File.separator);
        o_StringBuffer.append(".LiveShow");
        String stringLiveShowUserDirectory = o_StringBuffer.toString();
        File o_File = new File(stringLiveShowUserDirectory);
        if (!o_File.exists()) {
            try {
                o_File.mkdir();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringLiveShowUserDirectory;
    }

    public static long getTotalPhysicalMemorySize() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long value = operatingSystemMXBean.getTotalPhysicalMemorySize();
        return value;
    }

    public static long getFreePhysicalMemorySize() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long value = operatingSystemMXBean.getFreePhysicalMemorySize();
        return value;
    }

    public static void calculateMemorySize() {
        long longMinSize;
        float longMB = 1048576.0f;
        float longGB = 1.0737418E9f;
        long longTotalMemory = Run_LiveShow.getTotalPhysicalMemorySize();
        long longFreeMemory = Run_LiveShow.getFreePhysicalMemorySize();
        s_MaxMemory = (long)((float)longTotalMemory * DEFAULT_MAXPERCENTAGE / longMB);
        s_MinMemory = (long)((float)longTotalMemory * DEFAULT_MINPERCENTAGE / longMB);
        if (longTotalMemory < 2500000000L) {
            longMinSize = DEFAULTSIZE_SMALLMIN_MB;
            s_MinMemory = DEFAULTSIZE_SMALLMIN_MB;
            s_MaxMemory = DEFAULTSIZE_SMALLMIN_MB;
        } else {
            longMinSize = DEFAULTSIZE_MIN_MB;
        }
        if (s_MinMemory < longMinSize) {
            s_MinMemory = longMinSize;
        } else if (DEFAULTSIZE_MAX_MB > 0L && s_MinMemory > DEFAULTSIZE_MAX_MB) {
            s_MinMemory = DEFAULTSIZE_MAX_MB;
        }
        if (s_MaxMemory < longMinSize) {
            s_MaxMemory = longMinSize;
        } else if (DEFAULTSIZE_MAX_MB > 0L && s_MaxMemory > DEFAULTSIZE_MAX_MB) {
            s_MaxMemory = DEFAULTSIZE_MAX_MB;
        }
    }

    public static void setPermission_Execute(File p_File) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        try {
            Files.setPosixFilePermissions(p_File.toPath(), perms);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static File writeWindowsStartFile() {
        String stringLiveShowUserPath = Run_LiveShow.getLiveShowUserPath();
        String stringFileName = stringLiveShowUserPath + File.separator + "Run_LiveShow_Windows.bat";
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            o_File.delete();
        }
        try {
            Run_LiveShow.calculateMemorySize();
            String stringWorkingDirectory = Run_LiveShow.getWorkingDirectory();
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append("chcp 65001");
            o_StringBuilder.append(System.lineSeparator());
            o_StringBuilder.append("start \"\" \"javaw.exe\" ");
            o_StringBuilder.append(" -Xms" + String.valueOf(s_MinMemory) + "m -Xmx" + String.valueOf(s_MaxMemory) + "m -XX:+UseG1GC -XX:MaxNewSize=128m -jar \"" + stringWorkingDirectory + File.separator + "LiveShow.jar\"");
            o_StringBuilder.append(System.lineSeparator());
            o_StringBuilder.append("exit");
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            OutputStreamWriter o_OutputStreamWriter = new OutputStreamWriter((OutputStream)o_FileOutputStream, "UTF-8");
            o_OutputStreamWriter.write(o_StringBuilder.toString());
            o_OutputStreamWriter.flush();
            o_OutputStreamWriter.close();
            o_FileOutputStream.flush();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return null;
        }
        if (!o_File.exists()) {
            return null;
        }
        return o_File;
    }

    public static File writeMacStartFile() {
        String stringLiveShowUserPath = Run_LiveShow.getLiveShowUserPath();
        String stringFileName = stringLiveShowUserPath + File.separator + "Run_LiveShow_Mac.command";
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            o_File.delete();
        }
        try {
            Run_LiveShow.calculateMemorySize();
            String stringWorkingDirectory = Run_LiveShow.getWorkingDirectory();
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append("#!/bin/bash");
            o_StringBuilder.append(System.lineSeparator());
            o_StringBuilder.append("cd \"" + stringWorkingDirectory + "\"");
            o_StringBuilder.append(System.lineSeparator());
            o_StringBuilder.append("java -Xms" + String.valueOf(s_MinMemory) + "m -Xmx" + String.valueOf(s_MaxMemory) + "m -XX:+UseG1GC -XX:MaxNewSize=128m -jar \"" + stringWorkingDirectory + File.separator + "LiveShow.jar\" &");
            o_StringBuilder.append(System.lineSeparator());
            o_StringBuilder.append("killall Terminal");
            o_StringBuilder.append(System.lineSeparator());
            o_StringBuilder.append("exit");
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            OutputStreamWriter o_OutputStreamWriter = new OutputStreamWriter((OutputStream)o_FileOutputStream, "UTF-8");
            o_OutputStreamWriter.write(o_StringBuilder.toString());
            o_OutputStreamWriter.flush();
            o_OutputStreamWriter.close();
            o_FileOutputStream.flush();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return null;
        }
        if (!o_File.exists()) {
            return null;
        }
        return o_File;
    }

    public static File writeLinuxStartFile() {
        String stringLiveShowUserPath = Run_LiveShow.getLiveShowUserPath();
        String stringFileName = stringLiveShowUserPath + File.separator + "Run_LiveShow_Linux.sh";
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            o_File.delete();
        }
        try {
            Run_LiveShow.calculateMemorySize();
            String stringWorkingDirectory = Run_LiveShow.getWorkingDirectory();
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append("#!/bin/bash");
            o_StringBuilder.append(System.lineSeparator());
            o_StringBuilder.append("cd \"");
            o_StringBuilder.append(stringWorkingDirectory);
            o_StringBuilder.append("\"");
            o_StringBuilder.append(System.lineSeparator());
            if (OSChecker.getOSArchitecture().toLowerCase().contains("arm") && Run_LiveShow.getJavaVersion() <= 8) {
                o_StringBuilder.append("java -Xms" + String.valueOf(s_MinMemory) + "m -Xmx" + String.valueOf(s_MaxMemory) + "m -XX:+UseConcMarkSweepGC -jar \"" + stringWorkingDirectory + File.separator + "LiveShow.jar\"");
            } else {
                o_StringBuilder.append("java -Xms" + String.valueOf(s_MinMemory) + "m -Xmx" + String.valueOf(s_MaxMemory) + "m -XX:+UseG1GC -XX:MaxNewSize=128m -jar \"" + stringWorkingDirectory + File.separator + "LiveShow.jar\"");
            }
            o_StringBuilder.append(" &");
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            OutputStreamWriter o_OutputStreamWriter = new OutputStreamWriter((OutputStream)o_FileOutputStream, "UTF-8");
            o_OutputStreamWriter.write(o_StringBuilder.toString());
            o_OutputStreamWriter.flush();
            o_OutputStreamWriter.close();
            o_FileOutputStream.flush();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return null;
        }
        if (!o_File.exists()) {
            return null;
        }
        return o_File;
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }
}

