/*
 * Decompiled with CFR 0.152.
 */
package StartPackage;

import ClientPackage.LiveDBClient;
import FileToolPackage.FileSelection;
import FileToolPackage.FileTools;
import JarLoader.JarResources;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlObjects.ControlGroup;
import LiveShowObjectPackage.LiveShowJingle;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowProjectDescription;
import MediaGraphicsPackage.LiveShowMediaSourceView;
import MediaObjectPackage.LiveShowMediaObjectDescription;
import MediaObjectPackage.MediaConstants;
import MediaObjectPackage.MediaObject_PlayStatus;
import MediaObjectPackage.MediaSource;
import MediaObjectPackage.MediaSourceListener;
import MediaPackage.MediaServer;
import MediaPackage.MediaServerPanel;
import MediaPackage.ServerAutoDetect_Client_ListModel;
import MediaVirtualPackage.LiveShowMediaObject;
import MediaVirtualPackage.LiveShowMediaVIP;
import MediaVirtualPackage.MediaParentObject;
import MediaVirtualPackage.MediaSource_Client;
import Models.LiveDBListTools;
import PlayMediaPackage.PlayMedia;
import SPITLibraryPackage.SPIT_Message;
import SPITServerPackage.LiveShowSPITObject;
import SPITServerPackage.LiveShowSPITObjectDescription;
import SPITServerPackage.PlaySPIT;
import SPITServerPackage.SPITServer_Client;
import ServerAutoDetectPackage.ServerAutoDetect;
import ServerAutoDetectPackage.ServerAutoDetect_Client;
import SocketMessagePackage.LiveDBConnectionDescription;
import SwingFramePackage.JOptionDialog;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class LiveShowMediaSystem
implements MediaSourceListener {
    public static String FILENAME_MEDIADIRECTORY = "/MediaFiles";
    public static final String FOLDER_LANGUAGES = "Languages";
    public static final String FOLDER_STYLES = "Styles";
    public static Locale s_LanguageLocale;
    public static Font s_FontDefault;
    public static ServerAutoDetect_Client s_ServerAutoDetect_Client;
    public static MediaServerTableModel s_MediaServerTableModel;
    public static MediaServerSelectionTableModel s_MediaServerSelectionTableModel;
    @LiveLanguageString
    public static String MEDIASERVER_NOTCONNECTED;
    @LiveLanguageString
    public static String MEDIASERVER;
    @LiveLanguageString
    public static String SPITCLIENT;
    @LiveLanguageString
    public static String SPITCLIENT_NOTCONNECTED;
    @LiveLanguageString
    public static String SPITCLIENT_NOTCONFIRMED;
    @LiveLanguageString
    public static String FILENOTFOUND_TITEL;
    @LiveLanguageString
    public static String FILENOTFOUND_REMARK;
    @LiveLanguageString
    public static String FILENOTFOUND_BUTTON_SEARCH;
    @LiveLanguageString
    public static String FILENOTFOUND_BUTTON_DISCARD;
    @LiveLanguageString
    public static String FILENOTFOUND_BUTTON_DISCARDALL;
    public static boolean s_FIleNotFoundCancelAll;
    @LiveLanguageString
    public static String FILENOTWRITEPERMISSION_TITEL;
    @LiveLanguageString
    public static String FILENOTWRITEPERMISSION_REASON;
    @LiveLanguageString
    public static String FILENOTWRITEPERMISSION_EFFECT;
    @LiveLanguageString
    public static String FILENOTWRITEPERMISSION_REMARK;
    @LiveLanguageString
    public static String FILENOTWRITEPERMISSION_QUESTION;
    @LiveLanguageString
    public static String FILEDUPLICATION_TITEL;
    @LiveLanguageString
    public static String FILEDUPLICATION_REASON;
    @LiveLanguageString
    public static String FILEDUPLICATION_EFFECT;
    @LiveLanguageString
    public static String FILEDUPLICATION_REMARK;
    @LiveLanguageString
    public static String FILEDUPLICATIONSAMECONTENT_TITEL;
    @LiveLanguageString
    public static String FILEDUPLICATIONSAMECONTENT_REASON;
    @LiveLanguageString
    public static String FILEDUPLICATIONSAMECONTENT_EFFECT;
    @LiveLanguageString
    public static String FILEDUPLICATIONSAMECONTENT_REMARK;
    @LiveLanguageString
    public static String FILEDUPLICATIONSAMECONTENT_QUESTION;
    @LiveLanguageString
    public static String FILEREPLACEMENT_REASON;
    @LiveLanguageString
    public static String FILEREPLACEMENT_EFFECT;
    @LiveLanguageString
    public static String FILEREPLACEMENT_REMARK;
    @LiveLanguageString
    public static String FILEREPLACEMENT_QUESTION;
    @LiveLanguageString
    public static String LOAD_MEDIAFILE;
    @LiveLanguageString
    public static String UPLOAD_MEDIAFILE;
    @LiveLanguageString
    public static String UPLOAD_CANCELLED;
    @LiveLanguageString
    public static String UPLOAD_ERROR;
    private static LiveShowProjectDescription s_LiveShowProjectDescription;
    private static MediaServerPanel s_MediaServerPanel;
    private static MediaSource.MediaSourceTableModel s_MediaSourceTableModel;
    private static MediaSource.MediaSourcetListModel s_MediaSourceListModel_ImagesText;
    public static LiveShowMediaSourceView s_LiveShowMediaSourceView;
    private static LiveShowMediaVIP s_LiveShowMediaVIP;
    private static ArrayList<MediaParentObject> s_JingleObjects;
    private static final Object s_SyncJingles;
    public static LiveShowMediaSystem s_SingleInstance;
    private static final Object s_SyncVIP;
    private static final Object s_SyncMediaSource;
    private static final Object s_SyncPlayBuffer;
    private static ArrayList<PlayMedia> s_PlayMedias;
    private static final Object s_SyncExport;
    private static ArrayList<File> s_ExportedFiles;
    private static ArrayList<String> s_ExportedFileCheckSums;
    private static HashMap<String, String> s_ExportedReplacement;
    public static File s_LastOpenFilePath;
    public static ControlGroup s_ControlGroup_Active;
    public static JarResources s_JarResources_Default;
    public static WindowFocusListener s_HelpFocusListener;
    public static LiveShowJingle.JingleCreatorInterface s_JingleCreatorInterface;
    public static LiveShowJingle.JingleContainerInterface s_JingleContainerInterface;

    public LiveShowMediaSystem() {
        this.initMembers();
        LiveShowMediaSystem.init();
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private static void init() {
        s_LanguageLocale = Locale.getDefault();
        s_FontDefault = UIManager.getFont(s_LanguageLocale);
    }

    private void initMembers() {
    }

    public static void closeProject() {
        s_MediaServerTableModel.clear();
        LiveShowMediaObjectDescription.poolClear();
        MediaObject_PlayStatus.poolClear();
        MediaObject_PlayStatus.ObjectPlayStatus.poolClear();
        MediaObject_PlayStatus.ObjectPlayStatusPlayer.poolClear();
        LiveShowSPITObjectDescription.poolClear();
        PlaySPIT.PlayStatus.poolClear();
    }

    public static void setLiveShowProjectDescription(LiveShowProjectDescription p_LiveShowProjectDescription) {
        s_LiveShowProjectDescription = p_LiveShowProjectDescription;
        LiveShowMediaObject.clearHashMapFilePositions();
        s_FIleNotFoundCancelAll = false;
    }

    public static LiveShowProjectDescription getLiveShowProjectDescription() {
        return s_LiveShowProjectDescription;
    }

    public static String getProjectName() {
        if (s_LiveShowProjectDescription == null) {
            return "";
        }
        return s_LiveShowProjectDescription.getProjectName();
    }

    public static String getFolderStyles() {
        return FOLDER_STYLES;
    }

    public static Locale getLanguageLocale() {
        if (s_LanguageLocale == null) {
            return Locale.getDefault();
        }
        return s_LanguageLocale;
    }

    public static Font getFontDefault() {
        return s_FontDefault;
    }

    public static void notifyError(Exception p_Exception, String p_Titel, String p_Remark1, String p_Remark2) {
        String stringRemark = "<html>" + p_Remark1 + "<br>" + p_Remark2 + "</html>";
        JOptionDialog.showMessageDialog(null, stringRemark, p_Titel, 0);
    }

    public static void addPlayMedia(PlayMedia p_PlayMedia) {
        if (p_PlayMedia == null) {
            return;
        }
        if (s_PlayMedias != null) {
            if (s_PlayMedias.contains(p_PlayMedia)) {
                return;
            }
            s_PlayMedias.add(p_PlayMedia);
        }
    }

    public static void removePlayMedia(PlayMedia p_PlayMedia) {
        if (p_PlayMedia == null) {
            return;
        }
        if (s_PlayMedias != null) {
            if (!s_PlayMedias.contains(p_PlayMedia)) {
                return;
            }
            s_PlayMedias.remove(p_PlayMedia);
        }
    }

    public static ArrayList<PlayMedia> getPlayMedias() {
        return s_PlayMedias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File checkMediaFileNameDuplicated_load(File p_MediaFile) {
        if (p_MediaFile == null) {
            return null;
        }
        MediaSource o_MediaSource = null;
        String stringMediaFileName = p_MediaFile.getName();
        Object object = s_SyncMediaSource;
        synchronized (object) {
            for (int intMediaSource = 0; intMediaSource < s_MediaSourceTableModel.size(); ++intMediaSource) {
                o_MediaSource = (MediaSource)s_MediaSourceTableModel.get(intMediaSource);
                if (o_MediaSource == null) continue;
                File o_MediaFile = o_MediaSource.getFile();
                if (FileTools.getPathName(p_MediaFile).equals(FileTools.getPathName(o_MediaFile))) {
                    return null;
                }
                if (o_MediaFile.getName().equals(stringMediaFileName)) {
                    return o_MediaFile;
                }
                o_MediaSource = null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaSource getLiveShowMediaSourceByFileName(String p_FileName) {
        Object object = s_SyncMediaSource;
        synchronized (object) {
            for (int intHD = 0; intHD < s_MediaSourceTableModel.size(); ++intHD) {
                File o_MediaFile;
                MediaSource o_MediaSource = (MediaSource)s_MediaSourceTableModel.get(intHD);
                if (o_MediaSource == null || (o_MediaFile = o_MediaSource.getFile()) == null) continue;
                if (o_MediaFile.getName().equals(p_FileName)) {
                    return o_MediaSource;
                }
                o_MediaSource = null;
            }
        }
        return null;
    }

    public static int showOptionPane_WarningWritable(File p_MediaFile, File p_Directory) {
        JLabel o_LabelMessage = new JLabel();
        StringBuffer o_StringBuffer = new StringBuffer();
        o_StringBuffer.append("<html>");
        if (p_MediaFile != null) {
            o_StringBuffer.append("<b>");
            o_StringBuffer.append(p_MediaFile.getName());
            o_StringBuffer.append("</b><br>");
        }
        o_StringBuffer.append(FILENOTWRITEPERMISSION_REASON);
        o_StringBuffer.append("<br>");
        o_StringBuffer.append(FILENOTWRITEPERMISSION_EFFECT);
        o_StringBuffer.append("<br>");
        o_StringBuffer.append(FILENOTWRITEPERMISSION_REMARK);
        o_StringBuffer.append("<br>");
        o_StringBuffer.append(FILENOTWRITEPERMISSION_QUESTION);
        o_StringBuffer.append("</html>");
        o_LabelMessage.setText(o_StringBuffer.toString());
        int intAnswer = JOptionDialog.showConfirmDialog(null, o_LabelMessage, FILENOTWRITEPERMISSION_TITEL + p_Directory.getAbsolutePath(), 0, 0, 1);
        return intAnswer;
    }

    public static void showOptionPane_WarningWritable_Save(File p_MediaFile, File p_Directory) {
        JLabel o_LabelMessage = new JLabel();
        StringBuffer o_StringBuffer = new StringBuffer();
        o_StringBuffer.append("<html>");
        if (p_MediaFile != null) {
            o_StringBuffer.append("<b>");
            o_StringBuffer.append(p_MediaFile.getName());
            o_StringBuffer.append("</b><br>");
        }
        o_StringBuffer.append(FILENOTWRITEPERMISSION_REASON);
        o_StringBuffer.append("</html>");
        o_LabelMessage.setText(o_StringBuffer.toString());
        JOptionDialog.showMessageDialog(null, o_LabelMessage, FILENOTWRITEPERMISSION_TITEL + p_Directory.getAbsolutePath(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File checkMediaFileNameDuplicated_save(File p_MediaFile, File o_NewDirectory) {
        if (p_MediaFile == null) {
            return null;
        }
        if (o_NewDirectory == null) {
            return null;
        }
        String stringMediaFileName = p_MediaFile.getName();
        Object object = s_SyncMediaSource;
        synchronized (object) {
            File[] o_Files = o_NewDirectory.listFiles();
            if (o_Files == null) {
                return null;
            }
            for (int intFile = 0; intFile < o_Files.length; ++intFile) {
                File o_MediaFile = o_Files[intFile];
                if (o_MediaFile == null) continue;
                if (FileTools.getPathName(p_MediaFile).equals(FileTools.getPathName(o_MediaFile))) {
                    return null;
                }
                if (!o_MediaFile.getName().equals(stringMediaFileName)) continue;
                if (MediaSource.autoDetectMediaType((File)p_MediaFile) != 1002) {
                    return null;
                }
                if (FileTools.getCheckSum_MD5_Partial(o_MediaFile).equals(FileTools.getCheckSum_MD5_Partial(p_MediaFile))) {
                    return null;
                }
                return o_MediaFile;
            }
        }
        return null;
    }

    public static int showOptionPane_WarningFileDuplication(File p_MediaFile, File p_ProblemFile) {
        JLabel o_LabelMessage = new JLabel();
        o_LabelMessage.setText("<html>" + FileTools.getPathName(p_ProblemFile) + File.separator + p_ProblemFile.getName() + "<br>" + FileTools.getPathName(p_MediaFile) + File.separator + p_MediaFile.getName() + "<br>" + FILEDUPLICATION_REASON + "<br>" + FILEDUPLICATION_EFFECT + "<br><br>" + FILEDUPLICATION_REMARK + "<br>" + FileTools.getPathName(p_MediaFile) + File.separator + p_MediaFile.getName() + "<br></html>");
        JOptionDialog.showMessageDialog(null, o_LabelMessage, FILEDUPLICATION_TITEL + p_MediaFile.getAbsolutePath(), 0);
        return 1;
    }

    public static int showOptionPane_WarningFileDuplication_SameContent(File p_MediaFile, File p_ProblemFile) {
        JLabel o_LabelMessage = new JLabel();
        o_LabelMessage.setText("<html>" + FileTools.getPathName(p_ProblemFile) + File.separator + p_ProblemFile.getName() + "<br>" + FileTools.getPathName(p_MediaFile) + File.separator + p_MediaFile.getName() + "<br>" + FILEDUPLICATIONSAMECONTENT_REASON + "<br>" + FILEDUPLICATIONSAMECONTENT_EFFECT + "<br><br>" + FILEDUPLICATIONSAMECONTENT_REMARK + "<br><br>" + FILEDUPLICATIONSAMECONTENT_QUESTION + "<br>" + FileTools.getPathName(p_ProblemFile) + File.separator + p_ProblemFile.getName() + "<br></html>");
        return JOptionDialog.showConfirmDialog(null, o_LabelMessage, FILEDUPLICATIONSAMECONTENT_TITEL + p_MediaFile.getAbsolutePath(), 0, 2, 1);
    }

    public static String showOptionPane_ReplaceFileDuplication(File p_MediaFile, File p_ProblemFile) {
        JLabel o_LabelMessage = new JLabel();
        o_LabelMessage.setText("<html>" + FileTools.getPathName(p_ProblemFile) + "/" + p_ProblemFile.getName() + "<br>" + FileTools.getPathName(p_MediaFile) + "/" + p_MediaFile.getName() + "<br>" + FILEREPLACEMENT_REASON + "<br>" + FILEREPLACEMENT_EFFECT + "<br><br>" + FILEREPLACEMENT_REMARK + "<br>" + FileTools.getPathName(p_MediaFile) + "/" + p_MediaFile.getName() + "<br><br>" + FILEREPLACEMENT_QUESTION + "</html>");
        String o_String = JOptionDialog.showInputDialog(null, o_LabelMessage, FILEDUPLICATION_TITEL + p_MediaFile.getAbsolutePath(), 2);
        return o_String;
    }

    public static MediaServerPanel getMediaServerPanel() {
        return s_MediaServerPanel;
    }

    public static MediaSource_Client createMediaSource(String p_MediaFilePathName) {
        File o_File = new File(p_MediaFilePathName);
        return LiveShowMediaSystem.createMediaSource(o_File);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaSource_Client createMediaSource(File p_MediaFile) {
        if (p_MediaFile == null) {
            return null;
        }
        if (!p_MediaFile.exists()) {
            return null;
        }
        MediaSource_Client o_MediaSource_Client = null;
        Object object = s_SyncMediaSource;
        synchronized (object) {
            o_MediaSource_Client = LiveShowMediaSystem.getMediaSource(p_MediaFile);
            if (o_MediaSource_Client == null) {
                try {
                    o_MediaSource_Client = new MediaSource_Client(p_MediaFile);
                    LiveShowMediaSystem.addMediaSource(o_MediaSource_Client);
                }
                catch (Exception e) {
                    if (o_MediaSource_Client != null) {
                        o_MediaSource_Client.close();
                    }
                    o_MediaSource_Client = null;
                }
            }
        }
        return o_MediaSource_Client;
    }

    public static MediaSource.MediaSourceTableModel getMediaSourceTableModel() {
        return s_MediaSourceTableModel;
    }

    public static MediaSource.MediaSourcetListModel getMediaSourceListModel_ImagesText() {
        return s_MediaSourceListModel_ImagesText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMediaSourceCount() {
        int intMediaSourceCount = 0;
        Object object = s_SyncMediaSource;
        synchronized (object) {
            intMediaSourceCount = s_MediaSourceTableModel.size();
        }
        return intMediaSourceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaSource_Client getMediaSource(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        MediaSource_Client o_MediaSource_Client = null;
        Object object = s_SyncMediaSource;
        synchronized (object) {
            if (p_Index < s_MediaSourceTableModel.size()) {
                o_MediaSource_Client = (MediaSource_Client)s_MediaSourceTableModel.get(p_Index);
            }
        }
        return o_MediaSource_Client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaSource_Client getMediaSource(File p_MediaFile) {
        if (p_MediaFile == null) {
            return null;
        }
        MediaSource_Client o_MediaSource_Client = null;
        Object object = s_SyncMediaSource;
        synchronized (object) {
            for (int intMediaSource = 0; intMediaSource < s_MediaSourceTableModel.size(); ++intMediaSource) {
                o_MediaSource_Client = (MediaSource_Client)s_MediaSourceTableModel.get(intMediaSource);
                if (o_MediaSource_Client == null) continue;
                File o_MediaFile = o_MediaSource_Client.getFile();
                if (p_MediaFile.equals(o_MediaFile)) break;
                o_MediaSource_Client = null;
            }
        }
        return o_MediaSource_Client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaSource_Client getMediaSource(LiveShowMediaObjectDescription p_LiveShowMediaObjectDescription) {
        if (p_LiveShowMediaObjectDescription == null) {
            return null;
        }
        MediaSource_Client o_MediaSource_Client = null;
        String stringSourceString = p_LiveShowMediaObjectDescription.getSourceString();
        if (stringSourceString == null) {
            return null;
        }
        Object object = s_SyncMediaSource;
        synchronized (object) {
            for (int intMediaSource = 0; intMediaSource < s_MediaSourceTableModel.size(); ++intMediaSource) {
                o_MediaSource_Client = (MediaSource_Client)s_MediaSourceTableModel.get(intMediaSource);
                if (o_MediaSource_Client == null) continue;
                File o_MediaFile = o_MediaSource_Client.getFile();
                if (stringSourceString.equals(o_MediaFile.getPath())) break;
                o_MediaSource_Client = null;
            }
        }
        return o_MediaSource_Client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addMediaSource(MediaSource p_MediaSource) {
        if (p_MediaSource == null) {
            return false;
        }
        boolean boolAdded = false;
        Object object = s_SyncMediaSource;
        synchronized (object) {
            if (s_MediaSourceTableModel.contains((Object)p_MediaSource)) {
                boolAdded = true;
            } else {
                s_MediaSourceTableModel.add((Object)p_MediaSource);
                if (p_MediaSource.getMediaType() == 1001 || p_MediaSource.getMediaType() == 1003) {
                    s_MediaSourceListModel_ImagesText.addDMXMediaSource(p_MediaSource);
                }
                p_MediaSource.addMediaSourceListener((MediaSourceListener)s_SingleInstance);
                boolAdded = true;
            }
        }
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeMediaSource(MediaSource p_MediaSource) {
        if (p_MediaSource == null) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = s_SyncMediaSource;
        synchronized (object) {
            s_MediaSourceListModel_ImagesText.removeMediaSource(p_MediaSource);
            boolRemoved = s_MediaSourceTableModel.remove((Object)p_MediaSource);
            if (boolRemoved) {
                p_MediaSource.removeMediaSourceListener((MediaSourceListener)s_SingleInstance);
            }
        }
        return boolRemoved;
    }

    public static LiveShowMediaSourceView getLiveShowMediaSourceView() {
        return s_LiveShowMediaSourceView;
    }

    public void eventMediaSourceInvalidFile(MediaSource p_MediaSource, File p_MediaFile) {
    }

    public void eventMediaSourceOpened(MediaSource p_MediaSource, File p_MediaFile, long p_SectionStart, long p_SectionEnd) {
    }

    public void eventMediaSourceClosing(MediaSource p_MediaSource) {
        LiveShowMediaSystem.removeMediaSource(p_MediaSource);
    }

    public void eventMediaSourceRefreshing(MediaSource p_MediaSource) {
    }

    public static File searchLostMediaSourceFile(File p_File) {
        File o_SelectedFile = null;
        if (p_File == null) {
            return null;
        }
        if (s_FIleNotFoundCancelAll) {
            return null;
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] options = new Object[]{FILENOTFOUND_BUTTON_SEARCH, FILENOTFOUND_BUTTON_DISCARD, FILENOTFOUND_BUTTON_DISCARDALL};
        StringBuffer stringBufferRemark = new StringBuffer();
        stringBufferRemark.append("<html>");
        stringBufferRemark.append("<b>");
        stringBufferRemark.append("<center>");
        stringBufferRemark.append(p_File.getName());
        stringBufferRemark.append("</center>");
        stringBufferRemark.append("</b>");
        stringBufferRemark.append("<br>");
        stringBufferRemark.append(FILENOTFOUND_REMARK);
        stringBufferRemark.append("</html>");
        int intResult = JOptionDialog.showOptionDialog(null, stringBufferRemark.toString(), p_File.getName() + " " + FILENOTFOUND_TITEL, 1, -1, null, options, options[0]);
        switch (intResult) {
            case 0: {
                break;
            }
            case 1: {
                return null;
            }
            case 2: {
                s_FIleNotFoundCancelAll = true;
                return null;
            }
        }
        FileNameExtensionFilter o_FileNameExtensionFilter = null;
        if (MediaSource.MEDIAFILE_FILTER_IMAGE.accept(p_File)) {
            o_FileNameExtensionFilter = MediaSource.MEDIAFILE_FILTER_IMAGE;
        }
        if (MediaSource.MEDIAFILE_FILTER_VIDEO.accept(p_File)) {
            o_FileNameExtensionFilter = MediaSource.MEDIAFILE_FILTER_VIDEO;
        }
        if (MediaSource.MEDIAFILE_FILTER_TEXT.accept(p_File)) {
            o_FileNameExtensionFilter = MediaSource.MEDIAFILE_FILTER_TEXT;
        }
        if (p_File.getParentFile() == null && s_LastOpenFilePath != null) {
            p_File = new File(s_LastOpenFilePath.getAbsolutePath() + File.separator + p_File.getName());
        }
        if ((o_SelectedFile = FileSelection.showOpen(null, p_File.getName() + " " + FILENOTFOUND_TITEL, p_File.getParentFile(), o_FileNameExtensionFilter, true, true, MediaSource.MEDIAFILE_FILTER_IMAGE, null, MediaSource.MEDIAFILE_FILTER_VIDEO, MediaSource.MEDIAFILE_FILTER_TEXT)) != null) {
            if (o_SelectedFile.isDirectory()) {
                o_SelectedFile = null;
            } else {
                s_LastOpenFilePath = o_SelectedFile.getParentFile();
            }
        }
        return o_SelectedFile;
    }

    public static File loadMediaFile(String p_Title, File p_LastDirectory) {
        FileNameExtensionFilter o_FileNameExtensionFilter = MediaSource.MEDIAFILE_FILTER_ALLMEDIA;
        File o_SelectedFile = FileSelection.showOpen(null, p_Title, p_LastDirectory, MediaSource.MEDIAFILE_FILTER_ALLMEDIA, true, true, MediaSource.MEDIAFILE_FILTER_IMAGE, null, MediaSource.MEDIAFILE_FILTER_VIDEO, MediaSource.MEDIAFILE_FILTER_TEXT);
        return o_SelectedFile;
    }

    public static File getLastOpenedFilePath() {
        return s_LastOpenFilePath;
    }

    public static void setLastOpenedFilePath(File p_File) {
        if (p_File == null) {
            if (s_LastOpenFilePath == null) {
                return;
            }
        } else {
            if (!p_File.isDirectory()) {
                p_File = p_File.getParentFile();
            }
            if (p_File.equals(s_LastOpenFilePath)) {
                return;
            }
        }
        s_LastOpenFilePath = p_File;
        PlayMedia.writeIni();
    }

    public static void setLiveShowMediaVIP(LiveShowMediaVIP p_LiveShowMediaVIP) {
        s_LiveShowMediaVIP = p_LiveShowMediaVIP;
    }

    public static void removeLiveShowMediaVIP(LiveShowMediaVIP p_LiveShowMediaVIP) {
        if (s_LiveShowMediaVIP != p_LiveShowMediaVIP) {
            return;
        }
        s_LiveShowMediaVIP = null;
    }

    public static LiveShowMediaVIP getLiveShowMediaVIP() {
        return s_LiveShowMediaVIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportedFileList_Clear() {
        Object object = s_SyncExport;
        synchronized (object) {
            s_ExportedFiles.clear();
            s_ExportedFileCheckSums.clear();
            s_ExportedReplacement.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportedFileList_Add(File p_File) {
        if (p_File == null) {
            return false;
        }
        Object object = s_SyncExport;
        synchronized (object) {
            int intIndex = s_ExportedFiles.indexOf(p_File);
            if (intIndex >= 0) {
                s_ExportedFileCheckSums.set(intIndex, FileTools.getCheckSum_MD5_Partial(p_File));
                return false;
            }
            s_ExportedFiles.add(p_File);
            s_ExportedFileCheckSums.add(FileTools.getCheckSum_MD5_Partial(p_File));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportedFileList_Remove(File p_File) {
        if (p_File == null) {
            return false;
        }
        File o_FileRemoved = null;
        Object object = s_SyncExport;
        synchronized (object) {
            int intIndex = s_ExportedFiles.indexOf(p_File);
            if (intIndex >= 0) {
                try {
                    o_FileRemoved = s_ExportedFiles.remove(intIndex);
                    s_ExportedFileCheckSums.remove(intIndex);
                }
                catch (Exception e) {
                    if (o_FileRemoved != null) {
                        // empty if block
                    }
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportedFileList_Contains(File p_File) {
        Object object = s_SyncExport;
        synchronized (object) {
            if (p_File == null) {
                return false;
            }
            return s_ExportedFiles.contains(p_File);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exported_FileList_CheckSum(File p_File) {
        if (p_File == null) {
            return "";
        }
        Object object = s_SyncExport;
        synchronized (object) {
            int intIndex = s_ExportedFiles.indexOf(p_File);
            if (intIndex < 0) {
                return "";
            }
            try {
                return s_ExportedFileCheckSums.get(intIndex);
            }
            catch (Exception exception) {
                return "";
            }
        }
    }

    public static boolean exportLiveShowMediaObject(ObjectOutput out, LiveShowMediaObject p_LiveShowMediaObject, LiveShowProjectDescription p_LiveShowProjectDescription) throws IOException {
        if (p_LiveShowMediaObject == null) {
            return false;
        }
        File o_MediaFile = null;
        String o_StringReplacement = null;
        boolean boolSuccess = true;
        MediaSource o_MediaSource = p_LiveShowMediaObject.getMediaSource();
        if (o_MediaSource != null) {
            String stringNewPath = p_LiveShowProjectDescription.getProjectPath();
            o_MediaFile = o_MediaSource.getFile();
            if (o_MediaFile != null) {
                if (s_ExportedReplacement != null) {
                    o_StringReplacement = s_ExportedReplacement.get(o_MediaFile.getPath());
                }
                if (o_StringReplacement == null) {
                    String stringNewName;
                    o_StringReplacement = o_MediaFile.getName();
                    File o_NewDirectory = new File(stringNewPath + FILENAME_MEDIADIRECTORY);
                    File o_ProblemFile = LiveShowMediaSystem.checkMediaFileNameDuplicated_save(o_MediaFile, o_NewDirectory);
                    if (o_ProblemFile != null && (stringNewName = LiveShowMediaSystem.showOptionPane_ReplaceFileDuplication(o_MediaFile, o_ProblemFile)) != null) {
                        File o_File = new File(stringNewName);
                        o_StringReplacement = o_File.getName();
                    }
                }
            }
        }
        if (o_MediaFile != null && (boolSuccess = p_LiveShowMediaObject.exportExternal(out, p_LiveShowProjectDescription, o_StringReplacement)) && s_ExportedReplacement != null) {
            s_ExportedReplacement.put(o_MediaFile.getPath(), o_StringReplacement);
        }
        return boolSuccess;
    }

    public static void setControlGroupActive(ControlGroup p_ControlGroup) {
        s_ControlGroup_Active = p_ControlGroup;
    }

    public static ControlGroup getControlGroupActive() {
        return s_ControlGroup_Active;
    }

    public static ServerAutoDetect_Client getServerAutoDetect_Client() {
        return s_ServerAutoDetect_Client;
    }

    public static int getMediaServerCount() {
        return s_MediaServerTableModel.size();
    }

    public static MediaServer getMediaServer(int p_Index) {
        return s_MediaServerTableModel.getMediaServer(p_Index);
    }

    public static void setJingleCreator(LiveShowJingle.JingleCreatorInterface p_JingleCreatorInterface) {
        s_JingleCreatorInterface = p_JingleCreatorInterface;
    }

    public static LiveShowJingle.JingleInterface createJingle(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (s_JingleCreatorInterface == null) {
            return null;
        }
        return s_JingleCreatorInterface.createJingle(p_LiveShowObjectDescription);
    }

    public static LiveShowJingle.JingleInterface createJingle(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (s_JingleCreatorInterface == null) {
            return null;
        }
        return s_JingleCreatorInterface.createJingle(p_LiveShowObjectInterface);
    }

    public static void setJingleContainer(LiveShowJingle.JingleContainerInterface p_JingleContainerInterface) {
        s_JingleContainerInterface = p_JingleContainerInterface;
    }

    public static LiveShowJingle.JingleContainerInterface getJingleContainerInterface() {
        return s_JingleContainerInterface;
    }

    public static int getJingleObjectCount() {
        LiveShowJingle.JingleContainerInterface o_JingleContainerInterface = s_JingleContainerInterface;
        if (o_JingleContainerInterface == null) {
            return 0;
        }
        return o_JingleContainerInterface.getJingleViewCount();
    }

    public static MediaParentObject getJingleObject(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        LiveShowJingle.JingleContainerInterface o_JingleContainerInterface = s_JingleContainerInterface;
        if (o_JingleContainerInterface == null) {
            return null;
        }
        LiveShowJingle.JingleInterface o_JingleInterface = o_JingleContainerInterface.getJingleView(p_Index);
        if (o_JingleInterface == null) {
            return null;
        }
        return (MediaParentObject)o_JingleInterface.getLiveShowObject();
    }

    public static LiveShowObjectInterface getJingleObject(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        LiveShowJingle.JingleContainerInterface o_JingleContainerInterface = s_JingleContainerInterface;
        if (o_JingleContainerInterface == null) {
            return null;
        }
        for (int intObject = 0; intObject < o_JingleContainerInterface.getJingleViewCount(); ++intObject) {
            LiveShowJingle.JingleInterface o_JingleInterface = o_JingleContainerInterface.getJingleView(intObject);
            LiveShowObject o_LiveShowObjectInterface = o_JingleInterface.getLiveShowObject();
            if (o_LiveShowObjectInterface == null || !p_ID.equals(o_LiveShowObjectInterface.getID())) continue;
            return o_LiveShowObjectInterface;
        }
        return null;
    }

    public static LiveShowMediaObject getJingleMediaObject(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        MediaParentObject o_MediaParentObject = (MediaParentObject)LiveShowMediaSystem.getJingleObject(p_ID);
        if (o_MediaParentObject == null) {
            return null;
        }
        if (!(o_MediaParentObject instanceof LiveShowMediaObject)) {
            return null;
        }
        return (LiveShowMediaObject)o_MediaParentObject;
    }

    public static LiveShowSPITObject getJingleSPITObject(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        MediaParentObject o_MediaParentObject = (MediaParentObject)LiveShowMediaSystem.getJingleObject(p_ID);
        if (o_MediaParentObject == null) {
            return null;
        }
        if (!(o_MediaParentObject instanceof LiveShowSPITObject)) {
            return null;
        }
        return (LiveShowSPITObject)o_MediaParentObject;
    }

    public static boolean removeJingleSPIT(LiveShowSPITObject p_LiveShowSPITObject) {
        if (p_LiveShowSPITObject == null) {
            return false;
        }
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createRemoveSPITObject((String)p_LiveShowSPITObject.getID());
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
        p_LiveShowSPITObject.close(true);
        return true;
    }

    public static void setHelpFocusListener(WindowFocusListener p_HelpFocusListener) {
        s_HelpFocusListener = p_HelpFocusListener;
    }

    public static WindowFocusListener getHelpFocusListener() {
        return s_HelpFocusListener;
    }

    static {
        s_ServerAutoDetect_Client = ServerAutoDetect_Client.startServerAutoDetect(null, (String)MediaConstants.MEDIASERVERTASKID, (int)15109);
        s_MediaServerTableModel = new MediaServerTableModel();
        s_MediaServerSelectionTableModel = new MediaServerSelectionTableModel();
        MEDIASERVER_NOTCONNECTED = "Not Connected";
        MEDIASERVER = "Media Server";
        SPITCLIENT = "Trigger Client";
        SPITCLIENT_NOTCONNECTED = "Not Connected";
        SPITCLIENT_NOTCONFIRMED = "not confirmed";
        FILENOTFOUND_TITEL = "not found - search new position";
        FILENOTFOUND_REMARK = "<html>not found!<br>You can: <br>search for the file not found<br>or discard all media objects that use this file<br>or discard all media objects whose media file is not found.</html>";
        FILENOTFOUND_BUTTON_SEARCH = "search";
        FILENOTFOUND_BUTTON_DISCARD = "discard";
        FILENOTFOUND_BUTTON_DISCARDALL = "discard all";
        s_FIleNotFoundCancelAll = false;
        FILENOTWRITEPERMISSION_TITEL = "No write permission: ";
        FILENOTWRITEPERMISSION_REASON = "You have no write permission at this location.";
        FILENOTWRITEPERMISSION_EFFECT = "No markers can be saved by the software.";
        FILENOTWRITEPERMISSION_REMARK = "It's better to copy the file to another location with write permission and load it from there!";
        FILENOTWRITEPERMISSION_QUESTION = "Do you want to load the file nevertheless?";
        FILEDUPLICATION_TITEL = "Mediafile names duplicated";
        FILEDUPLICATION_REASON = "The media-files have identically names.";
        FILEDUPLICATION_EFFECT = "This may occur problems when the mediafiles will be exported!";
        FILEDUPLICATION_REMARK = "You should first rename the file and then load it again!";
        FILEDUPLICATIONSAMECONTENT_TITEL = "Mediafile already exists";
        FILEDUPLICATIONSAMECONTENT_REASON = "The media-files have identically names but different location.";
        FILEDUPLICATIONSAMECONTENT_EFFECT = "Problems occurs when files with the same name but different content are used.";
        FILEDUPLICATIONSAMECONTENT_REMARK = "The contents of the files seems to be equal!";
        FILEDUPLICATIONSAMECONTENT_QUESTION = "Do you want to load the existing file instead?";
        FILEREPLACEMENT_REASON = "The media-files have identically names.";
        FILEREPLACEMENT_EFFECT = "If You don't change the name the files will be overwritten!";
        FILEREPLACEMENT_REMARK = "The following file should be renamed, except you are shure that the contents are identically!";
        FILEREPLACEMENT_QUESTION = "Enter a new name:";
        LOAD_MEDIAFILE = "Load Mediafile";
        UPLOAD_MEDIAFILE = "Upload File to MediaServer: ";
        UPLOAD_CANCELLED = "Upload CANCELLED";
        UPLOAD_ERROR = "Upload ERROR";
        s_MediaServerPanel = new MediaServerPanel();
        s_MediaSourceTableModel = new MediaSource.MediaSourceTableModel();
        s_MediaSourceListModel_ImagesText = new MediaSource.MediaSourcetListModel();
        s_LiveShowMediaSourceView = new LiveShowMediaSourceView();
        s_JingleObjects = new ArrayList();
        s_SyncJingles = new Object();
        s_SingleInstance = new LiveShowMediaSystem();
        s_SyncVIP = new Object();
        s_SyncMediaSource = new Object();
        s_SyncPlayBuffer = new Object();
        s_PlayMedias = new ArrayList();
        s_SyncExport = new Object();
        s_ExportedFiles = new ArrayList();
        s_ExportedFileCheckSums = new ArrayList();
        s_ExportedReplacement = new HashMap();
        s_LastOpenFilePath = null;
        s_ControlGroup_Active = null;
        s_JarResources_Default = new JarResources(LiveShowMediaSystem.getFolderStyles() + File.separator + "LiveShowControls_Black.jar");
        s_JingleCreatorInterface = null;
        s_JingleContainerInterface = null;
    }

    public static class MediaServerSelectionTableModel
    extends MediaServerTableModel {
        public static int s_ColumnCount = 8;
        public static final int s_IndexSelected = 7;
        @LiveLanguageString
        private static String s_ColumnSelected = "Selected";
        @LiveLanguageString
        private static String TOOLTIPTEXT_SELECTED = new String("<html>Click to select the media server</html>");
        private ArrayList<MediaServer> m_SelectedMediaServers;
        private CellRendererServerSelected m_SelectedCellRenderer;
        private CellRendererConnectionStatus m_ConnectionStatusCellRenderer;
        private DefaultTableCellRenderer m_NameCellRenderer;
        private DefaultTableCellRenderer m_ServerNameCellRenderer;
        private DefaultTableCellRenderer m_ServerURLCellRenderer;
        private DefaultTableCellRenderer m_ServerPortCellRenderer;
        private DefaultCellEditor m_CellEditorMediaServer;
        private final Object m_SyncRows = new Object();
        private JTable m_JTable;
        private SelectionListener m_SelectionListener;
        private MediaServerSelectionTableModel s_SelReference;

        public MediaServerSelectionTableModel() {
            LiveLanguage.addLanguageListener((Object)this, null);
            this.initMembers();
        }

        private void initMembers() {
            this.s_SelReference = this;
            this.m_SelectedMediaServers = new ArrayList();
            this.m_SelectedCellRenderer = new CellRendererServerSelected();
            this.m_SelectedCellRenderer.setToolTipText(TOOLTIPTEXT_SELECTED);
            this.m_SelectedCellRenderer.setHorizontalAlignment(0);
            this.m_JTable = null;
            this.m_SelectionListener = null;
        }

        public void finishJTable(JTable p_JTable, SelectionListener p_SelectionListener) {
            TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            this.m_JTable = p_JTable;
            super.finishJTable(p_JTable);
            this.m_SelectionListener = p_SelectionListener;
            TableAndListModel.TableBehavior o_TableBehavior = new TableAndListModel.TableBehavior(p_JTable, this);
            TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
            TableColumn o_TableColumn = o_TableColumnModel.getColumn(7);
            if (o_TableColumn != null) {
                o_TableColumn.setMaxWidth(25);
                o_TableColumn.setMinWidth(25);
                o_TableColumn.setPreferredWidth(25);
                o_TableColumn.setResizable(false);
                TableAndListModel.TableCellEditorRenderer_CheckBox o_TableCellEditorRenderer_CheckBox = new TableAndListModel.TableCellEditorRenderer_CheckBox();
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_CheckBox);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_CheckBox);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(2)) != null) {
                o_TableColumn.setMaxWidth(25);
                o_TableColumn.setMinWidth(25);
                o_TableColumn.setPreferredWidth(25);
                o_TableColumn.setResizable(false);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(0)) != null) {
                o_TableCellEditorRenderer_String = (TableAndListModel.TableCellEditorRenderer_String)o_TableColumn.getCellRenderer();
                o_TableCellEditorRenderer_String.setToolTipText(null);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(2)) != null) {
                o_TableCellEditorRenderer_String = (TableAndListModel.TableCellEditorRenderer_String)o_TableColumn.getCellRenderer();
                o_TableCellEditorRenderer_String.setToolTipText(null);
            }
            o_TableBehavior.addMouseExcludedColumn(7, false);
            o_TableBehavior.addMouseExcludedColumn(0, false);
            o_TableBehavior.addMouseExcludedColumn(2, false);
            int intColumnRemovedCount = 0;
            o_TableColumn = o_TableColumnModel.getColumn(6);
            o_TableColumnModel.removeColumn(o_TableColumn);
            ++intColumnRemovedCount;
            o_TableColumn = o_TableColumnModel.getColumn(1);
            o_TableColumnModel.removeColumn(o_TableColumn);
            o_TableColumnModel.moveColumn(7 - ++intColumnRemovedCount, 0);
        }

        @Override
        public void excludedMouseEvent(MouseEvent p_MouseEvent, JTable p_JTable, int p_RowModel, int p_ColumnModel, Object p_Value) {
            if (p_MouseEvent.getID() == 502 && p_MouseEvent.getButton() == 1 && (p_ColumnModel == 7 || p_ColumnModel == 0 || p_ColumnModel == 2)) {
                MediaServer o_MediaServer = this.getMediaServer(p_RowModel);
                if (this.m_SelectedMediaServers.contains(o_MediaServer)) {
                    this.removeSelectedMediaServer(o_MediaServer);
                } else {
                    this.addSelectedMediaServer(o_MediaServer);
                }
                return;
            }
            super.excludedMouseEvent(p_MouseEvent, p_JTable, p_RowModel, p_ColumnModel, p_Value);
        }

        @Override
        public void removeMediaServer(MediaServer p_MediaServer) {
            if (p_MediaServer == null) {
                return;
            }
            this.removeSelectedMediaServer(p_MediaServer);
            super.remove(p_MediaServer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearSelectedMediaServers() {
            Object object = this.m_SyncRows;
            synchronized (object) {
                for (int intMediaServer = this.m_SelectedMediaServers.size() - 1; intMediaServer >= 0; --intMediaServer) {
                    MediaServer o_MediaServer = this.m_SelectedMediaServers.get(intMediaServer);
                    if (o_MediaServer == null) continue;
                    this.removeSelectedMediaServer(o_MediaServer);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectedMediaServer(MediaServer p_MediaServer) {
            if (p_MediaServer == null) {
                return;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                if (this.m_SelectedMediaServers.contains(p_MediaServer)) {
                    return;
                }
                int intRow = this.indexOf(p_MediaServer);
                if (intRow < 0) {
                    return;
                }
                this.m_SelectedMediaServers.add(p_MediaServer);
                this.setValue(p_MediaServer, (Object)true, 7);
            }
            if (this.m_SelectionListener != null) {
                this.m_SelectionListener.selectionMediaServer_Added(p_MediaServer);
            }
            if (this.m_JTable != null) {
                this.m_JTable.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectedMediaServer(MediaServer p_MediaServer) {
            if (p_MediaServer == null) {
                return;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                if (!this.m_SelectedMediaServers.contains(p_MediaServer)) {
                    return;
                }
                int intRow = this.indexOf(p_MediaServer);
                if (intRow < 0) {
                    return;
                }
                this.m_SelectedMediaServers.remove(p_MediaServer);
                this.setValue(p_MediaServer, (Object)false, 7);
            }
            if (this.m_SelectionListener != null) {
                this.m_SelectionListener.selectionMediaServer_Removed(p_MediaServer);
            }
            if (this.m_JTable != null) {
                this.m_JTable.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSelectedMediaServerCount() {
            Object object = this.m_SyncRows;
            synchronized (object) {
                return this.m_SelectedMediaServers.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MediaServer getSelectedMediaServer(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                if (p_Index >= this.m_SelectedMediaServers.size()) {
                    return null;
                }
                return this.m_SelectedMediaServers.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList<MediaServer> getMediaServers_Copy() {
            ArrayList<MediaServer> o_MediaServers;
            Object object = this.m_SyncRows;
            synchronized (object) {
                o_MediaServers = this.getElementArrayList_Safe();
            }
            return o_MediaServers;
        }

        @Override
        public int getColumnCount() {
            return s_ColumnCount;
        }

        @Override
        public String getColumnName(int p_Column) {
            switch (p_Column) {
                case 7: {
                    return s_ColumnSelected;
                }
            }
            return super.getColumnName(p_Column);
        }

        @Override
        public boolean isCellEditable(int p_Row, int p_Column) {
            switch (p_Column) {
                case 7: {
                    return false;
                }
                case 0: {
                    return false;
                }
            }
            return super.isCellEditable(p_Row, p_Column);
        }

        @Override
        public void setValue(MediaServer p_MediaServer, Object p_Value, int p_Column) {
            if (p_MediaServer == null) {
                return;
            }
            switch (p_Column) {
                case 7: {
                    break;
                }
                default: {
                    super.setValue(p_MediaServer, p_Value, p_Column);
                }
            }
        }

        @Override
        public Object getValue(MediaServer p_MediaServer, int p_Column) {
            if (p_MediaServer == null) {
                return null;
            }
            switch (p_Column) {
                case 7: {
                    return this.m_SelectedMediaServers.contains(p_MediaServer);
                }
            }
            return super.getValue(p_MediaServer, p_Column);
        }

        public static class CellRendererConnectionStatus
        extends JLabel
        implements TableCellRenderer {
            public static final Border UNSELECTED_BORDER = new BevelBorder(0);
            public static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2);

            public CellRendererConnectionStatus() {
                this.initComponentsFurther();
            }

            private void initComponentsFurther() {
                super.setOpaque(true);
                super.setBackground(Color.DARK_GRAY);
                super.setText("");
                this.setName("Table.cellRenderer");
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setForeground(table.getForeground());
                int intConnectionStatus = value != null ? (Integer)value : 6;
                switch (intConnectionStatus) {
                    case 2: {
                        super.setBackground(Color.GREEN);
                        break;
                    }
                    case 3: {
                        super.setBackground(Color.GREEN);
                        break;
                    }
                    case 6: {
                        super.setBackground(Color.RED);
                        break;
                    }
                    case 1: {
                        super.setBackground(Color.LIGHT_GRAY);
                        break;
                    }
                    case 9: {
                        super.setBackground(Color.LIGHT_GRAY);
                        break;
                    }
                    case 8: {
                        super.setBackground(Color.YELLOW);
                        break;
                    }
                    case 0: {
                        super.setBackground(Color.ORANGE);
                        break;
                    }
                    default: {
                        super.setBackground(table.getBackground());
                    }
                }
                if (isSelected) {
                    // empty if block
                }
                this.setFont(table.getFont());
                return this;
            }
        }

        public static class CellRendererServerSelected
        extends JCheckBox
        implements TableCellRenderer {
            public CellRendererServerSelected() {
                this.initComponentsFurther();
            }

            private void initComponentsFurther() {
                super.setOpaque(true);
                super.setBackground(Color.BLACK);
                super.setText("");
                super.setPreferredSize(new Dimension(16, 16));
                this.setName("Table.cellRenderer");
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Color o_Background = table.getBackground();
                Color o_Foreground = table.getForeground();
                if (isSelected) {
                    if (table.hasFocus()) {
                        o_Background = UIManager.getColor("Table.selectionBackground");
                        o_Foreground = UIManager.getColor("Table.selectionForeground");
                    } else {
                        o_Background = UIManager.getColor("Table.selectionInactiveBackground");
                        o_Foreground = UIManager.getColor("Table.selectionInactiveForeground");
                    }
                }
                this.setBackground(o_Background);
                this.setForeground(o_Foreground);
                boolean boolSelected = value != null ? (Boolean)value : false;
                super.setSelected(boolSelected);
                this.setFont(table.getFont());
                Object border = null;
                return this;
            }
        }

        public static interface SelectionListener {
            public void selectionMediaServer_Added(MediaServer var1);

            public void selectionMediaServer_Removed(MediaServer var1);
        }
    }

    public static class MediaServerTableModel
    extends TableAndListModel<MediaServer>
    implements ServerAutoDetect.ServerAutoDetect_Listener,
    TableAndListModel.TableBehaviorListener {
        public static int s_ColumnCount = 7;
        public static final int s_IndexName = 0;
        public static final int s_IndexServerDetected = 1;
        public static final int s_IndexServerConnection = 2;
        public static final int s_IndexServerName = 3;
        public static final int s_IndexServerURL = 4;
        public static final int s_IndexServerPort = 5;
        public static final int s_IndexServerSweep = 6;
        @LiveLanguageString
        private static String s_ColumnName = "Name";
        @LiveLanguageString
        private static String s_ColumnServerConnectionStatus = "Connect";
        @LiveLanguageString
        private static String s_ColumnServerDetected = "Detected";
        @LiveLanguageString
        private static String s_ColumnServerURL = "IP";
        @LiveLanguageString
        private static String s_ColumnServerPort = "Port";
        @LiveLanguageString
        private static String s_ColumnServerName = "Host Name";
        @LiveLanguageString
        private static String s_ColumnServerSweep = "Sweep";
        @LiveLanguageString
        private static String TOOLTIPTEXT_NAME = new String("<html>You can change the name of the media server</html>");
        @LiveLanguageString
        private static String TOOLTIPTEXT_CONNECT = new String("<html>Click to connect or disconnect MediaServer.</html>");
        @LiveLanguageString
        private static String TOOLTIPTEXT_SERVERDETECTED = new String("<html>The automatic found MediaServers.<br>Click to edit)</html>");
        @LiveLanguageString
        private static String TOOLTIPTEXT_SERVERURL = new String("<html>The IP/URL of the media server.<br>DoubleClick to edit)</html>");
        @LiveLanguageString
        private static String TOOLTIPTEXT_SERVERPORT = new String("<html>The port number of the media server.<br>DoubleClick to edit)</html>");
        @LiveLanguageString
        private static String TOOLTIPTEXT_SERVERNAME = new String("<html>Name of the Server.<br>Only avaliable when the server is connected.</html>");
        @LiveLanguageString
        private static String TOOLTIPTEXT_SERVERSWEEP = new String("<html>All media files on the media server which are not used yet,<br>will be deleted.</html>");
        private final Object m_SyncRows = new Object();
        private JTable m_JTable;
        private MediaServerTableModel s_SelReference;

        public MediaServerTableModel() {
            super(false);
            LiveLanguage.addLanguageListener((Object)this, null);
            this.initMembers();
        }

        private void initMembers() {
            this.s_SelReference = this;
            s_ServerAutoDetect_Client.addServerAutoDetectListener((ServerAutoDetect.ServerAutoDetect_Listener)this.s_SelReference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.m_SyncRows;
            synchronized (object) {
                int intRowCount = this.size();
                for (int intRow = intRowCount - 1; intRow >= 0; --intRow) {
                    MediaServer o_MediaServer = this.getMediaServer(intRow);
                    if (o_MediaServer == null) continue;
                    o_MediaServer.close();
                }
            }
        }

        public void finishJTable(JTable p_JTable) {
            TableAndListModel.TableCellHeaderRenderer o_TableCellHeaderRenderer;
            TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            this.m_JTable = p_JTable;
            TableRowSorter<MediaServerTableModel> o_TableRowSorter = new TableRowSorter<MediaServerTableModel>(this);
            o_TableRowSorter.setComparator(0, TableAndListModel.getStringComparator_Normal());
            o_TableRowSorter.setComparator(4, TableAndListModel.getStringComparator_Normal());
            o_TableRowSorter.setComparator(5, TableAndListModel.getStringComparator_Integer());
            o_TableRowSorter.setComparator(3, TableAndListModel.getStringComparator_Normal());
            super.finishJTable(p_JTable, o_TableRowSorter, null);
            TableAndListModel.TableBehavior o_TableBehavior = new TableAndListModel.TableBehavior(p_JTable, this);
            TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
            TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
            if (o_TableColumn != null) {
                o_TableColumn.setMinWidth(100);
                o_TableColumn.setPreferredWidth(150);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setToolTipText(TOOLTIPTEXT_NAME);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
                o_TableColumn.setMinWidth(100);
                o_TableColumn.setPreferredWidth(150);
                TableAndListModel.TableCellEditorRenderer_ComboBox o_TableCellEditorRenderer_ComboBox = new TableAndListModel.TableCellEditorRenderer_ComboBox();
                o_TableCellEditorRenderer_ComboBox.setComboBoxModel(new LiveDBListTools.ListModelWrapper(ServerAutoDetect_Client_ListModel.getDetectedServerListModel(s_ServerAutoDetect_Client)));
                o_TableCellEditorRenderer_ComboBox.setListCellRenderer(new ServerAutoDetect_Client_ListModel.DetectedServer_ListCellRenderer(false, false, true, true, true, false));
                o_TableCellEditorRenderer_ComboBox.setHorizontalAlignment(0);
                o_TableCellEditorRenderer_ComboBox.setToolTipText(TOOLTIPTEXT_SERVERDETECTED);
                o_TableCellEditorRenderer_ComboBox.setToolTipTextAt(true, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_ComboBox);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_ComboBox);
                o_TableCellHeaderRenderer = new TableAndListModel.TableCellHeaderRenderer();
                o_TableCellHeaderRenderer.setToolTipText(TOOLTIPTEXT_SERVERDETECTED);
                o_TableCellHeaderRenderer.setToolTipTextAt(true, true);
                o_TableColumn.setHeaderRenderer(o_TableCellHeaderRenderer);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(3)) != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setToolTipText(TOOLTIPTEXT_SERVERNAME);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(0);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(4)) != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setToolTipText(TOOLTIPTEXT_SERVERURL);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(0);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(5)) != null) {
                TableAndListModel.TableCellEditorRenderer_Integer o_TableCellEditorRenderer_Integer = new TableAndListModel.TableCellEditorRenderer_Integer();
                o_TableCellEditorRenderer_Integer.setToolTipText(TOOLTIPTEXT_SERVERPORT);
                o_TableCellEditorRenderer_Integer.setToolTipTextAt(false, true);
                o_TableCellEditorRenderer_Integer.setHorizontalAlignment(0);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_Integer);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_Integer);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(2)) != null) {
                o_TableColumn.setMinWidth(50);
                o_TableColumn.setMaxWidth(50);
                o_TableColumn.setPreferredWidth(50);
                o_TableColumn.setResizable(false);
                o_TableCellEditorRenderer_String = new CellRendererConnectionStatus();
                o_TableCellEditorRenderer_String.setToolTipText(TOOLTIPTEXT_CONNECT);
                o_TableCellEditorRenderer_String.setToolTipTextAt(true, true);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(0);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
                o_TableBehavior.addMouseExcludedColumn(2, false);
                o_TableCellHeaderRenderer = new TableAndListModel.TableCellHeaderRenderer();
                o_TableCellHeaderRenderer.setToolTipText(TOOLTIPTEXT_CONNECT);
                o_TableCellHeaderRenderer.setToolTipTextAt(true, true);
                o_TableColumn.setHeaderRenderer(o_TableCellHeaderRenderer);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(6)) != null) {
                o_TableColumn.setMinWidth(36);
                o_TableColumn.setMaxWidth(35);
                o_TableColumn.setPreferredWidth(36);
                o_TableColumn.setResizable(false);
                o_TableCellEditorRenderer_String = new CellRendererServerSweep();
                o_TableCellEditorRenderer_String.setToolTipText(TOOLTIPTEXT_SERVERSWEEP);
                o_TableCellEditorRenderer_String.setToolTipTextAt(true, true);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(0);
                o_TableCellEditorRenderer_String.setIcon(CellRendererServerSweep.s_Icon);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
                o_TableBehavior.addMouseExcludedColumn(6, false);
                o_TableCellHeaderRenderer = new TableAndListModel.TableCellHeaderRenderer();
                o_TableCellHeaderRenderer.setToolTipText(TOOLTIPTEXT_SERVERSWEEP);
                o_TableCellHeaderRenderer.setToolTipTextAt(true, true);
                o_TableColumn.setHeaderRenderer(o_TableCellHeaderRenderer);
            }
            p_JTable.getTableHeader().setComponentPopupMenu(PopUpToolTip.getSelfReference());
        }

        @Override
        public void excludedMouseEvent(MouseEvent p_MouseEvent, JTable p_JTable, int p_RowModel, int p_ColumnModel, Object p_Value) {
            if (p_MouseEvent.getID() == 502 && p_MouseEvent.getButton() == 1) {
                if (p_ColumnModel == 2) {
                    MediaServer o_MediaServer = this.getMediaServer(p_RowModel);
                    if (o_MediaServer == null) {
                        return;
                    }
                    if (!o_MediaServer.isConnected()) {
                        o_MediaServer.connectToServer();
                    } else {
                        o_MediaServer.disconnectServer();
                    }
                    return;
                }
                if (p_ColumnModel == 6) {
                    MediaServer o_MediaServer = this.getMediaServer(p_RowModel);
                    if (o_MediaServer == null) {
                        return;
                    }
                    if (!o_MediaServer.isConnected()) {
                        return;
                    }
                    o_MediaServer.sendMessage_Sweep();
                    return;
                }
            }
        }

        public void eventDetectedServer_Added(ServerAutoDetect.DetectedServer p_DetectedServer) {
            for (int intIndex = 0; intIndex < this.size(); ++intIndex) {
                MediaServer o_MediaServer = (MediaServer)this.get(intIndex);
                if (o_MediaServer == null) continue;
                this.changedElement(o_MediaServer);
            }
        }

        public void eventDetectedServer_Changed(ServerAutoDetect.DetectedServer p_DetectedServer) {
            for (int intIndex = 0; intIndex < this.size(); ++intIndex) {
                MediaServer o_MediaServer = (MediaServer)this.get(intIndex);
                if (o_MediaServer == null) continue;
                this.changedElement(o_MediaServer);
            }
        }

        public void eventDetectedServer_Removed(ServerAutoDetect.DetectedServer p_DetectedServer) {
            for (int intIndex = 0; intIndex < this.size(); ++intIndex) {
                MediaServer o_MediaServer = (MediaServer)this.get(intIndex);
                if (o_MediaServer == null) continue;
                this.changedElement(o_MediaServer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<MediaServer> getMediaServers_Copy() {
            ArrayList<MediaServer> o_MediaServers;
            Object object = this.m_SyncRows;
            synchronized (object) {
                o_MediaServers = this.getElementArrayList_Safe();
            }
            return o_MediaServers;
        }

        @Override
        public int getColumnCount() {
            return s_ColumnCount;
        }

        @Override
        public String getColumnName(int p_Column) {
            switch (p_Column) {
                case 0: {
                    return s_ColumnName;
                }
                case 2: {
                    return s_ColumnServerConnectionStatus;
                }
                case 1: {
                    return s_ColumnServerDetected;
                }
                case 4: {
                    return s_ColumnServerURL;
                }
                case 5: {
                    return s_ColumnServerPort;
                }
                case 3: {
                    return s_ColumnServerName;
                }
                case 6: {
                    return s_ColumnServerSweep;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMediaServer(MediaServer p_MediaServer) {
            if (p_MediaServer == null) {
                return;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                if (!this.add(p_MediaServer)) {
                    return;
                }
            }
            s_MediaServerSelectionTableModel.add(p_MediaServer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeMediaServer(MediaServer p_MediaServer) {
            if (p_MediaServer == null) {
                return;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                if (!this.remove(p_MediaServer)) {
                    return;
                }
            }
            s_MediaServerSelectionTableModel.removeMediaServer(p_MediaServer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MediaServer getMediaServer(int p_Row) {
            if (p_Row < 0) {
                return null;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                if (p_Row >= this.size()) {
                    return null;
                }
                return (MediaServer)this.get(p_Row);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MediaServer getMediaServer(LiveDBClient p_LiveDBClient) {
            if (p_LiveDBClient == null) {
                return null;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                for (int intRow = 0; intRow < this.size(); ++intRow) {
                    MediaServer o_MediaServer = (MediaServer)this.get(intRow);
                    if (o_MediaServer == null || o_MediaServer.getLiveDBClient() != p_LiveDBClient) continue;
                    return o_MediaServer;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MediaServer getMediaServer(String p_MediaServerID) {
            if (p_MediaServerID == null) {
                return null;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                for (int intRow = 0; intRow < this.size(); ++intRow) {
                    MediaServer o_MediaServer = (MediaServer)this.get(intRow);
                    if (o_MediaServer == null || !p_MediaServerID.equals(o_MediaServer.getID())) continue;
                    return o_MediaServer;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MediaServer getMediaServer(String p_MediaServerURL, String p_MediaServerPort) {
            if (p_MediaServerURL == null) {
                return null;
            }
            if (p_MediaServerPort == null) {
                return null;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                for (int intRow = 0; intRow < this.size(); ++intRow) {
                    LiveDBConnectionDescription o_LiveDBConnectionDescription;
                    MediaServer o_MediaServer = (MediaServer)this.get(intRow);
                    if (o_MediaServer == null || (o_LiveDBConnectionDescription = o_MediaServer.getLiveDBConnectionDescription()) == null || !o_LiveDBConnectionDescription.getServerRemoteURL().equals(p_MediaServerURL) || !String.valueOf(o_LiveDBConnectionDescription.getServerPort()).equals(p_MediaServerPort)) continue;
                    return o_MediaServer;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshMediaServer(MediaServer p_MediaServer) {
            if (p_MediaServer == null) {
                return;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                this.changedElement(p_MediaServer);
            }
        }

        @Override
        public boolean isCellEditable(int p_RowModel, int p_ColumnModel) {
            LiveDBClient o_LiveDBClient = null;
            boolean boolEditable = true;
            MediaServer o_MediaServer = this.getMediaServer(p_RowModel);
            if (o_MediaServer != null) {
                o_LiveDBClient = o_MediaServer.getLiveDBClient();
            }
            if (o_LiveDBClient != null && (o_LiveDBClient.getConnectionStatus() == 9 || o_LiveDBClient.getConnectionStatus() == 1 || o_LiveDBClient.getConnectionStatus() == 2 || o_LiveDBClient.getConnectionStatus() == 3)) {
                boolEditable = false;
            }
            switch (p_ColumnModel) {
                case 0: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case 1: {
                    return boolEditable;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 6: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public void setValue(MediaServer p_MediaServer, Object p_Value, int p_Column) {
            if (p_MediaServer == null) {
                return;
            }
            switch (p_Column) {
                case 0: {
                    p_MediaServer.setName((String)p_Value);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    ServerAutoDetect.DetectedServer o_DetectedServer = (ServerAutoDetect.DetectedServer)p_Value;
                    p_MediaServer.setDetectedServer(o_DetectedServer);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
        }

        @Override
        public Object getValue(MediaServer p_MediaServer, int p_Column) {
            if (p_MediaServer == null) {
                return null;
            }
            if (p_Column < 0) {
                return null;
            }
            switch (p_Column) {
                case 0: {
                    return p_MediaServer.getName();
                }
                case 2: {
                    return p_MediaServer.getConnectionStatus();
                }
                case 1: {
                    return p_MediaServer.getDetectedServer();
                }
                case 3: {
                    return p_MediaServer.getServerName();
                }
                case 5: {
                    return p_MediaServer.getServerPort();
                }
                case 4: {
                    return p_MediaServer.getServerURL();
                }
                case 6: {
                    return p_MediaServer.getConnectionStatus();
                }
            }
            return null;
        }

        public static class CellRendererServerSweep
        extends TableAndListModel.TableCellEditorRenderer_String {
            public static final Border UNSELECTED_BORDER = new BevelBorder(0);
            public static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2);
            public static ImageIcon s_Icon = new ImageIcon(CellRendererServerSweep.class.getResource("/IconsPackage/Edit_Sweep.png"));

            public CellRendererServerSweep() {
                this.initComponentsFurther();
            }

            private void initComponentsFurther() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent o_JComponent = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (o_JComponent instanceof JLabel) {
                    ((JLabel)o_JComponent).setText("");
                }
                int intConnectionStatus = value != null ? (Integer)value : 6;
                switch (intConnectionStatus) {
                    case 2: 
                    case 3: {
                        o_JComponent.setEnabled(true);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 6: 
                    case 8: 
                    case 9: {
                        o_JComponent.setEnabled(false);
                        break;
                    }
                    default: {
                        o_JComponent.setEnabled(false);
                    }
                }
                return o_JComponent;
            }
        }

        public static class CellRendererConnectionStatus
        extends TableAndListModel.TableCellEditorRenderer_String {
            public static final Border UNSELECTED_BORDER = new BevelBorder(0);
            public static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 1);

            public CellRendererConnectionStatus() {
                this.initComponentsFurther();
            }

            private void initComponentsFurther() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent o_JComponent = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (o_JComponent instanceof JLabel) {
                    ((JLabel)o_JComponent).setText("");
                }
                int intConnectionStatus = value != null ? (Integer)value : 6;
                switch (intConnectionStatus) {
                    case 2: {
                        o_JComponent.setBackground(Color.GREEN);
                        break;
                    }
                    case 3: {
                        o_JComponent.setBackground(Color.GREEN);
                        break;
                    }
                    case 6: {
                        o_JComponent.setBackground(Color.RED);
                        break;
                    }
                    case 1: {
                        o_JComponent.setBackground(Color.LIGHT_GRAY);
                        break;
                    }
                    case 9: {
                        o_JComponent.setBackground(Color.LIGHT_GRAY);
                        break;
                    }
                    case 8: {
                        o_JComponent.setBackground(Color.YELLOW);
                        break;
                    }
                    case 0: {
                        o_JComponent.setBackground(Color.ORANGE);
                        break;
                    }
                    default: {
                        o_JComponent.setBackground(Color.WHITE);
                    }
                }
                Border border = null;
                border = isSelected ? SELECTED_BORDER : UNSELECTED_BORDER;
                o_JComponent.setBorder(border);
                return o_JComponent;
            }
        }
    }
}

