/*
 * Decompiled with CFR 0.152.
 */
package SPITToolsPackage;

import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_ObjectDescription;
import SPITLibraryPackage.SPIT_TypeDescription;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITServerPackage.LiveShowSPITObject;
import SPITServerPackage.LiveShowSPITObjectDescription;
import SPITServerPackage.SPITServer_Client;
import SPITServerPackage.SPIT_Type;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.JLabel_RightClickToolTip;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class SPITObjectConflictModel
extends TableAndListModel<Conflict> {
    public static final int COLUMNCOUNT = 2;
    public static final int COLUMNINDEX_SERVER = 0;
    public static final int COLUMNINDEX_CLIENT = 1;
    public static String COLUMN_SERVERNAME = "LiveShow";
    public static String COLUMN_CLIENTNAME = "Client";
    private TableRowSorter m_TableRowSorter;
    private SPITRowFilter m_SPITRowFilter;
    private final Object m_SyncObject = new Object();

    public SPITObjectConflictModel() {
        super(false);
        this.initMembers();
    }

    private void initMembers() {
        this.m_TableRowSorter = new TableRowSorter<SPITObjectConflictModel>(this);
    }

    public void finishJTable(JTable p_JTable) {
        SPITObjectConflictRenderer o_TableCellEditorRenderer_String;
        if (p_JTable == null) {
            return;
        }
        this.m_TableRowSorter.setComparator(0, TableAndListModel.getStringComparator_Normal());
        this.m_TableRowSorter.setComparator(1, TableAndListModel.getStringComparator_Normal());
        this.m_SPITRowFilter = new SPITRowFilter(this);
        super.finishJTable(p_JTable, this.m_TableRowSorter, this.m_SPITRowFilter);
        TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
        TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
        if (o_TableColumn != null) {
            o_TableCellEditorRenderer_String = new SPITObjectConflictRenderer();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
            o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
            o_TableCellEditorRenderer_String = new SPITObjectConflictRenderer();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
            o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
        }
        p_JTable.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            super.clear();
        }
    }

    public static String getObjectName(Object p_Object) {
        String stringName;
        if (p_Object == null) {
            return null;
        }
        try {
            Method o_Method = p_Object.getClass().getMethod("getName", new Class[0]);
            if (o_Method == null) {
                return null;
            }
            stringName = (String)o_Method.invoke(p_Object, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
        return stringName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConflict(String p_ClientID, LiveShowSPITObjectDescription p_Description_Server, LiveShowSPITObjectDescription p_Description_Client) {
        if (p_ClientID == null) {
            return false;
        }
        if (p_Description_Server == null && p_Description_Client == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            int intFoundIndex = this.findConflictIndex(p_ClientID, p_Description_Server, p_Description_Client);
            if (intFoundIndex >= 0) {
                Conflict o_Conflict = (Conflict)this.get(intFoundIndex);
                o_Conflict.setServerObjectDescription(p_Description_Server);
                o_Conflict.setClientObjectDescription(p_Description_Client);
                o_Conflict.setClientID(p_ClientID);
                return false;
            }
        }
        object = this.m_SyncObject;
        synchronized (object) {
            Conflict o_Conflict = new Conflict(p_Description_Server, p_Description_Client, p_ClientID);
            this.add(o_Conflict);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConflict(String p_ClientID, String p_SPIT_ObjectID, boolean p_ClientSide) {
        if (p_SPIT_ObjectID == null) {
            return false;
        }
        boolean boolFound = false;
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_ClientSide) {
                for (int intIndex = this.size() - 1; intIndex >= 0; --intIndex) {
                    LiveShowSPITObjectDescription o_ObjectDescription;
                    Conflict o_Conflict = (Conflict)this.get(intIndex);
                    if (o_Conflict == null || (o_ObjectDescription = o_Conflict.getClientObjectDescription()) == null || !o_ObjectDescription.getID().equals(p_SPIT_ObjectID) || p_ClientID != null && !p_ClientID.equals(o_Conflict.getClientID())) continue;
                    this.remove(o_Conflict);
                    boolFound = true;
                }
            } else {
                for (int intIndex = this.size() - 1; intIndex >= 0; --intIndex) {
                    LiveShowSPITObjectDescription o_ObjectDescription;
                    Conflict o_Conflict = (Conflict)this.get(intIndex);
                    if (o_Conflict == null || (o_ObjectDescription = o_Conflict.getServerObjectDescription()) == null || !o_ObjectDescription.getID().equals(p_SPIT_ObjectID)) continue;
                    this.remove(o_Conflict);
                    boolFound = true;
                }
            }
        }
        if (boolFound) {
            // empty if block
        }
        return boolFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConflict(String p_ClientID) {
        if (p_ClientID == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intIndex = this.size() - 1; intIndex >= 0; --intIndex) {
                Conflict o_Conflict = (Conflict)this.get(intIndex);
                if (o_Conflict == null || !p_ClientID.equals(o_Conflict.getClientID())) continue;
                this.remove(o_Conflict);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findConflictIndex(String p_ClientID, LiveShowSPITObjectDescription p_Description_Server, LiveShowSPITObjectDescription p_Description_Client) {
        if (p_ClientID == null) {
            return -1;
        }
        if (p_Description_Server == null && p_Description_Client == null) {
            return -1;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intIndex = 0; intIndex < this.size(); ++intIndex) {
                LiveShowSPITObjectDescription o_TypeDescription;
                Conflict o_Conflict = (Conflict)this.get(intIndex);
                String stringClientID = o_Conflict.getClientID();
                if (!p_ClientID.equals(stringClientID)) continue;
                if (p_Description_Server != null && (o_TypeDescription = o_Conflict.getServerObjectDescription()) != null && p_Description_Server.getID().equals(o_TypeDescription.getID())) {
                    return intIndex;
                }
                if (p_Description_Client == null || (o_TypeDescription = o_Conflict.getClientObjectDescription()) == null || !p_Description_Client.getID().equals(o_TypeDescription.getID())) continue;
                return intIndex;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowSPITObjectDescription getObjectDescription_Server(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.size()) {
                return null;
            }
            Conflict o_Conflict = (Conflict)this.get(p_Index);
            if (o_Conflict == null) {
                return null;
            }
            return o_Conflict.getServerObjectDescription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowSPITObjectDescription getObjectDescription_Client(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.size()) {
                return null;
            }
            Conflict o_Conflict = (Conflict)this.get(p_Index);
            if (o_Conflict == null) {
                return null;
            }
            return o_Conflict.getClientObjectDescription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LiveShowSPITObjectDescription> getObjectDescriptions_Client(String p_ClientID, String p_SPIT_TypeID) {
        ArrayList<LiveShowSPITObjectDescription> o_LiveShowObjectDescriptions = new ArrayList<LiveShowSPITObjectDescription>();
        if (p_SPIT_TypeID == null) {
            return o_LiveShowObjectDescriptions;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intIndex = 0; intIndex < this.size(); ++intIndex) {
                Conflict o_Conflict = (Conflict)this.get(intIndex);
                if (o_Conflict == null) continue;
                LiveShowSPITObjectDescription o_LiveShowObjectDescription = o_Conflict.getClientObjectDescription();
                String stringClientID = o_Conflict.getClientID();
                if (o_LiveShowObjectDescription == null || !p_SPIT_TypeID.equals(o_LiveShowObjectDescription.getSourceString())) continue;
                if (p_ClientID == null) {
                    o_LiveShowObjectDescriptions.add(o_LiveShowObjectDescription);
                    continue;
                }
                if (!p_ClientID.equals(stringClientID)) continue;
                o_LiveShowObjectDescriptions.add(o_LiveShowObjectDescription);
            }
            return o_LiveShowObjectDescriptions;
        }
    }

    @Override
    public int getRowOf(LiveShowSPITObjectDescription p_LiveShowSPITObjectDescription) {
        for (int intIndex = 0; intIndex < this.size(); ++intIndex) {
            Conflict o_Conflict = (Conflict)this.get(intIndex);
            if (o_Conflict.getClientObjectDescription() == p_LiveShowSPITObjectDescription) {
                return intIndex;
            }
            if (o_Conflict.getServerObjectDescription() != p_LiveShowSPITObjectDescription) continue;
            return intIndex;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientID(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.size()) {
                return null;
            }
            Conflict o_Conflict = (Conflict)this.get(p_Index);
            if (o_Conflict == null) {
                return null;
            }
            return o_Conflict.getClientID();
        }
    }

    public String getClientID(LiveShowSPITObjectDescription p_LiveShowSPITObjectDescription) {
        if (p_LiveShowSPITObjectDescription == null) {
            return null;
        }
        int intRow = this.getRowOf(p_LiveShowSPITObjectDescription);
        if (intRow < 0) {
            return null;
        }
        return this.getClientID(intRow);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int col) {
        SPITServer_Client o_SPIT_Client = null;
        switch (col) {
            case 0: {
                if (o_SPIT_Client == null) {
                    return COLUMN_SERVERNAME;
                }
                return o_SPIT_Client.getServerName();
            }
            case 1: {
                if (o_SPIT_Client == null) {
                    return COLUMN_CLIENTNAME;
                }
                return o_SPIT_Client.getName();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Conflict p_Conflict, int columnIndex) {
        if (p_Conflict == null) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            switch (columnIndex) {
                case 0: {
                    return p_Conflict.getServerObjectDescription();
                }
                case 1: {
                    return p_Conflict.getClientObjectDescription();
                }
            }
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValue(Conflict p_Conflict, Object p_Value, int p_Column) {
    }

    public void filter(String p_FilterString) {
        if (this.m_SPITRowFilter == null) {
            return;
        }
        this.m_SPITRowFilter.setFilterString(p_FilterString);
    }

    public static class SPITObjectConflictRenderer
    extends TableAndListModel.TableCellEditorRenderer_String {
        public static Color s_ColorWarning = new Color(255, 200, 200);
        public static Color s_ColorDisabled = new Color(100, 100, 100);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SPIT_ClientInterface o_SPITServer_Client;
            SPIT_Type_Interface o_SPIT_Type_Interface = null;
            String stringTypeName = null;
            JLabel_RightClickToolTip o_JLabel = (JLabel_RightClickToolTip)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            o_JLabel.setForeground(s_ColorWarning);
            LiveShowSPITObjectDescription o_ObjectDescription = (LiveShowSPITObjectDescription)value;
            try {
                int intRowModel = table.convertRowIndexToModel(row);
                o_SPITServer_Client = SPITServer_Client.getSPIT_ClientInterface(LiveShowSPITObject.s_SPITObjectConflictModel.getClientID(intRowModel));
                if (o_ObjectDescription != null) {
                    o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(o_ObjectDescription.getSourceString());
                    if (o_SPIT_Type_Interface == null) {
                        SPIT_TypeDescription o_SPIT_TypeDescription = SPIT_Type.s_SPITTypeConflictModel.getTypeDescription_Client(o_ObjectDescription.getSourceString(), SPIT_Type.s_SPITTypeConflictModel.getClientID(intRowModel));
                        if (o_SPIT_TypeDescription != null) {
                            stringTypeName = o_SPIT_TypeDescription.getName();
                        }
                    } else {
                        stringTypeName = o_SPIT_Type_Interface.getName();
                    }
                }
            }
            catch (Exception e) {
                o_SPITServer_Client = null;
                o_ObjectDescription = null;
            }
            try {
                if (table.convertColumnIndexToModel(column) == 0) {
                    this.setIcon(null);
                } else {
                    this.setIcon(null);
                }
            }
            catch (Exception e) {
                this.setIcon(null);
            }
            if (o_ObjectDescription == null) {
                o_JLabel.setText("");
                o_JLabel.setToolTipText(null);
            } else {
                StringBuilder o_StringBuilder = new StringBuilder();
                o_StringBuilder.append(o_ObjectDescription.getName());
                if (stringTypeName != null) {
                    o_StringBuilder.append(" - ");
                    o_StringBuilder.append(stringTypeName);
                }
                try {
                    if (table.convertColumnIndexToModel(column) == 1 && o_SPITServer_Client != null) {
                        o_StringBuilder.append(" (");
                        o_StringBuilder.append(o_SPITServer_Client.getClientComputerName());
                        o_StringBuilder.append(" ");
                        o_StringBuilder.append(o_SPITServer_Client.getClientProjectName());
                        o_StringBuilder.append(")");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                o_JLabel.setText(o_StringBuilder.toString());
                if (o_SPITServer_Client != null) {
                    o_StringBuilder.delete(0, o_StringBuilder.length());
                    o_StringBuilder.append(o_SPITServer_Client.getClientComputerName());
                    o_StringBuilder.append(" ");
                    o_StringBuilder.append(o_SPITServer_Client.getName());
                    o_StringBuilder.append(" (");
                    o_StringBuilder.append(o_SPITServer_Client.getIPAddress());
                    o_StringBuilder.append(" ");
                    o_StringBuilder.append(String.valueOf(o_SPITServer_Client.getPort()));
                    o_StringBuilder.append(" )");
                    o_JLabel.setToolTipText(o_StringBuilder.toString());
                    o_JLabel.setToolTipText_RightClick(o_StringBuilder.toString());
                } else {
                    o_JLabel.setToolTipText(null);
                    o_JLabel.setToolTipText_RightClick(null);
                }
            }
            return o_JLabel;
        }
    }

    public static class SPITRowFilter
    extends RowFilter<LiveShowSPITObjectDescription, Integer> {
        private SPITObjectConflictModel m_SPITObjectConflictModel;
        private String m_FilterString;

        public SPITRowFilter(SPITObjectConflictModel p_SPITObjectConflictModel) {
            this.initMembers();
            this.m_SPITObjectConflictModel = p_SPITObjectConflictModel;
        }

        private void initMembers() {
            this.m_FilterString = null;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
            if (this.m_SPITObjectConflictModel != null) {
                this.m_SPITObjectConflictModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            SPIT_ClientInterface o_SPIT_ClientInterface;
            SPIT_Type_Interface o_SPIT_Type_Interface;
            SPIT_TypeDescription o_SPIT_TypeDescription;
            SPIT_ObjectDescription o_SPIT_ObjectDescription;
            if (this.m_SPITObjectConflictModel == null) {
                return false;
            }
            if (this.m_FilterString == null) {
                return true;
            }
            if (this.m_FilterString.length() <= 0) {
                return true;
            }
            int intRow = (Integer)entry.getIdentifier();
            LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = this.m_SPITObjectConflictModel.getObjectDescription_Client(intRow);
            if (o_LiveShowSPITObjectDescription != null) {
                o_SPIT_ObjectDescription = o_LiveShowSPITObjectDescription.getSPIT_ObjectDescription();
                if (o_SPIT_ObjectDescription != null) {
                    if (o_SPIT_ObjectDescription.getName().toLowerCase().contains(this.m_FilterString)) {
                        return true;
                    }
                    if (o_SPIT_ObjectDescription.getRemark().toLowerCase().contains(this.m_FilterString)) {
                        return true;
                    }
                }
                if ((o_SPIT_TypeDescription = (o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(o_LiveShowSPITObjectDescription.getSourceString())) == null ? SPIT_Type.s_SPITTypeConflictModel.getTypeDescription_Client(o_LiveShowSPITObjectDescription.getSourceString(), this.m_SPITObjectConflictModel.getClientID(intRow)) : o_SPIT_Type_Interface.getSPIT_TypeDescription()) != null) {
                    if (o_SPIT_TypeDescription.getName().toLowerCase().contains(this.m_FilterString)) {
                        return true;
                    }
                    if (o_SPIT_TypeDescription.getGroupName().toLowerCase().contains(this.m_FilterString)) {
                        return true;
                    }
                }
            }
            if ((o_LiveShowSPITObjectDescription = this.m_SPITObjectConflictModel.getObjectDescription_Server(intRow)) != null) {
                o_SPIT_ObjectDescription = o_LiveShowSPITObjectDescription.getSPIT_ObjectDescription();
                if (o_SPIT_ObjectDescription != null) {
                    if (o_SPIT_ObjectDescription.getName().toLowerCase().contains(this.m_FilterString)) {
                        return true;
                    }
                    if (o_SPIT_ObjectDescription.getRemark().toLowerCase().contains(this.m_FilterString)) {
                        return true;
                    }
                }
                if ((o_SPIT_TypeDescription = (o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(o_LiveShowSPITObjectDescription.getSourceString())) == null ? SPIT_Type.s_SPITTypeConflictModel.getTypeDescription_Client(o_LiveShowSPITObjectDescription.getSourceString(), this.m_SPITObjectConflictModel.getClientID(intRow)) : o_SPIT_Type_Interface.getSPIT_TypeDescription()) != null) {
                    if (o_SPIT_TypeDescription.getName().toLowerCase().contains(this.m_FilterString)) {
                        return true;
                    }
                    if (o_SPIT_TypeDescription.getGroupName().toLowerCase().contains(this.m_FilterString)) {
                        return true;
                    }
                }
            }
            if ((o_SPIT_ClientInterface = SPITServer_Client.getSPIT_ClientInterface(this.m_SPITObjectConflictModel.getClientID(intRow))) != null) {
                if (o_SPIT_ClientInterface.getClientProjectName().toLowerCase().contains(this.m_FilterString)) {
                    return true;
                }
                if (o_SPIT_ClientInterface.getClientComputerName().toLowerCase().contains(this.m_FilterString)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Conflict {
        private LiveShowSPITObjectDescription m_ClientObjectDescription;
        private LiveShowSPITObjectDescription m_ServerObjectDescription;
        private String m_ClientID;

        public Conflict(LiveShowSPITObjectDescription p_ServerObjectDescription, LiveShowSPITObjectDescription p_ClientObjectDescription, String p_ClientID) {
            this.m_ServerObjectDescription = p_ServerObjectDescription;
            this.m_ClientObjectDescription = p_ClientObjectDescription;
            this.m_ClientID = p_ClientID;
        }

        public void setServerObjectDescription(LiveShowSPITObjectDescription p_ServerObjectDescription) {
            this.m_ServerObjectDescription = p_ServerObjectDescription;
        }

        public LiveShowSPITObjectDescription getServerObjectDescription() {
            return this.m_ServerObjectDescription;
        }

        public void setClientObjectDescription(LiveShowSPITObjectDescription p_ClientObjectDescription) {
            this.m_ClientObjectDescription = p_ClientObjectDescription;
        }

        public LiveShowSPITObjectDescription getClientObjectDescription() {
            return this.m_ClientObjectDescription;
        }

        public void setClientID(String p_ClientID) {
            this.m_ClientID = p_ClientID;
        }

        public String getClientID() {
            return this.m_ClientID;
        }
    }
}

