/*
 * Decompiled with CFR 0.152.
 */
package SPITServerPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Message;
import SPITLibraryPackage.SPIT_TypeDescription;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITModelPackage.SPIT_TypeModel;
import SPITRemotePackage.SPITRemote;
import SPITServerPackage.LiveShowSPITObject;
import SPITServerPackage.LiveShowSPITObjectDescription;
import SPITServerPackage.SPITServer;
import SPITServerPackage.SPITServer_Client;
import SPITToolsPackage.SPITTypeConflictModel;
import SPITToolsPackage.SinglePropertyChangeSupport;
import SwingModelPackage.TableAndListModel;
import Text.NameExtension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class SPIT_Type
implements SPIT_Type_Interface,
Externalizable,
PropertyChangeListener {
    public static ImageIcon s_Icon = new ImageIcon(SPIT_Type.class.getResource("/IconsPackage/Trigger.png"));
    public static SPIT_TypeModel s_SPITTypeTableModel = new SPIT_TypeModel();
    public static TableAndListModel.ListModel<SPIT_Type_Interface> s_SPITTypeListModel = s_SPITTypeTableModel.getListModel();
    public static SPIT_TypeModel.SPIT_TypeLListRenderer s_SPITTypeListRenderer = s_SPITTypeTableModel.getSPIT_TypeLListRenderer();
    public static SPITTypeConflictModel s_SPITTypeConflictModel = new SPITTypeConflictModel();
    public static final String PROP_CONFLICTS = "conflicts";
    public static final String PROP_PARAMCHANGED = "paramchanged";
    public static final String PROP_CONFIRMED = "confirmed";
    public static final String PROP_CLOSED = "closed";
    @LiveLanguageString
    public static String SPITTYPEMODEL_COLUMN_GROUPNAME = "Group";
    @LiveLanguageString
    public static String SPITTYPEMODEL_COLUMN_TYPENAME = "Name";
    @LiveLanguageString
    public static String SPITTYPEMODEL_COLUMN_DELAYNAME = "Delay";
    @LiveLanguageString
    public static String SPITTYPEMODEL_COLUMN_DURATIONNAME = "Duration";
    private SPIT_TypeDescription m_Description;
    private boolean m_Confirmed;
    private boolean m_JustLoadProject;
    private ArrayList<String> m_SPITServer_ClientIDs;
    private final Object m_SyncObject;
    private SinglePropertyChangeSupport m_SinglePropertyChangeSupport;
    public static final int SOFTWAREVERSION = 1;

    public static boolean addSPIT_Type(SPIT_Type_Interface p_SPIT_Type_Interface, SPIT_ClientInterface p_SPITServer_Client) {
        if (p_SPIT_Type_Interface == null) {
            return false;
        }
        boolean boolConflictsFound = false;
        if (p_SPIT_Type_Interface.getServerRemote()) {
            if (SPITRemote.addRemoteSPIT_Type((SPIT_Type_Interface)p_SPIT_Type_Interface)) {
                if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
                    SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)p_SPIT_Type_Interface);
                    SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
                }
                return true;
            }
            return false;
        }
        boolean boolAdded = s_SPITTypeTableModel.addSPIT_Type(p_SPIT_Type_Interface);
        if (!boolAdded && (p_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(p_SPIT_Type_Interface.getID())) == null) {
            return false;
        }
        SPIT_Type o_SPIT_Type = (SPIT_Type)p_SPIT_Type_Interface;
        if (p_SPITServer_Client != null && p_SPIT_Type_Interface.getFixed()) {
            o_SPIT_Type.addOwnerSPITServer_ClientID(p_SPITServer_Client.getClientID());
        }
        p_SPIT_Type_Interface.setConfirmed(true);
        if (!o_SPIT_Type.getJustLoadProject()) {
            if (s_SPITTypeConflictModel.removeConflict(null, p_SPIT_Type_Interface.getID(), true)) {
                boolConflictsFound = true;
            }
            if (s_SPITTypeConflictModel.removeConflict(null, p_SPIT_Type_Interface.getID(), false)) {
                boolConflictsFound = true;
            }
            if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
                SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)p_SPIT_Type_Interface);
                SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
            }
        }
        o_SPIT_Type.setJustLoadProject(false);
        if (boolConflictsFound) {
            SPIT_Type.notifyConflictsChanged();
        }
        return boolAdded;
    }

    public static boolean removeSPIT_Type_ByServer(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return false;
        }
        boolean boolRemoved = false;
        if (p_SPIT_Type_Interface.getServerRemote()) {
            return SPITRemote.removeRemoteSPIT_Type((SPIT_Type_Interface)p_SPIT_Type_Interface);
        }
        SPIT_Type o_SPIT_Type = (SPIT_Type)p_SPIT_Type_Interface;
        boolean boolFoundConflict = false;
        if (s_SPITTypeConflictModel.removeConflict(null, p_SPIT_Type_Interface.getID(), false)) {
            boolFoundConflict = true;
        }
        if (boolFoundConflict) {
            SPIT_Type.notifyConflictsChanged();
            return true;
        }
        boolRemoved = s_SPITTypeTableModel.removeSPIT_Type(p_SPIT_Type_Interface);
        if (boolRemoved) {
            String stringID = p_SPIT_Type_Interface.getID();
            p_SPIT_Type_Interface.close();
            if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
                SPIT_Message o_SPIT_Message = SPIT_Message.createRemoveSPITType((String)stringID);
                SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
            }
        }
        return boolRemoved;
    }

    public static boolean removeSPIT_Type_ByClient(SPIT_Type_Interface p_SPIT_Type_Interface, SPITServer_Client p_SPITServer_Client) {
        if (p_SPIT_Type_Interface == null) {
            return false;
        }
        boolean boolAllowRemove = true;
        boolean boolRemoved = false;
        if (p_SPIT_Type_Interface.getServerRemote()) {
            return false;
        }
        SPIT_Type o_SPIT_Type = (SPIT_Type)p_SPIT_Type_Interface;
        int intOwnerCount = o_SPIT_Type.getOwnerSpitServer_ClientCount();
        if (p_SPIT_Type_Interface.getFixed()) {
            for (int intSPIT_Client = 0; intSPIT_Client < intOwnerCount; ++intSPIT_Client) {
                SPIT_ClientInterface o_SPITServer_ClientOwner = SPITServer_Client.getSPIT_ClientInterface(o_SPIT_Type.getSPITServer_ClientID(intSPIT_Client));
                if (p_SPITServer_Client == o_SPITServer_ClientOwner) continue;
                boolAllowRemove = false;
                break;
            }
        }
        if (p_SPITServer_Client != null && LiveShowSPITObject.checkActionAssignedForeign(p_SPIT_Type_Interface, p_SPITServer_Client)) {
            boolAllowRemove = false;
        }
        if (!boolAllowRemove) {
            if (p_SPITServer_Client != null) {
                p_SPIT_Type_Interface.setConfirmed(true);
                SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)p_SPIT_Type_Interface);
                p_SPITServer_Client.sendSPIT_Message(o_SPIT_Message);
            }
            return false;
        }
        boolean boolFoundConflict = false;
        if (s_SPITTypeConflictModel.removeConflict(p_SPITServer_Client.getClientID(), p_SPIT_Type_Interface.getID(), true)) {
            boolFoundConflict = true;
        }
        if (boolFoundConflict) {
            SPIT_Type.notifyConflictsChanged();
            return true;
        }
        boolRemoved = s_SPITTypeTableModel.removeSPIT_Type(p_SPIT_Type_Interface);
        if (boolRemoved) {
            if (p_SPITServer_Client != null) {
                o_SPIT_Type.removeOwnerSPITServer_ClientID(p_SPITServer_Client.getClientID());
            }
            String stringID = p_SPIT_Type_Interface.getID();
            p_SPIT_Type_Interface.close();
            if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
                SPIT_Message o_SPIT_Message = SPIT_Message.createRemoveSPITType((String)stringID);
                SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
            }
        }
        return boolRemoved;
    }

    public static int getSPIT_TypeCount() {
        return s_SPITTypeTableModel.size();
    }

    public static SPIT_Type_Interface getSPIT_Type(String p_ID) {
        return s_SPITTypeTableModel.getSPIT_Type(p_ID);
    }

    public static SPIT_Type_Interface getSPIT_Type(int p_Index) {
        return s_SPITTypeTableModel.getSPIT_Type(p_Index);
    }

    public static Object[] getSPIT_Types() {
        return s_SPITTypeTableModel.getSPIT_Types();
    }

    public static boolean parseReportSPITType(SPIT_Message.ReportSPITType p_ReportSPITType, SPITServer_Client p_SPITServer_Client, boolean p_IsTransferringProject) {
        SPIT_Message o_SPIT_Message;
        boolean boolConfirmed;
        if (p_ReportSPITType == null) {
            return false;
        }
        if (p_SPITServer_Client == null) {
            return false;
        }
        boolean boolExisting = true;
        SPITServer_Client o_SPIT_Client = p_SPITServer_Client;
        if (o_SPIT_Client == null) {
            return false;
        }
        if (p_ReportSPITType.getServerRemote()) {
            return false;
        }
        SPIT_Type o_SPIT_Type = (SPIT_Type)SPIT_Type.getSPIT_Type(p_ReportSPITType.getID());
        if (p_IsTransferringProject) {
            if (o_SPIT_Type == null) {
                if (p_ReportSPITType.getFixed()) {
                    o_SPIT_Type = new SPIT_Type();
                    o_SPIT_Type.readReportSPITType(p_ReportSPITType);
                    o_SPIT_Type.setConfirmed(true);
                    SPIT_Type.addSPIT_Type(o_SPIT_Type, p_SPITServer_Client);
                } else {
                    s_SPITTypeConflictModel.addConflict(o_SPIT_Client.getClientID(), null, new SPIT_TypeDescription(p_ReportSPITType));
                    SPIT_Type.notifyConflictsChanged();
                }
                return true;
            }
            if (p_ReportSPITType.getFixed()) {
                o_SPIT_Type.readReportSPITType(p_ReportSPITType);
                o_SPIT_Type.setConfirmed(true);
                SPIT_Message o_SPIT_Message2 = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_Type);
                o_SPIT_Client.sendSPIT_Message(o_SPIT_Message2);
                return true;
            }
            boolean boolEqual = false;
            if (o_SPIT_Type.getOwnerSpitServer_ClientCount() <= 0 && o_SPIT_Type.checkEqualsReportSPITType(p_ReportSPITType)) {
                boolEqual = true;
            }
            if (boolEqual) {
                o_SPIT_Type.setConfirmed(true);
                SPIT_Message o_SPIT_Message3 = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_Type);
                o_SPIT_Client.sendSPIT_Message(o_SPIT_Message3);
            } else {
                s_SPITTypeConflictModel.addConflict(o_SPIT_Client.getClientID(), o_SPIT_Type.getSPIT_TypeDescription(), new SPIT_TypeDescription(p_ReportSPITType));
                SPIT_Type.notifyConflictsChanged();
            }
            return true;
        }
        if (o_SPIT_Type == null) {
            o_SPIT_Type = new SPIT_Type();
            boolExisting = false;
            boolConfirmed = false;
        } else {
            boolExisting = true;
            boolConfirmed = p_ReportSPITType.getConfirmed();
        }
        o_SPIT_Type.readReportSPITType(p_ReportSPITType);
        o_SPIT_Type.setConfirmed(true);
        if (!boolExisting) {
            SPIT_Type.addSPIT_Type(o_SPIT_Type, p_SPITServer_Client);
        } else if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
            o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_Type);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, o_SPIT_Client);
        }
        if (!boolConfirmed) {
            o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_Type);
            o_SPIT_Client.sendSPIT_Message(o_SPIT_Message);
        }
        return true;
    }

    public static boolean parseRemoveSPITType(SPIT_Message.RemoveSPITType p_RemoveSPITType, SPITServer_Client p_SPITServer_Client) {
        if (p_RemoveSPITType == null) {
            return false;
        }
        SPIT_Type o_SPITTypeExisting = (SPIT_Type)SPIT_Type.getSPIT_Type(p_RemoveSPITType.getID());
        if (o_SPITTypeExisting == null) {
            s_SPITTypeConflictModel.removeConflict(p_SPITServer_Client.getClientID(), p_RemoveSPITType.getID(), true);
        }
        return SPIT_Type.removeSPIT_Type_ByClient(o_SPITTypeExisting, p_SPITServer_Client);
    }

    public static void parseCloseProject_Client(SPITServer_Client p_SPITServer_Client) {
        SPIT_Type o_SPIT_Type;
        int intSPITType;
        if (p_SPITServer_Client == null) {
            return;
        }
        ArrayList<SPIT_Type> o_SPIT_Types = new ArrayList<SPIT_Type>(s_SPITTypeTableModel.size());
        for (intSPITType = s_SPITTypeTableModel.size() - 1; intSPITType >= 0; --intSPITType) {
            o_SPIT_Type = (SPIT_Type)s_SPITTypeTableModel.getSPIT_Type(intSPITType);
            if (o_SPIT_Type == null) continue;
            o_SPIT_Types.add(o_SPIT_Type);
        }
        s_SPITTypeConflictModel.removeConflict(p_SPITServer_Client.getClientID());
        for (intSPITType = 0; intSPITType < o_SPIT_Types.size(); ++intSPITType) {
            o_SPIT_Type = (SPIT_Type)o_SPIT_Types.get(intSPITType);
            o_SPIT_Type.removeOwnerSPITServer_ClientID(p_SPITServer_Client.getClientID());
        }
        SPIT_Type.notifyConflictsChanged();
    }

    public static void parseCloseProject() {
        s_SPITTypeConflictModel.clear();
        int intSPITTypeCount = s_SPITTypeTableModel.size();
        for (int intType = intSPITTypeCount - 1; intType >= 0; --intType) {
            SPIT_Type_Interface o_SPIT_Type_Interface = s_SPITTypeTableModel.getSPIT_Type(intType);
            SPIT_Type.removeSPIT_Type_ByServer(o_SPIT_Type_Interface);
        }
        s_SPITTypeTableModel.clear();
        SPIT_Type.notifyConflictsChanged();
    }

    public static void parseNewProject() {
        s_SPITTypeConflictModel.clear();
        SPIT_Type.notifyConflictsChanged();
    }

    public static void notifyConflictsChanged() {
        if (s_SPITTypeConflictModel.size() > 0) {
            SPITServer.getPropertyChangeSupport().firePropertyChange(PROP_CONFLICTS, false, true);
        } else {
            SPITServer.getPropertyChangeSupport().firePropertyChange(PROP_CONFLICTS, true, false);
        }
    }

    public static void synchronizeSPITTypes_ClientToServer(int[] p_TypeConflictIndexes) {
        boolean boolConflictsChanged = false;
        if (p_TypeConflictIndexes != null && p_TypeConflictIndexes.length > 0) {
            int intConflict;
            ArrayList<SPIT_TypeDescription> o_TypeConflicts_Server = new ArrayList<SPIT_TypeDescription>(p_TypeConflictIndexes.length);
            ArrayList<SPIT_TypeDescription> o_TypeConflicts_Client = new ArrayList<SPIT_TypeDescription>(p_TypeConflictIndexes.length);
            ArrayList<String> o_TypeConflicts_CLientID = new ArrayList<String>(p_TypeConflictIndexes.length);
            for (intConflict = 0; intConflict < p_TypeConflictIndexes.length; ++intConflict) {
                o_TypeConflicts_Server.add(s_SPITTypeConflictModel.getTypeDescription_Server(p_TypeConflictIndexes[intConflict]));
                o_TypeConflicts_Client.add(s_SPITTypeConflictModel.getTypeDescription_Client(p_TypeConflictIndexes[intConflict]));
                o_TypeConflicts_CLientID.add(s_SPITTypeConflictModel.getClientID(p_TypeConflictIndexes[intConflict]));
            }
            for (intConflict = 0; intConflict < o_TypeConflicts_Server.size(); ++intConflict) {
                SPIT_Type o_SPIT_Type_Interface;
                SPIT_TypeDescription o_TypeDescription_Server = (SPIT_TypeDescription)o_TypeConflicts_Server.get(intConflict);
                SPIT_TypeDescription o_TypeDescription_Client = (SPIT_TypeDescription)o_TypeConflicts_Client.get(intConflict);
                SPIT_ClientInterface o_SPITServer_Client = SPITServer_Client.getSPIT_ClientInterface((String)o_TypeConflicts_CLientID.get(intConflict));
                if (o_SPITServer_Client == null || !o_SPITServer_Client.isConnected() || o_TypeDescription_Server == null && o_TypeDescription_Client == null) continue;
                if (o_TypeDescription_Client != null && o_TypeDescription_Server != null) {
                    o_SPIT_Type_Interface = (SPIT_Type)SPIT_Type.getSPIT_Type(o_TypeDescription_Server.getID());
                    if (o_SPIT_Type_Interface == null) continue;
                    o_SPIT_Type_Interface.copyFromDescription(o_TypeDescription_Client);
                    o_SPIT_Type_Interface.setConfirmed(true);
                    SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_Type_Interface);
                    if (!o_SPITServer_Client.sendSPIT_Message(o_SPIT_Message)) continue;
                    if (s_SPITTypeConflictModel.removeConflict(o_SPITServer_Client.getClientID(), o_TypeDescription_Client.getID(), true)) {
                        boolConflictsChanged = true;
                    }
                    if (!s_SPITTypeConflictModel.removeConflict(o_SPITServer_Client.getClientID(), o_TypeDescription_Server.getID(), false)) continue;
                    boolConflictsChanged = true;
                    continue;
                }
                if (o_TypeDescription_Client != null) {
                    o_SPIT_Type_Interface = new SPIT_Type();
                    o_SPIT_Type_Interface.copyFromDescription(o_TypeDescription_Client);
                    SPIT_Type.addSPIT_Type(o_SPIT_Type_Interface, o_SPITServer_Client);
                    continue;
                }
                if (o_TypeDescription_Server == null) continue;
                o_SPIT_Type_Interface = (SPIT_Type)SPIT_Type.getSPIT_Type(o_TypeDescription_Server.getID());
                SPIT_Type.removeSPIT_Type_ByServer(o_SPIT_Type_Interface);
            }
            if (boolConflictsChanged) {
                SPIT_Type.notifyConflictsChanged();
            }
        }
    }

    public static void synchronizeSPITTypes_ServerToClient(int[] p_TypeConflictIndexes) {
        if (p_TypeConflictIndexes != null && p_TypeConflictIndexes.length > 0) {
            int intConflict;
            ArrayList<SPIT_TypeDescription> o_Conflicts_Server = new ArrayList<SPIT_TypeDescription>(p_TypeConflictIndexes.length);
            ArrayList<SPIT_TypeDescription> o_Conflicts_Client = new ArrayList<SPIT_TypeDescription>(p_TypeConflictIndexes.length);
            ArrayList<String> o_Conflicts_ClientID = new ArrayList<String>(p_TypeConflictIndexes.length);
            for (intConflict = 0; intConflict < p_TypeConflictIndexes.length; ++intConflict) {
                o_Conflicts_Server.add(s_SPITTypeConflictModel.getTypeDescription_Server(p_TypeConflictIndexes[intConflict]));
                o_Conflicts_Client.add(s_SPITTypeConflictModel.getTypeDescription_Client(p_TypeConflictIndexes[intConflict]));
                o_Conflicts_ClientID.add(s_SPITTypeConflictModel.getClientID(p_TypeConflictIndexes[intConflict]));
            }
            for (intConflict = 0; intConflict < o_Conflicts_Server.size(); ++intConflict) {
                SPIT_Message o_SPIT_Message;
                SPIT_Type o_SPIT_Type_Interface;
                SPIT_TypeDescription o_TypeDescription_Server = (SPIT_TypeDescription)o_Conflicts_Server.get(intConflict);
                SPIT_TypeDescription o_TypeDescription_Client = (SPIT_TypeDescription)o_Conflicts_Client.get(intConflict);
                SPIT_ClientInterface o_SPITServer_Client = SPITServer_Client.getSPIT_ClientInterface((String)o_Conflicts_ClientID.get(intConflict));
                if (o_SPITServer_Client == null || !o_SPITServer_Client.isConnected() || o_TypeDescription_Server == null && o_TypeDescription_Client == null) continue;
                if (o_TypeDescription_Client != null && o_TypeDescription_Server != null) {
                    o_SPIT_Type_Interface = (SPIT_Type)SPIT_Type.getSPIT_Type(o_TypeDescription_Server.getID());
                    if (o_SPIT_Type_Interface == null) continue;
                    o_SPIT_Type_Interface.copyFromDescription(o_TypeDescription_Server);
                    o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_Type_Interface);
                    if (!o_SPITServer_Client.sendSPIT_Message(o_SPIT_Message)) continue;
                    s_SPITTypeConflictModel.removeConflict(o_SPITServer_Client.getClientID(), o_SPIT_Type_Interface.getID(), true);
                    SPIT_Type.notifyConflictsChanged();
                    continue;
                }
                if (o_TypeDescription_Client != null) {
                    ArrayList<LiveShowSPITObjectDescription> o_LiveShowSPITObjectDescriptions = LiveShowSPITObject.s_SPITObjectConflictModel.getObjectDescriptions_Client(o_SPITServer_Client.getClientID(), o_TypeDescription_Client.getID());
                    for (int intObject = 0; intObject < o_LiveShowSPITObjectDescriptions.size(); ++intObject) {
                        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = o_LiveShowSPITObjectDescriptions.get(intObject);
                        if (o_LiveShowSPITObjectDescription == null) continue;
                        o_SPIT_Message = SPIT_Message.createRemoveSPITObject((String)o_LiveShowSPITObjectDescription.getID());
                        o_SPITServer_Client.sendSPIT_Message(o_SPIT_Message);
                    }
                    o_SPIT_Message = SPIT_Message.createRemoveSPITType((String)o_TypeDescription_Client.getID());
                    if (!o_SPITServer_Client.sendSPIT_Message(o_SPIT_Message)) continue;
                    s_SPITTypeConflictModel.removeConflict(o_SPITServer_Client.getClientID(), o_TypeDescription_Client.getID(), true);
                    SPIT_Type.notifyConflictsChanged();
                    continue;
                }
                if (o_TypeDescription_Server == null) continue;
                o_SPIT_Type_Interface = new SPIT_Type();
                o_SPIT_Type_Interface.copyFromDescription(o_TypeDescription_Server);
                o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_Type_Interface);
                if (!o_SPITServer_Client.sendSPIT_Message(o_SPIT_Message)) continue;
                s_SPITTypeConflictModel.removeConflict(o_SPITServer_Client.getClientID(), o_SPIT_Type_Interface.getID(), false);
                SPIT_Type.notifyConflictsChanged();
            }
        }
    }

    public SPIT_Type() {
        s_SPITTypeListModel.setGetSortStringMethod(SPIT_Type_Interface.class, "getName", true);
        this.m_SyncObject = new Object();
        this.initMembers();
        this.m_Description = new SPIT_TypeDescription();
        this.m_Description.setName(this.createName(SPIT_TypeDescription.DEFAULTNAME));
    }

    private void initMembers() {
        this.m_SPITServer_ClientIDs = new ArrayList();
        this.m_SinglePropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_Confirmed = false;
        this.m_JustLoadProject = false;
        ++SPIT_TypeDescription.s_InstanceCount;
    }

    public void close() {
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_CLOSED, null, this);
    }

    public SPIT_TypeDescription getSPIT_TypeDescription() {
        return this.m_Description;
    }

    public Icon getIcon() {
        return s_Icon;
    }

    public void setID(String p_ID) {
        if (!this.m_Description.setID(p_ID)) {
            return;
        }
    }

    public String getID() {
        return this.m_Description.getID();
    }

    public void addOwnerSPITServer_ClientID(String p_SPITServer_ClientID) {
        if (p_SPITServer_ClientID == null) {
            return;
        }
        if (this.m_SPITServer_ClientIDs.contains(p_SPITServer_ClientID)) {
            return;
        }
        this.m_SPITServer_ClientIDs.add(p_SPITServer_ClientID);
    }

    public void removeOwnerSPITServer_ClientID(String p_SPITServer_ClientID) {
        if (p_SPITServer_ClientID == null) {
            return;
        }
        this.m_SPITServer_ClientIDs.remove(p_SPITServer_ClientID);
    }

    public int getOwnerSpitServer_ClientCount() {
        return this.m_SPITServer_ClientIDs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSPITServer_ClientID(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.m_SPITServer_ClientIDs.size()) {
                return null;
            }
            return this.m_SPITServer_ClientIDs.get(p_Index);
        }
    }

    public void setFixed(boolean p_Fixed) {
        if (!this.m_Description.setFixed(p_Fixed)) {
            return;
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)this);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
    }

    public boolean getFixed() {
        return this.m_Description.getFixed();
    }

    public void setServerRemote(boolean p_IsServerRemote) {
        if (!this.m_Description.setServerRemote(p_IsServerRemote)) {
            return;
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)this);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
    }

    public boolean getServerRemote() {
        return this.m_Description.getServerRemote();
    }

    public void setServerProjectIndepended(boolean p_ProjectDepending) {
        if (!this.m_Description.setServerProjectIndepended(p_ProjectDepending)) {
            return;
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)this);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
    }

    public boolean getServerProjectIndepended() {
        return this.m_Description.getServerProjectIndepended();
    }

    public void setGroupName(String p_GroupName) {
        if (!this.m_Description.setGroupName(p_GroupName)) {
            return;
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)this);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
    }

    public String getGroupName() {
        return this.m_Description.getGroupName();
    }

    public String createName(String p_Name) {
        int intPrefixCount = 0;
        int intMaxPostFix = 0;
        String stringPrefix = p_Name == null || p_Name.length() <= 0 ? SPIT_TypeDescription.DEFAULTNAME : NameExtension.getPrefix(p_Name);
        for (int intSPITType = 0; intSPITType < SPIT_Type.getSPIT_TypeCount(); ++intSPITType) {
            int intPostfix;
            SPIT_Type_Interface o_SPIT_Type = SPIT_Type.getSPIT_Type(intSPITType);
            if (o_SPIT_Type == null || (intPostfix = NameExtension.getPostfix_Int(o_SPIT_Type.getName(), stringPrefix)) == -2) continue;
            if (intPostfix == -1) {
                intPostfix = ++intPrefixCount;
            }
            if (intPostfix <= intMaxPostFix) continue;
            intMaxPostFix = intPostfix;
        }
        return NameExtension.createName(stringPrefix, ++intMaxPostFix, "000", true);
    }

    public void setName(String p_Name) {
        if (!this.m_Description.setName(p_Name)) {
            return;
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)this);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
    }

    public String getName() {
        return this.m_Description.getName();
    }

    public void setDelay(long p_Delay) {
        if (!this.m_Description.setDelay(p_Delay)) {
            return;
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)this);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
    }

    public long getDelay() {
        return this.m_Description.getDelay();
    }

    public void setDuration(long p_Duration) {
        if (!this.m_Description.setDuration(p_Duration)) {
            return;
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)this);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
    }

    public long getDuration() {
        return this.m_Description.getDuration();
    }

    public boolean readReportSPITType(SPIT_Message.ReportSPITType p_ReportSPITType) {
        if (p_ReportSPITType == null) {
            return false;
        }
        if (this.m_Description.readReportSPITType(p_ReportSPITType)) {
            this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
            return true;
        }
        return false;
    }

    public boolean checkEqualsReportSPITType(SPIT_Message.ReportSPITType p_ReportSPITType) {
        return this.m_Description.checkEqualsReportSPITType(p_ReportSPITType);
    }

    public boolean copyFromDescription(SPIT_TypeDescription p_TypeDescription) {
        if (p_TypeDescription == null) {
            return false;
        }
        if (this.m_Description.copyFromDescription(p_TypeDescription)) {
            this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
            return true;
        }
        return false;
    }

    public boolean getJustLoadProject() {
        return this.m_JustLoadProject;
    }

    public void setJustLoadProject(boolean p_JustLoaded) {
        this.m_JustLoadProject = p_JustLoaded;
    }

    public boolean getConfirmed() {
        return this.m_Confirmed;
    }

    public void setConfirmed(boolean p_Confirmed) {
        if (this.m_Confirmed == p_Confirmed) {
            return;
        }
        boolean oldValue = this.m_Confirmed;
        this.m_Confirmed = p_Confirmed;
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_CONFIRMED, oldValue, this.m_Confirmed);
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_Description.getID());
        out.writeBoolean(this.m_Description.getFixed());
        out.writeBoolean(this.m_Description.getServerRemote());
        out.writeUTF(this.m_Description.getGroupName());
        out.writeUTF(this.m_Description.getName());
        out.writeLong(this.m_Description.getDelay());
        out.writeLong(this.m_Description.getDuration());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_Description.setID(in.readUTF());
        this.m_Description.setFixed(in.readBoolean());
        this.m_Description.setServerRemote(in.readBoolean());
        this.m_Description.setGroupName(in.readUTF());
        this.m_Description.setName(in.readUTF());
        this.m_Description.setDelay(in.readLong());
        this.m_Description.setDuration(in.readLong());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SPITServer_Client) {
            SPITServer_Client o_SPITServer_Client = (SPITServer_Client)evt.getSource();
            if ("clientClosed".equals(evt.getPropertyName())) {
                // empty if block
            }
        }
    }

    static {
        LiveLanguage.addLanguageListener(SPIT_Type.class, null);
        LiveLanguage.loadLanguageStrings(SPIT_Type.class);
        SPIT_TypeModel.COLUMN_GROUPNAME = SPITTYPEMODEL_COLUMN_GROUPNAME;
        SPIT_TypeModel.COLUMN_TYPENAME = SPITTYPEMODEL_COLUMN_TYPENAME;
        SPIT_TypeModel.COLUMN_DELAYNAME = SPITTYPEMODEL_COLUMN_DELAYNAME;
        SPIT_TypeModel.COLUMN_DURATIONNAME = SPITTYPEMODEL_COLUMN_DURATIONNAME;
    }
}

