/*
 * Decompiled with CFR 0.152.
 */
package SPITServerPackage;

import GUID.LiveGUID;
import LiveShowObjectPackage.LiveShowObjectInterface;
import MediaVirtualPackage.LiveShowMediaVIP;
import PlayMediaPackage.PlayMedia;
import SPITActionPackage.SPIT_ActionPlayer;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Message;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITLibraryPackage.SPIT_Watchdog;
import SPITModelPackage.SPITClientTableModel;
import SPITRemotePackage.SPITRemote;
import SPITServerPackage.LiveShowSPITObject;
import SPITServerPackage.SPITServer;
import SPITServerPackage.SPIT_ServerInterface;
import SPITServerPackage.SPIT_Type;
import SPITToolsPackage.SinglePropertyChangeSupport;
import StartPackage.LiveShowMediaSystem;
import TimerPackage.JavaTimer;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.time.LocalDateTime;
import java.util.ArrayList;

public class SPITServer_Client
implements SPIT_ClientInterface {
    public static boolean s_DEBUGON = false;
    public static SPITClientTableModel s_SPITClientTableModel = new SPITClientTableModel();
    private static final Object s_SyncObject = new Object();
    public static final String PROP_CLIENTPROJECTNAME = "clientProjectName";
    public static final String PROP_CLIENTSPITPROJECTCLOSED = "clientClosed";
    public static int s_MAX_OVERTAKING_SPIT_MESSAGES = 10;
    private InetAddress m_InetAddress;
    private int m_Port;
    private int m_MessageNumber_Send;
    private int m_MessageNumber_Received;
    private int m_MessageNumber_Confirmed_Received;
    private int m_MessageNumber_Confirmed_Send;
    private int m_ConfirmMessagesAfter;
    private final Object m_SyncMessageNumber = new Object();
    private boolean m_Connected;
    private boolean m_WaitForConfirmReceived = false;
    private long m_WaitForConfirmReceived_Start = -1L;
    private String m_ClientID;
    private String m_Name;
    private String m_ClientComputerName;
    private String m_ClientLoginName;
    private String m_ClientLoginPassword;
    private String m_ClientSPITProjectID;
    private String m_ClientSPITProjectName;
    private ArrayList<SPIT_Message> m_OvertakingSPIT_Messages;
    private SPIT_ServerInterface m_SPIT_ServerInterface;
    private String m_ServerIP;
    private int m_ServerPort;
    private boolean m_SPIT_ClientTransferringProject;
    private ArrayList<SPIT_Message> m_SPIT_MessagesToSend;
    private final Object m_SyncSpitMessagesToSend = new Object();
    private ArrayList<SPIT_Message> m_SPIT_MessagesSended;
    private int m_SPITMessageToSend_Attempts = 0;
    private SPIT_Watchdog m_SPIT_Watchdog;
    private JavaTimer m_JavaTimer;
    private boolean m_Closed;
    private final Object m_SyncClose = new Object();
    private SinglePropertyChangeSupport m_SinglePropertyChangeSupport;

    public static int getSPITClientsCount() {
        return s_SPITClientTableModel.size();
    }

    public SPITServer_Client(SPIT_ServerInterface p_SPIT_ServerInterface, String p_ID, String p_ClientComputerName, String p_Name, InetAddress p_InetAddress, int p_Port, String p_ServerIP, int p_ServerPort) {
        this.initMembers();
        this.m_ClientID = p_ID;
        this.m_ClientComputerName = p_ClientComputerName;
        this.m_Name = p_Name;
        this.m_InetAddress = p_InetAddress;
        this.m_Port = p_Port;
        this.m_SPIT_ServerInterface = p_SPIT_ServerInterface;
        this.m_ServerIP = p_ServerIP;
        this.m_ServerPort = p_ServerPort;
    }

    private void initMembers() {
        this.m_Closed = false;
        this.m_Connected = false;
        this.m_ClientID = LiveGUID.getGUID();
        this.m_InetAddress = null;
        this.m_Name = "";
        this.m_ClientComputerName = "";
        this.m_ClientSPITProjectID = "";
        this.m_ClientSPITProjectName = "";
        this.m_ClientLoginName = "";
        this.m_ClientLoginPassword = "";
        this.m_SinglePropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_SPIT_MessagesToSend = new ArrayList();
        this.m_ConfirmMessagesAfter = 0;
        this.m_SPIT_MessagesSended = new ArrayList();
        this.m_SPITMessageToSend_Attempts = 0;
        this.m_SPIT_Watchdog = new SPIT_Watchdog((SPIT_ClientInterface)this);
        this.m_OvertakingSPIT_Messages = new ArrayList();
        this.m_SPIT_ClientTransferringProject = false;
        this.m_MessageNumber_Send = 1;
        this.m_MessageNumber_Received = -1;
        this.m_MessageNumber_Confirmed_Received = -1;
        this.m_MessageNumber_Confirmed_Send = -1;
        this.m_WaitForConfirmReceived = false;
        this.m_WaitForConfirmReceived_Start = -1L;
        this.m_JavaTimer = new JavaTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_SyncClose;
        synchronized (object) {
            if (this.m_Closed) {
                return;
            }
            this.m_Closed = true;
        }
        this.m_SPIT_Watchdog.close();
        SPIT_Type.parseCloseProject_Client(this);
        LiveShowSPITObject.parseCloseProject_Client(this);
        SPIT_Message o_SPIT_Message = SPIT_Message.createDisconnect();
        o_SPIT_Message.getHeader().setClientID(this.getClientID());
        o_SPIT_Message.getHeader().setServerID(this.getServerID());
        o_SPIT_Message.getHeader().setMessageNumber((byte)0);
        if (this.m_SPIT_ServerInterface != null) {
            this.m_SPIT_ServerInterface.sendSPIT_Message(o_SPIT_Message, this.getInetAddress(), this.getPort());
        }
        this.setConnected(false);
        this.clearSPIT_MessagesToSend();
        if (this.m_SPIT_ServerInterface != null) {
            this.m_SPIT_ServerInterface.removeSPIT_ClientInterface((SPIT_ClientInterface)this);
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_CLIENTSPITPROJECTCLOSED, this, null);
        this.m_SPIT_ClientTransferringProject = false;
        if (this.m_JavaTimer != null) {
            this.m_JavaTimer.close();
        }
        this.printReport("--- Client Close ---", "CLOSED");
    }

    public void setClientConnectionParams(String p_ClientID, String p_ClientLoginName, String p_ClientLoginPassword) {
        this.m_ClientID = p_ClientID;
        this.m_ClientLoginName = p_ClientLoginName;
        this.m_ClientLoginPassword = p_ClientLoginPassword;
    }

    public String getClientID() {
        return this.m_ClientID;
    }

    public String getClientLoginName() {
        return this.m_ClientLoginName;
    }

    public String getClientLoginPassword() {
        return this.m_ClientLoginPassword;
    }

    public String getName() {
        return this.m_Name;
    }

    public String getClientComputerName() {
        return this.m_ClientComputerName;
    }

    public String getServerID() {
        if (this.m_SPIT_ServerInterface != null) {
            return this.m_SPIT_ServerInterface.getServerID();
        }
        return "";
    }

    public String getServerIP() {
        return this.m_ServerIP;
    }

    public int getServerPort() {
        return this.m_ServerPort;
    }

    public String getServerComputerName() {
        return SPITServer.s_ServerComputerName;
    }

    public String getServerName() {
        return SPITServer.s_ServerName;
    }

    public void setServerProjectName(String p_ServerProjectName) {
    }

    public String getServerProjectName() {
        return LiveShowMediaSystem.getLiveShowProjectDescription().getProjectName();
    }

    public int getServerStepTime() {
        return PlayMedia.BUFFER_MILLISECONDS;
    }

    public int getServerFramesPerSecond() {
        return SPITServer.getFramesPerSecond();
    }

    public void setClientProjectID(String p_ClientProjectID) {
        if (p_ClientProjectID == null) {
            p_ClientProjectID = "";
        }
        if (p_ClientProjectID.equals(this.m_ClientSPITProjectID)) {
            return;
        }
        this.m_ClientSPITProjectID = p_ClientProjectID;
    }

    public String getClientProjectID() {
        return this.m_ClientSPITProjectID;
    }

    public void setClientProjectName(String p_ClientProjectName) {
        if (p_ClientProjectName == null) {
            return;
        }
        if (this.m_ClientSPITProjectName.equals(p_ClientProjectName)) {
            return;
        }
        String oldValue = this.m_ClientSPITProjectName;
        this.m_ClientSPITProjectName = p_ClientProjectName;
        this.firePropertyChange(PROP_CLIENTPROJECTNAME, oldValue, this.m_ClientSPITProjectName);
    }

    public String getClientProjectName() {
        return this.m_ClientSPITProjectName;
    }

    public InetAddress getInetAddress() {
        return this.m_InetAddress;
    }

    public String getIPAddress() {
        InetAddress o_InetAddress = this.m_InetAddress;
        if (o_InetAddress == null) {
            return "";
        }
        return o_InetAddress.getHostAddress();
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setConfirmAfter(byte p_ConfirmAfter) {
        this.m_ConfirmMessagesAfter = p_ConfirmAfter & 0xFF;
        if (s_MAX_OVERTAKING_SPIT_MESSAGES < this.m_ConfirmMessagesAfter) {
            s_MAX_OVERTAKING_SPIT_MESSAGES = this.m_ConfirmMessagesAfter;
        }
    }

    public void setConfirmAfter_Int(int p_ConfirmAfter) {
        if (p_ConfirmAfter < 0) {
            p_ConfirmAfter = 0;
        }
        if (p_ConfirmAfter > 255) {
            p_ConfirmAfter = 255;
        }
        this.m_ConfirmMessagesAfter = p_ConfirmAfter;
        if (s_MAX_OVERTAKING_SPIT_MESSAGES < this.m_ConfirmMessagesAfter) {
            s_MAX_OVERTAKING_SPIT_MESSAGES = this.m_ConfirmMessagesAfter;
        }
    }

    public byte getConfirmAfter() {
        return (byte)(this.m_ConfirmMessagesAfter & 0xFF);
    }

    public int getConfirmAfter_Int() {
        return this.m_ConfirmMessagesAfter;
    }

    public void setConnected(boolean p_Connected) {
        this.m_Connected = p_Connected;
    }

    public boolean isConnected() {
        return this.m_Connected;
    }

    public int getMessageNumberSend() {
        return this.m_MessageNumber_Send;
    }

    public void resetMessageNumberReceived() {
        this.m_MessageNumber_Received = -1;
        this.m_MessageNumber_Confirmed_Received = -1;
        this.m_OvertakingSPIT_Messages.clear();
        this.m_MessageNumber_Confirmed_Send = -1;
    }

    public int getMessageNumberReceived() {
        return this.m_MessageNumber_Received;
    }

    public void setMessageNumberReceived(int p_MessageNumber, boolean p_SendConfirmReceivedDirect) {
        if (p_MessageNumber == 0) {
            return;
        }
        this.m_MessageNumber_Received = p_MessageNumber > 255 || p_MessageNumber < 0 ? 0 : p_MessageNumber;
        if (this.m_ConfirmMessagesAfter > 0) {
            int intDiff;
            if (this.m_MessageNumber_Confirmed_Received < 0) {
                this.m_MessageNumber_Confirmed_Received = this.m_MessageNumber_Received;
            }
            if ((intDiff = this.diffMessageNumber(this.m_MessageNumber_Confirmed_Received, this.m_MessageNumber_Received)) >= this.m_ConfirmMessagesAfter - 1 || p_SendConfirmReceivedDirect) {
                this.sendConfirmReceived(this.m_MessageNumber_Received, 0);
            }
        }
    }

    private int diffMessageNumber(int p_NumberOld, int p_NumberNew) {
        int intDiff = p_NumberNew - p_NumberOld;
        if (intDiff > 127) {
            intDiff = p_NumberNew - (p_NumberOld + 255);
        }
        if (intDiff < -127) {
            intDiff = p_NumberNew + 255 - p_NumberOld;
        }
        return intDiff;
    }

    public void sendConfirmReceived(int p_MessageNumber_Received, int p_MessageNumber_Missed) {
        SPIT_ServerInterface o_SPITServerInterface = this.m_SPIT_ServerInterface;
        if (this.m_ConfirmMessagesAfter > 0 && o_SPITServerInterface != null) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createConfirmReceived((byte)((byte)p_MessageNumber_Received), (byte)((byte)p_MessageNumber_Missed));
            o_SPIT_Message.getHeader().setServerID(this.getServerID());
            o_SPIT_Message.getHeader().setClientID(this.getClientID());
            o_SPIT_Message.getHeader().setMessageNumber((byte)0);
            o_SPITServerInterface.sendSPIT_Message(o_SPIT_Message, this.getInetAddress(), this.getPort());
        }
        if (++p_MessageNumber_Received > 255) {
            p_MessageNumber_Received = 1;
        }
        this.m_MessageNumber_Confirmed_Received = p_MessageNumber_Received;
    }

    public boolean checkParseSPIT_Message(SPIT_Message p_SPIT_Message) {
        int intDiff;
        int intActualMessageNumber;
        if (p_SPIT_Message == null) {
            return false;
        }
        if (this.m_Closed) {
            return false;
        }
        SPIT_Message.Header o_Header = p_SPIT_Message.getHeader();
        SPIT_Message.OPPart o_OPPart = p_SPIT_Message.getOPPart();
        if (o_Header == null || o_OPPart == null) {
            this.printReport("Error", "checkParseSPIT_Message SPIT_Message Header or OPPart wrong");
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        if ((intActualMessageNumber = p_SPIT_Message.getMessageNumber()) == 0) {
            return this.parseSPIT_Message(p_SPIT_Message);
        }
        if (this.m_MessageNumber_Received < 0) {
            this.setMessageNumberReceived(intActualMessageNumber, false);
            return this.parseSPIT_Message(p_SPIT_Message);
        }
        int intNextMessageNumber = this.m_MessageNumber_Received + 1;
        if (intNextMessageNumber > 255 || intNextMessageNumber < 1) {
            intNextMessageNumber = 1;
        }
        if ((intDiff = this.diffMessageNumber(intNextMessageNumber, intActualMessageNumber)) < 0) {
            this.printReport("Comment", "checkParseSPIT_Message expected MessageNumber: " + intNextMessageNumber + " received SPIT_Message (OPFlage: " + p_SPIT_Message.getOPFlag() + ") maybe resended. MessageNmber: " + intActualMessageNumber);
            this.sendConfirmReceived(this.m_MessageNumber_Received, 0);
            return true;
        }
        if (intActualMessageNumber == intNextMessageNumber) {
            boolean boolParsed = true;
            this.setMessageNumberReceived(intActualMessageNumber, false);
            if (!this.parseSPIT_Message(p_SPIT_Message)) {
                boolParsed = false;
            }
            if (this.m_OvertakingSPIT_Messages.size() > 0) {
                this.printReport("Comment", "checkParseSPIT_Message received missing SPIT_Message" + intActualMessageNumber + " (OPFlag: " + p_SPIT_Message.getOPFlag() + ")");
            }
            while (this.m_OvertakingSPIT_Messages.size() > 0) {
                SPIT_Message o_OvertakingSPIT_Message;
                int intOvertakingMessageNumber;
                intNextMessageNumber = this.m_MessageNumber_Received + 1;
                if (intNextMessageNumber > 255 || intNextMessageNumber < 1) {
                    intNextMessageNumber = 1;
                }
                if ((intOvertakingMessageNumber = (o_OvertakingSPIT_Message = this.m_OvertakingSPIT_Messages.get(0)).getMessageNumber()) == intNextMessageNumber) {
                    this.printReport("Comment", "checkParseSPIT_Message       overtaking SPIT_Message" + intOvertakingMessageNumber + " (OPFlag: " + o_OvertakingSPIT_Message.getOPFlag() + ") will be handled.");
                    this.setMessageNumberReceived(intOvertakingMessageNumber, true);
                    if (!this.parseSPIT_Message(o_OvertakingSPIT_Message)) {
                        boolParsed = false;
                    }
                    this.m_OvertakingSPIT_Messages.remove(0);
                    continue;
                }
                if (this.m_ConfirmMessagesAfter <= 0) break;
                this.sendConfirmReceived(this.m_MessageNumber_Received, intNextMessageNumber);
                break;
            }
            return boolParsed;
        }
        this.printReport("Comment", " checkParseSPIT_Message  SPIT_Message " + intActualMessageNumber + " (OPFlag: " + p_SPIT_Message.getOPFlag() + ") has overtaken " + intNextMessageNumber);
        if (this.addOvertakingSPIT_Message(p_SPIT_Message, intNextMessageNumber) && this.m_ConfirmMessagesAfter > 0) {
            this.sendConfirmReceived(this.m_MessageNumber_Received, intNextMessageNumber);
        }
        return true;
    }

    public boolean addOvertakingSPIT_Message(SPIT_Message p_SPIT_Message, int p_MissedMessageNumber) {
        int intMessageNumber;
        if (p_SPIT_Message == null) {
            return true;
        }
        boolean boolAdded = true;
        if (this.m_OvertakingSPIT_Messages.size() >= s_MAX_OVERTAKING_SPIT_MESSAGES) {
            boolAdded = false;
            this.printReport("Error", "SPITMessage --- overtaking more than " + s_MAX_OVERTAKING_SPIT_MESSAGES + " messages -> ");
        }
        if ((intMessageNumber = p_SPIT_Message.getHeader().getMessageNumber()) < p_MissedMessageNumber) {
            intMessageNumber += 255;
        }
        for (int intMessage = 0; intMessage < this.m_OvertakingSPIT_Messages.size(); ++intMessage) {
            SPIT_Message o_OvertakingSPIT_Message = this.m_OvertakingSPIT_Messages.get(intMessage);
            int intOvertakingMessageNumber = o_OvertakingSPIT_Message.getHeader().getMessageNumber();
            if (intOvertakingMessageNumber < p_MissedMessageNumber) {
                intOvertakingMessageNumber += 255;
            }
            if (intMessageNumber >= intOvertakingMessageNumber) continue;
            this.m_OvertakingSPIT_Messages.add(intMessage, p_SPIT_Message);
            return true;
        }
        this.m_OvertakingSPIT_Messages.add(p_SPIT_Message);
        return boolAdded;
    }

    public boolean parseSPIT_Message(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return false;
        }
        boolean boolOK = false;
        SPIT_Message.Header o_Header = p_SPIT_Message.getHeader();
        SPIT_Message.OPPart o_OPPart = p_SPIT_Message.getOPPart();
        if (o_Header == null || o_OPPart == null) {
            return false;
        }
        if (s_DEBUGON) {
            this.printReport("           parseSPIT_Message", "SPIT_Message OPFlag:" + p_SPIT_Message.getOPFlag() + " MessageNumber: " + p_SPIT_Message.getMessageNumber());
        }
        if (o_OPPart instanceof SPIT_Message.ConfirmReceived) {
            boolOK = this.parseConfirmReceived((SPIT_Message.ConfirmReceived)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.Disconnect) {
            boolOK = this.parseDisconnect((SPIT_Message.Disconnect)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.Watchdog) {
            boolOK = this.parseWatchdog((SPIT_Message.Watchdog)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.WatchdogAnswer) {
            boolOK = this.parseWatchdogAnswer((SPIT_Message.WatchdogAnswer)o_OPPart);
        }
        if (o_OPPart instanceof SPIT_Message.ReportSPITProject) {
            boolOK = this.parseReportSPITProject((SPIT_Message.ReportSPITProject)o_OPPart);
        }
        if (o_OPPart instanceof SPIT_Message.CloseSPITProject) {
            boolOK = this.parseCloseSPITProject((SPIT_Message.CloseSPITProject)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.RequestProjectTransfer) {
            boolOK = this.parseRequestProjectTransfer((SPIT_Message.RequestProjectTransfer)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.StartProjectTransfer) {
            boolOK = this.parseStartProjectTransfer((SPIT_Message.StartProjectTransfer)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.EndProjectTransfer) {
            boolOK = this.parseEndProjectTransfer((SPIT_Message.EndProjectTransfer)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.ReportSPITType) {
            boolOK = this.parseReportSPITType((SPIT_Message.ReportSPITType)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.RemoveSPITType) {
            boolOK = this.parseRemoveSPITType((SPIT_Message.RemoveSPITType)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.ReportSPITObject) {
            boolOK = this.parseReportSPITObject((SPIT_Message.ReportSPITObject)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.RemoveSPITObject) {
            boolOK = this.parseRemoveSPITObject((SPIT_Message.RemoveSPITObject)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.PlaySPITStart) {
            boolOK = this.parsePlaySPITStart_Remote((SPIT_Message.PlaySPITStart)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.PlaySPITObject) {
            boolOK = this.parsePlaySPITObject_Remote((SPIT_Message.PlaySPITObject)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.PlaySPITEnd) {
            boolOK = this.parsePlaySPITEnd_Remote((SPIT_Message.PlaySPITEnd)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.ReportPlayStatus) {
            boolOK = this.parseReportPlayStatus((SPIT_Message.ReportPlayStatus)o_OPPart);
        }
        SPIT_Message.addEmpty((SPIT_Message)p_SPIT_Message);
        return boolOK;
    }

    private void sleepSend() {
        this.m_JavaTimer.sleep((long)SPITServer.SEND_WAITTIME_MUCHMESSAGES);
    }

    public boolean sendSPIT_Message_ForAllClients(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return false;
        }
        SPIT_Message o_SPIT_Message = SPIT_Message.getSPIT_Message((int)p_SPIT_Message.getOPFlag());
        o_SPIT_Message.setMessageBytes(p_SPIT_Message.getMessageBytes(), p_SPIT_Message.getMessageBytesCount());
        o_SPIT_Message.parse();
        return this.addSPIT_MessageToSend(o_SPIT_Message);
    }

    public boolean sendSPIT_Message(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return false;
        }
        return this.addSPIT_MessageToSend(p_SPIT_Message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSPIT_MessageToSend(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return false;
        }
        Object object = this.m_SyncSpitMessagesToSend;
        synchronized (object) {
            if (this.m_SPIT_MessagesToSend.contains(p_SPIT_Message)) {
                return true;
            }
            this.m_SPIT_MessagesToSend.add(p_SPIT_Message);
        }
        SPIT_ServerInterface o_SPITServerInterface = this.m_SPIT_ServerInterface;
        if (o_SPITServerInterface != null) {
            o_SPITServerInterface.notifySend();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_Message getNextSPIT_MessageToSend() {
        SPIT_ServerInterface o_SPITServerInterface;
        SPIT_Message o_SPIT_Message = null;
        SPIT_Message o_SPIT_Message_Resend = null;
        boolean boolResend = false;
        Object object = this.m_SyncSpitMessagesToSend;
        synchronized (object) {
            if (this.m_ConfirmMessagesAfter > 0) {
                if (this.m_SPIT_MessagesSended.size() >= this.m_ConfirmMessagesAfter) {
                    if (!this.m_WaitForConfirmReceived) {
                        this.m_WaitForConfirmReceived = true;
                        this.m_WaitForConfirmReceived_Start = System.currentTimeMillis();
                    } else if (System.currentTimeMillis() - this.m_WaitForConfirmReceived_Start > 200L) {
                        boolResend = true;
                        this.m_WaitForConfirmReceived = false;
                        this.m_WaitForConfirmReceived_Start = -1L;
                    }
                } else {
                    this.m_WaitForConfirmReceived = false;
                    this.m_WaitForConfirmReceived_Start = -1L;
                    if (this.m_SPIT_MessagesToSend.size() > 0) {
                        o_SPIT_Message = this.m_SPIT_MessagesToSend.get(0);
                    }
                }
            } else if (this.m_SPIT_MessagesToSend.size() > 0) {
                o_SPIT_Message = this.m_SPIT_MessagesToSend.get(0);
            }
        }
        if (boolResend) {
            object = this.m_SyncSpitMessagesToSend;
            synchronized (object) {
                if (this.m_ConfirmMessagesAfter > 0 && this.m_SPIT_MessagesSended.size() >= this.m_ConfirmMessagesAfter) {
                    o_SPIT_Message_Resend = this.m_SPIT_MessagesSended.get(0);
                }
            }
        }
        if (o_SPIT_Message_Resend != null && (o_SPITServerInterface = this.m_SPIT_ServerInterface) != null) {
            o_SPITServerInterface.sendSPIT_Message(o_SPIT_Message_Resend, this.getInetAddress(), this.getPort());
        }
        if (o_SPIT_Message == null) {
            return null;
        }
        object = this.m_SyncMessageNumber;
        synchronized (object) {
            o_SPIT_Message.getHeader().setServerID(this.getServerID());
            o_SPIT_Message.getHeader().setClientID(this.getClientID());
            o_SPIT_Message.getHeader().setMessageNumber((byte)this.m_MessageNumber_Send);
        }
        return o_SPIT_Message;
    }

    public boolean getWaitForConfirmReceive() {
        return this.m_WaitForConfirmReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void successSendSPIT_Message(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return;
        }
        this.m_SPITMessageToSend_Attempts = 0;
        Object object = this.m_SyncSpitMessagesToSend;
        synchronized (object) {
            this.m_SPIT_MessagesToSend.remove(p_SPIT_Message);
        }
        object = this.m_SyncMessageNumber;
        synchronized (object) {
            this.m_MessageNumber_Send = this.m_MessageNumber_Send == 255 ? 1 : ++this.m_MessageNumber_Send;
        }
        if (s_DEBUGON) {
            this.printReport("    SendedMessage", "SPIT_Message OPFlag: " + p_SPIT_Message.getOPFlag() + " MessageNumber: " + p_SPIT_Message.getMessageNumber());
        }
        object = this.m_SyncSpitMessagesToSend;
        synchronized (object) {
            if (this.m_ConfirmMessagesAfter > 0) {
                int intDiff;
                boolean boolAdd = true;
                if (this.m_MessageNumber_Confirmed_Send >= 0 && (intDiff = this.diffMessageNumber(this.m_MessageNumber_Confirmed_Send, p_SPIT_Message.getMessageNumber())) <= 0) {
                    boolAdd = false;
                }
                if (boolAdd) {
                    this.m_SPIT_MessagesSended.add(p_SPIT_Message);
                }
            } else {
                SPIT_Message.addEmpty((SPIT_Message)p_SPIT_Message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorSendSPIT_Message(SPIT_Message p_SPIT_Message, Exception p_Exception) {
        if (p_SPIT_Message == null) {
            return;
        }
        if (p_Exception instanceof SPIT_ClientInterface.Exception_SendSPIT_Message) {
            this.printReport("Fatal Error", "sending SPIT_Message OPFlag: " + p_SPIT_Message.getOPFlag() + p_Exception.getMessage());
            Object object = this.m_SyncSpitMessagesToSend;
            synchronized (object) {
                this.m_SPIT_MessagesToSend.remove(p_SPIT_Message);
                SPIT_Message.addEmpty((SPIT_Message)p_SPIT_Message);
            }
            return;
        }
        ++this.m_SPITMessageToSend_Attempts;
        if (this.m_SPITMessageToSend_Attempts > 10) {
            this.printReport("Fatal Error", "After " + this.m_SPITMessageToSend_Attempts + " attempts, the SPIT_Message OPFlag: " + p_SPIT_Message.getOPFlag() + " could not be sent" + p_Exception.getMessage());
            Object object = this.m_SyncSpitMessagesToSend;
            synchronized (object) {
                this.m_SPIT_MessagesToSend.remove(p_SPIT_Message);
                SPIT_Message.addEmpty((SPIT_Message)p_SPIT_Message);
            }
            this.m_SPITMessageToSend_Attempts = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSPIT_MessagesToSend() {
        Object object = this.m_SyncSpitMessagesToSend;
        synchronized (object) {
            this.m_SPIT_MessagesToSend.clear();
            this.m_SPIT_MessagesSended.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmReceivedSPIT_Message(SPIT_Message.ConfirmReceived p_ConfirmReceived) {
        SPIT_ServerInterface o_SPITServerInterface;
        if (p_ConfirmReceived == null) {
            return;
        }
        SPIT_Message o_SPIT_Message_Resend = null;
        Object object = this.m_SyncSpitMessagesToSend;
        synchronized (object) {
            this.m_MessageNumber_Confirmed_Send = p_ConfirmReceived.getConfirmMessageNumber_Int();
            for (int intMessage = this.m_SPIT_MessagesSended.size() - 1; intMessage >= 0; --intMessage) {
                SPIT_Message o_SPIT_Message = this.m_SPIT_MessagesSended.get(intMessage);
                int intDiff = this.diffMessageNumber(o_SPIT_Message.getMessageNumber(), p_ConfirmReceived.getConfirmMessageNumber_Int());
                if (intDiff < 0) continue;
                this.m_SPIT_MessagesSended.remove(intMessage);
                SPIT_Message.addEmpty((SPIT_Message)o_SPIT_Message);
            }
            if (s_DEBUGON) {
                this.printReport("    confirmReceivedSPIT_Message", "SPIT_Message OPFlag:" + p_ConfirmReceived.getOPFlag() + " confirmed MessageNumber: " + p_ConfirmReceived.getConfirmMessageNumber_Int());
            }
            if (this.m_SPIT_MessagesSended.size() > 0 && p_ConfirmReceived.getMissingMessageNumber_Int() > 0) {
                this.printReport("comment", "Not all sended messages are confirmed there are " + this.m_SPIT_MessagesSended.size() + " left. First not confirmed: " + this.m_SPIT_MessagesSended.get(0).getMessageNumber());
                o_SPIT_Message_Resend = this.m_SPIT_MessagesSended.get(0);
            }
        }
        if (o_SPIT_Message_Resend != null && (o_SPITServerInterface = this.m_SPIT_ServerInterface) != null) {
            this.printReport("comment", "Resend message (OPFlag: (" + o_SPIT_Message_Resend.getOPFlag() + ") MessageNumber: " + o_SPIT_Message_Resend.getMessageNumber());
            o_SPITServerInterface.sendSPIT_Message(o_SPIT_Message_Resend, this.getInetAddress(), this.getPort());
        }
        if ((o_SPITServerInterface = this.m_SPIT_ServerInterface) != null) {
            o_SPITServerInterface.notifySend();
        }
    }

    public boolean parseConfirmReceived(SPIT_Message.ConfirmReceived p_ConfirmReceived) {
        if (p_ConfirmReceived == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.confirmReceivedSPIT_Message(p_ConfirmReceived);
        return true;
    }

    public boolean parseDisconnect(SPIT_Message.Disconnect p_Disconnect) {
        if (p_Disconnect == null) {
            return false;
        }
        this.close();
        return true;
    }

    private boolean parseWatchdog(SPIT_Message.Watchdog p_Watchdog) {
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        SPIT_Message o_SPIT_Message = SPIT_Message.createWatchdogAnswer();
        this.sendSPIT_Message(o_SPIT_Message);
        return true;
    }

    public void startWatchdog() {
        if (this.m_SPIT_Watchdog != null) {
            this.m_SPIT_Watchdog.startWatchdog();
        }
    }

    public void stopWatchdog() {
        if (this.m_SPIT_Watchdog != null) {
            this.m_SPIT_Watchdog.stopWatchdog();
        }
    }

    private boolean parseWatchdogAnswer(SPIT_Message.WatchdogAnswer p_WatchdogAnswer) {
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return true;
    }

    public void watchdogMissed() {
        this.printReport("Error", "Watchdog missed -> will disconnect");
        this.close();
    }

    public void firePropertyChange(String PropertyName, Object p_OldValue, Object p_NewValue) {
        this.m_SinglePropertyChangeSupport.firePropertyChange(PropertyName, p_OldValue, p_NewValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        this.m_SinglePropertyChangeSupport.fireIndexedPropertyChange(this.m_Name, this.m_Port, s_SyncObject, s_SyncObject);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public void printReport(String p_Remark, String p_Message) {
        LocalDateTime o_LocalDateTime = LocalDateTime.now();
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append(o_LocalDateTime.getYear());
        o_StringBuilder.append("_");
        o_StringBuilder.append(o_LocalDateTime.getMonthValue());
        o_StringBuilder.append("_");
        o_StringBuilder.append(o_LocalDateTime.getDayOfMonth());
        o_StringBuilder.append(" ");
        o_StringBuilder.append(o_LocalDateTime.getHour());
        o_StringBuilder.append(":");
        o_StringBuilder.append(o_LocalDateTime.getMinute());
        o_StringBuilder.append(":");
        o_StringBuilder.append(o_LocalDateTime.getSecond());
        o_StringBuilder.append("    ");
        o_StringBuilder.append(p_Remark);
        o_StringBuilder.append(":");
        o_StringBuilder.append(" ");
        if (this.m_SPIT_ServerInterface != null) {
            o_StringBuilder.append("SPITServer: ");
            o_StringBuilder.append(" ");
            o_StringBuilder.append(this.m_SPIT_ServerInterface.getComputerName());
            o_StringBuilder.append(" ");
        }
        o_StringBuilder.append("SPITClient: ");
        o_StringBuilder.append(" ");
        o_StringBuilder.append(this.getClientComputerName());
        o_StringBuilder.append("(");
        o_StringBuilder.append(this.getIPAddress());
        o_StringBuilder.append(")");
        o_StringBuilder.append("    ");
        o_StringBuilder.append(p_Message);
        System.out.println(o_StringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        ArrayList o_SPIT_ClientInterfaces;
        SPIT_ClientInterface o_SPIT_ClientInterface = null;
        Object object = s_SyncObject;
        synchronized (object) {
            o_SPIT_ClientInterfaces = s_SPITClientTableModel.getArrayList();
        }
        for (int intClient = 0; intClient < o_SPIT_ClientInterfaces.size(); ++intClient) {
            o_SPIT_ClientInterface = (SPIT_ClientInterface)o_SPIT_ClientInterfaces.get(intClient);
            if (o_SPIT_ClientInterface == null) continue;
            o_SPIT_ClientInterface.close();
        }
    }

    public static int getSPIT_ClientInterfaceCount() {
        return s_SPITClientTableModel.size();
    }

    public static boolean addSPIT_ClientInterface(SPIT_ClientInterface p_SPIT_ClientInterface) {
        if (p_SPIT_ClientInterface == null) {
            return false;
        }
        SPIT_ClientInterface o_SPIT_ClientInterface = s_SPITClientTableModel.getSPIT_ClientInterface(p_SPIT_ClientInterface.getClientID());
        if (o_SPIT_ClientInterface == null) {
            return s_SPITClientTableModel.addSPIT_ClientInterface(p_SPIT_ClientInterface);
        }
        o_SPIT_ClientInterface.setClientProjectName(p_SPIT_ClientInterface.getClientProjectName());
        return true;
    }

    public static SPIT_ClientInterface getSPIT_ClientInterface(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        return s_SPITClientTableModel.getSPIT_ClientInterface(p_ID);
    }

    public static SPIT_ClientInterface getSPIT_ClientInterface(int p_Index) {
        return s_SPITClientTableModel.getSPIT_ClientInterface(p_Index);
    }

    public static boolean removeSPIT_ClientInterface(SPIT_ClientInterface p_SPIT_ClientInterface) {
        if (p_SPIT_ClientInterface == null) {
            return false;
        }
        return s_SPITClientTableModel.removeSPIT_ClientInterface(p_SPIT_ClientInterface);
    }

    public static boolean checkLogin(String p_LoginName, String p_LoginPassword) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SPIT_ClientInterface getSPIT_ClientInterface(String p_ClientID, InetAddress p_CLientInetAddress, int p_ClientPort) {
        if (p_ClientID == null) {
            return null;
        }
        if (p_CLientInetAddress == null) {
            return null;
        }
        SPIT_ClientInterface o_SPIT_ClientInterface = null;
        Object object = s_SyncObject;
        synchronized (object) {
            for (int intClient = 0; intClient < s_SPITClientTableModel.size(); ++intClient) {
                o_SPIT_ClientInterface = s_SPITClientTableModel.getSPIT_ClientInterface(intClient);
                if (o_SPIT_ClientInterface == null) continue;
                if (!p_ClientID.equals(o_SPIT_ClientInterface.getClientID())) {
                    o_SPIT_ClientInterface = null;
                    continue;
                }
                if (!p_CLientInetAddress.equals(o_SPIT_ClientInterface.getInetAddress())) {
                    o_SPIT_ClientInterface = null;
                    continue;
                }
                if (p_ClientPort == o_SPIT_ClientInterface.getPort()) break;
                o_SPIT_ClientInterface = null;
            }
        }
        return o_SPIT_ClientInterface;
    }

    public static void sendSPIT_Message(SPIT_Message p_SPIT_Message, SPIT_ClientInterface p_ExcludedClient) {
        if (p_SPIT_Message == null) {
            return;
        }
        int intSPIT_ClientInterfaceCount = s_SPITClientTableModel.size();
        for (int intClient = 0; intClient < intSPIT_ClientInterfaceCount; ++intClient) {
            SPIT_ClientInterface o_SPIT_ClientInterface = s_SPITClientTableModel.getSPIT_ClientInterface(intClient);
            if (o_SPIT_ClientInterface == null || o_SPIT_ClientInterface == p_ExcludedClient) continue;
            p_SPIT_Message.getHeader().setServerID(o_SPIT_ClientInterface.getServerID());
            p_SPIT_Message.getHeader().setClientID(o_SPIT_ClientInterface.getClientID());
            o_SPIT_ClientInterface.sendSPIT_Message_ForAllClients(p_SPIT_Message);
        }
        SPIT_Message.addEmpty((SPIT_Message)p_SPIT_Message);
    }

    private boolean parseReportSPITProject(SPIT_Message.ReportSPITProject p_OPPart) {
        if (p_OPPart == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.setClientProjectName(p_OPPart.getProjectName());
        SPIT_Message o_SPIT_Message = SPIT_Message.createRequestProjectTransfer();
        this.sendSPIT_Message(o_SPIT_Message);
        return true;
    }

    public boolean parseCloseSPITProject(SPIT_Message.CloseSPITProject p_CloseSPITProject) {
        if (p_CloseSPITProject == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.setClientProjectName("");
        SPIT_Type.parseCloseProject_Client(this);
        LiveShowSPITObject.parseCloseProject_Client(this);
        return true;
    }

    private boolean parseRequestProjectTransfer(SPIT_Message.RequestProjectTransfer p_Request) {
        if (p_Request == null) {
            return false;
        }
        final SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        Runnable o_Runnable_ProjectTransfer = new Runnable(){

            @Override
            public void run() {
                SPIT_Object_Interface o_SPIT_Object_Interface;
                LiveShowObjectInterface o_LiveShowObjectInterface;
                int intObject;
                SPIT_Type_Interface o_SPIT_Type_Interface;
                int intSPITType;
                SPIT_Message o_SPIT_Message = SPIT_Message.createStartProjectTransfer();
                if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                    return;
                }
                int intCount = SPIT_Type.getSPIT_TypeCount();
                for (intSPITType = 0; intSPITType < intCount; ++intSPITType) {
                    o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(intSPITType);
                    if (o_SPIT_Type_Interface == null) continue;
                    o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_Type_Interface);
                    if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                        return;
                    }
                    if (o_SPIT_Watchdog != null) {
                        o_SPIT_Watchdog.eventWatchdogAnswer();
                    }
                    SPITServer_Client.this.sleepSend();
                }
                LiveShowMediaVIP o_LiveShowMediaVIP = LiveShowMediaSystem.getLiveShowMediaVIP();
                if (o_LiveShowMediaVIP != null) {
                    intCount = o_LiveShowMediaVIP.getLiveShowObjectInterfaceCount();
                    for (intObject = 0; intObject < intCount; ++intObject) {
                        o_LiveShowObjectInterface = o_LiveShowMediaVIP.getLiveShowObjectInterface(intObject);
                        if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof SPIT_Object_Interface)) continue;
                        o_SPIT_Object_Interface = (SPIT_Object_Interface)o_LiveShowObjectInterface;
                        o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_SPIT_Object_Interface);
                        if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                            return;
                        }
                        if (o_SPIT_Watchdog != null) {
                            o_SPIT_Watchdog.eventWatchdogAnswer();
                        }
                        SPITServer_Client.this.sleepSend();
                    }
                }
                intCount = LiveShowMediaSystem.getJingleObjectCount();
                for (intObject = 0; intObject < intCount; ++intObject) {
                    o_LiveShowObjectInterface = LiveShowMediaSystem.getJingleObject(intObject);
                    if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof SPIT_Object_Interface)) continue;
                    o_SPIT_Object_Interface = (SPIT_Object_Interface)o_LiveShowObjectInterface;
                    o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_SPIT_Object_Interface);
                    if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                        return;
                    }
                    if (o_SPIT_Watchdog != null) {
                        o_SPIT_Watchdog.eventWatchdogAnswer();
                    }
                    SPITServer_Client.this.sleepSend();
                }
                intCount = SPITRemote.getRemoteSPIT_TypeCount();
                for (intSPITType = 0; intSPITType < intCount; ++intSPITType) {
                    o_SPIT_Type_Interface = SPITRemote.getRemoteSPIT_Type((int)intSPITType);
                    if (o_SPIT_Type_Interface == null) continue;
                    o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_Type_Interface);
                    if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                        return;
                    }
                    if (o_SPIT_Watchdog != null) {
                        o_SPIT_Watchdog.eventWatchdogAnswer();
                    }
                    SPITServer_Client.this.sleepSend();
                }
                intCount = SPITRemote.getRemoteSPIT_ObjectCount();
                for (int intSPITObject = 0; intSPITObject < intCount; ++intSPITObject) {
                    o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object((int)intSPITObject);
                    if (o_SPIT_Object_Interface == null) continue;
                    o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_SPIT_Object_Interface);
                    if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                        return;
                    }
                    o_SPIT_Message = SPIT_Message.createReportPlayStatus((SPIT_Object_Interface)o_SPIT_Object_Interface);
                    if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                        return;
                    }
                    if (o_SPIT_Watchdog != null) {
                        o_SPIT_Watchdog.eventWatchdogAnswer();
                    }
                    SPITServer_Client.this.sleepSend();
                }
                o_SPIT_Message = SPIT_Message.createEndProjectTransfer();
                if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                    return;
                }
            }
        };
        Thread o_Thread_Sender = new Thread(o_Runnable_ProjectTransfer);
        o_Thread_Sender.start();
        return true;
    }

    private boolean parseStartProjectTransfer(SPIT_Message.StartProjectTransfer p_StartProjectTransfer) {
        if (p_StartProjectTransfer == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.m_SPIT_ClientTransferringProject = true;
        return true;
    }

    private boolean parseEndProjectTransfer(SPIT_Message.EndProjectTransfer p_EndProjectTransfer) {
        if (p_EndProjectTransfer == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.m_SPIT_ClientTransferringProject = false;
        return true;
    }

    private boolean parseReportSPITType(SPIT_Message.ReportSPITType p_ReportSPITType) {
        if (p_ReportSPITType == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return SPIT_Type.parseReportSPITType(p_ReportSPITType, this, this.m_SPIT_ClientTransferringProject);
    }

    private boolean parseRemoveSPITType(SPIT_Message.RemoveSPITType p_RemoveSPITType) {
        if (p_RemoveSPITType == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return SPIT_Type.parseRemoveSPITType(p_RemoveSPITType, this);
    }

    public boolean parseReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
        if (p_ReportSPITObject == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return LiveShowSPITObject.parseReportSPITObject(p_ReportSPITObject, this, this.m_SPIT_ClientTransferringProject);
    }

    public boolean parseRemoveSPITObject(SPIT_Message.RemoveSPITObject p_RemoveSPITObject) {
        if (p_RemoveSPITObject == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return LiveShowSPITObject.parseRemoveSPITObject(p_RemoveSPITObject, this);
    }

    public boolean parsePlaySPITStart_Remote(SPIT_Message.PlaySPITStart p_PlaySPITStart) {
        SPIT_ActionPlayer o_SPIT_ActionPlayer;
        if (p_PlaySPITStart == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        if ((o_SPIT_ActionPlayer = SPIT_ActionPlayer.getSPIT_ActionPlayer((String)p_PlaySPITStart.getPlayerID())) == null) {
            o_SPIT_ActionPlayer = new SPIT_ActionPlayer(p_PlaySPITStart.getPlayerID(), p_PlaySPITStart.getPlayerName(), p_PlaySPITStart.getPlayerType());
            SPIT_ActionPlayer.addSPIT_ActionPlayer((SPIT_ActionPlayer)o_SPIT_ActionPlayer);
        }
        o_SPIT_ActionPlayer.startPlayTransfer((SPIT_ClientInterface)this, p_PlaySPITStart.getPlayerIsRunning(), p_PlaySPITStart.getTime());
        return true;
    }

    public boolean parsePlaySPITObject_Remote(SPIT_Message.PlaySPITObject p_PlaySPITObject) {
        SPIT_ActionPlayer o_SPIT_ActionPlayer;
        if (p_PlaySPITObject == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        if ((o_SPIT_ActionPlayer = SPIT_ActionPlayer.getSPIT_ActionPlayer((String)p_PlaySPITObject.getPlayerID())) == null) {
            return false;
        }
        SPIT_Object_Interface o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object((String)p_PlaySPITObject.getID());
        o_SPIT_ActionPlayer.playObjectTransfer((SPIT_ClientInterface)this, o_SPIT_Object_Interface, p_PlaySPITObject.getPlayPrePosition(), p_PlaySPITObject.getFrameInsideObject(), p_PlaySPITObject.getValue(), p_PlaySPITObject.getValueFlag());
        return true;
    }

    public boolean parsePlaySPITEnd_Remote(SPIT_Message.PlaySPITEnd p_PlaySPITEnd) {
        SPIT_ActionPlayer o_SPIT_ActionPlayer;
        if (p_PlaySPITEnd == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        if ((o_SPIT_ActionPlayer = SPIT_ActionPlayer.getSPIT_ActionPlayer((String)p_PlaySPITEnd.getPlayerID())) == null) {
            return false;
        }
        o_SPIT_ActionPlayer.endPlayTransfer((SPIT_ClientInterface)this);
        return true;
    }

    public boolean parseReportPlayStatus(SPIT_Message.ReportPlayStatus p_ReportPlayStatus) {
        if (p_ReportPlayStatus == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return LiveShowSPITObject.parseReportPlayStatus(p_ReportPlayStatus);
    }
}

