/*
 * Decompiled with CFR 0.152.
 */
package SPITServerPackage;

import OS.OSChecker;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Message;
import SPITRemotePackage.SPITRemote;
import SPITServerPackage.LiveShowSPITObject;
import SPITServerPackage.SPITServer_Client;
import SPITServerPackage.SPIT_ServerInterface;
import SPITServerPackage.SPIT_Type;
import SPITToolsPackage.SinglePropertyChangeSupport;
import ServerAutoDetectPackage.ServerAutoDetect_Server;
import SoundPackage.SoundMixers;
import StartPackage.LiveShowMediaSystem;
import TimerPackage.JavaTimer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.UUID;

public class SPITServer
implements SPIT_ServerInterface {
    public static int SEND_WAITTIME_MUCHMESSAGES = 5;
    public static int SEND_WAITTIME_NORMAL = 1;
    public static String INIFILE_NAME = "LiveShow_SPITServer.ini";
    public static final String INIFILE_FIELDSEPERATOR = "=";
    public static final String INIFILE_REMARK = "//";
    public static String s_ServerID = UUID.randomUUID().toString();
    public static String s_ServerComputerName = "";
    public static String s_ServerName = "liveSHOW";
    public static int s_LocalPort = 15120;
    public static final String SPITSERVER_TASKID = "#spit#";
    public static String SPITSERVER_TASKNAME = "liveShowSPIT";
    public static boolean s_ClosingProject = false;
    public static boolean s_ReportProjectSended = false;
    private DatagramSocket m_DatagramSocket;
    private final Object m_SyncSendMessage = new Object();
    private boolean m_StopServer;
    private Runnable m_Send_Runnable;
    private Thread m_SendThread;
    private Runnable m_RunnableReceive;
    private Thread m_ThreadReceive;
    private JavaTimer m_JavaTimer;
    private static final Object s_SyncServer = new Object();
    private static int s_FramesPerSecond = (int)SoundMixers.DEFAULT_AUDIOFORMAT.getFrameRate();
    private static SinglePropertyChangeSupport s_SinglePropertyChangeSupport = new SinglePropertyChangeSupport(SPITServer.class);
    private boolean m_Closed;
    private final Object m_SyncClose = new Object();
    public static SPITServer s_SelfReference = new SPITServer();
    public static final Object s_SyncWriteIni = new Object();

    public static SinglePropertyChangeSupport getPropertyChangeSupport() {
        return s_SinglePropertyChangeSupport;
    }

    public SPITServer() {
        this.initMembers();
        this.readIni();
        this.initRunnableSend();
        this.initRunnableReceive();
        SPITRemote.setSPIT_ServerInterface((SPIT_ServerInterface)this);
    }

    private void initMembers() {
        this.m_Closed = false;
        this.m_StopServer = true;
        try {
            s_ServerComputerName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            s_ServerComputerName = "";
        }
        this.m_JavaTimer = new JavaTimer();
    }

    public static void close() {
        if (s_SelfReference != null) {
            s_SelfReference.closeInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInstance() {
        Object object = this.m_SyncClose;
        synchronized (object) {
            if (this.m_Closed) {
                return;
            }
            this.m_Closed = true;
        }
        SPITServer_Client.closeAll();
        this.stopServer();
        if (this.m_JavaTimer != null) {
            this.m_JavaTimer.close();
        }
    }

    public String getServerID() {
        return s_ServerID;
    }

    public String getServerName() {
        return s_ServerName;
    }

    public int getServerStepTime() {
        return SPITServer.getFramesPerSecond();
    }

    public String getServerProjectName() {
        return LiveShowMediaSystem.getProjectName();
    }

    private void initRunnableReceive() {
        this.m_RunnableReceive = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] o_BytesReceived = new byte[512];
                DatagramPacket o_DatagramPacket = new DatagramPacket(o_BytesReceived, o_BytesReceived.length);
                while (!SPITServer.this.m_StopServer) {
                    Object object = s_SyncServer;
                    synchronized (object) {
                        if (SPITServer.this.m_DatagramSocket == null || SPITServer.this.m_DatagramSocket.isClosed()) {
                            SPITServer.this.m_StopServer = true;
                            continue;
                        }
                    }
                    try {
                        SPITServer.this.m_DatagramSocket.receive(o_DatagramPacket);
                    }
                    catch (SocketTimeoutException e_SocketTimeoutException) {
                        continue;
                    }
                    catch (Exception e) {
                        SPITServer.this.m_StopServer = true;
                        continue;
                    }
                    SPIT_Message o_SPIT_Message = SPIT_Message.createSPIT_Message((byte[])o_DatagramPacket.getData(), (int)o_DatagramPacket.getLength());
                    if (o_SPIT_Message == null) continue;
                    if (o_SPIT_Message.getHeader() == null) {
                        o_SPIT_Message = null;
                        continue;
                    }
                    if (o_SPIT_Message.getOPPart() == null) {
                        o_SPIT_Message = null;
                        continue;
                    }
                    InetAddress o_ClientInetAddress = o_DatagramPacket.getAddress();
                    int intClientPort = o_DatagramPacket.getPort();
                    SPITServer.this.parseSPIT_Message(o_ClientInetAddress, intClientPort, o_SPIT_Message);
                }
            }
        };
    }

    private boolean parseSPIT_Message(InetAddress p_ClientInetAddress, int p_ClientPort, SPIT_Message p_SPIT_Message) {
        if (p_ClientInetAddress == null) {
            return false;
        }
        if (p_SPIT_Message == null) {
            return false;
        }
        if (this.m_Closed) {
            return false;
        }
        SPIT_Message.OPPart o_OPPart = p_SPIT_Message.getOPPart();
        if (o_OPPart == null) {
            return false;
        }
        SPIT_Message.Header o_Header = p_SPIT_Message.getHeader();
        if (o_Header == null) {
            return false;
        }
        String stringServerID = o_Header.getServerID();
        String stringClientID = o_Header.getClientID();
        SPIT_ClientInterface o_SPIT_ClientInterface = this.getSPIT_ClientInterface(stringClientID, p_ClientInetAddress, p_ClientPort);
        if (o_OPPart instanceof SPIT_Message.Connect) {
            boolean boolSuccess = this.parseConnect((SPIT_Message.Connect)o_OPPart, o_SPIT_ClientInterface, p_ClientInetAddress, p_ClientPort);
            SPIT_Message.addEmpty((SPIT_Message)p_SPIT_Message);
            return boolSuccess;
        }
        if (o_OPPart instanceof SPIT_Message.ConnectConfirm) {
            boolean boolSuccess = this.parseConnectConfirm((SPIT_Message.ConnectConfirm)o_OPPart, o_SPIT_ClientInterface, p_ClientInetAddress, p_ClientPort);
            SPIT_Message.addEmpty((SPIT_Message)p_SPIT_Message);
            return boolSuccess;
        }
        if (o_SPIT_ClientInterface == null) {
            return false;
        }
        o_SPIT_ClientInterface.checkParseSPIT_Message(p_SPIT_Message);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseConnect(SPIT_Message.Connect p_OPPart, SPIT_ClientInterface p_Client, InetAddress p_ClientInetAddress, int p_ClientPort) {
        if (p_OPPart == null) {
            return false;
        }
        SPIT_Message.Header o_Header = p_OPPart.getHeader();
        boolean boolConnectOK = true;
        if (!boolConnectOK) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createConnectAnswer((boolean)boolConnectOK, (String)this.getComputerName(), (String)this.getServerName(), (int)this.getServerStepTime());
            o_SPIT_Message.getHeader().setClientID(p_OPPart.getClientID());
            o_SPIT_Message.getHeader().setServerID(this.getServerID());
            o_SPIT_Message.getHeader().setMessageNumber((byte)0);
            this.sendSPIT_Message(o_SPIT_Message, p_ClientInetAddress, p_ClientPort);
            if (p_Client != null) {
                this.removeSPIT_ClientInterface(p_Client);
                p_Client.close();
            }
            return false;
        }
        if (p_Client == null) {
            p_Client = new SPITServer_Client(this, o_Header.getClientID(), p_OPPart.getClientComputerName(), p_OPPart.getClientName(), p_ClientInetAddress, p_ClientPort, p_OPPart.getServerIP(), p_OPPart.getServerPort());
            ((SPITServer_Client)p_Client).setClientConnectionParams(p_OPPart.getClientID(), p_OPPart.getLoginName(), p_OPPart.getLoginPassword());
            p_Client.resetMessageNumberReceived();
            Object object = s_SyncServer;
            synchronized (object) {
                this.addSPIT_ClientInterface(p_Client);
            }
        } else {
            ((SPITServer_Client)p_Client).setClientConnectionParams(p_OPPart.getClientID(), p_OPPart.getLoginName(), p_OPPart.getLoginPassword());
            p_Client.resetMessageNumberReceived();
        }
        p_Client.printReport("--- Client connected ---", "normal connection");
        SPIT_Message o_SPIT_Message = SPIT_Message.createConnectAnswer((boolean)boolConnectOK, (String)p_Client.getServerComputerName(), (String)p_Client.getServerName(), (int)p_Client.getServerStepTime());
        p_Client.sendSPIT_Message(o_SPIT_Message);
        o_SPIT_Message = SPIT_Message.createReportSPITProject((String)p_Client.getServerProjectName(), (String)p_Client.getServerProjectName(), (int)SPITServer.getFramesPerSecond());
        p_Client.sendSPIT_Message(o_SPIT_Message);
        p_Client.startWatchdog();
        return boolConnectOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseConnectConfirm(SPIT_Message.ConnectConfirm p_OPPart, SPIT_ClientInterface p_Client, InetAddress p_ClientInetAddress, int p_ClientPort) {
        if (p_OPPart == null) {
            return false;
        }
        SPIT_Message.Header o_Header = p_OPPart.getHeader();
        boolean boolConnectOK = true;
        if (!boolConnectOK) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createConnectAnswerConfirm((boolean)boolConnectOK, (String)this.getComputerName(), (String)this.getServerName(), (int)this.getServerStepTime(), (byte)0);
            o_SPIT_Message.getHeader().setClientID(p_OPPart.getClientID());
            o_SPIT_Message.getHeader().setServerID(this.getServerID());
            o_SPIT_Message.getHeader().setMessageNumber((byte)0);
            this.sendSPIT_Message(o_SPIT_Message, p_ClientInetAddress, p_ClientPort);
            if (p_Client != null) {
                this.removeSPIT_ClientInterface(p_Client);
                p_Client.close();
            }
            return false;
        }
        if (p_Client == null) {
            p_Client = new SPITServer_Client(this, o_Header.getClientID(), p_OPPart.getClientComputerName(), p_OPPart.getClientName(), p_ClientInetAddress, p_ClientPort, p_OPPart.getServerIP(), p_OPPart.getServerPort());
            ((SPITServer_Client)p_Client).setClientConnectionParams(p_OPPart.getClientID(), p_OPPart.getLoginName(), p_OPPart.getLoginPassword());
            p_Client.resetMessageNumberReceived();
            p_Client.setConfirmAfter(p_OPPart.getConfirmAfter());
            Object object = s_SyncServer;
            synchronized (object) {
                this.addSPIT_ClientInterface(p_Client);
            }
        } else {
            ((SPITServer_Client)p_Client).setClientConnectionParams(p_OPPart.getClientID(), p_OPPart.getLoginName(), p_OPPart.getLoginPassword());
            p_Client.resetMessageNumberReceived();
            p_Client.setConfirmAfter(p_OPPart.getConfirmAfter());
        }
        if (p_Client.getConfirmAfter() > 0) {
            p_Client.printReport("--- Client connected ---", "confirmed connection");
        } else {
            p_Client.printReport("--- Client connected ---", "normal connection");
        }
        SPIT_Message o_SPIT_Message = SPIT_Message.createConnectAnswerConfirm((boolean)boolConnectOK, (String)p_Client.getServerComputerName(), (String)p_Client.getServerName(), (int)p_Client.getServerStepTime(), (byte)p_Client.getConfirmAfter());
        p_Client.sendSPIT_Message(o_SPIT_Message);
        o_SPIT_Message = SPIT_Message.createReportSPITProject((String)p_Client.getServerProjectName(), (String)p_Client.getServerProjectName(), (int)SPITServer.getFramesPerSecond());
        p_Client.sendSPIT_Message(o_SPIT_Message);
        p_Client.startWatchdog();
        return boolConnectOK;
    }

    public int getSPIT_ClientInterfaceCount() {
        return SPITServer_Client.s_SPITClientTableModel.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSPIT_ClientInterface(SPIT_ClientInterface p_SPIT_ClientInterface) {
        SPIT_ClientInterface o_SPIT_ClientInterface;
        if (p_SPIT_ClientInterface == null) {
            return false;
        }
        boolean boolAdded = false;
        p_SPIT_ClientInterface.setConnected(true);
        Object object = s_SyncServer;
        synchronized (object) {
            o_SPIT_ClientInterface = SPITServer_Client.s_SPITClientTableModel.getSPIT_ClientInterface(p_SPIT_ClientInterface.getClientID());
            if (o_SPIT_ClientInterface == null) {
                boolAdded = SPITServer_Client.s_SPITClientTableModel.addSPIT_ClientInterface(p_SPIT_ClientInterface);
            }
        }
        if (o_SPIT_ClientInterface != null) {
            o_SPIT_ClientInterface.setClientProjectName(p_SPIT_ClientInterface.getClientProjectName());
        }
        if (boolAdded) {
            // empty if block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSPIT_ClientInterface(SPIT_ClientInterface p_SPIT_ClientInterface) {
        if (p_SPIT_ClientInterface == null) {
            return false;
        }
        boolean boolRemoved = false;
        p_SPIT_ClientInterface.setConnected(false);
        Object object = s_SyncServer;
        synchronized (object) {
            SPIT_ClientInterface o_SPIT_ClientInterface = SPITServer_Client.s_SPITClientTableModel.getSPIT_ClientInterface(p_SPIT_ClientInterface.getClientID());
            if (o_SPIT_ClientInterface != null) {
                boolRemoved = SPITServer_Client.s_SPITClientTableModel.removeSPIT_ClientInterface(p_SPIT_ClientInterface);
            }
        }
        if (boolRemoved) {
            // empty if block
        }
        return boolRemoved;
    }

    public SPIT_ClientInterface getSPIT_ClientInterface(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        return SPITServer_Client.s_SPITClientTableModel.getSPIT_ClientInterface(p_Index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_ClientInterface getSPIT_ClientInterface(String p_ClientID, InetAddress p_CLientInetAddress, int p_ClientPort) {
        if (p_ClientID == null) {
            return null;
        }
        if (p_CLientInetAddress == null) {
            return null;
        }
        SPIT_ClientInterface o_SPIT_ClientInterface = null;
        Object object = s_SyncServer;
        synchronized (object) {
            for (int intClient = 0; intClient < SPITServer_Client.s_SPITClientTableModel.size(); ++intClient) {
                o_SPIT_ClientInterface = SPITServer_Client.s_SPITClientTableModel.getSPIT_ClientInterface(intClient);
                if (o_SPIT_ClientInterface == null) continue;
                if (!p_ClientID.equals(o_SPIT_ClientInterface.getClientID())) {
                    o_SPIT_ClientInterface = null;
                    continue;
                }
                if (!p_CLientInetAddress.equals(o_SPIT_ClientInterface.getInetAddress())) {
                    o_SPIT_ClientInterface = null;
                    continue;
                }
                if (p_ClientPort == o_SPIT_ClientInterface.getPort()) break;
                o_SPIT_ClientInterface = null;
            }
        }
        return o_SPIT_ClientInterface;
    }

    public void closeAllSPITServer_Clients() {
        SPIT_ClientInterface o_SPIT_ClientInterface = null;
        for (int intClient = SPITServer_Client.s_SPITClientTableModel.size() - 1; intClient >= 0; --intClient) {
            o_SPIT_ClientInterface = (SPIT_ClientInterface)SPITServer_Client.s_SPITClientTableModel.get(intClient);
            SPITServer_Client.s_SPITClientTableModel.removeElement((Object)o_SPIT_ClientInterface);
            if (o_SPIT_ClientInterface == null) continue;
            o_SPIT_ClientInterface.close();
        }
    }

    public boolean sendedReportProject() {
        return s_ReportProjectSended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySend() {
        Object object = s_SyncServer;
        synchronized (object) {
            s_SyncServer.notifyAll();
        }
    }

    public boolean sendSPIT_Message(SPIT_Message p_SPIT_Message, SPIT_ClientInterface p_ExcludedClient) {
        boolean boolSended = false;
        int intSPIT_ClientInterfaceCount = SPITServer_Client.s_SPITClientTableModel.size();
        for (int intClient = 0; intClient < intSPIT_ClientInterfaceCount; ++intClient) {
            SPIT_ClientInterface o_SPIT_ClientInterface = SPITServer_Client.s_SPITClientTableModel.getSPIT_ClientInterface(intClient);
            if (o_SPIT_ClientInterface == null || o_SPIT_ClientInterface == p_ExcludedClient) continue;
            p_SPIT_Message.getHeader().setServerID(o_SPIT_ClientInterface.getServerID());
            p_SPIT_Message.getHeader().setClientID(o_SPIT_ClientInterface.getClientID());
            if (!o_SPIT_ClientInterface.sendSPIT_Message_ForAllClients(p_SPIT_Message)) continue;
            boolSended = true;
        }
        SPIT_Message.addEmpty((SPIT_Message)p_SPIT_Message);
        return boolSended;
    }

    private void initRunnableSend() {
        this.m_Send_Runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!SPITServer.this.m_StopServer) {
                    Object object = s_SyncServer;
                    synchronized (object) {
                        boolean boolFound = false;
                        boolean boolWaitForConfirmReceive = false;
                        if (SPITServer.this.m_DatagramSocket == null || SPITServer.this.m_DatagramSocket.isClosed()) {
                            break;
                        }
                        if (SPITServer.this.m_StopServer) {
                            // empty if block
                        }
                        SPIT_ClientInterface o_SPITClientInterface = null;
                        for (int intClient = 0; intClient < SPITServer.this.getSPIT_ClientInterfaceCount(); ++intClient) {
                            o_SPITClientInterface = SPITServer.this.getSPIT_ClientInterface(intClient);
                            if (o_SPITClientInterface == null) continue;
                            SPIT_Message o_SPIT_Message = o_SPITClientInterface.getNextSPIT_MessageToSend();
                            if (o_SPITClientInterface.getWaitForConfirmReceive()) {
                                boolWaitForConfirmReceive = true;
                            }
                            if (o_SPIT_Message == null) continue;
                            boolFound = true;
                            Exception o_Exception = SPITServer.this.sendSPIT_Message(o_SPIT_Message, o_SPITClientInterface.getInetAddress(), o_SPITClientInterface.getPort());
                            if (o_Exception == null) {
                                o_SPITClientInterface.successSendSPIT_Message(o_SPIT_Message);
                            } else {
                                o_SPITClientInterface.errorSendSPIT_Message(o_SPIT_Message, o_Exception);
                            }
                            try {
                                if (SPITServer.this.m_JavaTimer == null) continue;
                                SPITServer.this.m_JavaTimer.sleep((long)SEND_WAITTIME_NORMAL);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (SPITServer.this.m_StopServer && !boolFound) {
                            break;
                        }
                        if (!boolFound && !boolWaitForConfirmReceive) {
                            try {
                                s_SyncServer.wait(2000L);
                            }
                            catch (Exception exception) {}
                        } else if (!boolFound && boolWaitForConfirmReceive) {
                            try {
                                s_SyncServer.wait(200L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception sendSPIT_Message(SPIT_Message p_SPIT_Message, InetAddress p_InetAddress, int p_Port) {
        Object o_Exception = null;
        if (p_SPIT_Message == null || p_InetAddress == null) {
            o_Exception = new SPIT_ClientInterface.Exception_SendSPIT_Message("sendSPIT_Message SPIT_Message or InetAddress is null");
            return o_Exception;
        }
        boolean boolSended = true;
        byte[] o_BytesMessage = p_SPIT_Message.getMessageBytes();
        if (o_BytesMessage == null) {
            o_Exception = new SPIT_ClientInterface.Exception_SendSPIT_Message("sendSPIT_Message SPIT_Message has no MessageBytes");
            return o_Exception;
        }
        byte[] o_BytesSend = SPIT_Message.getDataBytes((int)o_BytesMessage.length);
        try {
            System.arraycopy(o_BytesMessage, 0, o_BytesSend, 0, o_BytesMessage.length);
        }
        catch (Exception e) {
            o_Exception = new SPIT_ClientInterface.Exception_SendSPIT_Message("sendSPIT_Message arraycopy MessageBytes to DatagramPacket array: " + e.getMessage());
            return o_Exception;
        }
        DatagramPacket o_DatagramPacket = new DatagramPacket(o_BytesSend, o_BytesSend.length, p_InetAddress, p_Port);
        Object object = s_SyncServer;
        synchronized (object) {
            if (this.m_DatagramSocket == null || this.m_DatagramSocket.isClosed()) {
                o_Exception = new SPIT_ClientInterface.Exception_SendSPIT_Message("sendSPIT_Message DatagramSocket is closed");
                return o_Exception;
            }
            try {
                this.m_DatagramSocket.send(o_DatagramPacket);
            }
            catch (Exception e) {
                o_Exception = e;
            }
        }
        SPIT_Message.addEmpty((byte[])o_BytesSend);
        return o_Exception;
    }

    public static void closeProject() {
        s_ClosingProject = true;
        s_ReportProjectSended = false;
        SPITRemote.parseCloseSPITProject_Server();
        SPIT_Message o_SPIT_Message = SPIT_Message.createCloseSPITProject((String)LiveShowMediaSystem.getLiveShowProjectDescription().getProjectName());
        SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        LiveShowSPITObject.parseCloseProject();
        SPIT_Type.parseCloseProject();
        SPIT_Message.poolClear();
    }

    public static void newProject(boolean p_EmptyProject) {
        if (s_SelfReference != null) {
            s_SelfReference.startServer();
        }
        s_ClosingProject = false;
        LiveShowSPITObject.parseNewProject();
        SPIT_Type.parseNewProject();
        SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITProject((String)LiveShowMediaSystem.getProjectName(), (String)LiveShowMediaSystem.getProjectName(), (int)SPITServer.getFramesPerSecond());
        SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        s_ReportProjectSended = true;
    }

    public static void savedProject() {
        if (s_SelfReference != null) {
            s_SelfReference.startServer();
        }
        s_ClosingProject = false;
        SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITProject((String)LiveShowMediaSystem.getProjectName(), (String)LiveShowMediaSystem.getProjectName(), (int)SPITServer.getFramesPerSecond());
        SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        s_ReportProjectSended = true;
    }

    public static boolean getClosingProject() {
        return s_ClosingProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer() {
        if (!this.m_StopServer) {
            ServerAutoDetect_Server o_ServerAutoDetect_Server = ServerAutoDetect_Server.getServerAutoDetect_Server((String)s_ServerID);
            if (o_ServerAutoDetect_Server != null) {
                o_ServerAutoDetect_Server.setServerProjectName(LiveShowMediaSystem.getProjectName());
            }
            return;
        }
        this.m_StopServer = false;
        Object object = s_SyncServer;
        synchronized (object) {
            try {
                this.m_DatagramSocket = new DatagramSocket(s_LocalPort);
                try {
                    this.m_DatagramSocket.setSendBufferSize(65024);
                    this.m_DatagramSocket.setReceiveBufferSize(65024);
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                this.m_DatagramSocket = null;
                this.m_StopServer = true;
                return;
            }
        }
        this.m_SendThread = new Thread(this.m_Send_Runnable);
        this.m_SendThread.start();
        Thread o_Thread = new Thread(this.m_RunnableReceive);
        o_Thread.start();
        ServerAutoDetect_Server.startServerAutoDetect((String)s_ServerID, (String)SPITSERVER_TASKID, (String)SPITSERVER_TASKNAME, (int)15110, (int)s_LocalPort, null, (String)LiveShowMediaSystem.getProjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        this.m_StopServer = true;
        Object object = s_SyncServer;
        synchronized (object) {
            ServerAutoDetect_Server.stopServerAutoDetect((String)s_ServerID);
        }
        this.closeDatagramSocket();
        this.writeIni();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDatagramSocket() {
        Object object = s_SyncServer;
        synchronized (object) {
            this.m_StopServer = true;
            s_SyncServer.notifyAll();
        }
        try {
            if (this.m_SendThread != null) {
                this.m_SendThread.join(2000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_SendThread = null;
        object = s_SyncServer;
        synchronized (object) {
            try {
                if (this.m_DatagramSocket != null) {
                    this.m_DatagramSocket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_DatagramSocket = null;
        }
    }

    public String getComputerName() {
        return s_ServerComputerName;
    }

    public DatagramSocket getDatagramSocket() {
        return this.m_DatagramSocket;
    }

    public Object getSyncSendMessage() {
        return this.m_SyncSendMessage;
    }

    public boolean readIni() {
        String stringSPITServerAddition = this.getServer_Addition();
        String stringFileName = stringSPITServerAddition != null && stringSPITServerAddition.length() > 0 ? OSChecker.getPathUserHomeConfigDirectory() + "/" + stringSPITServerAddition + "/" + INIFILE_NAME : OSChecker.getPathUserHomeConfigDirectory() + "/" + INIFILE_NAME;
        File o_FileIni = new File(stringFileName);
        if (!o_FileIni.exists()) {
            return false;
        }
        boolean boolIni = false;
        FileReader o_FileReaderIni = null;
        BufferedReader o_BufferedReader = null;
        try {
            o_FileReaderIni = new FileReader(o_FileIni);
            o_BufferedReader = new BufferedReader(o_FileReaderIni);
            String stringLine = o_BufferedReader.readLine();
            while (stringLine != null) {
                String[] stringValuePair = stringLine.split(INIFILE_FIELDSEPERATOR);
                if (stringValuePair == null) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair.length < 2) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair[1].trim().length() > 0) {
                    String stringPropertyName = stringValuePair[0].trim();
                    String stringPropertyValue = stringValuePair[1].trim();
                    if (stringPropertyName.trim().toLowerCase().equals("ServerID".toLowerCase())) {
                        String stringID;
                        s_ServerID = stringID = stringPropertyValue.trim();
                    }
                    if (stringPropertyName.trim().toLowerCase().equals("ServerPort".toLowerCase())) {
                        String stringPort = stringPropertyValue.trim();
                        try {
                            int intPort;
                            s_LocalPort = intPort = Integer.valueOf(stringPort).intValue();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                stringLine = o_BufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (o_BufferedReader != null) {
                o_BufferedReader.close();
            }
            if (o_FileReaderIni != null) {
                o_FileReaderIni.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return boolIni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeIni() {
        Object object = s_SyncWriteIni;
        synchronized (object) {
            File o_FileIni;
            String stringSPITServerAddition = this.getServer_Addition();
            boolean boolOK = true;
            try {
                String stringFileName = stringSPITServerAddition != null && stringSPITServerAddition.length() > 0 ? OSChecker.getPathUserHomeConfigDirectory() + "/" + stringSPITServerAddition + "/" + INIFILE_NAME : OSChecker.getPathUserHomeConfigDirectory() + "/" + INIFILE_NAME;
                o_FileIni = new File(stringFileName);
                if (o_FileIni.exists()) {
                    boolOK = o_FileIni.delete();
                }
                if (!boolOK) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            boolean boolIni = false;
            FileWriter o_FileWriterIni = null;
            BufferedWriter o_BufferedWriter = null;
            try {
                o_FileWriterIni = new FileWriter(o_FileIni);
                o_BufferedWriter = new BufferedWriter(o_FileWriterIni);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append("ServerID");
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append(s_ServerID);
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append("UUID of the SPITServer");
                o_BufferedWriter.append(stringBuilder.toString());
                o_BufferedWriter.newLine();
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append("ServerPort");
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append(s_LocalPort);
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append("port of the SPITServer");
                o_BufferedWriter.append(stringBuilder.toString());
                boolIni = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (o_BufferedWriter != null) {
                    o_BufferedWriter.flush();
                    o_BufferedWriter.close();
                }
                if (o_FileWriterIni != null) {
                    o_FileWriterIni.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return boolIni;
        }
    }

    public String getServer_Addition() {
        return "";
    }

    public void setFramesPerSecond(int p_FramesPerSecond) {
        if (p_FramesPerSecond < 1) {
            p_FramesPerSecond = 1;
        }
        s_FramesPerSecond = p_FramesPerSecond;
    }

    public static int getFramesPerSecond() {
        return s_FramesPerSecond;
    }
}

