/*
 * Decompiled with CFR 0.152.
 */
package SPITServerPackage;

import Icons.IconManager;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectPanel;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITServerPackage.LiveShowSPITObject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.ImageIcon;

public class LiveShowSPITObjectPanel
extends LiveShowObjectPanel {
    public static ImageIcon s_IconCalculateSoundGraphic = IconManager.getImageIcon("Sound_CalculateGraphic.png");
    private static Stroke s_BasicStroke_3Points = new BasicStroke(3.0f);

    public LiveShowSPITObjectPanel(LiveShowSPITObject p_LiveShowObject, boolean p_Resizable) {
        super(p_LiveShowObject, p_Resizable);
        this.initMembers();
        this.checkConfirmedAssigned();
    }

    private void initMembers() {
        this.setDoubleBuffered(false);
        this.setBackground(new Color(255, 100, 0));
        this.setColorOutline(this.m_ColorFill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        Object object = this.m_SyncPainting;
        synchronized (object) {
        }
    }

    private void checkConfirmedAssigned() {
        LiveShowSPITObject o_LiveShowSPITObject = (LiveShowSPITObject)this.m_LiveShowObjectInterface;
        if (o_LiveShowSPITObject == null) {
            this.setFailure(true);
            return;
        }
        if (o_LiveShowSPITObject.getConfirmed() && o_LiveShowSPITObject.getActionAssigned_Global() || o_LiveShowSPITObject.getSPIT_Type() == null) {
            this.setFailure(false);
        } else {
            this.setFailure(true);
        }
    }

    @Override
    public void paintData(Graphics2D p_Graphics2D, int p_ContainerViewWidth, int p_Height, int p_VisibleStartX, int p_VisibleEndX, long p_VisibleStartFrame, long p_VisibleEndFrame, boolean p_RedrawWidth, boolean p_RedrawHeight) {
        if (p_Graphics2D == null) {
            return;
        }
        SPIT_Type_Interface o_SPIT_Type_Interface = null;
        LiveShowSPITObject o_LiveShowSPITObject = null;
        boolean boolConfirmed = false;
        boolean boolActionAssigned = false;
        Stroke oldStroke = p_Graphics2D.getStroke();
        LiveShowObjectInterface o_LiveShowObjectInterface = this.getLiveShowObjectInterface();
        if (o_LiveShowObjectInterface instanceof LiveShowSPITObject && o_LiveShowObjectInterface != null) {
            o_LiveShowSPITObject = (LiveShowSPITObject)o_LiveShowObjectInterface;
            o_SPIT_Type_Interface = o_LiveShowSPITObject.getSPIT_Type();
            boolConfirmed = o_LiveShowSPITObject.getConfirmed();
            boolActionAssigned = o_LiveShowSPITObject.getActionAssigned_Global();
        }
        Color o_Color = this.m_ColorOutline;
        if (o_LiveShowSPITObject != null) {
            int intPosX;
            long longStartFrame;
            p_Graphics2D.setStroke(s_BasicStroke_3Points);
            long longDelay = o_LiveShowSPITObject.getDelay();
            long longDuration = o_LiveShowSPITObject.getDuration();
            if (longDelay > 0L) {
                longStartFrame = longDelay + o_LiveShowSPITObject.getFrameStartOffset();
                intPosX = this.getInsidePositionX(longStartFrame);
                p_Graphics2D.setColor(Color.GREEN);
                p_Graphics2D.drawLine(intPosX, 0, intPosX, this.m_AbsoluteConstraints.height);
            }
            if (longDuration > 0L) {
                longStartFrame = longDelay + longDuration + o_LiveShowSPITObject.getFrameStartOffset();
                intPosX = this.getInsidePositionX(longStartFrame);
                p_Graphics2D.setColor(Color.RED);
                p_Graphics2D.drawLine(intPosX, 0, intPosX, this.m_AbsoluteConstraints.height);
            }
        }
        p_Graphics2D.setStroke(oldStroke);
    }

    @Override
    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        this.setDirty();
        super.eventObjectParameterChanged(p_LiveShowObjectInterface, p_LiveShowObjectDescription);
        this.checkConfirmedAssigned();
        this.repaint();
    }
}

