/*
 * Decompiled with CFR 0.152.
 */
package SPITServerPackage;

import LiveShowObjectPackage.LiveShowObjectDescription;
import SPITLibraryPackage.SPIT_Message;
import SPITLibraryPackage.SPIT_ObjectDescription;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITServerPackage.SPIT_Type;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class LiveShowSPITObjectDescription
extends LiveShowObjectDescription {
    public static final int SOFTWAREVERSION = 2;
    public static int s_PoolSize = 1000;
    public static ArrayList<LiveShowSPITObjectDescription> s_LiveShowSPITObjectDescriptionsPool = new ArrayList(100);
    public static final Object s_SyncPool = new Object();
    private boolean m_Fixed;
    private boolean m_ServerRemote;
    private String m_ServerParams;
    private byte m_ValueUse;
    private String m_Remark;
    private long m_Delay;
    private long m_Duration;
    private boolean m_ActionAssigned;
    private boolean m_Confirmed;
    private final Object m_SyncObject1 = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShowSPITObjectDescription poolGet() {
        LiveShowSPITObjectDescription o_LiveShowDMXObjectDescription;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_LiveShowSPITObjectDescriptionsPool.size() > 0) {
                int intIndex = s_LiveShowSPITObjectDescriptionsPool.size() - 1;
                o_LiveShowDMXObjectDescription = s_LiveShowSPITObjectDescriptionsPool.get(intIndex);
                o_LiveShowDMXObjectDescription.reactivate(true);
                s_LiveShowSPITObjectDescriptionsPool.remove(intIndex);
            } else {
                o_LiveShowDMXObjectDescription = new LiveShowSPITObjectDescription();
            }
        }
        return o_LiveShowDMXObjectDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean poolAddEmpty(LiveShowSPITObjectDescription p_LiveShowDMXObjectDescription) {
        if (p_LiveShowDMXObjectDescription == null) {
            return false;
        }
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_LiveShowSPITObjectDescriptionsPool.size() < s_PoolSize) {
                s_LiveShowSPITObjectDescriptionsPool.add(p_LiveShowDMXObjectDescription);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poolClear() {
        Object object = s_SyncPool;
        synchronized (object) {
            s_LiveShowSPITObjectDescriptionsPool.clear();
        }
    }

    public LiveShowSPITObjectDescription() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_ServerParams = "";
        this.m_ValueUse = 0;
        this.m_Remark = "";
        this.m_Fixed = false;
        this.m_ServerRemote = false;
        this.m_Delay = 0L;
        this.m_Duration = 0L;
        this.m_Confirmed = false;
        this.m_ActionAssigned = false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        super.writeExternal(out);
        out.writeUTF(this.m_ServerParams);
        out.writeByte(this.m_ValueUse);
        out.writeBoolean(this.m_Fixed);
        out.writeBoolean(this.m_ServerRemote);
        out.writeUTF(this.m_Remark);
        out.writeLong(this.m_Delay);
        out.writeLong(this.m_Duration);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        super.readExternal(in);
        this.m_ServerParams = in.readUTF();
        this.m_ValueUse = in.readByte();
        this.m_Fixed = in.readBoolean();
        this.m_ServerRemote = in.readBoolean();
        this.m_Remark = in.readUTF();
        this.m_Delay = in.readLong();
        this.m_Duration = in.readLong();
    }

    @Override
    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        longBytesCount += 4L;
        longBytesCount += super.getDiskSpaceEstimated();
        longBytesCount += 4L;
        longBytesCount += (long)(this.m_ServerParams.length() * 2);
        ++longBytesCount;
        ++longBytesCount;
        ++longBytesCount;
        longBytesCount += 8L;
        return longBytesCount += 8L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean p_Final) {
        super.close(false);
        if (p_Final) {
            Object object = this.m_SyncObject1;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
                if (!LiveShowSPITObjectDescription.poolAddEmpty(this)) {
                    // empty if block
                }
            }
        }
    }

    public boolean setConfirmed(boolean p_Confirmed) {
        if (this.m_Confirmed == p_Confirmed) {
            return false;
        }
        this.m_Confirmed = p_Confirmed;
        return true;
    }

    public boolean getConfirmed() {
        return this.m_Confirmed;
    }

    @Override
    public void reactivate(boolean p_SetToDefault) {
        super.reactivate(p_SetToDefault);
        this.initMembers();
        this.m_FrameLength = LiveShowObjectDescription.DEFAULTFRAMELENGTH;
    }

    public String getServerParams() {
        return this.m_ServerParams;
    }

    public boolean setServerParams(String p_Producer) {
        if (p_Producer == null) {
            return false;
        }
        if (this.m_ServerParams.equals(p_Producer)) {
            return false;
        }
        this.m_ServerParams = p_Producer;
        return true;
    }

    public byte getValueUse() {
        return this.m_ValueUse;
    }

    public boolean setValueUse(byte p_ValueUse) {
        if (this.m_ValueUse == p_ValueUse) {
            return false;
        }
        this.m_ValueUse = p_ValueUse;
        return true;
    }

    public boolean setFixed(boolean p_Fixed) {
        if (this.m_Fixed == p_Fixed) {
            return false;
        }
        this.m_Fixed = p_Fixed;
        return true;
    }

    public boolean getFixed() {
        return this.m_Fixed;
    }

    public boolean setServerRemote(boolean p_IsServerRemote) {
        if (this.m_ServerRemote == p_IsServerRemote) {
            return false;
        }
        this.m_ServerRemote = p_IsServerRemote;
        return true;
    }

    public boolean getServerRemote() {
        return this.m_ServerRemote;
    }

    public boolean setRemark(String p_Remark) {
        boolean boolChanged = false;
        if (p_Remark == null) {
            p_Remark = "";
        }
        if (p_Remark.equals(this.m_Remark)) {
            return boolChanged;
        }
        this.m_Remark = p_Remark;
        boolChanged = true;
        return boolChanged;
    }

    public String getRemark() {
        return this.m_Remark;
    }

    public boolean setDelay(long p_Delay) {
        boolean boolChanged = false;
        if (p_Delay < 0L) {
            p_Delay = 0L;
        }
        if (p_Delay == this.m_Delay) {
            return boolChanged;
        }
        this.m_Delay = p_Delay;
        boolChanged = true;
        return boolChanged;
    }

    public long getDelay() {
        return this.m_Delay;
    }

    public boolean setDuration(long p_Duration) {
        boolean boolChanged = false;
        if (p_Duration < 0L) {
            p_Duration = 0L;
        }
        if (p_Duration == this.m_Duration) {
            return boolChanged;
        }
        this.m_Duration = p_Duration;
        boolChanged = true;
        return boolChanged;
    }

    public long getDuration() {
        return this.m_Duration;
    }

    public boolean setActionAssigned(boolean p_ActionAssigned) {
        boolean boolChanged = false;
        if (p_ActionAssigned == this.m_ActionAssigned) {
            return boolChanged;
        }
        this.m_ActionAssigned = p_ActionAssigned;
        boolChanged = true;
        return boolChanged;
    }

    public boolean getActionAssigned() {
        return this.m_ActionAssigned;
    }

    @Override
    public LiveShowObjectDescription clone(LiveShowObjectDescription p_LiveShowObjectDescription) {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = p_LiveShowObjectDescription == null ? LiveShowSPITObjectDescription.poolGet() : (LiveShowSPITObjectDescription)p_LiveShowObjectDescription;
        super.clone(o_LiveShowSPITObjectDescription);
        o_LiveShowSPITObjectDescription.setServerParams(this.m_ServerParams);
        o_LiveShowSPITObjectDescription.setValueUse(this.m_ValueUse);
        o_LiveShowSPITObjectDescription.setFixed(this.m_Fixed);
        o_LiveShowSPITObjectDescription.setServerRemote(this.m_ServerRemote);
        o_LiveShowSPITObjectDescription.setRemark(this.m_Remark);
        o_LiveShowSPITObjectDescription.setDelay(this.m_Delay);
        o_LiveShowSPITObjectDescription.setDuration(this.m_Duration);
        return o_LiveShowSPITObjectDescription;
    }

    @Override
    public boolean copyFrom(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return false;
        }
        boolean boolChanged = false;
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)p_LiveShowObjectDescription;
        boolChanged = super.copyFrom(o_LiveShowSPITObjectDescription);
        if (this.copySPITObjectParamFrom(o_LiveShowSPITObjectDescription)) {
            boolChanged = true;
        }
        return boolChanged;
    }

    public boolean copySPITObjectParamFrom(LiveShowSPITObjectDescription p_LiveShowSPITObjectDescription) {
        boolean boolChanged = false;
        if (this.setServerParams(p_LiveShowSPITObjectDescription.getServerParams())) {
            boolChanged = true;
        }
        if (this.setValueUse(p_LiveShowSPITObjectDescription.getValueUse())) {
            boolChanged = true;
        }
        if (this.setFixed(p_LiveShowSPITObjectDescription.getFixed())) {
            boolChanged = true;
        }
        if (this.setServerRemote(p_LiveShowSPITObjectDescription.getServerRemote())) {
            boolChanged = true;
        }
        if (this.setRemark(p_LiveShowSPITObjectDescription.getRemark())) {
            boolChanged = true;
        }
        if (this.setDelay(p_LiveShowSPITObjectDescription.getDelay())) {
            boolChanged = true;
        }
        if (this.setDuration(p_LiveShowSPITObjectDescription.getDuration())) {
            boolChanged = true;
        }
        return boolChanged;
    }

    public boolean isEqual(LiveShowSPITObjectDescription p_LiveShowSPITObjectDescription) {
        if (p_LiveShowSPITObjectDescription == null) {
            return false;
        }
        if (!super.isEqual(p_LiveShowSPITObjectDescription)) {
            return false;
        }
        if (!this.m_ServerParams.equals(p_LiveShowSPITObjectDescription.getServerParams())) {
            return false;
        }
        if (this.m_ValueUse != p_LiveShowSPITObjectDescription.getValueUse()) {
            return false;
        }
        if (this.m_Fixed != p_LiveShowSPITObjectDescription.getFixed()) {
            return false;
        }
        if (this.m_ServerRemote != p_LiveShowSPITObjectDescription.getServerRemote()) {
            return false;
        }
        if (!this.m_Remark.equals(p_LiveShowSPITObjectDescription.getRemark())) {
            return false;
        }
        if (this.m_Delay != p_LiveShowSPITObjectDescription.getDelay()) {
            return false;
        }
        return this.m_Duration == p_LiveShowSPITObjectDescription.getDuration();
    }

    public SPIT_ObjectDescription getSPIT_ObjectDescription() {
        SPIT_ObjectDescription o_SPIT_ObjectDescription = new SPIT_ObjectDescription();
        o_SPIT_ObjectDescription.setServerParams(this.getServerParams());
        o_SPIT_ObjectDescription.setValueUse(this.getValueUse());
        o_SPIT_ObjectDescription.setFixed(this.getFixed());
        o_SPIT_ObjectDescription.setServerRemote(this.getServerRemote());
        o_SPIT_ObjectDescription.setRemark(this.getRemark());
        o_SPIT_ObjectDescription.setDelay(this.getDelay());
        o_SPIT_ObjectDescription.setDuration(this.getDuration());
        o_SPIT_ObjectDescription.setFrameStart(this.getFrameStart());
        o_SPIT_ObjectDescription.setFrameLength(this.getFrameLength());
        o_SPIT_ObjectDescription.setFrameFadeInLength(this.getFrameFadeInLength());
        o_SPIT_ObjectDescription.setFrameFadeOutLength(this.getFrameFadeOutLength());
        o_SPIT_ObjectDescription.setName(this.getName());
        o_SPIT_ObjectDescription.setTrack(this.getVIPTrackNumber());
        o_SPIT_ObjectDescription.setSPITTypeID(this.getSourceString());
        o_SPIT_ObjectDescription.setValueFactor((int)(this.getVolumeFactor() * 1000000.0f));
        return o_SPIT_ObjectDescription;
    }

    public boolean copyFromSPIT_ObjectDescription(SPIT_ObjectDescription p_SPIT_ObjectDescription) {
        SPIT_Type_Interface o_SPIT_Type_Interface;
        String stringSourceName;
        if (p_SPIT_ObjectDescription == null) {
            return false;
        }
        boolean boolChanged = false;
        if (this.setServerParams(p_SPIT_ObjectDescription.getServerParams())) {
            boolChanged = true;
        }
        if (this.setValueUse(p_SPIT_ObjectDescription.getValueUse())) {
            boolChanged = true;
        }
        if (this.setFixed(p_SPIT_ObjectDescription.getFixed())) {
            boolChanged = true;
        }
        if (this.setServerRemote(p_SPIT_ObjectDescription.getServerRemote())) {
            boolChanged = true;
        }
        if (this.setRemark(p_SPIT_ObjectDescription.getRemark())) {
            boolChanged = true;
        }
        if (this.setDelay(p_SPIT_ObjectDescription.getDelay())) {
            boolChanged = true;
        }
        if (this.setDuration(p_SPIT_ObjectDescription.getDuration())) {
            boolChanged = true;
        }
        if (this.setFrameStart(p_SPIT_ObjectDescription.getFrameStart())) {
            boolChanged = true;
        }
        if (this.setFrameFadeInLength(p_SPIT_ObjectDescription.getFrameFadeInLength())) {
            boolChanged = true;
        }
        if (this.setFrameFadeOutLength(p_SPIT_ObjectDescription.getFrameFadeOutLength())) {
            boolChanged = true;
        }
        if (this.setFrameLength(p_SPIT_ObjectDescription.getFrameLength())) {
            boolChanged = true;
        }
        if (this.setName(p_SPIT_ObjectDescription.getName())) {
            boolChanged = true;
        }
        if (this.setVIPTrackNumber(p_SPIT_ObjectDescription.getTrack())) {
            boolChanged = true;
        }
        if (this.setSourceString(p_SPIT_ObjectDescription.getSPITTypeID())) {
            boolChanged = true;
        }
        if (this.setVolumeFactor((float)p_SPIT_ObjectDescription.getValueFactor() / 1000000.0f)) {
            boolChanged = true;
        }
        if (this.setSourceName(stringSourceName = (o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(p_SPIT_ObjectDescription.getSPITTypeID())) == null ? "" : o_SPIT_Type_Interface.getName())) {
            boolChanged = true;
        }
        return boolChanged;
    }

    public boolean readReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
        SPIT_Type_Interface o_SPIT_Type_Interface;
        String stringSourceName;
        if (p_ReportSPITObject == null) {
            return false;
        }
        boolean boolChanged = false;
        if (this.setServerParams(p_ReportSPITObject.getServerParams())) {
            boolChanged = true;
        }
        if (this.setValueUse(p_ReportSPITObject.getValueUse())) {
            boolChanged = true;
        }
        if (this.setFixed(p_ReportSPITObject.getFixed())) {
            boolChanged = true;
        }
        if (this.setServerRemote(p_ReportSPITObject.getServerRemote())) {
            boolChanged = true;
        }
        if (this.setRemark(p_ReportSPITObject.getRemark())) {
            boolChanged = true;
        }
        if (this.setDelay(p_ReportSPITObject.getDelay())) {
            boolChanged = true;
        }
        if (this.setDuration(p_ReportSPITObject.getDuration())) {
            boolChanged = true;
        }
        if (this.setFrameStart(p_ReportSPITObject.getFrameStart())) {
            boolChanged = true;
        }
        if (this.setFrameFadeInLength(p_ReportSPITObject.getFrameFadeInLength())) {
            boolChanged = true;
        }
        if (this.setFrameFadeOutLength(p_ReportSPITObject.getFrameFadeOutLength())) {
            boolChanged = true;
        }
        if (this.setFrameLength(p_ReportSPITObject.getFrameLength())) {
            boolChanged = true;
        }
        if (this.setName(p_ReportSPITObject.getName())) {
            boolChanged = true;
        }
        if (this.setVIPTrackNumber(p_ReportSPITObject.getTrack())) {
            boolChanged = true;
        }
        if (this.setSourceString(p_ReportSPITObject.getSPITTypeID())) {
            boolChanged = true;
        }
        if (this.setVolumeFactor((float)p_ReportSPITObject.getValueFactor() / 1000000.0f)) {
            boolChanged = true;
        }
        if (this.setSourceName(stringSourceName = (o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(p_ReportSPITObject.getSPITTypeID())) == null ? "" : o_SPIT_Type_Interface.getName())) {
            boolChanged = true;
        }
        return boolChanged;
    }

    public boolean readReportPlayStatus(SPIT_Message.ReportPlayStatus p_ReportPlayStatus) {
        if (p_ReportPlayStatus == null) {
            return false;
        }
        return false;
    }

    public boolean checkEqualsReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
        if (p_ReportSPITObject == null) {
            return false;
        }
        if (!this.m_ServerParams.equals(p_ReportSPITObject.getServerParams())) {
            return false;
        }
        if (this.m_ValueUse != p_ReportSPITObject.getValueUse()) {
            return false;
        }
        if (this.m_Fixed != p_ReportSPITObject.getFixed()) {
            return false;
        }
        if (this.m_ServerRemote != p_ReportSPITObject.getServerRemote()) {
            return false;
        }
        if (!this.m_Remark.equals(p_ReportSPITObject.getRemark())) {
            return false;
        }
        if (this.m_Delay != p_ReportSPITObject.getDelay()) {
            return false;
        }
        if (this.m_Duration != p_ReportSPITObject.getDuration()) {
            return false;
        }
        if (this.m_FrameStart != p_ReportSPITObject.getFrameStart()) {
            return false;
        }
        if (this.m_FrameFadeInLength != p_ReportSPITObject.getFrameFadeInLength()) {
            return false;
        }
        if (this.m_FrameFadeOutLength != p_ReportSPITObject.getFrameFadeOutLength()) {
            return false;
        }
        if (this.m_FrameLength != p_ReportSPITObject.getFrameLength()) {
            return false;
        }
        if (!this.m_Name.equals(p_ReportSPITObject.getName())) {
            return false;
        }
        if (this.m_VIPTrackNumber != p_ReportSPITObject.getTrack()) {
            return false;
        }
        if (!this.m_SourceString.equals(p_ReportSPITObject.getSPITTypeID())) {
            return false;
        }
        if ((double)Math.abs(this.m_VolumeFactor - (float)p_ReportSPITObject.getValueFactor() / 1000000.0f) > 0.001) {
            return false;
        }
        SPIT_Type_Interface o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(p_ReportSPITObject.getSPITTypeID());
        String stringSourceName = o_SPIT_Type_Interface == null ? "" : o_SPIT_Type_Interface.getName();
        return !(this.m_SourceName != null ? !this.m_SourceName.equals(stringSourceName) : stringSourceName != null);
    }
}

