/*
 * Decompiled with CFR 0.152.
 */
package SPITServerPackage;

import Icons.IconManager;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectPanel;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import MediaVirtualPackage.LiveShowMediaVIP;
import MediaVirtualPackage.MediaParentObject;
import PlayMediaPackage.PlayMedia;
import SPITActionPackage.SPIT_ActionStatus;
import SPITActionPackage.SPIT_Action_Interface;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Message;
import SPITLibraryPackage.SPIT_ObjectDescription;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_TypeDescription;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITRemotePackage.SPITRemote;
import SPITServerPackage.LiveShowSPITObjectDescription;
import SPITServerPackage.LiveShowSPITObjectPanel;
import SPITServerPackage.LiveShowSPITSettingsPanel;
import SPITServerPackage.PlaySPIT;
import SPITServerPackage.SPITServer;
import SPITServerPackage.SPITServer_Client;
import SPITServerPackage.SPIT_Type;
import SPITToolsPackage.SPITObjectConflictModel;
import StartPackage.LiveShowMediaSystem;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;

public class LiveShowSPITObject
extends MediaParentObject
implements SPIT_Object_Interface {
    public static final int SOFTWAREVERSION = 1;
    public static ImageIcon s_Icon = IconManager.getImageIcon("Trigger.png");
    public static LiveShowSPITSettingsPanel s_SPITSettingsPanel = new LiveShowSPITSettingsPanel();
    public static SPITObjectConflictModel s_SPITObjectConflictModel = new SPITObjectConflictModel();
    private LiveShowSPITObject m_SelfReference;
    private boolean m_JustLoadProject;
    private SPIT_Type_Interface m_SPIT_Type_Interface;
    private ArrayList<String> m_SPITServer_ClientIDs;
    private static final Object s_SyncObject = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addSPITObject(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ClientInterface p_SPITServer_Client) {
        if (p_SPIT_Object_Interface == null) {
            return false;
        }
        LiveShowMediaVIP o_LiveShowMediaVIP = LiveShowMediaSystem.getLiveShowMediaVIP();
        if (o_LiveShowMediaVIP == null) {
            return false;
        }
        boolean boolFoundConflict = false;
        if (p_SPIT_Object_Interface.getServerRemote()) {
            if (SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)p_SPIT_Object_Interface)) {
                if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
                    SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)p_SPIT_Object_Interface);
                    SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
                }
                return true;
            }
            return false;
        }
        if (!(p_SPIT_Object_Interface instanceof LiveShowSPITObject)) {
            return false;
        }
        LiveShowSPITObject o_LiveShowSPITObject = (LiveShowSPITObject)p_SPIT_Object_Interface;
        Object object = s_SyncObject;
        synchronized (object) {
            String[] o_ParamStrings = o_LiveShowSPITObject.getAdditonalParams().split(";");
            if (o_ParamStrings.length <= 0) {
                return false;
            }
            if ("vip".equals(o_ParamStrings[0])) {
                int intTrackCount;
                for (int intTrack = intTrackCount = o_LiveShowMediaVIP.getLiveShowVipTrackCount(); intTrack <= o_LiveShowSPITObject.getVIPTrackNumber(); ++intTrack) {
                    o_LiveShowMediaVIP.createLiveShowVipTrack();
                }
                LiveShowVIPTrack o_LiveShowVIPTrack = o_LiveShowMediaVIP.getLiveShowVIPTrack(o_LiveShowSPITObject.getVIPTrackNumber());
                if (o_LiveShowVIPTrack == null) {
                    return false;
                }
                o_LiveShowVIPTrack.addLiveShowObjectInterface(o_LiveShowSPITObject, o_LiveShowSPITObject.getFrameStart());
            } else if ("jingle".equals(o_ParamStrings[0])) {
                LiveShowMediaSystem.createJingle(o_LiveShowSPITObject);
            }
            o_LiveShowSPITObject.setConfirmed(true);
            if (!o_LiveShowSPITObject.getJustLoadProject()) {
                if (s_SPITObjectConflictModel.removeConflict(null, o_LiveShowSPITObject.getID(), true)) {
                    boolFoundConflict = true;
                }
                if (s_SPITObjectConflictModel.removeConflict(null, o_LiveShowSPITObject.getID(), false)) {
                    boolFoundConflict = true;
                }
                if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
                    SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_LiveShowSPITObject);
                    SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
                }
            }
            o_LiveShowSPITObject.setJustLoadProject(false);
        }
        if (boolFoundConflict) {
            LiveShowSPITObject.notifyConflictsChanged();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeSPITObject_ByServer(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return false;
        }
        if (p_SPIT_Object_Interface.getServerRemote()) {
            if (SPITRemote.removeRemoteSPIT_Object((SPIT_Object_Interface)p_SPIT_Object_Interface)) {
                if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
                    SPIT_Message o_SPIT_Message = SPIT_Message.createRemoveSPITObject((String)p_SPIT_Object_Interface.getID());
                    SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
                }
                return true;
            }
            return false;
        }
        if (!(p_SPIT_Object_Interface instanceof LiveShowSPITObject)) {
            return false;
        }
        LiveShowSPITObject o_LiveShowSPITObject = (LiveShowSPITObject)p_SPIT_Object_Interface;
        boolean boolFoundConflict = false;
        if (s_SPITObjectConflictModel.removeConflict(null, o_LiveShowSPITObject.getID(), false)) {
            boolFoundConflict = true;
        }
        if (boolFoundConflict) {
            LiveShowSPITObject.notifyConflictsChanged();
        }
        Object object = s_SyncObject;
        synchronized (object) {
            String[] o_ParamStrings = o_LiveShowSPITObject.getAdditonalParams().split(";");
            if (o_ParamStrings.length <= 0) {
                return false;
            }
            if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
                SPIT_Message o_SPIT_Message = SPIT_Message.createRemoveSPITObject((String)o_LiveShowSPITObject.getID());
                SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
            }
            return true;
        }
    }

    public static boolean removeSPITObject_ByClient(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ClientInterface p_SPITServer_Client) {
        if (p_SPIT_Object_Interface == null) {
            return false;
        }
        boolean boolAllowRemove = true;
        boolean boolFoundConflict = false;
        if (p_SPIT_Object_Interface.getServerRemote()) {
            return false;
        }
        if (!(p_SPIT_Object_Interface instanceof LiveShowSPITObject)) {
            return false;
        }
        LiveShowSPITObject o_LiveShowSPITObject = (LiveShowSPITObject)p_SPIT_Object_Interface;
        LiveShowMediaVIP o_LiveShowMediaVIP = LiveShowMediaSystem.getLiveShowMediaVIP();
        if (o_LiveShowMediaVIP == null) {
            return false;
        }
        SPIT_ClientInterface o_SPIT_Client = p_SPITServer_Client;
        String[] o_ParamStrings = o_LiveShowSPITObject.getAdditonalParams().split(";");
        if (o_ParamStrings.length <= 0) {
            return false;
        }
        int intOwnerCount = o_LiveShowSPITObject.getAssignedSpitServer_ClientCount();
        if (intOwnerCount > 0) {
            for (int intSPIT_Client = 0; intSPIT_Client < intOwnerCount; ++intSPIT_Client) {
                SPIT_ClientInterface o_SPITServer_ClientOwner = SPITServer_Client.getSPIT_ClientInterface(o_LiveShowSPITObject.getAssignedSPITServer_ClientID(intSPIT_Client));
                if (o_LiveShowSPITObject.getFixed() && p_SPITServer_Client != o_SPITServer_ClientOwner) {
                    boolAllowRemove = false;
                } else {
                    if (p_SPITServer_Client == null || p_SPITServer_Client == o_SPITServer_ClientOwner) continue;
                    boolAllowRemove = false;
                }
                break;
            }
        } else if (p_SPITServer_Client != null) {
            boolAllowRemove = false;
        }
        if (!boolAllowRemove) {
            if (p_SPITServer_Client != null) {
                o_LiveShowSPITObject.setConfirmed(true);
                SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_LiveShowSPITObject);
                p_SPITServer_Client.sendSPIT_Message(o_SPIT_Message);
            }
            return false;
        }
        if (s_SPITObjectConflictModel.removeConflict(p_SPITServer_Client.getClientID(), o_LiveShowSPITObject.getID(), true)) {
            boolFoundConflict = true;
        }
        if (boolFoundConflict) {
            LiveShowSPITObject.notifyConflictsChanged();
        }
        if (o_SPIT_Client != null) {
            o_LiveShowSPITObject.removeAssignedSPITServer_ClientID(o_SPIT_Client.getClientID());
        }
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() <= 0) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createRemoveSPITObject((String)o_LiveShowSPITObject.getID());
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
        o_LiveShowSPITObject.close(true);
        return true;
    }

    public static boolean parseReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject, SPITServer_Client p_SPITServer_Client, boolean p_IsTransferringProject) {
        SPIT_Message o_SPIT_Message;
        if (p_ReportSPITObject == null) {
            return false;
        }
        if (p_SPITServer_Client == null) {
            return false;
        }
        boolean boolExists = true;
        if (p_ReportSPITObject.getServerRemote()) {
            return false;
        }
        SPITServer_Client o_SPIT_Client = p_SPITServer_Client;
        if (o_SPIT_Client == null) {
            return false;
        }
        LiveShowMediaVIP o_LiveShowMediaVIP = LiveShowMediaSystem.getLiveShowMediaVIP();
        if (o_LiveShowMediaVIP == null) {
            return false;
        }
        LiveShowSPITObject o_SPIT_Object = LiveShowSPITObject.getSPIT_Object(p_ReportSPITObject.getID());
        if (p_IsTransferringProject) {
            if (o_SPIT_Object == null) {
                s_SPITObjectConflictModel.addConflict(p_SPITServer_Client.getClientID(), null, LiveShowSPITObject.createObjectDescription(p_ReportSPITObject));
                LiveShowSPITObject.notifyConflictsChanged();
                return true;
            }
            boolean boolEqual = true;
            if (o_SPIT_Object.getAssignedSpitServer_ClientCount() <= 0) {
                boolEqual = o_SPIT_Object.checkEqualsReportSPITObject(p_ReportSPITObject);
            }
            if (boolEqual) {
                o_SPIT_Object.setConfirmed(true);
                if (p_ReportSPITObject.getActionAssigned()) {
                    o_SPIT_Object.addAssignedSPITServer_ClientID(o_SPIT_Client.getClientID());
                } else {
                    o_SPIT_Object.removeAssignedSPITServer_ClientID(o_SPIT_Client.getClientID());
                }
                SPIT_Message o_SPIT_Message2 = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_SPIT_Object);
                o_SPIT_Client.sendSPIT_Message(o_SPIT_Message2);
                s_SPITObjectConflictModel.removeConflict(o_SPIT_Client.getClientID(), o_SPIT_Object.getID(), false);
                s_SPITObjectConflictModel.removeConflict(o_SPIT_Client.getClientID(), p_ReportSPITObject.getID(), true);
            } else {
                s_SPITObjectConflictModel.addConflict(o_SPIT_Client.getClientID(), (LiveShowSPITObjectDescription)o_SPIT_Object.getDescription(), LiveShowSPITObject.createObjectDescription(p_ReportSPITObject));
                LiveShowSPITObject.notifyConflictsChanged();
            }
            return true;
        }
        if (o_SPIT_Object == null) {
            return true;
        }
        boolean boolConfirmed = p_ReportSPITObject.getConfirmed();
        o_SPIT_Object.setConfirmed(true);
        if (p_ReportSPITObject.getActionAssigned()) {
            o_SPIT_Object.addAssignedSPITServer_ClientID(o_SPIT_Client.getClientID());
        } else {
            o_SPIT_Object.removeAssignedSPITServer_ClientID(o_SPIT_Client.getClientID());
        }
        if (!boolExists) {
            LiveShowSPITObject.addSPITObject(o_SPIT_Object, p_SPITServer_Client);
        } else if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
            o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_SPIT_Object);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, o_SPIT_Client);
        }
        if (!boolConfirmed) {
            o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_SPIT_Object);
            o_SPIT_Client.sendSPIT_Message(o_SPIT_Message);
        }
        return true;
    }

    public static boolean parseReportPlayStatus(SPIT_Message.ReportPlayStatus p_ReportPlayStatus) {
        return false;
    }

    private static LiveShowSPITObjectDescription createObjectDescription(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = LiveShowSPITObjectDescription.poolGet();
        o_LiveShowSPITObjectDescription.setID(p_ReportSPITObject.getID());
        o_LiveShowSPITObjectDescription.setFixed(p_ReportSPITObject.getFixed());
        o_LiveShowSPITObjectDescription.setServerRemote(p_ReportSPITObject.getServerRemote());
        o_LiveShowSPITObjectDescription.setName(p_ReportSPITObject.getName());
        o_LiveShowSPITObjectDescription.setObjectType(25);
        o_LiveShowSPITObjectDescription.setSourceString(p_ReportSPITObject.getSPITTypeID());
        SPIT_Type_Interface o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(o_LiveShowSPITObjectDescription.getSourceString());
        if (o_SPIT_Type_Interface == null) {
            o_LiveShowSPITObjectDescription.setSourceName("");
        } else {
            o_LiveShowSPITObjectDescription.setSourceName(o_SPIT_Type_Interface.getName());
        }
        o_LiveShowSPITObjectDescription.setEffectSourceString(null);
        o_LiveShowSPITObjectDescription.setEffectParameters(null);
        o_LiveShowSPITObjectDescription.setVIPTrackNumber(p_ReportSPITObject.getTrack());
        o_LiveShowSPITObjectDescription.setFrameStart(p_ReportSPITObject.getFrameStart());
        o_LiveShowSPITObjectDescription.setFrameStartOffset(0L);
        o_LiveShowSPITObjectDescription.setFrameLength(p_ReportSPITObject.getFrameLength());
        o_LiveShowSPITObjectDescription.setFrameFadeInLength(p_ReportSPITObject.getFrameFadeInLength());
        o_LiveShowSPITObjectDescription.setFrameFadeInOffset(0L);
        o_LiveShowSPITObjectDescription.setFrameFadeOutLength(p_ReportSPITObject.getFrameFadeOutLength());
        o_LiveShowSPITObjectDescription.setFrameFadeOutOffset(0L);
        o_LiveShowSPITObjectDescription.setVolumeFactor((float)p_ReportSPITObject.getValueFactor() / 1000000.0f);
        o_LiveShowSPITObjectDescription.setServerParams(p_ReportSPITObject.getServerParams());
        o_LiveShowSPITObjectDescription.setRemark(p_ReportSPITObject.getRemark());
        o_LiveShowSPITObjectDescription.setDelay(p_ReportSPITObject.getDelay());
        o_LiveShowSPITObjectDescription.setDuration(p_ReportSPITObject.getDuration());
        o_LiveShowSPITObjectDescription.setActionAssigned(p_ReportSPITObject.getActionAssigned());
        return o_LiveShowSPITObjectDescription;
    }

    public static boolean checkActionAssignedForeign(SPIT_Type_Interface p_SPIT_Type_Interface, SPITServer_Client p_SPITServer_Client) {
        String o_SPITServer_ClientID;
        int intClient;
        LiveShowSPITObject o_LiveShowSPITObject;
        LiveShowObjectInterface o_LiveShowObjectInterface;
        int intObject;
        if (p_SPIT_Type_Interface == null) {
            return false;
        }
        LiveShowMediaVIP o_LiveShowMediaVIP = LiveShowMediaSystem.getLiveShowMediaVIP();
        if (o_LiveShowMediaVIP == null) {
            return false;
        }
        int intObjectCount = o_LiveShowMediaVIP.getLiveShowObjectInterfaceCount();
        for (intObject = 0; intObject < intObjectCount; ++intObject) {
            o_LiveShowObjectInterface = o_LiveShowMediaVIP.getLiveShowObjectInterface(intObject);
            if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowSPITObject) || p_SPIT_Type_Interface != (o_LiveShowSPITObject = (LiveShowSPITObject)o_LiveShowObjectInterface).getSPIT_Type()) continue;
            if (p_SPITServer_Client == null) {
                if (o_LiveShowSPITObject.getAssignedSpitServer_ClientCount() <= 0) continue;
                return true;
            }
            for (intClient = 0; intClient < o_LiveShowSPITObject.getAssignedSpitServer_ClientCount(); ++intClient) {
                o_SPITServer_ClientID = o_LiveShowSPITObject.getAssignedSPITServer_ClientID(intClient);
                if (o_SPITServer_ClientID == null || o_SPITServer_ClientID.equals(p_SPITServer_Client.getClientID())) continue;
                return true;
            }
        }
        intObjectCount = LiveShowMediaSystem.getJingleObjectCount();
        for (intObject = 0; intObject < intObjectCount; ++intObject) {
            o_LiveShowObjectInterface = LiveShowMediaSystem.getJingleObject(intObject);
            if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowSPITObject) || p_SPIT_Type_Interface != (o_LiveShowSPITObject = (LiveShowSPITObject)o_LiveShowObjectInterface).getSPIT_Type()) continue;
            if (p_SPITServer_Client == null) {
                if (o_LiveShowSPITObject.getAssignedSpitServer_ClientCount() <= 0) continue;
                return true;
            }
            for (intClient = 0; intClient < o_LiveShowSPITObject.getAssignedSpitServer_ClientCount(); ++intClient) {
                o_SPITServer_ClientID = o_LiveShowSPITObject.getAssignedSPITServer_ClientID(intClient);
                if (o_SPITServer_ClientID == null || o_SPITServer_ClientID.equals(p_SPITServer_Client.getClientID())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean parseRemoveSPITObject(SPIT_Message.RemoveSPITObject p_RemoveSPITObject, SPITServer_Client p_SPITServer_Client) {
        if (p_RemoveSPITObject == null) {
            return false;
        }
        if (p_SPITServer_Client == null) {
            return false;
        }
        LiveShowSPITObject o_LiveShowSPITObject = LiveShowSPITObject.getSPIT_Object(p_RemoveSPITObject.getID());
        if (o_LiveShowSPITObject == null) {
            s_SPITObjectConflictModel.removeConflict(p_SPITServer_Client.getClientID(), p_RemoveSPITObject.getID(), true);
            LiveShowSPITObject.notifyConflictsChanged();
        }
        return LiveShowSPITObject.removeSPITObject_ByClient(o_LiveShowSPITObject, p_SPITServer_Client);
    }

    public static void parseCloseProject_Client(SPITServer_Client p_SPITServer_Client) {
        LiveShowObjectInterface o_LiveShowObjectInterface;
        int intObject;
        if (p_SPITServer_Client == null) {
            return;
        }
        LiveShowMediaVIP o_LiveShowMediaVIP = LiveShowMediaSystem.getLiveShowMediaVIP();
        if (o_LiveShowMediaVIP == null) {
            return;
        }
        ArrayList<LiveShowSPITObject> o_SPIT_Objects = new ArrayList<LiveShowSPITObject>();
        for (intObject = o_LiveShowMediaVIP.getLiveShowObjectInterfaceCount() - 1; intObject >= 0; --intObject) {
            o_LiveShowObjectInterface = o_LiveShowMediaVIP.getLiveShowObjectInterface(intObject);
            if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowSPITObject)) continue;
            o_SPIT_Objects.add((LiveShowSPITObject)o_LiveShowObjectInterface);
        }
        for (intObject = 0; intObject <= LiveShowMediaSystem.getJingleObjectCount(); ++intObject) {
            o_LiveShowObjectInterface = LiveShowMediaSystem.getJingleObject(intObject);
            if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowSPITObject)) continue;
            o_SPIT_Objects.add((LiveShowSPITObject)o_LiveShowObjectInterface);
        }
        s_SPITObjectConflictModel.removeConflict(p_SPITServer_Client.getClientID());
        for (int intSPITObject = 0; intSPITObject < o_SPIT_Objects.size(); ++intSPITObject) {
            LiveShowSPITObject o_LiveShowSPITObject = (LiveShowSPITObject)o_SPIT_Objects.get(intSPITObject);
            o_LiveShowSPITObject.removeAssignedSPITServer_ClientID(p_SPITServer_Client.getClientID());
        }
        LiveShowSPITObject.notifyConflictsChanged();
    }

    public static void parseCloseProject() {
        s_SPITObjectConflictModel.clear();
        LiveShowSPITObject.notifyConflictsChanged();
    }

    public static void parseNewProject() {
        s_SPITObjectConflictModel.clear();
        LiveShowSPITObject.notifyConflictsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShowSPITObject getSPIT_Object(String p_SPITObjectID) {
        if (p_SPITObjectID == null) {
            return null;
        }
        LiveShowSPITObject o_LiveShowSPITObject = null;
        LiveShowMediaVIP o_LiveShowMediaVIP = LiveShowMediaSystem.getLiveShowMediaVIP();
        if (o_LiveShowMediaVIP == null) {
            return null;
        }
        Object object = s_SyncObject;
        synchronized (object) {
            LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowMediaVIP.getLiveShowObjectInterface(p_SPITObjectID);
            if (o_LiveShowObjectInterface instanceof LiveShowSPITObject) {
                o_LiveShowSPITObject = (LiveShowSPITObject)o_LiveShowObjectInterface;
            }
            if (o_LiveShowSPITObject == null) {
                o_LiveShowSPITObject = LiveShowMediaSystem.getJingleSPITObject(p_SPITObjectID);
            }
        }
        return o_LiveShowSPITObject;
    }

    public static int getSPIT_ObjectCount(SPIT_Type_Interface p_SPIT_Type_Interface) {
        LiveShowSPITObject o_LiveShowSPITObject;
        LiveShowObjectInterface o_LiveShowObjectInterface;
        int intObject;
        if (p_SPIT_Type_Interface == null) {
            return 0;
        }
        int intFoundObjectCount = 0;
        LiveShowMediaVIP o_LiveShowMediaVIP = LiveShowMediaSystem.getLiveShowMediaVIP();
        if (o_LiveShowMediaVIP == null) {
            return intFoundObjectCount;
        }
        int intObjectCount = o_LiveShowMediaVIP.getLiveShowObjectInterfaceCount();
        for (intObject = 0; intObject < intObjectCount; ++intObject) {
            o_LiveShowObjectInterface = o_LiveShowMediaVIP.getLiveShowObjectInterface(intObject);
            if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowSPITObject) || p_SPIT_Type_Interface != (o_LiveShowSPITObject = (LiveShowSPITObject)o_LiveShowObjectInterface).getSPIT_Type()) continue;
            ++intFoundObjectCount;
        }
        intObjectCount = LiveShowMediaSystem.getJingleObjectCount();
        for (intObject = 0; intObject < intObjectCount; ++intObject) {
            o_LiveShowObjectInterface = LiveShowMediaSystem.getJingleObject(intObject);
            if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowSPITObject) || p_SPIT_Type_Interface != (o_LiveShowSPITObject = (LiveShowSPITObject)o_LiveShowObjectInterface).getSPIT_Type()) continue;
            ++intFoundObjectCount;
        }
        return intFoundObjectCount;
    }

    public static void notifyConflictsChanged() {
        if (SPIT_Type.s_SPITTypeConflictModel.size() > 0) {
            SPITServer.getPropertyChangeSupport().firePropertyChange("conflicts", false, true);
        } else {
            SPITServer.getPropertyChangeSupport().firePropertyChange("conflicts", true, false);
        }
    }

    public static void synchronizeSPITTypes_ClientToServer(int[] p_ObjectConflictIndexes) {
        int intConflict;
        boolean boolConflictsChanged = false;
        if (p_ObjectConflictIndexes == null || p_ObjectConflictIndexes.length <= 0) {
            return;
        }
        LiveShowMediaVIP o_LiveShowMediaVIP = LiveShowMediaSystem.getLiveShowMediaVIP();
        if (o_LiveShowMediaVIP == null) {
            return;
        }
        ArrayList<LiveShowSPITObjectDescription> o_ObjectConflicts_Server = new ArrayList<LiveShowSPITObjectDescription>(p_ObjectConflictIndexes.length);
        ArrayList<LiveShowSPITObjectDescription> o_ObjectConflicts_Client = new ArrayList<LiveShowSPITObjectDescription>(p_ObjectConflictIndexes.length);
        ArrayList<String> o_ObjectConflict_ClientID = new ArrayList<String>(p_ObjectConflictIndexes.length);
        for (intConflict = 0; intConflict < p_ObjectConflictIndexes.length; ++intConflict) {
            o_ObjectConflicts_Server.add(s_SPITObjectConflictModel.getObjectDescription_Server(p_ObjectConflictIndexes[intConflict]));
            o_ObjectConflicts_Client.add(s_SPITObjectConflictModel.getObjectDescription_Client(p_ObjectConflictIndexes[intConflict]));
            o_ObjectConflict_ClientID.add(s_SPITObjectConflictModel.getClientID(p_ObjectConflictIndexes[intConflict]));
        }
        for (intConflict = 0; intConflict < o_ObjectConflicts_Server.size(); ++intConflict) {
            LiveShowObjectInterface o_LiveShowObjectInterface;
            String[] o_ServerParams;
            SPIT_TypeDescription o_SPITypeDescription;
            SPIT_Type_Interface o_SPIT_Type_Interface;
            LiveShowSPITObject o_LiveShowSPITObject;
            SPIT_ClientInterface o_SPITServer_Client = SPITServer_Client.getSPIT_ClientInterface((String)o_ObjectConflict_ClientID.get(intConflict));
            LiveShowSPITObjectDescription o_ObjectDescription_Server = (LiveShowSPITObjectDescription)o_ObjectConflicts_Server.get(intConflict);
            LiveShowSPITObjectDescription o_ObjectDescription_Client = (LiveShowSPITObjectDescription)o_ObjectConflicts_Client.get(intConflict);
            if (o_ObjectDescription_Server == null && o_ObjectDescription_Client == null) continue;
            if (o_ObjectDescription_Client != null && o_ObjectDescription_Server != null) {
                String stringClientID;
                o_LiveShowSPITObject = LiveShowSPITObject.getSPIT_Object(o_ObjectDescription_Server.getID());
                if (o_LiveShowSPITObject == null) continue;
                o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(o_ObjectDescription_Client.getSourceString());
                if (o_SPIT_Type_Interface == null) {
                    o_SPITypeDescription = SPIT_Type.s_SPITTypeConflictModel.getTypeDescription_Client(o_ObjectDescription_Client.getSourceString(), (String)o_ObjectConflict_ClientID.get(intConflict));
                    if (o_SPITypeDescription == null) continue;
                    o_SPIT_Type_Interface = new SPIT_Type();
                    o_SPIT_Type_Interface.copyFromDescription(o_SPITypeDescription);
                    SPIT_Type.addSPIT_Type(o_SPIT_Type_Interface, o_SPITServer_Client);
                }
                o_LiveShowSPITObject.setDescription(o_ObjectDescription_Client);
                if (o_ObjectDescription_Client.getActionAssigned()) {
                    o_LiveShowSPITObject.addAssignedSPITServer_ClientID((String)o_ObjectConflict_ClientID.get(intConflict));
                } else {
                    o_LiveShowSPITObject.removeAssignedSPITServer_ClientID((String)o_ObjectConflict_ClientID.get(intConflict));
                }
                o_LiveShowSPITObject.setConfirmed(true);
                if (o_SPITServer_Client != null && o_SPITServer_Client.isConnected()) {
                    SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_LiveShowSPITObject);
                    o_SPITServer_Client.sendSPIT_Message(o_SPIT_Message);
                }
                if (s_SPITObjectConflictModel.removeConflict(stringClientID = (String)o_ObjectConflict_ClientID.get(intConflict), o_ObjectDescription_Client.getID(), true)) {
                    boolConflictsChanged = true;
                }
                if (!s_SPITObjectConflictModel.removeConflict(stringClientID, o_ObjectDescription_Server.getID(), false)) continue;
                boolConflictsChanged = true;
                continue;
            }
            if (o_ObjectDescription_Client != null) {
                o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(o_ObjectDescription_Client.getSourceString());
                if (o_SPIT_Type_Interface == null) {
                    o_SPITypeDescription = SPIT_Type.s_SPITTypeConflictModel.getTypeDescription_Client(o_ObjectDescription_Client.getSourceString(), (String)o_ObjectConflict_ClientID.get(intConflict));
                    if (o_SPITypeDescription == null) continue;
                    o_SPIT_Type_Interface = new SPIT_Type();
                    o_SPIT_Type_Interface.copyFromDescription(o_SPITypeDescription);
                    SPIT_Type.addSPIT_Type(o_SPIT_Type_Interface, o_SPITServer_Client);
                }
                if ((o_ServerParams = o_ObjectDescription_Client.getServerParams().split(";")).length <= 0) continue;
                if ("vip".equals(o_ServerParams[0])) {
                    o_LiveShowObjectInterface = o_LiveShowMediaVIP.getLiveShowObjectInterface(o_ObjectDescription_Client.getID());
                    if (o_LiveShowObjectInterface != null) continue;
                    o_LiveShowSPITObject = (LiveShowSPITObject)o_LiveShowMediaVIP.createLiveShowObject(o_ObjectDescription_Client);
                    o_LiveShowSPITObject.setDescription(o_ObjectDescription_Client);
                    if (o_ObjectDescription_Client.getActionAssigned()) {
                        o_LiveShowSPITObject.addAssignedSPITServer_ClientID((String)o_ObjectConflict_ClientID.get(intConflict));
                    } else {
                        o_LiveShowSPITObject.removeAssignedSPITServer_ClientID((String)o_ObjectConflict_ClientID.get(intConflict));
                    }
                    LiveShowSPITObject.addSPITObject(o_LiveShowSPITObject, o_SPITServer_Client);
                    continue;
                }
                if (!"jingle".equals(o_ServerParams[0]) || (o_LiveShowObjectInterface = LiveShowMediaSystem.getJingleSPITObject(o_ObjectDescription_Client.getID())) != null) continue;
                o_LiveShowSPITObject = (LiveShowSPITObject)((Object)LiveShowMediaSystem.createJingle(o_ObjectDescription_Client));
                o_LiveShowSPITObject.setDescription(o_ObjectDescription_Client);
                if (o_ObjectDescription_Client.getActionAssigned()) {
                    o_LiveShowSPITObject.addAssignedSPITServer_ClientID((String)o_ObjectConflict_ClientID.get(intConflict));
                } else {
                    o_LiveShowSPITObject.removeAssignedSPITServer_ClientID((String)o_ObjectConflict_ClientID.get(intConflict));
                }
                LiveShowSPITObject.addSPITObject(o_LiveShowSPITObject, o_SPITServer_Client);
                continue;
            }
            if (o_ObjectDescription_Server == null || (o_ServerParams = o_ObjectDescription_Server.getServerParams().split(";")).length <= 0) continue;
            if ("vip".equals(o_ServerParams[0])) {
                o_LiveShowObjectInterface = o_LiveShowMediaVIP.getLiveShowObjectInterface(o_ObjectDescription_Server.getID());
                if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowSPITObject)) continue;
                o_LiveShowSPITObject = (LiveShowSPITObject)o_LiveShowObjectInterface;
                o_LiveShowMediaVIP.removeLiveShowObject(o_LiveShowObjectInterface);
                continue;
            }
            if (!"jingle".equals(o_ServerParams[0]) || (o_LiveShowObjectInterface = LiveShowMediaSystem.getJingleSPITObject(o_ObjectDescription_Server.getID())) == null || !(o_LiveShowObjectInterface instanceof LiveShowSPITObject)) continue;
            o_LiveShowSPITObject = (LiveShowSPITObject)o_LiveShowObjectInterface;
            LiveShowMediaSystem.removeJingleSPIT(o_LiveShowSPITObject);
        }
        if (boolConflictsChanged) {
            LiveShowSPITObject.notifyConflictsChanged();
        }
    }

    public static void synchronizeSPITTypes_ServerToClient(int[] p_ObjectConflictIndexes) {
        int intConflict;
        boolean boolConflictsChanged = false;
        if (p_ObjectConflictIndexes == null || p_ObjectConflictIndexes.length <= 0) {
            return;
        }
        ArrayList<LiveShowSPITObjectDescription> o_ObjectConflicts_Server = new ArrayList<LiveShowSPITObjectDescription>(p_ObjectConflictIndexes.length);
        ArrayList<LiveShowSPITObjectDescription> o_ObjectConflicts_Client = new ArrayList<LiveShowSPITObjectDescription>(p_ObjectConflictIndexes.length);
        ArrayList<String> o_ObjectConlict_CLientID = new ArrayList<String>(p_ObjectConflictIndexes.length);
        for (intConflict = 0; intConflict < p_ObjectConflictIndexes.length; ++intConflict) {
            o_ObjectConflicts_Server.add(s_SPITObjectConflictModel.getObjectDescription_Server(p_ObjectConflictIndexes[intConflict]));
            o_ObjectConflicts_Client.add(s_SPITObjectConflictModel.getObjectDescription_Client(p_ObjectConflictIndexes[intConflict]));
            o_ObjectConlict_CLientID.add(s_SPITObjectConflictModel.getClientID(p_ObjectConflictIndexes[intConflict]));
        }
        for (intConflict = 0; intConflict < o_ObjectConflicts_Server.size(); ++intConflict) {
            SPIT_Message o_SPIT_Message;
            SPIT_Type_Interface o_SPIT_Type_Interface;
            LiveShowSPITObject o_SPIT_Object;
            SPIT_ClientInterface o_SPITServer_Client = SPITServer_Client.getSPIT_ClientInterface((String)o_ObjectConlict_CLientID.get(intConflict));
            if (o_SPITServer_Client == null || !o_SPITServer_Client.isConnected()) continue;
            LiveShowSPITObjectDescription o_ObjectDescription_Server = (LiveShowSPITObjectDescription)o_ObjectConflicts_Server.get(intConflict);
            LiveShowSPITObjectDescription o_ObjectDescription_Client = (LiveShowSPITObjectDescription)o_ObjectConflicts_Client.get(intConflict);
            if (o_ObjectDescription_Server == null && o_ObjectDescription_Client == null) continue;
            if (o_ObjectDescription_Client != null && o_ObjectDescription_Server != null) {
                o_SPIT_Object = LiveShowSPITObject.getSPIT_Object(o_ObjectDescription_Server.getID());
                if (o_SPIT_Object == null || (o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(o_ObjectDescription_Server.getSourceString())) == null) continue;
                o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_Type_Interface);
                o_SPITServer_Client.sendSPIT_Message(o_SPIT_Message);
                o_SPIT_Object.setDescription(o_ObjectDescription_Server);
                if (o_ObjectDescription_Client.getActionAssigned()) {
                    o_SPIT_Object.addAssignedSPITServer_ClientID(o_SPITServer_Client.getClientID());
                } else {
                    o_SPIT_Object.removeAssignedSPITServer_ClientID(o_SPITServer_Client.getClientID());
                }
                o_SPIT_Object.setConfirmed(true);
                o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_SPIT_Object);
                if (!o_SPITServer_Client.sendSPIT_Message(o_SPIT_Message)) continue;
                if (s_SPITObjectConflictModel.removeConflict(o_SPITServer_Client.getClientID(), o_ObjectDescription_Client.getID(), true)) {
                    boolConflictsChanged = true;
                }
                if (!s_SPITObjectConflictModel.removeConflict(o_SPITServer_Client.getClientID(), o_ObjectDescription_Server.getID(), false)) continue;
                boolConflictsChanged = true;
                continue;
            }
            if (o_ObjectDescription_Client != null) {
                o_SPIT_Message = SPIT_Message.createRemoveSPITObject((String)o_ObjectDescription_Client.getID());
                o_SPITServer_Client.sendSPIT_Message(o_SPIT_Message);
                continue;
            }
            if (o_ObjectDescription_Server == null || (o_SPIT_Object = LiveShowSPITObject.getSPIT_Object(o_ObjectDescription_Server.getID())) == null || (o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(o_ObjectDescription_Server.getSourceString())) == null) continue;
            o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_Type_Interface);
            o_SPITServer_Client.sendSPIT_Message(o_SPIT_Message);
            o_SPIT_Object.setConfirmed(true);
            o_SPIT_Object.setDescription(o_ObjectDescription_Server);
            o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_SPIT_Object);
            o_SPITServer_Client.sendSPIT_Message(o_SPIT_Message);
        }
        if (boolConflictsChanged) {
            LiveShowSPITObject.notifyConflictsChanged();
        }
    }

    public LiveShowSPITObject(LiveShowSPITObjectDescription p_LiveShowSPITObjectDescription) {
        super(p_LiveShowSPITObjectDescription);
        this.initMembers();
        this.m_Description.setObjectType(25);
        this.initMembersFurther((LiveShowSPITObjectDescription)this.m_Description);
    }

    private void initMembers() {
        this.m_SelfReference = this;
        this.m_SPIT_Type_Interface = null;
        this.m_SPITServer_ClientIDs = new ArrayList();
        this.m_JustLoadProject = false;
    }

    private void initMembersFurther(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return;
        }
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)p_LiveShowObjectDescription;
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription_Self = (LiveShowSPITObjectDescription)this.m_Description;
        if (o_LiveShowSPITObjectDescription_Self == null) {
            return;
        }
        super.setDescription(o_LiveShowSPITObjectDescription);
        o_LiveShowSPITObjectDescription_Self.setID(o_LiveShowSPITObjectDescription.getID());
        o_LiveShowSPITObjectDescription_Self.setFixed(o_LiveShowSPITObjectDescription.getFixed());
        o_LiveShowSPITObjectDescription_Self.setServerRemote(o_LiveShowSPITObjectDescription.getServerRemote());
        SPIT_Type_Interface o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(o_LiveShowSPITObjectDescription.getSourceString());
        this.setSPIT_Type(o_SPIT_Type_Interface);
        if (o_SPIT_Type_Interface != null) {
            o_LiveShowSPITObjectDescription_Self.setSourceName(o_SPIT_Type_Interface.getName());
        } else {
            o_LiveShowSPITObjectDescription_Self.setSourceName(o_LiveShowSPITObjectDescription.getSourceName());
        }
        o_LiveShowSPITObjectDescription_Self.setRemark(o_LiveShowSPITObjectDescription.getRemark());
        o_LiveShowSPITObjectDescription_Self.setDelay(o_LiveShowSPITObjectDescription.getDelay());
        o_LiveShowSPITObjectDescription_Self.setDuration(o_LiveShowSPITObjectDescription.getDuration());
    }

    @Override
    public void close(boolean p_Finish) {
        super.close(p_Finish);
        if (this.m_SPIT_Type_Interface != null) {
            this.m_SPIT_Type_Interface.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.m_SPIT_Type_Interface = null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public boolean exportExternal(ObjectOutput out, LiveShowProjectDescription p_LiveShowProjectDescription, String p_ReplaceName) throws IOException {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description.clone(null);
        o_LiveShowSPITObjectDescription.writeExternal(out);
        o_LiveShowSPITObjectDescription.close(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAssignedSPITServer_ClientID(String p_SPITServer_ClientID) {
        if (p_SPITServer_ClientID == null) {
            return;
        }
        Object object = s_SyncObject;
        synchronized (object) {
            if (this.m_SPITServer_ClientIDs.contains(p_SPITServer_ClientID)) {
                return;
            }
            this.m_SPITServer_ClientIDs.add(p_SPITServer_ClientID);
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAssignedSPITServer_ClientID(String p_SPITServer_ClientID) {
        if (p_SPITServer_ClientID == null) {
            return;
        }
        Object object = s_SyncObject;
        synchronized (object) {
            if (this.m_SPITServer_ClientIDs.remove(p_SPITServer_ClientID)) {
                this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
            }
        }
    }

    public int getAssignedSpitServer_ClientCount() {
        return this.m_SPITServer_ClientIDs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAssignedSPITServer_ClientID(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = s_SyncObject;
        synchronized (object) {
            if (p_Index >= this.m_SPITServer_ClientIDs.size()) {
                return null;
            }
            return this.m_SPITServer_ClientIDs.get(p_Index);
        }
    }

    public void setAdditonalParams(String p_Producer) {
        if (p_Producer == null) {
            return;
        }
        if (((LiveShowSPITObjectDescription)this.m_Description).setServerParams(p_Producer)) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    public String getAdditonalParams() {
        return ((LiveShowSPITObjectDescription)this.m_Description).getServerParams();
    }

    @Override
    public double getFrameTime() {
        return LiveShowVIP.FRAMETIME;
    }

    @Override
    public long getSourceFrameLength() {
        return -1L;
    }

    public void setSPIT_Action_Interface(SPIT_Action_Interface p_SPIT_Action_Interface, Object p_SPIT_Action_Object) {
    }

    public SPIT_Action_Interface getSPIT_Action_Interface() {
        return null;
    }

    public Object getSPIT_Action_Object() {
        return null;
    }

    public boolean getActionAssigned() {
        return false;
    }

    public SPIT_ActionStatus getSPIT_ActionStatus() {
        return null;
    }

    public void playStarted() {
    }

    public void playAction() {
    }

    public void playEnd() {
    }

    @Override
    public LiveShowObjectPanel createLiveShowObjectPanel(boolean p_Resizable) {
        LiveShowSPITObjectPanel o_LiveShowSPITObjectPanel = new LiveShowSPITObjectPanel(this, p_Resizable);
        return o_LiveShowSPITObjectPanel;
    }

    @Override
    public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        float floatVolumeFactor;
        if (p_Play == null) {
            this.m_IsPlaying = false;
            return null;
        }
        if (p_PlayObject == null) {
            this.m_IsPlaying = false;
            return null;
        }
        if (p_PlayObject.getData() == null) {
            this.m_IsPlaying = false;
            return null;
        }
        boolean boolIsRunning = p_Play.isRunning();
        boolean boolFadeIn = false;
        boolean boolFadeOut = false;
        if (this.m_SPIT_Type_Interface == null) {
            return null;
        }
        PlayMedia.MediaPlayObject o_MediaPlayObject = (PlayMedia.MediaPlayObject)p_PlayObject;
        PlaySPIT.SPITPlayObject o_SPITPlayObject = o_MediaPlayObject.getSPITPlayObject();
        if (o_SPITPlayObject == null) {
            return null;
        }
        LiveShowMediaVIP o_LiveShowMediaVIP = LiveShowMediaSystem.getLiveShowMediaVIP();
        if (o_LiveShowMediaVIP != null && !o_LiveShowMediaVIP.getActive()) {
            return null;
        }
        if (p_LiveShowSceneBridge != null) {
            if (p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart()) && p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart() + this.getFrameLength() - 1L)) {
                if (p_IsPreObject) {
                    return null;
                }
            } else if (p_IsPreObject) {
                if (!p_LiveShowSceneBridge.getPlayPreObject()) {
                    // empty if block
                }
                if (p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart()) && p_PlayObject.getFramePosition() < p_LiveShowSceneBridge.getFrameStart() + p_LiveShowSceneBridge.getFrameLength()) {
                    return null;
                }
                LiveShowSceneBridge o_ExcludedLiveShowSceneBridge = null;
                LiveShowVIP o_LiveShowVIP = p_LiveShowSceneBridge.getLiveShowVIP();
                if (o_LiveShowVIP != null) {
                    o_ExcludedLiveShowSceneBridge = o_LiveShowVIP.getLiveShowSceneBridge_Exluded();
                }
                if (o_ExcludedLiveShowSceneBridge != null && this.getFrameStart() >= o_ExcludedLiveShowSceneBridge.getFrameStart()) {
                    return null;
                }
            } else if (p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart() + this.getFrameLength() - 1L)) {
                return null;
            }
            if (p_IsPreObject) {
                boolFadeOut = true;
            } else {
                boolFadeIn = true;
            }
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        long longFramePosition = p_PlayObject.getFramePosition();
        long longFramesToRead = p_PlayObject.getFramesToRead();
        if (longFramePosition < this.m_Description.getFrameStart()) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            this.m_IsPlaying = false;
            return null;
        }
        if (longFramePosition >= this.m_Description.getFrameStart() + this.getFrameLength()) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            this.m_IsPlaying = false;
            return null;
        }
        this.m_IsPlaying = true;
        boolean boolInside = false;
        double doubleFadeInFactor = 1.0;
        double doubleFadeOutFactor = 0.0;
        double doubleFadeFactor = 1.0;
        long longFramePositionInside = longFramePosition - this.m_Description.getFrameStart();
        if (longFramePositionInside >= 0L && longFramePositionInside < this.getFrameLengthToPlay()) {
            boolInside = true;
        }
        if (boolInside) {
            long longFrameFromEndPosition = this.getFrameLengthToPlay() - longFramePositionInside;
            long longFrameFromStartPosition = longFramePositionInside > this.getFrameLengthToPlay() - this.m_Description.getFrameFadeOutLength() ? this.getFrameLengthToPlay() - this.m_Description.getFrameFadeOutLength() : longFramePositionInside;
            doubleFadeInFactor = 1.0;
            floatVolumeFactor = this.m_Description.getVolumeFactor_Linear();
            if (this.m_Description.getFrameFadeInLength() > 0L && longFrameFromStartPosition < this.m_Description.getFrameFadeInLength()) {
                doubleFadeInFactor = (double)(longFrameFromStartPosition + (longFramesToRead - 1L)) / (double)this.m_Description.getFrameFadeInLength();
                if (doubleFadeInFactor > 1.0) {
                    doubleFadeInFactor = 1.0;
                }
                if (doubleFadeInFactor < 1.0E-4) {
                    doubleFadeInFactor = 0.0;
                }
                boolFadeIn = true;
            }
            doubleFadeOutFactor = 1.0;
            if (this.m_Description.getFrameFadeOutLength() > 0L && longFrameFromEndPosition < this.m_Description.getFrameFadeOutLength()) {
                doubleFadeOutFactor = (double)(longFrameFromEndPosition - (longFramesToRead - 1L)) / (double)this.m_Description.getFrameFadeOutLength();
                if (doubleFadeOutFactor > 1.0) {
                    doubleFadeOutFactor = 1.0;
                }
                if (doubleFadeOutFactor < 1.0E-4) {
                    doubleFadeOutFactor = 0.0;
                }
                boolFadeOut = true;
            }
        } else {
            boolIsRunning = false;
            longFramePositionInside = 0L;
            doubleFadeInFactor = 0.0;
            doubleFadeOutFactor = 0.0;
            doubleFadeFactor = 0.0;
            boolFadeIn = false;
            boolFadeOut = false;
            floatVolumeFactor = 0.0f;
        }
        doubleFadeFactor = doubleFadeInFactor * doubleFadeOutFactor;
        o_MediaPlayObject.setFadeInProgress(doubleFadeInFactor);
        o_MediaPlayObject.setFadeOutProgress(doubleFadeOutFactor);
        o_SPITPlayObject.setPlayObjectStatus(this, p_IsPreObject, longFramePositionInside, floatVolumeFactor, doubleFadeFactor, boolFadeIn, boolFadeOut);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_MediaPlayObject;
    }

    @Override
    public void refreshJumps() {
    }

    @Override
    public String createToolTipText(boolean p_Complete) {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.getDescription();
        SPIT_Type_Interface o_SPIT_Type_Interface = this.m_SPIT_Type_Interface;
        StringBuffer o_StringBuffer = new StringBuffer();
        if (p_Complete) {
            o_StringBuffer.append("<html>");
        }
        o_StringBuffer.append("<center>");
        if (o_SPIT_Type_Interface != null) {
            o_StringBuffer.append("TriggerObject");
        }
        if (o_LiveShowSPITObjectDescription.getRemark().length() > 0) {
            o_StringBuffer.append("<br>");
            o_StringBuffer.append(o_LiveShowSPITObjectDescription.getRemark());
        }
        o_StringBuffer.append("</center>");
        o_StringBuffer.append("<br>");
        o_StringBuffer.append(super.createToolTipText(false));
        if (p_Complete) {
            o_StringBuffer.append("</html>");
        }
        return o_StringBuffer.toString();
    }

    @Override
    public String getSourceAdditionalInfo() {
        return null;
    }

    @Override
    public void setSource(Object p_SourceObject) {
        if (p_SourceObject instanceof SPIT_Type) {
            this.setSPIT_Type((SPIT_Type)p_SourceObject);
        }
    }

    @Override
    public Object getSource() {
        return this.m_SPIT_Type_Interface;
    }

    public boolean setSPIT_Type(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return false;
        }
        if (p_SPIT_Type_Interface == this.m_SPIT_Type_Interface) {
            return false;
        }
        if (this.m_SPIT_Type_Interface != null) {
            this.m_SPIT_Type_Interface.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.m_SPIT_Type_Interface = p_SPIT_Type_Interface;
        if (this.m_SPIT_Type_Interface != null) {
            LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description;
            o_LiveShowSPITObjectDescription.setSourceString(this.m_SPIT_Type_Interface.getID());
            o_LiveShowSPITObjectDescription.setSourceName(this.m_SPIT_Type_Interface.getName());
            o_LiveShowSPITObjectDescription.setServerRemote(this.m_SPIT_Type_Interface.getServerRemote());
            this.m_SPIT_Type_Interface.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.m_ChangedSinceLastAction = true;
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        return true;
    }

    public SPIT_Type_Interface getSPIT_Type() {
        return this.m_SPIT_Type_Interface;
    }

    public void changeSPIT_Type(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return;
        }
        if (p_SPIT_Type_Interface == this.m_SPIT_Type_Interface) {
            return;
        }
        this.setSPIT_Type(p_SPIT_Type_Interface);
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0 && this.m_SPIT_Type_Interface != null) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)this);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
    }

    @Override
    public LiveShowObjectInterface.EffectPanel getEffectPanel() {
        return s_SPITSettingsPanel;
    }

    public void changeDelay(long p_Delay) {
        if (p_Delay < 0L) {
            p_Delay = 0L;
        }
        if (this.getDelay() == p_Delay) {
            return;
        }
        this.setDelay(p_Delay);
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0 && this.m_SPIT_Type_Interface != null) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)this);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
    }

    public void setDelay(long p_Delay) {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription;
        if (p_Delay < 0L) {
            p_Delay = 0L;
        }
        if ((o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description).setDelay(p_Delay)) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    public long getDelay() {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description;
        return o_LiveShowSPITObjectDescription.getDelay();
    }

    public void changeDuration(long p_Duration) {
        if (p_Duration < 0L) {
            p_Duration = 0L;
        }
        if (this.getDuration() == p_Duration) {
            return;
        }
        this.setDuration(p_Duration);
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0 && this.m_SPIT_Type_Interface != null) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)this);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
    }

    public void setDuration(long p_Duration) {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription;
        if (p_Duration < 0L) {
            p_Duration = 0L;
        }
        if ((o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description).setDuration(p_Duration)) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    public long getDuration() {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description;
        return o_LiveShowSPITObjectDescription.getDuration();
    }

    public boolean getActionAssigned_Global() {
        return this.m_SPITServer_ClientIDs.size() > 0;
    }

    public void changeRemark(String p_Remark) {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription;
        if (p_Remark == null) {
            p_Remark = "";
        }
        if (p_Remark.equals((o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description).getRemark())) {
            return;
        }
        this.setRemark(p_Remark);
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0 && this.m_SPIT_Type_Interface != null) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)this);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
    }

    public void setRemark(String p_Remark) {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription;
        if (p_Remark == null) {
            p_Remark = "";
        }
        if ((o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description).setRemark(p_Remark)) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    public String getRemark() {
        return ((LiveShowSPITObjectDescription)this.m_Description).getRemark();
    }

    public String getSourceString() {
        return ((LiveShowSPITObjectDescription)this.m_Description).getSourceString();
    }

    public boolean getJustLoadProject() {
        return this.m_JustLoadProject;
    }

    public void setJustLoadProject(boolean p_JustLoaded) {
        this.m_JustLoadProject = p_JustLoaded;
    }

    public void setConfirmed(boolean p_Confirmed) {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description;
        boolean boolChanged = o_LiveShowSPITObjectDescription.setConfirmed(p_Confirmed);
        if (boolChanged) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    public boolean getConfirmed() {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description;
        return o_LiveShowSPITObjectDescription.getConfirmed();
    }

    public void setFixed(boolean p_Fixed) {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description;
        boolean boolChanged = o_LiveShowSPITObjectDescription.setFixed(p_Fixed);
        if (boolChanged) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    public boolean getFixed() {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description;
        return o_LiveShowSPITObjectDescription.getFixed();
    }

    public void setServerRemote(boolean p_IsRemote) {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description;
        boolean boolChanged = o_LiveShowSPITObjectDescription.setServerRemote(p_IsRemote);
        if (boolChanged) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    public boolean getServerRemote() {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description;
        return o_LiveShowSPITObjectDescription.getServerRemote();
    }

    public void setDescription(LiveShowSPITObjectDescription p_LiveShowObjectDescription) {
        this.initMembersFurther(p_LiveShowObjectDescription);
    }

    @Override
    public ImageIcon getImageIcon() {
        return s_Icon;
    }

    @Override
    public ComboBoxModel getSourceListModel() {
        return null;
    }

    @Override
    public boolean getSourceIsReplaceable() {
        return true;
    }

    @Override
    public DefaultListCellRenderer getSourceListRenderer() {
        return null;
    }

    @Override
    public boolean getFrameOffsetAbility() {
        return false;
    }

    @Override
    public LiveShowVIP getLiveShowVIP() {
        return LiveShowMediaSystem.getLiveShowMediaVIP();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SPIT_Type_Interface) {
            SPIT_Type o_SPIT_Type_Interface = (SPIT_Type)evt.getSource();
            if ("paramchanged".equals(evt.getPropertyName())) {
                this.setSourceName(o_SPIT_Type_Interface.getName());
                this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
            } else if ("closed".equals(evt.getPropertyName())) {
                this.close(true);
            }
        }
        if (evt.getSource() instanceof SPITServer_Client) {
            SPITServer_Client o_SPITServer_Client = (SPITServer_Client)evt.getSource();
            if ("clientClosed".equals(evt.getPropertyName())) {
                // empty if block
            }
        }
        if ("name".equals(evt.getPropertyName())) {
            this.setName((String)evt.getNewValue());
        } else if ("sourceName".equals(evt.getPropertyName())) {
            this.setSourceName((String)evt.getNewValue());
        } else if ("liveShowObject_SourceClose".equals(evt.getPropertyName())) {
            this.close(true);
        }
    }

    @Override
    public void setObjectParams(long p_StartFramePosition, long p_FrameStartOffset, long p_FrameLength, long p_FrameFadeInLength, long p_FrameFadeInOffset, long p_FrameFadeOutLength, long p_FrameFadeOutOffset, float p_VolumeFactor) {
        if (this.getFrameStartOffset() != p_FrameStartOffset || this.getFrameLength() != p_FrameLength) {
            // empty if block
        }
        super.setObjectParams(p_StartFramePosition, p_FrameStartOffset, p_FrameLength, p_FrameFadeInLength, p_FrameFadeInOffset, p_FrameFadeOutLength, p_FrameFadeOutOffset, p_VolumeFactor);
    }

    @Override
    public void notifyObjectListeners_ObjectParameterChanged(LiveShowObjectDescription p_LiveShowObjectDescription) {
        super.notifyObjectListeners_ObjectParameterChanged(p_LiveShowObjectDescription);
    }

    @Override
    public void eventEndOfAction(LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
        if (this.m_ChangedSinceLastAction) {
            super.eventEndOfAction(p_ActorLiveShowVIP, p_Success, p_Action);
            LiveShowSPITObjectDescription o_SPITObjectDescription = (LiveShowSPITObjectDescription)this.getDescription();
            if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0 && this.m_SPIT_Type_Interface != null) {
                SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)this);
                SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
            }
        }
    }

    public void setSPITTypeID(String p_SourceString) {
        ((LiveShowSPITObjectDescription)this.m_Description).setSourceString(p_SourceString);
    }

    public String getSPITTypeID() {
        return this.getSourceString();
    }

    public void changeServerParams(String p_Params) {
        if (p_Params == null) {
            return;
        }
        this.setServerParams(p_Params);
        if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0 && this.m_SPIT_Type_Interface != null) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)this);
            SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        }
    }

    public void setServerParams(String p_Params) {
        this.setAdditonalParams(p_Params);
    }

    public String getServerParams() {
        return this.getAdditonalParams();
    }

    public void setValueFactor(int p_ValueFactor) {
        this.setVolumeFactor((float)p_ValueFactor / 1000000.0f, false);
    }

    public int getValueFactor() {
        return (int)(this.getVolumeFactor() * 1000000.0f);
    }

    public void setValueUse(byte p_ValueUse) {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description;
        boolean boolChanged = o_LiveShowSPITObjectDescription.setValueUse(p_ValueUse);
        if (boolChanged) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    public byte getValueUse() {
        LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)this.m_Description;
        return o_LiveShowSPITObjectDescription.getValueUse();
    }

    public void setTrack(int p_VIPTrackNumber) {
        this.setVIPTrackNumber(p_VIPTrackNumber);
    }

    public int getTrack() {
        return this.getVIPTrackNumber();
    }

    public boolean copyFromSPIT_ObjectDescription(SPIT_ObjectDescription p_SPIT_ObjectDescription) {
        if (((LiveShowSPITObjectDescription)this.m_Description).copyFromSPIT_ObjectDescription(p_SPIT_ObjectDescription)) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
            return true;
        }
        return false;
    }

    public boolean readReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
        if (((LiveShowSPITObjectDescription)this.m_Description).readReportSPITObject(p_ReportSPITObject)) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
            return true;
        }
        return false;
    }

    public boolean readReportPlayStatus(SPIT_Message.ReportPlayStatus p_ReportPlayStatus) {
        if (((LiveShowSPITObjectDescription)this.m_Description).readReportPlayStatus(p_ReportPlayStatus)) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
            return true;
        }
        return false;
    }

    public boolean checkEqualsReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
        return ((LiveShowSPITObjectDescription)this.m_Description).checkEqualsReportSPITObject(p_ReportSPITObject);
    }

    public SPIT_ObjectDescription getSPIT_ObjectDescription() {
        return ((LiveShowSPITObjectDescription)this.m_Description).getSPIT_ObjectDescription();
    }

    public void close() {
        this.close(true);
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
    }

    public void setPlayValue(int p_PlayValue) {
    }
}

