/*
 * Decompiled with CFR 0.152.
 */
package PlayMediaPackage;

import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayListener;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowVIP;
import MediaObjectPackage.MediaObject_PlayStatus;
import MediaPackage.MediaServer;
import MediaVirtualPackage.LiveShowMediaObject;
import OS.OSChecker;
import SPITServerPackage.PlaySPIT;
import StartPackage.LiveShowMediaSystem;
import TimerPackage.JavaTimer;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.UUID;

public class PlayMedia
extends Play
implements Runnable {
    public static final String INIFILE_NAME = OSChecker.getPathUserHomeConfigDirectory() + "/PlayMedia.ini";
    public static final String INIFILE_FIELDSEPERATOR = "=";
    public static int BUFFER_MILLISECONDS = 40;
    public static int NEW_BUFFER_MILLISECONDS = 40;
    public static boolean USESINIFILE = PlayMedia.readIni();
    public static double s_MainTransparency;
    public static double s_MainSoundVolume;
    private String m_ID;
    private String m_ProducerName;
    private long m_FramesToReadTime;
    private long m_FramesToReadDefault;
    private MediaPlayObject m_MediaPlayObject;
    private long m_FramePositionToWrite;
    private PlaySPIT m_PlaySPIT;
    JavaTimer m_JavaTimer;
    private final Object m_SyncPlayWait = new Object();
    private static boolean s_ReadIniActive;
    public static final Object s_SyncWriteIni;

    public static int getNewBufferMilliseconds() {
        return NEW_BUFFER_MILLISECONDS;
    }

    public static void setNewBufferMilliseconds(int p_Milliseconds) {
        NEW_BUFFER_MILLISECONDS = p_Milliseconds;
    }

    public static boolean readIni() {
        File o_FileIni = new File(INIFILE_NAME);
        if (!o_FileIni.exists()) {
            return false;
        }
        s_ReadIniActive = true;
        boolean boolIni = false;
        FileReader o_FileReaderIni = null;
        BufferedReader o_BufferedReader = null;
        try {
            o_FileReaderIni = new FileReader(o_FileIni);
            o_BufferedReader = new BufferedReader(o_FileReaderIni);
            String stringLine = o_BufferedReader.readLine();
            while (stringLine != null) {
                String[] stringValuePair = stringLine.split(INIFILE_FIELDSEPERATOR);
                if (stringValuePair == null) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair.length < 2) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair[1].trim().length() > 0) {
                    String stringPropertyName = stringValuePair[0].trim();
                    String stringPropertyValue = stringValuePair[1].trim();
                    if (stringPropertyName.trim().equals("MediaPlayBuffer_ms")) {
                        int intValue = Integer.valueOf(stringPropertyValue.trim());
                        if (intValue > 10 && intValue <= 1000) {
                            BUFFER_MILLISECONDS = intValue;
                            NEW_BUFFER_MILLISECONDS = intValue;
                        }
                        boolIni = true;
                    } else if (stringPropertyName.trim().equals("LastMediaOpenPath")) {
                        File o_FileLastPath = new File(stringPropertyValue);
                        if (!o_FileLastPath.exists()) {
                            o_FileLastPath = null;
                        }
                        LiveShowMediaSystem.s_LastOpenFilePath = o_FileLastPath;
                        boolIni = true;
                    }
                }
                stringLine = o_BufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (o_BufferedReader != null) {
                o_BufferedReader.close();
            }
            if (o_FileReaderIni != null) {
                o_FileReaderIni.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        s_ReadIniActive = false;
        return boolIni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeIni() {
        if (s_ReadIniActive) {
            return false;
        }
        Object object = s_SyncWriteIni;
        synchronized (object) {
            File o_FileIni;
            boolean boolOK = true;
            try {
                o_FileIni = new File(INIFILE_NAME);
                if (o_FileIni.exists()) {
                    boolOK = o_FileIni.delete();
                }
                if (!boolOK) {
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println("ERROR PlayMedia writeIni() - delete ini file:");
                e.printStackTrace();
                return false;
            }
            boolean boolIni = false;
            FileWriter o_FileWriterIni = null;
            BufferedWriter o_BufferedWriter = null;
            try {
                o_FileWriterIni = new FileWriter(o_FileIni);
                o_BufferedWriter = new BufferedWriter(o_FileWriterIni);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append("MediaPlayBuffer_ms");
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append(NEW_BUFFER_MILLISECONDS);
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append("time in milliseconds media commands will be sended (default 40, for older hardware try 80)");
                o_BufferedWriter.append(stringBuilder.toString());
                o_BufferedWriter.newLine();
                String stringLastPath = null;
                File o_LastFile = LiveShowMediaSystem.s_LastOpenFilePath;
                if (o_LastFile != null) {
                    try {
                        stringLastPath = o_LastFile.getAbsolutePath();
                    }
                    catch (Exception e) {
                        stringLastPath = null;
                    }
                }
                if (stringLastPath != null) {
                    stringBuilder.delete(0, stringBuilder.length());
                    stringBuilder.append("LastMediaOpenPath");
                    stringBuilder.append(INIFILE_FIELDSEPERATOR);
                    stringBuilder.append(stringLastPath);
                    stringBuilder.append(INIFILE_FIELDSEPERATOR);
                    stringBuilder.append("the last path where a media file is loaded");
                    o_BufferedWriter.append(stringBuilder.toString());
                    o_BufferedWriter.newLine();
                }
                boolIni = true;
            }
            catch (IOException e_IOException) {
                System.err.println("ERROR PlayDMX writeIni():");
                e_IOException.printStackTrace();
            }
            try {
                if (o_BufferedWriter != null) {
                    o_BufferedWriter.flush();
                    o_BufferedWriter.close();
                }
                if (o_FileWriterIni != null) {
                    o_FileWriterIni.close();
                }
            }
            catch (IOException e_IOException) {
                System.err.println("ERROR PlayDMX writeIni() - close ini file:");
                e_IOException.printStackTrace();
            }
            return boolIni;
        }
    }

    public PlayMedia(String p_ProducerName, Playable p_Playable) {
        super(p_Playable);
        this.m_ProducerName = p_ProducerName;
        this.m_ID = "vip".equals(this.m_ProducerName) ? this.m_ProducerName : UUID.randomUUID().toString();
        this.m_PlaySPIT = new PlaySPIT(this.m_ID, this.m_ProducerName, p_Playable, this);
        this.initMembers();
        LiveShowMediaSystem.addPlayMedia(this);
        this.setPlayCursor(this.m_FramePlayCursor);
    }

    private void initMembers() {
        this.initPlayObject();
        this.setColor(Color.GREEN);
        this.m_FramesToReadTime = BUFFER_MILLISECONDS;
        this.m_JavaTimer = new JavaTimer();
    }

    public PlaySPIT getPlaySPIT() {
        return this.m_PlaySPIT;
    }

    @Override
    public boolean createOutputLine() {
        this.m_HasOutputLine = true;
        return true;
    }

    @Override
    public boolean closeOutputLine() {
        this.m_HasOutputLine = false;
        return true;
    }

    @Override
    public void close() {
        LiveShowMediaSystem.removePlayMedia(this);
        super.close();
        if (this.m_MediaPlayObject != null) {
            this.m_MediaPlayObject.close();
        }
        this.m_JavaTimer.close();
    }

    @Override
    protected void initPlayObject() {
        this.m_MediaPlayObject = new MediaPlayObject(this.m_ProducerName, this, this.m_Playable);
        this.m_MediaPlayObject.setReadPreObject(true);
        this.m_FramesToReadDefault = this.m_Playable.getFrameTime() <= 0.0 ? 1L : (long)((double)BUFFER_MILLISECONDS / this.m_Playable.getFrameTime() + 0.5);
        this.m_MediaPlayObject.setFrameTime(LiveShowVIP.getFRAMETIME());
        this.m_MediaPlayObject.setFramesBuffered((int)this.m_FramesToReadDefault);
        this.m_MediaPlayObject.setReadPreObject(false);
        this.m_FramesToReadDefault = this.m_Playable.getFrameTime() <= 0.0 ? 1L : (long)((double)BUFFER_MILLISECONDS / this.m_Playable.getFrameTime() + 0.5);
        this.m_MediaPlayObject.setFrameTime(LiveShowVIP.getFRAMETIME());
        this.m_MediaPlayObject.setFramesBuffered((int)this.m_FramesToReadDefault);
        this.m_PlaySPIT.setSPITPlayObject(this.m_MediaPlayObject.getSPITPlayObject());
    }

    @Override
    public void setPlayable(Playable p_Playable, Object p_Addition) {
        if (this.m_Playable == p_Playable) {
            return;
        }
        if (p_Playable == null) {
            return;
        }
        super.setPlayable(p_Playable, p_Addition);
        if (this.m_MediaPlayObject != null) {
            this.m_MediaPlayObject.close();
        }
        this.m_PlaySPIT.setPlayable(p_Playable);
        this.initPlayObject();
    }

    public String getID() {
        return this.m_ID;
    }

    public String getProducerName() {
        return this.m_ProducerName;
    }

    @Override
    public Playable.PlayObject getPlayObject() {
        return this.m_MediaPlayObject;
    }

    @Override
    public long getBufferDelayFrames() {
        return BUFFER_MILLISECONDS;
    }

    public long getPlayCursorJumpPerReadCycle() {
        return this.m_FramesToReadDefault;
    }

    @Override
    public void setPlayCursor(long p_FramePosition) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        super.setPlayCursor(p_FramePosition);
        super.setPlayCursorInternal(super.getPlayCursor(), super.getPlayCursor());
        this.m_FramePositionToWrite = super.getPlayCursor();
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public static void setMainTransparency(double p_MainTransparency) {
        if (p_MainTransparency < 0.0) {
            p_MainTransparency = 0.0;
        }
        s_MainTransparency = p_MainTransparency;
        PlayMedia.sendMainTransparency();
    }

    public static double getMainTransparency() {
        return s_MainTransparency;
    }

    public static void setMainSoundVolume(double p_MainSoundVolume) {
        if (p_MainSoundVolume < 0.0) {
            p_MainSoundVolume = 0.0;
        }
        s_MainSoundVolume = p_MainSoundVolume;
        PlayMedia.sendMainSoundVolume();
    }

    public static double getMainSoundVolume() {
        return s_MainSoundVolume;
    }

    @Override
    public void letsRun() {
        super.letsRun();
    }

    @Override
    public void setWaitForTrigger(boolean p_Wait) {
        super.setWaitForTrigger(p_Wait);
        if (!p_Wait) {
            // empty if block
        }
    }

    @Override
    protected void clearPlaying() {
        this.m_FramesRead = -1L;
    }

    @Override
    public void reworkPause() {
        this.m_MediaPlayObject.pause();
        this.sendPlayStatus();
    }

    @Override
    public void reworkStop() {
        this.m_MediaPlayObject.pause();
        this.m_PlaySPIT.reworkStop();
        this.sendPlayStatus();
    }

    @Override
    public void playFramePositionOnce(long p_FramePosition) {
        if (this.m_Playable == null) {
            return;
        }
        if (!this.m_IsEditModeOn) {
            if (this.m_MediaPlayObject == null) {
                return;
            }
            this.m_MediaPlayObject.clear();
            this.m_MediaPlayObject.setFramePosition(p_FramePosition);
            this.m_MediaPlayObject.setFramesToRead(1L);
            if (this.m_Playable.read(this, this.m_MediaPlayObject) == null) {
                this.m_MediaPlayObject.setFadeProgress(0.0);
            }
            this.sendPlayStatus();
        }
    }

    @Override
    public void playFramePositionOnce() {
        if (!this.m_IsEditModeOn) {
            this.playFramePositionOnce(this.m_FramePlayCursor);
        } else {
            this.playFramePositionOnce(this.m_FrameEditCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void fetchwriteData() {
        if (this.m_PlayListeners == null) {
            return;
        }
        boolean boolFadedInAtEndPosition = false;
        MediaPlayObject o_MediaPlayObject = this.m_MediaPlayObject;
        Playable o_Playable = this.m_Playable;
        if (o_MediaPlayObject == null) {
            if (this.m_PlaySynchronisizer != null) {
                this.m_PlaySynchronisizer.actionPlayPause();
                return;
            }
            this.m_StopFlag = true;
            return;
        }
        if (o_Playable == null) {
            if (this.m_PlaySynchronisizer != null) {
                this.m_PlaySynchronisizer.actionPlayPause();
                return;
            }
            this.m_StopFlag = true;
            return;
        }
        long longFrames = o_MediaPlayObject.getFramesBuffered();
        if (this.m_FramePositionToWrite >= o_Playable.getFrameEndToPlay()) {
            this.m_FramePositionToWrite = o_Playable.getFrameEndToPlay();
            super.setPlayCursorInternal(o_Playable.getFrameEndToPlay(), o_Playable.getFrameEndToPlay());
            return;
        }
        long longOldFramePositionToWrite = this.m_FramePositionToWrite;
        long longFramesToRead = this.m_FramePositionToWrite + longFrames > o_Playable.getFrameEndToPlay() ? o_Playable.getFrameEndToPlay() - this.m_FramePositionToWrite : longFrames;
        boolean boolReady = false;
        boolean boolJumpNow = false;
        boolean boolReadFromSceneBridge = false;
        while (!boolReady) {
            block22: {
                block23: {
                    boolReady = true;
                    if (this.m_ActualPlayJump == null || !this.m_ActualPlayJump.getJumpIsActive()) break block23;
                    if (!boolJumpNow) {
                        if (this.m_FramePositionToWrite < this.m_ActualPlayJump.getJumpFrameFrom() && this.m_FramePositionToWrite + longFramesToRead > this.m_ActualPlayJump.getJumpFrameFrom()) {
                            longFramesToRead = this.m_ActualPlayJump.getJumpFrameFrom() - this.m_FramePositionToWrite;
                            boolJumpNow = true;
                            boolReady = false;
                            if (longFramesToRead <= 0L) {
                                continue;
                            }
                            break block22;
                        } else {
                            boolReady = true;
                        }
                        break block22;
                    } else {
                        this.setPlayCursor(this.m_ActualPlayJump.getJumpFrameTo());
                        boolReady = true;
                        continue;
                    }
                }
                boolReady = true;
            }
            this.setWillStopAtSceneBridge(null);
            Object object = this.m_SyncPlayListeners;
            // MONITORENTER : object
            for (int intListener = 0; this.m_PlayListeners != null && intListener < this.m_PlayListeners.size(); ++intListener) {
                PlayListener o_PlayListener = (PlayListener)this.m_PlayListeners.get(intListener);
                if (o_PlayListener == null) continue;
                long longVetoFramesToRead = o_PlayListener.eventPlayCheckRead(this, this.m_FramePositionToWrite, longFramesToRead);
                if (longVetoFramesToRead <= 0L) {
                    longVetoFramesToRead = 0L;
                }
                if (longVetoFramesToRead >= longFramesToRead) continue;
                longFramesToRead = longVetoFramesToRead;
            }
            // MONITOREXIT : object
            if (longFramesToRead <= 0L) {
                longFramesToRead = 0L;
            }
            this.fetchWriteLiveShowObjectInterfaces_Jingle(this.m_FramePositionToWrite, longFramesToRead);
            o_MediaPlayObject.clear();
            o_MediaPlayObject.setFramePosition(this.m_FramePositionToWrite);
            o_MediaPlayObject.setFramesToRead(longFramesToRead);
            boolReadFromSceneBridge = o_Playable.getLiveShowSceneBridge_Actual() != null;
            if (o_Playable.read(this, o_MediaPlayObject) == null) {
                o_MediaPlayObject.getMediaObject_PlayStatus().setFadeProgress(0.0);
            }
            if (boolFadedInAtEndPosition) {
                o_MediaPlayObject.setFadeInProgress(1.0);
                o_MediaPlayObject.setFadeProgress(1.0);
            }
            this.sendPlayStatus();
            this.m_FramePositionToWrite += longFramesToRead;
            if (this.m_Status != 3) {
                return;
            }
            super.setPlayCursorInternal(longOldFramePositionToWrite, this.m_FramePositionToWrite);
            this.setWillStopAtSceneBridge(null);
            if (this.m_FramesRead < 0L) {
                this.m_PlayStartTime = System.nanoTime();
                return;
            }
            long longActualTime = (System.nanoTime() - this.m_PlayStartTime) / 1000000L;
            long longActualTimeCalculated = (long)((double)this.m_FramesRead * o_Playable.getFrameTime());
            long longTimeDiff = longActualTime - longActualTimeCalculated;
            this.m_FramesToReadTime = (long)((double)longFramesToRead * o_Playable.getFrameTime() + 0.5);
            long longTimeToWait = this.m_FramesToReadTime - longTimeDiff;
            if (this.m_FramesToReadTime > 0L) {
                this.m_JavaTimer.sleep(longTimeToWait);
            }
            this.m_FramesRead += longFramesToRead;
        }
    }

    @Override
    protected void checkFadeProgress(boolean p_NotifyListeners) {
        double doubleFadeProgress;
        boolean boolFadeInPossible = false;
        boolean boolFadeOutPossible = false;
        boolean boolFadedIn = false;
        Playable.PlayObject o_PlayObject = this.getPlayObject();
        if (o_PlayObject == null) {
            doubleFadeProgress = 0.0;
            boolFadeInPossible = false;
            boolFadeInPossible = false;
            boolFadedIn = false;
        } else {
            doubleFadeProgress = o_PlayObject.getFadeProgress();
            boolFadeInPossible = false;
            boolFadeOutPossible = false;
            if (o_PlayObject.getFadeInProgress() == 1.0) {
                boolFadedIn = true;
            }
            if (this.m_Status == 1) {
                if (o_PlayObject.getFadeInProgress() > 0.0 || o_PlayObject.getFadeOutProgress() > 0.0) {
                    boolFadeOutPossible = true;
                }
            } else if (o_PlayObject.getFadeInProgress() > 0.0 && (o_PlayObject.getFadeOutProgress() == 0.0 || o_PlayObject.getFadeOutProgress() == 1.0)) {
                boolFadeOutPossible = true;
            }
        }
        if (this.m_FadeInPossible != boolFadeInPossible || this.m_FadeOutPossible != boolFadeOutPossible) {
            this.m_FadeInPossible = boolFadeInPossible;
            this.m_FadeOutPossible = boolFadeOutPossible;
            if (p_NotifyListeners) {
                this.notifyPlayListeners_PlayFadePossibility(this.m_FadeInPossible, this.m_FadeOutPossible, doubleFadeProgress);
            }
        }
        if (this.m_FadedIn != boolFadedIn) {
            this.m_FadedIn = boolFadedIn;
            if (this.m_FadedIn) {
                this.m_WasFadedIn = true;
            }
            this.notifyPlayListeners_PlayFadedIn(this.m_FadedIn, doubleFadeProgress);
        }
    }

    @Override
    public void addLiveShowObjectInterface_Jingle(LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void removeLiveShowObjectInterface_Jingle(LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public int getLiveShowObjectInterfaces_JingleCount() {
        return 0;
    }

    @Override
    public void fetchWriteLiveShowObjectInterfaces_Jingle(long p_FramePositionToWrite, long p_FramesToRead) {
    }

    @Override
    public LiveShowObjectInterface getLiveShowObjectInterface_Jingle(int p_Index) {
        return null;
    }

    public void sendPlayStatus() {
        MediaPlayObject o_MediaPlayObject = (MediaPlayObject)this.getPlayObject();
        MediaServer.sendPlayStatus(this.getProducerName(), o_MediaPlayObject.getMediaObject_PlayStatus());
        this.m_PlaySPIT.sendPlayStatus();
    }

    public static void sendMainTransparency() {
        MediaServer.sendMainTransparency((float)s_MainTransparency);
    }

    public static void sendMainSoundVolume() {
        MediaServer.sendMainSoundVolume((float)s_MainSoundVolume);
    }

    public static Playable.PlayObject mixPlayObjects(Playable.PlayObject p_PlayObjectLine, Playable.PlayObject p_PlayObject) {
        if (p_PlayObjectLine == null) {
            return null;
        }
        if (p_PlayObject == null) {
            return null;
        }
        return p_PlayObjectLine;
    }

    public static double calculateVolumeFactor(double p_Loudness) {
        double doubleFactor;
        if (p_Loudness <= 0.0) {
            doubleFactor = 0.0;
        } else if (p_Loudness == 1.0) {
            doubleFactor = 1.0;
        } else {
            double doubleExp = 0.5 * Math.log10(p_Loudness) / Math.log10(2.0);
            doubleFactor = Math.pow(10.0, doubleExp);
        }
        return doubleFactor;
    }

    static {
        s_ReadIniActive = false;
        s_SyncWriteIni = new Object();
    }

    public static class MediaPlayObject
    implements Playable.PlayObject {
        public static final int SOFTWAREVERSION = 1;
        private MediaObject_PlayStatus m_MediaObject_PlayStatus;
        private Playable m_Playable;
        private String m_ProducerName;
        private PlayMedia m_PlayMedia;
        private int m_FramesBuffered;
        private double m_FrameTime;
        private final Object m_SyncPlayStatus = new Object();
        private PlaySPIT.SPITPlayObject m_SPITPlayObject;

        public MediaPlayObject(String p_ProducerName, PlayMedia p_PlayMedia, Playable p_Playable) {
            this.m_ProducerName = p_ProducerName;
            this.m_Playable = p_Playable;
            this.m_PlayMedia = p_PlayMedia;
            this.initMembers();
            this.m_SPITPlayObject = new PlaySPIT.SPITPlayObject(p_ProducerName, p_PlayMedia.getPlaySPIT(), p_Playable, this);
        }

        private void initMembers() {
            this.m_MediaObject_PlayStatus = MediaObject_PlayStatus.poolGet();
            this.m_MediaObject_PlayStatus.setName("MediaPlayObject");
            this.m_MediaObject_PlayStatus.setFrameTime(this.m_FrameTime);
            this.m_MediaObject_PlayStatus.setFramesBuffered(this.m_FramesBuffered);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_MediaObject_PlayStatus.close();
                this.m_SPITPlayObject.close();
            }
        }

        public PlaySPIT.SPITPlayObject getSPITPlayObject() {
            return this.m_SPITPlayObject;
        }

        public void setReadPreObject(boolean p_ReadPreObject) {
            this.m_MediaObject_PlayStatus.setReadPreObject(p_ReadPreObject);
        }

        public void pause() {
            this.m_MediaObject_PlayStatus.pause();
            this.m_SPITPlayObject.pause();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Playable getPlayable() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_Playable;
            }
        }

        public PlayMedia getPlayMedia() {
            return this.m_PlayMedia;
        }

        public void addLiveShowMediaObject(LiveShowMediaObject p_LiveShowMediaObject) {
            if (p_LiveShowMediaObject == null) {
                return;
            }
            this.m_MediaObject_PlayStatus.addLiveShowMediaObject(p_LiveShowMediaObject.getDescription());
        }

        public void removeLiveShowMediaObject(LiveShowMediaObject p_LiveShowMediaObject) {
            if (p_LiveShowMediaObject == null) {
                return;
            }
            this.m_MediaObject_PlayStatus.removeLiveShowMediaObject(p_LiveShowMediaObject.getDescription());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFramePosition(long p_FramePosition) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_MediaObject_PlayStatus.setFramePosition(p_FramePosition);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getFramePosition() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_MediaObject_PlayStatus.getFramePosition();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getFramePositionOld() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_MediaObject_PlayStatus.getFramePositionOld();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFramesToRead(long p_FrameLength) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_MediaObject_PlayStatus.setFramesToRead(p_FrameLength);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getFramesToRead() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_MediaObject_PlayStatus.getFramesToRead();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFramesBuffered(int p_FramesBuffered) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_FramesBuffered = p_FramesBuffered;
                this.m_MediaObject_PlayStatus.setFramesBuffered(this.m_FramesBuffered);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getFramesBuffered() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_MediaObject_PlayStatus.getFramesBuffered();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getData() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_MediaObject_PlayStatus;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_MediaObject_PlayStatus.clear();
                this.m_MediaObject_PlayStatus.setFramesBuffered(this.m_FramesBuffered);
                this.m_MediaObject_PlayStatus.setFrameTime(this.m_FrameTime);
                this.m_SPITPlayObject.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFrameTime(double p_FrameTime) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_FrameTime = p_FrameTime;
                this.m_MediaObject_PlayStatus.setFrameTime(this.m_FrameTime);
                this.m_SPITPlayObject.setFrameTime(p_FrameTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getFadeProgress() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_MediaObject_PlayStatus.getFadeProgress();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getFadeInProgress() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_MediaObject_PlayStatus.getFadeInProgress();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getFadeOutProgress() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_MediaObject_PlayStatus.getFadeOutProgress();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getFadeProgress(boolean p_FromPreObject) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_MediaObject_PlayStatus.getFadeProgress(p_FromPreObject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getFadeInProgress(boolean p_FromPreObject) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_MediaObject_PlayStatus.getFadeInProgress(p_FromPreObject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getFadeOutProgress(boolean p_FromPreObject) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_MediaObject_PlayStatus.getFadeOutProgress(p_FromPreObject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFadeInProgress(double p_FadeInProgress) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_MediaObject_PlayStatus.setFadeInProgress(p_FadeInProgress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFadeOutProgress(double p_FadeOutProgress) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_MediaObject_PlayStatus.setFadeOutProgress(p_FadeOutProgress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFadeProgress(double p_FadeProgress) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_MediaObject_PlayStatus.setFadeProgress(p_FadeProgress);
            }
        }

        public void setVolumeFactor(float p_Factor) {
            this.m_MediaObject_PlayStatus.setVolumeFactor(p_Factor);
        }

        public float getVolumeFactor() {
            return this.m_MediaObject_PlayStatus.getVolumeFactor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MediaObject_PlayStatus getMediaObject_PlayStatus() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_MediaObject_PlayStatus;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MediaObject_PlayStatus.ObjectPlayStatus getObjectPlayStatus(String p_ObjectID) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                if (p_ObjectID == null) {
                    return null;
                }
                return this.m_MediaObject_PlayStatus.getObjectPlayStatus(p_ObjectID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPlayStatus(String p_ObjectID, boolean p_IsPlaying, boolean p_IsPreObject, long p_MediaPositionFrame, float p_VolumeFactor, double p_FadeProgress, boolean p_FadeIn, boolean p_FadeOut) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_MediaObject_PlayStatus.setPlayStatus(p_ObjectID, p_IsPlaying, p_IsPreObject, p_MediaPositionFrame, p_VolumeFactor, p_FadeProgress, p_FadeIn, p_FadeOut);
            }
        }
    }
}

