/*
 * Decompiled with CFR 0.152.
 */
package MediaVirtualPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import MediaObjectPackage.LiveShowMediaObjectDescription;
import PlayMediaPackage.PlayMedia;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;

public class LiveShowMediaSceneBridge
extends LiveShowSceneBridge {
    public static final int SOFTWAREVERSION = 1;
    @LiveLanguageString
    public static String s_BridgeRemoteGroupName = "Scene Media";
    private long m_PositionPre_Start;

    public LiveShowMediaSceneBridge(LiveShowObjectDescription p_LiveShowMediaObjectDescription) {
        super(p_LiveShowMediaObjectDescription);
        this.initMembers();
        this.initMembersFurther(p_LiveShowMediaObjectDescription);
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.setObjectType(22);
    }

    private void initMembersFurther(LiveShowObjectDescription p_LiveShowObjectDescription) {
        super.setDescription(p_LiveShowObjectDescription);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        this.m_Description.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = LiveShowMediaObjectDescription.poolGet();
        o_LiveShowMediaObjectDescription.readExternal(in);
        this.initMembersFurther((LiveShowObjectDescription)o_LiveShowMediaObjectDescription);
    }

    @Override
    public boolean exportExternal(ObjectOutput out, LiveShowProjectDescription p_LiveShowProjectDescription, String p_ReplaceName) throws IOException {
        this.writeExternal(out);
        return true;
    }

    @Override
    public void close(boolean p_Finish) {
        super.close(p_Finish);
    }

    @Override
    public void setDescription(LiveShowObjectDescription p_Description) {
        boolean boolEqualMediaType = true;
        this.initMembersFurther((LiveShowObjectDescription)((LiveShowMediaObjectDescription)p_Description));
        if (((LiveShowMediaObjectDescription)p_Description).getMediaType() != ((LiveShowMediaObjectDescription)this.m_Description).getMediaType()) {
            boolEqualMediaType = false;
        }
        ((LiveShowMediaObjectDescription)this.m_Description).setMediaType(((LiveShowMediaObjectDescription)p_Description).getMediaType());
        if (!boolEqualMediaType) {
            this.m_ChangedSinceLastAction = true;
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    @Override
    public void setSource(Object p_SourceObject) {
    }

    @Override
    public Object getSource() {
        return null;
    }

    @Override
    public String getSourceAdditionalInfo() {
        return null;
    }

    @Override
    public ComboBoxModel getSourceListModel() {
        return null;
    }

    @Override
    public boolean getSourceIsReplaceable() {
        return false;
    }

    @Override
    public DefaultListCellRenderer getSourceListRenderer() {
        return null;
    }

    @Override
    public boolean getFrameOffsetAbility() {
        return false;
    }

    @Override
    public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        if (p_Play == null) {
            return null;
        }
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getFramePosition() < 0L) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        if (!(p_PlayObject instanceof PlayMedia.MediaPlayObject)) {
            return null;
        }
        if (this.m_LiveShowVIP == null) {
            return null;
        }
        PlayMedia.MediaPlayObject o_MediaPlayObject = (PlayMedia.MediaPlayObject)p_PlayObject;
        Playable.PlayObject o_ResultPlayObject = null;
        if (this.m_Play == null) {
            return null;
        }
        long longFramePosition = p_Play.getPlayCursor();
        long longFramesToRead = o_MediaPlayObject.getFramesToRead();
        int longFramesBuffered = o_MediaPlayObject.getFramesBuffered();
        boolean boolBridgeStarted = false;
        if (!this.m_IsPlaying) {
            this.m_IsPlaying = true;
            boolBridgeStarted = true;
            this.m_PositionPre_Start = o_MediaPlayObject.getFramePositionOld();
            this.setFramePositionPre(o_MediaPlayObject.getFramePositionOld());
            if (p_Play.isRunning()) {
                this.m_Play.setPlayCursor(this.m_Description.getFrameStart());
                o_MediaPlayObject.setReadPreObject(true);
                longFramePosition = this.m_Description.getFrameStart();
                o_MediaPlayObject.setFramePosition(longFramePosition);
                o_MediaPlayObject.setReadPreObject(false);
            }
        }
        this.setFramePositionPre(this.m_PositionPre_Start + longFramePosition - this.m_Description.getFrameStart());
        if (!this.isCursorPositionInside(longFramePosition)) {
            if (this.m_IsPlaying) {
                this.stopSceneBridge();
                this.m_IsPlaying = false;
            }
            o_ResultPlayObject = this.m_LiveShowVIP.readInternal(p_Play, o_MediaPlayObject, null, -1L, 1.0, false);
            return o_ResultPlayObject;
        }
        long longFrameInside = p_PlayObject.getFramePosition() - this.getFrameStart();
        PlayMedia.MediaPlayObject o_MediaPlayObjectPre = null;
        PlayMedia.MediaPlayObject o_MediaPlayObjectPost = null;
        o_MediaPlayObject.setReadPreObject(true);
        if (o_MediaPlayObject.getFramesBuffered() != longFramesBuffered) {
            o_MediaPlayObject.setFramesBuffered(longFramesBuffered);
        }
        o_MediaPlayObject.setFramePosition(this.getFramePositionPre());
        o_MediaPlayObject.setFramesToRead(longFramesToRead);
        double doubleFadeProgress = this.calculateFadeProgress(longFramePosition, longFramesToRead, false, true);
        o_MediaPlayObjectPre = (PlayMedia.MediaPlayObject)this.m_LiveShowVIP.readInternal(p_Play, o_MediaPlayObject, this, longFrameInside, doubleFadeProgress, true);
        if (o_MediaPlayObjectPre != null) {
            o_MediaPlayObject.setFadeProgress(doubleFadeProgress);
            o_MediaPlayObject.setFadeOutProgress(doubleFadeProgress);
            o_MediaPlayObject.setFadeInProgress(0.0);
            o_MediaPlayObject.setVolumeFactor(this.getVolumeFactor());
        } else {
            o_MediaPlayObject.setFadeProgress(0.0);
            o_MediaPlayObject.setFadeOutProgress(0.0);
            o_MediaPlayObject.setFadeInProgress(0.0);
            o_MediaPlayObject.setVolumeFactor(0.0f);
        }
        o_MediaPlayObject.setReadPreObject(false);
        o_MediaPlayObject.setFramesToRead(longFramesToRead);
        o_MediaPlayObject.setFramePosition(longFramePosition);
        doubleFadeProgress = this.calculateFadeProgress(longFramePosition, o_MediaPlayObject.getFramesToRead(), true, false);
        o_MediaPlayObjectPost = (PlayMedia.MediaPlayObject)this.m_LiveShowVIP.readInternal(p_Play, o_MediaPlayObject, this, longFrameInside, doubleFadeProgress, false);
        if (o_MediaPlayObjectPost != null) {
            o_MediaPlayObject.setFadeProgress(doubleFadeProgress);
            o_MediaPlayObject.setFadeOutProgress(0.0);
            o_MediaPlayObject.setFadeInProgress(doubleFadeProgress);
            o_MediaPlayObject.setVolumeFactor(this.getVolumeFactor());
        } else {
            o_MediaPlayObject.setFadeProgress(0.0);
            o_MediaPlayObject.setFadeOutProgress(0.0);
            o_MediaPlayObject.setFadeInProgress(0.0);
            o_MediaPlayObject.setVolumeFactor(0.0f);
        }
        o_ResultPlayObject = o_MediaPlayObjectPre != null && o_MediaPlayObject != null ? o_MediaPlayObject : (o_MediaPlayObjectPre != null ? o_MediaPlayObjectPre : (o_MediaPlayObjectPost != null ? o_MediaPlayObjectPost : null));
        Play.PlaySynchronisizer o_PlaySynchronisizer = this.m_Play.getPlaySynchronizer();
        if (o_PlaySynchronisizer != null) {
            // empty if block
        }
        if (!this.m_LiveShowVIP.getActive()) {
            return null;
        }
        return o_ResultPlayObject;
    }

    private double calculateFadeProgress(long p_FramePosition, long p_FramesLength, boolean p_FadeIn, boolean p_FadeOut) {
        if (p_FramePosition < 0L) {
            return 0.0;
        }
        boolean boolInside = false;
        double doubleFactor = 1.0;
        long longFramePosition = p_FramePosition;
        double doubleValue = 0.0;
        long longFramePositionInside = longFramePosition - this.m_Description.getFrameStart();
        if (longFramePositionInside > 0L && longFramePositionInside < this.m_Description.getFrameStart() + this.m_Description.getFrameLength()) {
            boolInside = true;
        }
        if (boolInside = true) {
            if (!p_FadeIn) {
                if (this.m_Description.getFrameFadeOutLength() - this.m_Description.getFrameFadeOutOffset() > 0L && longFramePositionInside <= this.m_Description.getFrameFadeOutLength()) {
                    if (longFramePositionInside > this.m_Description.getFrameFadeOutOffset()) {
                        doubleFactor = (double)(this.m_Description.getFrameFadeOutLength() - longFramePositionInside) / (double)(this.m_Description.getFrameFadeOutLength() - this.m_Description.getFrameFadeOutOffset());
                    }
                } else {
                    doubleFactor = longFramePositionInside > this.m_Description.getFrameFadeOutOffset() ? 0.0 : 1.0;
                }
            } else {
                long longPositionFromEnd = this.m_Description.getFrameLength() - longFramePositionInside;
                if (longPositionFromEnd < 0L) {
                    doubleFactor = 1.0;
                } else if (this.m_Description.getFrameFadeInLength() - this.m_Description.getFrameFadeInOffset() > 0L && longPositionFromEnd <= this.m_Description.getFrameFadeInLength()) {
                    if (longPositionFromEnd > this.m_Description.getFrameFadeInOffset()) {
                        doubleFactor = (double)(this.m_Description.getFrameFadeInLength() - longPositionFromEnd) / (double)(this.m_Description.getFrameFadeInLength() - this.m_Description.getFrameFadeInOffset());
                    }
                } else {
                    doubleFactor = longPositionFromEnd > this.m_Description.getFrameFadeInOffset() ? 0.0 : 1.0;
                }
            }
        }
        if (doubleFactor > 1.0) {
            doubleFactor = 1.0;
        }
        if (doubleFactor < 0.0) {
            doubleFactor = 0.0;
        }
        return doubleFactor;
    }

    @Override
    public double getFrameTime() {
        return LiveShowVIP.FRAMETIME;
    }

    @Override
    public void notifyObjectListeners_ObjectParameterChanged(LiveShowObjectDescription p_LiveShowObjectDescription) {
        super.notifyObjectListeners_ObjectParameterChanged(p_LiveShowObjectDescription);
    }

    @Override
    public void eventEndOfAction(LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
        super.eventEndOfAction(p_ActorLiveShowVIP, p_Success, p_Action);
    }

    @Override
    public String getRemoteGroupName() {
        return s_BridgeRemoteGroupName;
    }
}

