/*
 * Decompiled with CFR 0.152.
 */
package MediaVirtualPackage;

import Icons.IconManager;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectPanel;
import MediaPackage.MediaServer;
import MediaPlayerPackage.LiveShow_MediaPlayer;
import MediaVirtualPackage.LiveShowMediaObject;
import SynchronizationPackage.EventQueueHandler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class LiveShowMediaObjectPanel
extends LiveShowObjectPanel {
    public static ImageIcon s_IconCalculateSoundGraphic = IconManager.getImageIcon("Sound_CalculateGraphic.png");
    private Runnable m_RunnableRepaint;

    public LiveShowMediaObjectPanel(LiveShowMediaObject p_LiveShowObject, boolean p_Resizable) {
        super(p_LiveShowObject, p_Resizable);
        this.initMembers();
        this.checkMediaServerConnection();
    }

    private void initMembers() {
        this.m_RunnableRepaint = new Runnable(){

            @Override
            public void run() {
                LiveShowMediaObjectPanel.this.repaint();
            }
        };
        this.setDoubleBuffered(false);
        this.setBackground(new Color(0, 50, 0));
        this.setColorBorder(Color.GREEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        Object object = this.m_SyncPainting;
        synchronized (object) {
        }
    }

    private void checkMediaServerConnection() {
        MediaServer o_MediaServer = null;
        boolean boolFailure = false;
        LiveShowMediaObject o_LiveShowMediaObject = (LiveShowMediaObject)this.m_LiveShowObjectInterface;
        if (o_LiveShowMediaObject == null) {
            this.setFailure(true);
            return;
        }
        if ("mediasourceclient".equals(o_LiveShowMediaObject.getProducer())) {
            this.setFailure(false);
            return;
        }
        int intMediaServerCount = o_LiveShowMediaObject.getMediaServerCount();
        if (intMediaServerCount <= 0) {
            this.setFailure(true);
            return;
        }
        for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
            o_MediaServer = o_LiveShowMediaObject.getMediaServer(intMediaServer);
            if (o_MediaServer == null || o_MediaServer.isConnected()) continue;
            this.setFailure(true);
            return;
        }
        this.setFailure(false);
    }

    @Override
    public void paintData(Graphics2D p_Graphics2D, int p_ContainerViewWidth, int p_Height, int p_VisibleStartX, int p_VisibleEndX, long p_VisibleStartFrame, long p_VisibleEndFrame, boolean p_RedrawWidth, boolean p_RedrawHeight) {
        int intPosStartX;
        int intNewWidth;
        int intNewHeight;
        int intSnapHeight;
        int intSnapWidth;
        int intSnapY;
        int intSnapX;
        Rectangle o_SnapShotOriginSize;
        if (p_Graphics2D == null) {
            return;
        }
        if (p_RedrawWidth) {
            // empty if block
        }
        if (p_RedrawHeight || p_RedrawWidth) {
            // empty if block
        }
        if (p_VisibleStartFrame == p_VisibleEndFrame) {
            return;
        }
        LiveShowMediaObject o_LiveShowMediaObject = (LiveShowMediaObject)this.m_LiveShowObjectInterface;
        if (o_LiveShowMediaObject == null) {
            return;
        }
        if (o_LiveShowMediaObject.getSnapShot_Start() == null && o_LiveShowMediaObject.getSnapShot_Middle() == null && o_LiveShowMediaObject.getSnapShot_End() == null) {
            this.paintCalculate(p_Graphics2D, p_VisibleStartX, p_VisibleEndX);
            return;
        }
        int longSize = p_Height < LiveShow_MediaPlayer.SnapshotEventListener.s_SnapShotDimension.height ? p_Height : LiveShow_MediaPlayer.SnapshotEventListener.s_SnapShotDimension.height;
        if (longSize > LiveShow_MediaPlayer.SnapshotEventListener.s_SnapShotDimension.width) {
            longSize = LiveShow_MediaPlayer.SnapshotEventListener.s_SnapShotDimension.width;
        }
        if ((o_SnapShotOriginSize = o_LiveShowMediaObject.getSnapShotOriginSize()) != null && o_SnapShotOriginSize.width > 0 && o_SnapShotOriginSize.height > 0) {
            intSnapX = o_SnapShotOriginSize.x;
            intSnapY = o_SnapShotOriginSize.y;
            intSnapWidth = o_SnapShotOriginSize.width;
            intSnapHeight = o_SnapShotOriginSize.height;
            double doubleFactorHeight = (double)longSize / (double)o_SnapShotOriginSize.height;
            double doubleFactorWidth = (double)longSize / (double)o_SnapShotOriginSize.width;
            if (doubleFactorHeight < doubleFactorWidth) {
                intNewHeight = (int)((double)o_SnapShotOriginSize.height * doubleFactorHeight);
                intNewWidth = (int)((double)o_SnapShotOriginSize.width * doubleFactorHeight);
            } else {
                intNewHeight = (int)((double)o_SnapShotOriginSize.height * doubleFactorWidth);
                intNewWidth = (int)((double)o_SnapShotOriginSize.width * doubleFactorWidth);
            }
        } else {
            intSnapX = 0;
            intSnapY = 0;
            intSnapWidth = longSize;
            intSnapHeight = longSize;
            intNewHeight = longSize;
            intNewWidth = longSize;
        }
        int intPosStartY = (p_Height - intNewHeight) / 2;
        BufferedImage o_SnapShot = o_LiveShowMediaObject.getSnapShot_Middle();
        if (o_SnapShot != null && (intPosStartX = this.getInsidePositionX(o_LiveShowMediaObject.getFrameStartOffset() + o_LiveShowMediaObject.getFrameLength() / 2L) - intNewWidth / 2) + longSize >= p_VisibleStartX && intPosStartX < p_VisibleEndX) {
            if (o_SnapShotOriginSize == null) {
                intSnapWidth = o_SnapShot.getWidth();
                intSnapHeight = o_SnapShot.getHeight();
            }
            p_Graphics2D.drawImage(o_SnapShot, intPosStartX, intPosStartY, intPosStartX + intNewWidth, intPosStartY + intNewHeight, intSnapX, intSnapY, intSnapX + intSnapWidth, intSnapY + intSnapHeight, null);
        }
        if ((o_SnapShot = o_LiveShowMediaObject.getSnapShot_Start()) != null && (intPosStartX = this.getInsidePositionX(o_LiveShowMediaObject.getFrameStartOffset())) + longSize >= p_VisibleStartX && intPosStartX < p_VisibleEndX) {
            if (o_SnapShotOriginSize == null) {
                intSnapWidth = o_SnapShot.getWidth();
                intSnapHeight = o_SnapShot.getHeight();
            }
            p_Graphics2D.drawImage(o_SnapShot, intPosStartX, intPosStartY, intPosStartX + intNewWidth, intPosStartY + intNewHeight, intSnapX, intSnapY, intSnapX + intSnapWidth, intSnapY + intSnapHeight, null);
        }
        if ((o_SnapShot = o_LiveShowMediaObject.getSnapShot_End()) != null && (intPosStartX = this.getInsidePositionX(o_LiveShowMediaObject.getFrameStartOffset() + o_LiveShowMediaObject.getFrameLength()) - longSize) + longSize >= p_VisibleStartX && intPosStartX < p_VisibleEndX) {
            if (o_SnapShotOriginSize == null) {
                intSnapWidth = o_SnapShot.getWidth();
                intSnapHeight = o_SnapShot.getHeight();
            }
            p_Graphics2D.drawImage(o_SnapShot, intPosStartX, intPosStartY, intPosStartX + intNewWidth, intPosStartY + intNewHeight, intSnapX, intSnapY, intSnapX + intSnapWidth, intSnapY + intSnapHeight, null);
        }
        p_Graphics2D.setColor(this.getBackground());
    }

    private void paintCalculate(Graphics2D p_Graphics2D, int p_VisibleStartX, int p_VisibleEndX) {
        Color o_Color = this.m_IsSelected ? this.getColorBackgroundSelected_Transparent() : Color.DARK_GRAY;
        p_Graphics2D.setColor(o_Color);
        p_Graphics2D.fillRect(p_VisibleStartX + 1, 0, p_VisibleEndX - p_VisibleStartX, this.m_AbsoluteConstraints.height);
        p_Graphics2D.drawImage(s_IconCalculateSoundGraphic.getImage(), p_VisibleStartX + 1 + (p_VisibleEndX - p_VisibleStartX) / 2, this.m_AbsoluteConstraints.height / 3, s_IconCalculateSoundGraphic.getImageObserver());
    }

    @Override
    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        this.setDirty();
        super.eventObjectParameterChanged(p_LiveShowObjectInterface, p_LiveShowObjectDescription);
        this.checkMediaServerConnection();
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.repaint();
        }
    }
}

