/*
 * Decompiled with CFR 0.152.
 */
package MediaVirtualPackage;

import FileToolPackage.FileTools;
import Icons.IconManager;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectPanel;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import MediaObjectPackage.LiveShowMediaObjectDescription;
import MediaObjectPackage.MediaObject_PlayStatus;
import MediaObjectPackage.MediaSource;
import MediaObjectPackage.MediaSourceListener;
import MediaPackage.MediaServer;
import MediaPlayerPackage.LiveShow_MediaPlayer;
import MediaVirtualPackage.LiveShowMediaObjectPanel;
import MediaVirtualPackage.LiveShowMediaVIP;
import MediaVirtualPackage.MediaParentObject;
import MediaVirtualPackage.MediaSource_Client;
import PlayMediaPackage.PlayMedia;
import StartPackage.LiveShowMediaSystem;
import SynchronizationPackage.JobHandler;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;

public class LiveShowMediaObject
extends MediaParentObject
implements LiveShow_MediaPlayer.SnapshotEventListener,
MediaSourceListener {
    public static final int SOFTWAREVERSION = 1;
    public static ImageIcon s_Icon = IconManager.getImageIcon("Media.png");
    private MediaSource_Client m_MediaSource_Client;
    private static HashMap<String, String> s_HasMapFileNewPosition = new HashMap();
    private static File s_LastNewPath = null;
    private BufferedImage m_SnapShot_Start;
    private BufferedImage m_SnapShot_Middle;
    private BufferedImage m_SnapShot_End;
    private long m_SnapShot_Start_Frame;
    private long m_SnapShot_Middle_Frame;
    private long m_SnapShot_End_Frame;
    private Rectangle m_SnapShotOriginSize;
    private Runnable m_Runnable_RequestSnapShots;
    private ArrayList<MediaServer> m_MediaServers;
    private boolean m_ResetPrefetchDone_Pre;
    private LiveShowSceneBridge m_LiveShowSceneBridge;
    private boolean m_ResetPrefetchDone;
    private boolean m_ResetWas_InFront;
    private boolean m_ResetWas_Behind;
    private boolean m_ResetRestart;
    private LiveShowMediaObject m_SelfReference;
    private final Object m_SyncMediaServers = new Object();

    public static void clearHashMapFilePositions() {
        s_HasMapFileNewPosition.clear();
        s_LastNewPath = null;
    }

    public LiveShowMediaObject(MediaSource_Client p_MediaSource_Client, LiveShowMediaObjectDescription p_LiveShowMediaObjectDescription) {
        super((LiveShowObjectDescription)p_LiveShowMediaObjectDescription);
        this.initMembers();
        this.m_MediaSource_Client = p_MediaSource_Client;
        this.m_Description.setObjectType(21);
        this.initMembersFurther((LiveShowObjectDescription)((LiveShowMediaObjectDescription)this.m_Description), null);
    }

    public LiveShowMediaObject(LiveShowMediaObjectDescription p_LiveShowMediaObjectDescription) {
        super((LiveShowObjectDescription)p_LiveShowMediaObjectDescription);
        this.initMembers();
        this.m_Description.setObjectType(21);
        this.initMembersFurther((LiveShowObjectDescription)((LiveShowMediaObjectDescription)this.m_Description), null);
        if (this.m_MediaSource_Client != null) {
            this.initCheckMediaServer(p_LiveShowMediaObjectDescription);
        }
    }

    public LiveShowMediaObject(LiveShowMediaObjectDescription p_LiveShowMediaObjectDescription, LiveShowProjectDescription p_LiveShowProjectDescription) {
        super((LiveShowObjectDescription)p_LiveShowMediaObjectDescription);
        this.m_MediaSource_Client = LiveShowMediaSystem.getMediaSource(p_LiveShowMediaObjectDescription);
        this.initMembers();
        this.initMembersFurther((LiveShowObjectDescription)p_LiveShowMediaObjectDescription, p_LiveShowProjectDescription);
        if (this.m_MediaSource_Client != null) {
            this.initCheckMediaServer(p_LiveShowMediaObjectDescription);
        }
    }

    private void initMembers() {
        this.m_SelfReference = this;
        this.m_ResetPrefetchDone_Pre = false;
        this.m_ResetPrefetchDone = false;
        this.m_ResetRestart = false;
        this.m_ResetWas_InFront = false;
        this.m_ResetWas_Behind = false;
        this.m_SnapShotOriginSize = new Rectangle(0, 0, LiveShow_MediaPlayer.SnapshotEventListener.s_SnapShotDimension.width, LiveShow_MediaPlayer.SnapshotEventListener.s_SnapShotDimension.height);
        this.m_SnapShot_Start_Frame = -1L;
        this.m_SnapShot_Middle_Frame = -1L;
        this.m_SnapShot_End_Frame = -1L;
        this.m_MediaServers = new ArrayList();
    }

    private void initMembersFurther(LiveShowObjectDescription p_LiveShowObjectDescription, LiveShowProjectDescription p_LiveShowProjectDescription) {
        File o_File;
        if (p_LiveShowObjectDescription == null) {
            return;
        }
        String stringNewFileName = null;
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = (LiveShowMediaObjectDescription)p_LiveShowObjectDescription;
        String stringOldFileName = o_LiveShowMediaObjectDescription.getSourceString();
        if (stringOldFileName == null) {
            stringOldFileName = "";
        }
        stringOldFileName = stringOldFileName.replace("\\", "/");
        if (this.m_MediaSource_Client == null) {
            stringNewFileName = stringOldFileName;
            this.m_MediaSource_Client = LiveShowMediaSystem.createMediaSource(stringNewFileName);
        }
        if (this.m_MediaSource_Client == null) {
            o_File = new File(stringOldFileName);
            stringNewFileName = o_File.getName();
            stringNewFileName = LiveShowMediaSystem.getLiveShowProjectDescription().getProjectPath() + LiveShowMediaSystem.FILENAME_MEDIADIRECTORY + "/" + stringNewFileName;
            o_File = new File(stringNewFileName);
            if (o_File.exists()) {
                this.m_MediaSource_Client = LiveShowMediaSystem.createMediaSource(stringNewFileName);
            }
        }
        if (this.m_MediaSource_Client == null && p_LiveShowProjectDescription != null) {
            o_File = new File(stringOldFileName);
            stringNewFileName = o_File.getName();
            stringNewFileName = p_LiveShowProjectDescription.getProjectPath() + LiveShowMediaSystem.FILENAME_MEDIADIRECTORY + "/" + stringNewFileName;
            o_File = new File(stringNewFileName);
            if (o_File.exists()) {
                this.m_MediaSource_Client = LiveShowMediaSystem.createMediaSource(stringNewFileName);
            }
        }
        if (this.m_MediaSource_Client == null) {
            stringNewFileName = s_HasMapFileNewPosition.get(stringOldFileName);
            if ("-".equals(stringNewFileName)) {
                return;
            }
            if (stringNewFileName != null) {
                this.m_MediaSource_Client = LiveShowMediaSystem.createMediaSource(stringNewFileName);
            }
        }
        if (this.m_MediaSource_Client == null && s_LastNewPath != null) {
            o_File = new File(stringOldFileName);
            stringNewFileName = o_File.getName();
            stringNewFileName = s_LastNewPath + "/" + stringNewFileName;
            o_File = new File(stringNewFileName);
            if (o_File.exists()) {
                this.m_MediaSource_Client = LiveShowMediaSystem.createMediaSource(stringNewFileName);
            }
        }
        if (this.m_MediaSource_Client == null) {
            o_File = new File(stringOldFileName);
            if ((o_File = LiveShowMediaSystem.searchLostMediaSourceFile(o_File)) == null) {
                s_HasMapFileNewPosition.put(stringOldFileName, "-");
                return;
            }
            stringNewFileName = o_File.getPath();
            this.m_MediaSource_Client = LiveShowMediaSystem.createMediaSource(stringNewFileName);
            if (this.m_MediaSource_Client != null) {
                s_HasMapFileNewPosition.put(stringOldFileName, stringNewFileName);
                s_LastNewPath = o_File.getParentFile();
            }
        }
        if (this.m_MediaSource_Client == null) {
            o_LiveShowMediaObjectDescription.setMediaType(-1);
            return;
        }
        if (stringNewFileName != null && !"-".equals(stringNewFileName)) {
            o_LiveShowMediaObjectDescription.setSourceString(stringNewFileName);
        }
        this.m_MediaSource_Client.addReference(this);
        if (this.m_MediaSource_Client != null) {
            o_LiveShowMediaObjectDescription.setMediaType(this.m_MediaSource_Client.getMediaType());
            o_LiveShowMediaObjectDescription.setSourceName(this.m_MediaSource_Client.getFile().getName());
            o_LiveShowMediaObjectDescription.setSourceString(this.m_MediaSource_Client.getFile().getPath());
            o_LiveShowMediaObjectDescription.setCheckSum(this.m_MediaSource_Client.getCheckSum());
        } else {
            o_LiveShowMediaObjectDescription.setMediaType(-1);
            o_LiveShowMediaObjectDescription.setSourceName("-");
            o_LiveShowMediaObjectDescription.setSourceString("-");
        }
        this.setDescription((LiveShowObjectDescription)o_LiveShowMediaObjectDescription);
        this.m_Description.setID(o_LiveShowMediaObjectDescription.getID());
        this.m_Description.setSourceName(this.m_MediaSource_Client.getFile().getName());
        this.m_MediaSource_Client.addPropertyChangeListener(this);
        this.m_MediaSource_Client.addMediaSourceListener(this);
        this.requestSnapShots();
    }

    @Override
    public void close(boolean p_Finish) {
        this.clearMediaServers();
        if (this.m_MediaSource_Client != null) {
            this.m_MediaSource_Client.removeMediaSourceListener(this);
            this.m_MediaSource_Client.removePropertyChangeListener(this);
            this.m_MediaSource_Client.removeReference(this, p_Finish);
            this.m_MediaSource_Client = null;
        }
        if (this.m_SnapShot_Start != null) {
            this.m_SnapShot_Start.flush();
            this.m_SnapShot_Start = null;
        }
        if (this.m_SnapShot_Middle != null) {
            this.m_SnapShot_Middle.flush();
            this.m_SnapShot_Middle = null;
        }
        if (this.m_SnapShot_End != null) {
            this.m_SnapShot_End.flush();
            this.m_SnapShot_End = null;
        }
        super.close(p_Finish);
    }

    public void refreshMediaSource() {
        MediaSource_Client o_MediaSource_Client = this.m_MediaSource_Client;
        if (o_MediaSource_Client == null) {
            return;
        }
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = (LiveShowMediaObjectDescription)this.m_Description;
        o_LiveShowMediaObjectDescription.setMediaType(o_MediaSource_Client.getMediaType());
        o_LiveShowMediaObjectDescription.setSourceName(o_MediaSource_Client.getFile().getName());
        o_LiveShowMediaObjectDescription.setSourceString(o_MediaSource_Client.getFile().getPath());
        o_LiveShowMediaObjectDescription.setFrameStartOffset(0L);
        o_LiveShowMediaObjectDescription.setCheckSum(o_MediaSource_Client.getCheckSum());
        this.m_SnapShot_Start_Frame = -1L;
        this.m_SnapShot_Middle_Frame = -1L;
        this.m_SnapShot_End_Frame = -1L;
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer = o_MediaSource_Client.getLiveShow_MediaPlayer();
        if (o_LiveShow_MediaPlayer == null) {
            return;
        }
        if (o_LiveShow_MediaPlayer.getSnapShotUseOriginal()) {
            this.m_SnapShot_Start = null;
            this.m_SnapShot_Middle = null;
            this.m_SnapShot_End = null;
        }
        this.requestSnapShots();
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    public MediaSource getMediaSource() {
        return this.m_MediaSource_Client;
    }

    public void setMediaSource(MediaSource_Client p_MediaSource_Client) {
        if (p_MediaSource_Client == null) {
            return;
        }
        if (p_MediaSource_Client == this.m_MediaSource_Client) {
            return;
        }
        if (this.m_MediaSource_Client != null) {
            this.m_MediaSource_Client.removeMediaSourceListener(this);
            this.m_MediaSource_Client.removePropertyChangeListener(this);
            this.m_MediaSource_Client.removeReference(this, true);
        }
        this.m_MediaSource_Client = p_MediaSource_Client;
        if (this.m_MediaSource_Client != null) {
            this.m_MediaSource_Client.addMediaSourceListener(this);
            this.m_MediaSource_Client.addPropertyChangeListener(this);
            this.m_MediaSource_Client.addReference(this);
            this.refreshMediaSource();
        }
    }

    public void initCheckMediaServer(LiveShowMediaObjectDescription p_LiveShowMediaObjectDescription) {
        int intMediaServerCount = p_LiveShowMediaObjectDescription.getMediaServerIDCount();
        for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
            MediaServer o_MediaServer;
            String stringMediaServerID = p_LiveShowMediaObjectDescription.getMediaServerID(intMediaServer);
            if (stringMediaServerID == null || (o_MediaServer = MediaServer.getMediaServer(stringMediaServerID)) == null) continue;
            o_MediaServer.addLiveShowMediaObject(this);
            this.addMediaServer(o_MediaServer);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public boolean exportExternal(ObjectOutput out, LiveShowProjectDescription p_LiveShowProjectDescription, String p_ReplaceName) throws IOException {
        File o_NewFile = null;
        String stringNewFileNameBase = "Unkwown";
        long longLastModification = 0L;
        boolean boolMustCopyFile = true;
        boolean boolCopiedPrior = false;
        boolean boolCopyOK = true;
        String stringOldFilePathName = this.m_Description.getSourceString();
        if (stringOldFilePathName == null) {
            return false;
        }
        File o_OldFile = new File(stringOldFilePathName);
        String stringOldFileNameBase = FileTools.getFileNameBase(o_OldFile);
        String stringOldPath = FileTools.getPathName(o_OldFile);
        String stringFileNameWithoutPath = p_ReplaceName != null ? p_ReplaceName : o_OldFile.getName();
        if (!o_OldFile.exists()) {
            boolMustCopyFile = false;
        }
        if (LiveShowMediaSystem.exportedFileList_Contains(o_OldFile) && LiveShowMediaSystem.exported_FileList_CheckSum(o_OldFile).equals(FileTools.getCheckSum_MD5_Partial(o_OldFile))) {
            boolCopiedPrior = true;
        }
        String stringNewPath = p_LiveShowProjectDescription.getProjectPath();
        File o_NewDirectory = new File(stringNewPath + LiveShowMediaSystem.FILENAME_MEDIADIRECTORY);
        if (boolMustCopyFile && !boolCopiedPrior) {
            o_NewFile = FileTools.copyFileTo(o_OldFile, o_NewDirectory, stringFileNameWithoutPath, true);
            if (o_NewFile == null) {
                boolCopyOK = false;
                System.out.println("LiveShowMediadVIP Cannot copy media file: " + this.getSourceName());
            }
            if (boolCopyOK) {
                stringFileNameWithoutPath = o_NewFile.getName();
                stringNewFileNameBase = FileTools.getFileNameBase(o_NewFile);
                LiveShowMediaSystem.exportedFileList_Add(o_OldFile);
            }
        }
        if (boolCopyOK && !boolCopiedPrior) {
            stringOldFilePathName = stringOldPath + "/" + stringOldFileNameBase + ".lsm";
            o_OldFile = new File(stringOldFilePathName);
            FileTools.copyFileTo(o_OldFile, o_NewDirectory, stringNewFileNameBase + ".lsm", true);
        }
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = (LiveShowMediaObjectDescription)this.m_Description.clone(null);
        if (boolCopyOK) {
            o_LiveShowMediaObjectDescription.setSourceString(stringFileNameWithoutPath);
            o_LiveShowMediaObjectDescription.setSourceName(stringFileNameWithoutPath);
        }
        o_LiveShowMediaObjectDescription.writeExternal(out);
        o_LiveShowMediaObjectDescription.close(true);
        return boolCopyOK;
    }

    public void setProducer(String p_Producer) {
        ((LiveShowMediaObjectDescription)this.m_Description).setProducer(p_Producer);
    }

    public String getProducer() {
        return ((LiveShowMediaObjectDescription)this.m_Description).getProducer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMediaServerCount() {
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            return this.m_MediaServers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaServer getMediaServer(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            if (p_Index >= this.m_MediaServers.size()) {
                return null;
            }
            return this.m_MediaServers.get(p_Index);
        }
    }

    public String getMediaServerID(int p_Index) {
        return ((LiveShowMediaObjectDescription)this.m_Description).getMediaServerID(p_Index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaServer(MediaServer p_MediaServer) {
        if (p_MediaServer == null) {
            return;
        }
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            for (int intMediaServer = 0; intMediaServer < this.m_MediaServers.size(); ++intMediaServer) {
                MediaServer o_MediaServer = this.m_MediaServers.get(intMediaServer);
                if (o_MediaServer != p_MediaServer) continue;
                return;
            }
            this.m_MediaServers.add(p_MediaServer);
        }
        ((LiveShowMediaObjectDescription)this.m_Description).addMediaServerID_Connection(p_MediaServer.getID(), p_MediaServer.getServerURL(), p_MediaServer.getServerPort());
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        p_MediaServer.addLiveShowMediaObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaServer_BySettings(MediaServer p_MediaServer) {
        if (p_MediaServer == null) {
            return;
        }
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            for (int intMediaServer = 0; intMediaServer < this.m_MediaServers.size(); ++intMediaServer) {
                MediaServer o_MediaServer = this.m_MediaServers.get(intMediaServer);
                if (o_MediaServer != p_MediaServer) continue;
                return;
            }
            this.m_MediaServers.add(p_MediaServer);
        }
        p_MediaServer.addLiveShowMediaObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaServer(MediaServer p_MediaServer) {
        if (p_MediaServer == null) {
            return;
        }
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            this.m_MediaServers.remove(p_MediaServer);
        }
        p_MediaServer.removeLiveShowMediaObject(this);
        ((LiveShowMediaObjectDescription)this.m_Description).removeMediaServerID_Connection(p_MediaServer.getID());
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaServer_BySettings(MediaServer p_MediaServer) {
        if (p_MediaServer == null) {
            return;
        }
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            this.m_MediaServers.remove(p_MediaServer);
        }
        p_MediaServer.removeLiveShowMediaObject(this);
    }

    public void clearMediaServers() {
        for (int intMediaServer = this.m_MediaServers.size() - 1; intMediaServer >= 0; --intMediaServer) {
            MediaServer o_MediaServer = this.getMediaServer(intMediaServer);
            if (o_MediaServer == null) continue;
            this.removeMediaServer(o_MediaServer);
        }
    }

    public void setMediaObjectParams_BySettings(LiveShowMediaObjectDescription p_LiveShowMediaObjectDescription) {
        String stringMediaServerID;
        MediaServer o_MediaServer;
        int intMediaServer;
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = (LiveShowMediaObjectDescription)this.m_Description;
        int intMediaServerCount = this.m_MediaServers.size();
        for (intMediaServer = intMediaServerCount - 1; intMediaServer >= 0; --intMediaServer) {
            o_MediaServer = this.m_MediaServers.get(intMediaServer);
            if (o_MediaServer == null) {
                return;
            }
            stringMediaServerID = o_MediaServer.getID();
            if (p_LiveShowMediaObjectDescription.containsMediaServerID(stringMediaServerID)) continue;
            this.removeMediaServer(o_MediaServer);
        }
        intMediaServerCount = p_LiveShowMediaObjectDescription.getMediaServerIDCount();
        for (intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
            stringMediaServerID = p_LiveShowMediaObjectDescription.getMediaServerID(intMediaServer);
            o_MediaServer = MediaServer.getMediaServer(stringMediaServerID);
            this.addMediaServer(o_MediaServer);
        }
        boolean boolChenged = false;
        LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP();
        if (o_LiveShowMediaObjectDescription.getMediaZOrder() != p_LiveShowMediaObjectDescription.getMediaZOrder()) {
            LiveShowVIPTrack o_LiveShowVIPTrack;
            if (o_LiveShowVIP != null && p_LiveShowMediaObjectDescription.getMediaZOrder() >= 0 && p_LiveShowMediaObjectDescription.getMediaZOrder() < o_LiveShowVIP.getLiveShowVipTrackCount() && (o_LiveShowVIPTrack = o_LiveShowVIP.getLiveShowVIPTrack(o_LiveShowMediaObjectDescription.getVIPTrackNumber())) != null) {
                o_LiveShowVIPTrack.removeLiveShowObjectInterface(this);
                o_LiveShowVIPTrack = o_LiveShowVIP.getLiveShowVIPTrack(p_LiveShowMediaObjectDescription.getMediaZOrder());
                if (o_LiveShowVIPTrack != null) {
                    o_LiveShowVIPTrack.addLiveShowObjectInterface(this, p_LiveShowMediaObjectDescription.getFrameStart());
                }
            }
            boolChenged = true;
        }
        if (o_LiveShowMediaObjectDescription.copyMediaObjectParamFrom(p_LiveShowMediaObjectDescription)) {
            boolChenged = true;
        }
        if (boolChenged) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    @Override
    public double getFrameTime() {
        return LiveShowVIP.FRAMETIME;
    }

    public BufferedImage getSnapShot_Start() {
        return this.m_SnapShot_Start;
    }

    public BufferedImage getSnapShot_Middle() {
        return this.m_SnapShot_Middle;
    }

    public BufferedImage getSnapShot_End() {
        return this.m_SnapShot_End;
    }

    public Rectangle getSnapShotOriginSize() {
        return this.m_SnapShotOriginSize;
    }

    public Dimension getSourceSize() {
        MediaSource_Client o_MediaSource_Client = this.m_MediaSource_Client;
        if (o_MediaSource_Client == null) {
            return null;
        }
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer = o_MediaSource_Client.getLiveShow_MediaPlayer();
        if (o_LiveShow_MediaPlayer == null) {
            return null;
        }
        return o_LiveShow_MediaPlayer.getSourceSize();
    }

    public Dimension getPlayerGrabSize() {
        MediaSource_Client o_MediaSource_Client = this.m_MediaSource_Client;
        if (o_MediaSource_Client == null) {
            return null;
        }
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer = o_MediaSource_Client.getLiveShow_MediaPlayer();
        if (o_LiveShow_MediaPlayer == null) {
            return null;
        }
        return o_LiveShow_MediaPlayer.getPlayerGrabSize();
    }

    public float getMediaSoundVolume() {
        return ((LiveShowMediaObjectDescription)this.m_Description).getMediaSoundVolume();
    }

    @Override
    public long getSourceFrameLength() {
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = (LiveShowMediaObjectDescription)this.m_Description;
        if (o_LiveShowMediaObjectDescription.getMediaType() == 1001) {
            return -1L;
        }
        if (o_LiveShowMediaObjectDescription.getMediaType() == 1003) {
            return -1L;
        }
        MediaSource_Client o_MediaSource_Client = this.m_MediaSource_Client;
        if (o_MediaSource_Client == null) {
            return -1L;
        }
        long longMilliseconds = o_MediaSource_Client.getLength_Milliseconds();
        if (longMilliseconds < 0L) {
            return -1L;
        }
        if (this.getFrameTime() <= 0.0) {
            return 0L;
        }
        long longFrameLength = (long)((double)longMilliseconds / this.getFrameTime() + 0.5);
        return longFrameLength;
    }

    @Override
    public LiveShowObjectPanel createLiveShowObjectPanel(boolean p_Resizable) {
        LiveShowMediaObjectPanel o_LiveShowMediaObjectPanel = new LiveShowMediaObjectPanel(this, p_Resizable);
        return o_LiveShowMediaObjectPanel;
    }

    @Override
    public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        if (p_Play == null) {
            this.m_IsPlaying = false;
            return null;
        }
        if (p_PlayObject == null) {
            this.m_IsPlaying = false;
            return null;
        }
        if (p_PlayObject.getData() == null) {
            this.m_IsPlaying = false;
            return null;
        }
        boolean boolIsRunning = p_Play.isRunning();
        boolean boolFadeIn = false;
        boolean boolFadeOut = false;
        PlayMedia.MediaPlayObject o_MediaPlayObject = (PlayMedia.MediaPlayObject)p_PlayObject;
        MediaObject_PlayStatus.ObjectPlayStatus o_ObjectPlayStatus = o_MediaPlayObject.getObjectPlayStatus(this.getID());
        if (o_ObjectPlayStatus == null) {
            return null;
        }
        LiveShowMediaVIP o_LiveShowMediaVIP = LiveShowMediaSystem.getLiveShowMediaVIP();
        if (o_LiveShowMediaVIP != null && !o_LiveShowMediaVIP.getActive()) {
            o_ObjectPlayStatus.setIsPlaying(false, p_IsPreObject);
            return null;
        }
        if (p_LiveShowSceneBridge != null) {
            if (p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart()) && p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart() + this.getFrameLength() - 1L)) {
                if (p_IsPreObject) {
                    o_ObjectPlayStatus.setIsPlaying(false, p_IsPreObject);
                    return null;
                }
            } else if (p_IsPreObject) {
                if (!p_LiveShowSceneBridge.getPlayPreObject() && this.getMediaSource().getMediaType() == 1002) {
                    o_ObjectPlayStatus.setIsPlaying(false, p_IsPreObject);
                    return null;
                }
                if (p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart()) && p_PlayObject.getFramePosition() < p_LiveShowSceneBridge.getFrameStart() + p_LiveShowSceneBridge.getFrameLength()) {
                    o_ObjectPlayStatus.setIsPlaying(false, p_IsPreObject);
                    return null;
                }
                LiveShowSceneBridge o_ExcludedLiveShowSceneBridge = null;
                LiveShowVIP o_LiveShowVIP = p_LiveShowSceneBridge.getLiveShowVIP();
                if (o_LiveShowVIP != null) {
                    o_ExcludedLiveShowSceneBridge = o_LiveShowVIP.getLiveShowSceneBridge_Exluded();
                }
                if (o_ExcludedLiveShowSceneBridge != null && this.getFrameStart() >= o_ExcludedLiveShowSceneBridge.getFrameStart()) {
                    o_ObjectPlayStatus.setIsPlaying(false, p_IsPreObject);
                    return null;
                }
            } else if (p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart() + this.getFrameLength() - 1L)) {
                o_ObjectPlayStatus.setIsPlaying(false, p_IsPreObject);
                return null;
            }
            if (p_IsPreObject) {
                boolFadeOut = true;
            } else {
                boolFadeIn = true;
            }
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            o_ObjectPlayStatus.setIsPlaying(false, p_IsPreObject);
            return null;
        }
        long longFramePosition = p_PlayObject.getFramePosition();
        long longFramesToRead = p_PlayObject.getFramesToRead();
        if (longFramePosition < this.m_Description.getFrameStart()) {
            this.m_ResetWas_InFront = true;
            if (this.m_ResetWas_Behind) {
                this.m_ResetPrefetchDone_Pre = false;
            }
            this.m_ResetWas_Behind = false;
            if (p_LiveShowSceneBridge == null) {
                if (!this.m_ResetPrefetchDone_Pre && o_LiveShowMediaVIP != null) {
                    LiveShowSceneBridge o_LiveShowSceneBridge_Previous = null;
                    LiveShowSceneBridge o_LiveShowSceneBridge_Next = o_LiveShowMediaVIP.getLiveShowSceneBridge_Next(this.m_Description.getFrameStart(), false, true);
                    this.resetPrefetchBuffer_SceneBridge(o_LiveShowSceneBridge_Previous, o_LiveShowSceneBridge_Next, p_IsPreObject, o_MediaPlayObject);
                }
                if (!this.m_ResetPrefetchDone) {
                    this.resetPrefetchBuffer(0L, o_MediaPlayObject);
                }
            }
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            this.m_IsPlaying = false;
            o_ObjectPlayStatus.setIsPlaying(false, p_IsPreObject);
            o_ObjectPlayStatus.setPlayStatus(boolIsRunning, p_IsPreObject, this.getFrameStartOffset(), 0.0f, 0.0, false, false);
            return null;
        }
        if (longFramePosition >= this.m_Description.getFrameStart() + this.getFrameLength()) {
            this.m_ResetWas_Behind = true;
            if (this.m_ResetWas_InFront) {
                this.m_ResetPrefetchDone_Pre = false;
            }
            this.m_ResetWas_InFront = false;
            if (p_LiveShowSceneBridge == null) {
                if (!this.m_ResetPrefetchDone_Pre && o_LiveShowMediaVIP != null) {
                    LiveShowSceneBridge o_LiveShowSceneBridge_Previous = o_LiveShowMediaVIP.getLiveShowSceneBridge_Previous(this.m_Description.getFrameStart() + this.getFrameLength(), false, true);
                    LiveShowSceneBridge o_LiveShowSceneBridge_Next = null;
                    this.resetPrefetchBuffer_SceneBridge(o_LiveShowSceneBridge_Previous, o_LiveShowSceneBridge_Next, p_IsPreObject, o_MediaPlayObject);
                }
                if (!this.m_ResetPrefetchDone) {
                    this.resetPrefetchBuffer(0L, o_MediaPlayObject);
                }
            }
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            this.m_IsPlaying = false;
            o_ObjectPlayStatus.setIsPlaying(false, p_IsPreObject);
            o_ObjectPlayStatus.setPlayStatus(boolIsRunning, p_IsPreObject, this.getFrameStartOffset(), 0.0f, 0.0, false, false);
            return null;
        }
        this.m_ResetPrefetchDone_Pre = false;
        this.m_ResetPrefetchDone = false;
        this.m_IsPlaying = true;
        if (p_LiveShowSceneBridge != null) {
            if (this.m_LiveShowSceneBridge != p_LiveShowSceneBridge) {
                o_ObjectPlayStatus.switchPlayers();
            }
            this.m_LiveShowSceneBridge = p_LiveShowSceneBridge;
        } else if (this.m_LiveShowSceneBridge != null && !this.m_LiveShowSceneBridge.getIsPlaying()) {
            if (o_LiveShowMediaVIP != null) {
                LiveShowSceneBridge o_LiveShowSceneBridge_Previous = null;
                LiveShowSceneBridge o_LiveShowSceneBridge_Next = o_LiveShowMediaVIP.getLiveShowSceneBridge_Next(this.m_LiveShowSceneBridge, false, true);
                if (o_LiveShowSceneBridge_Next != null && this.m_Description.getFrameStart() + this.getFrameLength() <= o_LiveShowSceneBridge_Next.getFrameStart()) {
                    if (o_LiveShowSceneBridge_Next.getJumpActive()) {
                        if ((o_LiveShowSceneBridge_Next = o_LiveShowSceneBridge_Next.getJumpSceneBridge()) != null && this.m_Description.getFrameStart() + this.getFrameLength() <= o_LiveShowSceneBridge_Next.getFrameStart()) {
                            o_LiveShowSceneBridge_Next = null;
                        }
                    } else {
                        o_LiveShowSceneBridge_Next = null;
                    }
                }
                if (o_LiveShowSceneBridge_Next == null) {
                    o_LiveShowSceneBridge_Previous = this.m_LiveShowSceneBridge;
                }
                this.resetPrefetchBuffer_SceneBridge(o_LiveShowSceneBridge_Previous, o_LiveShowSceneBridge_Next, true, o_MediaPlayObject);
            }
            this.m_LiveShowSceneBridge = null;
        }
        boolean boolInside = false;
        double doubleFadeInFactor = 1.0;
        double doubleFadeOutFactor = 0.0;
        double doubleFadeFactor = 1.0;
        float floatVolumeFactor = 1.0f;
        long longFramePositionInside = longFramePosition - this.m_Description.getFrameStart();
        if (longFramePositionInside >= 0L && longFramePositionInside < this.getFrameLengthToPlay()) {
            boolInside = true;
        }
        if (boolInside) {
            doubleFadeInFactor = 1.0;
            long longFrameFromEndPosition = this.getFrameLengthToPlay() - longFramePositionInside;
            long longFrameFromStartPosition = longFramePositionInside > this.getFrameLengthToPlay() - this.m_Description.getFrameFadeOutLength() ? this.getFrameLengthToPlay() - this.m_Description.getFrameFadeOutLength() : longFramePositionInside;
            floatVolumeFactor = this.m_Description.getVolumeFactor_Linear();
            if (this.m_Description.getFrameFadeInLength() > 0L && longFrameFromStartPosition < this.m_Description.getFrameFadeInLength()) {
                doubleFadeInFactor = (double)(longFrameFromStartPosition + (longFramesToRead - 1L)) / (double)this.m_Description.getFrameFadeInLength();
                if (doubleFadeInFactor > 1.0) {
                    doubleFadeInFactor = 1.0;
                }
                if (doubleFadeInFactor < 1.0E-4) {
                    doubleFadeInFactor = 0.0;
                }
                boolFadeIn = true;
            }
            doubleFadeOutFactor = 1.0;
            if (this.m_Description.getFrameFadeOutLength() > 0L && longFrameFromEndPosition < this.m_Description.getFrameFadeOutLength()) {
                doubleFadeOutFactor = (double)(longFrameFromEndPosition - (longFramesToRead - 1L)) / (double)this.m_Description.getFrameFadeOutLength();
                if (doubleFadeOutFactor > 1.0) {
                    doubleFadeOutFactor = 1.0;
                }
                if (doubleFadeOutFactor < 1.0E-4) {
                    doubleFadeOutFactor = 0.0;
                }
                boolFadeOut = true;
            }
        } else {
            boolIsRunning = false;
            longFramePositionInside = 0L;
            doubleFadeInFactor = 0.0;
            doubleFadeOutFactor = 0.0;
            doubleFadeFactor = 0.0;
            boolFadeIn = false;
            boolFadeOut = false;
            floatVolumeFactor = 0.0f;
        }
        if (doubleFadeOutFactor == 0.0) {
            doubleFadeInFactor = 0.0;
        }
        doubleFadeFactor = doubleFadeInFactor * doubleFadeOutFactor;
        o_MediaPlayObject.setFadeInProgress(doubleFadeInFactor);
        o_MediaPlayObject.setFadeOutProgress(doubleFadeOutFactor);
        o_ObjectPlayStatus.setPlayStatus(boolIsRunning, p_IsPreObject, longFramePositionInside + this.getFrameStartOffset(), floatVolumeFactor, doubleFadeFactor, boolFadeIn, boolFadeOut);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_MediaPlayObject;
    }

    public void resetPrefetchBuffer(long p_FrameInside, PlayMedia.MediaPlayObject p_MediaPlayObject) {
        MediaObject_PlayStatus.ObjectPlayStatus o_ObjectPlayStatus;
        this.m_ResetPrefetchDone = true;
        if (p_MediaPlayObject == null) {
            return;
        }
        if (this.m_ResetPrefetchDone && this.m_ResetPrefetchDone_Pre) {
            this.m_ResetRestart = false;
        }
        if ((o_ObjectPlayStatus = p_MediaPlayObject.getObjectPlayStatus(this.getID())) != null) {
            o_ObjectPlayStatus.setPlayStatus(false, false, p_FrameInside + this.getFrameStartOffset(), 0.0f, 0.0, false, false);
        }
    }

    private void resetPrefetchBuffer_SceneBridge(LiveShowSceneBridge p_PreviousSceneBridge, LiveShowSceneBridge p_NextSceneBridge, boolean p_IsPreObject, PlayMedia.MediaPlayObject p_MediaPlayObject) {
        MediaObject_PlayStatus.ObjectPlayStatus o_ObjectPlayStatus;
        LiveShowSceneBridge o_LiveShowSceneBridge;
        this.m_ResetPrefetchDone_Pre = true;
        if (p_MediaPlayObject == null) {
            return;
        }
        if (this.m_ResetPrefetchDone && this.m_ResetPrefetchDone_Pre) {
            this.m_ResetRestart = false;
        }
        if (p_PreviousSceneBridge != null) {
            if (p_PreviousSceneBridge.getFrameStart() > this.getFrameStart() + this.getFrameLength()) {
                p_PreviousSceneBridge = null;
            } else if (p_PreviousSceneBridge.getFrameStart() + this.getFrameLength() < this.getFrameStart()) {
                p_PreviousSceneBridge = null;
            }
        }
        if ((o_LiveShowSceneBridge = p_NextSceneBridge) != null) {
            if (o_LiveShowSceneBridge.getFrameStart() > this.getFrameStart() + this.getFrameLength()) {
                o_LiveShowSceneBridge = null;
            } else if (o_LiveShowSceneBridge.getFrameStart() + o_LiveShowSceneBridge.getFrameLength() < this.getFrameStart()) {
                o_LiveShowSceneBridge = null;
            } else if (p_PreviousSceneBridge != null ? p_MediaPlayObject.getFramePosition() < p_PreviousSceneBridge.getFrameStart() + p_PreviousSceneBridge.getFrameLength() : p_MediaPlayObject.getFramePosition() >= o_LiveShowSceneBridge.getFrameStart()) {
                return;
            }
        }
        if (o_LiveShowSceneBridge == null) {
            o_LiveShowSceneBridge = p_PreviousSceneBridge;
        }
        if ((o_ObjectPlayStatus = p_MediaPlayObject.getObjectPlayStatus(this.getID())) == null) {
            return;
        }
        if (o_LiveShowSceneBridge != null) {
            o_ObjectPlayStatus.setPlayStatus(false, true, o_LiveShowSceneBridge.getFrameStart() - this.getFrameStart() + this.getFrameStartOffset(), 0.0f, 0.0, false, false);
        } else {
            o_ObjectPlayStatus.setPlayStatus(false, true, this.getFrameStartOffset(), 0.0f, 0.0, false, false);
        }
    }

    @Override
    public void refreshJumps() {
    }

    @Override
    public String createToolTipText(boolean p_Complete) {
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer;
        StringBuffer o_StringBuffer = new StringBuffer();
        if (p_Complete) {
            o_StringBuffer.append("<html>");
        }
        if (this.m_MediaServers.size() <= 0) {
            o_StringBuffer.append("<center>");
            o_StringBuffer.append(LiveShowMediaSystem.MEDIASERVER);
            o_StringBuffer.append(": ");
            o_StringBuffer.append("<font color=\"#FF0000\">");
            o_StringBuffer.append("<b>---</b>");
            o_StringBuffer.append("</font>");
            o_StringBuffer.append("</center>");
            o_StringBuffer.append("<br>");
        } else {
            for (int intMediaServer = 0; intMediaServer < this.m_MediaServers.size(); ++intMediaServer) {
                MediaServer o_MediaServer = this.getMediaServer(intMediaServer);
                o_StringBuffer.append("<center>");
                o_StringBuffer.append(LiveShowMediaSystem.MEDIASERVER);
                o_StringBuffer.append(": ");
                if (o_MediaServer == null) {
                    o_StringBuffer.append("<font color=\"#FF0000\">");
                    o_StringBuffer.append("<b>---</b>");
                    o_StringBuffer.append("</font>");
                } else if (!o_MediaServer.isConnected()) {
                    o_StringBuffer.append("<b> ");
                    o_StringBuffer.append("<font color=\"#FF0000\">");
                    o_StringBuffer.append(o_MediaServer.getName());
                    o_StringBuffer.append(" ");
                    o_StringBuffer.append(LiveShowMediaSystem.MEDIASERVER_NOTCONNECTED);
                    o_StringBuffer.append("</font>");
                    o_StringBuffer.append("</b>");
                } else {
                    o_StringBuffer.append("<b> ");
                    o_StringBuffer.append("<font color=\"#00FF00\">");
                    o_StringBuffer.append(o_MediaServer.getName());
                    o_StringBuffer.append("</font>");
                    o_StringBuffer.append("</b>");
                }
                o_StringBuffer.append("</center>");
                o_StringBuffer.append("<br>");
            }
        }
        o_StringBuffer.append("<center>");
        o_StringBuffer.append("ZOrder: ");
        o_StringBuffer.append(this.getMediaZOrder());
        o_StringBuffer.append("<br>");
        o_StringBuffer.append("</center>");
        o_StringBuffer.append("<br>");
        o_StringBuffer.append("<center>");
        if (this.m_MediaSource_Client != null) {
            o_StringBuffer.append(this.m_MediaSource_Client.getMediaTypeName());
        }
        o_StringBuffer.append("<br>");
        o_StringBuffer.append("</center>");
        o_StringBuffer.append(super.createToolTipText(false));
        if (this.m_MediaSource_Client != null && (o_LiveShow_MediaPlayer = this.m_MediaSource_Client.getLiveShow_MediaPlayer()) != null && o_LiveShow_MediaPlayer.getSourceSize().width != 0 && o_LiveShow_MediaPlayer.getSourceSize().height != 0) {
            o_StringBuffer.append("<center>");
            o_StringBuffer.append("<br>");
            o_StringBuffer.append(o_LiveShow_MediaPlayer.getSourceSize().width);
            o_StringBuffer.append(" px");
            o_StringBuffer.append(" x ");
            o_StringBuffer.append(o_LiveShow_MediaPlayer.getSourceSize().height);
            o_StringBuffer.append(" px");
            o_StringBuffer.append("</center>");
        }
        if (p_Complete) {
            o_StringBuffer.append("</html>");
        }
        return o_StringBuffer.toString();
    }

    @Override
    public String getSourceAdditionalInfo() {
        MediaSource_Client o_MediaSource = this.m_MediaSource_Client;
        if (o_MediaSource == null) {
            return null;
        }
        File o_FileSource = o_MediaSource.getFile();
        if (o_FileSource == null) {
            return null;
        }
        File o_FileParent = o_FileSource.getParentFile();
        return o_FileParent.getAbsolutePath();
    }

    @Override
    public void setSource(Object p_SourceObject) {
        this.setMediaSource((MediaSource_Client)p_SourceObject);
    }

    @Override
    public Object getSource() {
        return this.m_MediaSource_Client;
    }

    @Override
    public ImageIcon getImageIcon() {
        return s_Icon;
    }

    @Override
    public ComboBoxModel getSourceListModel() {
        return LiveShowMediaSystem.getMediaSourceListModel_ImagesText();
    }

    @Override
    public boolean getSourceIsReplaceable() {
        MediaSource_Client o_MediaSource_Client = this.m_MediaSource_Client;
        if (o_MediaSource_Client == null) {
            return false;
        }
        if (o_MediaSource_Client.getMediaType() == 1001) {
            return true;
        }
        if (o_MediaSource_Client.getMediaType() == 1002) {
            return false;
        }
        return o_MediaSource_Client.getMediaType() == 1003;
    }

    @Override
    public DefaultListCellRenderer getSourceListRenderer() {
        return MediaSource.getMediaSourceListRenderer();
    }

    @Override
    public boolean getFrameOffsetAbility() {
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = (LiveShowMediaObjectDescription)this.m_Description;
        if (o_LiveShowMediaObjectDescription.getMediaType() == 1001) {
            return false;
        }
        if (o_LiveShowMediaObjectDescription.getMediaType() == 1002) {
            return true;
        }
        if (o_LiveShowMediaObjectDescription.getMediaType() == 1003) {
            return false;
        }
        return false;
    }

    @Override
    public LiveShowVIP getLiveShowVIP() {
        return LiveShowMediaSystem.getLiveShowMediaVIP();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName())) {
            this.setName((String)evt.getNewValue());
        } else if ("sourceName".equals(evt.getPropertyName())) {
            this.setSourceName((String)evt.getNewValue());
        } else if ("liveShowObject_SourceClose".equals(evt.getPropertyName())) {
            this.close(true);
        }
    }

    @Override
    public void setObjectParams(long p_StartFramePosition, long p_FrameStartOffset, long p_FrameLength, long p_FrameFadeInLength, long p_FrameFadeInOffset, long p_FrameFadeOutLength, long p_FrameFadeOutOffset, float p_VolumeFactor) {
        boolean boolRequestSnapShots = false;
        if (this.getFrameStartOffset() != p_FrameStartOffset || this.getFrameLength() != p_FrameLength) {
            boolRequestSnapShots = true;
        }
        super.setObjectParams(p_StartFramePosition, p_FrameStartOffset, p_FrameLength, p_FrameFadeInLength, p_FrameFadeInOffset, p_FrameFadeOutLength, p_FrameFadeOutOffset, p_VolumeFactor);
        if (boolRequestSnapShots) {
            this.requestSnapShots();
        }
    }

    @Override
    public void setVIPTrackNumber(int p_VIPTrackNumber) {
        if (this.m_Description.getVIPTrackNumber() == p_VIPTrackNumber) {
            return;
        }
        int intOldVIPTrackNumber = this.getVIPTrackNumber();
        if (!this.getIsJingle() && intOldVIPTrackNumber < 0) {
            ((LiveShowMediaObjectDescription)this.m_Description).setMediaZOrder(p_VIPTrackNumber);
        } else {
            int intMediaZOrder;
            LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP();
            if (o_LiveShowVIP != null && (intMediaZOrder = this.getMediaZOrder()) >= 0 && intMediaZOrder < o_LiveShowVIP.getLiveShowVipTrackCount()) {
                ((LiveShowMediaObjectDescription)this.m_Description).setMediaZOrder(p_VIPTrackNumber);
            }
        }
        super.setVIPTrackNumber(p_VIPTrackNumber);
    }

    public int getMediaZOrder() {
        if (this.m_Description == null) {
            return -1;
        }
        return ((LiveShowMediaObjectDescription)this.m_Description).getMediaZOrder();
    }

    public boolean setMediaZOrder(int p_ZOrder) {
        if (this.m_Description == null) {
            return false;
        }
        boolean boolChanged = false;
        boolChanged = ((LiveShowMediaObjectDescription)this.m_Description).setMediaZOrder(p_ZOrder);
        if (boolChanged) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
        return boolChanged;
    }

    public void requestSnapShots() {
        if (this.m_Runnable_RequestSnapShots == null) {
            this.m_Runnable_RequestSnapShots = new Runnable(){
                LiveShowMediaObjectDescription m_LiveShowMediaObjectDescription;

                @Override
                public void run() {
                    long longMilliseconds;
                    long longPosition;
                    MediaSource_Client o_MediaSource_Client = LiveShowMediaObject.this.m_MediaSource_Client;
                    if (o_MediaSource_Client == null) {
                        return;
                    }
                    LiveShow_MediaPlayer o_LiveShow_MediaPlayer = o_MediaSource_Client.getLiveShow_MediaPlayer();
                    if (o_LiveShow_MediaPlayer == null) {
                        return;
                    }
                    if (LiveShowMediaObject.this.getFrameLength() <= 0L) {
                        return;
                    }
                    this.m_LiveShowMediaObjectDescription = (LiveShowMediaObjectDescription)LiveShowMediaObject.this.m_Description;
                    if (this.m_LiveShowMediaObjectDescription.getMediaType() == 1002 && (longPosition = LiveShowMediaObject.this.m_Description.getFrameStartOffset()) != LiveShowMediaObject.this.m_SnapShot_Start_Frame) {
                        longMilliseconds = (long)(LiveShowMediaObject.this.getFrameTime() * (double)longPosition + 0.5);
                        o_LiveShow_MediaPlayer.requestSnapshot(LiveShowMediaObject.this.getID() + "_start", LiveShowMediaObject.this.m_SnapShot_Start, longMilliseconds, (LiveShow_MediaPlayer.SnapshotEventListener)LiveShowMediaObject.this.m_SelfReference);
                        LiveShowMediaObject.this.m_SnapShot_Start_Frame = longPosition;
                    }
                    if ((longPosition = LiveShowMediaObject.this.m_Description.getFrameStartOffset() + LiveShowMediaObject.this.getFrameLength() / 2L) != LiveShowMediaObject.this.m_SnapShot_Middle_Frame) {
                        longMilliseconds = (long)(LiveShowMediaObject.this.getFrameTime() * (double)longPosition + 0.5);
                        o_LiveShow_MediaPlayer.requestSnapshot(LiveShowMediaObject.this.getID() + "_middle", LiveShowMediaObject.this.m_SnapShot_Middle, longMilliseconds, (LiveShow_MediaPlayer.SnapshotEventListener)LiveShowMediaObject.this.m_SelfReference);
                        LiveShowMediaObject.this.m_SnapShot_Middle_Frame = longPosition;
                    }
                    if (this.m_LiveShowMediaObjectDescription.getMediaType() == 1002 && (longPosition = LiveShowMediaObject.this.m_Description.getFrameStartOffset() + LiveShowMediaObject.this.getFrameLength()) != LiveShowMediaObject.this.m_SnapShot_End_Frame) {
                        longMilliseconds = (long)(LiveShowMediaObject.this.getFrameTime() * (double)longPosition + 0.5);
                        o_LiveShow_MediaPlayer.requestSnapshot(LiveShowMediaObject.this.getID() + "_end", LiveShowMediaObject.this.m_SnapShot_End, longMilliseconds, (LiveShow_MediaPlayer.SnapshotEventListener)LiveShowMediaObject.this.m_SelfReference);
                        LiveShowMediaObject.this.m_SnapShot_End_Frame = longPosition;
                    }
                }
            };
        }
        JobHandler.addJob(this.m_Runnable_RequestSnapShots);
    }

    public void eventSnapshotImage(String p_ID, long p_Milliseconds, Image p_Image, Rectangle p_SnapShotOriginSize) {
        this.m_SnapShotOriginSize.setRect(p_SnapShotOriginSize);
        if (!(p_Image instanceof BufferedImage)) {
            return;
        }
        if (p_ID == null) {
            return;
        }
        if (p_ID.equals(this.getID() + "_start")) {
            this.m_SnapShot_Start = (BufferedImage)p_Image;
        }
        if (p_ID.equals(this.getID() + "_middle")) {
            this.m_SnapShot_Middle = (BufferedImage)p_Image;
        }
        if (p_ID.equals(this.getID() + "_end")) {
            this.m_SnapShot_End = (BufferedImage)p_Image;
        }
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    public void eventMediaServerConnection(MediaServer p_MediaServer, int p_ConnectionStatus) {
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    public void eventMediaSourceInvalidFile(MediaSource p_MediaSource, File p_MediaFile) {
    }

    public void eventMediaSourceOpened(MediaSource p_MediaSource, File p_MediaFile, long p_SectionStart, long p_SectionEnd) {
    }

    public void eventMediaSourceClosing(MediaSource p_MediaSource) {
    }

    public void eventMediaSourceRefreshing(MediaSource p_MediaSource) {
        if (p_MediaSource == this.m_MediaSource_Client) {
            this.refreshMediaSource();
        }
    }

    @Override
    public void notifyObjectListeners_ObjectParameterChanged(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (this.m_ChangedFrameStartOffset_SinceLastNotification) {
            this.m_ResetRestart = true;
        }
        super.notifyObjectListeners_ObjectParameterChanged(p_LiveShowObjectDescription);
    }

    @Override
    public void eventEndOfAction(LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
        super.eventEndOfAction(p_ActorLiveShowVIP, p_Success, p_Action);
        if (this.m_ResetRestart) {
            this.m_ResetPrefetchDone = false;
            this.m_ResetPrefetchDone_Pre = false;
        }
        this.m_ResetRestart = false;
    }
}

