/*
 * Decompiled with CFR 0.152.
 */
package MediaMixer;

import JarLoader.JarClassLoader;
import JarLoader.JarResources;
import MediaMixer.MediaControlComponent;
import StartPackage.LiveShowMediaSystem;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.JPanelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MediaMixerPanel
extends JPanel {
    private ArrayList<MediaControlComponent> m_MediaControlComponents;
    private JLabel jLabel_Name;
    private JPanelBackground jPanel_InnerPanel;

    public MediaMixerPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
    }

    private void initMembers() {
        this.m_MediaControlComponents = new ArrayList();
    }

    private void initComponents() {
        this.jLabel_Name = new JLabel();
        this.jPanel_InnerPanel = new JPanelBackground();
        this.setLayout(new GridBagLayout());
        this.jLabel_Name.setBackground(new Color(0, 0, 0));
        this.jLabel_Name.setForeground(new Color(255, 255, 255));
        this.jLabel_Name.setHorizontalAlignment(0);
        this.jLabel_Name.setText("jLabel1");
        this.jLabel_Name.setMaximumSize(new Dimension(34, 20));
        this.jLabel_Name.setMinimumSize(new Dimension(34, 20));
        this.jLabel_Name.setOpaque(true);
        this.jLabel_Name.setPreferredSize(new Dimension(34, 20));
        this.jLabel_Name.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MediaMixerPanel.this.jLabel_NameMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jLabel_Name, gridBagConstraints);
        this.jPanel_InnerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MediaMixerPanel.this.jPanel_InnerPanelMouseClicked(evt);
            }
        });
        this.jPanel_InnerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel_InnerPanel, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.setJarRessources(LiveShowMediaSystem.s_JarResources_Default);
    }

    public boolean addMediaControlComponent(final MediaControlComponent p_MediaControlComponent) {
        if (p_MediaControlComponent == null) {
            return false;
        }
        if (this.m_MediaControlComponents.contains(p_MediaControlComponent)) {
            return true;
        }
        this.m_MediaControlComponents.add(p_MediaControlComponent);
        GridBagConstraints o_GridBagConstraints = p_MediaControlComponent.getGridBagConstraints();
        o_GridBagConstraints.gridy = 0;
        o_GridBagConstraints.gridx = this.m_MediaControlComponents.size() - 1;
        o_GridBagConstraints.weighty = 1.0;
        o_GridBagConstraints.insets.top = 1;
        o_GridBagConstraints.insets.left = 0;
        o_GridBagConstraints.insets.right = 0;
        o_GridBagConstraints.insets.bottom = 1;
        o_GridBagConstraints.fill = 3;
        this.jPanel_InnerPanel.add((Component)p_MediaControlComponent, o_GridBagConstraints);
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    p_MediaControlComponent.changedParentHeight(MediaMixerPanel.this.jPanel_InnerPanel.getHeight());
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        p_MediaControlComponent.setVisible(true);
        return true;
    }

    public boolean removeMediaControlComponent(MediaControlComponent p_MediaControlComponent) {
        if (p_MediaControlComponent == null) {
            return false;
        }
        if (!this.m_MediaControlComponents.contains(p_MediaControlComponent)) {
            return true;
        }
        this.m_MediaControlComponents.add(p_MediaControlComponent);
        p_MediaControlComponent.setVisible(false);
        this.jPanel_InnerPanel.remove(p_MediaControlComponent);
        return true;
    }

    @Override
    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        super.setName(p_Name);
        this.jLabel_Name.setText(p_Name);
    }

    public void setJarRessources(JarResources p_JarResources) {
        this.jPanel_InnerPanel.setBackgroundOpaque(true);
        if (p_JarResources != null) {
            this.jPanel_InnerPanel.setBackgroundStyle(0);
            byte[] o_Bytes = p_JarResources.getResource("LiveShowControls/Background");
            Image o_Image = null;
            if (o_Bytes != null) {
                try {
                    o_Image = Toolkit.getDefaultToolkit().createImage(o_Bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.jPanel_InnerPanel.setBackgroundImage(o_Image);
            JarClassLoader o_JarClassLoader = p_JarResources.getJarClassLoader();
            if (o_JarClassLoader != null) {
                try {
                    Class o_Class = o_JarClassLoader.loadClass("LiveShowControls.Colors");
                    Field o_Field = o_Class.getDeclaredField("Mixer_Background");
                    Color o_Color = (Color)o_Field.get(o_Class);
                    this.jPanel_InnerPanel.setBackground(o_Color);
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
        } else {
            this.jPanel_InnerPanel.setBackgroundImage(null);
            this.jPanel_InnerPanel.setBackground(Color.darkGray);
            this.jPanel_InnerPanel.setBackgroundStyle(0);
        }
    }

    private void jLabel_NameMouseClicked(MouseEvent evt) {
    }

    private void jPanel_InnerPanelMouseClicked(MouseEvent evt) {
    }
}

