/*
 * Decompiled with CFR 0.152.
 */
package MediaMixer;

import JarLoader.JarResources;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlGroup;
import LiveShowControlObjects.ControlObject;
import LiveShowControlObjects.ValueSelectionInterface;
import LiveShowControls.JControlSlider;
import MediaMixer.MediaControlComponent;
import PlayMediaPackage.PlayMedia;
import StartPackage.LiveShowMediaSystem;
import SwingComponents.MouseAdapter_Delayed;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MediaControl_Transparency
extends MediaControlComponent
implements PropertyChangeListener {
    @LiveLanguageString
    public static String CONTROLNAME = "Media Transparency";
    @LiveLanguageString
    public static String CONTROLDESCRIPTION = "controls the media-transparency";
    @LiveLanguageString
    public static String DIMENSIONNAME_0_VOLUME = "Media Transparency";
    private ArrayList<ControlObject.ControlDimension> m_ControlDimensions;
    private StringBuffer m_StringBuffer_Transparency;
    private JControlSlider jControlSlider_Transparency;
    private JLabelBackground jLabelBackground_Transparency;
    private JLabel jLabel_Control;
    private JPanel jPanel_SliderDimmer;

    public MediaControl_Transparency() {
        this.initMembers();
        this.initComponents();
        this.initComponentFurther();
        this.initMediaControlComponentFinal();
    }

    private void initMembers() {
        this.m_StringBuffer_Transparency = new StringBuffer();
    }

    private void initComponents() {
        this.jLabelBackground_Transparency = new JLabelBackground();
        this.jPanel_SliderDimmer = new JPanel();
        this.jControlSlider_Transparency = new JControlSlider();
        this.jLabel_Control = new JLabel();
        this.setMinimumSize(new Dimension(55, 100));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(55, 100));
        this.setLayout(new GridBagLayout());
        this.jLabelBackground_Transparency.setBackground(new Color(0, 0, 0));
        this.jLabelBackground_Transparency.setBorder(BorderFactory.createEtchedBorder(Color.black, Color.white));
        this.jLabelBackground_Transparency.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Media.png")));
        this.jLabelBackground_Transparency.setBackgroundOpaque(true);
        this.jLabelBackground_Transparency.setMaximumSize(new Dimension(36, 36));
        this.jLabelBackground_Transparency.setMinimumSize(new Dimension(34, 34));
        this.jLabelBackground_Transparency.setName("");
        this.jLabelBackground_Transparency.setPreferredSize(new Dimension(34, 34));
        this.jLabelBackground_Transparency.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MediaControl_Transparency.this.jLabelBackground_TransparencyMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jLabelBackground_Transparency, gridBagConstraints);
        this.jPanel_SliderDimmer.setMinimumSize(new Dimension(50, 100));
        this.jPanel_SliderDimmer.setOpaque(false);
        this.jPanel_SliderDimmer.setPreferredSize(new Dimension(50, 100));
        this.jPanel_SliderDimmer.setLayout(new GridBagLayout());
        this.jControlSlider_Transparency.setToolTipText("");
        this.jControlSlider_Transparency.setBlocksBorder(BorderFactory.createEtchedBorder(Color.black, Color.white));
        this.jControlSlider_Transparency.setLabelsBorder(BorderFactory.createEtchedBorder(Color.black, Color.lightGray));
        this.jControlSlider_Transparency.setMinimumSize(new Dimension(40, 170));
        this.jControlSlider_Transparency.setPreferredSize(new Dimension(40, 170));
        this.jControlSlider_Transparency.setTrackInsets(new Insets(0, 12, 0, 12));
        this.jControlSlider_Transparency.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MediaControl_Transparency.this.jControlSlider_TransparencyMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderDimmer.add((Component)this.jControlSlider_Transparency, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.33333;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_SliderDimmer, gridBagConstraints);
        this.jLabel_Control.setForeground(new Color(255, 255, 255));
        this.jLabel_Control.setHorizontalAlignment(0);
        this.jLabel_Control.setToolTipText("");
        this.jLabel_Control.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jLabel_Control.setMinimumSize(new Dimension(36, 15));
        this.jLabel_Control.setPreferredSize(new Dimension(36, 15));
        this.jLabel_Control.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jLabel_Control, gridBagConstraints);
    }

    private void initComponentFurther() {
        this.jControlSlider_Transparency.setControlMaster(true);
        this.jControlSlider_Transparency.addDimensionPropertyChangeListener("value", (PropertyChangeListener)this, 0);
        this.jLabelBackground_Transparency.setText("");
        this.jLabelBackground_Transparency.setBackgroundStyle(0);
        this.jLabelBackground_Transparency.setBackgroundOpaque(true);
        ControlLabelModel o_ControlLabelModel = this.jControlSlider_Transparency.getControlLabelModel();
        o_ControlLabelModel.clearControlLabelDescriptions();
        o_ControlLabelModel.createControlLabelDescription(100.0, 100.0, Double.valueOf(100.0), "100", null, null);
        o_ControlLabelModel.createControlLabelDescription(75.0, 75.0, Double.valueOf(75.0), "75", null, null);
        o_ControlLabelModel.createControlLabelDescription(50.0, 50.0, Double.valueOf(50.0), "50", null, null);
        o_ControlLabelModel.createControlLabelDescription(25.0, 25.0, Double.valueOf(25.0), "25", null, null);
        o_ControlLabelModel.createControlLabelDescription(0.0, 0.0, Double.valueOf(0.0), "0 %", null, null);
        this.jControlSlider_Transparency.getControlDimension(0).setDimensionName(DIMENSIONNAME_0_VOLUME);
        this.jControlSlider_Transparency.setName(DIMENSIONNAME_0_VOLUME);
        this.setControlObject((ControlObject)this.jControlSlider_Transparency, 0);
        this.setJarResources(LiveShowMediaSystem.s_JarResources_Default);
        this.jControlSlider_Transparency.setValue(100.0);
        MouseAdapter_Delayed o_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

            @Override
            public void mouseClicked_Delayed(MouseEvent evt) {
                if (evt.getClickCount() <= 1) {
                    return;
                }
                ControlGroup o_ControlGroup = LiveShowMediaSystem.getControlGroupActive();
                if (o_ControlGroup == null) {
                    return;
                }
                if (evt.getClickCount() > 2) {
                    o_ControlGroup.clearControlObjects();
                } else if (o_ControlGroup.contains((ControlObject)MediaControl_Transparency.this.jControlSlider_Transparency)) {
                    o_ControlGroup.removeControlObject((ControlObject)MediaControl_Transparency.this.jControlSlider_Transparency);
                } else {
                    o_ControlGroup.addControlObject((ControlObject)MediaControl_Transparency.this.jControlSlider_Transparency);
                }
            }
        };
        this.jControlSlider_Transparency.addMouseListener((MouseListener)o_MouseAdapter_Delayed);
        this.m_ControlDimensions = new ArrayList();
        this.m_ControlDimensions.add(this.jControlSlider_Transparency.getControlDimension());
    }

    private void jLabelBackground_TransparencyMouseClicked(MouseEvent evt) {
        this.jControlSlider_Transparency.showValueSelection((ValueSelectionInterface)this.jControlSlider_Transparency, this.m_ControlDimensions, evt.getXOnScreen(), evt.getYOnScreen());
    }

    private void jControlSlider_TransparencyMouseClicked(MouseEvent evt) {
    }

    public void setJarResources(JarResources p_JarResources) {
        if (p_JarResources != null) {
            this.jControlSlider_Transparency.setJarResources(p_JarResources);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("value".equals(evt.getPropertyName())) {
            Double doubleTransparencyPC = (Double)evt.getNewValue();
            PlayMedia.setMainTransparency(doubleTransparencyPC / 100.0);
            this.m_StringBuffer_Transparency.delete(0, this.m_StringBuffer_Transparency.length());
            this.m_StringBuffer_Transparency.append(doubleTransparencyPC.intValue());
            this.m_StringBuffer_Transparency.append(" %");
            this.jLabel_Control.setText(this.m_StringBuffer_Transparency.toString());
        }
        super.propertyChange(evt);
    }

    @Override
    public void changedParentHeight(int p_ParentHeight) {
    }
}

