/*
 * Decompiled with CFR 0.152.
 */
package MediaMixer;

import BioMathmaticsPackage.BioMathematics;
import JarLoader.JarResources;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlGroup;
import LiveShowControlObjects.ControlObject;
import LiveShowControlObjects.ValueSelectionInterface;
import LiveShowControls.JControlSlider;
import MediaMixer.MediaControlComponent;
import PlayMediaPackage.PlayMedia;
import StartPackage.LiveShowMediaSystem;
import SwingComponents.MouseAdapter_Delayed;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MediaControl_SoundVolume
extends MediaControlComponent
implements PropertyChangeListener {
    @LiveLanguageString
    public static String CONTROLNAME = "Sound Volume";
    @LiveLanguageString
    public static String CONTROLDESCRIPTION = "controls the sound-volume";
    @LiveLanguageString
    public static String DIMENSIONNAME_0_VOLUME = "Sound Volume";
    private ArrayList<ControlObject.ControlDimension> m_ControlDimensions;
    private StringBuffer m_StringBuffer_DB;
    private JControlSlider jControlSlider_Volume;
    private JLabelBackground jLabelBackground_Volume;
    private JLabel jLabel_Control;
    private JPanel jPanel_SliderDimmer;

    public MediaControl_SoundVolume() {
        this.initMembers();
        this.initComponents();
        this.initComponentFurther();
        this.initMediaControlComponentFinal();
    }

    private void initMembers() {
        this.m_StringBuffer_DB = new StringBuffer();
    }

    private void initComponents() {
        this.jLabelBackground_Volume = new JLabelBackground();
        this.jPanel_SliderDimmer = new JPanel();
        this.jControlSlider_Volume = new JControlSlider();
        this.jLabel_Control = new JLabel();
        this.setMinimumSize(new Dimension(55, 100));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(55, 100));
        this.setLayout(new GridBagLayout());
        this.jLabelBackground_Volume.setBackground(new Color(0, 0, 0));
        this.jLabelBackground_Volume.setBorder(BorderFactory.createEtchedBorder(Color.black, Color.white));
        this.jLabelBackground_Volume.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Play_VideoSoundVolume.png")));
        this.jLabelBackground_Volume.setBackgroundOpaque(true);
        this.jLabelBackground_Volume.setMinimumSize(new Dimension(34, 34));
        this.jLabelBackground_Volume.setPreferredSize(new Dimension(34, 34));
        this.jLabelBackground_Volume.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MediaControl_SoundVolume.this.jLabelBackground_VolumeMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jLabelBackground_Volume, gridBagConstraints);
        this.jPanel_SliderDimmer.setMinimumSize(new Dimension(50, 100));
        this.jPanel_SliderDimmer.setOpaque(false);
        this.jPanel_SliderDimmer.setPreferredSize(new Dimension(50, 100));
        this.jPanel_SliderDimmer.setLayout(new GridBagLayout());
        this.jControlSlider_Volume.setToolTipText("");
        this.jControlSlider_Volume.setBlocksBorder(BorderFactory.createEtchedBorder(Color.black, Color.white));
        this.jControlSlider_Volume.setLabelsBorder(BorderFactory.createEtchedBorder(Color.black, Color.lightGray));
        this.jControlSlider_Volume.setMinimumSize(new Dimension(40, 170));
        this.jControlSlider_Volume.setPreferredSize(new Dimension(40, 170));
        this.jControlSlider_Volume.setSnapDistanceTransformed(1.0);
        this.jControlSlider_Volume.setTrackInsets(new Insets(0, 12, 0, 12));
        this.jControlSlider_Volume.setValueMaximum(200.0);
        this.jControlSlider_Volume.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MediaControl_SoundVolume.this.jControlSlider_VolumeMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderDimmer.add((Component)this.jControlSlider_Volume, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.33333;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_SliderDimmer, gridBagConstraints);
        this.jLabel_Control.setForeground(new Color(255, 255, 255));
        this.jLabel_Control.setHorizontalAlignment(0);
        this.jLabel_Control.setToolTipText("");
        this.jLabel_Control.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jLabel_Control.setMinimumSize(new Dimension(36, 15));
        this.jLabel_Control.setPreferredSize(new Dimension(36, 15));
        this.jLabel_Control.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jLabel_Control, gridBagConstraints);
    }

    private void initComponentFurther() {
        this.jControlSlider_Volume.setControlMaster(true);
        this.jControlSlider_Volume.addDimensionPropertyChangeListener("value", (PropertyChangeListener)this, 0);
        this.jLabelBackground_Volume.setText("");
        this.jLabelBackground_Volume.setBackgroundStyle(0);
        this.jLabelBackground_Volume.setBackgroundOpaque(true);
        ControlLabelModel o_ControlLabelModel = this.jControlSlider_Volume.getControlLabelModel();
        o_ControlLabelModel.clearControlLabelDescriptions();
        o_ControlLabelModel.createControlLabelDescription(200.0, 200.0, Double.valueOf(200.0), "+10", null, null);
        o_ControlLabelModel.createControlLabelDescription(100.0, 100.0, Double.valueOf(100.0), "0db", null, null);
        o_ControlLabelModel.createControlLabelDescription(50.0, 50.0, Double.valueOf(50.0), "-10", null, null);
        o_ControlLabelModel.createControlLabelDescription(25.0, 25.0, Double.valueOf(25.0), "-20", null, null);
        o_ControlLabelModel.createControlLabelDescription(0.0, 0.0, Double.valueOf(0.0), "---", null, null);
        this.jControlSlider_Volume.getControlDimension(0).setDimensionName(DIMENSIONNAME_0_VOLUME);
        this.jControlSlider_Volume.setName(DIMENSIONNAME_0_VOLUME);
        this.setControlObject((ControlObject)this.jControlSlider_Volume, 0);
        this.setJarResources(LiveShowMediaSystem.s_JarResources_Default);
        this.jControlSlider_Volume.setValue(100.0);
        MouseAdapter_Delayed o_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

            @Override
            public void mouseClicked_Delayed(MouseEvent evt) {
                if (evt.getClickCount() <= 1) {
                    return;
                }
                ControlGroup o_ControlGroup = LiveShowMediaSystem.getControlGroupActive();
                if (o_ControlGroup == null) {
                    return;
                }
                if (evt.getClickCount() > 2) {
                    o_ControlGroup.clearControlObjects();
                } else if (o_ControlGroup.contains((ControlObject)MediaControl_SoundVolume.this.jControlSlider_Volume)) {
                    o_ControlGroup.removeControlObject((ControlObject)MediaControl_SoundVolume.this.jControlSlider_Volume);
                } else {
                    o_ControlGroup.addControlObject((ControlObject)MediaControl_SoundVolume.this.jControlSlider_Volume);
                }
            }
        };
        this.jControlSlider_Volume.addMouseListener((MouseListener)o_MouseAdapter_Delayed);
        this.m_ControlDimensions = new ArrayList();
        this.m_ControlDimensions.add(this.jControlSlider_Volume.getControlDimension());
    }

    private void jLabelBackground_VolumeMouseClicked(MouseEvent evt) {
        this.jControlSlider_Volume.showValueSelection((ValueSelectionInterface)this.jControlSlider_Volume, this.m_ControlDimensions, evt.getXOnScreen(), evt.getYOnScreen());
    }

    private void jControlSlider_VolumeMouseClicked(MouseEvent evt) {
    }

    public void setJarResources(JarResources p_JarResources) {
        if (p_JarResources != null) {
            this.jControlSlider_Volume.setJarResources(p_JarResources);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("value".equals(evt.getPropertyName())) {
            PlayMedia.setMainSoundVolume((Double)evt.getNewValue() / 100.0);
            Double doubleDB = BioMathematics.calculateDB_FromLoudness((Double)evt.getNewValue() / 100.0);
            if (doubleDB == Double.MIN_VALUE) {
                this.jLabel_Control.setText("--- db");
            } else {
                this.m_StringBuffer_DB.delete(0, this.m_StringBuffer_DB.length());
                if (doubleDB > 0.0) {
                    this.m_StringBuffer_DB.append("+");
                }
                this.m_StringBuffer_DB.append(doubleDB.intValue());
                this.m_StringBuffer_DB.append(" db");
                this.jLabel_Control.setText(this.m_StringBuffer_DB.toString());
            }
        }
        super.propertyChange(evt);
    }

    @Override
    public void changedParentHeight(int p_ParentHeight) {
    }
}

