/*
 * Decompiled with CFR 0.152.
 */
package MediaMixer;

import LiveShowControlObjects.ControlObject;
import LiveShowPlayPackage.PlayRemoteActions;
import SPITActionPackage.SPIT_ActionStatus;
import SPITActionPackage.SPIT_Action_Interface;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITRemotePackage.SPITRemote;
import java.awt.GridBagConstraints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public abstract class MediaControlComponent
extends JPanel
implements PropertyChangeListener,
SPIT_Action_Interface {
    protected GridBagConstraints m_GridBagConstraints;
    protected ArrayList<ControlObject> m_ControlObjects;
    protected boolean m_IsMaster;
    protected double m_ValueSPITInput_Old;

    public MediaControlComponent() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_GridBagConstraints = new GridBagConstraints();
        this.m_ControlObjects = new ArrayList();
        this.m_IsMaster = false;
        this.m_ValueSPITInput_Old = 0.0;
    }

    public void initMediaControlComponentFinal() {
    }

    public GridBagConstraints getGridBagConstraints() {
        return this.m_GridBagConstraints;
    }

    public abstract void changedParentHeight(int var1);

    protected boolean setControlObject(ControlObject p_ControlObject, int p_ControlIndex) {
        ControlObject o_ControlObject;
        if (p_ControlIndex < 0) {
            return false;
        }
        if (p_ControlIndex >= this.m_ControlObjects.size()) {
            for (int intControl = this.m_ControlObjects.size(); intControl <= p_ControlIndex; ++intControl) {
                this.m_ControlObjects.add(null);
            }
        }
        if (p_ControlObject == (o_ControlObject = this.m_ControlObjects.get(p_ControlIndex))) {
            return true;
        }
        this.m_ControlObjects.set(p_ControlIndex, p_ControlObject);
        if (p_ControlObject != null) {
            p_ControlObject.addPropertyChangeListener((PropertyChangeListener)this);
        }
        return true;
    }

    public int getControlsCount() {
        return this.m_ControlObjects.size();
    }

    public ControlObject getControlObject(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_ControlObjects.size()) {
            return null;
        }
        return this.m_ControlObjects.get(p_Index);
    }

    public void setControlMaster(boolean p_IsMaster) {
        this.m_IsMaster = p_IsMaster;
        for (int intControlObject = 0; intControlObject < this.getControlsCount(); ++intControlObject) {
            ControlObject o_ControlObject = this.getControlObject(intControlObject);
            if (o_ControlObject == null) continue;
            o_ControlObject.setControlMaster(p_IsMaster);
        }
    }

    public void createSPITRemote(String p_ID, String p_GroupName, String p_TypeName, ArrayList<SPIT_Object_Interface> p_SPIT_Object_Interfaces) {
        int intSPITIndex = 0;
        for (int intControl = 0; intControl < this.getControlsCount(); ++intControl) {
            ControlObject o_ControlObject = this.getControlObject(intControl);
            if (o_ControlObject == null) continue;
            for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                SPIT_Object_Interface o_SPIT_Object_Interface;
                SPIT_Type_Interface o_SPIT_Type_Interface;
                ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intDimension);
                if (o_ControlDimension == null) continue;
                String stringSPITID = p_ID + String.valueOf(intControl) + String.valueOf(intDimension);
                intSPITIndex = intControl * o_ControlObject.getControlDimensionCount() + intDimension;
                if (p_SPIT_Object_Interfaces == null) {
                    o_SPIT_Type_Interface = SPITRemote.createServerRemoteSPIT_Type((String)stringSPITID, (String)p_GroupName, (String)p_TypeName, (boolean)true);
                    SPITRemote.addRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type_Interface);
                    o_SPIT_Object_Interface = SPITRemote.createServerRemoteSPIT_Object((SPIT_Type_Interface)o_SPIT_Type_Interface, (String)stringSPITID, (String)o_ControlObject.getName(), (byte)1);
                    o_SPIT_Object_Interface.setSPIT_Action_Interface((SPIT_Action_Interface)this, (Object)o_ControlDimension);
                    o_ControlDimension.addPropertyChangeListener((PropertyChangeListener)this);
                    SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
                } else {
                    if (intSPITIndex >= p_SPIT_Object_Interfaces.size()) {
                        return;
                    }
                    o_SPIT_Object_Interface = p_SPIT_Object_Interfaces.get(intSPITIndex);
                    if (o_SPIT_Object_Interface == null || (o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type()) == null) continue;
                    o_SPIT_Type_Interface.setGroupName(p_GroupName);
                    o_SPIT_Object_Interface.setName(o_ControlObject.getName());
                    o_SPIT_Object_Interface.setSPIT_Action_Interface((SPIT_Action_Interface)this, (Object)o_ControlDimension);
                    o_ControlDimension.addPropertyChangeListener((PropertyChangeListener)this);
                }
                double doublePlayValue = o_ControlDimension.getValue() / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
                o_SPIT_Object_Interface.setPlayValue((int)(doublePlayValue * 1000000.0));
            }
        }
    }

    public void createSPITRemote_InDecrease(String p_ID, String p_GroupName, String p_TypeName, String p_ObjectName) {
        boolean intSPITIndex = false;
        String stringSPITID = p_ID;
        SPIT_Type_Interface o_SPIT_Type_Interface = SPITRemote.createServerRemoteSPIT_Type((String)stringSPITID, (String)p_GroupName, (String)p_TypeName, (boolean)true);
        SPITRemote.addRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type_Interface);
        SPIT_Object_Interface o_SPIT_Object_Interface = SPITRemote.createServerRemoteSPIT_Object((SPIT_Type_Interface)o_SPIT_Type_Interface, (String)stringSPITID, (String)p_ObjectName, (byte)0);
        o_SPIT_Object_Interface.setSPIT_Action_Interface((SPIT_Action_Interface)this, null);
        SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
    }

    public void playStarted(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_SPIT_Action_Object) {
    }

    public void playEnd(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_SPIT_Action_Object) {
    }

    public void play(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_SPIT_Action_Object) {
        double doubleValue_Input;
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        if (p_SPIT_ActionStatus == null) {
            return;
        }
        ControlObject.ControlDimension o_ControlDimension = null;
        if (p_SPIT_Object_Interface.getID().contains("mainmixerMedia_IncreaseVolume")) {
            double doubleMinVolume;
            ControlObject o_ControlObject = this.getControlObject(0);
            if (o_ControlObject == null) {
                return;
            }
            o_ControlDimension = o_ControlObject.getControlDimension(0);
            if (o_ControlDimension == null) {
                return;
            }
            double doubleVolume = o_ControlDimension.getValue();
            double doubleMaxVolume = o_ControlDimension.getValueMaximum();
            if ((doubleVolume += (doubleMaxVolume - (doubleMinVolume = o_ControlDimension.getValueMinimum())) * PlayRemoteActions.VALUEFACTOR_UPDOWN_PERCENT) > doubleMaxVolume) {
                doubleVolume = doubleMaxVolume;
            }
            o_ControlDimension.setValue(doubleVolume);
            o_ControlObject.setValueManuallyIsReady();
            return;
        }
        if (p_SPIT_Object_Interface.getID().contains("mainmixerMedia_DecreaseVolume")) {
            double doubleMinVolume;
            ControlObject o_ControlObject = this.getControlObject(0);
            if (o_ControlObject == null) {
                return;
            }
            o_ControlDimension = o_ControlObject.getControlDimension(0);
            if (o_ControlDimension == null) {
                return;
            }
            double doubleVolume = o_ControlDimension.getValue();
            double doubleMaxVolume = o_ControlDimension.getValueMaximum();
            if ((doubleVolume -= (doubleMaxVolume - (doubleMinVolume = o_ControlDimension.getValueMinimum())) * PlayRemoteActions.VALUEFACTOR_UPDOWN_PERCENT) < doubleMinVolume) {
                doubleVolume = doubleMinVolume;
            }
            o_ControlDimension.setValue(doubleVolume);
            o_ControlObject.setValueManuallyIsReady();
            return;
        }
        if (p_SPIT_Action_Object == null) {
            return;
        }
        if (p_SPIT_Action_Object instanceof ControlObject.ControlDimension) {
            o_ControlDimension = (ControlObject.ControlDimension)p_SPIT_Action_Object;
        }
        if (o_ControlDimension == null) {
            return;
        }
        ControlObject o_ControlObject = o_ControlDimension.getControlObject();
        if (o_ControlObject == null) {
            return;
        }
        if (p_SPIT_Object_Interface.getID().contains("mainmixerMedia_SoundVolume") || p_SPIT_Object_Interface.getID().contains("mainmixerMedia_Transparency")) {
            boolean boolValueCaught = false;
            doubleValue_Input = (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum()) * ((double)p_SPIT_ActionStatus.getPlayValue() / 1000000.0);
            double doubleValue_Actual = o_ControlDimension.getValue();
            if (doubleValue_Input > this.m_ValueSPITInput_Old) {
                if (doubleValue_Input >= doubleValue_Actual && Math.abs(this.m_ValueSPITInput_Old - doubleValue_Actual) < (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum()) / 100.0) {
                    boolValueCaught = true;
                }
            } else if (doubleValue_Input <= doubleValue_Actual && Math.abs(this.m_ValueSPITInput_Old - doubleValue_Actual) < (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum()) / 100.0) {
                boolValueCaught = true;
            }
            if (boolValueCaught) {
                o_ControlDimension.setValue(doubleValue_Input);
                o_ControlObject.setValueManuallyIsReady();
            }
        } else {
            doubleValue_Input = (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum()) * ((double)p_SPIT_ActionStatus.getPlayValue() / 1000000.0);
            o_ControlDimension.setValue(doubleValue_Input);
            o_ControlObject.setValueManuallyIsReady();
        }
        this.m_ValueSPITInput_Old = doubleValue_Input;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof ControlObject.ControlDimension && ("valueFactor".equals(evt.getPropertyName()) || "value".equals(evt.getPropertyName()))) {
            ControlObject.ControlDimension o_ControlDimension = (ControlObject.ControlDimension)evt.getSource();
            SPIT_Object_Interface o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_ObjectByActionObject((Object)o_ControlDimension);
            if (o_SPIT_Object_Interface == null) {
                return;
            }
            if (o_ControlDimension != o_SPIT_Object_Interface.getSPIT_Action_Object()) {
                return;
            }
            o_ControlDimension = (ControlObject.ControlDimension)o_SPIT_Object_Interface.getSPIT_Action_Object();
            double doublePlayValue = o_ControlDimension.getValue() / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            o_SPIT_Object_Interface.setPlayValue((int)(doublePlayValue * 1000000.0));
        }
    }
}

