/*
 * Decompiled with CFR 0.152.
 */
package SwingComponents;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class KeyAdapter_Delayed
extends KeyAdapter {
    public static int DELAYMILLISECONDS = 250;
    private int m_DelayMilliseconds;
    private HashMap<Object, KeyActionSource> m_KeyActionSources;
    private final Object m_SyncKeyActionSource = new Object();
    private int m_LastKeyPressed;

    public KeyAdapter_Delayed() {
        this.initMembers();
    }

    public KeyAdapter_Delayed(int p_DelayMilliseconds) {
        this.initMembers();
        this.m_DelayMilliseconds = p_DelayMilliseconds;
    }

    private void initMembers() {
        this.m_KeyActionSources = new HashMap();
        this.m_DelayMilliseconds = DELAYMILLISECONDS;
        this.m_LastKeyPressed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_SyncKeyActionSource;
        synchronized (object) {
            Iterator<KeyActionSource> o_Iterator = this.m_KeyActionSources.values().iterator();
            while (o_Iterator.hasNext()) {
                KeyActionSource o_KeyActionSource = o_Iterator.next();
                o_Iterator.remove();
                if (o_KeyActionSource == null) continue;
                o_KeyActionSource.close();
            }
        }
    }

    public int getDelay() {
        return this.m_DelayMilliseconds;
    }

    public void setDelay(int p_DelayMilliseconds) {
        if (p_DelayMilliseconds < 0) {
            p_DelayMilliseconds = 0;
        }
        this.m_DelayMilliseconds = p_DelayMilliseconds;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        KeyAction o_KeyAction;
        if (this.m_DelayMilliseconds <= 0) {
            this.keyPressed_Delayed(e, 1);
        }
        if ((o_KeyAction = this.getKeyAction(e)) == null) {
            return;
        }
        o_KeyAction.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        KeyAction o_KeyAction;
        if (this.m_DelayMilliseconds <= 0) {
            this.keyReleased_Delayed(e, 1);
        }
        if ((o_KeyAction = this.getKeyAction(e)) == null) {
            return;
        }
        o_KeyAction.keyReleased(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.m_DelayMilliseconds <= 0) {
            this.keyTyped_Delayed(e, 1);
        }
    }

    public void keyPressed_Delayed(KeyEvent e, int p_Count) {
    }

    public void keyReleased_Delayed(KeyEvent e, int p_Count) {
    }

    public void keyTyped_Delayed(KeyEvent e, int p_Count) {
    }

    private KeyAction getKeyAction(KeyEvent e) {
        if (e.getComponent() == null) {
            return null;
        }
        KeyActionSource o_KeyActionSource = this.getKeyActionSource(e);
        if (o_KeyActionSource == null) {
            return null;
        }
        KeyAction o_KeyAction = o_KeyActionSource.getKeyAction(e.getKeyCode());
        return o_KeyAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyActionSource getKeyActionSource(KeyEvent e) {
        KeyActionSource o_KeyActionSource;
        if (e.getComponent() == null) {
            return null;
        }
        Object object = this.m_SyncKeyActionSource;
        synchronized (object) {
            o_KeyActionSource = this.m_KeyActionSources.get(e.getSource());
            if (o_KeyActionSource == null) {
                o_KeyActionSource = new KeyActionSource(this, e.getComponent());
                this.m_KeyActionSources.put(e.getSource(), o_KeyActionSource);
            }
        }
        return o_KeyActionSource;
    }

    public static KeyEvent createKeyEvent(KeyEvent e, int p_ID) {
        return KeyAdapter_Delayed.createKeyEvent(e.getComponent(), p_ID, e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar(), e.getKeyLocation());
    }

    public static KeyEvent createKeyEvent(Component p_Component, int p_ID, long p_When, int p_Modifiers, int p_KeyCode, char p_KeyChar, int p_KeyLocation) {
        if (p_ID == 400) {
            if (p_KeyChar == '\uffff') {
                return null;
            }
            p_KeyCode = 0;
            p_KeyLocation = 0;
        }
        KeyEvent o_KeyEvent = new KeyEvent(p_Component, p_ID, p_When, p_Modifiers, p_KeyCode, p_KeyChar, p_KeyLocation);
        return o_KeyEvent;
    }

    private static class KeyAction {
        public static final int STATUS_NONE = 0;
        public static final int STATUS_PRESSED = 1;
        public static final int STATUS_TYPED = 2;
        public static final int STATUS_RELEASED = 3;
        private KeyAdapter_Delayed m_KeyAdapter_Delayed;
        private KeyActionSource m_KeyActionSource;
        private int m_KeyCode;
        private int m_ButtonCount;
        private KeyEvent m_KeyEvent_Pressed;
        private KeyEvent m_KeyEvent_Released;
        private int m_Status;
        private boolean m_TimerDelayEnd;
        private Timer m_TimerDelay;
        private TimerTask m_TimerDelayTask;
        private final Object m_SyncDelay = new Object();

        public KeyAction(KeyAdapter_Delayed p_KeyAdapter_Delayed, KeyActionSource p_KeyActionSource, int p_KeyCode) {
            this.m_KeyAdapter_Delayed = p_KeyAdapter_Delayed;
            this.m_KeyActionSource = p_KeyActionSource;
            this.m_KeyCode = p_KeyCode;
            this.initMembers();
        }

        private void initMembers() {
            this.m_ButtonCount = 0;
            this.m_TimerDelayEnd = true;
            this.m_Status = 0;
            this.m_TimerDelayTask = new TimerTask(){

                @Override
                public void run() {
                    this.timerDelayEnd();
                }
            };
            this.m_TimerDelay = new Timer("KeyEvent" + String.valueOf(this.m_KeyCode));
        }

        public void close() {
            this.m_TimerDelay.purge();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void timerDelayStart() {
            Object object = this.m_SyncDelay;
            synchronized (object) {
                if (this.m_TimerDelayEnd) {
                    this.m_TimerDelayEnd = false;
                    this.m_TimerDelayTask = new TimerTask(){

                        @Override
                        public void run() {
                            this.timerDelayEnd();
                        }
                    };
                    this.m_TimerDelay.schedule(this.m_TimerDelayTask, this.m_KeyAdapter_Delayed.getDelay());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void timerDelayEnd() {
            Object object = this.m_SyncDelay;
            synchronized (object) {
                this.m_TimerDelayEnd = true;
                switch (this.m_Status) {
                    case 3: {
                        KeyEvent o_KeyEvent = KeyAdapter_Delayed.createKeyEvent(this.m_KeyEvent_Pressed, 401);
                        if (o_KeyEvent != null) {
                            this.m_KeyAdapter_Delayed.keyPressed_Delayed(o_KeyEvent, this.m_ButtonCount);
                            if (o_KeyEvent.isConsumed()) {
                                this.m_KeyEvent_Pressed.consume();
                            }
                        }
                        if ((o_KeyEvent = KeyAdapter_Delayed.createKeyEvent(this.m_KeyEvent_Pressed, 400)) != null) {
                            this.m_KeyAdapter_Delayed.keyTyped_Delayed(o_KeyEvent, this.m_ButtonCount);
                            if (o_KeyEvent.isConsumed()) {
                                this.m_KeyEvent_Pressed.consume();
                            }
                        }
                        if ((o_KeyEvent = KeyAdapter_Delayed.createKeyEvent(this.m_KeyEvent_Released, 402)) != null) {
                            this.m_KeyAdapter_Delayed.keyReleased_Delayed(o_KeyEvent, this.m_ButtonCount);
                            if (o_KeyEvent.isConsumed()) {
                                this.m_KeyEvent_Released.consume();
                            }
                        }
                        this.endButtonSequence();
                        break;
                    }
                    case 1: {
                        KeyEvent o_KeyEvent = KeyAdapter_Delayed.createKeyEvent(this.m_KeyEvent_Pressed, 401);
                        if (o_KeyEvent != null) {
                            this.m_KeyAdapter_Delayed.keyPressed_Delayed(o_KeyEvent, this.m_ButtonCount);
                            if (o_KeyEvent.isConsumed()) {
                                this.m_KeyEvent_Pressed.consume();
                            }
                        }
                        if ((o_KeyEvent = KeyAdapter_Delayed.createKeyEvent(this.m_KeyEvent_Pressed, 400)) == null) break;
                        this.m_KeyAdapter_Delayed.keyTyped_Delayed(o_KeyEvent, this.m_ButtonCount);
                        if (!o_KeyEvent.isConsumed()) break;
                        this.m_KeyEvent_Pressed.consume();
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent e) {
            Object object = this.m_SyncDelay;
            synchronized (object) {
                if (this.m_Status == 1) {
                    return;
                }
                this.m_KeyEvent_Pressed = e;
                this.m_Status = 1;
                ++this.m_ButtonCount;
                if (this.m_TimerDelayEnd) {
                    this.timerDelayStart();
                } else {
                    this.m_KeyEvent_Pressed.consume();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyReleased(KeyEvent e) {
            Object object = this.m_SyncDelay;
            synchronized (object) {
                this.m_KeyEvent_Released = e;
                this.m_Status = 3;
                if (this.m_TimerDelayEnd) {
                    KeyEvent o_KeyEvent = KeyAdapter_Delayed.createKeyEvent(this.m_KeyEvent_Released, 402);
                    if (o_KeyEvent != null) {
                        this.m_KeyAdapter_Delayed.keyReleased_Delayed(o_KeyEvent, this.m_ButtonCount);
                        if (o_KeyEvent.isConsumed()) {
                            e.consume();
                        }
                    }
                    this.endButtonSequence();
                } else {
                    this.m_KeyEvent_Released.consume();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyTyped(KeyEvent e) {
            Object object = this.m_SyncDelay;
            synchronized (object) {
                e.consume();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endButtonSequence() {
            Object object = this.m_SyncDelay;
            synchronized (object) {
                this.m_ButtonCount = 0;
                this.m_Status = 0;
            }
        }
    }

    private static class KeyActionSource {
        private KeyAdapter_Delayed m_KeyAdapter_Delayed;
        private Component m_Source;
        private HashMap<Integer, KeyAction> m_KeyActions;
        private final Object m_SyncKeyActions = new Object();

        public KeyActionSource(KeyAdapter_Delayed p_KeyAdapter_Delayed, Component p_Source) {
            this.m_KeyAdapter_Delayed = p_KeyAdapter_Delayed;
            this.m_Source = p_Source;
            this.initMembers();
        }

        private void initMembers() {
            this.m_KeyActions = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncKeyActions;
            synchronized (object) {
                Iterator<KeyAction> o_Iterator = this.m_KeyActions.values().iterator();
                while (o_Iterator.hasNext()) {
                    KeyAction o_KeyAction = o_Iterator.next();
                    o_Iterator.remove();
                    if (o_KeyAction == null) continue;
                    o_KeyAction.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KeyAction getKeyAction(int p_KeyCode) {
            KeyAction o_KeyAction;
            Object object = this.m_SyncKeyActions;
            synchronized (object) {
                o_KeyAction = this.m_KeyActions.get(p_KeyCode);
                if (o_KeyAction == null) {
                    o_KeyAction = new KeyAction(this.m_KeyAdapter_Delayed, this, p_KeyCode);
                    this.m_KeyActions.put(p_KeyCode, o_KeyAction);
                }
            }
            return o_KeyAction;
        }
    }
}

