/*
 * Decompiled with CFR 0.152.
 */
package SoundPackage;

import BioMathmaticsPackage.BioMathematics;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import SoundPackage.SoundMixers;
import SoundPackage.Sound_Channel_LinesPanel;
import SwingTextPackage.DocumentFilter_Double;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;

public class Sound_LineFactorPanel
extends JPanel {
    public static Dimension s_Size = new Dimension(61, 30);
    @LiveLanguageString
    public static String CHANNELVOLUMECHANGE = "Volume Change (db)";
    private static Border s_TextBorder = new LineBorder(Color.GRAY, 1);
    public static ImageIcon s_IconCheckBox_Unselected = new ImageIcon(Sound_LineFactorPanel.class.getResource("/IconsPackage/CheckBox_Black_Unselected.png"));
    public static ImageIcon s_IconCheckBox_Selected = new ImageIcon(Sound_LineFactorPanel.class.getResource("/IconsPackage/CheckBox_Black_Selected.png"));
    private Sound_Channel_LinesPanel m_Sound_Channel_LinesPanel;
    private SoundMixers.Sound_Lines m_Sound_Lines;
    private SoundMixers.Sound_Lines_Parent m_Sound_Lines_Parent;
    private int m_Channel;
    private int m_Sound_LineNumber;
    private final Object m_SyncObject = new Object();
    private JCheckBox jCheckBox_Line;
    private JTextField jTextField_VolumeDB;

    public Sound_LineFactorPanel(Sound_Channel_LinesPanel p_Sound_Channel_LinesPanel, int p_Channel, int p_SoundLineNumber) {
        this.initMembers();
        this.initComponents();
        this.m_Sound_Channel_LinesPanel = p_Sound_Channel_LinesPanel;
        this.m_Channel = p_Channel;
        this.m_Sound_LineNumber = p_SoundLineNumber;
        LiveLanguage.addLanguageListener(this, null);
        this.initComponentsFurther();
    }

    private void initMembers() {
        this.m_Sound_Lines = null;
        this.m_Channel = 0;
        this.m_Sound_LineNumber = 0;
    }

    private void initComponentsFurther() {
        DocumentFilter_Double o_DocumentFilter_Double = new DocumentFilter_Double((JTextComponent)this.jTextField_VolumeDB);
        o_DocumentFilter_Double.setAllowEmptyString(true);
        this.jTextField_VolumeDB.setToolTipText(CHANNELVOLUMECHANGE);
        this.jTextField_VolumeDB.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.setMinimumSize(s_Size);
        this.setMaximumSize(s_Size);
        this.setPreferredSize(s_Size);
    }

    private void initComponents() {
        this.jCheckBox_Line = new JCheckBox();
        this.jTextField_VolumeDB = new JTextField();
        this.setMaximumSize(new Dimension(60, 30));
        this.setMinimumSize(new Dimension(60, 30));
        this.setPreferredSize(new Dimension(60, 30));
        this.setLayout(new GridBagLayout());
        this.jCheckBox_Line.setToolTipText("");
        this.jCheckBox_Line.setHorizontalAlignment(0);
        this.jCheckBox_Line.setMaximumSize(new Dimension(20, 30));
        this.jCheckBox_Line.setMinimumSize(new Dimension(20, 30));
        this.jCheckBox_Line.setPreferredSize(new Dimension(20, 30));
        this.jCheckBox_Line.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sound_LineFactorPanel.this.jCheckBox_LineActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jCheckBox_Line, gridBagConstraints);
        this.jTextField_VolumeDB.setHorizontalAlignment(0);
        this.jTextField_VolumeDB.setText("0");
        this.jTextField_VolumeDB.setToolTipText("");
        this.jTextField_VolumeDB.setBorder(null);
        this.jTextField_VolumeDB.setMaximumSize(new Dimension(40, 25));
        this.jTextField_VolumeDB.setMinimumSize(new Dimension(40, 25));
        this.jTextField_VolumeDB.setPreferredSize(new Dimension(40, 25));
        this.jTextField_VolumeDB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Sound_LineFactorPanel.this.jTextField_VolumeDBFocusLost(evt);
            }
        });
        this.jTextField_VolumeDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sound_LineFactorPanel.this.jTextField_VolumeDBActionPerformed(evt);
            }
        });
        this.jTextField_VolumeDB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                Sound_LineFactorPanel.this.jTextField_VolumeDBKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jTextField_VolumeDB, gridBagConstraints);
    }

    private void jCheckBox_LineActionPerformed(ActionEvent evt) {
        this.setSoundLineFactorFromGUI();
    }

    private void jTextField_VolumeDBKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.setSoundLineFactorFromGUI();
        }
    }

    private void jTextField_VolumeDBFocusLost(FocusEvent evt) {
        this.setSoundLineFactorFromGUI();
    }

    private void jTextField_VolumeDBActionPerformed(ActionEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoundLineFactorFromGUI() {
        boolean boolLineChanged = false;
        Object object = this.m_SyncObject;
        synchronized (object) {
            double doubleVolumeDB;
            if (this.m_Sound_Lines == null) {
                return;
            }
            try {
                doubleVolumeDB = this.jTextField_VolumeDB.getText().length() <= 0 ? 0.0 : Double.valueOf(this.jTextField_VolumeDB.getText());
            }
            catch (Exception e) {
                doubleVolumeDB = 0.0;
            }
            SoundMixers.SoundLineFactor o_SoundLineFactor = this.m_Sound_Lines.getSoundLineFactor(this.m_Channel, this.m_Sound_LineNumber);
            double doubleVolumeFactor = BioMathematics.calculateVolumeFactor_FromDB(doubleVolumeDB);
            if (this.jCheckBox_Line.isSelected()) {
                this.jTextField_VolumeDB.setEnabled(true);
                this.jTextField_VolumeDB.setText(String.valueOf(doubleVolumeDB));
                if (o_SoundLineFactor == null) {
                    boolLineChanged = true;
                    o_SoundLineFactor = this.m_Sound_Lines.getRemovedSoundLineFactor(this.m_Channel, this.m_Sound_LineNumber);
                    if (o_SoundLineFactor != null) {
                        doubleVolumeFactor = o_SoundLineFactor.getVolumeFactor();
                    }
                    if (this.m_Sound_Lines_Parent != null) {
                        this.m_Sound_Lines_Parent.addSoundLineFactor(this.m_Channel, this.m_Sound_LineNumber, doubleVolumeFactor, true);
                    } else if (this.m_Sound_Lines != null) {
                        this.m_Sound_Lines.addSoundLineFactor(this.m_Channel, this.m_Sound_LineNumber, doubleVolumeFactor, false);
                    }
                } else {
                    boolLineChanged = false;
                    if (o_SoundLineFactor.getVolumeFactor() == doubleVolumeFactor) {
                        return;
                    }
                    if (this.m_Sound_Lines_Parent != null) {
                        this.m_Sound_Lines_Parent.addSoundLineFactor(this.m_Channel, this.m_Sound_LineNumber, doubleVolumeFactor, true);
                    } else if (this.m_Sound_Lines != null) {
                        this.m_Sound_Lines.addSoundLineFactor(this.m_Channel, this.m_Sound_LineNumber, doubleVolumeFactor, false);
                    }
                }
            } else if (o_SoundLineFactor != null) {
                boolLineChanged = true;
                if (this.m_Sound_Lines_Parent != null) {
                    this.m_Sound_Lines_Parent.removeSoundLineFactor(this.m_Channel, this.m_Sound_LineNumber);
                } else if (this.m_Sound_Lines != null) {
                    this.m_Sound_Lines.removeSoundLineFactor(this.m_Channel, this.m_Sound_LineNumber);
                }
            }
            if (this.m_Sound_Channel_LinesPanel != null) {
                this.m_Sound_Channel_LinesPanel.notifyUserInput();
            }
        }
        this.refreshGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSound_Lines_Parent(SoundMixers.Sound_Lines_Parent p_Sound_Lines_Parent) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.m_Sound_Lines_Parent = p_Sound_Lines_Parent;
            this.m_Sound_Lines = this.m_Sound_Lines_Parent != null ? this.m_Sound_Lines_Parent.getSound_Lines() : null;
        }
        this.refreshGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSound_Lines(SoundMixers.Sound_Lines p_Sound_Lines) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.m_Sound_Lines_Parent = null;
            this.m_Sound_Lines = p_Sound_Lines;
        }
        this.refreshGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshGUI() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            SoundMixers.SoundLineFactor o_SoundLineFactor;
            SoundMixers.Sound_Lines o_Sound_Lines = this.m_Sound_Lines;
            this.jCheckBox_Line.setSelected(false);
            this.jTextField_VolumeDB.setText("");
            this.jTextField_VolumeDB.setBorder(null);
            this.jTextField_VolumeDB.setEnabled(false);
            if (o_Sound_Lines != null && (o_SoundLineFactor = o_Sound_Lines.getSoundLineFactor(this.m_Channel, this.m_Sound_LineNumber)) != null) {
                this.jCheckBox_Line.setSelected(true);
                double doubleVolumeDB = BioMathematics.calculateDB_FromVolumeFactor(o_SoundLineFactor.getVolumeFactor());
                doubleVolumeDB = doubleVolumeDB > 0.0 ? (double)((int)(doubleVolumeDB * 10.0 + 0.5)) / 10.0 : (double)((int)(doubleVolumeDB * 10.0 - 0.5)) / 10.0;
                this.jTextField_VolumeDB.setText(String.valueOf(doubleVolumeDB));
                this.jTextField_VolumeDB.setBorder(s_TextBorder);
                this.jTextField_VolumeDB.setEnabled(true);
            }
        }
    }

    public void changedExternalSound_Lines() {
        this.refreshGUI();
    }
}

