/*
 * Decompiled with CFR 0.152.
 */
package OS;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class OSChecker {
    public static final int OSGROUP_UNKNOWN = -1;
    public static final int OSGROUP_WINDOWS = 1;
    public static final int OSGROUP_LINUX = 2;
    public static final int OSGROUP_MAC = 3;
    public static final int OSGROUP_SOLARIS = 4;
    public static final int OS_UNKNOWN = -1;
    public static final int OS_WINDOWS = 0;
    public static final int OS_WINDOWSXP = 1;
    public static final int OS_WINDOWSVISTA = 2;
    public static final int OS_WINDOWS7 = 3;
    public static final int OS_WINDOWS8 = 4;
    public static final int OS_WINDOWS10 = 5;
    public static final int OS_WINDOWS11 = 6;
    public static final int OS_LINUX = 100;
    public static final int OS_MAC = 1000;
    public static final int OS_SOLARIS = 10000;
    public static final int OS_32 = 32;
    public static final int OS_64 = 64;
    public static String s_ProgramName;
    private static int s_OSGroup;
    private static int s_OSFlag;
    private static int s_OSARchitectureFlag;
    private static String s_OSVersion;
    private static String s_OSName;
    private static String s_OSArchitecture;
    private static File s_FileJavaHome;
    private static File s_FileUserHome;
    private static File s_FileUserHomeConfig;
    private static boolean s_OSChecked;
    private static boolean s_JavaHomeChecked;
    private static boolean s_UserHomeChecked;
    private static boolean s_WindowsAeroChecked;
    private static boolean s_WindowsMustStopAero;

    public static int getOSGroupFlag() {
        if (!s_OSChecked) {
            OSChecker.checkOS();
        }
        return s_OSGroup;
    }

    public static int getOSFlag() {
        if (!s_OSChecked) {
            OSChecker.checkOS();
        }
        return s_OSFlag;
    }

    public static String getOSName() {
        if (!s_OSChecked) {
            OSChecker.checkOS();
        }
        return s_OSName;
    }

    public static String getOSVersion() {
        if (!s_OSChecked) {
            OSChecker.checkOS();
        }
        return s_OSVersion;
    }

    public static int getOSArchitectureFlag() {
        if (!s_OSChecked) {
            OSChecker.checkOS();
        }
        return s_OSARchitectureFlag;
    }

    public static String getOSArchitecture() {
        if (!s_OSChecked) {
            OSChecker.checkOS();
        }
        return s_OSArchitecture;
    }

    public static boolean getIsWindows() {
        if (!s_OSChecked) {
            OSChecker.checkOS();
        }
        return s_OSGroup == 1;
    }

    public static boolean getIsMac() {
        if (!s_OSChecked) {
            OSChecker.checkOS();
        }
        return s_OSGroup == 3;
    }

    public static boolean getIsLinux() {
        if (!s_OSChecked) {
            OSChecker.checkOS();
        }
        return s_OSGroup == 2;
    }

    public static void setProgramName(String p_ProgramName) {
        if (p_ProgramName == null || p_ProgramName.length() <= 0) {
            p_ProgramName = "unknown";
        }
        s_ProgramName = p_ProgramName;
    }

    public static boolean checkProgramStart(String p_ProgramName) {
        boolean boolOK = true;
        OSChecker.setProgramName(p_ProgramName);
        if (!s_OSChecked) {
            OSChecker.checkOS();
        }
        if (!s_JavaHomeChecked) {
            boolOK = OSChecker.checkJavaHome();
        }
        if (!s_UserHomeChecked) {
            boolOK = OSChecker.checkUserHome();
        }
        if (!boolOK) {
            return false;
        }
        if (!boolOK) {
            return false;
        }
        OSChecker.getUserHomeConfigDirectory();
        String stringShellAnswer = "";
        switch (s_OSGroup) {
            case 1: {
                if (!(s_OSFlag != 2 && s_OSFlag != 3 || s_WindowsAeroChecked)) {
                    boolOK = OSChecker.checkWindowsAero();
                }
                if (!boolOK) {
                    return false;
                }
                if (!s_WindowsMustStopAero) break;
                File o_WindowsShellFileAdmin = OSChecker.make_WindowsShell_StartConfig();
                if (!o_WindowsShellFileAdmin.exists()) {
                    return false;
                }
                stringShellAnswer = OSChecker.executeShell(o_WindowsShellFileAdmin);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        return stringShellAnswer != null;
    }

    public static boolean checkProgramClose() {
        boolean boolOK = true;
        String stringShellAnswer = "";
        switch (s_OSGroup) {
            case 1: {
                if (s_OSFlag != 2 && s_OSFlag != 3 || !s_WindowsMustStopAero) break;
                File o_WindowsShellFileAdmin = OSChecker.make_WindowsShell_CloseConfig();
                if (!o_WindowsShellFileAdmin.exists()) {
                    return false;
                }
                stringShellAnswer = OSChecker.executeShell(o_WindowsShellFileAdmin);
                break;
            }
        }
        return stringShellAnswer != null;
    }

    public static int checkOS() {
        s_OSName = System.getProperty("os.name");
        s_OSVersion = System.getProperty("os.version");
        s_OSArchitecture = System.getProperty("os.arch");
        s_OSARchitectureFlag = OSChecker.checkOSArchitecture();
        String stringOS = System.getProperty("os.name").toLowerCase();
        if (stringOS.indexOf("win") >= 0) {
            s_OSGroup = 1;
            s_OSFlag = stringOS.indexOf("11") >= 0 ? 6 : (stringOS.indexOf("10") >= 0 ? 5 : (stringOS.indexOf("8") >= 0 ? 4 : (stringOS.indexOf("7") >= 0 ? 3 : (stringOS.indexOf("vista") >= 0 ? 2 : (stringOS.indexOf("xp") >= 0 ? 1 : 0)))));
        } else if (stringOS.indexOf("mac") >= 0) {
            s_OSGroup = 3;
            s_OSFlag = 1000;
        } else if (stringOS.indexOf("nix") >= 0 || stringOS.indexOf("nux") >= 0) {
            s_OSGroup = 2;
            s_OSFlag = 100;
        } else if (stringOS.indexOf("sunos") >= 0) {
            s_OSGroup = 4;
            s_OSFlag = 10000;
        } else {
            s_OSGroup = -1;
            s_OSFlag = -1;
        }
        s_OSChecked = true;
        return s_OSFlag;
    }

    private static int checkOSArchitecture() {
        String stringOSArchitecture = System.getProperty("os.arch").toLowerCase();
        if (stringOSArchitecture.indexOf("64") >= 0) {
            s_OSARchitectureFlag = 64;
            return s_OSARchitectureFlag;
        }
        s_OSARchitectureFlag = 32;
        return s_OSARchitectureFlag;
    }

    public static String getPathJavaHomeDirectory() {
        if (!s_JavaHomeChecked) {
            OSChecker.checkJavaHome();
        }
        if (s_FileJavaHome == null) {
            return null;
        }
        return s_FileJavaHome.getAbsolutePath();
    }

    public static File getJavaHomeDirectory() {
        if (!s_JavaHomeChecked) {
            OSChecker.checkJavaHome();
        }
        return s_FileJavaHome;
    }

    public static String getPathUserHomeDirectory() {
        if (!s_UserHomeChecked) {
            OSChecker.checkUserHome();
        }
        if (s_FileUserHome == null) {
            return null;
        }
        return s_FileUserHome.getAbsolutePath();
    }

    public static File getUserHomeDirectory() {
        if (!s_UserHomeChecked) {
            OSChecker.checkUserHome();
        }
        return s_FileUserHome;
    }

    public static String getPathUserHomeConfigDirectory() {
        if (s_FileUserHomeConfig == null) {
            OSChecker.getUserHomeConfigDirectory();
        }
        return s_FileUserHomeConfig.getAbsolutePath();
    }

    public static File getUserHomeConfigDirectory() {
        if (s_FileUserHome == null) {
            OSChecker.getUserHomeDirectory();
        }
        if (s_FileUserHomeConfig == null && !(s_FileUserHomeConfig = new File(s_FileUserHome.getAbsolutePath() + "/." + s_ProgramName)).exists() && !s_FileUserHomeConfig.mkdir()) {
            System.out.println("Error: Cannot create User Config Directory: " + s_FileUserHomeConfig.getAbsolutePath());
        }
        return s_FileUserHomeConfig;
    }

    public static boolean getWindowsAeroWasRunning() {
        return s_WindowsMustStopAero;
    }

    public static boolean checkJavaHome() {
        s_FileJavaHome = new File(System.getProperty("java.home"));
        s_JavaHomeChecked = true;
        System.out.println("****** Java.home: " + s_FileJavaHome + " ******");
        if (!s_FileJavaHome.exists()) {
            s_FileJavaHome = null;
            return false;
        }
        return true;
    }

    public static boolean checkUserHome() {
        s_FileUserHome = new File(System.getProperty("user.home"));
        s_UserHomeChecked = true;
        if (!s_FileUserHome.exists()) {
            s_FileUserHome = null;
            return false;
        }
        return true;
    }

    public static boolean checkWindowsAero() {
        s_WindowsMustStopAero = false;
        if (s_OSFlag == 3 || s_OSFlag == 2) {
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append("@ECHO OFF \n for /f \"tokens=2*\" %%a in ('sc query uxsms ^| findstr STATE') do echo %%b");
            File o_ShellFile = new File(OSChecker.getPathUserHomeConfigDirectory() + "/Windows_CheckAero.bat");
            try {
                if (o_ShellFile.exists()) {
                    o_ShellFile.delete();
                }
                o_ShellFile.createNewFile();
                FileWriter o_FileWriter = new FileWriter(o_ShellFile);
                BufferedWriter o_BufferedWriter = new BufferedWriter(o_FileWriter);
                o_BufferedWriter.write(o_StringBuilder.toString());
                o_BufferedWriter.flush();
                o_BufferedWriter.close();
                o_FileWriter.close();
                String stringAnswer = null;
                stringAnswer = OSChecker.executeShell(o_ShellFile);
                if (stringAnswer == null) {
                    return false;
                }
                if (stringAnswer.toLowerCase().contains("run")) {
                    s_WindowsMustStopAero = true;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public static File make_WindowsShell_StartConfig() {
        BufferedWriter o_BufferedWriter;
        FileWriter o_FileWriter;
        StringBuilder o_StringBuilder = new StringBuilder();
        if (s_WindowsMustStopAero) {
            if (s_WindowsMustStopAero) {
                o_StringBuilder.append("net stop uxsms");
            }
        } else {
            o_StringBuilder.append("REM All OK");
        }
        File o_ShellFile = new File(OSChecker.getPathUserHomeConfigDirectory() + "\\Windows_StartConfig.bat");
        try {
            if (o_ShellFile.exists()) {
                o_ShellFile.delete();
            }
            o_ShellFile.createNewFile();
            o_FileWriter = new FileWriter(o_ShellFile);
            o_BufferedWriter = new BufferedWriter(o_FileWriter);
            o_BufferedWriter.write(o_StringBuilder.toString());
            o_BufferedWriter.flush();
            o_BufferedWriter.close();
            o_FileWriter.close();
            o_ShellFile.setExecutable(true);
        }
        catch (IOException e) {
            return null;
        }
        if (s_OSFlag == 0 || s_OSFlag == 1) {
            return o_ShellFile;
        }
        o_StringBuilder = new StringBuilder();
        if (s_WindowsMustStopAero) {
            o_StringBuilder.append("set currentpath=" + OSChecker.getPathUserHomeConfigDirectory() + "\\Windows_StartConfig.bat\n");
            o_StringBuilder.append("echo Set UAC = CreateObject(\"Shell.Application\") > \"" + OSChecker.getPathUserHomeConfigDirectory() + "\\WindowsAdmin.vbs\"\n");
            o_StringBuilder.append("echo call UAC.ShellExecute(\"%currentpath%\" , \"\", \"\", \"runas\", 1) >> \"" + OSChecker.getPathUserHomeConfigDirectory() + "\\WindowsAdmin.vbs\"\n");
            o_StringBuilder.append("\"" + OSChecker.getPathUserHomeConfigDirectory() + "\\WindowsAdmin.vbs\"");
        } else {
            o_StringBuilder.append("REM All OK");
        }
        File o_AdminShellFile = new File(OSChecker.getPathUserHomeConfigDirectory() + "\\WindowsAdmin_Start.bat");
        try {
            if (o_AdminShellFile.exists()) {
                o_AdminShellFile.delete();
            }
            o_AdminShellFile.createNewFile();
            o_FileWriter = new FileWriter(o_AdminShellFile);
            o_BufferedWriter = new BufferedWriter(o_FileWriter);
            o_BufferedWriter.write(o_StringBuilder.toString());
            o_BufferedWriter.flush();
            o_BufferedWriter.close();
            o_FileWriter.close();
            o_AdminShellFile.setExecutable(true);
        }
        catch (IOException e) {
            return null;
        }
        return o_AdminShellFile;
    }

    public static File make_WindowsShell_CloseConfig() {
        BufferedWriter o_BufferedWriter;
        FileWriter o_FileWriter;
        StringBuilder o_StringBuilder = new StringBuilder();
        if (s_WindowsMustStopAero) {
            o_StringBuilder.append("net start uxsms");
        } else {
            o_StringBuilder.append("REM All OK");
        }
        File o_ShellFile = new File(OSChecker.getPathUserHomeConfigDirectory() + "\\Windows_CloseConfig.bat");
        try {
            if (o_ShellFile.exists()) {
                o_ShellFile.delete();
            }
            o_ShellFile.createNewFile();
            o_FileWriter = new FileWriter(o_ShellFile);
            o_BufferedWriter = new BufferedWriter(o_FileWriter);
            o_BufferedWriter.write(o_StringBuilder.toString());
            o_BufferedWriter.flush();
            o_BufferedWriter.close();
            o_FileWriter.close();
            o_ShellFile.setExecutable(true);
        }
        catch (IOException e) {
            return null;
        }
        o_StringBuilder = new StringBuilder();
        if (s_WindowsMustStopAero) {
            o_StringBuilder.append("set currentpath=" + OSChecker.getPathUserHomeConfigDirectory() + "\\Windows_CloseConfig.bat\n");
            o_StringBuilder.append("echo Set UAC = CreateObject(\"Shell.Application\") > \"" + OSChecker.getPathUserHomeConfigDirectory() + "\\WindowsAdmin.vbs\"\n");
            o_StringBuilder.append("echo call UAC.ShellExecute(\"%currentpath%\" , \"\", \"\", \"runas\", 1) >> \"" + OSChecker.getPathUserHomeConfigDirectory() + "\\WindowsAdmin.vbs\"\n");
            o_StringBuilder.append("\"" + OSChecker.getPathUserHomeConfigDirectory() + "\\WindowsAdmin.vbs\"");
        } else {
            o_StringBuilder.append("REM All OK");
        }
        File o_AdminShellFile = new File(OSChecker.getPathUserHomeConfigDirectory() + "\\WindowsAdmin_Close.bat");
        try {
            if (o_AdminShellFile.exists()) {
                o_AdminShellFile.delete();
            }
            o_AdminShellFile.createNewFile();
            o_FileWriter = new FileWriter(o_AdminShellFile);
            o_BufferedWriter = new BufferedWriter(o_FileWriter);
            o_BufferedWriter.write(o_StringBuilder.toString());
            o_BufferedWriter.flush();
            o_BufferedWriter.close();
            o_FileWriter.close();
            o_AdminShellFile.setExecutable(true);
        }
        catch (IOException e) {
            return null;
        }
        return o_AdminShellFile;
    }

    public static String executeShell(File p_File_Shell) {
        ArrayList<String> o_ShellCommands = new ArrayList<String>();
        o_ShellCommands.add(p_File_Shell.getAbsolutePath());
        ProcessBuilder o_ProcessBuilder = new ProcessBuilder(o_ShellCommands);
        o_ProcessBuilder.redirectErrorStream(true);
        Process o_ShellProcess = null;
        try {
            o_ShellProcess = o_ProcessBuilder.start();
        }
        catch (IOException e) {
            return null;
        }
        StringBuilder stringShellOutput = new StringBuilder();
        BufferedReader o_BufferedReader = new BufferedReader(new InputStreamReader(o_ShellProcess.getInputStream()));
        String stringLine = null;
        String stringPrevious = null;
        try {
            while ((stringLine = o_BufferedReader.readLine()) != null) {
                if (stringLine.equals(stringPrevious)) continue;
                stringPrevious = stringLine;
                stringShellOutput.append(stringLine).append('\n');
            }
            o_BufferedReader.close();
        }
        catch (IOException e) {
            try {
                o_BufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        try {
            if (o_ShellProcess.waitFor() != 0) {
                System.err.println(stringShellOutput.toString());
            }
        }
        catch (InterruptedException e) {
            return null;
        }
        return stringShellOutput.toString();
    }

    static {
        s_OSChecked = false;
        s_JavaHomeChecked = false;
        s_UserHomeChecked = false;
        s_WindowsAeroChecked = false;
        s_WindowsMustStopAero = false;
    }
}

