/*
 * Decompiled with CFR 0.152.
 */
package LiveShowVirtualPackage;

import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPTrackListener;
import SynchronizationPackage.LiveCloseSemaphore;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.util.ArrayList;

public abstract class LiveShowVIPTrack
implements LiveShowObjectListener {
    protected LiveShowVIP m_LiveShowVIP;
    protected DataFlavor m_DataFlavor;
    protected FlavorMap m_DataFlavorMap;
    protected ArrayList<LiveShowObjectInterface> m_LiveShowObjectInterfaces;
    protected ArrayList<LiveShowVIPTrackListener> m_LiveShowVIPTrackListeners;
    protected long m_ObjectsFrameMax;
    protected LiveCloseSemaphore m_LiveCloseSemaphore;
    protected final Object m_SyncVIPTrackListeners = new Object();
    protected final Object m_SyncVIPObjects = new Object();

    public LiveShowVIPTrack(LiveShowVIP p_LiveShowVIP) {
        this.initMembers();
        this.m_LiveShowVIP = p_LiveShowVIP;
        this.m_DataFlavor = this.m_LiveShowVIP.getDataFlavor();
        this.m_DataFlavorMap = this.m_LiveShowVIP.getDataFlavorMap();
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_LiveShowVIPTrackListeners = new ArrayList();
        this.m_LiveShowObjectInterfaces = new ArrayList();
        this.m_ObjectsFrameMax = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.notifyLiveShowVIPTrackListeners_Closing();
        Object object = this.m_SyncVIPTrackListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPTrackListeners != null) {
                this.m_LiveShowVIPTrackListeners.clear();
                this.m_LiveShowVIPTrackListeners = null;
            }
        }
        ArrayList<LiveShowObjectInterface> o_LiveShowObjectInterfaces = null;
        Object object2 = this.m_SyncVIPObjects;
        synchronized (object2) {
            if (this.m_LiveShowObjectInterfaces != null) {
                o_LiveShowObjectInterfaces = new ArrayList<LiveShowObjectInterface>(this.m_LiveShowObjectInterfaces.size());
                o_LiveShowObjectInterfaces.addAll(this.m_LiveShowObjectInterfaces);
            }
        }
        if (o_LiveShowObjectInterfaces != null) {
            int intVIPObjectCount = o_LiveShowObjectInterfaces.size();
            for (int intVIPObject = intVIPObjectCount - 1; intVIPObject >= 0; --intVIPObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = (LiveShowObjectInterface)o_LiveShowObjectInterfaces.get(intVIPObject);
                if (o_LiveShowObjectInterface != null) {
                    o_LiveShowObjectInterface.close(true);
                }
                this.removeLiveShowObjectInterface(o_LiveShowObjectInterface);
                this.m_LiveShowVIP.removeLiveShowObject(o_LiveShowObjectInterface);
            }
        }
        this.m_LiveShowObjectInterfaces = null;
        if (this.m_LiveShowVIP != null) {
            this.m_LiveShowVIP = null;
        }
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public LiveShowVIP getLiveShowVIP() {
        return this.m_LiveShowVIP;
    }

    public DataFlavor getDataFlavor() {
        return this.m_DataFlavor;
    }

    public FlavorMap getDataFlavorMap() {
        return this.m_DataFlavorMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLiveShowObjectInterface(LiveShowObjectInterface p_LiveShowObjectInterface, long p_FramePosition) {
        if (p_LiveShowObjectInterface == null) {
            return false;
        }
        boolean boolAdded = false;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return false;
        }
        Object object = this.m_SyncVIPObjects;
        synchronized (object) {
            if (!this.m_LiveShowObjectInterfaces.contains(p_LiveShowObjectInterface)) {
                p_LiveShowObjectInterface.changeStartPosition(p_FramePosition);
                p_LiveShowObjectInterface.setVIPTrackNumber(o_LiveShowVIP.getLiveShowVIPTrackNumber(this));
                this.addSorted_LiveShowObjectInterface(p_LiveShowObjectInterface);
                p_LiveShowObjectInterface.setOwner(this);
                o_LiveShowVIP.addLiveShowObject(p_LiveShowObjectInterface);
                p_LiveShowObjectInterface.addLiveShowObjectListener(this);
                boolAdded = true;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (boolAdded) {
            this.notifyLiveShowVIPTrackListeners_ObjectInterfaceAdded(p_LiveShowObjectInterface);
        }
        return boolAdded;
    }

    private void addSorted_LiveShowObjectInterface(LiveShowObjectInterface p_LiveShowObject) {
        LiveShowObjectInterface o_LiveShowObject;
        int intLiveShowObject;
        for (intLiveShowObject = 0; intLiveShowObject < this.m_LiveShowObjectInterfaces.size() && ((o_LiveShowObject = this.m_LiveShowObjectInterfaces.get(intLiveShowObject)) == null || o_LiveShowObject.getFrameStart() < p_LiveShowObject.getFrameStart() || o_LiveShowObject.getFrameStart() == p_LiveShowObject.getFrameStart() && (o_LiveShowObject instanceof LiveShowSceneBridge && !(p_LiveShowObject instanceof LiveShowSceneBridge) || o_LiveShowObject.getFrameStart() + o_LiveShowObject.getFrameLength() > p_LiveShowObject.getFrameStart() + p_LiveShowObject.getFrameLength())); ++intLiveShowObject) {
        }
        this.m_LiveShowObjectInterfaces.add(intLiveShowObject, p_LiveShowObject);
    }

    private void resort_LiveShowObject(LiveShowObjectInterface p_LiveShowObject) {
        LiveShowObjectInterface o_LiveShowObject;
        int intObject;
        if (this.m_LiveShowObjectInterfaces.size() < 2) {
            return;
        }
        int intIndex = this.m_LiveShowObjectInterfaces.indexOf(p_LiveShowObject);
        if (intIndex < 0) {
            return;
        }
        for (intObject = 0; intObject < this.m_LiveShowObjectInterfaces.size() && ((o_LiveShowObject = this.m_LiveShowObjectInterfaces.get(intObject)) == null || intObject == intIndex || o_LiveShowObject.getFrameStart() < p_LiveShowObject.getFrameStart() || o_LiveShowObject.getFrameStart() == p_LiveShowObject.getFrameStart() && (o_LiveShowObject instanceof LiveShowSceneBridge && !(p_LiveShowObject instanceof LiveShowSceneBridge) || o_LiveShowObject.getFrameStart() + o_LiveShowObject.getFrameLength() > p_LiveShowObject.getFrameStart() + p_LiveShowObject.getFrameLength())); ++intObject) {
        }
        if (intObject == intIndex + 1) {
            return;
        }
        if (intObject < intIndex) {
            this.m_LiveShowObjectInterfaces.remove(p_LiveShowObject);
            this.m_LiveShowObjectInterfaces.add(intObject, p_LiveShowObject);
        }
        if (intObject > intIndex) {
            this.m_LiveShowObjectInterfaces.remove(p_LiveShowObject);
            this.m_LiveShowObjectInterfaces.add(intObject - 1, p_LiveShowObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveShowObjectInterfaceCount() {
        int intObjectInterfaceCount;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return 0;
        }
        Object object = this.m_SyncVIPObjects;
        synchronized (object) {
            intObjectInterfaceCount = this.m_LiveShowObjectInterfaces.size();
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return intObjectInterfaceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLiveShowObjectInterface(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncVIPObjects;
        synchronized (object) {
            boolRemoved = this.m_LiveShowObjectInterfaces.remove(p_LiveShowObjectInterface);
            if (boolRemoved) {
                p_LiveShowObjectInterface.removeLiveShowObjectListener(this);
                p_LiveShowObjectInterface.setOwner(null);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (boolRemoved) {
            this.notifyLiveShowVIPTrackListeners_ObjectInterfaceRemoved(p_LiveShowObjectInterface);
        }
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowObjectInterface getLiveShowObjectInterface(int p_Index) {
        LiveShowObjectInterface o_LiveShowObjectInterface;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncVIPObjects;
        synchronized (object) {
            o_LiveShowObjectInterface = p_Index < 0 || p_Index >= this.m_LiveShowObjectInterfaces.size() ? null : this.m_LiveShowObjectInterfaces.get(p_Index);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowObjectInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowObjectInterface findLiveShowObjectInterface(String p_ID) {
        if (p_ID == null || p_ID.length() <= 0) {
            return null;
        }
        LiveShowObjectInterface o_LiveShowObjectInterface = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncVIPObjects;
        synchronized (object) {
            for (int intObject = 0; intObject < this.m_LiveShowObjectInterfaces.size(); ++intObject) {
                o_LiveShowObjectInterface = this.m_LiveShowObjectInterfaces.get(intObject);
                if (o_LiveShowObjectInterface == null) continue;
                if (p_ID.equals(o_LiveShowObjectInterface.getID())) break;
                o_LiveShowObjectInterface = null;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowObjectInterface;
    }

    public boolean containsLiveShowObjectInterface(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return false;
        }
        boolean boolContains = false;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolContains = this.m_LiveShowObjectInterfaces.contains(p_LiveShowObjectInterface);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolContains;
    }

    @Override
    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_ObjectDescription) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        if (p_LiveShowObjectInterface.getChangedStartLengthSinceLastNotification()) {
            this.resort_LiveShowObject(p_LiveShowObjectInterface);
        }
        this.notifyLiveShowVIPTrackListeners_ObjectInterfaceChanged(p_LiveShowObjectInterface);
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
    }

    @Override
    public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return;
        }
        this.removeLiveShowObjectInterface(p_LiveShowObjectInterface);
        this.m_LiveShowVIP.removeLiveShowObject(p_LiveShowObjectInterface);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
    }

    @Override
    public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLiveShowVIPTrackListener(LiveShowVIPTrackListener p_LiveShowVIPTrackListener) {
        if (p_LiveShowVIPTrackListener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAdded = false;
        Object object = this.m_SyncVIPTrackListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPTrackListeners != null && !this.m_LiveShowVIPTrackListeners.contains(p_LiveShowVIPTrackListener)) {
                this.m_LiveShowVIPTrackListeners.add(p_LiveShowVIPTrackListener);
                boolAdded = true;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLiveShowVIPTrackListener(LiveShowVIPTrackListener p_LiveShowVIPTrackListener) {
        if (p_LiveShowVIPTrackListener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncVIPTrackListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPTrackListeners != null) {
                boolRemoved = this.m_LiveShowVIPTrackListeners.remove(p_LiveShowVIPTrackListener);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPTrackListeners_ObjectInterfaceAdded(LiveShowObjectInterface p_LiveShowObjectInterface) {
        ArrayList<LiveShowVIPTrackListener> o_LiveShowVIPTrackListeners;
        Object object = this.m_SyncVIPTrackListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPTrackListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPTrackListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPTrackListeners = new ArrayList<LiveShowVIPTrackListener>(this.m_LiveShowVIPTrackListeners.size());
            o_LiveShowVIPTrackListeners.addAll(this.m_LiveShowVIPTrackListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPTrackListeners.size(); ++intListener) {
            LiveShowVIPTrackListener o_Listener = (LiveShowVIPTrackListener)o_LiveShowVIPTrackListeners.get(intListener);
            o_Listener.eventVIPTrackObjectInterfaceAdded(this, p_LiveShowObjectInterface);
        }
        o_LiveShowVIPTrackListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPTrackListeners_ObjectInterfaceRemoved(LiveShowObjectInterface p_LiveShowObjectInterface) {
        ArrayList<LiveShowVIPTrackListener> o_LiveShowVIPTrackListeners;
        Object object = this.m_SyncVIPTrackListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPTrackListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPTrackListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPTrackListeners = new ArrayList<LiveShowVIPTrackListener>(this.m_LiveShowVIPTrackListeners.size());
            o_LiveShowVIPTrackListeners.addAll(this.m_LiveShowVIPTrackListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPTrackListeners.size(); ++intListener) {
            LiveShowVIPTrackListener o_Listener = (LiveShowVIPTrackListener)o_LiveShowVIPTrackListeners.get(intListener);
            o_Listener.eventVIPTrackObjectInterfaceRemoved(this, p_LiveShowObjectInterface);
        }
        o_LiveShowVIPTrackListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPTrackListeners_ObjectInterfaceChanged(LiveShowObjectInterface p_LiveShowObjectInterface) {
        ArrayList<LiveShowVIPTrackListener> o_LiveShowVIPTrackListeners;
        Object object = this.m_SyncVIPTrackListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPTrackListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPTrackListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPTrackListeners = new ArrayList<LiveShowVIPTrackListener>(this.m_LiveShowVIPTrackListeners.size());
            o_LiveShowVIPTrackListeners.addAll(this.m_LiveShowVIPTrackListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPTrackListeners.size(); ++intListener) {
            LiveShowVIPTrackListener o_Listener = (LiveShowVIPTrackListener)o_LiveShowVIPTrackListeners.get(intListener);
            o_Listener.eventVIPTrackObjectParamChanged(this, p_LiveShowObjectInterface);
        }
        o_LiveShowVIPTrackListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPTrackListeners_Closing() {
        ArrayList<LiveShowVIPTrackListener> o_LiveShowVIPTrackListeners;
        Object object = this.m_SyncVIPTrackListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPTrackListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPTrackListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPTrackListeners = new ArrayList<LiveShowVIPTrackListener>(this.m_LiveShowVIPTrackListeners.size());
            o_LiveShowVIPTrackListeners.addAll(this.m_LiveShowVIPTrackListeners);
            this.m_LiveShowVIPTrackListeners.clear();
        }
        int intListenerCount = o_LiveShowVIPTrackListeners.size();
        for (int intListener = intListenerCount - 1; intListener >= 0 && o_LiveShowVIPTrackListeners.size() > 0; --intListener) {
            LiveShowVIPTrackListener o_Listener = (LiveShowVIPTrackListener)o_LiveShowVIPTrackListeners.get(intListener);
            o_Listener.eventVIPTrackClosing(this);
            o_LiveShowVIPTrackListeners.remove(o_Listener);
        }
        o_LiveShowVIPTrackListeners.clear();
    }
}

