/*
 * Decompiled with CFR 0.152.
 */
package LiveShowObjectPackage;

import FileToolPackage.FileSelection;
import FileToolPackage.FileTools;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShow_ExportDescription;
import SPITModelPackage.SPIT_ObjectModel;
import SPITModelPackage.SPIT_TypeModel;
import SoundPackage.SoundMixers;
import SwingFramePackage.JOptionDialog;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;

public class LiveShowProjectDescription
implements Externalizable {
    public static final int SOFTWAREVERSION = 2;
    public static final int PROJECTSTATUS_NEW = 0;
    public static final int PROJECTSTATUS_PROPERTYIESSET = 1;
    public static final int PROJECTSTATUS_EXSTING = 2;
    public static final int PROJECTSTATUS_CHANGED = 3;
    @LiveLanguageString
    public static String PROJECT_NEWPROJECT = "New_Project";
    @LiveLanguageString
    public static String LABEL_SOUND = "Sound";
    @LiveLanguageString
    public static String LABEL_DMX = "Light";
    @LiveLanguageString
    public static String LABEL_SCENEBRIDGES = "Scenebridges";
    @LiveLanguageString
    public static String LABEL_OBJECTS = "Objects";
    @LiveLanguageString
    public static String LABEL_JINGLES = "Jingles";
    @LiveLanguageString
    public static String LABEL_LENGTH = "Length";
    @LiveLanguageString
    public static String PROJECT_FILEDESCRIPTION = "LiveShowProject";
    public static final String FILESUFFIX = ".lsp";
    public static final String SCREEN_FILESUFFIX = ".lsc";
    @LiveLanguageString
    public static String PROJECT_SAVE = "Do you want to save the actual project?";
    @LiveLanguageString
    public static String PROJECT_LOADTITEL = "Load";
    @LiveLanguageString
    public static String PROJECT_SAVETITEL = "Save";
    @LiveLanguageString
    public static String PROJECT_OVERWRITECONTENT = "Do you want to overwrite the project?";
    @LiveLanguageString
    public static String PROJECT_OVERWRITETITLE = "Overwrite existing Project";
    @LiveLanguageString
    public static String PROJECT_NOWRITEPERMISSION_TITLE = "No write permission: ";
    @LiveLanguageString
    public static String PROJECT_NOWRITEPERMISSION_LOADCONTENT = "You can't load a project from a location with no write permissions!";
    @LiveLanguageString
    public static String PROJECT_NOWRITEPERMISSION_SAVECONTENT = "You own no write permissiion, please choose another directory!";
    private String m_ProjectName;
    private String m_ProjectPath;
    private String m_ProjectDescription;
    private int m_ProjectStatus;
    private String m_ProjectStatistic;
    private AudioFormat m_AudioFormat;
    public static File s_LastOpenedFile;
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    public static final String PROP_PROJECTDESCRIPTION = "projectDescription";
    public static final String PROP_PROJECTDESCRIPTION_PROJECTSTATUS = "projectStatus";
    public static final String PROP_PROJECTDESCRIPTION_PROJECTPROPERTIES = "projectProperties";
    public static final String PROP_PROJECTAUDIOFORMAT = "projectAudioFormat";

    public LiveShowProjectDescription() {
        this.initMembers();
        LiveLanguage.addLanguageListener(this, null);
        this.m_ProjectName = PROJECT_NEWPROJECT;
    }

    public LiveShowProjectDescription(File p_FileLastOpened) {
        this.initMembers();
        LiveLanguage.addLanguageListener(this, null);
        this.m_ProjectName = PROJECT_NEWPROJECT;
        if (p_FileLastOpened != null && p_FileLastOpened.exists()) {
            if (p_FileLastOpened.isDirectory()) {
                this.m_ProjectPath = p_FileLastOpened.getPath();
                this.m_ProjectName = PROJECT_NEWPROJECT;
            } else {
                this.m_ProjectPath = p_FileLastOpened.getParent();
                this.m_ProjectName = p_FileLastOpened.getName();
                if (this.m_ProjectName.endsWith(FILESUFFIX)) {
                    this.m_ProjectName = this.m_ProjectName.substring(0, this.m_ProjectName.length() - FILESUFFIX.length());
                }
            }
        }
        if (this.m_ProjectPath == null) {
            this.m_ProjectPath = "";
        }
    }

    private void initMembers() {
        this.m_ProjectPath = "";
        this.m_ProjectDescription = "";
        this.m_ProjectStatistic = "";
        this.m_ProjectStatus = 0;
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_AudioFormat = null;
        this.setAudioFormat(SoundMixers.DEFAULT_AUDIOFORMAT);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (out == null) {
            return;
        }
        out.writeInt(2);
        out.writeUTF(this.m_ProjectName);
        out.writeUTF(this.m_ProjectPath);
        out.writeUTF(this.m_ProjectDescription);
        out.writeUTF(this.m_ProjectStatistic);
        LiveShowProjectDescription.writeExternalAudioFormat(out, this.m_AudioFormat);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in == null) {
            return;
        }
        int intSoftwareVersion = in.readInt();
        this.m_ProjectName = in.readUTF();
        this.m_ProjectPath = in.readUTF();
        this.m_ProjectDescription = in.readUTF();
        if (intSoftwareVersion >= 2) {
            this.m_ProjectStatistic = in.readUTF();
        }
        this.setAudioFormat(LiveShowProjectDescription.readExternalAudioFormat(in));
    }

    public static boolean saveLiveShowProjectDescription(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
        try {
            if (o_File.exists()) {
                o_File.delete();
            }
            FileOutputStream o_OutputStream = new FileOutputStream(o_File);
            ObjectOutputStream o_ObjectOutput = new ObjectOutputStream(o_OutputStream);
            o_ObjectOutput.writeInt(2);
            p_LiveShowProjectDescription.writeExternal(o_ObjectOutput);
            o_ObjectOutput.close();
            ((OutputStream)o_OutputStream).close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static LiveShowProjectDescription loadLiveShowProjectDescription(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return null;
        }
        FileInputStream o_InputStream = null;
        ObjectInput o_ObjectInput = null;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
        if (!o_File.exists()) {
            return null;
        }
        try {
            o_InputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_InputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            p_LiveShowProjectDescription.readExternal(o_ObjectInput);
            o_ObjectInput.close();
            ((InputStream)o_InputStream).close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_InputStream != null) {
                    ((InputStream)o_InputStream).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
            return null;
        }
        return p_LiveShowProjectDescription;
    }

    public static File showLoadProjectDescription(LiveShowProjectDescription p_LiveShowProjectDescription) {
        FileNameExtensionFilter o_FileNameExtensionFilter_Project;
        File o_FileSelected;
        File o_File;
        if (p_LiveShowProjectDescription == null) {
            return null;
        }
        String stringPath = null;
        if (p_LiveShowProjectDescription.getProjectPathName() != null && p_LiveShowProjectDescription.getProjectPathName().length() > 0) {
            stringPath = p_LiveShowProjectDescription.getProjectPath();
            String stringName = p_LiveShowProjectDescription.getProjectName();
            o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
            if (!o_File.exists()) {
                o_File = new File(stringPath);
            }
        } else {
            try {
                o_File = FileSystemView.getFileSystemView().getDefaultDirectory();
                String stringName = "";
                stringPath = o_File.getPath();
            }
            catch (Exception e) {
                o_File = null;
            }
        }
        if (o_File == null || !o_File.exists()) {
            o_File = null;
        }
        if ((o_FileSelected = FileSelection.showOpen(null, PROJECT_LOADTITEL, o_File, o_FileNameExtensionFilter_Project = FileSelection.createFileNameExtensionFilter(PROJECT_FILEDESCRIPTION + " (" + FILESUFFIX + ")", FILESUFFIX), true, false)) != null) {
            if (!o_FileSelected.exists()) {
                o_FileSelected = null;
            } else {
                File o_DirectorySelected = o_FileSelected.getParentFile();
                String stringDirectoryPath = "";
                if (o_DirectorySelected != null) {
                    stringDirectoryPath = o_DirectorySelected.getAbsolutePath();
                }
                if (!FileTools.checkWritable(o_DirectorySelected)) {
                    JOptionDialog.showMessageDialog(null, (Object)PROJECT_NOWRITEPERMISSION_LOADCONTENT, (String)(PROJECT_NOWRITEPERMISSION_TITLE + stringDirectoryPath), (int)0);
                    return null;
                }
            }
        }
        if (o_FileSelected == null) {
            return null;
        }
        return o_FileSelected;
    }

    public static boolean checkLiveShowProjectDescription(LiveShowProjectDescription p_LiveShowProjectDescription, File p_File) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        if (p_File == null) {
            return false;
        }
        String stringFileName = p_File.getName();
        if (stringFileName.endsWith(FILESUFFIX)) {
            stringFileName = stringFileName.substring(0, stringFileName.length() - FILESUFFIX.length());
        }
        String stringFilePath = p_File.getParent();
        LiveShowProjectDescription o_LiveShowProjectDescription = new LiveShowProjectDescription();
        o_LiveShowProjectDescription.setProjectProperties(stringFileName, stringFilePath, null);
        o_LiveShowProjectDescription = LiveShowProjectDescription.loadLiveShowProjectDescription(o_LiveShowProjectDescription);
        if (o_LiveShowProjectDescription == null) {
            return false;
        }
        if (!o_LiveShowProjectDescription.checkPathCoincidence(stringFileName, stringFilePath)) {
            o_LiveShowProjectDescription.setProjectProperties(stringFileName, stringFilePath, null);
        }
        o_LiveShowProjectDescription.setProjectStatus(2);
        p_LiveShowProjectDescription = o_LiveShowProjectDescription.copyTo(p_LiveShowProjectDescription);
        return true;
    }

    public static boolean showSaveProjectDescription(LiveShowProjectDescription p_LiveShowProjectDescription, boolean p_Export) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        File o_File = null;
        String stringPath = null;
        stringPath = p_LiveShowProjectDescription.getProjectPath();
        String stringName = p_LiveShowProjectDescription.getProjectName();
        if (stringName == null || stringName.length() <= 0 || p_Export) {
            stringName = "";
        }
        if (stringPath == null || stringPath.length() <= 0) {
            o_File = FileSystemView.getFileSystemView().getDefaultDirectory();
            stringPath = o_File.getAbsolutePath();
        } else {
            o_File = new File(stringPath);
            if (!o_File.exists()) {
                o_File = FileSystemView.getFileSystemView().getDefaultDirectory();
            }
            stringPath = o_File.getAbsolutePath();
        }
        o_File = stringName.length() > 0 ? new File(stringPath + File.separator + stringName) : new File(stringPath);
        FileNameExtensionFilter o_FileNameExtensionFilter_Project = FileSelection.createFileNameExtensionFilter(PROJECT_FILEDESCRIPTION + " (" + FILESUFFIX + ")", FILESUFFIX);
        File o_FileSelected = FileSelection.showSave(null, PROJECT_SAVETITEL, o_File, o_FileNameExtensionFilter_Project, true, false);
        if (o_FileSelected != null) {
            int intOptionAnswer;
            File o_DirectorySelected = o_FileSelected.getParentFile();
            String stringDirectoryPath = "";
            if (o_DirectorySelected != null) {
                stringDirectoryPath = o_DirectorySelected.getAbsolutePath();
            }
            if (!FileTools.checkWritable(o_DirectorySelected)) {
                JOptionDialog.showMessageDialog(null, (Object)PROJECT_NOWRITEPERMISSION_SAVECONTENT, (String)(PROJECT_NOWRITEPERMISSION_TITLE + stringDirectoryPath), (int)0);
                return false;
            }
            String stringFileName = FileTools.getFileNameBase(o_FileSelected);
            stringFileName = o_DirectorySelected.getAbsolutePath() + File.separator + stringFileName + FILESUFFIX;
            o_FileSelected = new File(stringFileName);
            if (o_FileSelected.exists() && (intOptionAnswer = JOptionDialog.showConfirmDialog(null, (Object)PROJECT_OVERWRITECONTENT, (String)PROJECT_OVERWRITETITLE, (int)2, (Object)2)) != 0) {
                o_FileSelected = null;
            }
        }
        if (o_FileSelected == null) {
            return false;
        }
        String stringFileName = o_FileSelected.getName();
        if (stringFileName.endsWith(FILESUFFIX)) {
            stringFileName = stringFileName.substring(0, stringFileName.length() - FILESUFFIX.length());
        }
        String stringFilePath = o_FileSelected.getParent();
        p_LiveShowProjectDescription.setProjectProperties(stringFileName, stringFilePath, null);
        return true;
    }

    public boolean checkPathCoincidence(String p_FileName, String p_PathSource) {
        if (p_PathSource == null) {
            return false;
        }
        if (!p_FileName.equals(this.m_ProjectName)) {
            return false;
        }
        return p_PathSource.equals(this.m_ProjectPath);
    }

    public LiveShowProjectDescription copyTo(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            p_LiveShowProjectDescription = new LiveShowProjectDescription();
        }
        p_LiveShowProjectDescription.setProjectProperties(this.m_ProjectName, this.m_ProjectPath, this.m_ProjectDescription);
        p_LiveShowProjectDescription.setProjectStatistic(this.m_ProjectStatistic);
        p_LiveShowProjectDescription.setAudioFormat(this.m_AudioFormat);
        p_LiveShowProjectDescription.setProjectStatus(this.m_ProjectStatus);
        return p_LiveShowProjectDescription;
    }

    public String getProjectName() {
        return this.m_ProjectName;
    }

    public String getProjectPath() {
        return this.m_ProjectPath;
    }

    public void setProjectProperties(String p_ProjectName, String p_ProjectPath, String p_ProjectDescription) {
        boolean boolChanged = false;
        if (p_ProjectName != null) {
            if (!p_ProjectName.equals(this.m_ProjectName)) {
                boolChanged = true;
            }
            this.m_ProjectName = p_ProjectName;
        }
        if (p_ProjectPath != null) {
            if (!p_ProjectPath.equals(this.m_ProjectPath)) {
                boolChanged = true;
            }
            this.m_ProjectPath = p_ProjectPath;
        }
        if (p_ProjectDescription != null) {
            if (!p_ProjectDescription.equals(this.m_ProjectDescription)) {
                boolChanged = true;
            }
            this.m_ProjectDescription = p_ProjectDescription;
        }
        if (boolChanged) {
            this.m_ProjectStatus = 1;
            this.firePropertyChange(PROP_PROJECTDESCRIPTION_PROJECTPROPERTIES, null, this);
        }
    }

    public String getProjectPathName() {
        return this.m_ProjectPath + File.separator + this.m_ProjectName;
    }

    public void setProjectStatus(int p_Status) {
        if (p_Status < 0 || p_Status > 3) {
            return;
        }
        if (p_Status != this.m_ProjectStatus) {
            if (p_Status == 3 && this.m_ProjectStatus != 2) {
                return;
            }
            int oldValue = this.m_ProjectStatus;
            this.m_ProjectStatus = p_Status;
            this.firePropertyChange(PROP_PROJECTDESCRIPTION_PROJECTSTATUS, oldValue, this.m_ProjectStatus);
        }
    }

    public int getProjectStatus() {
        return this.m_ProjectStatus;
    }

    public void setProjectDescription(String p_ProjectDescription) {
        if (p_ProjectDescription == null) {
            p_ProjectDescription = "";
        }
        if (p_ProjectDescription.equals(this.m_ProjectDescription)) {
            return;
        }
        String oldValue = this.m_ProjectDescription;
        this.m_ProjectDescription = p_ProjectDescription;
        this.firePropertyChange(PROP_PROJECTDESCRIPTION, oldValue, this.m_ProjectDescription);
        this.setProjectStatus(3);
    }

    public String getProjectDescription() {
        return this.m_ProjectDescription;
    }

    public static String calculateProjectStatistic(boolean p_OnlySelected, LiveShow_ExportDescription p_LiveShow_ExportDescription) {
        LiveShowVIP o_LiveShowVIP;
        if (p_LiveShow_ExportDescription == null) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        double doubleFrameTime = 0.0;
        long longFrameStart = Long.MAX_VALUE;
        long longFrameEnd = 0L;
        o_StringBuilder.append("<html>");
        o_StringBuilder.append("<table>");
        for (int intVIP = 0; intVIP < LiveShowVIP.getLiveShowVIPCount() && (o_LiveShowVIP = LiveShowVIP.getLiveShowVIP(intVIP)) != null; ++intVIP) {
            int intJingleCount;
            ArrayList<LiveShowObjectInterface> o_LiveShowObjectInterfaces;
            int intObjectsCount;
            int intSceneBridgeCount;
            o_StringBuilder.append("<tr>");
            o_StringBuilder.append("<td>");
            o_StringBuilder.append(o_LiveShowVIP.getType());
            o_StringBuilder.append("</td>");
            o_StringBuilder.append("<td>");
            if (p_OnlySelected) {
                intSceneBridgeCount = o_LiveShowVIP.getSelectedSceneBridges_Only().size();
                intObjectsCount = o_LiveShowVIP.getSelectedObjects_Only().size();
                o_LiveShowObjectInterfaces = o_LiveShowVIP.getSelectedObjectInterfaces();
                intJingleCount = p_LiveShow_ExportDescription.getIncludeJingles() ? p_LiveShow_ExportDescription.getLiveShowJingleObjectCount(o_LiveShowVIP) : 0;
            } else {
                intSceneBridgeCount = o_LiveShowVIP.getLiveShowSceneBridgeCount();
                intObjectsCount = o_LiveShowVIP.getLiveShowObjectInterfaceCount() - intSceneBridgeCount;
                o_LiveShowObjectInterfaces = o_LiveShowVIP.getLiveShowObjectInterfaces();
                intJingleCount = p_LiveShow_ExportDescription.getLiveShowJingleObjectCount(o_LiveShowVIP);
            }
            for (int intObject = 0; intObject < o_LiveShowObjectInterfaces.size(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowObjectInterfaces.get(intObject);
                if (longFrameStart > o_LiveShowObjectInterface.getFrameStart()) {
                    longFrameStart = o_LiveShowObjectInterface.getFrameStart();
                }
                if (longFrameEnd >= o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameLength()) continue;
                longFrameEnd = o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameLength();
            }
            doubleFrameTime = o_LiveShowVIP.getFrameTime();
            o_StringBuilder.append(LABEL_SCENEBRIDGES);
            o_StringBuilder.append("</td>");
            o_StringBuilder.append("<td>");
            if (intSceneBridgeCount <= 0) {
                o_StringBuilder.append("-");
            } else {
                o_StringBuilder.append(intSceneBridgeCount);
            }
            o_StringBuilder.append("</td>");
            o_StringBuilder.append("</tr>");
            o_StringBuilder.append("<tr>");
            o_StringBuilder.append("<td>");
            o_StringBuilder.append("</td>");
            o_StringBuilder.append("<td>");
            o_StringBuilder.append(LABEL_OBJECTS);
            o_StringBuilder.append("</td>");
            o_StringBuilder.append("<td>");
            if (intObjectsCount <= 0) {
                o_StringBuilder.append("-");
            } else {
                o_StringBuilder.append(intObjectsCount);
            }
            o_StringBuilder.append("</td>");
            o_StringBuilder.append("</tr>");
            o_StringBuilder.append("<tr>");
            o_StringBuilder.append("<td>");
            o_StringBuilder.append("</td>");
            o_StringBuilder.append("<td>");
            o_StringBuilder.append(LABEL_JINGLES);
            o_StringBuilder.append("</td>");
            o_StringBuilder.append("<td>");
            if (intJingleCount <= 0) {
                o_StringBuilder.append("-");
            } else {
                o_StringBuilder.append(p_LiveShow_ExportDescription.getLiveShowJingleObjectCount(o_LiveShowVIP));
            }
            o_StringBuilder.append("</td>");
            o_StringBuilder.append("</tr>");
        }
        o_StringBuilder.append("<tr>");
        o_StringBuilder.append("<td>");
        o_StringBuilder.append(LABEL_LENGTH);
        o_StringBuilder.append("</td>");
        o_StringBuilder.append("<td>");
        if (longFrameStart == Long.MAX_VALUE) {
            longFrameStart = 0L;
        }
        o_StringBuilder.append(LiveShowProjectDescription.getTimeStringFromMillis((long)((double)(longFrameEnd - longFrameStart) * doubleFrameTime)));
        o_StringBuilder.append("</td>");
        o_StringBuilder.append("<tr>");
        o_StringBuilder.append("</table>");
        o_StringBuilder.append("</html>");
        return o_StringBuilder.toString();
    }

    public String getProjectStatistic() {
        return this.m_ProjectStatistic;
    }

    public void setProjectStatistic(String p_ProjectStatistic) {
        this.m_ProjectStatistic = p_ProjectStatistic == null ? "" : p_ProjectStatistic;
    }

    private static String getTimeStringFromMillis(long p_Milliseconds) {
        String stringTemp;
        String stringTime = "";
        boolean boolSetString = false;
        int intHours = (int)(p_Milliseconds / 3600000L);
        p_Milliseconds -= (long)(intHours * 3600000);
        if (boolSetString || intHours > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intHours);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
            boolSetString = true;
        }
        int intMinutes = (int)(p_Milliseconds / 60000L);
        p_Milliseconds -= (long)(intMinutes * 60000);
        if (boolSetString || intMinutes > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intMinutes);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
        }
        int intSeconds = (int)(p_Milliseconds / 1000L);
        p_Milliseconds -= (long)(intSeconds * 1000);
        if (boolSetString || intSeconds > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intSeconds);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
        }
        int intMilliseconds = (int)p_Milliseconds;
        stringTemp = "000";
        stringTemp = stringTemp + String.valueOf(intMilliseconds);
        stringTime = stringTime + stringTemp.substring(stringTemp.length() - 3, stringTemp.length());
        return stringTime;
    }

    public void setAudioFormat(AudioFormat p_AudioFormat) {
        if (p_AudioFormat == null) {
            return;
        }
        if (p_AudioFormat.equals(this.m_AudioFormat)) {
            return;
        }
        AudioFormat oldAudioFormat = this.m_AudioFormat;
        this.m_AudioFormat = p_AudioFormat;
        this.firePropertyChange(PROP_PROJECTAUDIOFORMAT, oldAudioFormat, this.m_AudioFormat);
        if (this.m_AudioFormat == null || this.m_AudioFormat.getFrameRate() <= 0.0f) {
            return;
        }
        LiveShowVIP.setFrameTime(1000.0 / (double)this.m_AudioFormat.getFrameRate());
        SPIT_TypeModel.FRAMESPERSECOND = this.m_AudioFormat.getFrameRate();
        SPIT_ObjectModel.FRAMESPERSECOND = this.m_AudioFormat.getFrameRate();
    }

    public AudioFormat getAudioFormat() {
        return this.m_AudioFormat;
    }

    public static void writeExternalAudioFormat(ObjectOutput out, AudioFormat p_AudioFormat) throws IOException {
        if (p_AudioFormat == null) {
            p_AudioFormat = SoundMixers.DEFAULT_AUDIOFORMAT;
        }
        out.writeUTF(p_AudioFormat.getEncoding().toString());
        out.writeFloat(p_AudioFormat.getSampleRate());
        out.writeInt(p_AudioFormat.getSampleSizeInBits());
        out.writeInt(p_AudioFormat.getChannels());
        out.writeInt(p_AudioFormat.getFrameSize());
        out.writeFloat(p_AudioFormat.getFrameRate());
        out.writeBoolean(p_AudioFormat.isBigEndian());
    }

    public static AudioFormat readExternalAudioFormat(ObjectInput in) throws IOException {
        AudioFormat o_AudioFormat = null;
        String strngEncoding = in.readUTF();
        AudioFormat.Encoding o_Encoding = new AudioFormat.Encoding(strngEncoding);
        float floatSampleRate = in.readFloat();
        int intSampleSizeInBits = in.readInt();
        int intChannels = in.readInt();
        int intFrameSize = in.readInt();
        float floatFrameRate = in.readFloat();
        boolean boolBigEndian = in.readBoolean();
        o_AudioFormat = new AudioFormat(o_Encoding, floatSampleRate, intSampleSizeInBits, intChannels, intFrameSize, floatFrameRate, boolBigEndian);
        return o_AudioFormat;
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.m_PropertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
        return this.m_PropertyChangeSupport.getPropertyChangeListeners(p_PropertyName);
    }

    public boolean hasListeners(String p_PropertyName) {
        return this.m_PropertyChangeSupport.hasListeners(p_PropertyName);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.m_PropertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

