/*
 * Decompiled with CFR 0.152.
 */
package LiveShowObjectPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowObjectPackage.LiveShowObjectGroup;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowVirtualPackage.LiveShowVIP;
import SwingComponents.FrameParent;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class LiveShowObjectGroupPanel
extends JPanel
implements ListSelectionListener {
    public static LiveShowObjectGroupPanel s_SelfReference;
    private static ArrayList<LiveShowObjectGroup> s_SelectedDMXDeviceGroups;
    private static final Object s_SyncSelection;
    private JButton jButton_CreateGroupsAutomatic;
    private JButton jButton_GroupToSelection;
    private JButton jButton_NewGroup;
    private JButton jButton_RemoveEmptyGroups;
    private JButton jButton_RemoveGroup;
    private JButton jButton_SelectionToGroup;
    private JLabel jLabel_Filter;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JPanel jPanel_DMXScenes;
    private JPanel jPanel_Search;
    private JScrollPane jScrollPane_DMXScenes;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JTable jTable_Groups;
    private JTextField jTextField_Filter;
    private JToolBar jToolBar1;
    private JToolBar jToolBar_ShowScene;
    public static FrameParent s_FrameParent;

    public LiveShowObjectGroupPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener(this, null);
        this.refreshUI();
    }

    private void initMembers() {
        s_SelfReference = this;
    }

    private void initComponentsFurther() {
        this.jScrollPane_DMXScenes.getViewport().setBackground(Color.BLACK);
        this.jTable_Groups.setModel((TableModel)((Object)LiveShowObjectGroup.getGroupTableModel()));
        LiveShowObjectGroup.getGroupTableModel().finishJTable(this.jTable_Groups);
        this.jTable_Groups.getSelectionModel().addListSelectionListener(this);
        this.jTable_Groups.setRowHeight(24);
        this.jTable_Groups.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_SelectionToGroup.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_NewGroup.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_RemoveGroup.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_RemoveEmptyGroups.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_GroupToSelection.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_CreateGroupsAutomatic.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    public JLabel_ResizeFrame getLabel_ResizeFrame() {
        return this.jLabel_ResizeFrame1;
    }

    private void initComponents() {
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jPanel_DMXScenes = new JPanel();
        this.jScrollPane_DMXScenes = new JScrollPane();
        this.jTable_Groups = new JTable();
        this.jToolBar1 = new JToolBar();
        this.jButton_NewGroup = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton_SelectionToGroup = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton_RemoveGroup = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButton_RemoveEmptyGroups = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.jButton_CreateGroupsAutomatic = new JButton();
        this.jToolBar_ShowScene = new JToolBar();
        this.jSeparator5 = new JToolBar.Separator();
        this.jButton_GroupToSelection = new JButton();
        this.jPanel_Search = new JPanel();
        this.jLabel_Filter = new JLabel();
        this.jTextField_Filter = new JTextField();
        this.setPreferredSize(new Dimension(450, 500));
        this.setLayout(new GridBagLayout());
        this.jLabel_ResizeFrame1.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jPanel_DMXScenes.setMinimumSize(new Dimension(200, 200));
        this.jPanel_DMXScenes.setPreferredSize(new Dimension(300, 300));
        this.jPanel_DMXScenes.setRequestFocusEnabled(false);
        this.jPanel_DMXScenes.setLayout(new GridBagLayout());
        this.jTable_Groups.setFont(new Font("Tahoma", 0, 14));
        this.jTable_Groups.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable_Groups.setAutoResizeMode(4);
        this.jTable_Groups.setRowHeight(20);
        this.jTable_Groups.setSelectionMode(2);
        this.jScrollPane_DMXScenes.setViewportView(this.jTable_Groups);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_DMXScenes.add((Component)this.jScrollPane_DMXScenes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_DMXScenes, gridBagConstraints);
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMinimumSize(new Dimension(100, 36));
        this.jToolBar1.setPreferredSize(new Dimension(100, 36));
        this.jButton_NewGroup.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_NewGroup.setToolTipText("Add new group");
        this.jButton_NewGroup.setContentAreaFilled(false);
        this.jButton_NewGroup.setFocusable(false);
        this.jButton_NewGroup.setHorizontalTextPosition(0);
        this.jButton_NewGroup.setIconTextGap(0);
        this.jButton_NewGroup.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_NewGroup.setMaximumSize(new Dimension(36, 36));
        this.jButton_NewGroup.setMinimumSize(new Dimension(36, 36));
        this.jButton_NewGroup.setPreferredSize(new Dimension(36, 36));
        this.jButton_NewGroup.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_NewGroup.setVerticalTextPosition(3);
        this.jButton_NewGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowObjectGroupPanel.this.jButton_NewGroupActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_NewGroup);
        this.jSeparator1.setMaximumSize(new Dimension(20, Short.MAX_VALUE));
        this.jSeparator1.setPreferredSize(new Dimension(20, 10));
        this.jToolBar1.add(this.jSeparator1);
        this.jButton_SelectionToGroup.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Timeline_SelectionToObjectGroup.png")));
        this.jButton_SelectionToGroup.setToolTipText("Overwrite group with the lamp selection of DMXStageview");
        this.jButton_SelectionToGroup.setContentAreaFilled(false);
        this.jButton_SelectionToGroup.setFocusable(false);
        this.jButton_SelectionToGroup.setHorizontalTextPosition(0);
        this.jButton_SelectionToGroup.setIconTextGap(0);
        this.jButton_SelectionToGroup.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_SelectionToGroup.setMaximumSize(new Dimension(64, 32));
        this.jButton_SelectionToGroup.setMinimumSize(new Dimension(64, 32));
        this.jButton_SelectionToGroup.setPreferredSize(new Dimension(64, 32));
        this.jButton_SelectionToGroup.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_SelectionToGroup.setVerticalTextPosition(3);
        this.jButton_SelectionToGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowObjectGroupPanel.this.jButton_SelectionToGroupActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SelectionToGroup);
        this.jSeparator2.setMaximumSize(new Dimension(40, Short.MAX_VALUE));
        this.jSeparator2.setPreferredSize(new Dimension(40, 10));
        this.jToolBar1.add(this.jSeparator2);
        this.jButton_RemoveGroup.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_RemoveGroup.setToolTipText("Remove selected group");
        this.jButton_RemoveGroup.setContentAreaFilled(false);
        this.jButton_RemoveGroup.setFocusable(false);
        this.jButton_RemoveGroup.setHorizontalTextPosition(0);
        this.jButton_RemoveGroup.setIconTextGap(0);
        this.jButton_RemoveGroup.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_RemoveGroup.setMaximumSize(new Dimension(32, 32));
        this.jButton_RemoveGroup.setMinimumSize(new Dimension(32, 32));
        this.jButton_RemoveGroup.setPreferredSize(new Dimension(32, 32));
        this.jButton_RemoveGroup.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_RemoveGroup.setVerticalTextPosition(3);
        this.jButton_RemoveGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowObjectGroupPanel.this.jButton_RemoveGroupActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RemoveGroup);
        this.jToolBar1.add(this.jSeparator3);
        this.jButton_RemoveEmptyGroups.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Sweep.png")));
        this.jButton_RemoveEmptyGroups.setToolTipText("Delete all empty groups");
        this.jButton_RemoveEmptyGroups.setContentAreaFilled(false);
        this.jButton_RemoveEmptyGroups.setFocusable(false);
        this.jButton_RemoveEmptyGroups.setHorizontalTextPosition(0);
        this.jButton_RemoveEmptyGroups.setIconTextGap(0);
        this.jButton_RemoveEmptyGroups.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_RemoveEmptyGroups.setMaximumSize(new Dimension(64, 32));
        this.jButton_RemoveEmptyGroups.setMinimumSize(new Dimension(64, 32));
        this.jButton_RemoveEmptyGroups.setPreferredSize(new Dimension(64, 32));
        this.jButton_RemoveEmptyGroups.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_RemoveEmptyGroups.setVerticalTextPosition(3);
        this.jButton_RemoveEmptyGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowObjectGroupPanel.this.jButton_RemoveEmptyGroupsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RemoveEmptyGroups);
        this.jToolBar1.add(this.jSeparator6);
        this.jButton_CreateGroupsAutomatic.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Timeline_ObjectGroupAutomatic.png")));
        this.jButton_CreateGroupsAutomatic.setToolTipText("automatically create groups");
        this.jButton_CreateGroupsAutomatic.setContentAreaFilled(false);
        this.jButton_CreateGroupsAutomatic.setFocusable(false);
        this.jButton_CreateGroupsAutomatic.setHorizontalTextPosition(0);
        this.jButton_CreateGroupsAutomatic.setIconTextGap(0);
        this.jButton_CreateGroupsAutomatic.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_CreateGroupsAutomatic.setMaximumSize(new Dimension(64, 32));
        this.jButton_CreateGroupsAutomatic.setMinimumSize(new Dimension(64, 32));
        this.jButton_CreateGroupsAutomatic.setPreferredSize(new Dimension(64, 32));
        this.jButton_CreateGroupsAutomatic.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_CreateGroupsAutomatic.setVerticalTextPosition(3);
        this.jButton_CreateGroupsAutomatic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowObjectGroupPanel.this.jButton_CreateGroupsAutomaticActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_CreateGroupsAutomatic);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.jToolBar_ShowScene.setBorder(null);
        this.jToolBar_ShowScene.setFloatable(false);
        this.jToolBar_ShowScene.setRollover(true);
        this.jToolBar_ShowScene.setMaximumSize(new Dimension(80, 36));
        this.jToolBar_ShowScene.setMinimumSize(new Dimension(80, 36));
        this.jToolBar_ShowScene.setPreferredSize(new Dimension(80, 36));
        this.jSeparator5.setMinimumSize(new Dimension(6, 0));
        this.jToolBar_ShowScene.add(this.jSeparator5);
        this.jButton_GroupToSelection.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Timeline_ObjectGroupToSelection.png")));
        this.jButton_GroupToSelection.setToolTipText("DMXStageview select lamps of group");
        this.jButton_GroupToSelection.setContentAreaFilled(false);
        this.jButton_GroupToSelection.setFocusable(false);
        this.jButton_GroupToSelection.setHorizontalTextPosition(0);
        this.jButton_GroupToSelection.setIconTextGap(0);
        this.jButton_GroupToSelection.setMargin(null);
        this.jButton_GroupToSelection.setMaximumSize(new Dimension(64, 32));
        this.jButton_GroupToSelection.setMinimumSize(new Dimension(64, 32));
        this.jButton_GroupToSelection.setPreferredSize(new Dimension(66, 36));
        this.jButton_GroupToSelection.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_GroupToSelection.setVerticalTextPosition(3);
        this.jButton_GroupToSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowObjectGroupPanel.this.jButton_GroupToSelectionActionPerformed(evt);
            }
        });
        this.jToolBar_ShowScene.add(this.jButton_GroupToSelection);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jToolBar_ShowScene, gridBagConstraints);
        this.jPanel_Search.setLayout(new GridBagLayout());
        this.jLabel_Filter.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Search.png")));
        this.jLabel_Filter.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Search.add((Component)this.jLabel_Filter, gridBagConstraints);
        this.jTextField_Filter.setHorizontalAlignment(0);
        this.jTextField_Filter.setToolTipText("");
        this.jTextField_Filter.setMinimumSize(new Dimension(100, 20));
        this.jTextField_Filter.setPreferredSize(new Dimension(60, 24));
        this.jTextField_Filter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LiveShowObjectGroupPanel.this.jTextField_FilterKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Search.add((Component)this.jTextField_Filter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_Search, gridBagConstraints);
    }

    public void newGroup() {
        final LiveShowObjectGroup o_Group = new LiveShowObjectGroup();
        this.clearSelectedGroups();
        LiveShowObjectGroup.addGroup(o_Group);
        o_Group.resetObjects();
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                int intRow = LiveShowObjectGroup.indexOf(o_Group);
                intRow = LiveShowObjectGroupPanel.this.jTable_Groups.convertRowIndexToView(intRow);
                LiveShowObjectGroupPanel.this.jTable_Groups.getSelectionModel().setSelectionInterval(intRow, intRow);
                LiveShowObjectGroupPanel.this.scrollToViewIndex(intRow);
                LiveShowObjectGroupPanel.this.refreshUI();
            }
        });
    }

    public void deleteSelectedGroups() {
        int[] intSelectedRows = this.jTable_Groups.getSelectedRows();
        this.clearSelectedGroups();
        for (int intSelectedRow = intSelectedRows.length - 1; intSelectedRow >= 0; --intSelectedRow) {
            LiveShowObjectGroup o_Group;
            try {
                int intRowModel = this.jTable_Groups.convertRowIndexToModel(intSelectedRows[intSelectedRow]);
                o_Group = LiveShowObjectGroup.getGroupTableModel().getGroup(intRowModel);
            }
            catch (Exception e) {
                continue;
            }
            LiveShowObjectGroup.removeGroup(o_Group, false);
        }
    }

    public LiveShowObjectGroup getGroup(int p_Index) {
        if (p_Index < 0 || p_Index >= LiveShowObjectGroup.getGroupCount()) {
            return null;
        }
        return LiveShowObjectGroup.getGroup(p_Index);
    }

    public int getGroupCount() {
        return LiveShowObjectGroup.getGroupCount();
    }

    public void clearSelectedGroups() {
        this.jTable_Groups.getSelectionModel().clearSelection();
        this.refreshUI();
    }

    public void scrollToViewIndex(int p_FirstViewIndex) {
        if (p_FirstViewIndex < 0) {
            return;
        }
        if (p_FirstViewIndex >= 0) {
            JViewport o_JViewport = (JViewport)this.jTable_Groups.getParent();
            Rectangle o_CellRect = this.jTable_Groups.getCellRect(p_FirstViewIndex, 0, true);
            Rectangle o_ViewportRect = o_JViewport.getViewRect();
            if (o_CellRect.y + o_CellRect.height / 2 < o_ViewportRect.y || o_CellRect.y + o_CellRect.height / 2 > o_ViewportRect.y + o_ViewportRect.height) {
                o_CellRect.setLocation(o_CellRect.x - o_ViewportRect.x, o_CellRect.y - o_ViewportRect.y);
                int intCenterY = (o_ViewportRect.height - o_CellRect.height) / 2;
                if (o_CellRect.y < intCenterY) {
                    intCenterY = -intCenterY;
                }
                o_CellRect.translate(o_CellRect.x, intCenterY);
                o_JViewport.scrollRectToVisible(o_CellRect);
            }
        }
    }

    private void refreshUI() {
        if (s_SelectedDMXDeviceGroups.size() <= 0) {
            this.jButton_SelectionToGroup.setEnabled(false);
            this.jButton_RemoveGroup.setEnabled(false);
            this.jButton_GroupToSelection.setEnabled(false);
        } else {
            if (s_SelectedDMXDeviceGroups.size() == 1) {
                this.jButton_SelectionToGroup.setEnabled(true);
            } else {
                this.jButton_SelectionToGroup.setEnabled(false);
            }
            this.jButton_RemoveGroup.setEnabled(true);
            this.jButton_GroupToSelection.setEnabled(true);
        }
    }

    private void jButton_NewGroupActionPerformed(ActionEvent evt) {
        this.newGroup();
    }

    private void jButton_SelectionToGroupActionPerformed(ActionEvent evt) {
        if (this.jTable_Groups.getSelectedRowCount() != 1) {
            return;
        }
        int intIndex = this.jTable_Groups.getSelectedRow();
        if (intIndex < 0) {
            return;
        }
        LiveShowObjectGroup o_Group = LiveShowObjectGroup.getGroup(intIndex = this.jTable_Groups.convertRowIndexToModel(intIndex));
        if (o_Group == null) {
            return;
        }
        o_Group.resetObjects();
    }

    private void jButton_RemoveGroupActionPerformed(ActionEvent evt) {
        this.deleteSelectedGroups();
    }

    private void jButton_GroupToSelectionActionPerformed(ActionEvent evt) {
        LiveShowVIP o_LiveShowVIP = null;
        int[] intSelectedRows = this.jTable_Groups.getSelectedRows();
        if (intSelectedRows.length <= 0) {
            return;
        }
        int intVIPCount = LiveShowVIP.getLiveShowVIPCount();
        if (intVIPCount == 0) {
            return;
        }
        for (int intVIP = 0; intVIP < intVIPCount; ++intVIP) {
            o_LiveShowVIP = LiveShowVIP.getLiveShowVIP(intVIP);
            if (o_LiveShowVIP == null) continue;
            o_LiveShowVIP.clearSelectedObjects(true);
        }
        if (o_LiveShowVIP == null) {
            return;
        }
        for (int intSelectedRow = intSelectedRows.length - 1; intSelectedRow >= 0; --intSelectedRow) {
            LiveShowObjectGroup o_Group;
            try {
                int intRowModel = this.jTable_Groups.convertRowIndexToModel(intSelectedRows[intSelectedRow]);
                o_Group = LiveShowObjectGroup.getGroupTableModel().getGroup(intRowModel);
            }
            catch (Exception e) {
                continue;
            }
            if (o_Group == null) continue;
            int intObjectCount = o_Group.getObjectCount();
            for (int intObject = 0; intObject < o_Group.getObjectCount(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = o_Group.getObject(intObject);
                if (o_LiveShowObjectInterface == null) {
                    return;
                }
                o_LiveShowVIP = o_LiveShowObjectInterface.getLiveShowVIP();
                if (o_LiveShowVIP != null) {
                    o_LiveShowVIP.addSelectedObject(o_LiveShowObjectInterface);
                    continue;
                }
                o_LiveShowObjectInterface.setSelected(true, false);
            }
        }
        o_LiveShowVIP.toFront();
    }

    private void jButton_RemoveEmptyGroupsActionPerformed(ActionEvent evt) {
        int intGroupCount = LiveShowObjectGroup.getGroupCount();
        if (intGroupCount == 0) {
            return;
        }
        LiveShowObjectGroup.clearEmptyGroups();
    }

    private void jButton_CreateGroupsAutomaticActionPerformed(ActionEvent evt) {
        LiveShowObjectGroup.createGroupsAutomatically();
    }

    private void jTextField_FilterKeyReleased(KeyEvent evt) {
        this.clearSelectedGroups();
        LiveShowObjectGroup.getGroupTableModel().filter(this.jTextField_Filter.getText());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        LiveShowObjectGroupPanel.refreshSelectedGroups();
        this.refreshUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshSelectedGroups() {
        Object object = s_SyncSelection;
        synchronized (object) {
            s_SelectedDMXDeviceGroups.clear();
            int[] intSelectedRows = LiveShowObjectGroupPanel.s_SelfReference.jTable_Groups.getSelectedRows();
            if (intSelectedRows.length <= 0) {
                return;
            }
            for (int intSelectedRow = intSelectedRows.length - 1; intSelectedRow >= 0; --intSelectedRow) {
                LiveShowObjectGroup o_Group;
                try {
                    int intRowModel = LiveShowObjectGroupPanel.s_SelfReference.jTable_Groups.convertRowIndexToModel(intSelectedRows[intSelectedRow]);
                    o_Group = LiveShowObjectGroup.getGroupTableModel().getGroup(intRowModel);
                }
                catch (Exception e) {
                    continue;
                }
                if (o_Group == null) continue;
                s_SelectedDMXDeviceGroups.add(o_Group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSelectedGroupCount() {
        Object object = s_SyncSelection;
        synchronized (object) {
            return s_SelectedDMXDeviceGroups.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShowObjectGroup getSelectedGroup(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = s_SyncSelection;
        synchronized (object) {
            if (p_Index >= s_SelectedDMXDeviceGroups.size()) {
                return null;
            }
            return s_SelectedDMXDeviceGroups.get(p_Index);
        }
    }

    public static void showFrame() {
        if (s_FrameParent != null) {
            s_FrameParent.showFrame();
        }
    }

    public static void setFrameParent(FrameParent p_FrameParent) {
        s_FrameParent = p_FrameParent;
    }

    static {
        s_SelectedDMXDeviceGroups = new ArrayList();
        s_SyncSelection = new Object();
    }
}

