/*
 * Decompiled with CFR 0.152.
 */
package GraphicsDeviceToolsPackage;

import GraphicsDeviceToolsPackage.GraphicsDeviceTools;
import OS.OSChecker;
import SwingComponents.MouseAdapter_Delayed;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.JPanelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class JPanel_GraphicsDevices
extends JPanel {
    private ArrayList<JPanel_Display> m_JPanel_Displays;
    private JPanelImage m_JPanelImage;
    private Rectangle m_VirtualBounds;
    private Rectangle m_VirtualBoundsSelection;
    private ArrayList<SelectionListener> m_SelectionListeners;
    private ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> m_SelectedGraphicsDeviceDescriptions;
    private static int AUTOMATICFEVICEREFRESH_TIME = 20000;
    private Thread m_ThreadAutomaticDeviceRefresh;
    private Runnable m_RunnableAutomaticDeviceRefresh;
    private boolean m_StopAutomaticDeviceRefresh;
    private final Object m_SyncAutomaticRefresh = new Object();
    private final Object m_SyncDisplays = new Object();
    private final Object m_SyncSelection = new Object();
    private final Object m_SyncListeners = new Object();
    private Runnable m_RunnableSelectionNotify = new Runnable(){
        ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> m_SelectedDevices;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList o_SelectionListeners;
            this.m_SelectedDevices = JPanel_GraphicsDevices.this.getSelectedGraphicsDeviceDescriptions(this.m_SelectedDevices);
            Object object = JPanel_GraphicsDevices.this.m_SyncListeners;
            synchronized (object) {
                o_SelectionListeners = new ArrayList(JPanel_GraphicsDevices.this.m_SelectionListeners.size());
                o_SelectionListeners.addAll(JPanel_GraphicsDevices.this.m_SelectionListeners);
            }
            for (int intListener = 0; intListener < o_SelectionListeners.size(); ++intListener) {
                SelectionListener o_SelectionListener = (SelectionListener)o_SelectionListeners.get(intListener);
                o_SelectionListener.selectionChanged(this.m_SelectedDevices);
            }
        }
    };
    private JButton jButton_Refresh;

    public JPanel_GraphicsDevices() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
    }

    private void initMembers() {
        this.m_JPanel_Displays = new ArrayList();
        this.m_VirtualBounds = new Rectangle(0, 0, 0, 0);
        this.m_VirtualBoundsSelection = new Rectangle(0, 0, 0, 0);
        this.m_SelectionListeners = new ArrayList();
        this.m_SelectedGraphicsDeviceDescriptions = new ArrayList();
        this.m_RunnableAutomaticDeviceRefresh = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!JPanel_GraphicsDevices.this.m_StopAutomaticDeviceRefresh) {
                    JPanel_GraphicsDevices.this.refreshGraphicsDevices();
                    Object object = JPanel_GraphicsDevices.this.m_SyncAutomaticRefresh;
                    synchronized (object) {
                        try {
                            long longWaitStart;
                            for (long longWaitTime = (long)AUTOMATICFEVICEREFRESH_TIME; longWaitTime > 0L && !JPanel_GraphicsDevices.this.m_StopAutomaticDeviceRefresh; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                                longWaitStart = System.nanoTime() / 1000000L;
                                JPanel_GraphicsDevices.this.m_SyncAutomaticRefresh.wait(longWaitTime);
                            }
                        }
                        catch (Exception e) {
                            JPanel_GraphicsDevices.this.m_StopAutomaticDeviceRefresh = true;
                            return;
                        }
                    }
                }
            }
        };
    }

    private void initComponents() {
        this.jButton_Refresh = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                JPanel_GraphicsDevices.this.formComponentResized(evt);
            }
        });
        this.setLayout(new AbsoluteLayout());
        this.jButton_Refresh.setIcon(new ImageIcon(this.getClass().getResource("/GraphicsDeviceToolsPackage/Icon_Refresh.png")));
        this.jButton_Refresh.setToolTipText("Refresh Displays");
        this.jButton_Refresh.setContentAreaFilled(false);
        this.jButton_Refresh.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Refresh.setMaximumSize(new Dimension(34, 34));
        this.jButton_Refresh.setMinimumSize(new Dimension(34, 34));
        this.jButton_Refresh.setPreferredSize(new Dimension(34, 34));
        this.jButton_Refresh.setPressedIcon(new ImageIcon(this.getClass().getResource("/GraphicsDeviceToolsPackage/Icon_Pressed.png")));
        this.jButton_Refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_GraphicsDevices.this.jButton_RefreshActionPerformed(evt);
            }
        });
        this.add((Component)this.jButton_Refresh, new AbsoluteConstraints(0, 0, -1, -1));
    }

    private void formComponentResized(ComponentEvent evt) {
        this.arrangeDisplays();
    }

    private void jButton_RefreshActionPerformed(ActionEvent evt) {
        this.refreshGraphicsDevices();
    }

    private void initComponentsFurther() {
        this.m_JPanelImage = new JPanelImage();
        this.add((Component)this.m_JPanelImage, this.m_JPanelImage.m_AbsoluteConstraints);
        this.refreshGraphicsDevices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setToolTipText(String p_ToolTipText) {
        super.setToolTipText(p_ToolTipText);
        Object object = this.m_SyncDisplays;
        synchronized (object) {
            for (int intDisplay = 0; intDisplay < this.m_JPanel_Displays.size(); ++intDisplay) {
                JPanel_Display o_JPanel_Display = this.m_JPanel_Displays.get(intDisplay);
                if (o_JPanel_Display == null) continue;
                o_JPanel_Display.setToolTipText(p_ToolTipText);
            }
        }
    }

    public void startAutomaticDeviceRefresh() {
        if (this.m_ThreadAutomaticDeviceRefresh == null || !this.m_ThreadAutomaticDeviceRefresh.isAlive()) {
            this.m_ThreadAutomaticDeviceRefresh = new Thread(this.m_RunnableAutomaticDeviceRefresh, this.getClass().getSimpleName() + "_AutomaticDeviceRefresh");
            this.m_StopAutomaticDeviceRefresh = false;
            this.m_ThreadAutomaticDeviceRefresh.start();
            this.jButton_Refresh.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAutomaticDeviceRefresh() {
        this.m_StopAutomaticDeviceRefresh = true;
        if (this.m_ThreadAutomaticDeviceRefresh != null) {
            Object object = this.m_SyncAutomaticRefresh;
            synchronized (object) {
                try {
                    if (this.m_ThreadAutomaticDeviceRefresh.isAlive()) {
                        this.m_SyncAutomaticRefresh.notifyAll();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (this.m_ThreadAutomaticDeviceRefresh.isAlive()) {
                    this.m_ThreadAutomaticDeviceRefresh.join(AUTOMATICFEVICEREFRESH_TIME);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jButton_Refresh.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshGraphicsDevices() {
        ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> o_SelectedGraphicsDeviceDescriptions;
        Point o_PointUpperLeft = new Point(0, 0);
        Point o_PointUnderRight = new Point(0, 0);
        Rectangle o_Bounds = new Rectangle(0, 0);
        Object object = this.m_SyncDisplays;
        synchronized (object) {
            JPanel_Display o_JPanel_Display;
            GraphicsDeviceTools.GraphicsDeviceDescription o_NewGraphicsDeviceDescription;
            int intDescription;
            ArrayList<JPanel_Display> o_NotFoundJPanel_Displays = new ArrayList<JPanel_Display>(this.m_JPanel_Displays.size());
            o_NotFoundJPanel_Displays.addAll(this.m_JPanel_Displays);
            GraphicsDeviceTools.refreshGraphicsDevices();
            ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> o_GraphicsDeviceDescriptions = GraphicsDeviceTools.getGraphicsDeviceDescriptions();
            o_SelectedGraphicsDeviceDescriptions = new ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription>();
            o_SelectedGraphicsDeviceDescriptions.addAll(this.m_SelectedGraphicsDeviceDescriptions);
            block3: for (intDescription = o_GraphicsDeviceDescriptions.size() - 1; intDescription >= 0; --intDescription) {
                o_NewGraphicsDeviceDescription = o_GraphicsDeviceDescriptions.get(intDescription);
                o_Bounds = o_NewGraphicsDeviceDescription.getBounds();
                if (o_Bounds.x < o_PointUpperLeft.x) {
                    o_PointUpperLeft.x = o_Bounds.x;
                }
                if (o_Bounds.y < o_PointUpperLeft.y) {
                    o_PointUpperLeft.y = o_Bounds.y;
                }
                if (o_Bounds.x + o_Bounds.width > o_PointUnderRight.x) {
                    o_PointUnderRight.x = o_Bounds.x + o_Bounds.width;
                }
                if (o_Bounds.y + o_Bounds.height > o_PointUnderRight.y) {
                    o_PointUnderRight.y = o_Bounds.y + o_Bounds.height;
                }
                for (int intDisplay = 0; intDisplay < this.m_JPanel_Displays.size(); ++intDisplay) {
                    o_JPanel_Display = this.m_JPanel_Displays.get(intDisplay);
                    GraphicsDeviceTools.GraphicsDeviceDescription o_GraphicsDeviceDescription = o_JPanel_Display.getGraphicsDeviceDescription();
                    if (!o_NewGraphicsDeviceDescription.getIDString().equals(o_GraphicsDeviceDescription.getIDString())) continue;
                    o_GraphicsDeviceDescriptions.remove(o_NewGraphicsDeviceDescription);
                    o_NotFoundJPanel_Displays.remove(o_JPanel_Display);
                    o_JPanel_Display.setGraphicsDeviceDescription(o_NewGraphicsDeviceDescription);
                    continue block3;
                }
            }
            for (int intDisplay = o_NotFoundJPanel_Displays.size() - 1; intDisplay >= 0; --intDisplay) {
                o_JPanel_Display = (JPanel_Display)o_NotFoundJPanel_Displays.get(intDisplay);
                o_JPanel_Display.setVisible(false);
                this.m_JPanel_Displays.remove(o_JPanel_Display);
                o_JPanel_Display.close();
                this.remove(o_JPanel_Display);
            }
            for (intDescription = o_GraphicsDeviceDescriptions.size() - 1; intDescription >= 0; --intDescription) {
                o_NewGraphicsDeviceDescription = o_GraphicsDeviceDescriptions.get(intDescription);
                o_JPanel_Display = new JPanel_Display(this, o_NewGraphicsDeviceDescription);
                this.m_JPanel_Displays.add(o_JPanel_Display);
                o_JPanel_Display.setToolTipText(this.getToolTipText());
                this.add((Component)o_JPanel_Display, o_JPanel_Display.getAbsoluteConstraints());
                this.setComponentZOrder(o_JPanel_Display, 0);
                this.setComponentZOrder(this.jButton_Refresh, 0);
            }
        }
        this.m_VirtualBounds.setBounds(o_PointUpperLeft.x, o_PointUpperLeft.y, o_PointUnderRight.x - o_PointUpperLeft.x, o_PointUnderRight.y - o_PointUpperLeft.y);
        if (this.m_VirtualBounds.height == 0) {
            this.m_VirtualBounds.height = 1;
        }
        if (this.m_VirtualBounds.width == 0) {
            this.m_VirtualBounds.width = 1;
        }
        this.arrangeDisplays();
        this.setSelectedGraphicsDeviceDescriptions(o_SelectedGraphicsDeviceDescriptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void arrangeDisplays() {
        AbsoluteConstraints o_AbsoluteConstraints;
        this.calculateVirtualBoundsSelection();
        Rectangle o_BoundsMain = new Rectangle(0, 0, 0, 0);
        double doubleHeightFactor = (double)this.getHeight() / this.m_VirtualBounds.getHeight();
        double doubleWidthFactor = (double)this.getWidth() / this.m_VirtualBounds.getWidth();
        double doubleFactor = doubleHeightFactor < doubleWidthFactor ? doubleHeightFactor : doubleWidthFactor;
        int intHeight = (int)(this.m_VirtualBounds.getHeight() * doubleFactor);
        int intWidth = (int)(this.m_VirtualBounds.getWidth() * doubleFactor);
        int intRectX = 0 + (this.getWidth() - intWidth) / 2;
        int intRectY = 0 + (this.getHeight() - intHeight) / 2;
        Object object = this.m_SyncDisplays;
        synchronized (object) {
            for (int intDisplay = 0; intDisplay < this.m_JPanel_Displays.size(); ++intDisplay) {
                JPanel_Display o_JPanel_Display = this.m_JPanel_Displays.get(intDisplay);
                GraphicsDeviceTools.GraphicsDeviceDescription o_GraphicsDeviceDescription = o_JPanel_Display.getGraphicsDeviceDescription();
                Rectangle o_Bounds = o_GraphicsDeviceDescription.getBounds();
                if (o_Bounds.x == 0 && o_Bounds.y == 0) {
                    o_BoundsMain = o_GraphicsDeviceDescription.getBounds();
                }
                o_AbsoluteConstraints = o_JPanel_Display.getAbsoluteConstraints();
                o_AbsoluteConstraints.x = (int)((double)intRectX + (double)(o_Bounds.x - this.m_VirtualBounds.x) * doubleFactor);
                o_AbsoluteConstraints.y = (int)((double)intRectY + (double)(o_Bounds.y - this.m_VirtualBounds.y) * doubleFactor);
                o_AbsoluteConstraints.width = (int)((double)o_Bounds.width * doubleFactor);
                o_AbsoluteConstraints.height = (int)((double)o_Bounds.height * doubleFactor);
                o_JPanel_Display.setBounds(o_AbsoluteConstraints.x, o_AbsoluteConstraints.y, o_AbsoluteConstraints.width, o_AbsoluteConstraints.height);
                if (o_JPanel_Display.getIsSelected()) {
                    o_JPanel_Display.setOpaque(false);
                    continue;
                }
                o_JPanel_Display.setOpaque(true);
            }
        }
        if (this.m_VirtualBoundsSelection.width == 0 && this.m_VirtualBoundsSelection.height == 0) {
            o_AbsoluteConstraints = this.m_JPanelImage.getAbsoluteConstraints();
            o_AbsoluteConstraints.x = (int)((double)intRectX + (double)(o_BoundsMain.x - this.m_VirtualBounds.x) * doubleFactor);
            o_AbsoluteConstraints.y = (int)((double)intRectY + (double)(o_BoundsMain.y - this.m_VirtualBounds.y) * doubleFactor);
            o_AbsoluteConstraints.width = (int)((double)o_BoundsMain.width * doubleFactor);
            o_AbsoluteConstraints.height = (int)((double)o_BoundsMain.height * doubleFactor);
        } else {
            o_AbsoluteConstraints = this.m_JPanelImage.getAbsoluteConstraints();
            o_AbsoluteConstraints.x = (int)((double)intRectX + (double)(this.m_VirtualBoundsSelection.x - this.m_VirtualBounds.x) * doubleFactor);
            o_AbsoluteConstraints.y = (int)((double)intRectY + (double)(this.m_VirtualBoundsSelection.y - this.m_VirtualBounds.y) * doubleFactor);
            o_AbsoluteConstraints.width = (int)((double)this.m_VirtualBoundsSelection.width * doubleFactor);
            o_AbsoluteConstraints.height = (int)((double)this.m_VirtualBoundsSelection.height * doubleFactor);
        }
        this.m_JPanelImage.setBounds(o_AbsoluteConstraints.x, o_AbsoluteConstraints.y, o_AbsoluteConstraints.width, o_AbsoluteConstraints.height);
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPanel_Display getJPanel_Display(GraphicsDeviceTools.GraphicsDeviceDescription p_GraphicsDeviceDescription) {
        if (p_GraphicsDeviceDescription == null) {
            return null;
        }
        Object object = this.m_SyncDisplays;
        synchronized (object) {
            for (int intPanel = 0; intPanel < this.m_JPanel_Displays.size(); ++intPanel) {
                JPanel_Display o_JPanel_Display = this.m_JPanel_Displays.get(intPanel);
                if (!o_JPanel_Display.getGraphicsDeviceDescription().getIDString().equals(p_GraphicsDeviceDescription.getIDString())) continue;
                return o_JPanel_Display;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionListener(SelectionListener p_SelectionListener) {
        if (p_SelectionListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_SelectionListeners.contains(p_SelectionListener)) {
                return;
            }
            this.m_SelectionListeners.add(p_SelectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionListener(SelectionListener p_SelectionListener) {
        if (p_SelectionListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (!this.m_SelectionListeners.contains(p_SelectionListener)) {
                return;
            }
            this.m_SelectionListeners.remove(p_SelectionListener);
        }
    }

    public void notifySelectionChanged() {
        this.arrangeDisplays();
        EventQueueHandler.invokeLater(this.m_RunnableSelectionNotify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection() {
        Object object = this.m_SyncDisplays;
        synchronized (object) {
            for (int intDisplay = 0; intDisplay < this.m_JPanel_Displays.size(); ++intDisplay) {
                JPanel_Display o_JPanel_Display = this.m_JPanel_Displays.get(intDisplay);
                o_JPanel_Display.setSelected(false);
            }
        }
        this.notifySelectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectedGraphicsDeviceDescription(GraphicsDeviceTools.GraphicsDeviceDescription p_GraphicsDeviceDescription) {
        JPanel_Display o_JPanel_Display;
        if (p_GraphicsDeviceDescription == null) {
            return;
        }
        Object object = this.m_SyncSelection;
        synchronized (object) {
            if (this.m_SelectedGraphicsDeviceDescriptions.contains(p_GraphicsDeviceDescription)) {
                return;
            }
            o_JPanel_Display = this.getJPanel_Display(p_GraphicsDeviceDescription);
            if (o_JPanel_Display == null) {
                return;
            }
            this.m_SelectedGraphicsDeviceDescriptions.add(p_GraphicsDeviceDescription);
        }
        o_JPanel_Display.setSelected(true);
        this.notifySelectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedGraphicsDeviceDescription(GraphicsDeviceTools.GraphicsDeviceDescription p_GraphicsDeviceDescription) {
        if (p_GraphicsDeviceDescription == null) {
            return;
        }
        JPanel_Display o_JPanel_Display = this.getJPanel_Display(p_GraphicsDeviceDescription);
        if (o_JPanel_Display == null) {
            return;
        }
        Object object = this.m_SyncSelection;
        synchronized (object) {
            this.m_SelectedGraphicsDeviceDescriptions.remove(p_GraphicsDeviceDescription);
        }
        o_JPanel_Display.setSelected(false);
        this.notifySelectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> getSelectedGraphicsDeviceDescriptions(ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> p_SelectedGraphicsDeviceDescriptions) {
        if (p_SelectedGraphicsDeviceDescriptions == null) {
            p_SelectedGraphicsDeviceDescriptions = new ArrayList();
        }
        p_SelectedGraphicsDeviceDescriptions.clear();
        Object object = this.m_SyncDisplays;
        synchronized (object) {
            for (int intDisplay = 0; intDisplay < this.m_JPanel_Displays.size(); ++intDisplay) {
                JPanel_Display o_JPanel_Display = this.m_JPanel_Displays.get(intDisplay);
                if (!o_JPanel_Display.getIsSelected()) continue;
                p_SelectedGraphicsDeviceDescriptions.add(o_JPanel_Display.getGraphicsDeviceDescription());
            }
        }
        return p_SelectedGraphicsDeviceDescriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> setSelectedGraphicsDeviceDescriptions(ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> p_GraphicsDeviceDescriptions) {
        if (p_GraphicsDeviceDescriptions == null) {
            return null;
        }
        this.clearSelection();
        ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> o_GraphicsDeviceDescriptions = new ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription>(p_GraphicsDeviceDescriptions.size());
        for (int intDevice = 0; intDevice < p_GraphicsDeviceDescriptions.size(); ++intDevice) {
            JPanel_Display o_JPanel_Display;
            GraphicsDeviceTools.GraphicsDeviceDescription o_GraphicsDeviceDescription = p_GraphicsDeviceDescriptions.get(intDevice);
            if (GraphicsDeviceTools.getGraphicsDevice(o_GraphicsDeviceDescription) == null || (o_JPanel_Display = this.getJPanel_Display(o_GraphicsDeviceDescription)) == null) continue;
            o_JPanel_Display.setSelected(true);
            o_GraphicsDeviceDescriptions.add(o_JPanel_Display.getGraphicsDeviceDescription());
        }
        Object object = this.m_SyncSelection;
        synchronized (object) {
            if (this.m_SelectedGraphicsDeviceDescriptions != p_GraphicsDeviceDescriptions) {
                this.m_SelectedGraphicsDeviceDescriptions.clear();
                this.m_SelectedGraphicsDeviceDescriptions.addAll(p_GraphicsDeviceDescriptions);
            }
        }
        return o_GraphicsDeviceDescriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateVirtualBoundsSelection() {
        Point o_PointUpperLeft = new Point(0, 0);
        Point o_PointUnderRight = new Point(0, 0);
        int intSelectedCount = 0;
        Object object = this.m_SyncDisplays;
        synchronized (object) {
            for (int intDisplay = 0; intDisplay < this.m_JPanel_Displays.size(); ++intDisplay) {
                JPanel_Display o_JPanel_Display = this.m_JPanel_Displays.get(intDisplay);
                if (!o_JPanel_Display.getIsSelected()) continue;
                ++intSelectedCount;
                Rectangle o_Bounds = o_JPanel_Display.getGraphicsDeviceDescription().getBounds();
                if (o_Bounds.x < o_PointUpperLeft.x) {
                    o_PointUpperLeft.x = o_Bounds.x;
                }
                if (o_Bounds.y < o_PointUpperLeft.y) {
                    o_PointUpperLeft.y = o_Bounds.y;
                }
                if (o_Bounds.x + o_Bounds.width > o_PointUnderRight.x) {
                    o_PointUnderRight.x = o_Bounds.x + o_Bounds.width;
                }
                if (o_Bounds.y + o_Bounds.height <= o_PointUnderRight.y) continue;
                o_PointUnderRight.y = o_Bounds.y + o_Bounds.height;
            }
        }
        this.m_VirtualBoundsSelection.setBounds(o_PointUpperLeft.x, o_PointUpperLeft.y, o_PointUnderRight.x - o_PointUpperLeft.x, o_PointUnderRight.y - o_PointUpperLeft.y);
    }

    public static class JPanelImage
    extends JPanelBackground {
        private AbsoluteConstraints m_AbsoluteConstraints;

        public JPanelImage() {
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_AbsoluteConstraints = new AbsoluteConstraints(0, 0);
        }

        private void initComponents() {
            this.setBackgroundImage(new ImageIcon(this.getClass().getResource("/GraphicsDeviceToolsPackage/Icon_Rainbow.png")).getImage());
            this.setBackgroundOpaque(true);
            this.setBackgroundStyle(2);
        }

        public AbsoluteConstraints getAbsoluteConstraints() {
            return this.m_AbsoluteConstraints;
        }
    }

    public static class JPanel_Display
    extends JPanel {
        public static Border BORDER_NORMAL = new LineBorder(Color.LIGHT_GRAY, 3, true);
        public static Border BORDER_SELECTED = new LineBorder(Color.BLUE, 3);
        public static Border BORDER_MAIN = new LineBorder(Color.ORANGE, 3);
        private JPanel_GraphicsDevices m_JPanel_GraphicsDevices;
        private AbsoluteConstraints m_AbsoluteConstraints;
        private GraphicsDeviceTools.GraphicsDeviceDescription m_GraphicsDeviceDescription;
        private JLabel m_LabelText;
        private StringBuffer m_StringBuffer;
        private boolean m_IsSelected;

        public JPanel_Display(JPanel_GraphicsDevices p_JPanel_GraphicsDevices, GraphicsDeviceTools.GraphicsDeviceDescription p_GraphicsDeviceDescription) {
            this.initMembers();
            this.m_JPanel_GraphicsDevices = p_JPanel_GraphicsDevices;
            this.m_GraphicsDeviceDescription = p_GraphicsDeviceDescription;
            this.initComponents();
        }

        private void initMembers() {
            this.m_AbsoluteConstraints = new AbsoluteConstraints(0, 0);
            this.m_StringBuffer = new StringBuffer();
            this.m_IsSelected = false;
        }

        private void initComponents() {
            if (this.m_GraphicsDeviceDescription.getBounds().x == 0 && this.m_GraphicsDeviceDescription.getBounds().y == 0) {
                this.setBorder(BORDER_MAIN);
            } else {
                this.setBorder(BORDER_NORMAL);
            }
            this.setBackground(Color.DARK_GRAY);
            this.setLayout(new GridBagLayout());
            this.m_LabelText = new JLabel();
            this.m_LabelText.setForeground(new Color(80, 0, 0));
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.anchor = 10;
            this.add((Component)this.m_LabelText, o_GridBagConstraints);
            this.m_LabelText.setVisible(true);
            this.m_LabelText.setFont(new Font("Tahoma", 1, 13));
            this.addMouseListener(new MouseAdapter_Delayed(){

                @Override
                public void mouseClicked_Delayed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        if (e.isShiftDown() || e.isControlDown()) {
                            if (OSChecker.getOSGroupFlag() == 3) {
                                m_JPanel_GraphicsDevices.clearSelection();
                                this.setSelected(true);
                            } else if (m_IsSelected) {
                                this.setSelected(false);
                            } else {
                                this.setSelected(true);
                            }
                        } else if (e.getClickCount() > 1) {
                            if (OSChecker.getOSGroupFlag() == 3) {
                                m_JPanel_GraphicsDevices.clearSelection();
                                this.setSelected(true);
                            } else if (m_IsSelected) {
                                this.setSelected(false);
                            } else {
                                this.setSelected(true);
                            }
                        } else {
                            m_JPanel_GraphicsDevices.clearSelection();
                            this.setSelected(true);
                        }
                    }
                }
            });
            this.refreshGUI();
        }

        public void close() {
            this.setVisible(false);
        }

        public void refreshGUI() {
            this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
            this.m_StringBuffer.append("<html>");
            if (this.m_GraphicsDeviceDescription != null) {
                String stringGraphicsDevideID = this.m_GraphicsDeviceDescription.getIDString();
                if (stringGraphicsDevideID.startsWith("\\")) {
                    this.m_StringBuffer.append(stringGraphicsDevideID.substring(1, stringGraphicsDevideID.length()));
                } else {
                    this.m_StringBuffer.append(stringGraphicsDevideID);
                }
                this.m_StringBuffer.append("<br>");
                this.m_StringBuffer.append(this.m_GraphicsDeviceDescription.getBounds().x);
                this.m_StringBuffer.append(",");
                this.m_StringBuffer.append(this.m_GraphicsDeviceDescription.getBounds().y);
                this.m_StringBuffer.append("<br>");
                this.m_StringBuffer.append(this.m_GraphicsDeviceDescription.getBounds().width);
                this.m_StringBuffer.append(" x ");
                this.m_StringBuffer.append(this.m_GraphicsDeviceDescription.getBounds().height);
            }
            this.m_StringBuffer.append("</html>");
            this.m_LabelText.setText(this.m_StringBuffer.toString());
            if (this.m_IsSelected) {
                this.m_LabelText.setForeground(Color.BLACK);
            } else {
                this.m_LabelText.setForeground(Color.WHITE);
            }
        }

        public AbsoluteConstraints getAbsoluteConstraints() {
            return this.m_AbsoluteConstraints;
        }

        public void setGraphicsDeviceDescription(GraphicsDeviceTools.GraphicsDeviceDescription p_GraphicsDeviceDescription) {
            this.m_GraphicsDeviceDescription = p_GraphicsDeviceDescription;
            this.refreshGUI();
        }

        public GraphicsDeviceTools.GraphicsDeviceDescription getGraphicsDeviceDescription() {
            return this.m_GraphicsDeviceDescription;
        }

        public void setSelected(boolean p_IsSelected) {
            if (this.m_IsSelected == p_IsSelected) {
                return;
            }
            this.m_IsSelected = p_IsSelected;
            if (this.m_IsSelected) {
                this.setBorder(BORDER_SELECTED);
            } else if (this.m_GraphicsDeviceDescription.getBounds().x == 0 && this.m_GraphicsDeviceDescription.getBounds().y == 0) {
                this.setBorder(BORDER_MAIN);
            } else {
                this.setBorder(BORDER_NORMAL);
            }
            if (this.m_IsSelected) {
                this.m_JPanel_GraphicsDevices.addSelectedGraphicsDeviceDescription(this.m_GraphicsDeviceDescription);
            } else {
                this.m_JPanel_GraphicsDevices.removeSelectedGraphicsDeviceDescription(this.m_GraphicsDeviceDescription);
            }
            this.refreshGUI();
        }

        public boolean getIsSelected() {
            return this.m_IsSelected;
        }
    }

    public static interface SelectionListener {
        public void selectionChanged(ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> var1);
    }
}

