/*
 * Decompiled with CFR 0.152.
 */
package GraphicsDeviceToolsPackage;

import OS.OSChecker;
import SwingModelPackage.TableAndListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class GraphicsDeviceTools {
    private static TableAndListModel.ListModel<GraphicsDevice> s_ListModel_GraphicsDevices = new TableAndListModel.ListModel(false);
    private static GraphicsEnvironment s_GraphicsEnvironment;
    private static ArrayList<GraphicsDevice> s_GraphicsDevices;
    private static ArrayList<GraphicsDeviceDescription> s_GraphicsDeviceDescriptions;
    private static boolean s_GraphicEnvironmentChecked;
    private static Point s_Point_TopLeft;
    private static Point s_Point_DownRight;
    private static Rectangle s_VirtualBounds;
    private static int s_MinimumVisible;
    private static final Object s_SyncObject;
    private static ArrayList<GraphicsDeviceListener> s_GraphicsDeviceListeners;
    private static final Object s_SyncListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshGraphicsDevices() {
        ArrayList<GraphicsDeviceDescription> o_ChangedGraphicsDeviceDescriptions = null;
        ArrayList<GraphicsDeviceDescription> o_AddedGraphicsDeviceDescriptions = null;
        ArrayList<GraphicsDeviceDescription> o_RemovedGraphicsDeviceDescriptions = null;
        s_GraphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (s_GraphicsEnvironment == null) {
            return;
        }
        Object object = s_SyncObject;
        synchronized (object) {
            try {
                GraphicsDeviceDescription o_GraphicsDeviceDescription;
                int intIndex;
                GraphicsDevice o_GraphicsDevice;
                int intDevice;
                ArrayList<GraphicsDevice> o_OldGraphicsDevices = new ArrayList<GraphicsDevice>(s_GraphicsDevices.size());
                o_OldGraphicsDevices.addAll(s_GraphicsDevices);
                GraphicsDevice[] o_NewGraphicsDevices = s_GraphicsEnvironment.getScreenDevices();
                for (intDevice = 0; intDevice < o_NewGraphicsDevices.length; ++intDevice) {
                    String stringDeviceID;
                    o_GraphicsDevice = o_NewGraphicsDevices[intDevice];
                    GraphicsConfiguration o_GraphicsConfiguration = o_GraphicsDevice.getDefaultConfiguration();
                    Rectangle o_Bounds = o_GraphicsConfiguration.getBounds();
                    if (intDevice == 0) {
                        s_Point_TopLeft.setLocation(o_Bounds.x, o_Bounds.y);
                        s_Point_DownRight.setLocation(o_Bounds.x + o_Bounds.width, o_Bounds.y + o_Bounds.height);
                    }
                    if (o_Bounds.x < GraphicsDeviceTools.s_Point_TopLeft.x) {
                        GraphicsDeviceTools.s_Point_TopLeft.x = o_Bounds.x;
                    }
                    if (o_Bounds.y < GraphicsDeviceTools.s_Point_TopLeft.y) {
                        GraphicsDeviceTools.s_Point_TopLeft.y = o_Bounds.y;
                    }
                    if (o_Bounds.x + o_Bounds.width > GraphicsDeviceTools.s_Point_DownRight.x) {
                        GraphicsDeviceTools.s_Point_DownRight.x = o_Bounds.x + o_Bounds.width;
                    }
                    if (o_Bounds.y + o_Bounds.height > GraphicsDeviceTools.s_Point_DownRight.y) {
                        GraphicsDeviceTools.s_Point_DownRight.y = o_Bounds.y + o_Bounds.height;
                    }
                    if ((stringDeviceID = o_GraphicsDevice.getIDstring()) == null || stringDeviceID.length() <= 0) {
                        stringDeviceID = "DisplayIndex" + String.valueOf(intDevice);
                    }
                    if (s_GraphicsDevices.contains(o_GraphicsDevice)) {
                        o_OldGraphicsDevices.remove(o_GraphicsDevice);
                        intIndex = s_GraphicsDevices.indexOf(o_GraphicsDevice);
                        if (intIndex < 0 || (o_GraphicsDeviceDescription = s_GraphicsDeviceDescriptions.get(intIndex)) == null || !o_GraphicsDeviceDescription.changeDescription(intDevice, o_GraphicsDevice.getIDstring(), o_GraphicsConfiguration.getBounds())) continue;
                        if (o_ChangedGraphicsDeviceDescriptions == null) {
                            o_ChangedGraphicsDeviceDescriptions = new ArrayList<GraphicsDeviceDescription>(1);
                        }
                        o_ChangedGraphicsDeviceDescriptions.add(o_GraphicsDeviceDescription);
                        continue;
                    }
                    s_GraphicsDevices.add(o_NewGraphicsDevices[intDevice]);
                    s_ListModel_GraphicsDevices.add((Object)o_GraphicsDevice);
                    o_GraphicsDeviceDescription = new GraphicsDeviceDescription(intDevice, o_GraphicsDevice.getIDstring(), o_GraphicsConfiguration.getBounds());
                    s_GraphicsDeviceDescriptions.add(o_GraphicsDeviceDescription);
                    if (o_AddedGraphicsDeviceDescriptions == null) {
                        o_AddedGraphicsDeviceDescriptions = new ArrayList<GraphicsDeviceDescription>(1);
                    }
                    o_AddedGraphicsDeviceDescriptions.add(o_GraphicsDeviceDescription);
                }
                s_VirtualBounds.setBounds(GraphicsDeviceTools.s_Point_TopLeft.x, GraphicsDeviceTools.s_Point_TopLeft.y, GraphicsDeviceTools.s_Point_DownRight.x - GraphicsDeviceTools.s_Point_TopLeft.x, GraphicsDeviceTools.s_Point_DownRight.y - GraphicsDeviceTools.s_Point_TopLeft.y);
                for (intDevice = o_OldGraphicsDevices.size() - 1; intDevice >= 0; --intDevice) {
                    o_GraphicsDevice = (GraphicsDevice)o_OldGraphicsDevices.get(intDevice);
                    intIndex = s_GraphicsDevices.indexOf(o_GraphicsDevice);
                    if (intIndex < 0) continue;
                    s_ListModel_GraphicsDevices.remove((Object)o_GraphicsDevice);
                    s_GraphicsDevices.remove(o_GraphicsDevice);
                    o_GraphicsDeviceDescription = s_GraphicsDeviceDescriptions.get(intIndex);
                    s_GraphicsDeviceDescriptions.remove(intIndex);
                    if (o_RemovedGraphicsDeviceDescriptions == null) {
                        o_RemovedGraphicsDeviceDescriptions = new ArrayList<GraphicsDeviceDescription>(1);
                    }
                    o_RemovedGraphicsDeviceDescriptions.add(o_GraphicsDeviceDescription);
                }
                s_GraphicEnvironmentChecked = true;
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
        if (o_RemovedGraphicsDeviceDescriptions != null) {
            GraphicsDeviceTools.notifyListenersRemovedDevice(o_RemovedGraphicsDeviceDescriptions);
        }
        if (o_AddedGraphicsDeviceDescriptions != null) {
            GraphicsDeviceTools.notifyListenersAddedDevice(o_AddedGraphicsDeviceDescriptions);
        }
        if (o_ChangedGraphicsDeviceDescriptions != null) {
            GraphicsDeviceTools.notifyListenersChangedDevice(o_ChangedGraphicsDeviceDescriptions);
        }
    }

    public static void startAutmaticRefresh() {
    }

    public static void stopAutmaticRefresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getGraphicsDeviceCount() {
        if (!s_GraphicEnvironmentChecked) {
            GraphicsDeviceTools.refreshGraphicsDevices();
        }
        Object object = s_SyncObject;
        synchronized (object) {
            return s_GraphicsDevices.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphicsDevice getGraphicsDevice(String p_IDString) {
        if (p_IDString == null) {
            return null;
        }
        if (!s_GraphicEnvironmentChecked) {
            GraphicsDeviceTools.refreshGraphicsDevices();
        }
        Object object = s_SyncObject;
        synchronized (object) {
            for (int intDevice = 0; intDevice < s_GraphicsDevices.size(); ++intDevice) {
                GraphicsDevice o_GraphicsDevice = s_GraphicsDevices.get(intDevice);
                if (o_GraphicsDevice == null || !o_GraphicsDevice.getIDstring().equals(p_IDString)) continue;
                return o_GraphicsDevice;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphicsDevice getGraphicsDevice(GraphicsDeviceDescription p_GraphicsDeviceDescription) {
        if (p_GraphicsDeviceDescription == null) {
            return null;
        }
        if (!s_GraphicEnvironmentChecked) {
            GraphicsDeviceTools.refreshGraphicsDevices();
        }
        Object object = s_SyncObject;
        synchronized (object) {
            for (int intDevice = 0; intDevice < s_GraphicsDevices.size(); ++intDevice) {
                GraphicsDevice o_GraphicsDevice = s_GraphicsDevices.get(intDevice);
                if (o_GraphicsDevice == null || !o_GraphicsDevice.getIDstring().equals(p_GraphicsDeviceDescription.getIDString())) continue;
                return o_GraphicsDevice;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphicsDeviceDescription getGraphicsDeviceDescription(int p_Index) {
        GraphicsDeviceDescription o_GraphicsDeviceDescription;
        if (p_Index < 0) {
            return null;
        }
        Object object = s_SyncObject;
        synchronized (object) {
            if (p_Index >= s_GraphicsDeviceDescriptions.size()) {
                return null;
            }
            o_GraphicsDeviceDescription = s_GraphicsDeviceDescriptions.get(p_Index);
        }
        return o_GraphicsDeviceDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphicsDeviceDescription getGraphicsDeviceDescription(String p_IDString) {
        if (p_IDString == null) {
            return null;
        }
        if (!s_GraphicEnvironmentChecked) {
            GraphicsDeviceTools.refreshGraphicsDevices();
        }
        Object object = s_SyncObject;
        synchronized (object) {
            for (int intDescription = 0; intDescription < s_GraphicsDeviceDescriptions.size(); ++intDescription) {
                GraphicsDeviceDescription o_GraphicsDeviceDescription = s_GraphicsDeviceDescriptions.get(intDescription);
                if (o_GraphicsDeviceDescription == null || !o_GraphicsDeviceDescription.getIDString().equals(p_IDString)) continue;
                return o_GraphicsDeviceDescription;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphicsDeviceDescription getGraphicsDeviceDescription(int p_ScreenX, int p_ScreenY) {
        if (!s_GraphicEnvironmentChecked) {
            GraphicsDeviceTools.refreshGraphicsDevices();
        }
        Object object = s_SyncObject;
        synchronized (object) {
            for (int intDescription = 0; intDescription < s_GraphicsDeviceDescriptions.size(); ++intDescription) {
                GraphicsDeviceDescription o_GraphicsDeviceDescription = s_GraphicsDeviceDescriptions.get(intDescription);
                if (o_GraphicsDeviceDescription == null || p_ScreenX < o_GraphicsDeviceDescription.getX() || p_ScreenX > o_GraphicsDeviceDescription.getX() + o_GraphicsDeviceDescription.getWidth() || p_ScreenY < o_GraphicsDeviceDescription.getY() || p_ScreenY > o_GraphicsDeviceDescription.getY() + o_GraphicsDeviceDescription.getHeight()) continue;
                return o_GraphicsDeviceDescription;
            }
        }
        return null;
    }

    public static TableAndListModel.ListModel<GraphicsDevice> getGraphicsDeviceListModel() {
        return s_ListModel_GraphicsDevices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<GraphicsDeviceDescription> getGraphicsDeviceDescriptions() {
        ArrayList<GraphicsDeviceDescription> o_GraphicsDeviceDescriptions;
        Object object = s_SyncObject;
        synchronized (object) {
            if (!s_GraphicEnvironmentChecked) {
                GraphicsDeviceTools.refreshGraphicsDevices();
            }
            o_GraphicsDeviceDescriptions = new ArrayList<GraphicsDeviceDescription>(s_GraphicsDeviceDescriptions.size());
            o_GraphicsDeviceDescriptions.addAll(s_GraphicsDeviceDescriptions);
        }
        return o_GraphicsDeviceDescriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DisplayMode getDisplayMode(GraphicsDeviceDescription p_GraphicsDeviceDescription) {
        if (p_GraphicsDeviceDescription == null) {
            return null;
        }
        if (!s_GraphicEnvironmentChecked) {
            GraphicsDeviceTools.refreshGraphicsDevices();
        }
        Object object = s_SyncObject;
        synchronized (object) {
            for (int intDevice = 0; intDevice < s_GraphicsDevices.size(); ++intDevice) {
                GraphicsDevice o_GraphicsDevice = s_GraphicsDevices.get(intDevice);
                if (o_GraphicsDevice == null || !o_GraphicsDevice.getIDstring().equals(p_GraphicsDeviceDescription.getIDString())) continue;
                return o_GraphicsDevice.getDisplayMode();
            }
            return null;
        }
    }

    public static GraphicsDevice getDefaultGraphicsDevice() {
        GraphicsDevice o_GraphicsDevice;
        GraphicsEnvironment o_GraphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (o_GraphicsEnvironment == null) {
            return null;
        }
        try {
            o_GraphicsDevice = o_GraphicsEnvironment.getDefaultScreenDevice();
        }
        catch (Exception e) {
            o_GraphicsDevice = null;
        }
        return o_GraphicsDevice;
    }

    public static Rectangle getDefaultGraphicsDevice_Bounds() {
        GraphicsDevice o_GraphicsDevice = GraphicsDeviceTools.getDefaultGraphicsDevice();
        if (o_GraphicsDevice == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return o_GraphicsDevice.getDefaultConfiguration().getBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle getVirtualBounds_AllGraphicsDevices() {
        if (!s_GraphicEnvironmentChecked) {
            GraphicsDeviceTools.refreshGraphicsDevices();
        }
        Object object = s_SyncObject;
        synchronized (object) {
            return s_VirtualBounds;
        }
    }

    public static Rectangle checkComponentMaxBounds(Component p_Component, Rectangle p_MaxBounds) {
        if (p_MaxBounds == null) {
            p_MaxBounds = new Rectangle();
        }
        if (p_Component == null) {
            return p_MaxBounds;
        }
        Rectangle o_Bounds = new Rectangle();
        o_Bounds = p_Component.getBounds(o_Bounds);
        if (o_Bounds.width > p_MaxBounds.width) {
            o_Bounds.width = p_MaxBounds.width;
        }
        if (o_Bounds.height > p_MaxBounds.height) {
            o_Bounds.height = p_MaxBounds.height;
        }
        if (o_Bounds.y < 0) {
            o_Bounds.y = 0;
        }
        if (o_Bounds.y > p_MaxBounds.height - s_MinimumVisible) {
            o_Bounds.y = p_MaxBounds.height - s_MinimumVisible;
        }
        if (o_Bounds.x > p_MaxBounds.width - s_MinimumVisible) {
            o_Bounds.x = p_MaxBounds.width - s_MinimumVisible;
        }
        if (o_Bounds.x + o_Bounds.width < s_MinimumVisible) {
            o_Bounds.x = s_MinimumVisible - o_Bounds.width;
        }
        return o_Bounds;
    }

    public static void checkComponentBounds(Component p_Component, Container p_Container, Rectangle p_MaxBounds, Rectangle p_NewBounds, int p_Lapping) {
        if (p_Component == null) {
            return;
        }
        if (p_MaxBounds == null) {
            p_MaxBounds = s_VirtualBounds;
        }
        if (p_Lapping < 0) {
            p_Lapping = 0;
        }
        boolean boolChanged = false;
        if (p_NewBounds == null) {
            return;
        }
        Rectangle o_Bounds = (Rectangle)p_NewBounds.clone();
        Dimension o_MinimumSize = p_Component.getMinimumSize();
        if (o_Bounds.width > p_MaxBounds.width) {
            o_Bounds.width = p_MaxBounds.width;
            boolChanged = true;
        }
        if (o_Bounds.height > p_MaxBounds.height - p_Lapping) {
            o_Bounds.height = p_MaxBounds.height - p_Lapping;
            boolChanged = true;
        }
        if (o_Bounds.width < o_MinimumSize.width) {
            o_Bounds.width = o_MinimumSize.width;
            boolChanged = true;
        }
        if (o_Bounds.height < o_MinimumSize.height) {
            o_Bounds.height = o_MinimumSize.height;
            boolChanged = true;
        }
        if (p_Lapping <= 0) {
            p_Lapping = 100;
        }
        if (p_Container == null) {
            if (o_Bounds.x > p_MaxBounds.x + p_MaxBounds.width - p_Lapping) {
                o_Bounds.x = p_MaxBounds.x;
                boolChanged = true;
            } else if (o_Bounds.x + o_Bounds.width < p_MaxBounds.x + p_Lapping) {
                o_Bounds.x = p_MaxBounds.x;
                boolChanged = true;
            }
            if (o_Bounds.y > p_MaxBounds.y + p_MaxBounds.height - p_Lapping) {
                o_Bounds.y = p_MaxBounds.y;
                boolChanged = true;
            }
            if (o_Bounds.y < p_MaxBounds.y) {
                o_Bounds.y = p_MaxBounds.y;
                boolChanged = true;
            }
        } else {
            if (o_Bounds.x > p_MaxBounds.width - p_Lapping) {
                o_Bounds.x = p_MaxBounds.width - p_Lapping;
                boolChanged = true;
            } else if (o_Bounds.x + o_Bounds.width < p_Lapping) {
                o_Bounds.x = p_Lapping - o_Bounds.width;
                boolChanged = true;
            }
            if (o_Bounds.y > p_MaxBounds.height - p_Lapping) {
                o_Bounds.y = p_MaxBounds.height - p_Lapping;
                boolChanged = true;
            }
            if (o_Bounds.y < 0) {
                o_Bounds.y = 0;
                boolChanged = true;
            }
        }
        if (!o_Bounds.equals(p_Component.getBounds())) {
            if (p_Component instanceof JInternalFrame) {
                if (((JInternalFrame)p_Component).isResizable()) {
                    p_Component.setBounds(o_Bounds);
                } else {
                    p_Component.setLocation(o_Bounds.x, o_Bounds.y);
                }
            } else {
                p_Component.setBounds(o_Bounds);
            }
            if (p_Container != null) {
                p_Container.revalidate();
                p_Container.repaint();
            }
            p_Component.revalidate();
            p_Component.repaint();
        }
    }

    public static Rectangle showOnGraphicsDevice_Description(GraphicsDeviceDescription p_GraphicsDeviceDescription, JFrame p_JFrame) {
        if (p_GraphicsDeviceDescription == null) {
            return GraphicsDeviceTools.showOnGraphicsDevice_Index(0, p_JFrame);
        }
        return GraphicsDeviceTools.showOnGraphicsDevice_ID(p_GraphicsDeviceDescription.getIDString(), p_JFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle showOnGraphicsDevice_ID(String p_IDString, JFrame p_JFrame) {
        if (p_IDString == null) {
            return GraphicsDeviceTools.showOnGraphicsDevice_Index(0, p_JFrame);
        }
        if (!s_GraphicEnvironmentChecked) {
            GraphicsDeviceTools.refreshGraphicsDevices();
        }
        Object object = s_SyncObject;
        synchronized (object) {
            for (int intScreen = 0; intScreen < s_GraphicsDevices.size(); ++intScreen) {
                GraphicsDevice o_GraphicsDevice = s_GraphicsDevices.get(intScreen);
                if (o_GraphicsDevice == null || !o_GraphicsDevice.getIDstring().equals(p_IDString)) continue;
                return GraphicsDeviceTools.showOnGraphicsDevice_Index(intScreen, p_JFrame);
            }
        }
        return GraphicsDeviceTools.showOnGraphicsDevice_Index(0, p_JFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle showOnGraphicsDevice_Index(int p_Index, JFrame p_JFrame) {
        if (p_JFrame == null) {
            Rectangle o_Bounds = new Rectangle();
            return o_Bounds;
        }
        if (!s_GraphicEnvironmentChecked) {
            GraphicsDeviceTools.refreshGraphicsDevices();
        }
        Object object = s_SyncObject;
        synchronized (object) {
            if (s_GraphicsDevices.size() <= 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            if (p_Index < 0) {
                p_Index = 0;
            }
            if (p_Index >= s_GraphicsDevices.size()) {
                p_Index = 0;
            }
            GraphicsDevice o_GraphicsDevice = s_GraphicsDevices.get(p_Index);
            Rectangle o_Bounds = o_GraphicsDevice.getDefaultConfiguration().getBounds();
            p_JFrame.setBounds(o_Bounds.x, o_Bounds.y, o_Bounds.width, o_Bounds.height);
            return o_Bounds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle showOnGraphicsDevice_Descriptions(ArrayList<GraphicsDeviceDescription> p_GraphicsDeviceDescriptions, JFrame p_JFrame) {
        if (p_JFrame == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (p_GraphicsDeviceDescriptions == null) {
            return GraphicsDeviceTools.showOnGraphicsDevice_Index(0, p_JFrame);
        }
        ArrayList<Integer> o_Indexes = new ArrayList<Integer>();
        if (!s_GraphicEnvironmentChecked) {
            GraphicsDeviceTools.refreshGraphicsDevices();
        }
        Object object = s_SyncObject;
        synchronized (object) {
            block3: for (int intDevice = 0; intDevice < p_GraphicsDeviceDescriptions.size(); ++intDevice) {
                String stringIDString = p_GraphicsDeviceDescriptions.get(intDevice).getIDString();
                if (stringIDString == null) continue;
                for (int intScreen = 0; intScreen < s_GraphicsDevices.size(); ++intScreen) {
                    GraphicsDevice o_GraphicsDevice = s_GraphicsDevices.get(intScreen);
                    if (o_GraphicsDevice == null || !o_GraphicsDevice.getIDstring().equals(stringIDString)) continue;
                    o_Indexes.add(intScreen);
                    continue block3;
                }
            }
        }
        return GraphicsDeviceTools.showOnGraphicsDevice_Indexes(o_Indexes, p_JFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle showOnGraphicsDevice_IDs(ArrayList<String> p_IDStrings, JFrame p_JFrame) {
        if (p_JFrame == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (p_IDStrings == null) {
            return GraphicsDeviceTools.showOnGraphicsDevice_Index(0, p_JFrame);
        }
        ArrayList<Integer> o_Indexes = new ArrayList<Integer>();
        if (!s_GraphicEnvironmentChecked) {
            GraphicsDeviceTools.refreshGraphicsDevices();
        }
        Object object = s_SyncObject;
        synchronized (object) {
            block3: for (int intString = 0; intString < p_IDStrings.size(); ++intString) {
                String stringIDString = p_IDStrings.get(intString);
                if (stringIDString == null) continue;
                for (int intScreen = 0; intScreen < s_GraphicsDevices.size(); ++intScreen) {
                    GraphicsDevice o_GraphicsDevice = s_GraphicsDevices.get(intScreen);
                    if (o_GraphicsDevice == null || !o_GraphicsDevice.getIDstring().equals(stringIDString)) continue;
                    o_Indexes.add(intScreen);
                    continue block3;
                }
            }
        }
        return GraphicsDeviceTools.showOnGraphicsDevice_Indexes(o_Indexes, p_JFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle showOnGraphicsDevice_Indexes(ArrayList<Integer> p_GraphicsDeviceIndexes, JFrame p_JFrame) {
        if (p_JFrame == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (p_GraphicsDeviceIndexes == null || p_GraphicsDeviceIndexes.size() <= 0) {
            return GraphicsDeviceTools.showOnGraphicsDevice_Index(0, p_JFrame);
        }
        GraphicsDevice o_GraphicsDeviceLeftTop = null;
        Point o_PointUpperLeft = new Point(0, 0);
        Point o_PointUnderRight = new Point(0, 0);
        Rectangle o_ResultBounds = new Rectangle(0, 0, 0, 0);
        if (!s_GraphicEnvironmentChecked) {
            GraphicsDeviceTools.refreshGraphicsDevices();
        }
        Object object = s_SyncObject;
        synchronized (object) {
            if (s_GraphicsDevices.size() <= 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            for (int intIndex = 0; intIndex < p_GraphicsDeviceIndexes.size(); ++intIndex) {
                GraphicsDevice o_GraphicsDevice;
                int intGraphicsDeviceIndex = p_GraphicsDeviceIndexes.get(intIndex);
                if (intGraphicsDeviceIndex < 0) {
                    intGraphicsDeviceIndex = 0;
                }
                if (intGraphicsDeviceIndex >= s_GraphicsDevices.size()) {
                    intGraphicsDeviceIndex = 0;
                }
                if ((o_GraphicsDevice = s_GraphicsDevices.get(intGraphicsDeviceIndex)) == null) continue;
                Rectangle o_Bounds = o_GraphicsDevice.getDefaultConfiguration().getBounds();
                if (intIndex == 0) {
                    o_GraphicsDeviceLeftTop = o_GraphicsDevice;
                    o_PointUpperLeft.x = o_Bounds.x;
                    o_PointUpperLeft.y = o_Bounds.y;
                    o_PointUnderRight.x = o_Bounds.x + o_Bounds.width;
                    o_PointUnderRight.y = o_Bounds.y + o_Bounds.height;
                    continue;
                }
                if (o_Bounds.x < o_PointUpperLeft.x) {
                    o_PointUpperLeft.x = o_Bounds.x;
                    o_GraphicsDeviceLeftTop = o_GraphicsDevice;
                }
                if (o_Bounds.y < o_PointUpperLeft.y) {
                    o_PointUpperLeft.y = o_Bounds.y;
                    o_GraphicsDeviceLeftTop = o_GraphicsDevice;
                }
                if (o_Bounds.x + o_Bounds.width > o_PointUnderRight.x) {
                    o_PointUnderRight.x = o_Bounds.x + o_Bounds.width;
                }
                if (o_Bounds.y + o_Bounds.height <= o_PointUnderRight.y) continue;
                o_PointUnderRight.y = o_Bounds.y + o_Bounds.height;
            }
        }
        o_ResultBounds.setBounds(o_PointUpperLeft.x, o_PointUpperLeft.y, o_PointUnderRight.x - o_PointUpperLeft.x, o_PointUnderRight.y - o_PointUpperLeft.y);
        return GraphicsDeviceTools.showOnGraphicsDevice(p_JFrame, o_GraphicsDeviceLeftTop, o_ResultBounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGraphicDeviceListener(GraphicsDeviceListener p_GraphicsDeviceListener) {
        if (p_GraphicsDeviceListener == null) {
            return;
        }
        Object object = s_SyncListener;
        synchronized (object) {
            if (s_GraphicsDeviceListeners.contains(p_GraphicsDeviceListener)) {
                return;
            }
            s_GraphicsDeviceListeners.add(p_GraphicsDeviceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeGraphicDeviceListener(GraphicsDeviceListener p_GraphicsDeviceListener) {
        if (p_GraphicsDeviceListener == null) {
            return;
        }
        Object object = s_SyncListener;
        synchronized (object) {
            s_GraphicsDeviceListeners.remove(p_GraphicsDeviceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyListenersChangedDevice(ArrayList<GraphicsDeviceDescription> p_GraphicsDeviceDescriptions) {
        ArrayList<GraphicsDeviceListener> o_GraphicsDeviceListeners;
        if (p_GraphicsDeviceDescriptions == null || p_GraphicsDeviceDescriptions.size() <= 0) {
            return;
        }
        Object object = s_SyncListener;
        synchronized (object) {
            if (s_GraphicsDeviceListeners.size() <= 0) {
                return;
            }
            o_GraphicsDeviceListeners = new ArrayList<GraphicsDeviceListener>(s_GraphicsDeviceListeners.size());
            o_GraphicsDeviceListeners.addAll(s_GraphicsDeviceListeners);
        }
        for (int intListener = 0; intListener < o_GraphicsDeviceListeners.size(); ++intListener) {
            GraphicsDeviceListener o_GraphicsDeviceListener = (GraphicsDeviceListener)o_GraphicsDeviceListeners.get(intListener);
            for (int intDescription = 0; intDescription < p_GraphicsDeviceDescriptions.size(); ++intDescription) {
                GraphicsDeviceDescription o_GraphicsDeviceDescription = p_GraphicsDeviceDescriptions.get(intDescription);
                o_GraphicsDeviceListener.eventGraphicsDeviceChanged(o_GraphicsDeviceDescription);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyListenersRemovedDevice(ArrayList<GraphicsDeviceDescription> p_GraphicsDeviceDescriptions) {
        ArrayList<GraphicsDeviceListener> o_GraphicsDeviceListeners;
        if (p_GraphicsDeviceDescriptions == null || p_GraphicsDeviceDescriptions.size() <= 0) {
            return;
        }
        Object object = s_SyncListener;
        synchronized (object) {
            if (s_GraphicsDeviceListeners.size() <= 0) {
                return;
            }
            o_GraphicsDeviceListeners = new ArrayList<GraphicsDeviceListener>(s_GraphicsDeviceListeners.size());
            o_GraphicsDeviceListeners.addAll(s_GraphicsDeviceListeners);
        }
        for (int intListener = 0; intListener < o_GraphicsDeviceListeners.size(); ++intListener) {
            GraphicsDeviceListener o_GraphicsDeviceListener = (GraphicsDeviceListener)o_GraphicsDeviceListeners.get(intListener);
            for (int intDescription = 0; intDescription < p_GraphicsDeviceDescriptions.size(); ++intDescription) {
                GraphicsDeviceDescription o_GraphicsDeviceDescription = p_GraphicsDeviceDescriptions.get(intDescription);
                o_GraphicsDeviceListener.eventGraphicsDeviceRemoved(o_GraphicsDeviceDescription);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyListenersAddedDevice(ArrayList<GraphicsDeviceDescription> p_GraphicsDeviceDescriptions) {
        ArrayList<GraphicsDeviceListener> o_GraphicsDeviceListeners;
        if (p_GraphicsDeviceDescriptions == null || p_GraphicsDeviceDescriptions.size() <= 0) {
            return;
        }
        Object object = s_SyncListener;
        synchronized (object) {
            if (s_GraphicsDeviceListeners.size() <= 0) {
                return;
            }
            o_GraphicsDeviceListeners = new ArrayList<GraphicsDeviceListener>(s_GraphicsDeviceListeners.size());
            o_GraphicsDeviceListeners.addAll(s_GraphicsDeviceListeners);
        }
        for (int intListener = 0; intListener < o_GraphicsDeviceListeners.size(); ++intListener) {
            GraphicsDeviceListener o_GraphicsDeviceListener = (GraphicsDeviceListener)o_GraphicsDeviceListeners.get(intListener);
            for (int intDescription = 0; intDescription < p_GraphicsDeviceDescriptions.size(); ++intDescription) {
                GraphicsDeviceDescription o_GraphicsDeviceDescription = p_GraphicsDeviceDescriptions.get(intDescription);
                o_GraphicsDeviceListener.eventGraphicsDeviceAdded(o_GraphicsDeviceDescription);
            }
        }
    }

    public static Rectangle showOnGraphicsDevice(Window p_Window, GraphicsDevice p_GraphicsDevice, Rectangle p_Bounds) {
        if (p_Window == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (p_GraphicsDevice == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        boolean boolVisible = p_Window.isVisible();
        if (OSChecker.getOSGroupFlag() == 3) {
            p_GraphicsDevice.setFullScreenWindow(p_Window);
            p_Window.setVisible(false);
            p_Window.setVisible(boolVisible);
            return p_GraphicsDevice.getDefaultConfiguration().getBounds();
        }
        p_Window.setBounds(p_Bounds);
        return p_Bounds;
    }

    static {
        s_GraphicsDevices = new ArrayList();
        s_GraphicsDeviceDescriptions = new ArrayList();
        s_GraphicEnvironmentChecked = false;
        s_Point_TopLeft = new Point(0, 0);
        s_Point_DownRight = new Point(0, 0);
        s_VirtualBounds = new Rectangle(0, 0, 0, 0);
        s_MinimumVisible = 10;
        s_SyncObject = new Object();
        s_GraphicsDeviceListeners = new ArrayList();
        s_SyncListener = new Object();
    }

    public static class GraphicsDeviceCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            renderer.setForeground(o_Foreground);
            renderer.setBackground(o_Background);
            if (value != null && value instanceof GraphicsDevice) {
                GraphicsDevice o_GraphicsDevice = (GraphicsDevice)value;
                renderer.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                renderer.setText(o_GraphicsDevice.getIDstring());
            }
            if (!isSelected) {
                // empty if block
            }
            return renderer;
        }
    }

    public static class GraphicsDeviceDescription
    implements Externalizable {
        static final int SOFTWAREVERSION = 1;
        private int m_Index;
        private String m_IDString;
        private Rectangle m_Bounds;

        public GraphicsDeviceDescription() {
            this.initMembers();
        }

        public GraphicsDeviceDescription(int p_Index, String p_IDString, Rectangle p_Bounds) {
            this.initMembers();
            this.m_Index = p_Index;
            this.m_IDString = p_IDString;
            if (p_Bounds != null) {
                this.m_Bounds.setBounds(p_Bounds);
            }
        }

        private void initMembers() {
            this.m_Index = -1;
            this.m_IDString = "";
            this.m_Bounds = new Rectangle(0, 0, 0, 0);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeInt(this.m_Index);
            out.writeUTF(this.m_IDString);
            out.writeInt(this.m_Bounds.x);
            out.writeInt(this.m_Bounds.y);
            out.writeInt(this.m_Bounds.width);
            out.writeInt(this.m_Bounds.height);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_Index = in.readInt();
            this.m_IDString = in.readUTF();
            this.m_Bounds.x = in.readInt();
            this.m_Bounds.y = in.readInt();
            this.m_Bounds.width = in.readInt();
            this.m_Bounds.height = in.readInt();
        }

        public int getIndex() {
            return this.m_Index;
        }

        public String getIDString() {
            return this.m_IDString;
        }

        public Rectangle getBounds() {
            return this.m_Bounds;
        }

        public int getX() {
            return this.m_Bounds.x;
        }

        public int getY() {
            return this.m_Bounds.y;
        }

        public int getWidth() {
            return this.m_Bounds.width;
        }

        public int getHeight() {
            return this.m_Bounds.height;
        }

        public boolean changeDescription(int p_Index, String p_IDString, Rectangle p_Bounds) {
            if (p_Bounds == null) {
                return false;
            }
            if (p_IDString == null) {
                return false;
            }
            boolean boolChanged = false;
            if (this.m_Index != p_Index) {
                this.m_Index = p_Index;
                boolChanged = true;
            }
            if (!this.m_IDString.equals(p_IDString)) {
                this.m_IDString = p_IDString;
                boolChanged = true;
            }
            if (p_Bounds.x != this.m_Bounds.x) {
                this.m_Bounds.x = p_Bounds.x;
                boolChanged = true;
            }
            if (p_Bounds.y != this.m_Bounds.y) {
                this.m_Bounds.y = p_Bounds.y;
                boolChanged = true;
            }
            if (p_Bounds.width != this.m_Bounds.width) {
                this.m_Bounds.width = p_Bounds.width;
                boolChanged = true;
            }
            if (p_Bounds.height != this.m_Bounds.height) {
                this.m_Bounds.height = p_Bounds.height;
                boolChanged = true;
            }
            return boolChanged;
        }
    }

    public static interface GraphicsDeviceListener {
        public void eventGraphicsDeviceAdded(GraphicsDeviceDescription var1);

        public void eventGraphicsDeviceRemoved(GraphicsDeviceDescription var1);

        public void eventGraphicsDeviceChanged(GraphicsDeviceDescription var1);
    }
}

