/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import DMXHardwarePackage.DMXHardwareInterface;
import DMXHardwarePackage.LAN_Device;
import DMXHardwarePackage.LAN_Device_ArtNet;
import DMXHardwarePackage.LAN_Interface;
import DMXHardwarePackage.LAN_Interface_Configuration;
import DMXHardwarePackage.LAN_Universe;
import GUIDPackage.HardwareGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import ProtocolPackage.Protocols;
import SwingModelPackage.TableAndListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableRowSorter;

public class LAN_PlugIn
implements PropertyChangeListener {
    public static final int SOFTWAREVERSION = 1;
    public static String PLUGNAME = "Plug";
    public static final String PROP_PLUGIN_NAME = "prop_pluginname";
    public static final String PROP_PLUGIN_UNIVERSE = "prop_pluginuniverse";
    public static final String PROP_PLUGIN_BINDINDEX = "prop_bindindex";
    public static final String PROP_PLUGIN_PORTINDEX = "prop_portindex";
    public static final String PROP_PLUGIN_INDEX = "prop_pluginindex";
    public static final String PROP_PLUGIN_TYPE = "prop_plugintype";
    public static final String PROP_PLUGIN_PROTOCOLTYPE = "prop_pluginprotocoltype";
    public static final String PROP_PLUGIN_MERGEMODE = "prop_pluginmergemode";
    public static final String PROP_PLUGIN_INPUTDISABLED = "prop_plugininputenabled";
    public static final String PROP_PLUGIN_CONNECTIONSTATUS = "prop_pluginconnectionstatus";
    public static final int MERGEMODE_SINGLE = 0;
    public static final String MERGEMODE_SINGLE_String = "-";
    public static final int MERGEMODE_HTP = 1;
    public static final String MERGEMODE_HTP_String = "HTP";
    public static final int MERGEMODE_LTP = 2;
    public static final String MERGEMODE_LTP_String = "LTP";
    private String m_ID;
    private String m_Name;
    private LAN_Device m_LAN_Device;
    private int m_ProtocolType;
    private int m_BindIndex;
    private boolean m_IsVirtual;
    private int m_PlugInType;
    private int m_LANUniverseNumber;
    private int m_MergeMode;
    private LAN_Universe m_LAN_Universe;
    private int m_ConnectionStatus;
    private int m_MissedPolls_ArtNet;
    private PropertyChangeSupport m_PropertyChangeSupport;

    public LAN_PlugIn(LAN_Device p_LAN_Device) {
        this.m_LAN_Device = p_LAN_Device;
        this.initMembers();
        this.m_ProtocolType = p_LAN_Device.getProtocolType();
        this.m_Name = PLUGNAME + (this.m_LAN_Device.getLAN_PlugInCount() + 1);
        this.m_LAN_Device.addPropertyChangeListener(this);
    }

    private void initMembers() {
        this.m_ID = HardwareGUID.getUID();
        this.m_Name = "";
        this.m_BindIndex = 1;
        this.m_IsVirtual = false;
        this.m_PlugInType = 0;
        this.m_LANUniverseNumber = -1;
        this.m_ProtocolType = 0;
        this.m_MergeMode = 0;
        this.m_PropertyChangeSupport = new PropertyChangeSupport(this);
        this.m_ConnectionStatus = 2;
        this.m_MissedPolls_ArtNet = 0;
    }

    public void close() {
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        LAN_Universe o_LAN_Universe = this.m_LAN_Universe;
        if (o_LAN_Device != null) {
            o_LAN_Device.removePropertyChangeListener(this);
        }
        if (o_LAN_Universe != null) {
            this.m_LAN_Universe = null;
            o_LAN_Universe.removeLAN_PlugIn(this);
        }
        if (o_LAN_Device != null) {
            this.m_LAN_Device = null;
            o_LAN_Device.removeLAN_PlugIn(this);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_ID);
        out.writeUTF(this.m_Name);
        out.writeInt(0);
        out.writeInt(this.m_PlugInType);
        out.writeInt(this.m_ProtocolType);
        out.writeInt(this.m_LANUniverseNumber);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intOldLANUniverseNumber = this.m_LANUniverseNumber;
        int intOldPlugInType = this.m_PlugInType;
        int intSoftwareVersion = in.readInt();
        this.m_ID = in.readUTF();
        this.m_Name = in.readUTF();
        in.readInt();
        this.m_PlugInType = in.readInt();
        this.m_ProtocolType = in.readInt();
        this.m_LANUniverseNumber = in.readInt();
        this.checkLAN_Universe(intOldLANUniverseNumber, intOldPlugInType, this.m_LANUniverseNumber, this.m_PlugInType);
    }

    public String getID() {
        return this.m_ID;
    }

    public LAN_Device getLAN_Device() {
        return this.m_LAN_Device;
    }

    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        String oldValue = this.m_Name;
        this.m_Name = p_Name;
        if (this.m_LAN_Universe != null) {
            this.m_LAN_Universe.refreshToolTipText();
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_PLUGIN_NAME, oldValue, this.m_Name);
    }

    public String getName() {
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        int intPlugIndex = 0;
        if (o_LAN_Device != null && o_LAN_Device instanceof LAN_Device_ArtNet) {
            if (this.m_IsVirtual) {
                return "Virtual";
            }
            intPlugIndex = o_LAN_Device.getPlugInIndex(this);
            return PLUGNAME + String.valueOf(intPlugIndex + 1);
        }
        return this.m_Name;
    }

    public void setBindIndex(int p_BindIndex) {
        if (this.m_BindIndex == p_BindIndex) {
            return;
        }
        if (p_BindIndex <= 0) {
            p_BindIndex = 1;
        }
        int oldValue = this.m_BindIndex;
        this.m_BindIndex = p_BindIndex;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_PLUGIN_BINDINDEX, oldValue, this.m_BindIndex);
    }

    public void setIsVirtual(boolean p_IsVirtual) {
        this.m_IsVirtual = p_IsVirtual;
    }

    public boolean getIsVirtual() {
        return this.m_IsVirtual;
    }

    public int getPortIndex() {
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device == null) {
            return -1;
        }
        return o_LAN_Device.getPortIndex(this);
    }

    public int getBindIndex() {
        return this.m_BindIndex;
    }

    public int getPlugInIndex() {
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device == null) {
            return -1;
        }
        return o_LAN_Device.getPlugInIndex(this);
    }

    public void setPlugInType(int p_PlugInType) {
        if (this.m_PlugInType == p_PlugInType) {
            return;
        }
        int oldValue = this.m_PlugInType;
        this.m_PlugInType = p_PlugInType;
        this.checkLAN_Universe(this.m_LANUniverseNumber, oldValue, this.m_LANUniverseNumber, p_PlugInType);
        this.m_PropertyChangeSupport.firePropertyChange(PROP_PLUGIN_TYPE, oldValue, this.m_PlugInType);
    }

    public int getPlugInType() {
        return this.m_PlugInType;
    }

    public void setProtocolType(int p_ProtocolType) {
        if (this.m_ProtocolType == p_ProtocolType) {
            return;
        }
        int oldValue = this.m_ProtocolType;
        LAN_Universe o_LAN_Universe = this.m_LAN_Universe;
        this.m_ProtocolType = p_ProtocolType;
        if (o_LAN_Universe != null) {
            o_LAN_Universe.changedProtocol_LAN_Plugin(this, oldValue, this.m_PlugInType);
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_PLUGIN_PROTOCOLTYPE, oldValue, this.m_ProtocolType);
    }

    public int getProtocolType() {
        return this.m_ProtocolType;
    }

    public void setMergeMode(int p_MergeMode) {
        if (p_MergeMode == this.m_MergeMode) {
            return;
        }
        if (p_MergeMode != 1 && p_MergeMode != 2 && p_MergeMode != 0) {
            return;
        }
        int oldValue = this.m_MergeMode;
        this.m_MergeMode = p_MergeMode;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_PLUGIN_MERGEMODE, oldValue, this.m_MergeMode);
    }

    public int getMergeMode() {
        return this.m_MergeMode;
    }

    public String getMergeModeString() {
        switch (this.m_MergeMode) {
            case 0: {
                return MERGEMODE_SINGLE_String;
            }
            case 1: {
                return MERGEMODE_HTP_String;
            }
            case 2: {
                return MERGEMODE_LTP_String;
            }
        }
        return "";
    }

    public void setLanUniverseNumber(int p_UniverseNumber) {
        if (this.m_LANUniverseNumber == p_UniverseNumber) {
            return;
        }
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device == null) {
            return;
        }
        switch (o_LAN_Device.getProtocolType()) {
            case 3: {
                if (p_UniverseNumber <= 0) {
                    p_UniverseNumber = -1;
                    break;
                }
                if (p_UniverseNumber <= 65535) break;
                p_UniverseNumber = 65535;
                break;
            }
            case 1: {
                if (p_UniverseNumber < 0) {
                    p_UniverseNumber = 0;
                    break;
                }
                if (p_UniverseNumber <= Short.MAX_VALUE) break;
                p_UniverseNumber = Short.MAX_VALUE;
            }
        }
        int intOldLanUniverseNumber = this.m_LANUniverseNumber;
        this.m_LANUniverseNumber = p_UniverseNumber;
        this.checkLAN_Universe(intOldLanUniverseNumber, this.m_PlugInType, this.m_LANUniverseNumber, this.m_PlugInType);
        this.m_PropertyChangeSupport.firePropertyChange(PROP_PLUGIN_UNIVERSE, intOldLanUniverseNumber, this.m_LANUniverseNumber);
    }

    public int getLAN_UniverseNumber() {
        return this.m_LANUniverseNumber;
    }

    public LAN_Universe getLAN_Universe() {
        return this.m_LAN_Universe;
    }

    private void checkLAN_Universe(int p_OldLANUniverseNumber, int p_OldPlugInType, int p_LANUniverseNumber, int p_PlugInType) {
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device == null) {
            return;
        }
        LAN_Interface o_LAN_Interface = o_LAN_Device.getLAN_Interface();
        if (o_LAN_Device == null) {
            return;
        }
        if (p_OldLANUniverseNumber == p_LANUniverseNumber && p_OldPlugInType == p_PlugInType) {
            return;
        }
        LAN_Universe o_LAN_Universe = o_LAN_Interface.getLAN_Universe(p_OldLANUniverseNumber, p_OldPlugInType);
        if (o_LAN_Universe != null) {
            o_LAN_Universe.removeLAN_PlugIn(this);
            this.m_LAN_Universe = null;
        }
        if (p_LANUniverseNumber >= 0) {
            o_LAN_Universe = o_LAN_Interface.getLAN_Universe(p_LANUniverseNumber, p_PlugInType);
            if (o_LAN_Universe != null) {
                this.m_LAN_Universe = o_LAN_Universe;
                o_LAN_Universe.addLAN_PlugIn(this);
            } else {
                this.m_LAN_Universe = o_LAN_Universe = new LAN_Universe(o_LAN_Interface, this.m_LANUniverseNumber, this.m_PlugInType);
                o_LAN_Universe.addLAN_PlugIn(this);
                o_LAN_Interface.addLAN_Universe(o_LAN_Universe);
            }
        }
        if (this.m_LAN_Universe == null) {
            this.setConnectionStatus(2);
        }
    }

    public void setConnectionStatus(int p_ConnectionStatus) {
        LAN_Universe o_LAN_Universe;
        if (this.m_ConnectionStatus == p_ConnectionStatus) {
            return;
        }
        int oldValue = this.m_ConnectionStatus;
        this.m_ConnectionStatus = p_ConnectionStatus;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_PLUGIN_CONNECTIONSTATUS, oldValue, this.m_ConnectionStatus);
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device != null) {
            o_LAN_Device.refreshConnectionStatus();
        }
        if ((o_LAN_Universe = this.m_LAN_Universe) != null) {
            o_LAN_Universe.checkConnectionStatus();
        }
    }

    public int getConnectionStatus() {
        return this.m_ConnectionStatus;
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LAN_Universe o_LAN_Universe = this.m_LAN_Universe;
        if (evt.getSource() instanceof LAN_Device && o_LAN_Universe != null) {
            o_LAN_Universe.refreshToolTipText();
        }
    }

    public void increaseMissedPolls() {
        ++this.m_MissedPolls_ArtNet;
    }

    public void resetMissedPolls() {
        this.m_MissedPolls_ArtNet = 0;
    }

    public int getMissedPolls() {
        return this.m_MissedPolls_ArtNet;
    }

    public static class LAN_PlugInCellRenderer
    extends DefaultTableCellRenderer {
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        protected static Border selectedBorder = new LineBorder(Color.BLUE, 2);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            StringBuilder o_StringBuilder = new StringBuilder();
            LAN_PluginTableModel o_LAN_PluginTableModel = (LAN_PluginTableModel)((Object)table.getModel());
            int intRowModel = table.convertRowIndexToModel(row);
            LAN_PlugIn o_LAN_PlugIn = o_LAN_PluginTableModel.getLAN_PlugIn(intRowModel);
            JLabel o_JLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (o_LAN_PlugIn != null) {
                LAN_Universe o_LAN_Universe;
                if (o_LAN_PlugIn.getConnectionStatus() == 5) {
                    o_JLabel.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CHECKED);
                } else {
                    o_JLabel.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONNECTED);
                }
                o_StringBuilder.append("<html>");
                o_StringBuilder.append("<center>");
                if (o_LAN_PlugIn.getLAN_Device() != null) {
                    if (o_LAN_PlugIn.getLAN_Device() instanceof LAN_Device_ArtNet) {
                        int intBindIndex;
                        LAN_Device_ArtNet o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_PlugIn.getLAN_Device();
                        LAN_Device_ArtNet.BindIndexStructure o_BindIndexStructure = o_LAN_Device_ArtNet.getBindIndexStructure(intBindIndex = o_LAN_PlugIn.getLAN_Device().getBindIndex(o_LAN_PlugIn));
                        if (o_BindIndexStructure != null) {
                            o_StringBuilder.append("<b>");
                            o_StringBuilder.append(o_BindIndexStructure.getShortName());
                            o_StringBuilder.append("<br>");
                            o_StringBuilder.append("</b>");
                        }
                    } else {
                        o_StringBuilder.append("<b>");
                        o_StringBuilder.append(o_LAN_PlugIn.getLAN_Device().getName());
                        o_StringBuilder.append("<br>");
                        o_StringBuilder.append("</b>");
                    }
                }
                switch (o_LAN_PlugIn.getPlugInType()) {
                    case 1: {
                        o_StringBuilder.append("Input");
                        break;
                    }
                    case 0: {
                        o_StringBuilder.append("Output");
                        break;
                    }
                    default: {
                        o_StringBuilder.append("");
                    }
                }
                o_StringBuilder.append("<br>");
                o_StringBuilder.append(Protocols.getProtocolName((int)o_LAN_PlugIn.getProtocolType()));
                o_StringBuilder.append("<br>");
                o_StringBuilder.append(o_LAN_PlugIn.getName());
                o_StringBuilder.append(" (");
                o_StringBuilder.append(String.valueOf(o_LAN_PlugIn.getPlugInIndex() + 1));
                o_StringBuilder.append(")");
                if (o_LAN_PlugIn.getMergeMode() == 2 || o_LAN_PlugIn.getMergeMode() == 1) {
                    o_StringBuilder.append("<br>");
                    o_StringBuilder.append("Merge: ");
                    o_StringBuilder.append(o_LAN_PlugIn.getMergeModeString());
                }
                if ((o_LAN_Universe = o_LAN_PlugIn.getLAN_Universe()) != null) {
                    o_StringBuilder.append("<br>");
                    o_StringBuilder.append("<br>");
                    o_StringBuilder.append(o_LAN_Universe.getName());
                }
                o_StringBuilder.append("</center>");
                o_StringBuilder.append("</html>");
            }
            Border border = null;
            border = isSelected ? selectedBorder : noFocusBorder;
            o_JLabel.setBorder(border);
            o_JLabel.setToolTipText(o_StringBuilder.toString());
            return o_JLabel;
        }
    }

    public static class LAN_PluginTableModel
    extends TableAndListModel<LAN_PlugIn>
    implements PropertyChangeListener {
        public static final int COLUMNCOUNT = 5;
        public static final int COLUMNINDEX_PLUGINNAME = 0;
        public static final int COLUMNINDEX_PLUGININDEX = 1;
        public static final int COLUMNINDEX_PLUGINTYPE = 2;
        public static final int COLUMNINDEX_PLUGINUNIVERSE = 3;
        public static final int COLUMNINDEX_PLUGINPROTOCOL = 4;
        @LiveLanguageString
        public static String COLUMN_PLUGINNAME = "Name";
        @LiveLanguageString
        public static String COLUMN_PLUGININDEX = "Index";
        @LiveLanguageString
        public static String COLUMN_PLUGINTYPE = "Type";
        @LiveLanguageString
        public static String COLUMN_PLUGINUNIVERSE = "LAN Universe";
        @LiveLanguageString
        public static String COLUMN_PLUGINPROTOCOL = "";
        private TableAndListModel.ListModel<String> m_ListModelPlugInType;
        private JComboBox<String> m_JComboBoxPlugInType;
        private TableCellEditor m_TableCellEditorPlugInType;
        private DefaultTableCellRenderer m_DefaultTableCellRenderer;
        private final Object m_SyncObject = new Object();

        public LAN_PluginTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, (String)LAN_Interface_Configuration.class.getSimpleName());
        }

        private void initMembers() {
            this.m_ListModelPlugInType = new TableAndListModel.ListModel(false);
            this.m_ListModelPlugInType.add((Object)"Output");
            this.m_ListModelPlugInType.add((Object)"Input");
            this.m_JComboBoxPlugInType = new JComboBox();
            this.m_JComboBoxPlugInType.setModel((ComboBoxModel<String>)this.m_ListModelPlugInType.createListModelWrapper());
            this.m_TableCellEditorPlugInType = new DefaultCellEditor(this.m_JComboBoxPlugInType);
            this.m_JComboBoxPlugInType.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    m_JComboBoxPlugInType.setSelectedIndex(m_JComboBoxPlugInType.getSelectedIndex());
                }
            });
            this.m_DefaultTableCellRenderer = new LAN_PlugInCellRenderer();
        }

        public void finishJTable(JTable p_JTable) {
            if (p_JTable == null) {
                return;
            }
            TableRowSorter<LAN_PluginTableModel> o_TableRowSorter = new TableRowSorter<LAN_PluginTableModel>(this);
            o_TableRowSorter.setComparator(1, new StringComparator_NumericInteger());
            o_TableRowSorter.setComparator(3, new StringComparator_NumericInteger());
            super.finishJTable(p_JTable, o_TableRowSorter, null);
            p_JTable.getColumnModel().getColumn(2).setCellEditor(this.m_TableCellEditorPlugInType);
            p_JTable.getColumnModel().getColumn(0).setCellRenderer(this.m_DefaultTableCellRenderer);
            p_JTable.getColumnModel().getColumn(1).setCellRenderer(this.m_DefaultTableCellRenderer);
            p_JTable.getColumnModel().getColumn(2).setCellRenderer(this.m_DefaultTableCellRenderer);
            p_JTable.getColumnModel().getColumn(3).setCellRenderer(this.m_DefaultTableCellRenderer);
            p_JTable.getColumnModel().getColumn(4).setCellRenderer(this.m_DefaultTableCellRenderer);
            this.clearSelection(p_JTable);
        }

        public boolean contains(String p_ID) {
            if (p_ID == null) {
                return false;
            }
            LAN_PlugIn o_LAN_PlugIn = this.getLAN_PlugIn(p_ID);
            return o_LAN_PlugIn != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LAN_PlugIn getLAN_PlugIn(String p_ID) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intPlugIn = 0; intPlugIn < this.size(); ++intPlugIn) {
                    LAN_PlugIn o_LAN_PlugIn = (LAN_PlugIn)this.get(intPlugIn);
                    if (o_LAN_PlugIn == null || !p_ID.equals(o_LAN_PlugIn.getID())) continue;
                    return o_LAN_PlugIn;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLAN_PlugIn(LAN_PlugIn p_LAN_PlugIn) {
            if (p_LAN_PlugIn == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.add(p_LAN_PlugIn)) {
                    p_LAN_PlugIn.addPropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLAN_PlugIn(int p_Position, LAN_PlugIn p_LAN_PlugIn) {
            if (p_LAN_PlugIn == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.add(p_Position, p_LAN_PlugIn)) {
                    p_LAN_PlugIn.addPropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLAN_PlugIn(LAN_PlugIn p_LAN_PlugIn) {
            if (p_LAN_PlugIn == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.remove(p_LAN_PlugIn)) {
                    p_LAN_PlugIn.removePropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectedLAN_PlugIn(JTable p_JTable, LAN_PlugIn p_LAN_PlugIn) {
            if (p_JTable == null) {
                return;
            }
            if (p_LAN_PlugIn == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                super.addSelectedElement(p_JTable, (Object)p_LAN_PlugIn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectedLAN_PlugIn(JTable p_JTable, LAN_PlugIn p_LAN_PlugIn) {
            if (p_JTable == null) {
                return;
            }
            if (p_LAN_PlugIn == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                super.removeSelectedElement(p_JTable, (Object)p_LAN_PlugIn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LAN_PlugIn getLAN_PlugIn(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                return (LAN_PlugIn)this.get(p_Index);
            }
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_PLUGINNAME;
                }
                case 1: {
                    return COLUMN_PLUGININDEX;
                }
                case 2: {
                    return COLUMN_PLUGINTYPE;
                }
                case 3: {
                    return COLUMN_PLUGINUNIVERSE;
                }
                case 4: {
                    return COLUMN_PLUGINPROTOCOL;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(LAN_PlugIn p_LAN_PlugIn, int columnIndex) {
            String stringValue = "";
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_LAN_PlugIn == null) {
                    return stringValue;
                }
                block4 : switch (columnIndex) {
                    case 0: {
                        stringValue = p_LAN_PlugIn.getName();
                        break;
                    }
                    case 1: {
                        try {
                            int intPlugInIndex = p_LAN_PlugIn.getPlugInIndex();
                            if (intPlugInIndex < 0) {
                                return "";
                            }
                            stringValue = String.valueOf(intPlugInIndex + 1);
                        }
                        catch (Exception e) {
                            stringValue = "";
                        }
                        break;
                    }
                    case 2: {
                        switch (p_LAN_PlugIn.getPlugInType()) {
                            case 1: {
                                stringValue = "Input";
                                break block4;
                            }
                            case 0: {
                                stringValue = "Output";
                                break block4;
                            }
                        }
                        stringValue = "?";
                        break;
                    }
                    case 3: {
                        if (p_LAN_PlugIn.getLAN_UniverseNumber() <= 0) {
                            stringValue = "";
                            break;
                        }
                        try {
                            stringValue = String.valueOf(p_LAN_PlugIn.getLAN_UniverseNumber());
                        }
                        catch (Exception e) {
                            stringValue = "";
                        }
                        break;
                    }
                    case 4: {
                        stringValue = Protocols.getProtocolName((int)p_LAN_PlugIn.getProtocolType());
                        break;
                    }
                    default: {
                        stringValue = "";
                    }
                }
                return stringValue;
            }
        }

        public boolean isCellEditable(int row, int col) {
            LAN_PlugIn o_LAN_PlugIn = this.getLAN_PlugIn(row);
            if (o_LAN_PlugIn == null) {
                return false;
            }
            switch (col) {
                case 0: {
                    LAN_Device o_LAN_Device = o_LAN_PlugIn.getLAN_Device();
                    if (o_LAN_Device == null) {
                        return false;
                    }
                    return o_LAN_Device.getProtocolType() == 3;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    LAN_Device o_LAN_Device = o_LAN_PlugIn.getLAN_Device();
                    if (o_LAN_Device == null) {
                        return false;
                    }
                    return o_LAN_Device.getProtocolType() == 3;
                }
                case 3: {
                    LAN_Device o_LAN_Device = o_LAN_PlugIn.getLAN_Device();
                    if (o_LAN_Device == null) {
                        return false;
                    }
                    return o_LAN_Device.getProtocolType() == 3;
                }
                case 4: {
                    return false;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(LAN_PlugIn p_LAN_PlugIn, Object value, int col) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_LAN_PlugIn == null) {
                    return;
                }
            }
            switch (col) {
                case 0: {
                    String stringValue = (String)value;
                    if (stringValue == null) {
                        return;
                    }
                    p_LAN_PlugIn.setName(stringValue);
                    break;
                }
                case 1: {
                    return;
                }
                case 2: {
                    switch ((String)value) {
                        case "Output": {
                            p_LAN_PlugIn.setPlugInType(0);
                            break;
                        }
                        case "Input": {
                            p_LAN_PlugIn.setPlugInType(1);
                        }
                    }
                    return;
                }
                case 3: {
                    int intValue;
                    String stringValue = (String)value;
                    if (stringValue == null) {
                        return;
                    }
                    LAN_Device o_LAN_Device = p_LAN_PlugIn.getLAN_Device();
                    if (o_LAN_Device == null) {
                        return;
                    }
                    try {
                        intValue = Integer.valueOf(stringValue);
                    }
                    catch (Exception e) {
                        intValue = -1;
                    }
                    if (o_LAN_Device.getProtocolType() == 3 && intValue <= 0) {
                        intValue = -1;
                    }
                    p_LAN_PlugIn.setLanUniverseNumber(intValue);
                    break;
                }
                case 4: {
                    return;
                }
            }
            this.changedElement(p_LAN_PlugIn);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof LAN_PlugIn) {
                LAN_PlugIn o_LAN_PlugIn = (LAN_PlugIn)evt.getSource();
                if (LAN_PlugIn.PROP_PLUGIN_NAME.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_PlugIn);
                }
                if (LAN_PlugIn.PROP_PLUGIN_INDEX.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_PlugIn);
                }
                if (LAN_PlugIn.PROP_PLUGIN_TYPE.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_PlugIn);
                }
                if (LAN_PlugIn.PROP_PLUGIN_UNIVERSE.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_PlugIn);
                }
                if (LAN_PlugIn.PROP_PLUGIN_PROTOCOLTYPE.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_PlugIn);
                }
                if (LAN_PlugIn.PROP_PLUGIN_CONNECTIONSTATUS.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_PlugIn);
                }
                if (LAN_PlugIn.PROP_PLUGIN_CONNECTIONSTATUS.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_PlugIn);
                }
            }
        }

        public static class StringComparator_NumericInteger
        implements Comparator<String> {
            @Override
            public int compare(String o1, String o2) {
                Integer int2;
                Integer int1;
                if (o1 == null || o2 == null) {
                    return 0;
                }
                try {
                    int1 = Integer.valueOf(o1);
                    int2 = Integer.valueOf(o2);
                }
                catch (Exception e) {
                    return 0;
                }
                return int1.compareTo(int2);
            }
        }

        public static class StringComparator_Normal
        implements Comparator<String> {
            @Override
            public int compare(String o1, String o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return o1.compareToIgnoreCase(o2);
            }
        }
    }
}

