/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import DMXHardwarePackage.DMXHardwareInterface;
import DMXHardwarePackage.LAN_Interface;
import DMXHardwarePackage.LAN_Interface_Configuration;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import SwingModelPackage.TableAndListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class LAN_NetworkInterface {
    private LAN_Interface m_LAN_Interface;
    private NetworkInterface m_NetworkInterface;
    private int m_NetworkIndex;
    private String m_MacAddress;
    private ArrayList<InterfaceAddress> m_InterfaceAddresses;
    private ArrayList<InetAddress> m_InetAddresses;
    private ArrayList<InetAddress> m_InetAddresses_Broadcast;
    private ArrayList<Boolean> m_InetAddresses_Detected;
    private final Object m_SyncInetAddress = new Object();
    private boolean m_Selected;
    public static final String PROP_SELECTED = "propSelected";
    public static final String PROP_ADDRESSSIZE = "propAddressSize";
    private PropertyChangeSupport m_PropertyChangeSupport;
    private boolean m_Detected;

    public LAN_NetworkInterface(LAN_Interface p_LAN_Interface, NetworkInterface p_NetworkInterface) {
        this.m_LAN_Interface = p_LAN_Interface;
        this.initMembers();
        this.m_NetworkInterface = p_NetworkInterface;
        this.m_NetworkIndex = this.m_NetworkInterface.getIndex();
        this.m_MacAddress = this.calculateMacAddress();
    }

    private void initMembers() {
        this.m_NetworkInterface = null;
        this.m_InterfaceAddresses = new ArrayList();
        this.m_InetAddresses = new ArrayList();
        this.m_InetAddresses_Broadcast = new ArrayList();
        this.m_InetAddresses_Detected = new ArrayList();
        this.m_Selected = false;
        this.m_Detected = false;
        this.m_PropertyChangeSupport = new PropertyChangeSupport(this);
    }

    public void close() {
        this.m_LAN_Interface.removeLAN_NetworkInterface(this);
        this.m_NetworkInterface = null;
        this.m_InetAddresses.clear();
        this.m_InetAddresses_Broadcast.clear();
    }

    public void setSelected(boolean p_Selected) {
        if (this.m_Selected == p_Selected) {
            return;
        }
        boolean oldValue = this.m_Selected;
        this.m_Selected = p_Selected;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_SELECTED, oldValue, this.m_Selected);
        this.m_LAN_Interface.changeSelectedLAN_NetworkInterface(this);
    }

    public boolean getSelected() {
        return this.m_Selected;
    }

    public NetworkInterface getNetworkInterface() {
        return this.m_NetworkInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInetAddress(InetAddress p_InetAddress, InterfaceAddress p_InterfaceAddress) {
        int newValue;
        int oldValue;
        if (p_InterfaceAddress == null) {
            return false;
        }
        boolean boolChanged = false;
        int intIndex = this.m_InetAddresses.indexOf(p_InetAddress);
        if (intIndex >= 0) {
            this.m_InterfaceAddresses.set(intIndex, p_InterfaceAddress);
            if (!this.m_InetAddresses_Broadcast.get(intIndex).equals(p_InterfaceAddress.getBroadcast())) {
                boolChanged = true;
            }
            this.m_InetAddresses_Broadcast.set(intIndex, p_InterfaceAddress.getBroadcast());
            this.m_InetAddresses_Detected.set(intIndex, true);
            return boolChanged;
        }
        Object object = this.m_SyncInetAddress;
        synchronized (object) {
            oldValue = this.m_InetAddresses.size();
            this.m_InterfaceAddresses.add(p_InterfaceAddress);
            this.m_InetAddresses.add(p_InetAddress);
            this.m_InetAddresses_Broadcast.add(p_InterfaceAddress.getBroadcast());
            this.m_InetAddresses_Detected.add(true);
            newValue = this.m_InetAddresses.size();
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_ADDRESSSIZE, oldValue, newValue);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInetAddress(InetAddress p_InetAddress) {
        int intIndex;
        Object object = this.m_SyncInetAddress;
        synchronized (object) {
            intIndex = this.m_InetAddresses.indexOf(p_InetAddress);
        }
        this.removeInetAddress(intIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInetAddress(int intIndex) {
        int newValue;
        int oldValue;
        Object object = this.m_SyncInetAddress;
        synchronized (object) {
            if (intIndex < 0) {
                return;
            }
            if (intIndex >= this.m_InetAddresses.size()) {
                return;
            }
            oldValue = this.m_InetAddresses.size();
            this.m_InterfaceAddresses.remove(intIndex);
            this.m_InetAddresses.remove(intIndex);
            this.m_InetAddresses_Broadcast.remove(intIndex);
            this.m_InetAddresses_Detected.remove(intIndex);
            newValue = this.m_InetAddresses.size();
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_ADDRESSSIZE, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetected(InetAddress p_InetAddress) {
        Object object = this.m_SyncInetAddress;
        synchronized (object) {
            int intIndex = this.m_InetAddresses.indexOf(p_InetAddress);
            if (intIndex < 0) {
                return;
            }
            this.m_InetAddresses_Detected.set(intIndex, true);
        }
    }

    public int getInetAddressCount() {
        return this.m_InetAddresses.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceAddress getInterfaceAddress(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncInetAddress;
        synchronized (object) {
            if (p_Index >= this.m_InterfaceAddresses.size()) {
                return null;
            }
            return this.m_InterfaceAddresses.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getInetAddress(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncInetAddress;
        synchronized (object) {
            if (p_Index >= this.m_InetAddresses.size()) {
                return null;
            }
            return this.m_InetAddresses.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getInetAddressBroadcast(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncInetAddress;
        synchronized (object) {
            if (p_Index >= this.m_InetAddresses_Broadcast.size()) {
                return null;
            }
            return this.m_InetAddresses_Broadcast.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkNetworkStarted() {
        Object object = this.m_SyncInetAddress;
        synchronized (object) {
            for (int intIndex = 0; intIndex < this.m_InetAddresses_Detected.size(); ++intIndex) {
                this.m_InetAddresses_Detected.set(intIndex, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkNetworkEnded() {
        Object object = this.m_SyncInetAddress;
        synchronized (object) {
            for (int intIndex = this.m_InetAddresses_Detected.size() - 1; intIndex >= 0; --intIndex) {
                if (!this.m_InetAddresses_Detected.get(intIndex).booleanValue()) {
                    // empty if block
                }
                this.removeInetAddress(intIndex);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public void setDetected(boolean p_Detected) {
        this.m_Detected = p_Detected;
    }

    public boolean getDetected() {
        return this.m_Detected;
    }

    public String calculateMacAddress() {
        if (this.m_NetworkIndex < 0) {
            return "";
        }
        String stringMacAddress = "";
        String stringOS = System.getProperty("os.name").toLowerCase();
        boolean boolFoundMacLinux = false;
        if (stringOS.indexOf("mac") >= 0) {
            stringMacAddress = LAN_NetworkInterface.calculateMacAddress_MACOSX(this.m_NetworkIndex);
            if (stringMacAddress != null && stringMacAddress.length() == 17) {
                boolFoundMacLinux = true;
            }
        } else if ((stringOS.indexOf("nix") >= 0 || stringOS.indexOf("nux") >= 0) && (stringMacAddress = LAN_NetworkInterface.calculateMacAddress_LINUX(this.m_NetworkIndex)) != null && stringMacAddress.length() == 17) {
            boolFoundMacLinux = true;
        }
        if (boolFoundMacLinux) {
            return stringMacAddress;
        }
        return LAN_NetworkInterface.calculateMacAddressWindows(this.m_NetworkInterface);
    }

    public static String calculateMacAddressWindows(NetworkInterface p_NetworkInterface) {
        byte[] bytesHardwareAddress;
        if (p_NetworkInterface == null) {
            return "";
        }
        try {
            bytesHardwareAddress = p_NetworkInterface.getHardwareAddress();
        }
        catch (Exception e) {
            return "";
        }
        return LAN_NetworkInterface.calculateMacAddressWindows(bytesHardwareAddress);
    }

    public static String calculateMacAddressWindows(byte[] p_HardwareAddress) {
        if (p_HardwareAddress == null) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        for (int i = 0; i < p_HardwareAddress.length; ++i) {
            o_StringBuilder.append(String.format("%02X%s", p_HardwareAddress[i], i < p_HardwareAddress.length - 1 ? "-" : ""));
        }
        return o_StringBuilder.toString();
    }

    public static String calculateMacAddress_MACOSX(int p_InterfaceIndex) {
        if (p_InterfaceIndex < 0) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        try {
            Process o_Process = Runtime.getRuntime().exec("networksetup -getmacaddress en" + String.valueOf(p_InterfaceIndex));
            BufferedReader o_BufferedReader = new BufferedReader(new InputStreamReader(o_Process.getInputStream()));
            o_StringBuilder.delete(0, o_StringBuilder.length());
            int intChar = o_BufferedReader.read();
            while (intChar >= 0) {
                o_StringBuilder.append((char)intChar);
                intChar = o_BufferedReader.read();
            }
            String stringReaden = o_StringBuilder.toString();
            String[] o_StringsReaden = stringReaden.split(" ");
            if (o_StringsReaden.length < 3) {
                return "";
            }
            return o_StringsReaden[2].trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String calculateMacAddress_LINUX(int p_InterfaceIndex) {
        if (p_InterfaceIndex < 0) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        try {
            Process o_Process = Runtime.getRuntime().exec("ip link show dev eth" + String.valueOf(p_InterfaceIndex) + " | grep -oE 'link/ether ([a-f0-9]{2}:){5}[a-f0-9]{2}' | cut -d' ' f2");
            BufferedReader o_BufferedReader = new BufferedReader(new InputStreamReader(o_Process.getInputStream()));
            o_StringBuilder.delete(0, o_StringBuilder.length());
            int intChar = o_BufferedReader.read();
            while (intChar >= 0) {
                o_StringBuilder.append((char)intChar);
                intChar = o_BufferedReader.read();
            }
            String stringReaden = o_StringBuilder.toString();
            stringReaden = stringReaden.trim();
            return stringReaden;
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getMacAddress() {
        return this.m_MacAddress;
    }

    public static class LAN_NetworkInterfaceSelectedCellRenderer
    extends DefaultTableCellRenderer {
        private JCheckBox m_JCheckBox = new JCheckBox();

        public LAN_NetworkInterfaceSelectedCellRenderer() {
            this.m_JCheckBox.setText("");
            this.m_JCheckBox.setPreferredSize(new Dimension(25, 25));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int intRowModel;
            String stringToolTip = null;
            LAN_NetworkInterfaceTableModel o_LAN_NetworkInterfaceTableModel = (LAN_NetworkInterfaceTableModel)((Object)table.getModel());
            LAN_NetworkInterface o_LAN_NetworkInterface = o_LAN_NetworkInterfaceTableModel.getLAN_NetworkInterface(intRowModel = table.convertRowIndexToModel(row));
            if (o_LAN_NetworkInterface != null) {
                this.m_JCheckBox.setSelected(o_LAN_NetworkInterface.getSelected());
                NetworkInterface o_NetworkInterface = o_LAN_NetworkInterface.getNetworkInterface();
                if (o_NetworkInterface != null) {
                    stringToolTip = o_NetworkInterface.getDisplayName();
                }
            } else {
                this.m_JCheckBox.setSelected(false);
            }
            this.m_JCheckBox.setBackground(table.getBackground());
            this.m_JCheckBox.setForeground(table.getForeground());
            this.m_JCheckBox.setToolTipText(stringToolTip);
            return this.m_JCheckBox;
        }
    }

    public static class LAN_NetworkInterfaceCellRenderer
    extends DefaultTableCellRenderer {
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        protected static Border selectedBorder = new LineBorder(Color.BLUE, 1);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String stringToolTip = null;
            LAN_NetworkInterfaceTableModel o_LAN_NetworkInterfaceTableModel = (LAN_NetworkInterfaceTableModel)((Object)table.getModel());
            int intRowModel = table.convertRowIndexToModel(row);
            int intColumnModel = table.convertColumnIndexToModel(column);
            LAN_NetworkInterface o_LAN_NetworkInterface = o_LAN_NetworkInterfaceTableModel.getLAN_NetworkInterface(intRowModel);
            JLabel o_JLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (o_LAN_NetworkInterface != null) {
                if (o_LAN_NetworkInterface.getSelected()) {
                    o_JLabel.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CHECKED);
                } else {
                    o_JLabel.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONNECTED);
                }
                NetworkInterface o_NetworkInterface = o_LAN_NetworkInterface.getNetworkInterface();
                if (o_NetworkInterface != null) {
                    stringToolTip = o_NetworkInterface.getDisplayName();
                }
            }
            if (isSelected) {
                o_JLabel.setBorder(selectedBorder);
            } else {
                o_JLabel.setBorder(noFocusBorder);
            }
            o_JLabel.setHorizontalAlignment(0);
            o_JLabel.setToolTipText(stringToolTip);
            return o_JLabel;
        }
    }

    public static class LAN_NetworkInterfaceTableModel
    extends TableAndListModel<LAN_NetworkInterface>
    implements PropertyChangeListener {
        public static final int COLUMNCOUNT = 3;
        public static final int COLUMNINDEX_SELECTED = 0;
        public static final int COLUMNINDEX_NETWORKINTERFACE = 1;
        public static final int COLUMNINDEX_FIRSTIP = 2;
        @LiveLanguageString
        public static String COLUMN_SELECTED = "";
        @LiveLanguageString
        public static String COLUMN_NETWORKINTERFACE = "Network Interface";
        @LiveLanguageString
        public static String COLUMN_FIRSTIP = "IP";
        private DefaultTableCellRenderer m_DefaultTableCellRenderer;
        private DefaultTableCellRenderer m_SelectedTableCellRenderer;
        private DefaultCellEditor m_SelectTableCellEditor;
        private DefaultTableCellRenderer m_EnableArtNetTableCellRenderer;
        private DefaultCellEditor m_EnableArtNetTableCellEditor;
        private final Object m_SyncObject = new Object();

        public LAN_NetworkInterfaceTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, (String)LAN_Interface_Configuration.class.getSimpleName());
        }

        private void initMembers() {
            this.m_SelectTableCellEditor = new DefaultCellEditor(new JCheckBox());
            this.m_SelectedTableCellRenderer = new LAN_NetworkInterfaceSelectedCellRenderer();
            this.m_DefaultTableCellRenderer = new LAN_NetworkInterfaceCellRenderer();
        }

        public void finishJTable(JTable p_JTable) {
            if (p_JTable == null) {
                return;
            }
            TableRowSorter<LAN_NetworkInterfaceTableModel> o_TableRowSorter = new TableRowSorter<LAN_NetworkInterfaceTableModel>(this);
            o_TableRowSorter.setComparator(1, new StringComparator_Normal());
            super.finishJTable(p_JTable, o_TableRowSorter, null);
            for (int intColumn = 0; intColumn < 3; ++intColumn) {
                TableCellRenderer o_TableCellRenderer = this.getTableCellRenderer(intColumn);
                TableColumn o_TableColumn = p_JTable.getColumnModel().getColumn(intColumn);
                if (intColumn == 0) {
                    o_TableColumn.setMaxWidth(30);
                    o_TableColumn.setMinWidth(30);
                    o_TableColumn.setPreferredWidth(30);
                    o_TableColumn.setResizable(false);
                }
                if (intColumn == 1) {
                    o_TableColumn.setMaxWidth(100000);
                    o_TableColumn.setMinWidth(100);
                    o_TableColumn.setPreferredWidth(200);
                    o_TableColumn.setResizable(true);
                }
                if (intColumn != 2) continue;
                o_TableColumn.setMaxWidth(10000);
                o_TableColumn.setMinWidth(100);
                o_TableColumn.setPreferredWidth(200);
                o_TableColumn.setResizable(true);
            }
            p_JTable.getColumnModel().getColumn(0).setCellRenderer(this.m_SelectedTableCellRenderer);
            p_JTable.getColumnModel().getColumn(0).setCellEditor(this.m_SelectTableCellEditor);
            p_JTable.getColumnModel().getColumn(1).setCellRenderer(this.m_DefaultTableCellRenderer);
            p_JTable.getColumnModel().getColumn(2).setCellRenderer(this.m_DefaultTableCellRenderer);
        }

        public boolean contains(NetworkInterface p_NetworkInterface) {
            if (p_NetworkInterface == null) {
                return false;
            }
            LAN_NetworkInterface o_LAN_NetworkInterface = this.getLAN_NetworkInterface(p_NetworkInterface);
            return o_LAN_NetworkInterface != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LAN_NetworkInterface getLAN_NetworkInterface(NetworkInterface p_NetworkInterface) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intInterface = 0; intInterface < this.size(); ++intInterface) {
                    LAN_NetworkInterface o_LAN_NetworkInterface = (LAN_NetworkInterface)this.get(intInterface);
                    if (o_LAN_NetworkInterface == null || !p_NetworkInterface.equals(o_LAN_NetworkInterface.getNetworkInterface())) continue;
                    return o_LAN_NetworkInterface;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLAN_NetworkInterface(LAN_NetworkInterface p_LAN_NetworkInterface) {
            if (p_LAN_NetworkInterface == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.add(p_LAN_NetworkInterface)) {
                    p_LAN_NetworkInterface.addPropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLAN_NetworkInterface(LAN_NetworkInterface p_LAN_NetworkInterface) {
            if (p_LAN_NetworkInterface == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.remove(p_LAN_NetworkInterface)) {
                    p_LAN_NetworkInterface.removePropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectedLAN_NetworkInterface(JTable p_JTable, LAN_NetworkInterface p_LAN_NetworkInterface) {
            if (p_JTable == null) {
                return;
            }
            if (p_LAN_NetworkInterface == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                super.addSelectedElement(p_JTable, (Object)p_LAN_NetworkInterface);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectedLAN_NetworkInterface(JTable p_JTable, LAN_NetworkInterface p_LAN_NetworkInterface) {
            if (p_JTable == null) {
                return;
            }
            if (p_LAN_NetworkInterface == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                super.removeSelectedElement(p_JTable, (Object)p_LAN_NetworkInterface);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LAN_NetworkInterface getLAN_NetworkInterface(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                return (LAN_NetworkInterface)this.get(p_Index);
            }
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_SELECTED;
                }
                case 1: {
                    return COLUMN_NETWORKINTERFACE;
                }
                case 2: {
                    return COLUMN_FIRSTIP;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(LAN_NetworkInterface p_LAN_NetworkInterface, int columnIndex) {
            String stringValue = "";
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_LAN_NetworkInterface == null) {
                    return "";
                }
                switch (columnIndex) {
                    case 0: {
                        NetworkInterface o_NetworkInterface = p_LAN_NetworkInterface.getNetworkInterface();
                        if (o_NetworkInterface == null) {
                            return false;
                        }
                        return p_LAN_NetworkInterface.getSelected();
                    }
                    case 1: {
                        NetworkInterface o_NetworkInterface = p_LAN_NetworkInterface.getNetworkInterface();
                        if (o_NetworkInterface == null) {
                            stringValue = "";
                            break;
                        }
                        stringValue = o_NetworkInterface.getDisplayName();
                        break;
                    }
                    case 2: {
                        StringBuilder o_StringBuilder = new StringBuilder();
                        for (int intIndex = 0; intIndex < p_LAN_NetworkInterface.getInetAddressCount(); ++intIndex) {
                            InetAddress o_InetAddress = p_LAN_NetworkInterface.getInetAddress(intIndex);
                            if (o_InetAddress == null) continue;
                            if (intIndex > 0) {
                                o_StringBuilder.append(" - ");
                            }
                            o_StringBuilder.append(o_InetAddress.getHostAddress());
                        }
                        stringValue = o_StringBuilder.toString();
                    }
                }
                return stringValue;
            }
        }

        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            return false;
        }

        public TableCellRenderer getTableCellRenderer(int p_Column) {
            switch (p_Column) {
                case 0: {
                    return this.m_SelectedTableCellRenderer;
                }
                case 1: {
                    return this.m_DefaultTableCellRenderer;
                }
                case 2: {
                    return this.m_DefaultTableCellRenderer;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(LAN_NetworkInterface p_LAN_NetworkInterface, Object value, int col) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_LAN_NetworkInterface == null) {
                    return;
                }
            }
            switch (col) {
                case 0: {
                    p_LAN_NetworkInterface.setSelected((Boolean)value);
                    break;
                }
                case 1: {
                    break;
                }
            }
            this.changedElement(p_LAN_NetworkInterface);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof LAN_NetworkInterface) {
                LAN_NetworkInterface o_LAN_NetworkInterface = (LAN_NetworkInterface)evt.getSource();
                if (LAN_NetworkInterface.PROP_ADDRESSSIZE.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_NetworkInterface);
                } else if (LAN_NetworkInterface.PROP_SELECTED.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_NetworkInterface);
                }
            }
        }

        public static class StringComparator_NumericInteger
        implements Comparator<String> {
            @Override
            public int compare(String o1, String o2) {
                Integer int2;
                Integer int1;
                if (o1 == null || o2 == null) {
                    return 0;
                }
                try {
                    int1 = Integer.valueOf(o1);
                    int2 = Integer.valueOf(o2);
                }
                catch (Exception e) {
                    return 0;
                }
                return int1.compareTo(int2);
            }
        }

        public static class StringComparator_Normal
        implements Comparator<String> {
            @Override
            public int compare(String o1, String o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return o1.compareToIgnoreCase(o2);
            }
        }

        public static class BooleanComparator_Normal
        implements Comparator<Boolean> {
            @Override
            public int compare(Boolean o1, Boolean o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                if (o1 == o2) {
                    return 0;
                }
                if (o1.booleanValue()) {
                    return 1;
                }
                if (o2.booleanValue()) {
                    return -1;
                }
                return 0;
            }
        }
    }
}

