/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import DMXHardwarePackage.LAN_Interface_Configuration;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import SwingComponents.RobustTextPane;
import SwingToolTipPackage.PopUpToolTip;
import ToolPackage.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class LAN_Interface_Help
extends JFrame
implements HyperlinkListener,
WindowFocusListener {
    public static String HELPFILE_PATH = "Help";
    private ArrayList<URL> m_Urls;
    private int m_URLIndex;
    private Object m_ActualFocusObject;
    private Object m_NewFocusObject;
    private JButton jButton_Back;
    private JButton jButton_Next;
    private RobustTextPane jEditorPane_Help;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JPanel jPanel_Content;
    private JScrollPane jScrollPane2;

    public LAN_Interface_Help() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        this.refresh();
        this.refreshButtons();
    }

    private void initMembers() {
        this.m_ActualFocusObject = null;
        this.m_NewFocusObject = null;
        this.m_Urls = new ArrayList();
        this.m_URLIndex = -1;
    }

    private void initComponents() {
        this.jPanel_Content = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorPane_Help = new RobustTextPane();
        this.jButton_Back = new JButton();
        this.jButton_Next = new JButton();
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(300, 300));
        this.setPreferredSize(new Dimension(500, 600));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                LAN_Interface_Help.this.formComponentShown(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel_Content.setLayout(new GridBagLayout());
        this.jEditorPane_Help.setBackground(new Color(255, 255, 254));
        this.jEditorPane_Help.setFont(new Font("Times New Roman", 0, 14));
        this.jEditorPane_Help.setForeground(new Color(0, 0, 1));
        this.jScrollPane2.setViewportView(this.jEditorPane_Help);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jButton_Back.setIcon(new ImageIcon(this.getClass().getResource("/Image/Document_Back.png")));
        this.jButton_Back.setToolTipText("");
        this.jButton_Back.setContentAreaFilled(false);
        this.jButton_Back.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LAN_Interface_Help.this.jButton_BackActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_Back, gridBagConstraints);
        this.jButton_Next.setIcon(new ImageIcon(this.getClass().getResource("/Image/Document_Forward.png")));
        this.jButton_Next.setToolTipText("");
        this.jButton_Next.setContentAreaFilled(false);
        this.jButton_Next.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LAN_Interface_Help.this.jButton_NextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_Next, gridBagConstraints);
        this.jLabel_ResizeFrame1.setHorizontalAlignment(4);
        this.jLabel_ResizeFrame1.setToolTipText("");
        this.jLabel_ResizeFrame1.setVerticalAlignment(3);
        this.jLabel_ResizeFrame1.setIconTextGap(0);
        this.jLabel_ResizeFrame1.setMaximumSize(new Dimension(32, 32));
        this.jLabel_ResizeFrame1.setMinimumSize(new Dimension(32, 32));
        this.jLabel_ResizeFrame1.setPreferredSize(new Dimension(32, 32));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        this.jPanel_Content.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel_Content, gridBagConstraints);
        this.pack();
    }

    private void initComponentsFurther() {
        HTMLEditorKit o_HTMLEditorKit = new HTMLEditorKit();
        this.jEditorPane_Help.setEditorKit(o_HTMLEditorKit);
        this.jEditorPane_Help.setContentType("text/html");
        this.jEditorPane_Help.addHyperlinkListener(this);
        this.jLabel_ResizeFrame1.setContainer(this);
        this.jButton_Back.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_Next.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    public void setActualFocus(Object p_FocusObject) {
        this.m_NewFocusObject = p_FocusObject;
        if (this.isVisible()) {
            this.refresh();
        }
    }

    @Override
    public void windowGainedFocus(final WindowEvent e) {
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                LAN_Interface_Help.this.setActualFocus(e.getSource());
            }
        };
        EventQueue.invokeLater(o_Runnable);
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    private void formComponentShown(ComponentEvent evt) {
        this.refresh();
    }

    private void jButton_BackActionPerformed(ActionEvent evt) {
        if (this.m_URLIndex > 0 && this.m_URLIndex < this.m_Urls.size()) {
            --this.m_URLIndex;
            URL o_Url = this.m_Urls.get(this.m_URLIndex);
            this.setURL(o_Url, false);
        }
        this.refreshButtons();
    }

    private void jButton_NextActionPerformed(ActionEvent evt) {
        if (this.m_URLIndex < this.m_Urls.size() - 1 && this.m_URLIndex >= 0) {
            ++this.m_URLIndex;
            URL o_Url = this.m_Urls.get(this.m_URLIndex);
            this.setURL(o_Url, false);
        }
        this.refreshButtons();
    }

    private void refresh() {
        this.refreshContext();
    }

    private void refreshContext() {
        if (this.m_ActualFocusObject == this.m_NewFocusObject && this.m_NewFocusObject != null) {
            return;
        }
        if (this.m_NewFocusObject instanceof LAN_Interface_Help) {
            return;
        }
        String stringFileBaseName = null;
        if (this.m_NewFocusObject == null) {
            stringFileBaseName = "LAN_Interface_Configuration";
        } else if (this.m_NewFocusObject instanceof LAN_Interface_Configuration) {
            stringFileBaseName = "LAN_Interface_Configuration";
        }
        this.m_ActualFocusObject = this.m_NewFocusObject;
        if (stringFileBaseName == null) {
            return;
        }
        this.setFileBase(stringFileBaseName);
    }

    private void refreshButtons() {
        if (this.m_URLIndex > 0) {
            this.jButton_Back.setEnabled(true);
        } else {
            this.jButton_Back.setEnabled(false);
        }
        if (this.m_URLIndex < this.m_Urls.size() - 1) {
            this.jButton_Next.setEnabled(true);
        } else {
            this.jButton_Next.setEnabled(false);
        }
    }

    public void setFileBase(String p_FileBase) {
        String stringLanguage = LiveLanguage.getLanguage((Locale)LiveLanguage.getLocaleActual());
        File o_File = new File(HELPFILE_PATH + "/" + HELPFILE_PATH + "_" + stringLanguage + "/" + p_FileBase + ".html");
        if (!o_File.exists() && !(o_File = new File(HELPFILE_PATH + "/" + HELPFILE_PATH + "/" + p_FileBase + ".html")).exists()) {
            o_File = new File(HELPFILE_PATH + "/" + HELPFILE_PATH + "/_MainWindow.html");
        }
        try {
            URL o_Url = o_File.toURI().toURL();
            this.setURL(o_Url, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setURL(URL p_Url, boolean p_New) {
        URL o_Url = null;
        if (p_Url == null) {
            try {
                File o_File = new File("Help/_MainWindow.html");
                o_Url = o_File.toURI().toURL();
            }
            catch (Exception exception) {}
        } else {
            o_Url = p_Url;
        }
        if (o_Url == null) {
            return;
        }
        try {
            this.jEditorPane_Help.setEditable(false);
            this.jEditorPane_Help.setPage(o_Url);
            if (this.m_Urls.size() > 0) {
                if (this.m_Urls.get(this.m_Urls.size() - 1).equals(o_Url)) {
                    return;
                }
                if (p_New) {
                    for (int intUrl = this.m_Urls.size() - 1; intUrl > this.m_URLIndex; --intUrl) {
                        this.m_Urls.remove(intUrl);
                    }
                }
            }
            if (p_New) {
                this.m_Urls.add(o_Url);
                this.m_URLIndex = this.m_Urls.size() - 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.refreshButtons();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setURL(e.getURL(), true);
        }
    }
}

