/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import ArtNetPackage.ArtNet_Op;
import ArtNetPackage.ProtocolConfiguration_ArtNet;
import DMXHardwarePackage.ACNInterpreter;
import DMXHardwarePackage.ArtNetInterpreter;
import DMXHardwarePackage.DMXHardwareFeedbackInterface;
import DMXHardwarePackage.DMXHardwareInterface;
import DMXHardwarePackage.DMXHardwarePluginFeedbackInterface;
import DMXHardwarePackage.DMXHardwarePluginInterface;
import DMXHardwarePackage.LAN_Device;
import DMXHardwarePackage.LAN_Device_ArtNet;
import DMXHardwarePackage.LAN_Interface_Configuration;
import DMXHardwarePackage.LAN_Interface_Help;
import DMXHardwarePackage.LAN_NetworkInterface;
import DMXHardwarePackage.LAN_PlugIn;
import DMXHardwarePackage.LAN_Universe;
import GUIDPackage.HardwareGUID;
import HardwareTools.UUIDCreator;
import ProtocolPackage.Protocols;
import ProtocolTools.RefreshTimer;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class LAN_Interface
implements DMXHardwareInterface,
Protocols.ProtocolLANInterface,
PropertyChangeListener {
    public static int SOFTWAREVERSION = 1;
    public static ImageIcon s_IconInterface = new ImageIcon(LAN_Interface.class.getResource("/Image/Interface.gif"));
    public static ImageIcon s_IconLogo = new ImageIcon(LAN_Interface.class.getResource("/Image/Logo.gif"));
    public static LAN_Interface_Help s_LAN_Interface_Help = new LAN_Interface_Help();
    public static int s_OSFlag = -1;
    public static int s_OSARchitectureFlag = -1;
    public static final String PROP_NAME = "propName";
    public static final String PROP_USEARTNET = "propUseArtNet";
    public static final int CONNECTION_TYPE = 3;
    public static final int DEFAULT_TIMEOUT_SECONDS = 2;
    public static final int ADDRESS_FIRST = 0;
    public static final int ADDRESS_LAST = 511;
    private static final String DIVIDER_PARAM = ";";
    private static final String DIVIDER_LINE = "\n";
    public static int DEAFAULT_LOCALPORT = 0;
    private String m_ID;
    private String m_Name;
    public static int s_NetworkInterfaceRefreshTime = 5000;
    public LAN_NetworkInterface.LAN_NetworkInterfaceTableModel m_LAN_NetworkInterfaceTableModel;
    public RefreshTimer m_TimerRefresh_Network;
    public HashMap<String, Boolean> m_LAN_NetworkReadenSelected;
    private boolean m_UseArtNet;
    private LAN_Device.LAN_DeviceTableModel m_LAN_DeviceTableModel;
    private LAN_PlugIn.LAN_PluginTableModel m_LAN_PluginTableModel_Empty;
    private LAN_Universe.LAN_UniverseTableModel m_LAN_UniverseTableModel;
    public static int s_LAN_UniverseOutput_RefreshTime = 1000;
    public RefreshTimer m_TimerRefresh_UniverseOutput;
    private ArrayList<DMXHardwareFeedbackInterface> m_DMXHardwareFeedbackInterfaces;
    private UUID m_LocalUUID;
    private byte[] m_LocalUUIDBytes;
    private int m_ConnectionStatus;
    private boolean m_DebugOn;
    private boolean m_DebugFailureOn;
    private LAN_Interface_Configuration m_Hardware_Configuration;
    private ACNInterpreter m_ACNInterpreter;
    private ArtNetInterpreter m_ArtNetInterpreter;
    private HashMap<LAN_NetworkInterface, HashMap<InetAddress, Protocols.ProtocolConfiguration>> m_ArtNetProtocols;
    private ArrayList<InetAddress> m_ProblemInetAddresses = new ArrayList();
    private PropertyChangeSupport m_PropertyChangeSupport;
    private final Object m_SyncRequest = new Object();
    private final Object m_SyncHardwareFeedbackInterface = new Object();
    private final Object m_SyncLANInterface = new Object();

    public LAN_Interface() {
        this.initMembers();
        this.checkNetwork();
        this.m_TimerRefresh_Network.start();
        this.m_TimerRefresh_UniverseOutput.start();
    }

    private void initMembers() {
        this.m_ID = HardwareGUID.getUID();
        this.m_Name = LAN_Interface.getInterfaceNameSimple();
        this.m_UseArtNet = false;
        this.m_LocalUUID = UUID.randomUUID();
        this.m_LocalUUIDBytes = UUIDCreator.toBytes((UUID)this.m_LocalUUID);
        this.m_DMXHardwareFeedbackInterfaces = new ArrayList();
        this.m_LAN_NetworkReadenSelected = new HashMap();
        this.m_ConnectionStatus = 2;
        this.m_PropertyChangeSupport = new PropertyChangeSupport(this);
        this.m_LAN_DeviceTableModel = new LAN_Device.LAN_DeviceTableModel();
        this.m_LAN_PluginTableModel_Empty = new LAN_PlugIn.LAN_PluginTableModel();
        this.m_LAN_UniverseTableModel = new LAN_Universe.LAN_UniverseTableModel();
        this.m_TimerRefresh_UniverseOutput = new RefreshTimer(s_LAN_UniverseOutput_RefreshTime);
        RefreshTimer.RefreshTimer_Listener o_RefreshTimer_Listener_Output = new RefreshTimer.RefreshTimer_Listener(){

            public void eventRefreshTimer(RefreshTimer p_RefreshTimer) {
                for (int intUniverse = 0; intUniverse < LAN_Interface.this.m_LAN_UniverseTableModel.size(); ++intUniverse) {
                    LAN_Universe o_LAN_Universe = (LAN_Universe)LAN_Interface.this.m_LAN_UniverseTableModel.get(intUniverse);
                    if (o_LAN_Universe == null) continue;
                    o_LAN_Universe.refreshWriteValues_Output();
                }
            }
        };
        this.m_TimerRefresh_UniverseOutput.addRefreshTimerListener(o_RefreshTimer_Listener_Output);
        this.m_DebugOn = false;
        this.m_DebugFailureOn = false;
        this.m_ACNInterpreter = null;
        this.m_ArtNetInterpreter = null;
        this.m_ArtNetProtocols = new HashMap();
        this.m_ProblemInetAddresses = new ArrayList();
        this.m_LAN_NetworkInterfaceTableModel = new LAN_NetworkInterface.LAN_NetworkInterfaceTableModel();
        this.m_TimerRefresh_Network = new RefreshTimer(s_NetworkInterfaceRefreshTime);
        RefreshTimer.RefreshTimer_Listener o_RefreshTimer_Listener_Network = new RefreshTimer.RefreshTimer_Listener(){

            public void eventRefreshTimer(RefreshTimer p_RefreshTimer) {
                LAN_Interface.this.checkNetwork();
            }
        };
        this.m_TimerRefresh_Network.addRefreshTimerListener(o_RefreshTimer_Listener_Network);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.m_TimerRefresh_UniverseOutput != null) {
            this.m_TimerRefresh_UniverseOutput.stop();
        }
        if (this.m_TimerRefresh_Network != null) {
            this.m_TimerRefresh_Network.stop();
        }
        if (this.m_ArtNetInterpreter != null) {
            this.m_ArtNetInterpreter.stopArtNetPoll();
            this.m_ArtNetInterpreter.close();
        }
        if (this.m_ACNInterpreter != null) {
            this.m_ACNInterpreter.close();
        }
        this.disconnect();
        for (int intIndex = this.getLAN_NetworkInterfaceCount() - 1; intIndex >= 0; --intIndex) {
            LAN_NetworkInterface o_LAN_NetworkInterface = this.getLAN_NetworkInterface(intIndex);
            if (o_LAN_NetworkInterface == null) continue;
            o_LAN_NetworkInterface.close();
        }
        this.checkArtNetLANProtocols();
        for (int intIndex = this.getLAN_DeviceCount() - 1; intIndex >= 0; --intIndex) {
            LAN_Device o_LAN_Device = this.getLAN_Device(intIndex);
            if (o_LAN_Device == null) continue;
            o_LAN_Device.close();
        }
        for (int intUniverse = this.getLAN_UniverseCount() - 1; intUniverse >= 0; --intUniverse) {
            LAN_Universe o_LAN_Universe = this.getLAN_Universe(intUniverse);
            if (o_LAN_Universe == null) continue;
            o_LAN_Universe.close();
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces != null) {
                this.m_DMXHardwareFeedbackInterfaces.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(SOFTWAREVERSION);
        ArrayList<LAN_Device> o_SACNDevices = new ArrayList<LAN_Device>();
        ArrayList<LAN_Device> o_ARTNETDevices = new ArrayList<LAN_Device>();
        ArrayList<LAN_Universe> o_PluggedUniverses = new ArrayList<LAN_Universe>();
        ArrayList<LAN_NetworkInterface> o_LAN_NetworkInterfaces = new ArrayList<LAN_NetworkInterface>();
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            LAN_NetworkInterface o_LAN_NetworkInterface;
            int intNetwork;
            LAN_Device o_LAN_Device;
            int intDevice;
            LAN_Universe o_LAN_Universe;
            int intUniverse;
            for (intUniverse = 0; intUniverse < this.m_LAN_UniverseTableModel.size(); ++intUniverse) {
                o_LAN_Universe = this.m_LAN_UniverseTableModel.getLAN_Universe(intUniverse);
                if (o_LAN_Universe == null || o_LAN_Universe.getDMXHardwarePluginFeedbackInterface() == null) continue;
                o_PluggedUniverses.add(o_LAN_Universe);
            }
            for (intDevice = 0; intDevice < this.m_LAN_DeviceTableModel.size(); ++intDevice) {
                o_LAN_Device = this.m_LAN_DeviceTableModel.getLAN_Device(intDevice);
                if (o_LAN_Device == null || o_LAN_Device.getProtocolType() != 3) continue;
                o_SACNDevices.add(o_LAN_Device);
            }
            for (intDevice = 0; intDevice < this.m_LAN_DeviceTableModel.size(); ++intDevice) {
                o_LAN_Device = this.m_LAN_DeviceTableModel.getLAN_Device(intDevice);
                if (o_LAN_Device == null || o_LAN_Device.getProtocolType() != 1) continue;
                o_ARTNETDevices.add(o_LAN_Device);
            }
            for (intNetwork = 0; intNetwork < this.m_LAN_NetworkInterfaceTableModel.size(); ++intNetwork) {
                o_LAN_NetworkInterface = this.m_LAN_NetworkInterfaceTableModel.getLAN_NetworkInterface(intNetwork);
                if (o_LAN_NetworkInterface == null) continue;
                o_LAN_NetworkInterfaces.add(o_LAN_NetworkInterface);
            }
            out.writeUTF(this.m_Name);
            out.writeBoolean(this.m_UseArtNet);
            out.writeInt(o_LAN_NetworkInterfaces.size());
            for (intNetwork = 0; intNetwork < o_LAN_NetworkInterfaces.size(); ++intNetwork) {
                o_LAN_NetworkInterface = (LAN_NetworkInterface)o_LAN_NetworkInterfaces.get(intNetwork);
                out.writeUTF(o_LAN_NetworkInterface.getMacAddress());
                out.writeBoolean(o_LAN_NetworkInterface.getSelected());
            }
            out.writeInt(o_PluggedUniverses.size());
            for (intUniverse = 0; intUniverse < o_PluggedUniverses.size(); ++intUniverse) {
                o_LAN_Universe = (LAN_Universe)o_PluggedUniverses.get(intUniverse);
                o_LAN_Universe.writeExternal(out);
            }
            out.writeInt(o_SACNDevices.size());
            for (intDevice = 0; intDevice < o_SACNDevices.size(); ++intDevice) {
                o_LAN_Device = (LAN_Device)o_SACNDevices.get(intDevice);
                o_LAN_Device.writeExternal(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        String stringName = in.readUTF();
        boolean boolUseArtNet = in.readBoolean();
        this.setName(stringName);
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            Boolean boolNetworkSelected;
            int intNetwork;
            this.m_LAN_NetworkReadenSelected.clear();
            int intNetworkCount = in.readInt();
            for (intNetwork = 0; intNetwork < intNetworkCount; ++intNetwork) {
                String stringMacAddress = in.readUTF();
                boolNetworkSelected = in.readBoolean();
                this.m_LAN_NetworkReadenSelected.put(stringMacAddress, boolNetworkSelected);
            }
            for (intNetwork = 0; intNetwork < this.getLAN_NetworkInterfaceCount(); ++intNetwork) {
                LAN_NetworkInterface o_LAN_NetworkInterface = this.getLAN_NetworkInterface(intNetwork);
                if (o_LAN_NetworkInterface == null) continue;
                boolNetworkSelected = this.m_LAN_NetworkReadenSelected.get(o_LAN_NetworkInterface.getMacAddress());
                if (boolNetworkSelected != null) {
                    o_LAN_NetworkInterface.setSelected(boolNetworkSelected);
                    continue;
                }
                o_LAN_NetworkInterface.setSelected(false);
            }
        }
        int intUniversCount = in.readInt();
        for (int intUniverse = 0; intUniverse < intUniversCount; ++intUniverse) {
            LAN_Universe o_LAN_UniverseNew = new LAN_Universe(this);
            o_LAN_UniverseNew.readExternal(in);
            LAN_Universe o_LAN_UniverseExist = this.getLAN_Universe(o_LAN_UniverseNew.getUniverseNumber(), o_LAN_UniverseNew.getDMXPluginType());
            if (o_LAN_UniverseExist != null) {
                o_LAN_UniverseNew.close();
                continue;
            }
            this.addLAN_Universe(o_LAN_UniverseNew);
        }
        int intDeviceCount = in.readInt();
        for (int intDevice = 0; intDevice < intDeviceCount; ++intDevice) {
            LAN_Device o_LAN_DeviceNew = new LAN_Device(this);
            o_LAN_DeviceNew.readExternal(in);
            LAN_Device o_LAN_DeviceExist = this.getLAN_Device(o_LAN_DeviceNew.getID());
            if (o_LAN_DeviceExist != null) {
                o_LAN_DeviceNew.close();
                continue;
            }
            this.addLAN_Device(o_LAN_DeviceNew);
        }
        this.setUseArtNet(boolUseArtNet);
        this.checkConnectionStatus();
    }

    public boolean getUseArtNet() {
        return this.m_UseArtNet;
    }

    public void setUseArtNet(boolean p_UseArtNet) {
        if (this.m_UseArtNet == p_UseArtNet) {
            return;
        }
        boolean oldValue = this.m_UseArtNet;
        this.m_UseArtNet = p_UseArtNet;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_USEARTNET, oldValue, this.m_UseArtNet);
        if (!this.m_UseArtNet) {
            this.closeArtNetProtocolsInternal();
        } else {
            this.checkArtNetLANProtocols();
        }
    }

    public ArtNetInterpreter getArtNetInterpreter() {
        if (this.m_ArtNetInterpreter == null) {
            this.m_ArtNetInterpreter = new ArtNetInterpreter(this);
        }
        return this.m_ArtNetInterpreter;
    }

    public ACNInterpreter getACNInterpreter() {
        if (this.m_ACNInterpreter == null) {
            this.m_ACNInterpreter = new ACNInterpreter(this);
        }
        return this.m_ACNInterpreter;
    }

    public String getID() {
        return this.m_ID;
    }

    public void setID(String p_ID) {
        this.m_ID = p_ID == null ? HardwareGUID.getUID() : p_ID;
    }

    public byte[] getLocalUUID() {
        return this.m_LocalUUIDBytes;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String p_Name) {
        if (p_Name == null || p_Name.length() <= 0) {
            this.m_Name = LAN_Interface.getInterfaceNameSimple();
            return;
        }
        if (p_Name.equals(this.m_Name)) {
            return;
        }
        Object o_DMXHardwareFeedbackInterfaces = null;
        String oldValue = this.m_Name;
        this.m_Name = p_Name;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_NAME, oldValue, this.m_Name);
        this.requestHardwareInfo();
    }

    public String getSourceName() {
        return "liveSHOWsoftware";
    }

    public ImageIcon getIconInterface() {
        return s_IconInterface;
    }

    public ImageIcon getIconLogo() {
        return s_IconLogo;
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public LAN_Device createLAN_Device(int p_ProtocolType) {
        LAN_Device o_LAN_Device = new LAN_Device(this, p_ProtocolType);
        this.addLAN_Device(o_LAN_Device);
        return o_LAN_Device;
    }

    public LAN_PlugIn createLAN_Plugin(LAN_Device p_LAN_Device) {
        if (p_LAN_Device == null) {
            return null;
        }
        return p_LAN_Device.createLAN_Plugin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLAN_Device(LAN_Device p_LAN_Device) {
        if (p_LAN_Device == null) {
            return;
        }
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            this.m_LAN_DeviceTableModel.addLAN_Device(p_LAN_Device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLAN_Device(LAN_Device p_LAN_Device) {
        if (p_LAN_Device == null) {
            return;
        }
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            this.m_LAN_DeviceTableModel.removeLAN_Device(p_LAN_Device);
        }
    }

    public int getLAN_DeviceCount() {
        if (this.m_LAN_DeviceTableModel == null) {
            return 0;
        }
        return this.m_LAN_DeviceTableModel.size();
    }

    public LAN_Device getLAN_Device(int p_Index) {
        if (this.m_LAN_DeviceTableModel == null) {
            return null;
        }
        return this.m_LAN_DeviceTableModel.getLAN_Device(p_Index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LAN_Device getLAN_Device(String p_ID) {
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_LAN_DeviceTableModel == null) {
                return null;
            }
            return this.m_LAN_DeviceTableModel.getLAN_Device(p_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LAN_Device_ArtNet> getLAN_Devices_ArtNet_ByIP(String p_IPAddress, ArrayList<LAN_Device_ArtNet> p_LAN_Devices) {
        if (p_LAN_Devices == null) {
            p_LAN_Devices = new ArrayList();
        }
        p_LAN_Devices.clear();
        if (p_IPAddress == null) {
            return p_LAN_Devices;
        }
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_LAN_DeviceTableModel == null) {
                return p_LAN_Devices;
            }
            int intDeviceCount = this.m_LAN_DeviceTableModel.size();
            for (int intDevice = 0; intDevice < intDeviceCount; ++intDevice) {
                LAN_Device_ArtNet o_LAN_Device_ArtNet;
                LAN_Device o_LAN_Device = this.m_LAN_DeviceTableModel.getLAN_Device(intDevice);
                if (o_LAN_Device == null || !(o_LAN_Device instanceof LAN_Device_ArtNet) || !p_IPAddress.equals((o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device).getRemoteIP())) continue;
                p_LAN_Devices.add((LAN_Device_ArtNet)o_LAN_Device);
            }
        }
        return p_LAN_Devices;
    }

    public LAN_Device_ArtNet getLAN_Device_ArtNet_ByIP(String p_IPAddress) {
        ArrayList<LAN_Device_ArtNet> o_LANDevices_ArtNet = this.getLAN_Devices_ArtNet_ByIP(p_IPAddress, null);
        if (o_LANDevices_ArtNet == null || o_LANDevices_ArtNet.size() <= 0) {
            return null;
        }
        return o_LANDevices_ArtNet.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LAN_Device> getLAN_Devices_ArtNet_ByMAC(String p_MACAddress, ArrayList<LAN_Device> p_LAN_Devices) {
        if (p_LAN_Devices == null) {
            p_LAN_Devices = new ArrayList();
        }
        p_LAN_Devices.clear();
        if (p_MACAddress == null) {
            return p_LAN_Devices;
        }
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_LAN_DeviceTableModel == null) {
                return p_LAN_Devices;
            }
            int intDeviceCount = this.m_LAN_DeviceTableModel.size();
            for (int intDevice = 0; intDevice < intDeviceCount; ++intDevice) {
                LAN_Device_ArtNet o_LAN_Device_ArtNet;
                LAN_Device o_LAN_Device = this.m_LAN_DeviceTableModel.getLAN_Device(intDevice);
                if (o_LAN_Device == null || !(o_LAN_Device instanceof LAN_Device_ArtNet) || !p_MACAddress.equals((o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device).getMacAddress())) continue;
                p_LAN_Devices.add(o_LAN_Device);
            }
        }
        return p_LAN_Devices;
    }

    public LAN_Device.LAN_DeviceTableModel getLAN_DeviceTableModel() {
        return this.m_LAN_DeviceTableModel;
    }

    public void setSelectedLAN_Device(JTable p_JTable, LAN_Device p_LAN_Device) {
        if (p_JTable == null) {
            return;
        }
        if (p_LAN_Device == null) {
            p_JTable.clearSelection();
            return;
        }
        this.m_LAN_DeviceTableModel.addSelectedLAN_Device(p_JTable, p_LAN_Device);
    }

    public LAN_PlugIn.LAN_PluginTableModel getLAN_PluginTableModel_Empty() {
        return this.m_LAN_PluginTableModel_Empty;
    }

    public void setSelectedLAN_PlugIn(JTable p_JTable, LAN_Device p_LAN_Device, LAN_PlugIn p_LAN_PlugIn) {
        if (p_JTable == null) {
            return;
        }
        if (p_LAN_Device == null) {
            p_JTable.clearSelection();
            return;
        }
        if (p_LAN_PlugIn == null) {
            p_JTable.clearSelection();
            return;
        }
        LAN_PlugIn.LAN_PluginTableModel o_TableModel = p_LAN_Device.getLAN_PluginTableModel();
        if (o_TableModel == null) {
            p_JTable.clearSelection();
        }
        o_TableModel.addSelectedLAN_PlugIn(p_JTable, p_LAN_PlugIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLAN_Universe(LAN_Universe p_LAN_Universe) {
        if (p_LAN_Universe == null) {
            return;
        }
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_LAN_UniverseTableModel == null) {
                return;
            }
            if (this.m_LAN_UniverseTableModel.contains(p_LAN_Universe)) {
                return;
            }
            this.m_LAN_UniverseTableModel.addLAN_Universe(p_LAN_Universe);
        }
        this.fireHardwareInterfacePluginAdded(p_LAN_Universe);
        this.checkConnectionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLAN_Universe(LAN_Universe p_LAN_Universe) {
        if (p_LAN_Universe == null) {
            return;
        }
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_LAN_UniverseTableModel == null) {
                return;
            }
            if (!this.m_LAN_UniverseTableModel.contains(p_LAN_Universe)) {
                return;
            }
            this.m_LAN_UniverseTableModel.removeLAN_Universe(p_LAN_Universe);
        }
        this.fireHardwareInterfacePluginRemoved(p_LAN_Universe);
        this.checkConnectionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLAN_UniverseCount() {
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_LAN_UniverseTableModel == null) {
                return 0;
            }
            return this.m_LAN_UniverseTableModel.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LAN_Universe getLAN_Universe(int p_Index) {
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_LAN_UniverseTableModel == null) {
                return null;
            }
            return this.m_LAN_UniverseTableModel.getLAN_Universe(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LAN_Universe getLAN_Universe(int p_LanUniverseNumber, int p_PlugInType) {
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_LAN_UniverseTableModel == null) {
                return null;
            }
            String stringKey = LAN_Universe.calculateKey(p_LanUniverseNumber, p_PlugInType);
            return this.m_LAN_UniverseTableModel.getLAN_Universe(stringKey);
        }
    }

    public LAN_Universe.LAN_UniverseTableModel getLAN_UniverseTableModel() {
        return this.m_LAN_UniverseTableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXHardwarePluginInterface getDMXHardwarePlugin(int p_Index) {
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_LAN_UniverseTableModel == null) {
                return null;
            }
            return this.m_LAN_UniverseTableModel.getLAN_Universe(p_Index);
        }
    }

    public DMXHardwarePluginInterface getDMXHardwarePlugin_Output(int p_LANUniverseNumber) {
        LAN_Universe o_LAN_Universe = this.getLAN_Universe(p_LANUniverseNumber, 0);
        return o_LAN_Universe;
    }

    public DMXHardwarePluginInterface getDMXHardwarePlugin_Input(int p_LANUniverseNumber) {
        LAN_Universe o_LAN_Universe = this.getLAN_Universe(p_LANUniverseNumber, 1);
        return o_LAN_Universe;
    }

    public void showConfigurationDialog(Frame p_Frame) {
        if (this.m_Hardware_Configuration == null) {
            this.m_Hardware_Configuration = new LAN_Interface_Configuration(p_Frame, false, this);
        }
        this.m_Hardware_Configuration.setVisible(true);
    }

    public void closeConfigurationDialog() {
        if (this.m_Hardware_Configuration != null) {
            this.m_Hardware_Configuration.setVisible(false);
        }
    }

    public void setConfigurationDialog(LAN_Interface_Configuration p_LAN_Interface_Configuration) {
        this.m_Hardware_Configuration = p_LAN_Interface_Configuration;
    }

    public static String getInterfaceNameSimple() {
        return "ArtNet - sACN";
    }

    public String getInterfaceName() {
        return "<html><b>" + this.m_Name + "</b></html>";
    }

    public static String staticInterfaceName() {
        return "<html><b>" + LAN_Interface.getInterfaceNameSimple() + "</b></html>";
    }

    public String getInterfaceDescription() {
        return "<html>LAN Interface supports ArtNet and sACN (ACN E1.31)<br>Usabel for ArtNet and sACN Hardware</html>";
    }

    public int getInterfaceVersionGroup() {
        return 1;
    }

    public String getManufacturerName() {
        return LAN_Interface.staticManufacturerName();
    }

    public static String staticManufacturerName() {
        return "ArtNet - sACN";
    }

    public String getManufacturerAddress() {
        return "<html><b>liveSHOWsoftware/b><br>www.liveshowsoftware.de<br></html>";
    }

    public String getManufacturerHomepage() {
        return "<html>www.liveshowsoftware.de</html>";
    }

    public int getConnectionType() {
        return 3;
    }

    public int getAddressCount() {
        return 512;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDMXHardwareFeedbackInterface(DMXHardwareFeedbackInterface p_DMXHardwareFeedbackInterface) {
        if (p_DMXHardwareFeedbackInterface == null) {
            return;
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.contains(p_DMXHardwareFeedbackInterface)) {
                return;
            }
            this.m_DMXHardwareFeedbackInterfaces.add(p_DMXHardwareFeedbackInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDMXHardwareFeedbackInterface(DMXHardwareFeedbackInterface p_DMXHardwareFeedbackInterface) {
        if (p_DMXHardwareFeedbackInterface == null) {
            return;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            boolRemoved = this.m_DMXHardwareFeedbackInterfaces.remove(p_DMXHardwareFeedbackInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDMXPluginCount() {
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_LAN_UniverseTableModel == null) {
                return 0;
            }
            return this.m_LAN_UniverseTableModel.size();
        }
    }

    public String getDMXPluginInfo(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        LAN_Universe o_LAN_Universe = (LAN_Universe)p_DMXHardwarePluginInterface;
        if (o_LAN_Universe == null) {
            return "";
        }
        return o_LAN_Universe.getDMXPluginInfo();
    }

    public int getDMXPluginType(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        LAN_Universe o_LAN_Universe = (LAN_Universe)p_DMXHardwarePluginInterface;
        if (o_LAN_Universe == null) {
            return -1;
        }
        return o_LAN_Universe.getDMXPluginType();
    }

    public boolean changeDMXPluginType(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_DMXPlugInType) {
        if (p_DMXPlugInType != -1 && p_DMXPlugInType != 1 && p_DMXPlugInType != 0) {
            return false;
        }
        LAN_Universe o_LAN_Universe = (LAN_Universe)p_DMXHardwarePluginInterface;
        if (o_LAN_Universe == null) {
            return false;
        }
        return o_LAN_Universe.setDMXPluginType(p_DMXPlugInType);
    }

    public DMXHardwarePluginFeedbackInterface getDMXPluggedInUniverse(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return null;
        }
        LAN_Universe o_LAN_Universe = (LAN_Universe)p_DMXHardwarePluginInterface;
        if (o_LAN_Universe == null) {
            return null;
        }
        return o_LAN_Universe.getDMXHardwarePluginFeedbackInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestDMXPlugConnection(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, DMXHardwarePluginFeedbackInterface p_DMXUniverseFeedbackInterface) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
        LAN_Universe o_LAN_Universe;
        Object object = this.m_SyncRequest;
        synchronized (object) {
            Object object2 = this.m_SyncLANInterface;
            synchronized (object2) {
                o_LAN_Universe = (LAN_Universe)p_DMXHardwarePluginInterface;
                if (o_LAN_Universe == null) {
                    return false;
                }
                o_DMXUniverseFeedbackInterface = o_LAN_Universe.getDMXHardwarePluginFeedbackInterface();
                if (o_DMXUniverseFeedbackInterface == p_DMXUniverseFeedbackInterface) {
                    return true;
                }
            }
        }
        o_LAN_Universe.requestDMXPlugConnection(p_DMXUniverseFeedbackInterface);
        this.fireHardwareInterfacePlugStatus(p_DMXHardwarePluginInterface, o_DMXUniverseFeedbackInterface, o_LAN_Universe.getDMXHardwarePluginFeedbackInterface());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePlugStatus(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, DMXHardwarePluginFeedbackInterface p_OldDMXUniverseFeedbackInterface, DMXHardwarePluginFeedbackInterface p_NewDMXUniverseFeedbackInterface) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwarePlugin((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, p_OldDMXUniverseFeedbackInterface, p_NewDMXUniverseFeedbackInterface);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    public int[] getDMXPluginValues(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        LAN_Universe o_LAN_Universe = (LAN_Universe)p_DMXHardwarePluginInterface;
        if (o_LAN_Universe == null) {
            return null;
        }
        return o_LAN_Universe.getDMXPluginValues();
    }

    public void setDebugOn(boolean p_DebugOn) {
        this.m_DebugOn = p_DebugOn;
    }

    public void setDebugFailureOn(boolean p_DebugOn) {
        this.m_DebugFailureOn = p_DebugOn;
    }

    public boolean connect(String p_ConnectionParam) {
        return true;
    }

    public boolean disconnect() {
        this.disconnectSACN();
        this.disconnectArtNet();
        this.checkConnectionStatus();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectSACN() {
        LAN_Universe o_LAN_Universe;
        int intUniverse;
        ArrayList<LAN_Universe> o_LAN_Universes;
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_LAN_UniverseTableModel == null) {
                return;
            }
            o_LAN_Universes = new ArrayList<LAN_Universe>(this.m_LAN_UniverseTableModel.size());
            for (intUniverse = 0; intUniverse < this.m_LAN_UniverseTableModel.size(); ++intUniverse) {
                o_LAN_Universe = this.m_LAN_UniverseTableModel.getLAN_Universe(intUniverse);
                if (o_LAN_Universe == null) continue;
                o_LAN_Universes.add(o_LAN_Universe);
            }
        }
        object = this.m_SyncRequest;
        synchronized (object) {
            for (intUniverse = 0; intUniverse < o_LAN_Universes.size(); ++intUniverse) {
                o_LAN_Universe = (LAN_Universe)o_LAN_Universes.get(intUniverse);
                o_LAN_Universe.disconnect();
            }
        }
        o_LAN_Universes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectArtNet() {
        ProtocolConfiguration_ArtNet o_ProtocolConfiguration_ArtNet;
        ArrayList<ProtocolConfiguration_ArtNet> o_ProtocolConfiguration_ArtNets;
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_ArtNetProtocols == null) {
                return;
            }
            o_ProtocolConfiguration_ArtNets = new ArrayList<ProtocolConfiguration_ArtNet>(this.m_ArtNetProtocols.size());
            for (int intNetwork = 0; intNetwork < this.getLAN_NetworkInterfaceCount(); ++intNetwork) {
                HashMap<InetAddress, Protocols.ProtocolConfiguration> o_ProtocolConfigurations;
                LAN_NetworkInterface o_LAN_NetworkInterface = this.getLAN_NetworkInterface(intNetwork);
                if (o_LAN_NetworkInterface == null || (o_ProtocolConfigurations = this.m_ArtNetProtocols.get(o_LAN_NetworkInterface)) == null) continue;
                for (InetAddress o_InetAddress : o_ProtocolConfigurations.keySet()) {
                    o_ProtocolConfiguration_ArtNet = (ProtocolConfiguration_ArtNet)o_ProtocolConfigurations.get(o_InetAddress);
                    if (o_ProtocolConfiguration_ArtNet == null) continue;
                    o_ProtocolConfiguration_ArtNets.add(o_ProtocolConfiguration_ArtNet);
                }
            }
        }
        object = this.m_SyncRequest;
        synchronized (object) {
            for (int intArtNet = 0; intArtNet < o_ProtocolConfiguration_ArtNets.size(); ++intArtNet) {
                o_ProtocolConfiguration_ArtNet = (ProtocolConfiguration_ArtNet)o_ProtocolConfiguration_ArtNets.get(intArtNet);
                if (o_ProtocolConfiguration_ArtNet == null) continue;
                o_ProtocolConfiguration_ArtNet.disconnect();
            }
        }
    }

    public int getConnectionStatus() {
        return this.m_ConnectionStatus;
    }

    public int getConnectionStatus(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        LAN_Universe o_LAN_Universe = (LAN_Universe)p_DMXHardwarePluginInterface;
        if (o_LAN_Universe == null) {
            return 2;
        }
        return o_LAN_Universe.getConnectionStatus();
    }

    public String getConnectionParameters() {
        StringBuilder stringParams = new StringBuilder();
        return stringParams.toString();
    }

    public void command_RebootHardware() {
        if (this.m_ConnectionStatus != 5) {
            return;
        }
        this.disconnect();
        if (this.connect("")) {
            this.requestCheckHardware();
        }
    }

    public boolean requestCheckHardware() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCheckConnectionFailed(int p_ExceptionType, String p_Remark) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        if (this.m_DebugOn || this.m_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " fireCheckConnectionFailed -> disconnect: " + p_Remark);
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareCheck((DMXHardwareInterface)this, false, p_Remark);
            o_DMXHardwareFeedbackInterface.eventHardwareException((DMXHardwareInterface)this, 910, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCheckConnectionSuccess() {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareCheck((DMXHardwareInterface)this, true, "");
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        if (this.m_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " fireCheckConnectionSuccess");
        }
    }

    public boolean requestHardwareInfo() {
        if (this.m_DebugOn) {
            System.out.println("LAN_Interface requestHardwareInfo");
        }
        StringBuilder stringHardwareInfo = new StringBuilder();
        stringHardwareInfo.append("<html>");
        stringHardwareInfo.append(this.getInterfaceName());
        stringHardwareInfo.append("</html>");
        this.fireHardwareInfoSuccess(stringHardwareInfo.toString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHardwareInfoFailed(int p_ExceptionType, String p_Remark) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        if (this.m_DebugOn || this.m_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " fireHardwareInfoFailed -> disconnect");
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareException((DMXHardwareInterface)this, p_ExceptionType, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHardwareInfoSuccess(String p_Info) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareInfo((DMXHardwareInterface)this, p_Info);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    public boolean requestWriteValues(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, ArrayList<Integer> p_ChangedAddresses, int[] p_AllValues) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWriteValuesFailed(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ExceptionType, String p_Remark) {
        if (this.m_DebugOn || this.m_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " LAN_Universe: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireWriteValuesFailed: " + p_Remark);
        }
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface);
        Object object = this.m_SyncRequest;
        synchronized (object) {
            if (o_DMXUniverseFeedbackInterface == null) {
                return;
            }
        }
        o_DMXUniverseFeedbackInterface.eventPluginException((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, p_ExceptionType, p_Remark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWriteValuesSuccess(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int[] p_AllInterfaceValues) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface);
        Object object = this.m_SyncRequest;
        synchronized (object) {
            if (o_DMXUniverseFeedbackInterface == null) {
                return;
            }
        }
        o_DMXUniverseFeedbackInterface.eventPluginWriteValues((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, p_AllInterfaceValues);
        if (this.m_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " DMXOutput: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireWriteValuesSuccess");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestReadValues(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, ArrayList<Integer> p_ChangedAddresses) {
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        int intAddressCount = p_ChangedAddresses.size();
        if (intAddressCount <= 0) {
            return true;
        }
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface);
        Object object = this.m_SyncRequest;
        synchronized (object) {
            if (o_DMXUniverseFeedbackInterface == null) {
                return false;
            }
        }
        this.fireReadValuesSucces(p_DMXHardwarePluginInterface, p_DMXHardwarePluginInterface.getDMXPluginValues());
        return true;
    }

    public void eventValuesReceived(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int[] p_ArrayValues) {
        this.fireReadValuesSucces(p_DMXHardwarePluginInterface, p_ArrayValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireReadValuesFailed(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ExceptionType, String p_Remark) {
        if (this.m_DebugOn || this.m_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " DMXPlugin: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireReadValuesFailed -> disconnect");
        }
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface);
        Object object = this.m_SyncRequest;
        synchronized (object) {
            if (o_DMXUniverseFeedbackInterface == null) {
                return;
            }
        }
        o_DMXUniverseFeedbackInterface.eventPluginException((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, p_ExceptionType, p_Remark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireReadValuesSucces(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int[] p_ArrayValues) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface);
        Object object = this.m_SyncRequest;
        synchronized (object) {
            if (o_DMXUniverseFeedbackInterface == null) {
                return;
            }
        }
        o_DMXUniverseFeedbackInterface.eventPluginReadValues((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, p_ArrayValues);
        if (this.m_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " DMXPlugin: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireReadValuesSuccess");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHardwareInterfaceConnectionStatus(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ConnectionStatus, String p_Remark) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareConnectionStatus((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, p_ConnectionStatus, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHardwareInterfacePlugStatus(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, DMXHardwarePluginFeedbackInterface p_OldDMXUniverseFeedbackInterface, DMXHardwarePluginFeedbackInterface p_NewDMXUniverseFeedbackInterface) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwarePlugin((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, p_OldDMXUniverseFeedbackInterface, p_NewDMXUniverseFeedbackInterface);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHardwareInterfacePluginAdded(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwarePluginAdded((DMXHardwareInterface)this, p_DMXHardwarePluginInterface);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHardwareInterfacePluginRemoved(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwarePluginRemoved((DMXHardwareInterface)this, p_DMXHardwarePluginInterface);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHardwareInterfacePluginChanged(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwarePluginChanged((DMXHardwareInterface)this, p_DMXHardwarePluginInterface);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireException(int p_ExceptionType, String p_Remark) {
        LAN_Universe o_LAN_Universe;
        ArrayList<LAN_Universe> o_LAN_Universes;
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareException((DMXHardwareInterface)this, p_ExceptionType, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        Object object2 = this.m_SyncLANInterface;
        synchronized (object2) {
            if (this.m_LAN_DeviceTableModel == null) {
                return;
            }
            o_LAN_Universes = new ArrayList<LAN_Universe>(this.m_LAN_UniverseTableModel.size());
            for (int intUniverse = 0; intUniverse < this.m_LAN_UniverseTableModel.size(); ++intUniverse) {
                o_LAN_Universe = this.m_LAN_UniverseTableModel.getLAN_Universe(intUniverse);
                if (o_LAN_Universe == null) continue;
                o_LAN_Universes.add(o_LAN_Universe);
            }
        }
        for (int intPlugin = 0; intPlugin < o_LAN_Universes.size(); ++intPlugin) {
            o_LAN_Universe = (LAN_Universe)o_LAN_Universes.get(intPlugin);
            DMXHardwarePluginFeedbackInterface o_DMXHardwarePluginFeedbackInterface = o_LAN_Universe.getDMXHardwarePluginFeedbackInterface();
            if (o_DMXHardwarePluginFeedbackInterface == null) continue;
            o_DMXHardwarePluginFeedbackInterface.eventPluginException((DMXHardwareInterface)this, (DMXHardwarePluginInterface)o_LAN_Universe, p_ExceptionType, p_Remark);
        }
        o_LAN_Universes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkNetwork() {
        LAN_NetworkInterface o_LAN_NetworkInterface = null;
        for (int intLAN_NezworkInterface = 0; intLAN_NezworkInterface < this.getLAN_NetworkInterfaceCount(); ++intLAN_NezworkInterface) {
            o_LAN_NetworkInterface = this.getLAN_NetworkInterface(intLAN_NezworkInterface);
            if (o_LAN_NetworkInterface == null) continue;
            o_LAN_NetworkInterface.setDetected(false);
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface o_NetworkInterface : Collections.list(interfaces)) {
                boolean boolNew = false;
                boolean boolChanged = false;
                if (o_NetworkInterface.isLoopback()) continue;
                try {
                    if (!o_NetworkInterface.isUp()) {
                    }
                }
                catch (Exception e) {}
                continue;
                Object e = this.m_SyncLANInterface;
                synchronized (e) {
                    o_LAN_NetworkInterface = this.getLAN_NetworkInterface(o_NetworkInterface);
                }
                List<InterfaceAddress> o_InterfaceAddresses = o_NetworkInterface.getInterfaceAddresses();
                for (int intInterfaceAddress = 0; intInterfaceAddress < o_InterfaceAddresses.size(); ++intInterfaceAddress) {
                    InetAddress o_InetAddress;
                    InterfaceAddress o_InterfaceAddress = o_InterfaceAddresses.get(intInterfaceAddress);
                    if (o_InterfaceAddress == null || (o_InetAddress = o_InterfaceAddress.getAddress()) == null || o_InetAddress instanceof Inet6Address || !(o_InetAddress instanceof Inet4Address)) continue;
                    if (o_LAN_NetworkInterface == null) {
                        boolNew = true;
                        o_LAN_NetworkInterface = new LAN_NetworkInterface(this, o_NetworkInterface);
                    }
                    o_LAN_NetworkInterface.setDetected(true);
                    if (!o_LAN_NetworkInterface.addInetAddress(o_InetAddress, o_InterfaceAddress)) continue;
                    boolChanged = true;
                }
                if (boolNew) {
                    Boolean boolWasSelected;
                    this.addLAN_NetworkInterface(o_LAN_NetworkInterface);
                    Object object = this.m_SyncLANInterface;
                    synchronized (object) {
                        boolWasSelected = this.m_LAN_NetworkReadenSelected.get(o_LAN_NetworkInterface.getMacAddress());
                    }
                    if (boolWasSelected != null && boolWasSelected.booleanValue()) {
                        o_LAN_NetworkInterface.setSelected(true);
                    }
                    this.checkArtNetLANProtocols();
                } else if (boolChanged) {
                    this.checkArtNetLANProtocols();
                }
                if (o_LAN_NetworkInterface == null) continue;
            }
        }
        catch (Exception interfaces) {
            // empty catch block
        }
        for (int intLAN_NetworkInterface = this.getLAN_NetworkInterfaceCount() - 1; intLAN_NetworkInterface >= 0; --intLAN_NetworkInterface) {
            o_LAN_NetworkInterface = this.getLAN_NetworkInterface(intLAN_NetworkInterface);
            if (o_LAN_NetworkInterface == null || o_LAN_NetworkInterface.getDetected()) continue;
            o_LAN_NetworkInterface.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LAN_NetworkInterface getLAN_NetworkInterface(NetworkInterface p_NetworkInterface) {
        if (p_NetworkInterface == null) {
            return null;
        }
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            return this.m_LAN_NetworkInterfaceTableModel.getLAN_NetworkInterface(p_NetworkInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLAN_NetworkInterface(LAN_NetworkInterface p_LAN_NetworkInterface) {
        if (p_LAN_NetworkInterface == null) {
            return false;
        }
        boolean boolAdded = false;
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (!this.m_LAN_NetworkInterfaceTableModel.contains(p_LAN_NetworkInterface)) {
                boolAdded = true;
            }
        }
        if (boolAdded) {
            this.m_LAN_NetworkInterfaceTableModel.addLAN_NetworkInterface(p_LAN_NetworkInterface);
            HashMap<InetAddress, Object> o_ProtocolConfigurations = this.m_ArtNetProtocols.get(p_LAN_NetworkInterface);
            if (o_ProtocolConfigurations == null) {
                o_ProtocolConfigurations = new HashMap();
                this.m_ArtNetProtocols.put(p_LAN_NetworkInterface, o_ProtocolConfigurations);
            }
            for (int intLAN_Universe = 0; intLAN_Universe < this.m_LAN_UniverseTableModel.size(); ++intLAN_Universe) {
                LAN_Universe o_LAN_Universe = this.m_LAN_UniverseTableModel.getLAN_Universe(intLAN_Universe);
                if (o_LAN_Universe == null) continue;
                o_LAN_Universe.addLAN_NetworkInterface(p_LAN_NetworkInterface);
            }
            p_LAN_NetworkInterface.addPropertyChangeListener(this);
        }
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLAN_NetworkInterface(LAN_NetworkInterface p_LAN_NetworkInterface) {
        if (p_LAN_NetworkInterface == null) {
            return false;
        }
        boolean boolFound = false;
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_LAN_NetworkInterfaceTableModel.contains(p_LAN_NetworkInterface)) {
                boolFound = true;
            }
        }
        if (boolFound) {
            HashMap<InetAddress, Protocols.ProtocolConfiguration> o_ProtocolConfigurations;
            p_LAN_NetworkInterface.removePropertyChangeListener(this);
            this.m_LAN_NetworkInterfaceTableModel.removeLAN_NetworkInterface(p_LAN_NetworkInterface);
            for (int intLAN_Universe = 0; intLAN_Universe < this.m_LAN_UniverseTableModel.size(); ++intLAN_Universe) {
                LAN_Universe o_LAN_Universe = this.m_LAN_UniverseTableModel.getLAN_Universe(intLAN_Universe);
                if (o_LAN_Universe == null) continue;
                o_LAN_Universe.removeLAN_NetworkInterface(p_LAN_NetworkInterface);
            }
            Object object2 = this.m_SyncLANInterface;
            synchronized (object2) {
                o_ProtocolConfigurations = this.m_ArtNetProtocols.get(p_LAN_NetworkInterface);
            }
            if (o_ProtocolConfigurations != null) {
                Iterator<InetAddress> o_Iterator = o_ProtocolConfigurations.keySet().iterator();
                while (o_Iterator.hasNext()) {
                    InetAddress o_INetAddress = o_Iterator.next();
                    ProtocolConfiguration_ArtNet o_ProtocolConfiguration_ArtNet = (ProtocolConfiguration_ArtNet)o_ProtocolConfigurations.get(o_INetAddress);
                    if (o_ProtocolConfiguration_ArtNet == null) continue;
                    o_Iterator.remove();
                    o_ProtocolConfiguration_ArtNet.close();
                }
                Object object3 = this.m_SyncLANInterface;
                synchronized (object3) {
                    this.m_ArtNetProtocols.remove(p_LAN_NetworkInterface);
                }
            }
        }
        return boolFound;
    }

    public void changeSelectedLAN_NetworkInterface(LAN_NetworkInterface p_LAN_NetworkInterface) {
        if (p_LAN_NetworkInterface == null) {
            return;
        }
        if (p_LAN_NetworkInterface.getSelected()) {
            this.m_LAN_NetworkReadenSelected.put(p_LAN_NetworkInterface.getMacAddress(), true);
        } else {
            this.m_LAN_NetworkReadenSelected.remove(p_LAN_NetworkInterface.getMacAddress());
        }
        for (int intLAN_Universe = 0; intLAN_Universe < this.m_LAN_UniverseTableModel.size(); ++intLAN_Universe) {
            LAN_Universe o_LAN_Universe = this.m_LAN_UniverseTableModel.getLAN_Universe(intLAN_Universe);
            if (o_LAN_Universe == null) continue;
            if (p_LAN_NetworkInterface.getSelected()) {
                o_LAN_Universe.addLAN_NetworkInterface(p_LAN_NetworkInterface);
                continue;
            }
            o_LAN_Universe.removeLAN_NetworkInterface(p_LAN_NetworkInterface);
        }
        this.checkArtNetLANProtocols();
    }

    public LAN_NetworkInterface.LAN_NetworkInterfaceTableModel getLAN_NetworkInterfaceTableModel() {
        if (this.m_LAN_NetworkInterfaceTableModel == null) {
            this.m_LAN_NetworkInterfaceTableModel = new LAN_NetworkInterface.LAN_NetworkInterfaceTableModel();
        }
        return this.m_LAN_NetworkInterfaceTableModel;
    }

    public int getLAN_NetworkInterfaceCount() {
        if (this.m_LAN_NetworkInterfaceTableModel == null) {
            return 0;
        }
        return this.m_LAN_NetworkInterfaceTableModel.size();
    }

    public LAN_NetworkInterface getLAN_NetworkInterface(int p_Index) {
        if (this.m_LAN_NetworkInterfaceTableModel == null) {
            return null;
        }
        return this.m_LAN_NetworkInterfaceTableModel.getLAN_NetworkInterface(p_Index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeArtNetProtocolsInternal() {
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            for (LAN_NetworkInterface o_LAN_NetworkInterface : this.m_ArtNetProtocols.keySet()) {
                HashMap<InetAddress, Protocols.ProtocolConfiguration> o_ProtocolConfigurations = this.m_ArtNetProtocols.get(o_LAN_NetworkInterface);
                if (o_ProtocolConfigurations == null || o_ProtocolConfigurations.size() <= 0) continue;
                Iterator<InetAddress> o_IteratorProtocolConfigurations = o_ProtocolConfigurations.keySet().iterator();
                while (o_IteratorProtocolConfigurations.hasNext()) {
                    InetAddress o_InetAddress = o_IteratorProtocolConfigurations.next();
                    ProtocolConfiguration_ArtNet o_ProtocolConfiguration_ArtNet = (ProtocolConfiguration_ArtNet)o_ProtocolConfigurations.get(o_InetAddress);
                    o_IteratorProtocolConfigurations.remove();
                    if (o_ProtocolConfiguration_ArtNet == null) continue;
                    o_ProtocolConfiguration_ArtNet.close();
                }
            }
        }
        for (int intIndex = this.getLAN_DeviceCount() - 1; intIndex >= 0; --intIndex) {
            LAN_Device o_LAN_Device = this.getLAN_Device(intIndex);
            if (o_LAN_Device == null || o_LAN_Device.getProtocolType() != 1) continue;
            o_LAN_Device.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkArtNetLANProtocols() {
        boolean boolCheckedSome;
        boolean boolProtocolConfigurationsFound;
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_ArtNetProtocols == null) {
                return;
            }
            if (!this.m_UseArtNet) {
                return;
            }
            boolProtocolConfigurationsFound = false;
            boolean boolCheckedAll = true;
            boolCheckedSome = false;
            for (int intNetwork = 0; intNetwork < this.getLAN_NetworkInterfaceCount(); ++intNetwork) {
                ProtocolConfiguration_ArtNet o_ProtocolConfiguration_ArtNet;
                InetAddress o_InetAddress;
                HashMap<InetAddress, Protocols.ProtocolConfiguration> o_ProtocolConfigurations;
                LAN_NetworkInterface o_LAN_NetworkInterface = this.getLAN_NetworkInterface(intNetwork);
                if (o_LAN_NetworkInterface == null || (o_ProtocolConfigurations = this.m_ArtNetProtocols.get(o_LAN_NetworkInterface)) == null) continue;
                Iterator<InetAddress> o_IteratorInetAddress = o_ProtocolConfigurations.keySet().iterator();
                while (o_IteratorInetAddress.hasNext()) {
                    o_InetAddress = o_IteratorInetAddress.next();
                    o_ProtocolConfiguration_ArtNet = (ProtocolConfiguration_ArtNet)o_ProtocolConfigurations.get(o_InetAddress);
                    if (o_ProtocolConfiguration_ArtNet == null) {
                        o_IteratorInetAddress.remove();
                    }
                    o_ProtocolConfiguration_ArtNet.setDetected(false);
                }
                for (int intIndex = 0; intIndex < o_LAN_NetworkInterface.getInetAddressCount(); ++intIndex) {
                    InterfaceAddress o_InterfaceAddress = o_LAN_NetworkInterface.getInterfaceAddress(intIndex);
                    o_InetAddress = o_LAN_NetworkInterface.getInetAddress(intIndex);
                    o_ProtocolConfiguration_ArtNet = (ProtocolConfiguration_ArtNet)o_ProtocolConfigurations.get(o_InetAddress);
                    if (o_LAN_NetworkInterface.getSelected()) {
                        if (o_ProtocolConfiguration_ArtNet == null) {
                            o_ProtocolConfiguration_ArtNet = new ProtocolConfiguration_ArtNet((Protocols.ProtocolLANInterface)this);
                            o_ProtocolConfiguration_ArtNet.setArtNetInterpreter((ProtocolConfiguration_ArtNet.ArtNetInterpreter)this.getArtNetInterpreter());
                            o_ProtocolConfigurations.put(o_InetAddress, (Protocols.ProtocolConfiguration)o_ProtocolConfiguration_ArtNet);
                        }
                        o_ProtocolConfiguration_ArtNet.setDetected(true);
                        if (o_ProtocolConfiguration_ArtNet.setInetAddress_ArtNet(o_LAN_NetworkInterface.getNetworkInterface(), o_InterfaceAddress) != 5) {
                            boolCheckedAll = false;
                        } else {
                            boolCheckedSome = true;
                        }
                        boolProtocolConfigurationsFound = true;
                        continue;
                    }
                    if (o_ProtocolConfiguration_ArtNet == null) continue;
                    o_ProtocolConfigurations.remove(o_InetAddress);
                    o_ProtocolConfiguration_ArtNet.close();
                }
                o_IteratorInetAddress = o_ProtocolConfigurations.keySet().iterator();
                while (o_IteratorInetAddress.hasNext()) {
                    o_InetAddress = o_IteratorInetAddress.next();
                    o_ProtocolConfiguration_ArtNet = (ProtocolConfiguration_ArtNet)o_ProtocolConfigurations.get(o_InetAddress);
                    if (o_ProtocolConfiguration_ArtNet == null) {
                        o_IteratorInetAddress.remove();
                    }
                    if (o_ProtocolConfiguration_ArtNet.getDetected()) continue;
                    o_IteratorInetAddress.remove();
                    o_ProtocolConfiguration_ArtNet.close();
                }
            }
        }
        if (!boolProtocolConfigurationsFound) {
            if (this.m_ArtNetInterpreter != null && !boolCheckedSome) {
                // empty if block
            }
        } else if (this.m_ArtNetInterpreter != null && boolCheckedSome) {
            this.m_ArtNetInterpreter.startArtNetPoll();
        }
        this.checkConnectionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProblemInetAddress(InetAddress p_InetAddress) {
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.m_ProblemInetAddresses.contains(p_InetAddress)) {
                return;
            }
            this.m_ProblemInetAddresses.add(p_InetAddress);
        }
        if (this.m_Hardware_Configuration != null) {
            this.m_Hardware_Configuration.refreshGUI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProblemInetAddress(InetAddress p_InetAddress) {
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (!this.m_ProblemInetAddresses.remove(p_InetAddress)) {
                return;
            }
        }
        if (this.m_Hardware_Configuration != null) {
            this.m_Hardware_Configuration.refreshGUI();
        }
    }

    public int getProblemInetAddressCount() {
        return this.m_ProblemInetAddresses.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getProblemInetAddress(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (p_Index >= this.m_ProblemInetAddresses.size()) {
                return null;
            }
            return this.m_ProblemInetAddresses.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConnectionStatus() {
        int intConnectionStatus;
        boolean boolAllChecked = true;
        boolean boolNoneChecked = true;
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            if (this.getLAN_UniverseCount() <= 0) {
                intConnectionStatus = 2;
            } else {
                intConnectionStatus = 5;
                for (int intUniverse = 0; intUniverse < this.getLAN_UniverseCount(); ++intUniverse) {
                    LAN_Universe o_LAN_Universe = this.getLAN_Universe(intUniverse);
                    if (o_LAN_Universe == null) continue;
                    if (o_LAN_Universe.getConnectionStatus() == 5) {
                        boolNoneChecked = false;
                        continue;
                    }
                    boolAllChecked = false;
                }
            }
        }
        intConnectionStatus = boolNoneChecked ? 2 : (boolAllChecked ? 5 : 6);
        if (this.m_ConnectionStatus != intConnectionStatus) {
            this.m_ConnectionStatus = intConnectionStatus;
            this.requestHardwareInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendArtNet_OP_Broadcast(ArtNet_Op p_ArtNet_Op) {
        ProtocolConfiguration_ArtNet o_ProtocolConfiguration_ArtNet;
        if (p_ArtNet_Op == null) {
            return;
        }
        ArrayList<ProtocolConfiguration_ArtNet> o_ARrayList_ProtocolConfigurations = new ArrayList<ProtocolConfiguration_ArtNet>();
        Object object = this.m_SyncLANInterface;
        synchronized (object) {
            for (HashMap<InetAddress, Protocols.ProtocolConfiguration> o_ProtocolConfigurations : this.m_ArtNetProtocols.values()) {
                if (o_ProtocolConfigurations == null) continue;
                for (InetAddress o_InetAddress : o_ProtocolConfigurations.keySet()) {
                    o_ProtocolConfiguration_ArtNet = (ProtocolConfiguration_ArtNet)o_ProtocolConfigurations.get(o_InetAddress);
                    if (o_ProtocolConfiguration_ArtNet == null) continue;
                    o_ARrayList_ProtocolConfigurations.add(o_ProtocolConfiguration_ArtNet);
                }
            }
        }
        for (int intConfiguration = 0; intConfiguration < o_ARrayList_ProtocolConfigurations.size(); ++intConfiguration) {
            o_ProtocolConfiguration_ArtNet = (ProtocolConfiguration_ArtNet)o_ARrayList_ProtocolConfigurations.get(intConfiguration);
            o_ProtocolConfiguration_ArtNet.sendArtNet_OP_Broadcast(p_ArtNet_Op);
        }
    }

    public void sendArtNet_OP(ArtNet_Op p_ArtNet_Op, InetAddress p_RemoteAddress, ProtocolConfiguration_ArtNet p_ProtocolConfiguration_ArtNet) {
        if (p_ArtNet_Op == null) {
            return;
        }
        if (p_ProtocolConfiguration_ArtNet == null) {
            return;
        }
        p_ProtocolConfiguration_ArtNet.sendArtNet_OP(p_ArtNet_Op, p_RemoteAddress);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof LAN_NetworkInterface) {
            LAN_NetworkInterface o_LAN_NetworkInterface = (LAN_NetworkInterface)evt.getSource();
            evt.getPropertyName().getClass();
        }
    }
}

