/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import DMXHardwarePackage.LAN_Device;
import DMXHardwarePackage.LAN_Device_ArtNet;
import DMXHardwarePackage.LAN_Device_Configuration_BindPanel;
import DMXHardwarePackage.LAN_Interface_Configuration;
import DMXHardwarePackage.LAN_PlugIn;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import ProtocolPackage.Protocols;
import SwingModelPackage.TableAndListModel;
import ToolPackage.DocumentFilter_Integer;
import ToolPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class LAN_Device_Configuration_PlugInPanel
extends JPanel
implements PropertyChangeListener {
    @LiveLanguageString
    public static String LABELUNIVERSE_ARTNET = "Port";
    @LiveLanguageString
    public static String LABELUNIVERSE_ARTNET_TOOLTIP = "<html>Low Part of portaddress (universenumber)<br>(0..15)</html>";
    @LiveLanguageString
    public static String LABELUNIVERSE_SACN = "Universe";
    @LiveLanguageString
    public static String LABELUNIVERSE_SACN_TOOLTIP = "<html>number of universe<br>0 = disabled</html>";
    @LiveLanguageString
    public static String LABELLANUNIVERSE = "LAN Universe";
    @LiveLanguageString
    public static String LABELLANUNIVERSE_DEACTIVATED = "Deactivated";
    @LiveLanguageString
    public static String LABELUNIVERSECALCULATED_ARTNET = "Calculated LAN universe number";
    @LiveLanguageString
    public static String LABELUNIVERSE_ARTNET_INPUTOUTPUTTOOLTIP = "<html>Change Port type (input<->output).<br>This may not work for every device.</html>";
    private LAN_Device_Configuration_BindPanel m_LAN_Device_Configuration_BindPanel;
    private LAN_PlugIn m_LAN_PlugIn;
    private GridBagConstraints m_GridBagConstraints;
    private Runnable m_Runnable_RefreshGUI;
    private String m_New_Name;
    private int m_New_PlugInType;
    private int m_New_ProtocolType;
    private int m_New_MergeMode;
    private int m_New_UniverseNumber;
    private byte m_New_SWOut;
    private byte m_New_SWIn;
    private JComboBox<String> jComboBox_MergeMode;
    private JComboBox<String> jComboBox_PlugInType;
    private JComboBox<String> jComboBox_Protocols;
    private JLabel jLabel_Name;
    private JLabel jLabel_PlugInType;
    private JLabel jLabel_PortIndex;
    private JLabel jLabel_ProtocolType;
    private JLabel jLabel_ProtocolType_Uncertain;
    private JLabel jLabel_Universe;
    private JLabel jLabel_UniverseCalculated;
    private JTextField jTextField_Name;
    private JTextField jTextField_Universe;

    public LAN_Device_Configuration_PlugInPanel(LAN_Device_Configuration_BindPanel p_LAN_Device_Configuration_BindPanel) {
        this.m_LAN_Device_Configuration_BindPanel = p_LAN_Device_Configuration_BindPanel;
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, (String)LAN_Interface_Configuration.class.getSimpleName());
    }

    private void initMembers() {
        this.m_GridBagConstraints = new GridBagConstraints();
        this.m_GridBagConstraints.gridx = 0;
        this.m_GridBagConstraints.gridy = 0;
        this.m_GridBagConstraints.fill = 2;
        this.m_GridBagConstraints.weightx = 1.0;
        this.m_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.m_Runnable_RefreshGUI = new Runnable(){

            @Override
            public void run() {
                LAN_Device_Configuration_PlugInPanel.this.refreshGUI();
            }
        };
    }

    private void initComponents() {
        this.jLabel_PlugInType = new JLabel();
        this.jComboBox_PlugInType = new JComboBox();
        this.jLabel_Universe = new JLabel();
        this.jTextField_Name = new JTextField();
        this.jTextField_Universe = new JTextField();
        this.jLabel_Name = new JLabel();
        this.jLabel_PortIndex = new JLabel();
        this.jLabel_UniverseCalculated = new JLabel();
        this.jLabel_ProtocolType = new JLabel();
        this.jComboBox_Protocols = new JComboBox();
        this.jComboBox_MergeMode = new JComboBox();
        this.jLabel_ProtocolType_Uncertain = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.setMinimumSize(new Dimension(26, 78));
        this.setPreferredSize(new Dimension(26, 78));
        this.setLayout(new GridBagLayout());
        this.jLabel_PlugInType.setHorizontalAlignment(0);
        this.jLabel_PlugInType.setText("Type");
        this.jLabel_PlugInType.setToolTipText("");
        this.jLabel_PlugInType.setHorizontalTextPosition(0);
        this.jLabel_PlugInType.setMaximumSize(new Dimension(100, 20));
        this.jLabel_PlugInType.setMinimumSize(new Dimension(100, 20));
        this.jLabel_PlugInType.setPreferredSize(new Dimension(100, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_PlugInType, gridBagConstraints);
        this.jComboBox_PlugInType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_PlugInType.setMinimumSize(new Dimension(100, 20));
        this.jComboBox_PlugInType.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.jComboBox_PlugInType, gridBagConstraints);
        this.jLabel_Universe.setHorizontalAlignment(4);
        this.jLabel_Universe.setText("Universe");
        this.jLabel_Universe.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Universe, gridBagConstraints);
        this.jTextField_Name.setHorizontalAlignment(0);
        this.jTextField_Name.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_Name, gridBagConstraints);
        this.jTextField_Universe.setHorizontalAlignment(0);
        this.jTextField_Universe.setText("jTextField1");
        this.jTextField_Universe.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LAN_Device_Configuration_PlugInPanel.this.jTextField_UniverseFocusLost(evt);
            }
        });
        this.jTextField_Universe.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LAN_Device_Configuration_PlugInPanel.this.jTextField_UniverseKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_Universe, gridBagConstraints);
        this.jLabel_Name.setHorizontalAlignment(4);
        this.jLabel_Name.setText("Name");
        this.jLabel_Name.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Name, gridBagConstraints);
        this.jLabel_PortIndex.setHorizontalAlignment(0);
        this.jLabel_PortIndex.setText("0");
        this.jLabel_PortIndex.setToolTipText("");
        this.jLabel_PortIndex.setMaximumSize(new Dimension(42, 20));
        this.jLabel_PortIndex.setMinimumSize(new Dimension(42, 20));
        this.jLabel_PortIndex.setPreferredSize(new Dimension(42, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_PortIndex, gridBagConstraints);
        this.jLabel_UniverseCalculated.setHorizontalAlignment(0);
        this.jLabel_UniverseCalculated.setText("Universe");
        this.jLabel_UniverseCalculated.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_UniverseCalculated, gridBagConstraints);
        this.jLabel_ProtocolType.setHorizontalAlignment(0);
        this.jLabel_ProtocolType.setText("ProtocolType");
        this.jLabel_ProtocolType.setToolTipText("");
        this.jLabel_ProtocolType.setHorizontalTextPosition(0);
        this.jLabel_ProtocolType.setMaximumSize(new Dimension(42, 20));
        this.jLabel_ProtocolType.setMinimumSize(new Dimension(42, 20));
        this.jLabel_ProtocolType.setPreferredSize(new Dimension(42, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_ProtocolType, gridBagConstraints);
        this.jComboBox_Protocols.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Protocols.setMinimumSize(new Dimension(100, 20));
        this.jComboBox_Protocols.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.jComboBox_Protocols, gridBagConstraints);
        this.jComboBox_MergeMode.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_MergeMode.setMinimumSize(new Dimension(100, 20));
        this.jComboBox_MergeMode.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.jComboBox_MergeMode, gridBagConstraints);
        this.jLabel_ProtocolType_Uncertain.setForeground(new Color(255, 255, 102));
        this.jLabel_ProtocolType_Uncertain.setHorizontalAlignment(0);
        this.jLabel_ProtocolType_Uncertain.setText("ProtocolType");
        this.jLabel_ProtocolType_Uncertain.setToolTipText("");
        this.jLabel_ProtocolType_Uncertain.setHorizontalTextPosition(0);
        this.jLabel_ProtocolType_Uncertain.setMaximumSize(new Dimension(42, 20));
        this.jLabel_ProtocolType_Uncertain.setMinimumSize(new Dimension(42, 20));
        this.jLabel_ProtocolType_Uncertain.setPreferredSize(new Dimension(42, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_ProtocolType_Uncertain, gridBagConstraints);
    }

    private void jTextField_UniverseFocusLost(FocusEvent evt) {
        this.checkJTextField_Universe();
    }

    private void jTextField_UniverseKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.checkJTextField_Universe();
        }
    }

    private void checkJTextField_Universe() {
        int intUniverseNumber;
        LAN_PlugIn o_LAN_PlugIn = null;
        LAN_Device o_LAN_Device = null;
        LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
        o_LAN_PlugIn = this.m_LAN_PlugIn;
        if (o_LAN_PlugIn != null && (o_LAN_Device = o_LAN_PlugIn.getLAN_Device()) != null && o_LAN_Device instanceof LAN_Device_ArtNet) {
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        }
        try {
            intUniverseNumber = Integer.valueOf(this.jTextField_Universe.getText());
        }
        catch (Exception e) {
            intUniverseNumber = 0;
        }
        if (o_LAN_Device_ArtNet != null) {
            if (intUniverseNumber < 0) {
                intUniverseNumber = 0;
            } else if (intUniverseNumber > 15) {
                intUniverseNumber = 15;
            }
            this.jTextField_Universe.setText(String.valueOf(intUniverseNumber));
        } else if (o_LAN_Device != null) {
            if (intUniverseNumber <= 0) {
                intUniverseNumber = -1;
            } else if (intUniverseNumber > 65535) {
                intUniverseNumber = 65535;
            }
            if (intUniverseNumber <= 0) {
                this.jTextField_Universe.setText("");
            } else {
                this.jTextField_Universe.setText(String.valueOf(intUniverseNumber));
            }
        } else {
            this.jTextField_Universe.setText("");
        }
        this.refreshNewLANUniverseNumber();
    }

    private void initComponentsFurther() {
        TableAndListModel.ListModel o_ListModelPlugInType = new TableAndListModel.ListModel(false);
        o_ListModelPlugInType.add((Object)"Output");
        o_ListModelPlugInType.add((Object)"Input");
        this.jComboBox_PlugInType.setModel((ComboBoxModel<String>)o_ListModelPlugInType.createListModelWrapper());
        this.jComboBox_PlugInType.setRenderer(new ComboBoxListRenderer());
        TableAndListModel.ListModel o_ListModelProtocols = new TableAndListModel.ListModel(false);
        o_ListModelProtocols.add((Object)Protocols.getProtocolName((int)1));
        o_ListModelProtocols.add((Object)Protocols.getProtocolName((int)3));
        this.jComboBox_Protocols.setModel((ComboBoxModel<String>)o_ListModelProtocols.createListModelWrapper());
        this.jComboBox_Protocols.setRenderer(new ComboBoxListRenderer());
        TableAndListModel.ListModel o_ListModelMergeMode = new TableAndListModel.ListModel(false);
        o_ListModelMergeMode.add((Object)"-");
        o_ListModelMergeMode.add((Object)"HTP");
        o_ListModelMergeMode.add((Object)"LTP");
        this.jComboBox_MergeMode.setModel((ComboBoxModel<String>)o_ListModelMergeMode.createListModelWrapper());
        this.jComboBox_MergeMode.setRenderer(new ComboBoxListRenderer());
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer(this.jTextField_Universe);
        o_DocumentFilter_Integer.setAllowNegativeNumbers(false);
        o_DocumentFilter_Integer.setAllowEmptyString(true);
        this.jTextField_Universe.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jComboBox_MergeMode.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jComboBox_PlugInType.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jComboBox_Protocols.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jLabel_UniverseCalculated.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jLabel_ProtocolType_Uncertain.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    public void close() {
        this.jTextField_Universe.setComponentPopupMenu(null);
        this.jComboBox_MergeMode.setComponentPopupMenu(null);
        this.jComboBox_PlugInType.setComponentPopupMenu(null);
        this.jComboBox_Protocols.setComponentPopupMenu(null);
        this.jLabel_UniverseCalculated.setComponentPopupMenu(null);
        this.jLabel_ProtocolType_Uncertain.setComponentPopupMenu(null);
        LAN_PlugIn o_LAN_PlugIn = this.m_LAN_PlugIn;
        if (o_LAN_PlugIn != null) {
            o_LAN_PlugIn.removePropertyChangeListener(this);
        }
        this.m_LAN_PlugIn = null;
        this.m_LAN_Device_Configuration_BindPanel = null;
    }

    public void setLAN_PlugIn(LAN_PlugIn p_LAN_PlugIn) {
        if (this.m_LAN_PlugIn == p_LAN_PlugIn) {
            return;
        }
        if (this.m_LAN_PlugIn != null) {
            this.m_LAN_PlugIn.removePropertyChangeListener(this);
        }
        this.m_LAN_PlugIn = p_LAN_PlugIn;
        if (this.m_LAN_PlugIn != null) {
            this.m_LAN_PlugIn.addPropertyChangeListener(this);
        }
        EventQueue.invokeLater(this.m_Runnable_RefreshGUI);
    }

    public LAN_PlugIn getLAN_PlugIn() {
        return this.m_LAN_PlugIn;
    }

    public GridBagConstraints getGridBagConstraints() {
        LAN_PlugIn o_LAN_PlugIn = this.m_LAN_PlugIn;
        if (o_LAN_PlugIn == null) {
            return this.m_GridBagConstraints;
        }
        LAN_Device o_LAN_Device = o_LAN_PlugIn.getLAN_Device();
        if (o_LAN_Device == null) {
            return this.m_GridBagConstraints;
        }
        int intIndexY = o_LAN_PlugIn.getPortIndex();
        if (o_LAN_Device instanceof LAN_Device_ArtNet && o_LAN_PlugIn.getPlugInType() == 1) {
            intIndexY += 4;
        }
        this.m_GridBagConstraints.gridy = intIndexY;
        return this.m_GridBagConstraints;
    }

    public void refreshGUI() {
        LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
        boolean boolSupportSACN = false;
        boolean boolProtocolType_IsUncertain = false;
        LAN_PlugIn o_LAN_PlugIn = this.m_LAN_PlugIn;
        if (o_LAN_PlugIn == null) {
            this.jLabel_PlugInType.setText("");
            return;
        }
        LAN_Device o_LAN_Device = o_LAN_PlugIn.getLAN_Device();
        if (o_LAN_Device == null) {
            this.jLabel_PlugInType.setText("");
            return;
        }
        if (o_LAN_Device instanceof LAN_Device_ArtNet) {
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        }
        if (o_LAN_Device_ArtNet != null) {
            Byte byteStatus2;
            this.jComboBox_PlugInType.setVisible(false);
            this.jLabel_PlugInType.setVisible(true);
            this.jTextField_Name.setEnabled(false);
            this.jLabel_Universe.setText(LABELUNIVERSE_ARTNET);
            this.jTextField_Universe.setToolTipText(LABELUNIVERSE_ARTNET_TOOLTIP);
            this.jLabel_UniverseCalculated.setToolTipText(LABELUNIVERSECALCULATED_ARTNET);
            this.jLabel_UniverseCalculated.setVisible(true);
            if (o_LAN_PlugIn.getPlugInType() == 0) {
                this.jComboBox_MergeMode.setSelectedItem(o_LAN_PlugIn.getMergeModeString());
                this.jComboBox_MergeMode.setVisible(true);
            } else {
                this.jComboBox_MergeMode.setVisible(false);
            }
            Byte byteStatus1 = o_LAN_Device_ArtNet.getStatus1();
            if (byteStatus1 == null) {
                byteStatus1 = 0;
            }
            if ((byteStatus2 = Byte.valueOf(o_LAN_Device_ArtNet.getStatus2())) == null) {
                byteStatus2 = 0;
            }
            if (o_LAN_Device_ArtNet.getChangeProtocol_Capable()) {
                boolSupportSACN = true;
            }
            if (o_LAN_PlugIn.getPlugInType() == 0) {
                if (boolSupportSACN) {
                    this.jLabel_ProtocolType.setVisible(false);
                    this.jLabel_ProtocolType_Uncertain.setVisible(false);
                    this.jComboBox_Protocols.setVisible(true);
                } else {
                    this.jLabel_ProtocolType.setVisible(true);
                    this.jLabel_ProtocolType_Uncertain.setVisible(false);
                    this.jComboBox_Protocols.setVisible(false);
                }
            } else if (o_LAN_PlugIn.getPlugInType() == 1) {
                boolProtocolType_IsUncertain = true;
                this.jLabel_ProtocolType.setVisible(false);
                this.jLabel_ProtocolType_Uncertain.setVisible(true);
                this.jComboBox_Protocols.setVisible(false);
            } else {
                this.jLabel_ProtocolType.setVisible(false);
                this.jLabel_ProtocolType_Uncertain.setVisible(false);
                this.jComboBox_Protocols.setVisible(false);
            }
            if (o_LAN_PlugIn == null || o_LAN_PlugIn.getIsVirtual()) {
                this.jTextField_Universe.setEnabled(false);
            } else {
                this.jTextField_Universe.setEnabled(true);
            }
        } else {
            this.jComboBox_MergeMode.setVisible(false);
            this.jComboBox_Protocols.setVisible(false);
            this.jLabel_ProtocolType_Uncertain.setVisible(false);
            this.jComboBox_PlugInType.setVisible(true);
            this.jLabel_PlugInType.setVisible(false);
            this.jTextField_Name.setEnabled(true);
            this.jLabel_Universe.setText(LABELUNIVERSE_SACN);
            this.jTextField_Universe.setToolTipText(LABELUNIVERSE_SACN_TOOLTIP);
            this.jTextField_Universe.setEnabled(true);
            this.jComboBox_PlugInType.setToolTipText(null);
            this.jLabel_UniverseCalculated.setToolTipText(null);
            this.jLabel_UniverseCalculated.setVisible(true);
        }
        this.jLabel_PortIndex.setText(String.valueOf(o_LAN_PlugIn.getPortIndex() + 1));
        this.jTextField_Name.setText(o_LAN_PlugIn.getName());
        this.jLabel_ProtocolType.setText(Protocols.getProtocolName((int)o_LAN_PlugIn.getProtocolType()));
        if (boolProtocolType_IsUncertain) {
            this.jLabel_ProtocolType_Uncertain.setText(Protocols.getProtocolName((int)o_LAN_PlugIn.getProtocolType()) + " ???");
        }
        this.jComboBox_Protocols.setSelectedItem(Protocols.getProtocolName((int)o_LAN_PlugIn.getProtocolType()));
        switch (o_LAN_PlugIn.getPlugInType()) {
            case 0: {
                this.jLabel_PlugInType.setText("Output");
                this.jComboBox_PlugInType.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.jLabel_PlugInType.setText("Input");
                this.jComboBox_PlugInType.setSelectedIndex(1);
                break;
            }
            default: {
                this.jLabel_PlugInType.setText("");
            }
        }
        if (o_LAN_Device_ArtNet != null) {
            int intPortIndex = o_LAN_PlugIn.getPortIndex();
            LAN_Device_ArtNet.BindIndexStructure o_BindIndexStructure = o_LAN_Device_ArtNet.getBindIndexStructure(o_LAN_PlugIn.getBindIndex());
            if (o_BindIndexStructure == null) {
                this.jTextField_Universe.setText("");
                this.jLabel_UniverseCalculated.setText("");
            } else if (o_LAN_PlugIn.getPlugInType() == 0) {
                byte byteSWOut = o_BindIndexStructure.getSWOut(intPortIndex);
                this.jTextField_Universe.setText(String.valueOf(byteSWOut & 0xFF));
                this.jLabel_UniverseCalculated.setText(LABELLANUNIVERSE + " " + String.valueOf(o_LAN_PlugIn.getLAN_UniverseNumber()));
            } else if (o_LAN_PlugIn.getPlugInType() == 1) {
                byte byteSWIn = o_BindIndexStructure.getSWIn(intPortIndex);
                this.jTextField_Universe.setText(String.valueOf(byteSWIn & 0xFF));
                this.jLabel_UniverseCalculated.setText(LABELLANUNIVERSE + " " + String.valueOf(o_LAN_PlugIn.getLAN_UniverseNumber()));
            } else {
                this.jTextField_Universe.setText("");
                this.jLabel_UniverseCalculated.setText("");
            }
        } else if (o_LAN_Device != null) {
            int intUniverseNumber = o_LAN_PlugIn.getLAN_UniverseNumber();
            if (intUniverseNumber <= 0) {
                intUniverseNumber = -1;
            } else if (intUniverseNumber > 65535) {
                intUniverseNumber = 65535;
            }
            if (intUniverseNumber <= 0) {
                this.jTextField_Universe.setText("");
                this.jLabel_UniverseCalculated.setText(LABELLANUNIVERSE_DEACTIVATED);
            } else {
                this.jTextField_Universe.setText(String.valueOf(intUniverseNumber));
                this.jLabel_UniverseCalculated.setText(LABELLANUNIVERSE + " " + String.valueOf(o_LAN_PlugIn.getLAN_UniverseNumber()));
            }
        }
        this.revalidate();
        this.repaint();
    }

    public int refreshNewLANUniverseNumber() {
        int intLANUniverseNumber = -1;
        LAN_PlugIn o_LAN_PlugIn = null;
        LAN_Device o_LAN_Device = null;
        int intUniversePort = -1;
        LAN_Device_Configuration_BindPanel o_LAN_Device_Configuration_BindPanel = this.m_LAN_Device_Configuration_BindPanel;
        if (o_LAN_Device_Configuration_BindPanel == null) {
            this.jLabel_UniverseCalculated.setText("");
            return -1;
        }
        o_LAN_PlugIn = this.m_LAN_PlugIn;
        if (o_LAN_PlugIn != null) {
            o_LAN_Device = o_LAN_PlugIn.getLAN_Device();
        }
        if (o_LAN_Device != null) {
            try {
                intUniversePort = Integer.valueOf(this.jTextField_Universe.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (o_LAN_Device instanceof LAN_Device_ArtNet) {
                int intNetSwitch = o_LAN_Device_Configuration_BindPanel.getNew_NetSwitchFromText();
                int intSubNet = o_LAN_Device_Configuration_BindPanel.getNew_SubNetFromText();
                if (intNetSwitch >= 0 && intSubNet >= 0 && intUniversePort >= 0) {
                    intLANUniverseNumber = intNetSwitch * 256 + intSubNet * 16 + intUniversePort;
                }
            } else {
                try {
                    intLANUniverseNumber = Integer.valueOf(this.jTextField_Universe.getText());
                }
                catch (Exception e) {
                    intLANUniverseNumber = -1;
                }
            }
        }
        if (intLANUniverseNumber >= 0) {
            this.jLabel_UniverseCalculated.setText(LABELLANUNIVERSE + " " + String.valueOf(intLANUniverseNumber));
        } else {
            this.jLabel_UniverseCalculated.setText(LABELLANUNIVERSE_DEACTIVATED);
        }
        return intLANUniverseNumber;
    }

    public void prepareSave_ArtNet() {
        LAN_PlugIn o_LAN_PlugIn = this.m_LAN_PlugIn;
        if (o_LAN_PlugIn == null) {
            return;
        }
        this.m_New_Name = o_LAN_PlugIn.getName();
        this.m_New_PlugInType = this.jComboBox_PlugInType.getSelectedIndex();
        this.m_New_ProtocolType = Protocols.getProtocolFromName((String)((String)this.jComboBox_Protocols.getSelectedItem()));
        this.m_New_MergeMode = 0;
        String stringMergeMode = (String)this.jComboBox_MergeMode.getSelectedItem();
        if (stringMergeMode != null) {
            switch (stringMergeMode) {
                case "HTP": {
                    this.m_New_MergeMode = 1;
                    break;
                }
                case "LTP": {
                    this.m_New_MergeMode = 2;
                    break;
                }
                case "-": {
                    this.m_New_MergeMode = 0;
                }
                default: {
                    this.m_New_MergeMode = 0;
                }
            }
        }
        try {
            this.m_New_UniverseNumber = Integer.valueOf(this.jTextField_Universe.getText());
            if (this.m_New_UniverseNumber < 0) {
                this.m_New_UniverseNumber = 0;
            } else if (this.m_New_UniverseNumber > 15) {
                this.m_New_UniverseNumber = 15;
            }
        }
        catch (Exception e) {
            this.m_New_UniverseNumber = 0;
        }
        String stringPlugInType = (String)this.jComboBox_PlugInType.getSelectedItem();
        if ("Output".equals(stringPlugInType)) {
            this.m_New_SWIn = 0;
            this.m_New_SWOut = (byte)(this.m_New_UniverseNumber & 0xFF);
        } else {
            this.m_New_SWOut = 0;
            this.m_New_SWIn = (byte)(this.m_New_UniverseNumber & 0xFF);
        }
    }

    public void prepareSave_sACN() {
        LAN_PlugIn o_LAN_PlugIn = this.m_LAN_PlugIn;
        if (o_LAN_PlugIn == null) {
            return;
        }
        this.m_New_Name = this.jTextField_Name.getText();
        this.m_New_PlugInType = this.jComboBox_PlugInType.getSelectedIndex();
        try {
            this.m_New_UniverseNumber = Integer.valueOf(this.jTextField_Universe.getText());
            if (this.m_New_UniverseNumber <= 0) {
                this.m_New_UniverseNumber = -1;
            }
            if (this.m_New_UniverseNumber > 65535) {
                this.m_New_UniverseNumber = 65535;
            }
        }
        catch (Exception e) {
            this.m_New_UniverseNumber = -1;
        }
    }

    public String getNew_Name() {
        return this.m_New_Name;
    }

    public int getNew_PlugInType() {
        return this.m_New_PlugInType;
    }

    public int getNew_ProtocolType() {
        return this.m_New_ProtocolType;
    }

    public int getNew_MergeMode() {
        return this.m_New_MergeMode;
    }

    public int getNew_UniverseNumber() {
        return this.m_New_UniverseNumber;
    }

    public byte getNew_SWOut() {
        return this.m_New_SWOut;
    }

    public byte getNew_SWIn() {
        return this.m_New_SWIn;
    }

    public int getBindIndex() {
        LAN_PlugIn o_LAN_PlugIn = this.m_LAN_PlugIn;
        if (o_LAN_PlugIn == null) {
            return -1;
        }
        return o_LAN_PlugIn.getBindIndex();
    }

    public int getPortIndex() {
        LAN_PlugIn o_LAN_PlugIn = this.m_LAN_PlugIn;
        if (o_LAN_PlugIn == null) {
            return -1;
        }
        return o_LAN_PlugIn.getPortIndex();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof LAN_PlugIn) {
            LAN_PlugIn o_LAN_PlugIn = (LAN_PlugIn)evt.getSource();
            EventQueue.invokeLater(this.m_Runnable_RefreshGUI);
        }
    }

    public static class ComboBoxListRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

        @Override
        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            Border border = SAFE_NO_FOCUS_BORDER;
            if (cellHasFocus) {
                if (isSelected) {
                    // empty if block
                }
                if (border == null) {
                    // empty if block
                }
            }
            this.setBorder(border);
            return this;
        }
    }
}

