/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import ArtNetPackage.ArtNet_Op;
import ArtNetPackage.ArtNet_Op_ArtAddress;
import ArtNetPackage.ArtNet_Op_ArtDMX;
import ArtNetPackage.ArtNet_Op_ArtIPProg;
import ArtNetPackage.ArtNet_Op_ArtIPProgReply;
import ArtNetPackage.ArtNet_Op_ArtPollReply;
import ArtNetPackage.ProtocolConfiguration_ArtNet;
import DMXHardwarePackage.LAN_Device;
import DMXHardwarePackage.LAN_Interface;
import DMXHardwarePackage.LAN_PlugIn;
import DMXHardwarePackage.LAN_Universe;
import NetworkTools.NetworkTool;
import ProtocolPackage.Protocols;
import java.awt.EventQueue;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class LAN_Device_ArtNet
extends LAN_Device {
    public static final String MACADDRESS_UNKNOWN = "unknown";
    public static final Object s_SynInterprete = new Object();
    public static int MISSEDPOOLS_MAX = 2;
    protected int m_MissedPolls;
    private HashMap<Integer, BindIndexStructure> m_BindIndexStructures;
    private final Object m_SyncBindIndex = new Object();
    protected ProtocolConfiguration_ArtNet m_ProtocolConfigurationDetected;
    protected int m_ReceivedArtPollReply;
    protected String m_MacAddress;
    protected String m_LocalIPAddress;
    protected InetAddress m_LocalInetAddress;
    protected int m_LocalPort;
    protected String m_RemoteIPAddress;
    protected InetAddress m_RemoteInetAddress;
    protected byte[] m_RemoteSubNetMask;
    protected boolean m_RemoteDHCP_Capable;
    protected boolean m_RemoteDHCP;
    protected int m_RemotePort;
    protected boolean m_RemoteInetAddressIsMulticast;
    protected boolean m_IPProgrammable;
    protected ArtNet_Op_ArtIPProg m_ArtNet_Op_ArtIPProg;
    protected ArtNet_Op_ArtAddress m_ArtNet_Op_ArtAddress;
    protected byte m_Status1;
    protected byte m_Status2;
    protected boolean m_ChangeProtocolCapable;
    Runnable m_RunnablePollStarted = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = s_SynInterprete;
            synchronized (object) {
                LAN_Device_ArtNet.this.m_ReceivedArtPollReply = -1;
                LAN_Device_ArtNet.this.increaseMissedPolls();
            }
        }
    };
    Runnable m_RunnablePollEnded = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LAN_Interface o_LAN_Interface = LAN_Device_ArtNet.this.m_LAN_Interface;
            if (o_LAN_Interface == null) {
                return;
            }
            Object object = s_SynInterprete;
            synchronized (object) {
                LAN_Device_ArtNet.this.checkMissedPolls();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void interpreteArtPollReply(ProtocolConfiguration_ArtNet p_ProtocolConfiguration_ArtNet, ArtNet_Op_ArtPollReply p_ArtNetPollReply, LAN_Interface p_LAN_Interface, InetAddress p_RemoteInetAddressUDP) {
        LAN_Interface o_LAN_Interface;
        LAN_Device_ArtNet o_LAN_Device_ArtNet;
        if (p_ArtNetPollReply == null) {
            return;
        }
        if (p_LAN_Interface == null) {
            p_ArtNetPollReply.close();
            return;
        }
        if (p_RemoteInetAddressUDP == null) {
            p_ArtNetPollReply.close();
            return;
        }
        boolean boolBindIndexStructureChanged = false;
        boolean boolNewDevice = false;
        Object object = s_SynInterprete;
        synchronized (object) {
            InetAddress o_RemoteInetAddress = p_ArtNetPollReply.getRemoteInetAddress();
            if (p_RemoteInetAddressUDP != null && !p_RemoteInetAddressUDP.equals(o_RemoteInetAddress)) {
                p_ArtNetPollReply.close();
                return;
            }
            String stringIPAddress = o_RemoteInetAddress != null ? o_RemoteInetAddress.getHostAddress() : "";
            String stringMacAddress = p_ArtNetPollReply.getMacAddress();
            String stringID = stringIPAddress;
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)p_LAN_Interface.getLAN_Device(stringID);
            if (o_LAN_Device_ArtNet == null && (o_LAN_Device_ArtNet = p_LAN_Interface.getLAN_Device_ArtNet_ByIP(stringIPAddress)) == null) {
                o_LAN_Device_ArtNet = new LAN_Device_ArtNet(p_LAN_Interface);
                o_LAN_Device_ArtNet.setID(stringID);
                o_LAN_Device_ArtNet.setMACAddress(stringMacAddress);
                o_LAN_Device_ArtNet.setRemoteAddress(o_RemoteInetAddress, p_ArtNetPollReply.getRemotePort());
                p_LAN_Interface.addLAN_Device(o_LAN_Device_ArtNet);
                boolNewDevice = true;
            }
            o_LAN_Device_ArtNet.setName("ARTNET");
            o_LAN_Device_ArtNet.setLongName("");
            o_LAN_Device_ArtNet.setProtocolConfigurationDetected(p_ProtocolConfiguration_ArtNet);
            int intBindIndex = p_ArtNetPollReply.getBindIndex();
            if (intBindIndex == 0) {
                intBindIndex = 1;
            }
            if (o_LAN_Device_ArtNet.getArtPollReplyReceived() >= intBindIndex) {
                p_ArtNetPollReply.close();
                return;
            }
            o_LAN_Device_ArtNet.setArtPollReplyReceived(intBindIndex);
            o_LAN_Device_ArtNet.setFirmware(p_ArtNetPollReply.getFirmwareHigh(), p_ArtNetPollReply.getFirmwareLow());
            o_LAN_Device_ArtNet.setRemoteAddress(p_ArtNetPollReply.getRemoteInetAddress(), p_ArtNetPollReply.getRemotePort());
            BindIndexStructure o_BindIndexStructure = o_LAN_Device_ArtNet.getBindIndexStructure(intBindIndex);
            if (o_BindIndexStructure == null) {
                o_BindIndexStructure = new BindIndexStructure(o_LAN_Device_ArtNet, intBindIndex);
            }
            o_BindIndexStructure.setIsVirtual(false);
            o_BindIndexStructure.setShortName(p_ArtNetPollReply.getShortName());
            o_BindIndexStructure.setLongName(p_ArtNetPollReply.getLongName());
            if (o_BindIndexStructure.setUniverseNetSwitch(p_ArtNetPollReply.getUniverseNet())) {
                boolBindIndexStructureChanged = true;
            }
            if (o_BindIndexStructure.setUniverseSubSwitch(p_ArtNetPollReply.getUniverseSubSwitch())) {
                boolBindIndexStructureChanged = true;
            }
            o_BindIndexStructure.setPortCount(p_ArtNetPollReply.getPlugInCount());
            if (o_BindIndexStructure.setPortTypes_SWInOuts(p_ArtNetPollReply.getPortTypes(), p_ArtNetPollReply.getSwOuts(), p_ArtNetPollReply.getSwIns())) {
                boolBindIndexStructureChanged = true;
            }
            if (o_BindIndexStructure.setGoodOutputs(p_ArtNetPollReply.getGoodOutputs())) {
                boolBindIndexStructureChanged = true;
            }
            if (o_BindIndexStructure.setGoodInputs(p_ArtNetPollReply.getGoodInputs())) {
                boolBindIndexStructureChanged = true;
            }
            if (boolBindIndexStructureChanged) {
                o_BindIndexStructure.checkArtNetPortTypes();
            }
            o_LAN_Device_ArtNet.setStatus1(p_ArtNetPollReply.getStatus1());
            o_LAN_Device_ArtNet.setStatus2(p_ArtNetPollReply.getStatus2());
        }
        if (boolNewDevice && (o_LAN_Interface = o_LAN_Device_ArtNet.getLAN_Interface()) != null) {
            ArtNet_Op_ArtIPProg o_ArtNet_Op_ArtIPProg = o_LAN_Device_ArtNet.getArtNet_Op_ArtIPProg();
            o_ArtNet_Op_ArtIPProg.setCommand_Enquiry();
            o_ArtNet_Op_ArtIPProg.setIP4Address(o_LAN_Device_ArtNet.getRemoteInetAddress());
            o_ArtNet_Op_ArtIPProg.setSubNetMask((byte)-1, (byte)0, (byte)0, (byte)0);
            o_LAN_Interface.sendArtNet_OP((ArtNet_Op)o_ArtNet_Op_ArtIPProg, o_LAN_Device_ArtNet.getRemoteInetAddress(), o_LAN_Device_ArtNet.getProtocolConfigurationDetected());
        }
        p_ArtNetPollReply.close();
    }

    public static void interpreteArtDMX(ProtocolConfiguration_ArtNet p_ProtocolConfiguration_ArtNet, ArtNet_Op_ArtDMX p_ArtDMX, LAN_Interface p_LAN_Interface, InetAddress p_RemoteInetAddressUDP) {
        BindIndexStructure o_BindIndexStructure;
        LAN_PlugIn o_LAN_PlugIn_In;
        if (p_ArtDMX == null) {
            return;
        }
        if (p_LAN_Interface == null) {
            p_ArtDMX.close();
            return;
        }
        LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
        String stringLAN_DeviceArtNetID = p_RemoteInetAddressUDP.getHostAddress();
        LAN_Device o_LAN_Device = p_LAN_Interface.getLAN_Device(stringLAN_DeviceArtNetID);
        if (o_LAN_Device instanceof LAN_Device_ArtNet) {
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        }
        if (o_LAN_Device_ArtNet == null) {
            o_LAN_Device_ArtNet = new LAN_Device_ArtNet(p_LAN_Interface);
            o_LAN_Device_ArtNet.setID(stringLAN_DeviceArtNetID);
            o_LAN_Device_ArtNet.setName("ARTNET VIRTUAL IN");
            o_LAN_Device_ArtNet.setLongName("Device does not send ArtPollReply");
            o_LAN_Device_ArtNet.setMACAddress(MACADDRESS_UNKNOWN);
            o_LAN_Device_ArtNet.setRemoteAddress(p_RemoteInetAddressUDP, Protocols.ARTNET_PORT);
            p_LAN_Interface.addLAN_Device(o_LAN_Device_ArtNet);
        }
        int intBindIndex = -1;
        int intUniverseNumber = p_ArtDMX.getUniverseNumber();
        LAN_Universe o_LAN_Universe = p_LAN_Interface.getLAN_Universe(intUniverseNumber, 1);
        if (o_LAN_Universe != null && (o_LAN_PlugIn_In = o_LAN_Universe.getLAN_PlugIn_ArtNet(p_RemoteInetAddressUDP.getHostAddress())) != null) {
            intBindIndex = o_LAN_PlugIn_In.getBindIndex();
        }
        if (intBindIndex < 0) {
            intBindIndex = 100000 + intUniverseNumber;
        }
        if ((o_BindIndexStructure = o_LAN_Device_ArtNet.getBindIndexStructure(intBindIndex)) == null) {
            o_BindIndexStructure = new BindIndexStructure(o_LAN_Device_ArtNet, intBindIndex);
            o_BindIndexStructure.setUniverseNetSwitch((byte)p_ArtDMX.getNetSwitch());
            o_BindIndexStructure.setUniverseSubSwitch((byte)p_ArtDMX.getSubSwitch());
            o_BindIndexStructure.setPortCount(1);
            o_BindIndexStructure.setShortName("Virtual Inputs");
            o_BindIndexStructure.setIsVirtual(true);
        }
        if ((o_LAN_PlugIn_In = o_BindIndexStructure.getLAN_PlugIn_In_BySWIn(p_ArtDMX.getPortAddress())) == null) {
            LAN_PlugIn o_LAN_PlugIn_Exist;
            int intSWInByteIndex;
            for (intSWInByteIndex = 0; intSWInByteIndex < 4 && (o_LAN_PlugIn_Exist = o_BindIndexStructure.getLAN_PlugIn_In(intSWInByteIndex)) != null; ++intSWInByteIndex) {
            }
            if (intSWInByteIndex >= 4) {
                p_ArtDMX.close();
                return;
            }
            o_BindIndexStructure.setSWIn(intSWInByteIndex, (byte)p_ArtDMX.getPortAddress());
            o_BindIndexStructure.setProtocolType(intSWInByteIndex, 1, 1);
            o_BindIndexStructure.setPortType(intSWInByteIndex, false, true);
            o_LAN_PlugIn_In = o_BindIndexStructure.createLAN_Plugin_In(intSWInByteIndex);
            o_LAN_PlugIn_In.setIsVirtual(true);
            o_LAN_PlugIn_In.setLanUniverseNumber(intUniverseNumber);
            o_LAN_PlugIn_In.setConnectionStatus(5);
            o_BindIndexStructure.addLAN_Plugin_In(intSWInByteIndex, o_LAN_PlugIn_In);
            o_LAN_PlugIn_In = o_BindIndexStructure.getLAN_PlugIn_In(intSWInByteIndex);
            if (o_LAN_PlugIn_In == null) {
                p_ArtDMX.close();
                return;
            }
            o_LAN_PlugIn_In.setIsVirtual(true);
            o_LAN_PlugIn_In.setName("VirtualPlug");
        }
        if ((o_LAN_Universe = p_LAN_Interface.getLAN_Universe(intUniverseNumber, 1)) == null) {
            p_ArtDMX.close();
            return;
        }
        for (int intPlugIn = 0; intPlugIn < o_LAN_Universe.getLAN_PlugInCount(); ++intPlugIn) {
            o_LAN_PlugIn_In = o_LAN_Universe.getLAN_PlugIn(intPlugIn);
            if (o_LAN_PlugIn_In == null || (o_LAN_Device = o_LAN_PlugIn_In.getLAN_Device()) == null || !(o_LAN_Device instanceof LAN_Device_ArtNet)) continue;
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
            if (p_RemoteInetAddressUDP != null) {
                if (!p_RemoteInetAddressUDP.getHostAddress().equals(o_LAN_Device_ArtNet.getRemoteIP())) continue;
                o_LAN_PlugIn_In.setConnectionStatus(5);
            }
            o_LAN_Device_ArtNet.resetMissedPolls(o_LAN_PlugIn_In);
        }
        if (o_LAN_Universe.getDMXHardwarePluginFeedbackInterface() == null) {
            p_ArtDMX.close();
            return;
        }
        o_LAN_Universe.interpreteArtDMX(p_ArtDMX, p_RemoteInetAddressUDP);
        p_ArtDMX.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void interpreteArtIPProgReply(ProtocolConfiguration_ArtNet p_ProtocolConfiguration_ArtNet, ArtNet_Op_ArtIPProgReply p_ArtIPProgReply, LAN_Interface p_LAN_Interface, InetAddress p_RemoteInetAddressUDP) {
        if (p_ArtIPProgReply == null) {
            return;
        }
        if (p_LAN_Interface == null) {
            return;
        }
        Object object = s_SynInterprete;
        synchronized (object) {
            InetAddress o_RemoteInetAddress = p_ArtIPProgReply.getIP4Address();
            ArrayList<LAN_Device_ArtNet> o_LAN_Devices = p_LAN_Interface.getLAN_Devices_ArtNet_ByIP(o_RemoteInetAddress.getHostAddress(), null);
            if (o_LAN_Devices.size() != 1) {
                p_ArtIPProgReply.close();
                return;
            }
            LAN_Device_ArtNet o_LAN_Device_ArtNet = o_LAN_Devices.get(0);
            if (o_LAN_Device_ArtNet == null) {
                return;
            }
            o_LAN_Device_ArtNet.setIPProgrammable(true);
            o_LAN_Device_ArtNet.setRemoteSubNetMask(p_ArtIPProgReply.getSubNetMask());
            Byte byteStatus = p_ArtIPProgReply.getStatus();
            if ((byteStatus & 0x40) > 0) {
                o_LAN_Device_ArtNet.setRemoteDHCP(true);
            } else {
                o_LAN_Device_ArtNet.setRemoteDHCP(false);
            }
        }
        p_ArtIPProgReply.close();
    }

    public LAN_Device_ArtNet(LAN_Interface p_LAN_Interface) {
        super(p_LAN_Interface);
        this.initMembers();
    }

    private void initMembers() {
        this.m_MacAddress = null;
        this.m_ProtocolType = 1;
        this.m_BindIndexStructures = new HashMap();
        this.m_RemoteSubNetMask = new byte[4];
        for (int intByte = 0; intByte < 4; ++intByte) {
            this.m_RemoteSubNetMask[intByte] = 0;
        }
        this.m_RemoteDHCP_Capable = false;
        this.m_RemoteDHCP = false;
        this.m_IPProgrammable = false;
        this.m_Status1 = 0;
        this.m_Status2 = 0;
        this.m_ChangeProtocolCapable = false;
        this.m_MissedPolls = 0;
        this.m_ReceivedArtPollReply = -1;
        this.m_ProtocolConfigurationDetected = null;
        this.m_ArtNet_Op_ArtIPProg = ArtNet_Op_ArtIPProg.getFromPool();
        this.m_ArtNet_Op_ArtAddress = ArtNet_Op_ArtAddress.getFromPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.m_SyncBindIndex;
        synchronized (object) {
            Iterator<Integer> o_Iterator = this.m_BindIndexStructures.keySet().iterator();
            while (o_Iterator.hasNext()) {
                int intBindIndex = o_Iterator.next();
                BindIndexStructure o_BindIndexStructure = this.m_BindIndexStructures.get(intBindIndex);
                if (o_BindIndexStructure != null) {
                    o_BindIndexStructure.close();
                }
                o_Iterator.remove();
            }
        }
        this.setStatus1((byte)0);
        this.setStatus2((byte)0);
        this.setMACAddress("");
        this.m_ArtNet_Op_ArtIPProg.close();
        this.m_ArtNet_Op_ArtAddress.close();
        super.close();
    }

    @Override
    public void removeLAN_PlugIn(LAN_PlugIn p_LAN_PlugIn) {
        if (p_LAN_PlugIn == null) {
            return;
        }
        BindIndexStructure o_BindIndexStructure = this.getBindIndexStructure(p_LAN_PlugIn.getBindIndex());
        if (o_BindIndexStructure != null) {
            o_BindIndexStructure.removeLAN_PlugIn(p_LAN_PlugIn);
        }
        super.removeLAN_PlugIn(p_LAN_PlugIn);
    }

    public void setProtocolConfigurationDetected(ProtocolConfiguration_ArtNet p_ProtocolConfiguration_ArtNet) {
        this.m_ProtocolConfigurationDetected = p_ProtocolConfiguration_ArtNet;
    }

    public ProtocolConfiguration_ArtNet getProtocolConfigurationDetected() {
        return this.m_ProtocolConfigurationDetected;
    }

    @Override
    public void setID(String p_ID) {
        if (p_ID == null) {
            return;
        }
        if (p_ID.equals(this.m_ID)) {
            return;
        }
        String oldValue = this.m_ID;
        this.m_ID = p_ID;
    }

    public void setMACAddress(String p_MacAddress) {
        if (p_MacAddress == null) {
            return;
        }
        if (p_MacAddress.equals(this.m_MacAddress)) {
            return;
        }
        String oldValue = this.m_MacAddress;
        this.m_MacAddress = p_MacAddress;
    }

    public String getMacAddress() {
        return this.m_MacAddress;
    }

    public void setLocalAddress(String p_LocalIP, int p_LocalPort) {
        InetAddress o_InetAddress;
        if (p_LocalIP == null) {
            // empty if block
        }
        try {
            o_InetAddress = InetAddress.getByName(p_LocalIP);
        }
        catch (Exception e) {
            o_InetAddress = null;
        }
        this.setLocalAddress(o_InetAddress, p_LocalPort);
    }

    public void setLocalAddress(InetAddress p_LocalInetAddress, int p_LocalPort) {
        if (this.m_LAN_Interface == null) {
            return;
        }
        boolean boolChanged = false;
        InetAddress oldValue = this.m_LocalInetAddress;
        if (!NetworkTool.isEqual((InetAddress)this.m_LocalInetAddress, (InetAddress)p_LocalInetAddress)) {
            boolChanged = true;
            this.m_LocalInetAddress = p_LocalInetAddress;
            this.m_LocalPort = p_LocalPort;
            this.m_LocalIPAddress = this.m_LocalInetAddress == null ? "" : this.m_LocalInetAddress.getHostAddress();
        }
        if (this.m_LocalPort != p_LocalPort) {
            boolChanged = true;
            this.m_LocalPort = p_LocalPort;
        }
        if (boolChanged) {
            // empty if block
        }
    }

    public String getRemoteIP() {
        return this.m_RemoteIPAddress;
    }

    public InetAddress getRemoteInetAddress() {
        return this.m_RemoteInetAddress;
    }

    public void setRemotePort(int p_PortNumber) {
        if (p_PortNumber < 0) {
            return;
        }
        if (this.m_RemotePort == p_PortNumber) {
            return;
        }
        this.setRemoteAddress(this.m_RemoteInetAddress, p_PortNumber);
    }

    public int getRemotePort() {
        return this.m_RemotePort;
    }

    public void setRemoteAddress(String p_RemoteIP, int p_RemotePort) {
        InetAddress o_InetAddress;
        try {
            o_InetAddress = InetAddress.getByName(p_RemoteIP);
        }
        catch (Exception e) {
            o_InetAddress = null;
        }
        this.setRemoteAddress(o_InetAddress, p_RemotePort);
    }

    public void setRemoteAddress(InetAddress p_InetAddress, int p_Port) {
        if (this.m_LAN_Interface == null) {
            return;
        }
        InetAddress oldValue = this.m_RemoteInetAddress;
        boolean boolChanged = false;
        if (!NetworkTool.isEqual((InetAddress)this.m_RemoteInetAddress, (InetAddress)p_InetAddress)) {
            boolChanged = true;
            this.m_RemoteInetAddress = p_InetAddress;
            this.m_RemotePort = p_Port;
            if (this.m_RemoteInetAddress == null) {
                this.m_RemoteIPAddress = "";
                this.m_RemoteInetAddressIsMulticast = false;
            } else {
                this.m_RemoteIPAddress = this.m_RemoteInetAddress.getHostAddress();
                this.m_RemoteInetAddressIsMulticast = this.m_RemoteInetAddress.isMulticastAddress();
            }
        }
        if (this.m_RemotePort != p_Port) {
            boolChanged = true;
            this.m_RemotePort = p_Port;
        }
        if (boolChanged) {
            this.m_PropertyChangeSupport.firePropertyChange("prop_deviceartnetip", oldValue, this.m_RemoteInetAddress);
        }
    }

    public boolean isRemoteMulticastAddress() {
        return this.m_RemoteInetAddressIsMulticast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBindIndexStructure(int p_BindIndex, BindIndexStructure p_BindIndexStructure) {
        Object object = this.m_SyncBindIndex;
        synchronized (object) {
            BindIndexStructure o_OldValue = this.m_BindIndexStructures.get(p_BindIndex);
            this.m_BindIndexStructures.put(p_BindIndex, p_BindIndexStructure);
            this.m_PropertyChangeSupport.fireIndexedPropertyChange("prop_deviceartnetbindindexstructure", p_BindIndex, o_OldValue, p_BindIndexStructure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindIndexStructure getBindIndexStructure(int p_BindIndex) {
        Object object = this.m_SyncBindIndex;
        synchronized (object) {
            return this.m_BindIndexStructures.get(p_BindIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBindIndexStructure(int p_BindIndex) {
        Object object = this.m_SyncBindIndex;
        synchronized (object) {
            BindIndexStructure o_BindIndexStructure = this.m_BindIndexStructures.get(p_BindIndex);
            if (o_BindIndexStructure == null) {
                return;
            }
            o_BindIndexStructure.close();
            this.m_BindIndexStructures.remove(p_BindIndex);
            this.m_PropertyChangeSupport.fireIndexedPropertyChange("prop_deviceartnetbindindexstructure", p_BindIndex, o_BindIndexStructure, null);
        }
    }

    public void setRemoteSubNetMask(byte[] p_SubNetMask) {
        boolean boolChanged = false;
        byte[] oldValue = (byte[])this.m_RemoteSubNetMask.clone();
        if (p_SubNetMask == null || p_SubNetMask.length != 4) {
            return;
        }
        for (int intByte = 0; intByte < 4; ++intByte) {
            if (this.m_RemoteSubNetMask[intByte] == p_SubNetMask[intByte]) continue;
            this.m_RemoteSubNetMask[intByte] = p_SubNetMask[intByte];
            boolChanged = true;
        }
        if (boolChanged) {
            this.m_PropertyChangeSupport.firePropertyChange("prop_deviceartnetsubnetmask", oldValue, this.m_RemoteSubNetMask);
        }
    }

    public byte[] getRemoteSubNetMask() {
        return this.m_RemoteSubNetMask;
    }

    public void setRemoteDHCP_Capable(boolean p_DHCP_Capable) {
        if (this.m_RemoteDHCP_Capable == p_DHCP_Capable) {
            return;
        }
        boolean oldValue = this.m_RemoteDHCP_Capable;
        this.m_RemoteDHCP_Capable = p_DHCP_Capable;
        this.m_PropertyChangeSupport.firePropertyChange("prop_deviceartnetdhcp_capable", oldValue, this.m_RemoteDHCP_Capable);
    }

    public boolean getRemoteDHCP_Capable() {
        return this.m_RemoteDHCP_Capable;
    }

    public void setRemoteDHCP(boolean p_UseDHCP) {
        if (this.m_RemoteDHCP == p_UseDHCP) {
            return;
        }
        boolean oldValue = this.m_RemoteDHCP;
        this.m_RemoteDHCP = p_UseDHCP;
        this.m_PropertyChangeSupport.firePropertyChange("prop_deviceartnetdhcp_used", oldValue, this.m_RemoteDHCP_Capable);
    }

    public boolean getRemoteDHCP() {
        return this.m_RemoteDHCP;
    }

    public void setChangeProtocol_Capable(boolean p_ChangeProtocolChangable) {
        if (this.m_ChangeProtocolCapable == p_ChangeProtocolChangable) {
            return;
        }
        boolean oldValue = this.m_ChangeProtocolCapable;
        this.m_ChangeProtocolCapable = p_ChangeProtocolChangable;
        this.m_PropertyChangeSupport.firePropertyChange("prop_deviceartnetchangeprotocol_capable", oldValue, this.m_RemoteDHCP_Capable);
    }

    public boolean getChangeProtocol_Capable() {
        return this.m_ChangeProtocolCapable;
    }

    public ArtNet_Op_ArtIPProg getArtNet_Op_ArtIPProg() {
        return this.m_ArtNet_Op_ArtIPProg;
    }

    public void setIPProgrammable(boolean p_IPProgrammable) {
        if (this.m_IPProgrammable == p_IPProgrammable) {
            return;
        }
        boolean oldValue = this.m_IPProgrammable;
        this.m_IPProgrammable = p_IPProgrammable;
        this.m_PropertyChangeSupport.firePropertyChange("prop_deviceartnetipprogrammable", oldValue, this.m_IPProgrammable);
    }

    public boolean getIPProgrammable() {
        return this.m_IPProgrammable;
    }

    @Override
    public void setConnectionStatus(int p_ConnectionStatus) {
        super.setConnectionStatus(p_ConnectionStatus);
    }

    public ArtNet_Op_ArtAddress getArtNet_Op_ArtAddress() {
        return this.m_ArtNet_Op_ArtAddress;
    }

    public void setStatus1(byte p_Status1) {
        if (this.m_Status1 != p_Status1) {
            byte oldValue = this.m_Status1;
            this.m_Status1 = p_Status1;
            this.m_PropertyChangeSupport.firePropertyChange("prop_deviceartnetstatus1", oldValue, p_Status1);
        }
    }

    public byte getStatus1() {
        return this.m_Status1;
    }

    public void setStatus2(byte p_Status2) {
        if (this.m_Status2 != p_Status2) {
            byte oldValue = this.m_Status2;
            this.m_Status2 = p_Status2;
            if ((p_Status2 & 2) > 0) {
                this.setRemoteDHCP(true);
            } else {
                this.setRemoteDHCP(false);
            }
            if ((p_Status2 & 4) > 0) {
                this.setRemoteDHCP_Capable(true);
            } else {
                this.setRemoteDHCP_Capable(false);
            }
            if ((p_Status2 & 0x10) > 0) {
                this.setChangeProtocol_Capable(true);
            } else {
                this.setChangeProtocol_Capable(false);
            }
            this.m_PropertyChangeSupport.firePropertyChange("prop_deviceartnetstatus2", oldValue, p_Status2);
        }
    }

    public byte getStatus2() {
        return this.m_Status2;
    }

    public static int calculateUniverseNumber(byte p_NetSwitch, byte p_SubSwitch, byte p_SW) {
        int intUniverseNumber = 0;
        intUniverseNumber += (p_NetSwitch & 0x7F) << 8;
        intUniverseNumber += (p_SubSwitch & 0xF) << 4;
        return intUniverseNumber += p_SW & 0xF;
    }

    @Override
    public int getBindIndex(LAN_PlugIn p_LAN_PlugIn) {
        if (p_LAN_PlugIn == null) {
            return -1;
        }
        return p_LAN_PlugIn.getBindIndex();
    }

    @Override
    public int getPortIndex(LAN_PlugIn p_LAN_PlugIn) {
        if (p_LAN_PlugIn == null) {
            return -1;
        }
        int intBindexIndex = p_LAN_PlugIn.getBindIndex();
        BindIndexStructure o_BindIndexStructure = this.getBindIndexStructure(intBindexIndex);
        if (o_BindIndexStructure == null) {
            return -1;
        }
        return o_BindIndexStructure.getPortIndex(p_LAN_PlugIn);
    }

    public void cyclePollStarted() {
        EventQueue.invokeLater(this.m_RunnablePollStarted);
    }

    public void cyclePollEnded() {
        EventQueue.invokeLater(this.m_RunnablePollEnded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseMissedPolls() {
        ++this.m_MissedPolls;
        Object object = this.m_SyncBindIndex;
        synchronized (object) {
            for (int intBindIndex : this.m_BindIndexStructures.keySet()) {
                BindIndexStructure o_BindIndexStructure = this.getBindIndexStructure(intBindIndex);
                if (o_BindIndexStructure == null) continue;
                for (int intByteIndex = 0; intByteIndex < 4; ++intByteIndex) {
                    LAN_PlugIn o_LAN_PlugIn = o_BindIndexStructure.getLAN_PlugIn_In(intByteIndex);
                    if (o_LAN_PlugIn == null) continue;
                    o_LAN_PlugIn.increaseMissedPolls();
                }
            }
        }
    }

    public void resetMissedPolls(LAN_PlugIn p_LAN_PlugIn) {
        this.m_MissedPolls = 0;
        if (p_LAN_PlugIn != null) {
            p_LAN_PlugIn.resetMissedPolls();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMissedPolls() {
        if (this.m_MissedPolls >= MISSEDPOOLS_MAX) {
            this.close();
            return;
        }
        Object o_LAN_PlugIns = null;
        Object object = this.m_SyncBindIndex;
        synchronized (object) {
            Iterator<Integer> o_Iterator = this.m_BindIndexStructures.keySet().iterator();
            while (o_Iterator.hasNext()) {
                int intBindIndex = o_Iterator.next();
                BindIndexStructure o_BindIndexStructure = this.getBindIndexStructure(intBindIndex);
                if (o_BindIndexStructure == null) continue;
                int intCountValidLAN_Plugin = 0;
                for (int intByteIndex = 0; intByteIndex < 4; ++intByteIndex) {
                    LAN_PlugIn o_LAN_PlugIn = o_BindIndexStructure.getLAN_PlugIn_Out(intByteIndex);
                    if (o_LAN_PlugIn != null) {
                        ++intCountValidLAN_Plugin;
                    }
                    if ((o_LAN_PlugIn = o_BindIndexStructure.getLAN_PlugIn_In(intByteIndex)) == null) continue;
                    if (o_LAN_PlugIn.getMissedPolls() >= MISSEDPOOLS_MAX) {
                        o_BindIndexStructure.removeLAN_PlugIn(o_LAN_PlugIn);
                        continue;
                    }
                    ++intCountValidLAN_Plugin;
                }
                if (intCountValidLAN_Plugin > 0) continue;
                int intBindindex = o_BindIndexStructure.getBindIndex();
                o_BindIndexStructure.close();
                o_Iterator.remove();
                this.m_PropertyChangeSupport.fireIndexedPropertyChange("prop_deviceartnetbindindexstructure", intBindIndex, o_BindIndexStructure, null);
            }
        }
    }

    public int getMissedPolls() {
        return this.m_MissedPolls;
    }

    public void setArtPollReplyReceived(int p_BindIndex) {
        this.m_ReceivedArtPollReply = p_BindIndex;
    }

    public int getArtPollReplyReceived() {
        return this.m_ReceivedArtPollReply;
    }

    public void notifyPropertyChanged(String p_PropertyName, Object p_OldValue, Object p_NewValue) {
        this.m_PropertyChangeSupport.firePropertyChange(p_PropertyName, p_OldValue, p_NewValue);
    }

    public void notifyIndexedPropertyChanged(String p_PropertyName, int p_Index, Object p_OldValue, Object p_NewValue) {
        this.m_PropertyChangeSupport.fireIndexedPropertyChange(p_PropertyName, p_Index, p_OldValue, p_NewValue);
    }

    public static class BindIndexStructure {
        private LAN_Device_ArtNet m_LAN_Device_ArtNet;
        private int m_BindIndex;
        private String m_ShortName;
        private String m_LongName;
        private byte m_UniverseNetSwitch;
        private byte m_UniverseSubSwitch;
        private int m_PortCount;
        private byte[] m_PortTypes;
        private byte[] m_GoodOutputs;
        private byte[] m_GoodInputs;
        private byte[] m_SWOuts;
        private byte[] m_SWIns;
        private LAN_PlugIn[] m_LAN_PlugIns_Out;
        private LAN_PlugIn[] m_LAN_PlugIns_In;
        private boolean m_IsVirtual;

        public BindIndexStructure(LAN_Device_ArtNet p_LAN_Device_ArtNet, int p_BindIndex) {
            this.initMembers();
            this.m_LAN_Device_ArtNet = p_LAN_Device_ArtNet;
            this.m_BindIndex = p_BindIndex;
            if (this.m_LAN_Device_ArtNet != null) {
                this.m_LAN_Device_ArtNet.putBindIndexStructure(this.m_BindIndex, this);
            }
        }

        private void initMembers() {
            this.m_LAN_Device_ArtNet = null;
            this.m_IsVirtual = false;
            this.m_ShortName = "";
            this.m_LongName = "";
            this.m_UniverseNetSwitch = 0;
            this.m_UniverseSubSwitch = 0;
            this.m_PortTypes = new byte[4];
            this.m_GoodOutputs = new byte[4];
            this.m_GoodInputs = new byte[4];
            this.m_SWOuts = new byte[4];
            this.m_SWIns = new byte[4];
            this.m_LAN_PlugIns_Out = new LAN_PlugIn[4];
            this.m_LAN_PlugIns_In = new LAN_PlugIn[4];
            for (int intByteIndex = 0; intByteIndex < 4; ++intByteIndex) {
                this.m_PortTypes[intByteIndex] = 0;
                this.m_GoodOutputs[intByteIndex] = 0;
                this.m_GoodInputs[intByteIndex] = 0;
                this.m_SWOuts[intByteIndex] = 0;
                this.m_SWIns[intByteIndex] = 0;
                this.m_LAN_PlugIns_Out[intByteIndex] = null;
                this.m_LAN_PlugIns_In[intByteIndex] = null;
            }
        }

        public void close() {
            for (int intByteIndex = 3; intByteIndex >= 0; --intByteIndex) {
                LAN_PlugIn o_LAN_PlugIn = this.m_LAN_PlugIns_In[intByteIndex];
                if (o_LAN_PlugIn != null) {
                    o_LAN_PlugIn.close();
                }
                if ((o_LAN_PlugIn = this.m_LAN_PlugIns_In[intByteIndex]) != null) {
                    o_LAN_PlugIn.close();
                }
                this.m_PortTypes[intByteIndex] = 0;
                this.m_SWOuts[intByteIndex] = 0;
                this.m_SWIns[intByteIndex] = 0;
                this.setPortCount(0);
                this.setGoodOutput(intByteIndex, (byte)0);
                this.setGoodInput(intByteIndex, (byte)0);
                this.setUniverseNetSwitch((byte)0);
                this.setUniverseSubSwitch((byte)0);
            }
        }

        public LAN_Device_ArtNet getLAN_Device_ArtNet() {
            return this.m_LAN_Device_ArtNet;
        }

        public int getBindIndex() {
            return this.m_BindIndex;
        }

        public String getShortName() {
            return this.m_ShortName;
        }

        public boolean setShortName(String p_NodeName) {
            if (p_NodeName == null) {
                return false;
            }
            String stringOldVale = this.m_ShortName;
            if (this.m_ShortName.equals(p_NodeName)) {
                return false;
            }
            this.m_ShortName = p_NodeName;
            this.fireIndexedPropertyChange("prop_deviceartnetnodename", this.m_BindIndex, stringOldVale, this.m_ShortName);
            return true;
        }

        public String getLongName() {
            return this.m_LongName;
        }

        public boolean setLongName(String p_NodeName) {
            if (p_NodeName == null) {
                return false;
            }
            String stringOldVale = this.m_LongName;
            if (this.m_LongName.equals(p_NodeName)) {
                return false;
            }
            this.m_LongName = p_NodeName;
            this.fireIndexedPropertyChange("prop_deviceartnetnodename", this.m_BindIndex, stringOldVale, this.m_LongName);
            return true;
        }

        public void setIsVirtual(boolean p_IsVirtual) {
            this.m_IsVirtual = p_IsVirtual;
        }

        public boolean getIsVirtual() {
            return this.m_IsVirtual;
        }

        public boolean setUniverseNetSwitch(byte p_NetSwitch) {
            if (this.m_UniverseNetSwitch == p_NetSwitch) {
                return false;
            }
            byte oldValue = this.m_UniverseNetSwitch;
            this.m_UniverseNetSwitch = p_NetSwitch;
            this.firePropertyChange("prop_deviceartnetuniversenet", oldValue, this.m_UniverseNetSwitch);
            return true;
        }

        public byte getUniverseNetSwitch() {
            return this.m_UniverseNetSwitch;
        }

        public boolean setUniverseSubSwitch(byte p_SubSwitch) {
            if (this.m_UniverseSubSwitch == p_SubSwitch) {
                return false;
            }
            byte oldValue = this.m_UniverseSubSwitch;
            this.m_UniverseSubSwitch = p_SubSwitch;
            this.firePropertyChange("prop_deviceartnetuniversenet", oldValue, this.m_UniverseNetSwitch);
            return true;
        }

        public byte getUniverseSubSwitch() {
            return this.m_UniverseSubSwitch;
        }

        public void setPortCount(int p_PortCount) {
            this.m_PortCount = p_PortCount;
        }

        public int getPortCount() {
            return this.m_PortCount;
        }

        public boolean setPortTypes_SWInOuts(byte[] p_PortTypes, byte[] p_SWOuts, byte[] p_SWIns) {
            if (p_PortTypes == null) {
                return false;
            }
            if (p_SWOuts == null) {
                return false;
            }
            if (p_SWIns == null) {
                return false;
            }
            boolean boolChanged = false;
            int intByteLength = p_PortTypes.length;
            for (int intByte = 0; intByte < intByteLength; ++intByte) {
                if (!this.setPortType_SWInOut(intByte, p_PortTypes[intByte], p_SWOuts[intByte], p_SWIns[intByte])) continue;
                boolChanged = true;
            }
            return boolChanged;
        }

        public boolean setPortType_SWInOut(int p_ByteIndex, byte p_PortType, byte p_SWOut, byte p_SWIn) {
            LAN_PlugIn o_LAN_PlugIn;
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return false;
            }
            boolean boolAcceptPortType = false;
            boolean boolWasDisabled = true;
            boolean boolWasOutput = false;
            boolean boolWasInput = false;
            boolean boolIsOutput = false;
            boolean boolIsDisabled = true;
            boolean boolIsInput = false;
            int intOldUniverseNumber_Out = -1;
            int intNewUniverseNumber_Out = -1;
            int intOldUniverseNumber_In = -1;
            int intNewUniverseNumber_In = -1;
            LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
            LAN_Interface o_LAN_Interface = null;
            o_LAN_Device_ArtNet = this.m_LAN_Device_ArtNet;
            if (o_LAN_Device_ArtNet != null) {
                o_LAN_Interface = o_LAN_Device_ArtNet.getLAN_Interface();
            }
            if (o_LAN_Interface == null) {
                return false;
            }
            boolean boolChanged = false;
            if ((p_PortType & 0x3F) == 0 || (p_PortType & 0x3F) == 5) {
                boolAcceptPortType = true;
            }
            if (!boolAcceptPortType) {
                return false;
            }
            if ((p_PortType & 0x3F) == 0 || (p_PortType & 0x3F) == 5) {
                boolAcceptPortType = true;
            }
            if (!boolAcceptPortType) {
                return false;
            }
            byte oldValue_PortType = this.m_PortTypes[p_ByteIndex];
            byte oldValue_SWOut = this.m_SWOuts[p_ByteIndex];
            byte oldValue_SWIn = this.m_SWIns[p_ByteIndex];
            if ((this.m_PortTypes[p_ByteIndex] & 0x80) > 0) {
                boolWasOutput = true;
                boolWasDisabled = false;
            }
            if ((this.m_PortTypes[p_ByteIndex] & 0x40) > 0) {
                boolWasInput = true;
                boolWasDisabled = false;
            }
            this.m_PortTypes[p_ByteIndex] = p_PortType;
            if ((this.m_PortTypes[p_ByteIndex] & 0x80) > 0) {
                boolIsOutput = true;
                boolIsDisabled = false;
            }
            if ((this.m_PortTypes[p_ByteIndex] & 0x40) > 0) {
                boolIsInput = true;
                boolIsDisabled = false;
            }
            if (boolIsDisabled && !boolWasDisabled) {
                o_LAN_PlugIn = this.m_LAN_PlugIns_Out[p_ByteIndex];
                if (o_LAN_PlugIn != null) {
                    o_LAN_PlugIn.close();
                    this.m_LAN_PlugIns_Out[p_ByteIndex] = null;
                }
                if ((o_LAN_PlugIn = this.m_LAN_PlugIns_In[p_ByteIndex]) != null) {
                    o_LAN_PlugIn.close();
                    this.m_LAN_PlugIns_In[p_ByteIndex] = null;
                }
                boolChanged = true;
            }
            this.m_PortTypes[p_ByteIndex] = p_PortType;
            if (boolIsOutput) {
                if (boolWasInput && (o_LAN_PlugIn = this.m_LAN_PlugIns_In[p_ByteIndex]) != null) {
                    o_LAN_PlugIn.close();
                    this.m_LAN_PlugIns_In[p_ByteIndex] = null;
                }
                intOldUniverseNumber_Out = LAN_Device_ArtNet.calculateUniverseNumber(this.m_UniverseNetSwitch, this.m_UniverseSubSwitch, this.m_SWOuts[p_ByteIndex]);
                intNewUniverseNumber_Out = LAN_Device_ArtNet.calculateUniverseNumber(this.m_UniverseNetSwitch, this.m_UniverseSubSwitch, p_SWOut);
                this.m_SWOuts[p_ByteIndex] = p_SWOut;
                o_LAN_PlugIn = this.m_LAN_PlugIns_Out[p_ByteIndex];
                if (o_LAN_PlugIn == null) {
                    this.m_LAN_PlugIns_Out[p_ByteIndex] = o_LAN_PlugIn = this.createLAN_Plugin_Out(p_ByteIndex);
                    o_LAN_PlugIn.setLanUniverseNumber(intNewUniverseNumber_Out);
                    o_LAN_PlugIn.setConnectionStatus(5);
                    this.addLAN_Plugin_Out(p_ByteIndex, o_LAN_PlugIn);
                    boolChanged = true;
                } else if (o_LAN_PlugIn.getLAN_UniverseNumber() == intNewUniverseNumber_Out) {
                    o_LAN_PlugIn.setConnectionStatus(5);
                } else {
                    o_LAN_PlugIn.setLanUniverseNumber(intNewUniverseNumber_Out);
                    o_LAN_PlugIn.setConnectionStatus(5);
                    boolChanged = true;
                }
                o_LAN_Device_ArtNet.resetMissedPolls(o_LAN_PlugIn);
            }
            if (boolIsInput) {
                if (boolWasOutput && (o_LAN_PlugIn = this.m_LAN_PlugIns_Out[p_ByteIndex]) != null) {
                    o_LAN_PlugIn.close();
                    this.m_LAN_PlugIns_Out[p_ByteIndex] = null;
                }
                intOldUniverseNumber_In = LAN_Device_ArtNet.calculateUniverseNumber(this.m_UniverseNetSwitch, this.m_UniverseSubSwitch, this.m_SWIns[p_ByteIndex]);
                intNewUniverseNumber_In = LAN_Device_ArtNet.calculateUniverseNumber(this.m_UniverseNetSwitch, this.m_UniverseSubSwitch, p_SWIn);
                this.m_SWIns[p_ByteIndex] = p_SWIn;
                o_LAN_PlugIn = this.m_LAN_PlugIns_In[p_ByteIndex];
                if (o_LAN_PlugIn == null) {
                    LAN_Universe o_LAN_Universe;
                    if (o_LAN_Interface != null && (o_LAN_Universe = o_LAN_Interface.getLAN_Universe(intNewUniverseNumber_In, 1)) != null && (o_LAN_PlugIn = o_LAN_Universe.getLAN_PlugIn_ArtNet(o_LAN_Device_ArtNet.getRemoteIP())) != null && o_LAN_PlugIn.getIsVirtual()) {
                        o_LAN_PlugIn.close();
                    }
                    o_LAN_PlugIn = this.createLAN_Plugin_In(p_ByteIndex);
                    o_LAN_PlugIn.setIsVirtual(false);
                    o_LAN_PlugIn.setLanUniverseNumber(intNewUniverseNumber_In);
                    o_LAN_PlugIn.setConnectionStatus(5);
                    this.addLAN_Plugin_In(p_ByteIndex, o_LAN_PlugIn);
                    boolChanged = true;
                } else if (o_LAN_PlugIn.getLAN_UniverseNumber() == intNewUniverseNumber_In) {
                    o_LAN_PlugIn.setConnectionStatus(5);
                } else {
                    o_LAN_PlugIn.setLanUniverseNumber(intNewUniverseNumber_In);
                    o_LAN_PlugIn.setConnectionStatus(5);
                    boolChanged = true;
                }
                o_LAN_Device_ArtNet.resetMissedPolls(o_LAN_PlugIn);
            }
            this.fireIndexedPropertyChange("prop_deviceartnetporttypes", p_ByteIndex, oldValue_PortType, this.m_PortTypes[p_ByteIndex]);
            this.fireIndexedPropertyChange("prop_deviceartnetswouts", p_ByteIndex, oldValue_SWOut, this.m_SWOuts[p_ByteIndex]);
            this.fireIndexedPropertyChange("prop_deviceartnetswouts", p_ByteIndex, oldValue_SWIn, this.m_SWIns[p_ByteIndex]);
            return boolChanged;
        }

        public byte getPortType(int p_ByteIndex) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return 0;
            }
            return this.m_PortTypes[p_ByteIndex];
        }

        public boolean setPortType(int p_ByteIndex, boolean p_IsOutput, boolean p_IsInput) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return false;
            }
            byte bytePortType_Old = this.m_PortTypes[p_ByteIndex];
            byte bytePortType_New = 0;
            if (p_IsOutput) {
                bytePortType_New = (byte)(bytePortType_New | 0x80);
            }
            if (p_IsInput) {
                bytePortType_New = (byte)(bytePortType_New | 0x40);
            }
            if (bytePortType_New != bytePortType_Old) {
                this.m_PortTypes[p_ByteIndex] = bytePortType_New;
                this.fireIndexedPropertyChange("prop_deviceartnetporttypes", p_ByteIndex, bytePortType_Old, bytePortType_New);
                return true;
            }
            return false;
        }

        public void checkArtNetPortTypes() {
            LAN_Device_ArtNet o_LAN_Device_ArtNet = this.m_LAN_Device_ArtNet;
            for (int intByteIndex = 0; intByteIndex < 4; ++intByteIndex) {
                int intLANUniverseNumber;
                LAN_PlugIn o_LAN_PlugIn = this.m_LAN_PlugIns_Out[intByteIndex];
                if (o_LAN_PlugIn != null) {
                    intLANUniverseNumber = LAN_Device_ArtNet.calculateUniverseNumber(this.m_UniverseNetSwitch, this.m_UniverseSubSwitch, this.getSWOut(intByteIndex));
                    o_LAN_PlugIn.setLanUniverseNumber(intLANUniverseNumber);
                    o_LAN_PlugIn.setConnectionStatus(5);
                }
                if ((o_LAN_PlugIn = this.m_LAN_PlugIns_In[intByteIndex]) == null) continue;
                intLANUniverseNumber = LAN_Device_ArtNet.calculateUniverseNumber(this.m_UniverseNetSwitch, this.m_UniverseSubSwitch, this.getSWIn(intByteIndex));
                o_LAN_PlugIn.setLanUniverseNumber(intLANUniverseNumber);
                o_LAN_PlugIn.setConnectionStatus(5);
            }
        }

        public boolean setGoodOutputs(byte[] p_GoodOutputs) {
            boolean boolChanged = false;
            int intByteLength = this.m_GoodOutputs.length > p_GoodOutputs.length ? p_GoodOutputs.length : this.m_GoodOutputs.length;
            for (int intByteIndex = 0; intByteIndex < intByteLength; ++intByteIndex) {
                if (!this.setGoodOutput(intByteIndex, p_GoodOutputs[intByteIndex])) continue;
                boolChanged = true;
            }
            return boolChanged;
        }

        public boolean setGoodOutput(int p_ByteIndex, byte p_GoodOutput) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return false;
            }
            if (this.m_GoodOutputs[p_ByteIndex] == p_GoodOutput) {
                return false;
            }
            boolean boolIsOutput = true;
            byte oldValue = this.m_GoodOutputs[p_ByteIndex];
            this.m_GoodOutputs[p_ByteIndex] = p_GoodOutput;
            LAN_PlugIn o_LAN_PlugIn = this.getLAN_PlugIn_Out(p_ByteIndex);
            if (o_LAN_PlugIn != null) {
                if ((p_GoodOutput & 1) <= 0) {
                    o_LAN_PlugIn.setProtocolType(1);
                } else {
                    o_LAN_PlugIn.setProtocolType(3);
                }
                if ((p_GoodOutput & 8) <= 0) {
                    o_LAN_PlugIn.setMergeMode(0);
                } else if ((p_GoodOutput & 2) <= 0) {
                    o_LAN_PlugIn.setMergeMode(1);
                } else {
                    o_LAN_PlugIn.setMergeMode(2);
                }
            } else {
                o_LAN_PlugIn = this.getLAN_PlugIn_In(p_ByteIndex);
                if (o_LAN_PlugIn != null) {
                    if ((p_GoodOutput & 1) <= 0) {
                        o_LAN_PlugIn.setProtocolType(1);
                    } else {
                        o_LAN_PlugIn.setProtocolType(3);
                    }
                }
            }
            if (oldValue != this.m_GoodOutputs[p_ByteIndex]) {
                this.fireIndexedPropertyChange("prop_deviceartnetgoodoutputs", p_ByteIndex, oldValue, this.m_GoodOutputs[p_ByteIndex]);
                return true;
            }
            return false;
        }

        public byte getGoodOutput(int p_ByteIndex) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return 0;
            }
            return this.m_GoodOutputs[p_ByteIndex];
        }

        public boolean setGoodInputs(byte[] p_GoodInputs) {
            boolean boolChanged = false;
            int intByteLength = this.m_GoodInputs.length > p_GoodInputs.length ? p_GoodInputs.length : this.m_GoodInputs.length;
            for (int intByteIndex = 0; intByteIndex < intByteLength; ++intByteIndex) {
                if (!this.setGoodInput(intByteIndex, p_GoodInputs[intByteIndex])) continue;
                boolChanged = true;
            }
            return boolChanged;
        }

        private boolean setGoodInput(int p_ByteIndex, byte p_GoodInput) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return false;
            }
            byte oldValue = this.m_GoodInputs[p_ByteIndex];
            this.m_GoodInputs[p_ByteIndex] = p_GoodInput;
            LAN_PlugIn o_LAN_PlugIn = this.getLAN_PlugIn_In(p_ByteIndex);
            if (oldValue != p_GoodInput) {
                this.fireIndexedPropertyChange("prop_deviceartnetgoodinputs", p_ByteIndex, oldValue, this.m_GoodInputs[p_ByteIndex]);
                return true;
            }
            return false;
        }

        public byte getGoodInput(int p_ByteIndex) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return 0;
            }
            return this.m_GoodInputs[p_ByteIndex];
        }

        public int getProtocolType(int p_ByteIndex, int p_PlugInType) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return 0;
            }
            switch (p_PlugInType) {
                case 0: {
                    byte byteGood = this.getGoodOutput(p_ByteIndex);
                    if ((byteGood & 1) > 0) {
                        return 3;
                    }
                    return 1;
                }
                case 1: {
                    byte byteGood = this.getGoodOutput(p_ByteIndex);
                    if ((byteGood & 1) > 0) {
                        return 3;
                    }
                    return 1;
                }
            }
            return 0;
        }

        public boolean setProtocolType(int p_ByteIndex, int p_PlugInType, int p_ProtocolType) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return false;
            }
            if (p_ProtocolType != 1 && p_ProtocolType != 3) {
                return false;
            }
            switch (p_PlugInType) {
                case 0: {
                    byte byteGood = this.getGoodOutput(p_ByteIndex);
                    switch (p_ProtocolType) {
                        case 1: {
                            if ((byteGood & 1) <= 0) {
                                return false;
                            }
                            byteGood = (byte)(byteGood & 0xFE);
                            return this.setGoodOutput(p_ByteIndex, byteGood);
                        }
                        case 3: {
                            if ((byteGood & 1) > 0) {
                                return false;
                            }
                            byteGood = (byte)(byteGood | 1);
                            return this.setGoodOutput(p_ByteIndex, byteGood);
                        }
                    }
                    return false;
                }
                case 1: {
                    byte byteGood = this.getGoodInput(p_ByteIndex);
                    switch (p_ProtocolType) {
                        case 1: {
                            if ((byteGood & 1) <= 0) {
                                return false;
                            }
                            byteGood = (byte)(byteGood & 0xFE);
                            return this.setGoodInput(p_ByteIndex, byteGood);
                        }
                        case 3: {
                            if ((byteGood & 1) > 0) {
                                return false;
                            }
                            byteGood = (byte)(byteGood | 1);
                            return this.setGoodInput(p_ByteIndex, byteGood);
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        public byte getSWOut(int p_ByteIndex) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return -1;
            }
            return this.m_SWOuts[p_ByteIndex];
        }

        public boolean setSWIn(int p_ByteIndex, byte p_PortAdress) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return false;
            }
            byte oldValue = this.m_SWIns[p_ByteIndex];
            this.m_SWIns[p_ByteIndex] = p_PortAdress;
            this.fireIndexedPropertyChange("prop_deviceartnetswins", p_ByteIndex, oldValue, this.m_SWIns[p_ByteIndex]);
            return true;
        }

        public byte getSWIn(int p_ByteIndex) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return -1;
            }
            return this.m_SWIns[p_ByteIndex];
        }

        public LAN_PlugIn createLAN_Plugin_Out(int p_ByteIndex) {
            return this.createLAN_Plugin(p_ByteIndex, 0);
        }

        public LAN_PlugIn createLAN_Plugin_In(int p_ByteIndex) {
            return this.createLAN_Plugin(p_ByteIndex, 1);
        }

        public LAN_PlugIn createLAN_Plugin(int p_ByteIndex, int p_PlugInType) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return null;
            }
            byte bytePortAddress = 0;
            LAN_Device_ArtNet o_LAN_Device_ArtNet = this.m_LAN_Device_ArtNet;
            if (o_LAN_Device_ArtNet == null) {
                return null;
            }
            switch (p_PlugInType) {
                case 0: {
                    if (this.m_LAN_PlugIns_Out[p_ByteIndex] != null) {
                        return this.m_LAN_PlugIns_Out[p_ByteIndex];
                    }
                    bytePortAddress = this.m_SWOuts[p_ByteIndex];
                    break;
                }
                case 1: {
                    if (this.m_LAN_PlugIns_In[p_ByteIndex] != null) {
                        return this.m_LAN_PlugIns_In[p_ByteIndex];
                    }
                    bytePortAddress = this.m_SWIns[p_ByteIndex];
                    break;
                }
                default: {
                    return null;
                }
            }
            LAN_PlugIn o_LAN_PlugIn = new LAN_PlugIn(this.m_LAN_Device_ArtNet);
            o_LAN_PlugIn.setBindIndex(this.m_BindIndex);
            o_LAN_PlugIn.setPlugInType(p_PlugInType);
            o_LAN_PlugIn.setLanUniverseNumber(LAN_Device_ArtNet.calculateUniverseNumber(this.m_UniverseNetSwitch, this.m_UniverseSubSwitch, bytePortAddress));
            o_LAN_PlugIn.setProtocolType(this.getProtocolType(p_ByteIndex, p_PlugInType));
            switch (p_PlugInType) {
                case 0: {
                    this.m_LAN_PlugIns_Out[p_ByteIndex] = o_LAN_PlugIn;
                    break;
                }
                case 1: {
                    this.m_LAN_PlugIns_In[p_ByteIndex] = o_LAN_PlugIn;
                    break;
                }
                default: {
                    return null;
                }
            }
            return o_LAN_PlugIn;
        }

        public boolean addLAN_Plugin_Out(int p_ByteIndex, LAN_PlugIn p_LAN_PlugIn) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return false;
            }
            if (p_LAN_PlugIn == null) {
                return false;
            }
            LAN_Device_ArtNet o_LAN_Device_ArtNet = this.m_LAN_Device_ArtNet;
            if (o_LAN_Device_ArtNet == null) {
                return false;
            }
            this.m_LAN_PlugIns_Out[p_ByteIndex] = p_LAN_PlugIn;
            o_LAN_Device_ArtNet.addLAN_PlugIn(p_LAN_PlugIn);
            return true;
        }

        public boolean addLAN_Plugin_In(int p_ByteIndex, LAN_PlugIn p_LAN_PlugIn) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return false;
            }
            if (p_LAN_PlugIn == null) {
                return false;
            }
            LAN_Device_ArtNet o_LAN_Device_ArtNet = this.m_LAN_Device_ArtNet;
            if (o_LAN_Device_ArtNet == null) {
                return false;
            }
            this.m_LAN_PlugIns_In[p_ByteIndex] = p_LAN_PlugIn;
            o_LAN_Device_ArtNet.addLAN_PlugIn(p_LAN_PlugIn);
            return true;
        }

        public boolean removeLAN_PlugIn(LAN_PlugIn p_LAN_PlugIn) {
            LAN_Device_ArtNet o_LAN_Device_ArtNet = this.m_LAN_Device_ArtNet;
            for (int intByteIndex = 0; intByteIndex < 4; ++intByteIndex) {
                if (this.m_LAN_PlugIns_Out[intByteIndex] == p_LAN_PlugIn) {
                    this.m_LAN_PlugIns_Out[intByteIndex] = null;
                    if (o_LAN_Device_ArtNet != null) {
                        o_LAN_Device_ArtNet.removeLAN_PlugIn(p_LAN_PlugIn);
                    }
                    return true;
                }
                if (this.m_LAN_PlugIns_In[intByteIndex] != p_LAN_PlugIn) continue;
                this.m_LAN_PlugIns_In[intByteIndex] = null;
                if (o_LAN_Device_ArtNet != null) {
                    o_LAN_Device_ArtNet.removeLAN_PlugIn(p_LAN_PlugIn);
                }
                return true;
            }
            return false;
        }

        public LAN_PlugIn getLAN_PlugIn_Out(int p_ByteIndex) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return null;
            }
            return this.m_LAN_PlugIns_Out[p_ByteIndex];
        }

        public LAN_PlugIn getLAN_PlugIn_In(int p_ByteIndex) {
            if (p_ByteIndex < 0 || p_ByteIndex >= 4) {
                return null;
            }
            return this.m_LAN_PlugIns_In[p_ByteIndex];
        }

        public LAN_PlugIn getLAN_PlugIn_In_BySWIn(int p_PortAddress) {
            if (p_PortAddress < 0 || p_PortAddress >= 16) {
                return null;
            }
            for (int intByteIndex = 0; intByteIndex < 4; ++intByteIndex) {
                LAN_PlugIn o_LAN_PlugIn = this.m_LAN_PlugIns_In[intByteIndex];
                if (o_LAN_PlugIn == null || this.m_SWIns[intByteIndex] != p_PortAddress) continue;
                return o_LAN_PlugIn;
            }
            return null;
        }

        public int getPortIndex(LAN_PlugIn p_LAN_PlugIn) {
            if (p_LAN_PlugIn == null) {
                return -1;
            }
            for (int intByteIndex = 0; intByteIndex < 4; ++intByteIndex) {
                if (this.m_LAN_PlugIns_Out[intByteIndex] == p_LAN_PlugIn) {
                    return intByteIndex;
                }
                if (this.m_LAN_PlugIns_In[intByteIndex] != p_LAN_PlugIn) continue;
                return intByteIndex;
            }
            return -1;
        }

        private void firePropertyChange(String p_PropertyName, Object oldValue, Object newValue) {
            if (p_PropertyName == null) {
                return;
            }
            LAN_Device_ArtNet o_LAN_Device_ArtNet = this.m_LAN_Device_ArtNet;
            if (o_LAN_Device_ArtNet != null) {
                o_LAN_Device_ArtNet.notifyPropertyChanged(p_PropertyName, oldValue, newValue);
            }
        }

        private void fireIndexedPropertyChange(String p_PropertyName, int p_Index, Object oldValue, Object newValue) {
            if (p_PropertyName == null) {
                return;
            }
            LAN_Device_ArtNet o_LAN_Device_ArtNet = this.m_LAN_Device_ArtNet;
            if (o_LAN_Device_ArtNet != null) {
                o_LAN_Device_ArtNet.notifyIndexedPropertyChanged(p_PropertyName, p_Index, oldValue, newValue);
            }
        }
    }
}

