/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import DMXHardwarePackage.DMXHardwareInterface;
import DMXHardwarePackage.LAN_Device_ArtNet;
import DMXHardwarePackage.LAN_Interface;
import DMXHardwarePackage.LAN_Interface_Configuration;
import DMXHardwarePackage.LAN_PlugIn;
import GUIDPackage.HardwareGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import ProtocolPackage.Protocols;
import SwingModelPackage.TableAndListModel;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;

public class LAN_Device {
    public static final int SOFTWAREVERSION = 1;
    public static final String PROP_DEVICE_TYPE = "prop_devicetype";
    public static final String PROP_DEVICE_NAME = "prop_devicename";
    public static final String PROP_DEVICE_LONGNAME = "prop_devicelongname";
    public static final String PROP_DEVICE_FIRMWARE = "prop_devicefirmware";
    public static final String PROP_DEVICE_DETECTED = "prop_devicedetected";
    public static final String PROP_DEVICE_CONNECTIONSTATUS = "prop_deviceconnectionstatus";
    public static final String PROP_DEVICE_LANPLUGIN = "prop_devicelanplugin";
    public static final String PROP_DEVICE_CLOSE = "prop_deviceclose";
    public static final String PROP_DEVICEARTNET_BINDINDEXSTRUCTURE = "prop_deviceartnetbindindexstructure";
    public static final String PROP_DEVICEARTNET_IP = "prop_deviceartnetip";
    public static final String PROP_DEVICEARTNET_SUBNETMASK = "prop_deviceartnetsubnetmask";
    public static final String PROP_DEVICEARTNET_IPPROGRAMMABLE = "prop_deviceartnetipprogrammable";
    public static final String PROP_DEVICEARTNET_DHCP_CAPAPBLE = "prop_deviceartnetdhcp_capable";
    public static final String PROP_DEVICEARTNET_DHCP_USED = "prop_deviceartnetdhcp_used";
    public static final String PROP_DEVICEARTNET_CHANGEPROTOCOL_CAPAPBLE = "prop_deviceartnetchangeprotocol_capable";
    public static final String PROP_DEVICEARTNET_NODENAME = "prop_deviceartnetnodename";
    public static final String PROP_DEVICEARTNET_UNIVERSENET = "prop_deviceartnetuniversenet";
    public static final String PROP_DEVICEARTNET_UNIVERSESUB = "prop_deviceartnetuniversesub";
    public static final String PROP_DEVICEARTNET_PORTTYPES = "prop_deviceartnetporttypes";
    public static final String PROP_DEVICEARTNET_SWINS = "prop_deviceartnetswins";
    public static final String PROP_DEVICEARTNET_SWOUTS = "prop_deviceartnetswouts";
    public static final String PROP_DEVICEARTNET_GOODINPUTS = "prop_deviceartnetgoodinputs";
    public static final String PROP_DEVICEARTNET_GOODOUTPUTS = "prop_deviceartnetgoodoutputs";
    public static final String PROP_DEVICEARTNET_STATUS1 = "prop_deviceartnetstatus1";
    public static final String PROP_DEVICEARTNET_STATUS2 = "prop_deviceartnetstatus2";
    private static int s_DeviceCount = 0;
    protected LAN_Interface m_LAN_Interface;
    protected String m_ID;
    protected String m_Name;
    protected String m_LongName;
    protected byte m_FirmwareHigh;
    protected byte m_FirmwareLow;
    protected LAN_PlugIn.LAN_PluginTableModel m_LAN_PlugIns;
    protected int m_ProtocolType;
    protected int m_ConnectionStatus;
    protected PropertyChangeSupport m_PropertyChangeSupport;
    protected final Object m_SyncPlugIns = new Object();

    public LAN_Device(LAN_Interface p_LAN_Interface) {
        this(p_LAN_Interface, 0);
    }

    public LAN_Device(LAN_Interface p_LAN_Interface, int p_ProtocolType) {
        this.m_LAN_Interface = p_LAN_Interface;
        this.initMembers();
        this.m_ProtocolType = p_ProtocolType;
        if (3 == p_ProtocolType) {
            this.m_Name = Protocols.getProtocolName((int)this.m_ProtocolType) + String.valueOf(s_DeviceCount + 1);
            ++s_DeviceCount;
        }
    }

    private void initMembers() {
        this.m_ID = HardwareGUID.getUID();
        this.m_ProtocolType = 0;
        this.m_Name = "ARTNET";
        this.m_LongName = "";
        this.m_FirmwareHigh = 0;
        this.m_FirmwareLow = 0;
        this.m_LAN_PlugIns = new LAN_PlugIn.LAN_PluginTableModel();
        this.m_PropertyChangeSupport = new PropertyChangeSupport(this);
        this.m_ConnectionStatus = 0;
    }

    public void close() {
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DEVICE_CLOSE, this, null);
        for (int intIndex = this.getLAN_PlugInCount() - 1; intIndex >= 0; --intIndex) {
            LAN_PlugIn o_LAN_PlugIn = this.getLAN_PlugIn(intIndex);
            if (o_LAN_PlugIn == null) continue;
            o_LAN_PlugIn.close();
        }
        if (this.m_LAN_Interface != null) {
            this.m_LAN_Interface.removeLAN_Device(this);
        }
        this.m_LAN_Interface = null;
    }

    public void setID(String p_ID) {
        if (p_ID == null) {
            return;
        }
        this.m_ID = p_ID;
    }

    public String getID() {
        return this.m_ID;
    }

    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        if (this.m_Name.equals(p_Name)) {
            return;
        }
        String oldValue = this.m_Name;
        this.m_Name = p_Name;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DEVICE_NAME, oldValue, this.m_Name);
    }

    public String getName() {
        return this.m_Name;
    }

    public void setLongName(String p_LongName) {
        if (p_LongName == null) {
            return;
        }
        if (this.m_LongName.equals(p_LongName)) {
            return;
        }
        String oldValue = this.m_LongName;
        this.m_LongName = p_LongName;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DEVICE_LONGNAME, oldValue, this.m_LongName);
    }

    public String getLongName() {
        return this.m_LongName;
    }

    public void setFirmware(byte p_FirmwareHigh, byte p_FirmwareLow) {
        if (p_FirmwareHigh == this.m_FirmwareHigh && p_FirmwareLow == this.m_FirmwareLow) {
            return;
        }
        int oldValue = 0;
        int intNewValue = 0;
        oldValue += this.m_FirmwareHigh & 0xFF00;
        this.m_FirmwareHigh = p_FirmwareHigh;
        this.m_FirmwareLow = p_FirmwareLow;
        intNewValue += this.m_FirmwareHigh & 0xFF00;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DEVICE_FIRMWARE, oldValue += this.m_FirmwareLow & 0xFF, intNewValue += this.m_FirmwareLow & 0xFF);
    }

    public byte getFirmwareHigh() {
        return this.m_FirmwareHigh;
    }

    public byte getFirmwareLow() {
        return this.m_FirmwareLow;
    }

    private void setProtocolType(int p_ProtocolType) {
        if (this.m_ProtocolType == p_ProtocolType) {
            return;
        }
        int oldValue = this.m_ProtocolType;
        this.m_ProtocolType = p_ProtocolType;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DEVICE_TYPE, oldValue, this.m_ProtocolType);
    }

    public int getProtocolType() {
        return this.m_ProtocolType;
    }

    public String getDeviceTypeName() {
        return Protocols.getProtocolName((int)this.m_ProtocolType);
    }

    public void setConnectionStatus(int p_ConnectionStatus) {
        if (this.m_ConnectionStatus == p_ConnectionStatus) {
            return;
        }
        int oldValue = this.m_ConnectionStatus;
        this.m_ConnectionStatus = p_ConnectionStatus;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DEVICE_CONNECTIONSTATUS, oldValue, this.m_ConnectionStatus);
    }

    public int getConnectionStatus() {
        return this.m_ConnectionStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshConnectionStatus() {
        boolean boolHasChecked = false;
        boolean boolHasNotChecked = false;
        Object object = this.m_SyncPlugIns;
        synchronized (object) {
            for (int intPlugIn = 0; intPlugIn < this.getLAN_PlugInCount(); ++intPlugIn) {
                LAN_PlugIn o_LAN_PlugIn = this.getLAN_PlugIn(intPlugIn);
                if (o_LAN_PlugIn == null) continue;
                if (o_LAN_PlugIn.getConnectionStatus() == 5) {
                    boolHasChecked = true;
                    continue;
                }
                boolHasNotChecked = true;
            }
        }
        if (!boolHasChecked) {
            this.setConnectionStatus(2);
        } else if (!boolHasNotChecked) {
            this.setConnectionStatus(5);
        } else {
            this.setConnectionStatus(6);
        }
    }

    public int getBindIndex(LAN_PlugIn p_LAN_PlugIn) {
        return 1;
    }

    public int getPortIndex(LAN_PlugIn p_LAN_PlugIn) {
        if (p_LAN_PlugIn == null) {
            return -1;
        }
        return this.m_LAN_PlugIns.indexOf(p_LAN_PlugIn);
    }

    public int getPlugInIndex(LAN_PlugIn p_LAN_PlugIn) {
        if (p_LAN_PlugIn == null) {
            return -1;
        }
        return this.m_LAN_PlugIns.indexOf(p_LAN_PlugIn);
    }

    public LAN_PlugIn createLAN_Plugin() {
        LAN_PlugIn o_LAN_PlugIn = new LAN_PlugIn(this);
        this.addLAN_PlugIn(o_LAN_PlugIn);
        return o_LAN_PlugIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLAN_PlugIn(LAN_PlugIn p_LAN_PlugIn) {
        if (p_LAN_PlugIn == null) {
            return;
        }
        Object object = this.m_SyncPlugIns;
        synchronized (object) {
            LAN_PlugIn o_LAN_PlugIn;
            if (this.m_LAN_PlugIns.contains(p_LAN_PlugIn)) {
                return;
            }
            int intBindIndex = p_LAN_PlugIn.getBindIndex();
            int intPlugin = 0;
            for (intPlugin = 0; intPlugin < this.m_LAN_PlugIns.size() && ((o_LAN_PlugIn = (LAN_PlugIn)this.m_LAN_PlugIns.get(intPlugin)) == null || intBindIndex >= o_LAN_PlugIn.getBindIndex()); ++intPlugin) {
            }
            this.m_LAN_PlugIns.addLAN_PlugIn(intPlugin, p_LAN_PlugIn);
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DEVICE_LANPLUGIN, null, p_LAN_PlugIn);
        this.refreshConnectionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLAN_PlugIn(LAN_PlugIn p_LAN_PlugIn) {
        if (p_LAN_PlugIn == null) {
            return;
        }
        Object object = this.m_SyncPlugIns;
        synchronized (object) {
            int intPlugInIndex = this.m_LAN_PlugIns.indexOf(p_LAN_PlugIn);
            if (intPlugInIndex < 0) {
                return;
            }
            this.m_LAN_PlugIns.removeLAN_PlugIn(p_LAN_PlugIn);
            p_LAN_PlugIn.close();
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DEVICE_LANPLUGIN, p_LAN_PlugIn, null);
        this.refreshConnectionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LAN_PlugIn getLAN_PlugIn(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncPlugIns;
        synchronized (object) {
            return this.m_LAN_PlugIns.getLAN_PlugIn(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLAN_PlugInCount() {
        Object object = this.m_SyncPlugIns;
        synchronized (object) {
            return this.m_LAN_PlugIns.size();
        }
    }

    public LAN_PlugIn.LAN_PluginTableModel getLAN_PluginTableModel() {
        return this.m_LAN_PlugIns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        LAN_PlugIn o_LAN_PlugIn;
        int intPluginCount;
        out.writeInt(1);
        out.writeUTF(this.m_ID);
        out.writeInt(this.m_ProtocolType);
        out.writeUTF(this.m_Name);
        out.writeUTF(this.m_LongName);
        ArrayList<LAN_PlugIn> o_LAN_PlugIns = new ArrayList<LAN_PlugIn>();
        Object object = this.m_SyncPlugIns;
        synchronized (object) {
            intPluginCount = this.getLAN_PlugInCount();
            for (int intPlugin = 0; intPlugin < intPluginCount; ++intPlugin) {
                o_LAN_PlugIn = this.getLAN_PlugIn(intPlugin);
                if (o_LAN_PlugIn == null) continue;
                o_LAN_PlugIns.add(o_LAN_PlugIn);
            }
        }
        intPluginCount = o_LAN_PlugIns.size();
        out.writeInt(intPluginCount);
        for (int intPlugin = 0; intPlugin < intPluginCount; ++intPlugin) {
            o_LAN_PlugIn = (LAN_PlugIn)o_LAN_PlugIns.get(intPlugin);
            o_LAN_PlugIn.writeExternal(out);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        String stringID = in.readUTF();
        int intProtocolType = in.readInt();
        this.setProtocolType(intProtocolType);
        String stringName = in.readUTF();
        String stringLongName = in.readUTF();
        this.setProtocolType(intProtocolType);
        this.setName(stringName);
        this.setLongName(stringLongName);
        int intPlugInCount = in.readInt();
        for (int intPlugIn = 0; intPlugIn < intPlugInCount; ++intPlugIn) {
            LAN_PlugIn o_LAN_PlugIn = new LAN_PlugIn(this);
            o_LAN_PlugIn.readExternal(in);
            this.addLAN_PlugIn(o_LAN_PlugIn);
        }
    }

    public LAN_Interface getLAN_Interface() {
        return this.m_LAN_Interface;
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public static class LAN_DeviceCellRenderer
    extends DefaultTableCellRenderer {
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        protected static Border selectedBorder = new LineBorder(Color.BLUE, 2);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            StringBuilder o_StringBuilder = new StringBuilder();
            LAN_DeviceTableModel o_LAN_DeviceTableModel = (LAN_DeviceTableModel)((Object)table.getModel());
            int intRowModel = table.convertRowIndexToModel(row);
            LAN_Device o_LAN_Device = o_LAN_DeviceTableModel.getLAN_Device(intRowModel);
            JLabel o_JLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (o_LAN_Device != null) {
                switch (o_LAN_Device.getConnectionStatus()) {
                    case 5: {
                        o_JLabel.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CHECKED);
                        break;
                    }
                    case 6: {
                        o_JLabel.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_SOMECHECKED);
                        break;
                    }
                    default: {
                        o_JLabel.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONNECTED);
                    }
                }
                o_StringBuilder.append("<html>");
                o_StringBuilder.append(Protocols.getProtocolName((int)o_LAN_Device.getProtocolType()));
                o_StringBuilder.append("<br>");
                o_StringBuilder.append(o_LAN_Device.getName());
                o_StringBuilder.append("<br>");
                o_StringBuilder.append(o_LAN_Device.getLongName());
                if (o_LAN_Device instanceof LAN_Device_ArtNet) {
                    o_StringBuilder.append("<br>");
                    o_StringBuilder.append("IP: ");
                    o_StringBuilder.append(((LAN_Device_ArtNet)o_LAN_Device).getRemoteIP());
                }
                o_StringBuilder.append("</html>");
            }
            Border border = null;
            border = isSelected ? selectedBorder : noFocusBorder;
            o_JLabel.setBorder(border);
            o_JLabel.setToolTipText(o_StringBuilder.toString());
            return o_JLabel;
        }
    }

    public static class LAN_DeviceTableModel
    extends TableAndListModel<LAN_Device>
    implements PropertyChangeListener {
        public static final int COLUMNCOUNT = 3;
        public static final int COLUMNINDEX_DEVICETYPE = 0;
        public static final int COLUMNINDEX_DEVICENAME = 1;
        public static final int COLUMNINDEX_DEVICELONGNAME = 2;
        @LiveLanguageString
        public static String COLUMN_DEVICETYPE = "Type";
        @LiveLanguageString
        public static String COLUMN_DEVICENAME = "Name";
        @LiveLanguageString
        public static String COLUMN_DEVICELONGNAME = "Description";
        private HashMap<String, LAN_Device> m_LAN_Devices_ID;
        private DefaultTableCellRenderer m_DefaultTableCellRenderer;
        private final Object m_SyncObject = new Object();

        public LAN_DeviceTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, (String)LAN_Interface_Configuration.class.getSimpleName());
        }

        private void initMembers() {
            this.m_LAN_Devices_ID = new HashMap();
            this.m_DefaultTableCellRenderer = new LAN_DeviceCellRenderer();
        }

        public void finishJTable(JTable p_JTable) {
            if (p_JTable == null) {
                return;
            }
            TableRowSorter<LAN_DeviceTableModel> o_TableRowSorter = new TableRowSorter<LAN_DeviceTableModel>(this);
            o_TableRowSorter.setComparator(0, new StringComparator_Normal());
            o_TableRowSorter.setComparator(1, new StringComparator_Normal());
            o_TableRowSorter.setComparator(2, new StringComparator_Normal());
            super.finishJTable(p_JTable, o_TableRowSorter, null);
            p_JTable.getColumnModel().getColumn(1).setCellRenderer(this.m_DefaultTableCellRenderer);
            p_JTable.getColumnModel().getColumn(0).setCellRenderer(this.m_DefaultTableCellRenderer);
            p_JTable.getColumnModel().getColumn(2).setCellRenderer(this.m_DefaultTableCellRenderer);
        }

        public boolean contains(String p_ID) {
            if (p_ID == null) {
                return false;
            }
            LAN_Device o_LAN_Device = this.getLAN_Device(p_ID);
            return o_LAN_Device != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LAN_Device getLAN_Device(String p_ID) {
            if (p_ID == null) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                return this.m_LAN_Devices_ID.get(p_ID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLAN_Device(LAN_Device p_LAN_Device) {
            if (p_LAN_Device == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.add(p_LAN_Device)) {
                    this.m_LAN_Devices_ID.put(p_LAN_Device.getID(), p_LAN_Device);
                    p_LAN_Device.addPropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLAN_Device(LAN_Device p_LAN_Device) {
            if (p_LAN_Device == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.remove(p_LAN_Device)) {
                    p_LAN_Device.removePropertyChangeListener(this);
                    this.m_LAN_Devices_ID.remove(p_LAN_Device.getID());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectedLAN_Device(JTable p_JTable, LAN_Device p_LAN_Device) {
            if (p_JTable == null) {
                return;
            }
            if (p_LAN_Device == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                super.addSelectedElement(p_JTable, (Object)p_LAN_Device);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectedLAN_Device(JTable p_JTable, LAN_Device p_LAN_Device) {
            if (p_JTable == null) {
                return;
            }
            if (p_LAN_Device == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                super.remove((Object)p_LAN_Device);
            }
        }

        public LAN_Device getLAN_Device(int p_Index) {
            return (LAN_Device)this.get(p_Index);
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_DEVICETYPE;
                }
                case 1: {
                    return COLUMN_DEVICENAME;
                }
                case 2: {
                    return COLUMN_DEVICELONGNAME;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(LAN_Device p_LAN_Device, int columnIndex) {
            String stringValue = "";
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_LAN_Device == null) {
                    return stringValue;
                }
                switch (columnIndex) {
                    case 0: {
                        stringValue = p_LAN_Device.getDeviceTypeName();
                        break;
                    }
                    case 1: {
                        stringValue = p_LAN_Device.getName();
                        break;
                    }
                    case 2: {
                        stringValue = p_LAN_Device.getLongName();
                    }
                }
                return stringValue;
            }
        }

        public boolean isCellEditable(int row, int col) {
            LAN_Device o_LAN_Device = this.getLAN_Device(row);
            if (o_LAN_Device == null) {
                return false;
            }
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return 3 == o_LAN_Device.getProtocolType();
                }
                case 2: {
                    return 3 == o_LAN_Device.getProtocolType();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(LAN_Device p_LAN_Device, Object value, int col) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_LAN_Device == null) {
                    return;
                }
            }
            switch (col) {
                case 0: {
                    return;
                }
                case 1: {
                    String stringValue = (String)value;
                    p_LAN_Device.setName(stringValue);
                    break;
                }
                case 2: {
                    String stringValue = (String)value;
                    p_LAN_Device.setLongName(stringValue);
                }
            }
            this.changedElement(p_LAN_Device);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof LAN_Device) {
                LAN_Device o_LAN_Device = (LAN_Device)evt.getSource();
                Object object = this.m_SyncObject;
                synchronized (object) {
                }
                if (LAN_Device.PROP_DEVICE_DETECTED.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_Device);
                } else if (LAN_Device.PROP_DEVICE_CONNECTIONSTATUS.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_Device);
                } else if (LAN_Device.PROP_DEVICE_TYPE.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_Device);
                } else if (LAN_Device.PROP_DEVICE_NAME.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_Device);
                } else if (LAN_Device.PROP_DEVICE_LONGNAME.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_Device);
                }
            }
        }

        public static class StringComparator_NumericInteger
        implements Comparator<String> {
            @Override
            public int compare(String o1, String o2) {
                Integer int2;
                Integer int1;
                if (o1 == null || o2 == null) {
                    return 0;
                }
                try {
                    int1 = Integer.valueOf(o1);
                    int2 = Integer.valueOf(o2);
                }
                catch (Exception e) {
                    return 0;
                }
                return int1.compareTo(int2);
            }
        }

        public static class StringComparator_Normal
        implements Comparator<String> {
            @Override
            public int compare(String o1, String o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return o1.compareToIgnoreCase(o2);
            }
        }
    }
}

