/*
 * Decompiled with CFR 0.152.
 */
package ProtocolPackage;

import ACN_Direct_1_31_Package.ACN_Direct_Data_Bytes;
import ArtNetPackage.ArtNet_Op_ArtDMX;
import java.net.InetAddress;
import java.util.ArrayList;

public class Protocols {
    public static int PROTOCOL_COUNT = 4;
    public static final int UNKNOWN_PROTOCOL = 0;
    private static final String UNKNOWN_PROTOCOLNAME = "";
    public static final int ARTNET_PROTOCOL = 1;
    private static final String ARTNET_PROTOCOLNAME = "ArtNet";
    public static int ARTNET_PORT = 6454;
    public static final int ACN_1_31_PROTOCOL = 3;
    private static final String ACN_1_31_PROTOCOLNAME = "sACN";
    public static final int ACN_1_17_PROTOCOL = 4;
    private static final String ACN_1_17_PROTOCOLNAME = "ACN_1_17";
    public static int ACN_1_31_PORT = 5568;
    public static String ACN_1_31_SubnetMask = "255.255.0.0";

    public static String getProtocolName(int p_Protocol) {
        switch (p_Protocol) {
            case 1: {
                return ARTNET_PROTOCOLNAME;
            }
            case 3: {
                return ACN_1_31_PROTOCOLNAME;
            }
            case 4: {
                return ACN_1_17_PROTOCOLNAME;
            }
        }
        return UNKNOWN_PROTOCOLNAME;
    }

    public static int getProtocolFromName(String p_ProtocolName) {
        if (p_ProtocolName == null) {
            return 0;
        }
        switch (p_ProtocolName) {
            case "ArtNet": {
                return 1;
            }
            case "sACN": {
                return 3;
            }
            case "ACN_1_17": {
                return 4;
            }
        }
        return 0;
    }

    public static interface ProtocolSenderInterface {
        public byte[] getLocalUUID();
    }

    public static interface ProtocolReaderInterface {
        public void interpreteArtDMX(ArtNet_Op_ArtDMX var1, InetAddress var2);

        public void interpreteACN(ACN_Direct_Data_Bytes var1, InetAddress var2);
    }

    public static interface ProtocolPlugInInterface {
        public int getUniverseNumber();
    }

    public static interface ProtocolLANInterface {
        public byte[] getLocalUUID();

        public String getSourceName();

        public void addProblemInetAddress(InetAddress var1);

        public void removeProblemInetAddress(InetAddress var1);

        public int getProblemInetAddressCount();

        public InetAddress getProblemInetAddress(int var1);
    }

    public static abstract class ProtocolConfiguration {
        protected int m_LANProtocolType;
        protected ProtocolLANInterface m_ProtocolLANInterface;

        public ProtocolConfiguration(int p_LANProtocol, ProtocolLANInterface p_ProtocolLANInterface) {
            this.m_LANProtocolType = p_LANProtocol;
            this.m_ProtocolLANInterface = p_ProtocolLANInterface;
        }

        public int getLANProtocolType() {
            return this.m_LANProtocolType;
        }

        public ProtocolLANInterface getProtocolLANInterface() {
            return this.m_ProtocolLANInterface;
        }

        public abstract int getConnectionStatus();

        public abstract void close();

        public abstract InetAddress getLocalInetAddress();

        public abstract boolean disconnect();

        public abstract boolean writeValues(ProtocolPlugInInterface var1, InetAddress var2, int var3, ArrayList<Integer> var4, int[] var5);

        public abstract byte[] getLocalUUID();
    }
}

