/*
 * Decompiled with CFR 0.152.
 */
package ArtNetPackage;

import ArtNetPackage.ArtNetData_Bytes;
import ArtNetPackage.ArtNet_Header;
import ArtNetPackage.ArtNet_Op;
import java.util.ArrayList;

public class ArtNet_Op_ArtAddress
extends ArtNet_Op {
    public static final int OP_SIZE = 97;
    public static final int OP_CODE = 24576;
    public static final Object s_SyncPool = new Object();
    public static ArrayList<ArtNet_Op_ArtAddress> s_Pool = new ArrayList();
    private byte m_ProtocolRevision_High;
    private byte m_ProtocolRevision_Low;
    private byte m_NetSwitch;
    private byte m_BindIndex;
    private String m_Name;
    private String m_LongName;
    private byte[] m_SWIns;
    private byte[] m_SWOuts;
    private byte m_SubSwitch;
    private byte m_SWVideo;
    private byte m_Command;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtNet_Op_ArtAddress getFromPool() {
        ArtNet_Op_ArtAddress o_ArtNet_Op_ArtAddress;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_Pool.size() > 0) {
                o_ArtNet_Op_ArtAddress = s_Pool.get(s_Pool.size() - 1);
                s_Pool.remove(s_Pool.size() - 1);
                o_ArtNet_Op_ArtAddress.refresh();
            } else {
                o_ArtNet_Op_ArtAddress = new ArtNet_Op_ArtAddress();
            }
        }
        return o_ArtNet_Op_ArtAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtNet_Op_ArtAddress getFromPool(ArtNet_Header p_ArtNet_Header, ArtNetData_Bytes p_ArtNetData_Bytes) {
        ArtNet_Op_ArtAddress o_ArtNet_Op_ArtAddress;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_Pool.size() > 0) {
                o_ArtNet_Op_ArtAddress = s_Pool.get(s_Pool.size() - 1);
                s_Pool.remove(s_Pool.size() - 1);
                o_ArtNet_Op_ArtAddress.refresh(p_ArtNet_Header, p_ArtNetData_Bytes);
            } else {
                o_ArtNet_Op_ArtAddress = new ArtNet_Op_ArtAddress(p_ArtNet_Header, p_ArtNetData_Bytes);
            }
        }
        return o_ArtNet_Op_ArtAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToPool(ArtNet_Op_ArtAddress p_ArtNet_Op_ArtAddress) {
        if (p_ArtNet_Op_ArtAddress == null) {
            return;
        }
        Object object = s_SyncPool;
        synchronized (object) {
            s_Pool.add(p_ArtNet_Op_ArtAddress);
        }
    }

    private void initMembers() {
        this.m_ProtocolRevision_Low = (byte)14;
        this.m_ProtocolRevision_High = 0;
        this.m_NetSwitch = 0;
        this.m_BindIndex = 1;
        this.m_Name = "";
        this.m_LongName = "";
        if (this.m_SWIns == null) {
            this.m_SWIns = new byte[4];
        }
        if (this.m_SWOuts == null) {
            this.m_SWOuts = new byte[4];
        }
        for (int intByte = 0; intByte < 4; ++intByte) {
            this.m_SWIns[intByte] = 0;
            this.m_SWOuts[intByte] = 0;
        }
        this.m_SubSwitch = 0;
        this.m_SWVideo = 0;
        this.m_Command = 0;
    }

    @Override
    public void close() {
        if (this.m_Closed) {
            return;
        }
        super.close();
        ArtNet_Op_ArtAddress.addToPool(this);
    }

    public byte getProtocolRevisionHigh() {
        return this.m_ProtocolRevision_High;
    }

    public byte getProtocolRevisionLow() {
        return this.m_ProtocolRevision_Low;
    }

    public int getProtocolRevision() {
        int intRevicion = 0;
        intRevicion += this.m_ProtocolRevision_High;
        return intRevicion <<= 8;
    }

    public void setNetSwitch(byte p_NetSwitch) {
        if (this.m_NetSwitch == p_NetSwitch) {
            return;
        }
        this.m_NetSwitch = p_NetSwitch;
        this.m_Changed = true;
    }

    public byte getNetSwitch() {
        return this.m_NetSwitch;
    }

    public void setBindIndex(byte p_BindIndex) {
        if (this.m_BindIndex == p_BindIndex) {
            return;
        }
        this.m_BindIndex = p_BindIndex;
        this.m_Changed = true;
    }

    public byte getBindIndex() {
        return this.m_BindIndex;
    }

    public void setName(String p_Name) {
        if (p_Name == null || p_Name.length() <= 0) {
            p_Name = "?";
        }
        if (p_Name.length() > 17) {
            p_Name = p_Name.substring(0, 17);
        }
        if (p_Name.equals(this.m_Name)) {
            return;
        }
        this.m_Name = p_Name;
        this.m_Changed = true;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setLongName(String p_LongName) {
        if (p_LongName == null || p_LongName.length() <= 0) {
            p_LongName = "?";
        }
        if (p_LongName.length() > 63) {
            p_LongName = p_LongName.substring(0, 63);
        }
        if (p_LongName.equals(this.m_LongName)) {
            return;
        }
        this.m_LongName = p_LongName;
        this.m_Changed = true;
    }

    public String getLongName() {
        return this.m_LongName;
    }

    public void setSWIn(int p_Index, byte p_SWIn) {
        if (p_Index < 0 || p_Index >= 4) {
            return;
        }
        if (this.m_SWIns[p_Index] == p_SWIn) {
            return;
        }
        this.m_SWIns[p_Index] = p_SWIn;
        this.m_Changed = true;
    }

    public byte getSWIn(int p_Index) {
        if (p_Index < 0 || p_Index >= 4) {
            return 0;
        }
        return this.m_SWIns[p_Index];
    }

    public void setSWOut(int p_Index, byte p_SWOut) {
        if (p_Index < 0 || p_Index >= 4) {
            return;
        }
        if (this.m_SWOuts[p_Index] == p_SWOut) {
            return;
        }
        this.m_SWOuts[p_Index] = p_SWOut;
        this.m_Changed = true;
    }

    public byte getSWOut(int p_Index) {
        if (p_Index < 0 || p_Index >= 4) {
            return 0;
        }
        return this.m_SWOuts[p_Index];
    }

    public void setSubSwitch(byte p_SubSwitch) {
        if (this.m_SubSwitch == p_SubSwitch) {
            return;
        }
        this.m_SubSwitch = p_SubSwitch;
        this.m_Changed = true;
    }

    public byte getSubSwitch() {
        return this.m_SubSwitch;
    }

    public void setSWVideo(byte p_SWVideo) {
        if (this.m_SWVideo == p_SWVideo) {
            return;
        }
        this.m_SWVideo = p_SWVideo;
        this.m_Changed = true;
    }

    public byte getSWVideo() {
        return this.m_SWVideo;
    }

    public void setCommand(byte p_Command) {
        if (this.m_Command == p_Command) {
            return;
        }
        this.m_Command = p_Command;
        this.m_Changed = true;
    }

    public byte getCommand() {
        return this.m_Command;
    }

    public ArtNet_Op_ArtAddress(ArtNet_Header p_ArtNet_Header, ArtNetData_Bytes p_ArtNetData_Bytes) {
        super(24576, p_ArtNetData_Bytes);
        this.initMembers();
        this.m_ArtNet_Header = p_ArtNet_Header;
        if (this.m_ArtNet_Header != null) {
            this.m_ArtNet_Header.setArtNet_Op(this);
        }
        this.m_Valid = this.received(p_ArtNetData_Bytes);
    }

    public void refresh(ArtNet_Header p_ArtNet_Header, ArtNetData_Bytes p_ArtNetData_Bytes) {
        super.refresh(24576, p_ArtNetData_Bytes);
        this.initMembers();
        this.m_ArtNet_Header = p_ArtNet_Header;
        if (this.m_ArtNet_Header != null) {
            this.m_ArtNet_Header.setArtNet_Op(this);
        }
        this.m_Valid = this.received(p_ArtNetData_Bytes);
    }

    public boolean received(ArtNetData_Bytes p_ArtNetData_Bytes) {
        if (p_ArtNetData_Bytes == null) {
            this.m_Valid = false;
            return false;
        }
        int intOffset = 10;
        try {
            this.m_ProtocolRevision_High = p_ArtNetData_Bytes.getByte(intOffset);
            this.m_ProtocolRevision_Low = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_NetSwitch = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_BindIndex = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_Name = p_ArtNetData_Bytes.getString(++intOffset, 18);
            this.m_LongName = p_ArtNetData_Bytes.getString(intOffset += 18, 64);
            p_ArtNetData_Bytes.getByteData(intOffset += 64, this.m_SWIns, 0, 4);
            p_ArtNetData_Bytes.getByteData(intOffset += 4, this.m_SWOuts, 0, 4);
            this.m_SubSwitch = p_ArtNetData_Bytes.getByte(intOffset += 4);
            this.m_SWVideo = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_Command = p_ArtNetData_Bytes.getByte(++intOffset);
            ++intOffset;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public ArtNet_Op_ArtAddress() {
        super(24576, 107);
        this.initMembers();
        this.m_ArtNet_Header = ArtNet_Header.getFromPool(this);
    }

    public void refresh() {
        super.refresh(24576, 107);
        this.initMembers();
        this.m_ArtNet_Header = ArtNet_Header.getFromPool(this);
    }

    @Override
    public byte[] getSendDataBytes() {
        ArtNetData_Bytes o_ArtNetData_Bytes = this.m_ArtNetData_Bytes;
        if (o_ArtNetData_Bytes == null) {
            this.m_Valid = false;
            return null;
        }
        if (this.m_Changed) {
            int intOffset = 10;
            try {
                intOffset += o_ArtNetData_Bytes.setByte(this.m_ProtocolRevision_High, intOffset);
                intOffset += o_ArtNetData_Bytes.setByte(this.m_ProtocolRevision_Low, intOffset);
                intOffset += o_ArtNetData_Bytes.setByte(this.m_NetSwitch, intOffset);
                intOffset += o_ArtNetData_Bytes.setByte(this.m_BindIndex, intOffset);
                intOffset += o_ArtNetData_Bytes.setString(this.m_Name, intOffset, 18);
                intOffset += o_ArtNetData_Bytes.setString(this.m_LongName, intOffset, 64);
                intOffset += o_ArtNetData_Bytes.setByteArray(this.m_SWIns, 0, intOffset, 4);
                intOffset += o_ArtNetData_Bytes.setByteArray(this.m_SWOuts, 0, intOffset, 4);
                intOffset += o_ArtNetData_Bytes.setByte(this.m_SubSwitch, intOffset);
                intOffset += o_ArtNetData_Bytes.setByte(this.m_SWVideo, intOffset);
                intOffset += o_ArtNetData_Bytes.setByte(this.m_Command, intOffset);
                this.m_Valid = true;
            }
            catch (Exception e) {
                this.m_Valid = false;
            }
            if (!this.m_Valid) {
                return null;
            }
            this.m_Changed = false;
        }
        return o_ArtNetData_Bytes.getData(this.m_Size);
    }
}

