/*
 * Decompiled with CFR 0.152.
 */
package ArtNetPackage;

import ArtNetPackage.ArtNetData_Bytes;
import ArtNetPackage.ArtNet_Header;

public abstract class ArtNet_Op {
    protected boolean m_Closed;
    protected ArtNet_Header m_ArtNet_Header;
    protected int m_OpCode;
    protected int m_Size;
    protected boolean m_Changed;
    protected boolean m_Valid;
    protected ArtNetData_Bytes m_ArtNetData_Bytes;

    public ArtNet_Op(int p_OpCode, ArtNetData_Bytes p_ArtNetData_Bytes) {
        this.initMembers();
        this.m_OpCode = p_OpCode;
        if (p_ArtNetData_Bytes == null) {
            this.m_Valid = false;
            this.m_Size = 0;
        } else {
            this.m_ArtNetData_Bytes = p_ArtNetData_Bytes;
            this.m_Size = p_ArtNetData_Bytes.getSize();
        }
    }

    public void refresh(int p_OpCode, ArtNetData_Bytes p_ArtNetData_Bytes) {
        this.initMembers();
        this.m_OpCode = p_OpCode;
        if (p_ArtNetData_Bytes == null) {
            this.m_Valid = false;
            this.m_Size = 0;
        } else {
            this.m_ArtNetData_Bytes = p_ArtNetData_Bytes;
            this.m_Size = p_ArtNetData_Bytes.getSize();
        }
    }

    public ArtNet_Op(int p_OpCode, int p_Size) {
        this.initMembers();
        this.m_OpCode = p_OpCode;
        this.m_Size = p_Size;
        this.m_ArtNetData_Bytes = ArtNetData_Bytes.getPoolArtNetData_Bytes(this.m_Size);
    }

    public void refresh(int p_OpCode, int p_Size) {
        this.initMembers();
        this.m_OpCode = p_OpCode;
        this.m_Size = p_Size;
        this.m_ArtNetData_Bytes = ArtNetData_Bytes.getPoolArtNetData_Bytes(this.m_Size);
    }

    public ArtNetData_Bytes getArtNetData_Bytes() {
        return this.m_ArtNetData_Bytes;
    }

    public abstract byte[] getSendDataBytes();

    private void initMembers() {
        this.m_Closed = false;
        this.m_Valid = false;
        this.m_Changed = true;
    }

    public void close() {
        if (this.m_Closed) {
            return;
        }
        this.m_Closed = true;
        if (this.m_ArtNet_Header != null) {
            this.m_ArtNet_Header.close();
            this.m_ArtNet_Header = null;
        }
        if (this.m_ArtNetData_Bytes != null) {
            this.m_ArtNetData_Bytes.close();
            this.m_ArtNetData_Bytes = null;
        }
    }

    public ArtNet_Header getArtNet_Header() {
        return this.m_ArtNet_Header;
    }

    public int getOpCode() {
        return this.m_OpCode;
    }

    public boolean getValid() {
        return this.m_Valid;
    }
}

