/*
 * Decompiled with CFR 0.152.
 */
package ArtNetPackage;

import ArtNetPackage.ArtNetData_Bytes;
import ArtNetPackage.ArtNet_Op;
import java.util.ArrayList;

public class ArtNet_Header {
    public static final int SIZE = 10;
    public static String s_ArtNetID = "Art-Net";
    public static final Object s_SyncPool = new Object();
    public static ArrayList<ArtNet_Header> s_Pool = new ArrayList();
    protected boolean m_Closed;
    protected int m_OpCode;
    protected ArtNet_Op m_ArtNet_Op;
    protected boolean m_Valid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtNet_Header getFromPool(ArtNet_Op p_ArtNet_Op) {
        ArtNet_Header o_ArtNet_Header;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_Pool.size() > 0) {
                o_ArtNet_Header = s_Pool.get(s_Pool.size() - 1);
                s_Pool.remove(s_Pool.size() - 1);
                o_ArtNet_Header.refresh(p_ArtNet_Op);
            } else {
                o_ArtNet_Header = new ArtNet_Header(p_ArtNet_Op);
            }
        }
        return o_ArtNet_Header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtNet_Header getFromPool(ArtNetData_Bytes p_ArtNetDataBytes) {
        ArtNet_Header o_ArtNet_Header;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_Pool.size() > 0) {
                o_ArtNet_Header = s_Pool.get(s_Pool.size() - 1);
                s_Pool.remove(s_Pool.size() - 1);
                o_ArtNet_Header.refresh(p_ArtNetDataBytes);
            } else {
                o_ArtNet_Header = new ArtNet_Header(p_ArtNetDataBytes);
            }
        }
        return o_ArtNet_Header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToPool(ArtNet_Header p_ArtNet_Header) {
        if (p_ArtNet_Header == null) {
            return;
        }
        Object object = s_SyncPool;
        synchronized (object) {
            s_Pool.add(p_ArtNet_Header);
        }
    }

    private void initMembers() {
        this.m_Closed = false;
        this.m_Valid = false;
        this.m_OpCode = 0;
        this.m_ArtNet_Op = null;
    }

    public ArtNet_Header(ArtNetData_Bytes p_ArtNetDataBytes) {
        this.initMembers();
        this.m_Valid = this.received(p_ArtNetDataBytes);
    }

    public void refresh(ArtNetData_Bytes p_ArtNetDataBytes) {
        this.initMembers();
        this.m_Valid = this.received(p_ArtNetDataBytes);
    }

    public void close() {
        if (this.m_Closed) {
            return;
        }
        this.m_Closed = true;
        ArtNet_Header.addToPool(this);
    }

    private boolean received(ArtNetData_Bytes p_ArtNetData_Bytes) {
        if (p_ArtNetData_Bytes == null || p_ArtNetData_Bytes.getSize() < 10) {
            return false;
        }
        int intOffset = 0;
        try {
            String stringArtNetID = p_ArtNetData_Bytes.getString(intOffset, 8);
            if (stringArtNetID == null || stringArtNetID.length() != s_ArtNetID.length() || !s_ArtNetID.equals(stringArtNetID)) {
                this.m_Valid = false;
                return this.m_Valid;
            }
            this.m_OpCode = p_ArtNetData_Bytes.getInt16(intOffset += 8);
            intOffset += 2;
            this.m_Valid = true;
        }
        catch (Exception e) {
            this.m_Valid = false;
            return this.m_Valid;
        }
        return this.m_Valid;
    }

    public boolean getValid() {
        return this.m_Valid;
    }

    public int getOpCode() {
        return this.m_OpCode;
    }

    public void setArtNet_Op(ArtNet_Op p_ArtNet_Op) {
        this.m_ArtNet_Op = p_ArtNet_Op;
    }

    public ArtNet_Op getArtNet_Op() {
        return this.m_ArtNet_Op;
    }

    public ArtNet_Header(ArtNet_Op p_ArtNet_Op) {
        this.initMembers();
        this.m_ArtNet_Op = p_ArtNet_Op;
        this.m_OpCode = p_ArtNet_Op.getOpCode();
        this.fillArtNetData_Bytes();
    }

    public void refresh(ArtNet_Op p_ArtNet_Op) {
        this.initMembers();
        this.m_ArtNet_Op = p_ArtNet_Op;
        this.m_OpCode = p_ArtNet_Op.getOpCode();
        this.fillArtNetData_Bytes();
    }

    public boolean fillArtNetData_Bytes() {
        if (this.m_ArtNet_Op == null) {
            return false;
        }
        int intOffset = 0;
        try {
            ArtNetData_Bytes o_ArtNetData_Bytes = this.m_ArtNet_Op.getArtNetData_Bytes();
            intOffset += o_ArtNetData_Bytes.setString(s_ArtNetID, intOffset, 8);
            intOffset += o_ArtNetData_Bytes.setInt16(this.m_OpCode, intOffset);
            this.m_Valid = true;
        }
        catch (Exception e) {
            this.m_Valid = false;
        }
        return this.m_Valid;
    }
}

