/*
 * Decompiled with CFR 0.152.
 */
package ACN_1_31_Package;

import ACN_1_17_Package.ACNDataAbstract;
import ACN_1_17_Package.ACNData_Interface;
import ACN_1_17_Package.ACNLayerAbstract;
import ACN_1_17_Package.ACNLayer_Interface;
import ACN_1_17_Package.ACN_ByteData;
import ACN_1_17_Package.ACN_PDU;
import ACN_1_31_Package.ACN_1_31_DMPLayer;

public class ACN_1_31_FrameLayer
extends ACNLayerAbstract {
    public static int PDUVECTORSIZE = 4;
    public static int PDUHEADERLENGTHSIZE = 0;
    public static int PDUHEADERSIZE = 64;
    public static ACN_1_31_FrameLayer m_SelfReference = new ACN_1_31_FrameLayer();

    public static ACN_1_31_FrameLayer getInstance() {
        return m_SelfReference;
    }

    public ACN_1_31_FrameLayer() {
        this.initMembers();
    }

    private void initMembers() {
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public int getACN_Vector_Size() {
        return PDUVECTORSIZE;
    }

    @Override
    public int getACN_PDU_HeaderSize() {
        return PDUHEADERSIZE;
    }

    @Override
    public int getACN_PDU_HeaderLengthBytesCount() {
        return PDUHEADERLENGTHSIZE;
    }

    @Override
    public ACNData_Interface createACNData(ACN_PDU p_ACN_PDU) {
        if (p_ACN_PDU == null) {
            return null;
        }
        ACN_1_31_Frame o_ACNData_Interface = null;
        ACN_PDU.PDU_Vector o_PDU_Vector = p_ACN_PDU.getPDU_Vector();
        if (o_PDU_Vector == null) {
            return o_ACNData_Interface;
        }
        switch (o_PDU_Vector.getVectorValue()) {
            case 2: {
                o_ACNData_Interface = new ACN_1_31_Frame(p_ACN_PDU.getParentACNData(), p_ACN_PDU);
                break;
            }
            default: {
                o_ACNData_Interface = null;
            }
        }
        return o_ACNData_Interface;
    }

    public static class ACN_1_31_Frame
    extends ACNDataAbstract {
        protected ACN_ByteData m_Priority;
        protected ACN_ByteData m_Reserved;
        protected ACN_ByteData m_SequenceNumber;
        protected ACN_ByteData m_OptionsFlag;
        protected ACN_ByteData m_UniverseNumber;

        public ACN_1_31_Frame() {
            super(null, ACN_1_31_FrameLayer.getInstance(), null);
            this.initMembers();
            this.initMembersFurther();
        }

        public ACN_1_31_Frame(ACNData_Interface p_ParentACNData, ACN_PDU p_ACN_PDU) {
            super(p_ParentACNData, ACN_1_31_FrameLayer.getInstance(), p_ACN_PDU);
            this.initMembers();
            this.initMembersFurther();
        }

        private void initMembers() {
            this.m_Priority = ACN_ByteData.poolGet(1);
            this.addDataACN_Member(this.m_Priority);
            this.m_Reserved = ACN_ByteData.poolGet(2);
            this.addDataACN_Member(this.m_Reserved);
            this.m_SequenceNumber = ACN_ByteData.poolGet(1);
            this.addDataACN_Member(this.m_SequenceNumber);
            this.m_OptionsFlag = ACN_ByteData.poolGet(1);
            this.addDataACN_Member(this.m_OptionsFlag);
            this.m_UniverseNumber = ACN_ByteData.poolGet(2);
            this.addDataACN_Member(this.m_UniverseNumber);
        }

        private void initMembersFurther() {
            this.m_ACN_PDU.getPDU_Vector().setInt(2);
            this.m_ACN_PDU.getPDU_Header().getHeaderContent().setString("LiveShow");
            this.m_Priority.setInt(100);
            this.m_Reserved.setInt(0);
            this.m_SequenceNumber.setInt(0);
            this.m_OptionsFlag.setByte(0, (byte)0);
            this.m_UniverseNumber.setInt(0);
        }

        @Override
        public void close() {
            super.close();
        }

        public String getSourceName() {
            if (this.m_ACN_PDU.getPDU_Vector().isReceived()) {
                return this.m_ACN_PDU.getPDU_Header().getHeaderContent().getString();
            }
            return "";
        }

        public void setPriority(int p_Priority) {
            this.m_Priority.setInt(p_Priority);
        }

        public int getPriority() {
            return this.m_Priority.getInt();
        }

        public void setSequenceNumber(int p_SequenceNumber) {
            this.m_SequenceNumber.setInt(p_SequenceNumber);
        }

        public int getSequenceNumber() {
            return this.m_SequenceNumber.getInt();
        }

        public void setUniverseNumber(int p_UniversNumber) {
            this.m_UniverseNumber.setInt(p_UniversNumber);
        }

        public int getUniverseNumber() {
            return this.m_UniverseNumber.getInt();
        }

        @Override
        public ACNLayer_Interface createNextACNLayer(ACN_PDU.PDU_Vector p_PDU_Vector, ACN_PDU.PDU_Header p_PDU_Header) {
            ACN_1_31_DMPLayer o_ACNLayer_Interface;
            int intVectorValue = p_PDU_Vector.getVectorValue();
            switch (intVectorValue) {
                case 2: {
                    o_ACNLayer_Interface = ACN_1_31_DMPLayer.getInstance();
                    break;
                }
                default: {
                    o_ACNLayer_Interface = null;
                }
            }
            return o_ACNLayer_Interface;
        }

        @Override
        public void eventDataMemberReceived(ACNData_Interface p_ACNData_Interface, ACN_ByteData p_ACN_ByteData) {
        }

        @Override
        public void eventDataMemberFilled(ACNData_Interface p_ACNData_Interface, ACN_ByteData p_ACN_ByteData) {
        }

        @Override
        public void eventDataMemberChanged(ACNData_Interface p_ACNData_Interface, ACN_ByteData p_ACN_ByteData) {
        }

        @Override
        public void eventDataReceived(ACNData_Interface p_ACNData_Interface) {
        }

        @Override
        public void eventDataFilled(ACNData_Interface p_ACNData_Interface) {
        }
    }
}

